# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouterNatAddressArgs', 'RouterNatAddress']

@pulumi.input_type
class RouterNatAddressArgs:
    def __init__(__self__, *,
                 nat_ips: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 router: pulumi.Input[_builtins.str],
                 router_nat: pulumi.Input[_builtins.str],
                 drain_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RouterNatAddress resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nat_ips: Self-links of NAT IPs to be used in a Nat service. Only valid if the referenced RouterNat
               natIpAllocateOption is set to MANUAL_ONLY.
        :param pulumi.Input[_builtins.str] router: The name of the Cloud Router in which the referenced NAT service is configured.
        :param pulumi.Input[_builtins.str] router_nat: The name of the Nat service in which this address will be configured.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] drain_nat_ips: A list of URLs of the IP resources to be drained. These IPs must be
               valid static external IPs that have been assigned to the NAT.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Region where the NAT service reside.
        """
        pulumi.set(__self__, "nat_ips", nat_ips)
        pulumi.set(__self__, "router", router)
        pulumi.set(__self__, "router_nat", router_nat)
        if drain_nat_ips is not None:
            pulumi.set(__self__, "drain_nat_ips", drain_nat_ips)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="natIps")
    def nat_ips(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Self-links of NAT IPs to be used in a Nat service. Only valid if the referenced RouterNat
        natIpAllocateOption is set to MANUAL_ONLY.
        """
        return pulumi.get(self, "nat_ips")

    @nat_ips.setter
    def nat_ips(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "nat_ips", value)

    @_builtins.property
    @pulumi.getter
    def router(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Cloud Router in which the referenced NAT service is configured.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "router", value)

    @_builtins.property
    @pulumi.getter(name="routerNat")
    def router_nat(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Nat service in which this address will be configured.
        """
        return pulumi.get(self, "router_nat")

    @router_nat.setter
    def router_nat(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "router_nat", value)

    @_builtins.property
    @pulumi.getter(name="drainNatIps")
    def drain_nat_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of URLs of the IP resources to be drained. These IPs must be
        valid static external IPs that have been assigned to the NAT.
        """
        return pulumi.get(self, "drain_nat_ips")

    @drain_nat_ips.setter
    def drain_nat_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "drain_nat_ips", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where the NAT service reside.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _RouterNatAddressState:
    def __init__(__self__, *,
                 drain_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 router: Optional[pulumi.Input[_builtins.str]] = None,
                 router_nat: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RouterNatAddress resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] drain_nat_ips: A list of URLs of the IP resources to be drained. These IPs must be
               valid static external IPs that have been assigned to the NAT.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nat_ips: Self-links of NAT IPs to be used in a Nat service. Only valid if the referenced RouterNat
               natIpAllocateOption is set to MANUAL_ONLY.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Region where the NAT service reside.
        :param pulumi.Input[_builtins.str] router: The name of the Cloud Router in which the referenced NAT service is configured.
        :param pulumi.Input[_builtins.str] router_nat: The name of the Nat service in which this address will be configured.
        """
        if drain_nat_ips is not None:
            pulumi.set(__self__, "drain_nat_ips", drain_nat_ips)
        if nat_ips is not None:
            pulumi.set(__self__, "nat_ips", nat_ips)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if router is not None:
            pulumi.set(__self__, "router", router)
        if router_nat is not None:
            pulumi.set(__self__, "router_nat", router_nat)

    @_builtins.property
    @pulumi.getter(name="drainNatIps")
    def drain_nat_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of URLs of the IP resources to be drained. These IPs must be
        valid static external IPs that have been assigned to the NAT.
        """
        return pulumi.get(self, "drain_nat_ips")

    @drain_nat_ips.setter
    def drain_nat_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "drain_nat_ips", value)

    @_builtins.property
    @pulumi.getter(name="natIps")
    def nat_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Self-links of NAT IPs to be used in a Nat service. Only valid if the referenced RouterNat
        natIpAllocateOption is set to MANUAL_ONLY.
        """
        return pulumi.get(self, "nat_ips")

    @nat_ips.setter
    def nat_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nat_ips", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where the NAT service reside.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def router(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cloud Router in which the referenced NAT service is configured.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "router", value)

    @_builtins.property
    @pulumi.getter(name="routerNat")
    def router_nat(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Nat service in which this address will be configured.
        """
        return pulumi.get(self, "router_nat")

    @router_nat.setter
    def router_nat(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "router_nat", value)


@pulumi.type_token("gcp:compute/routerNatAddress:RouterNatAddress")
class RouterNatAddress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 drain_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 router: Optional[pulumi.Input[_builtins.str]] = None,
                 router_nat: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A resource used to set the list of IP addresses to be used in a NAT service and manage the draining of destroyed IPs.

        > **Note:** This resource is to be used alongside a `compute.RouterNat` resource,
        the router nat resource must have no defined `nat_ips` or `drain_nat_ips` parameters,
        instead using the `initial_nat_ips` parameter to set at least one IP for the creation of the resource.

        To get more information about RouterNatAddress, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/routers)
        * How-to Guides
            * [Google Cloud Router](https://cloud.google.com/router/docs/)

        ## Example Usage

        ## Import

        RouterNatAddress can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/routers/{{router}}/{{router_nat}}`

        * `{{project}}/{{region}}/{{router}}/{{router_nat}}`

        * `{{region}}/{{router}}/{{router_nat}}`

        * `{{router}}/{{router_nat}}`

        When using the `pulumi import` command, RouterNatAddress can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/routerNatAddress:RouterNatAddress default projects/{{project}}/regions/{{region}}/routers/{{router}}/{{router_nat}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerNatAddress:RouterNatAddress default {{project}}/{{region}}/{{router}}/{{router_nat}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerNatAddress:RouterNatAddress default {{region}}/{{router}}/{{router_nat}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerNatAddress:RouterNatAddress default {{router}}/{{router_nat}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] drain_nat_ips: A list of URLs of the IP resources to be drained. These IPs must be
               valid static external IPs that have been assigned to the NAT.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nat_ips: Self-links of NAT IPs to be used in a Nat service. Only valid if the referenced RouterNat
               natIpAllocateOption is set to MANUAL_ONLY.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Region where the NAT service reside.
        :param pulumi.Input[_builtins.str] router: The name of the Cloud Router in which the referenced NAT service is configured.
        :param pulumi.Input[_builtins.str] router_nat: The name of the Nat service in which this address will be configured.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouterNatAddressArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A resource used to set the list of IP addresses to be used in a NAT service and manage the draining of destroyed IPs.

        > **Note:** This resource is to be used alongside a `compute.RouterNat` resource,
        the router nat resource must have no defined `nat_ips` or `drain_nat_ips` parameters,
        instead using the `initial_nat_ips` parameter to set at least one IP for the creation of the resource.

        To get more information about RouterNatAddress, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/routers)
        * How-to Guides
            * [Google Cloud Router](https://cloud.google.com/router/docs/)

        ## Example Usage

        ## Import

        RouterNatAddress can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/routers/{{router}}/{{router_nat}}`

        * `{{project}}/{{region}}/{{router}}/{{router_nat}}`

        * `{{region}}/{{router}}/{{router_nat}}`

        * `{{router}}/{{router_nat}}`

        When using the `pulumi import` command, RouterNatAddress can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/routerNatAddress:RouterNatAddress default projects/{{project}}/regions/{{region}}/routers/{{router}}/{{router_nat}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerNatAddress:RouterNatAddress default {{project}}/{{region}}/{{router}}/{{router_nat}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerNatAddress:RouterNatAddress default {{region}}/{{router}}/{{router_nat}}
        ```

        ```sh
        $ pulumi import gcp:compute/routerNatAddress:RouterNatAddress default {{router}}/{{router_nat}}
        ```

        :param str resource_name: The name of the resource.
        :param RouterNatAddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouterNatAddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 drain_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 router: Optional[pulumi.Input[_builtins.str]] = None,
                 router_nat: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouterNatAddressArgs.__new__(RouterNatAddressArgs)

            __props__.__dict__["drain_nat_ips"] = drain_nat_ips
            if nat_ips is None and not opts.urn:
                raise TypeError("Missing required property 'nat_ips'")
            __props__.__dict__["nat_ips"] = nat_ips
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            if router is None and not opts.urn:
                raise TypeError("Missing required property 'router'")
            __props__.__dict__["router"] = router
            if router_nat is None and not opts.urn:
                raise TypeError("Missing required property 'router_nat'")
            __props__.__dict__["router_nat"] = router_nat
        super(RouterNatAddress, __self__).__init__(
            'gcp:compute/routerNatAddress:RouterNatAddress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            drain_nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            nat_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            router: Optional[pulumi.Input[_builtins.str]] = None,
            router_nat: Optional[pulumi.Input[_builtins.str]] = None) -> 'RouterNatAddress':
        """
        Get an existing RouterNatAddress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] drain_nat_ips: A list of URLs of the IP resources to be drained. These IPs must be
               valid static external IPs that have been assigned to the NAT.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nat_ips: Self-links of NAT IPs to be used in a Nat service. Only valid if the referenced RouterNat
               natIpAllocateOption is set to MANUAL_ONLY.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: Region where the NAT service reside.
        :param pulumi.Input[_builtins.str] router: The name of the Cloud Router in which the referenced NAT service is configured.
        :param pulumi.Input[_builtins.str] router_nat: The name of the Nat service in which this address will be configured.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouterNatAddressState.__new__(_RouterNatAddressState)

        __props__.__dict__["drain_nat_ips"] = drain_nat_ips
        __props__.__dict__["nat_ips"] = nat_ips
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["router"] = router
        __props__.__dict__["router_nat"] = router_nat
        return RouterNatAddress(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="drainNatIps")
    def drain_nat_ips(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of URLs of the IP resources to be drained. These IPs must be
        valid static external IPs that have been assigned to the NAT.
        """
        return pulumi.get(self, "drain_nat_ips")

    @_builtins.property
    @pulumi.getter(name="natIps")
    def nat_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Self-links of NAT IPs to be used in a Nat service. Only valid if the referenced RouterNat
        natIpAllocateOption is set to MANUAL_ONLY.
        """
        return pulumi.get(self, "nat_ips")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where the NAT service reside.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def router(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Cloud Router in which the referenced NAT service is configured.
        """
        return pulumi.get(self, "router")

    @_builtins.property
    @pulumi.getter(name="routerNat")
    def router_nat(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Nat service in which this address will be configured.
        """
        return pulumi.get(self, "router_nat")

