# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WireGroupArgs', 'WireGroup']

@pulumi.input_type
class WireGroupArgs:
    def __init__(__self__, *,
                 cross_site_network: pulumi.Input[_builtins.str],
                 admin_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['WireGroupEndpointArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 wire_group_properties: Optional[pulumi.Input['WireGroupWireGroupPropertiesArgs']] = None,
                 wire_properties: Optional[pulumi.Input['WireGroupWirePropertiesArgs']] = None):
        """
        The set of arguments for constructing a WireGroup resource.
        :param pulumi.Input[_builtins.str] cross_site_network: Required cross site network to which wire group belongs.
        :param pulumi.Input[_builtins.bool] admin_enabled: Indicates whether the wire group is administratively enabled.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Sequence[pulumi.Input['WireGroupEndpointArgs']]] endpoints: Endpoints grouped by location, each mapping to interconnect configurations.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is created. The name must be
               1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['WireGroupWireGroupPropertiesArgs'] wire_group_properties: Properties specific to the wire group.
               Structure is documented below.
        :param pulumi.Input['WireGroupWirePropertiesArgs'] wire_properties: Default properties for wires within the group.
               Structure is documented below.
        """
        pulumi.set(__self__, "cross_site_network", cross_site_network)
        if admin_enabled is not None:
            pulumi.set(__self__, "admin_enabled", admin_enabled)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if wire_group_properties is not None:
            pulumi.set(__self__, "wire_group_properties", wire_group_properties)
        if wire_properties is not None:
            pulumi.set(__self__, "wire_properties", wire_properties)

    @_builtins.property
    @pulumi.getter(name="crossSiteNetwork")
    def cross_site_network(self) -> pulumi.Input[_builtins.str]:
        """
        Required cross site network to which wire group belongs.
        """
        return pulumi.get(self, "cross_site_network")

    @cross_site_network.setter
    def cross_site_network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cross_site_network", value)

    @_builtins.property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the wire group is administratively enabled.
        """
        return pulumi.get(self, "admin_enabled")

    @admin_enabled.setter
    def admin_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "admin_enabled", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WireGroupEndpointArgs']]]]:
        """
        Endpoints grouped by location, each mapping to interconnect configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WireGroupEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be
        1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must be a dash,
        lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="wireGroupProperties")
    def wire_group_properties(self) -> Optional[pulumi.Input['WireGroupWireGroupPropertiesArgs']]:
        """
        Properties specific to the wire group.
        Structure is documented below.
        """
        return pulumi.get(self, "wire_group_properties")

    @wire_group_properties.setter
    def wire_group_properties(self, value: Optional[pulumi.Input['WireGroupWireGroupPropertiesArgs']]):
        pulumi.set(self, "wire_group_properties", value)

    @_builtins.property
    @pulumi.getter(name="wireProperties")
    def wire_properties(self) -> Optional[pulumi.Input['WireGroupWirePropertiesArgs']]:
        """
        Default properties for wires within the group.
        Structure is documented below.
        """
        return pulumi.get(self, "wire_properties")

    @wire_properties.setter
    def wire_properties(self, value: Optional[pulumi.Input['WireGroupWirePropertiesArgs']]):
        pulumi.set(self, "wire_properties", value)


@pulumi.input_type
class _WireGroupState:
    def __init__(__self__, *,
                 admin_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_site_network: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['WireGroupEndpointArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 topologies: Optional[pulumi.Input[Sequence[pulumi.Input['WireGroupTopologyArgs']]]] = None,
                 wire_group_properties: Optional[pulumi.Input['WireGroupWireGroupPropertiesArgs']] = None,
                 wire_properties: Optional[pulumi.Input['WireGroupWirePropertiesArgs']] = None,
                 wires: Optional[pulumi.Input[Sequence[pulumi.Input['WireGroupWireArgs']]]] = None):
        """
        Input properties used for looking up and filtering WireGroup resources.
        :param pulumi.Input[_builtins.bool] admin_enabled: Indicates whether the wire group is administratively enabled.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] cross_site_network: Required cross site network to which wire group belongs.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Sequence[pulumi.Input['WireGroupEndpointArgs']]] endpoints: Endpoints grouped by location, each mapping to interconnect configurations.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is created. The name must be
               1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['WireGroupTopologyArgs']]] topologies: Topology details for the wire group configuration.
               Structure is documented below.
        :param pulumi.Input['WireGroupWireGroupPropertiesArgs'] wire_group_properties: Properties specific to the wire group.
               Structure is documented below.
        :param pulumi.Input['WireGroupWirePropertiesArgs'] wire_properties: Default properties for wires within the group.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['WireGroupWireArgs']]] wires: The single/redundant wire(s) managed by the wire group.
               Structure is documented below.
        """
        if admin_enabled is not None:
            pulumi.set(__self__, "admin_enabled", admin_enabled)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if cross_site_network is not None:
            pulumi.set(__self__, "cross_site_network", cross_site_network)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if topologies is not None:
            pulumi.set(__self__, "topologies", topologies)
        if wire_group_properties is not None:
            pulumi.set(__self__, "wire_group_properties", wire_group_properties)
        if wire_properties is not None:
            pulumi.set(__self__, "wire_properties", wire_properties)
        if wires is not None:
            pulumi.set(__self__, "wires", wires)

    @_builtins.property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the wire group is administratively enabled.
        """
        return pulumi.get(self, "admin_enabled")

    @admin_enabled.setter
    def admin_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "admin_enabled", value)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="crossSiteNetwork")
    def cross_site_network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required cross site network to which wire group belongs.
        """
        return pulumi.get(self, "cross_site_network")

    @cross_site_network.setter
    def cross_site_network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_site_network", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WireGroupEndpointArgs']]]]:
        """
        Endpoints grouped by location, each mapping to interconnect configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WireGroupEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be
        1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must be a dash,
        lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def topologies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WireGroupTopologyArgs']]]]:
        """
        Topology details for the wire group configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "topologies")

    @topologies.setter
    def topologies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WireGroupTopologyArgs']]]]):
        pulumi.set(self, "topologies", value)

    @_builtins.property
    @pulumi.getter(name="wireGroupProperties")
    def wire_group_properties(self) -> Optional[pulumi.Input['WireGroupWireGroupPropertiesArgs']]:
        """
        Properties specific to the wire group.
        Structure is documented below.
        """
        return pulumi.get(self, "wire_group_properties")

    @wire_group_properties.setter
    def wire_group_properties(self, value: Optional[pulumi.Input['WireGroupWireGroupPropertiesArgs']]):
        pulumi.set(self, "wire_group_properties", value)

    @_builtins.property
    @pulumi.getter(name="wireProperties")
    def wire_properties(self) -> Optional[pulumi.Input['WireGroupWirePropertiesArgs']]:
        """
        Default properties for wires within the group.
        Structure is documented below.
        """
        return pulumi.get(self, "wire_properties")

    @wire_properties.setter
    def wire_properties(self, value: Optional[pulumi.Input['WireGroupWirePropertiesArgs']]):
        pulumi.set(self, "wire_properties", value)

    @_builtins.property
    @pulumi.getter
    def wires(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WireGroupWireArgs']]]]:
        """
        The single/redundant wire(s) managed by the wire group.
        Structure is documented below.
        """
        return pulumi.get(self, "wires")

    @wires.setter
    def wires(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WireGroupWireArgs']]]]):
        pulumi.set(self, "wires", value)


@pulumi.type_token("gcp:compute/wireGroup:WireGroup")
class WireGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cross_site_network: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WireGroupEndpointArgs', 'WireGroupEndpointArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 wire_group_properties: Optional[pulumi.Input[Union['WireGroupWireGroupPropertiesArgs', 'WireGroupWireGroupPropertiesArgsDict']]] = None,
                 wire_properties: Optional[pulumi.Input[Union['WireGroupWirePropertiesArgs', 'WireGroupWirePropertiesArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Compute Wire Group Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example_cross_site_network = gcp.compute.CrossSiteNetwork("example-cross-site-network",
            name="test-cross-site-network",
            description="Example cross site network")
        example_test_wire_group = gcp.compute.WireGroup("example-test-wire-group",
            name="test-wire-group",
            description="Example Wire Group",
            cross_site_network="test-cross-site-network",
            wire_properties={
                "bandwidth_unmetered": 10,
                "fault_response": "NONE",
            },
            wire_group_properties={
                "type": "WIRE",
            },
            admin_enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[example_cross_site_network]))
        ```

        ## Import

        WireGroup can be imported using any of these accepted formats:

        * `projects/{{project}}/global/crossSiteNetworks/{{cross_site_network}}/wireGroups/{{name}}`

        * `{{project}}/{{cross_site_network}}/{{name}}`

        * `{{cross_site_network}}/{{name}}`

        When using the `pulumi import` command, WireGroup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/wireGroup:WireGroup default projects/{{project}}/global/crossSiteNetworks/{{cross_site_network}}/wireGroups/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/wireGroup:WireGroup default {{project}}/{{cross_site_network}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/wireGroup:WireGroup default {{cross_site_network}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] admin_enabled: Indicates whether the wire group is administratively enabled.
        :param pulumi.Input[_builtins.str] cross_site_network: Required cross site network to which wire group belongs.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WireGroupEndpointArgs', 'WireGroupEndpointArgsDict']]]] endpoints: Endpoints grouped by location, each mapping to interconnect configurations.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is created. The name must be
               1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['WireGroupWireGroupPropertiesArgs', 'WireGroupWireGroupPropertiesArgsDict']] wire_group_properties: Properties specific to the wire group.
               Structure is documented below.
        :param pulumi.Input[Union['WireGroupWirePropertiesArgs', 'WireGroupWirePropertiesArgsDict']] wire_properties: Default properties for wires within the group.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WireGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Compute Wire Group Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example_cross_site_network = gcp.compute.CrossSiteNetwork("example-cross-site-network",
            name="test-cross-site-network",
            description="Example cross site network")
        example_test_wire_group = gcp.compute.WireGroup("example-test-wire-group",
            name="test-wire-group",
            description="Example Wire Group",
            cross_site_network="test-cross-site-network",
            wire_properties={
                "bandwidth_unmetered": 10,
                "fault_response": "NONE",
            },
            wire_group_properties={
                "type": "WIRE",
            },
            admin_enabled=True,
            opts = pulumi.ResourceOptions(depends_on=[example_cross_site_network]))
        ```

        ## Import

        WireGroup can be imported using any of these accepted formats:

        * `projects/{{project}}/global/crossSiteNetworks/{{cross_site_network}}/wireGroups/{{name}}`

        * `{{project}}/{{cross_site_network}}/{{name}}`

        * `{{cross_site_network}}/{{name}}`

        When using the `pulumi import` command, WireGroup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/wireGroup:WireGroup default projects/{{project}}/global/crossSiteNetworks/{{cross_site_network}}/wireGroups/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/wireGroup:WireGroup default {{project}}/{{cross_site_network}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/wireGroup:WireGroup default {{cross_site_network}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param WireGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WireGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cross_site_network: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WireGroupEndpointArgs', 'WireGroupEndpointArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 wire_group_properties: Optional[pulumi.Input[Union['WireGroupWireGroupPropertiesArgs', 'WireGroupWireGroupPropertiesArgsDict']]] = None,
                 wire_properties: Optional[pulumi.Input[Union['WireGroupWirePropertiesArgs', 'WireGroupWirePropertiesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WireGroupArgs.__new__(WireGroupArgs)

            __props__.__dict__["admin_enabled"] = admin_enabled
            if cross_site_network is None and not opts.urn:
                raise TypeError("Missing required property 'cross_site_network'")
            __props__.__dict__["cross_site_network"] = cross_site_network
            __props__.__dict__["description"] = description
            __props__.__dict__["endpoints"] = endpoints
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["wire_group_properties"] = wire_group_properties
            __props__.__dict__["wire_properties"] = wire_properties
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["topologies"] = None
            __props__.__dict__["wires"] = None
        super(WireGroup, __self__).__init__(
            'gcp:compute/wireGroup:WireGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            cross_site_network: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WireGroupEndpointArgs', 'WireGroupEndpointArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            topologies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WireGroupTopologyArgs', 'WireGroupTopologyArgsDict']]]]] = None,
            wire_group_properties: Optional[pulumi.Input[Union['WireGroupWireGroupPropertiesArgs', 'WireGroupWireGroupPropertiesArgsDict']]] = None,
            wire_properties: Optional[pulumi.Input[Union['WireGroupWirePropertiesArgs', 'WireGroupWirePropertiesArgsDict']]] = None,
            wires: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WireGroupWireArgs', 'WireGroupWireArgsDict']]]]] = None) -> 'WireGroup':
        """
        Get an existing WireGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] admin_enabled: Indicates whether the wire group is administratively enabled.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] cross_site_network: Required cross site network to which wire group belongs.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WireGroupEndpointArgs', 'WireGroupEndpointArgsDict']]]] endpoints: Endpoints grouped by location, each mapping to interconnect configurations.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is created. The name must be
               1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WireGroupTopologyArgs', 'WireGroupTopologyArgsDict']]]] topologies: Topology details for the wire group configuration.
               Structure is documented below.
        :param pulumi.Input[Union['WireGroupWireGroupPropertiesArgs', 'WireGroupWireGroupPropertiesArgsDict']] wire_group_properties: Properties specific to the wire group.
               Structure is documented below.
        :param pulumi.Input[Union['WireGroupWirePropertiesArgs', 'WireGroupWirePropertiesArgsDict']] wire_properties: Default properties for wires within the group.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WireGroupWireArgs', 'WireGroupWireArgsDict']]]] wires: The single/redundant wire(s) managed by the wire group.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WireGroupState.__new__(_WireGroupState)

        __props__.__dict__["admin_enabled"] = admin_enabled
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["cross_site_network"] = cross_site_network
        __props__.__dict__["description"] = description
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["topologies"] = topologies
        __props__.__dict__["wire_group_properties"] = wire_group_properties
        __props__.__dict__["wire_properties"] = wire_properties
        __props__.__dict__["wires"] = wires
        return WireGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the wire group is administratively enabled.
        """
        return pulumi.get(self, "admin_enabled")

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter(name="crossSiteNetwork")
    def cross_site_network(self) -> pulumi.Output[_builtins.str]:
        """
        Required cross site network to which wire group belongs.
        """
        return pulumi.get(self, "cross_site_network")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Optional[Sequence['outputs.WireGroupEndpoint']]]:
        """
        Endpoints grouped by location, each mapping to interconnect configurations.
        Structure is documented below.
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be
        1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must be a dash,
        lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def topologies(self) -> pulumi.Output[Sequence['outputs.WireGroupTopology']]:
        """
        Topology details for the wire group configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "topologies")

    @_builtins.property
    @pulumi.getter(name="wireGroupProperties")
    def wire_group_properties(self) -> pulumi.Output[Optional['outputs.WireGroupWireGroupProperties']]:
        """
        Properties specific to the wire group.
        Structure is documented below.
        """
        return pulumi.get(self, "wire_group_properties")

    @_builtins.property
    @pulumi.getter(name="wireProperties")
    def wire_properties(self) -> pulumi.Output[Optional['outputs.WireGroupWireProperties']]:
        """
        Default properties for wires within the group.
        Structure is documented below.
        """
        return pulumi.get(self, "wire_properties")

    @_builtins.property
    @pulumi.getter
    def wires(self) -> pulumi.Output[Sequence['outputs.WireGroupWire']]:
        """
        The single/redundant wire(s) managed by the wire group.
        Structure is documented below.
        """
        return pulumi.get(self, "wires")

