# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetEntryGroupIamPolicyResult',
    'AwaitableGetEntryGroupIamPolicyResult',
    'get_entry_group_iam_policy',
    'get_entry_group_iam_policy_output',
]

@pulumi.output_type
class GetEntryGroupIamPolicyResult:
    """
    A collection of values returned by getEntryGroupIamPolicy.
    """
    def __init__(__self__, entry_group=None, etag=None, id=None, policy_data=None, project=None, region=None):
        if entry_group and not isinstance(entry_group, str):
            raise TypeError("Expected argument 'entry_group' to be a str")
        pulumi.set(__self__, "entry_group", entry_group)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="entryGroup")
    def entry_group(self) -> _builtins.str:
        return pulumi.get(self, "entry_group")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> _builtins.str:
        """
        (Required only by `datacatalog.EntryGroupIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetEntryGroupIamPolicyResult(GetEntryGroupIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEntryGroupIamPolicyResult(
            entry_group=self.entry_group,
            etag=self.etag,
            id=self.id,
            policy_data=self.policy_data,
            project=self.project,
            region=self.region)


def get_entry_group_iam_policy(entry_group: Optional[_builtins.str] = None,
                               project: Optional[_builtins.str] = None,
                               region: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEntryGroupIamPolicyResult:
    """
    Retrieves the current IAM policy data for entrygroup

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.datacatalog.get_entry_group_iam_policy(entry_group=basic_entry_group["name"])
    ```


    :param _builtins.str entry_group: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param _builtins.str region: EntryGroup location region.
           Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no region is provided in the parent identifier and no
           region is specified, it is taken from the provider configuration.
    """
    __args__ = dict()
    __args__['entryGroup'] = entry_group
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:datacatalog/getEntryGroupIamPolicy:getEntryGroupIamPolicy', __args__, opts=opts, typ=GetEntryGroupIamPolicyResult).value

    return AwaitableGetEntryGroupIamPolicyResult(
        entry_group=pulumi.get(__ret__, 'entry_group'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'),
        region=pulumi.get(__ret__, 'region'))
def get_entry_group_iam_policy_output(entry_group: Optional[pulumi.Input[_builtins.str]] = None,
                                      project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEntryGroupIamPolicyResult]:
    """
    Retrieves the current IAM policy data for entrygroup

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.datacatalog.get_entry_group_iam_policy(entry_group=basic_entry_group["name"])
    ```


    :param _builtins.str entry_group: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param _builtins.str region: EntryGroup location region.
           Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no region is provided in the parent identifier and no
           region is specified, it is taken from the provider configuration.
    """
    __args__ = dict()
    __args__['entryGroup'] = entry_group
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:datacatalog/getEntryGroupIamPolicy:getEntryGroupIamPolicy', __args__, opts=opts, typ=GetEntryGroupIamPolicyResult)
    return __ret__.apply(lambda __response__: GetEntryGroupIamPolicyResult(
        entry_group=pulumi.get(__response__, 'entry_group'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project'),
        region=pulumi.get(__response__, 'region')))
