# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'RepositoryGitRemoteSettingsArgs',
    'RepositoryGitRemoteSettingsArgsDict',
    'RepositoryGitRemoteSettingsSshAuthenticationConfigArgs',
    'RepositoryGitRemoteSettingsSshAuthenticationConfigArgsDict',
    'RepositoryIamBindingConditionArgs',
    'RepositoryIamBindingConditionArgsDict',
    'RepositoryIamMemberConditionArgs',
    'RepositoryIamMemberConditionArgsDict',
    'RepositoryReleaseConfigCodeCompilationConfigArgs',
    'RepositoryReleaseConfigCodeCompilationConfigArgsDict',
    'RepositoryReleaseConfigRecentScheduledReleaseRecordArgs',
    'RepositoryReleaseConfigRecentScheduledReleaseRecordArgsDict',
    'RepositoryReleaseConfigRecentScheduledReleaseRecordErrorStatusArgs',
    'RepositoryReleaseConfigRecentScheduledReleaseRecordErrorStatusArgsDict',
    'RepositoryWorkflowConfigInvocationConfigArgs',
    'RepositoryWorkflowConfigInvocationConfigArgsDict',
    'RepositoryWorkflowConfigInvocationConfigIncludedTargetArgs',
    'RepositoryWorkflowConfigInvocationConfigIncludedTargetArgsDict',
    'RepositoryWorkflowConfigRecentScheduledExecutionRecordArgs',
    'RepositoryWorkflowConfigRecentScheduledExecutionRecordArgsDict',
    'RepositoryWorkflowConfigRecentScheduledExecutionRecordErrorStatusArgs',
    'RepositoryWorkflowConfigRecentScheduledExecutionRecordErrorStatusArgsDict',
    'RepositoryWorkspaceCompilationOverridesArgs',
    'RepositoryWorkspaceCompilationOverridesArgsDict',
]

MYPY = False

if not MYPY:
    class RepositoryGitRemoteSettingsArgsDict(TypedDict):
        default_branch: pulumi.Input[_builtins.str]
        """
        The Git remote's default branch name.
        """
        url: pulumi.Input[_builtins.str]
        """
        The Git remote's URL.
        """
        authentication_token_secret_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the Secret Manager secret version to use as an authentication token for Git operations. This secret is for assigning with HTTPS only(for SSH use `ssh_authentication_config`). Must be in the format projects/*/secrets/*/versions/*.
        """
        ssh_authentication_config: NotRequired[pulumi.Input['RepositoryGitRemoteSettingsSshAuthenticationConfigArgsDict']]
        """
        Authentication fields for remote uris using SSH protocol.
        Structure is documented below.
        """
        token_status: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Indicates the status of the Git access token. https://cloud.google.com/dataform/reference/rest/v1beta1/projects.locations.repositories#TokenStatus
        """
elif False:
    RepositoryGitRemoteSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryGitRemoteSettingsArgs:
    def __init__(__self__, *,
                 default_branch: pulumi.Input[_builtins.str],
                 url: pulumi.Input[_builtins.str],
                 authentication_token_secret_version: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_authentication_config: Optional[pulumi.Input['RepositoryGitRemoteSettingsSshAuthenticationConfigArgs']] = None,
                 token_status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] default_branch: The Git remote's default branch name.
        :param pulumi.Input[_builtins.str] url: The Git remote's URL.
        :param pulumi.Input[_builtins.str] authentication_token_secret_version: The name of the Secret Manager secret version to use as an authentication token for Git operations. This secret is for assigning with HTTPS only(for SSH use `ssh_authentication_config`). Must be in the format projects/*/secrets/*/versions/*.
        :param pulumi.Input['RepositoryGitRemoteSettingsSshAuthenticationConfigArgs'] ssh_authentication_config: Authentication fields for remote uris using SSH protocol.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] token_status: (Output)
               Indicates the status of the Git access token. https://cloud.google.com/dataform/reference/rest/v1beta1/projects.locations.repositories#TokenStatus
        """
        pulumi.set(__self__, "default_branch", default_branch)
        pulumi.set(__self__, "url", url)
        if authentication_token_secret_version is not None:
            pulumi.set(__self__, "authentication_token_secret_version", authentication_token_secret_version)
        if ssh_authentication_config is not None:
            pulumi.set(__self__, "ssh_authentication_config", ssh_authentication_config)
        if token_status is not None:
            pulumi.set(__self__, "token_status", token_status)

    @_builtins.property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> pulumi.Input[_builtins.str]:
        """
        The Git remote's default branch name.
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_branch", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Input[_builtins.str]:
        """
        The Git remote's URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="authenticationTokenSecretVersion")
    def authentication_token_secret_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Secret Manager secret version to use as an authentication token for Git operations. This secret is for assigning with HTTPS only(for SSH use `ssh_authentication_config`). Must be in the format projects/*/secrets/*/versions/*.
        """
        return pulumi.get(self, "authentication_token_secret_version")

    @authentication_token_secret_version.setter
    def authentication_token_secret_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_token_secret_version", value)

    @_builtins.property
    @pulumi.getter(name="sshAuthenticationConfig")
    def ssh_authentication_config(self) -> Optional[pulumi.Input['RepositoryGitRemoteSettingsSshAuthenticationConfigArgs']]:
        """
        Authentication fields for remote uris using SSH protocol.
        Structure is documented below.
        """
        return pulumi.get(self, "ssh_authentication_config")

    @ssh_authentication_config.setter
    def ssh_authentication_config(self, value: Optional[pulumi.Input['RepositoryGitRemoteSettingsSshAuthenticationConfigArgs']]):
        pulumi.set(self, "ssh_authentication_config", value)

    @_builtins.property
    @pulumi.getter(name="tokenStatus")
    def token_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Indicates the status of the Git access token. https://cloud.google.com/dataform/reference/rest/v1beta1/projects.locations.repositories#TokenStatus
        """
        return pulumi.get(self, "token_status")

    @token_status.setter
    def token_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_status", value)


if not MYPY:
    class RepositoryGitRemoteSettingsSshAuthenticationConfigArgsDict(TypedDict):
        host_public_key: pulumi.Input[_builtins.str]
        """
        Content of a public SSH key to verify an identity of a remote Git host.
        """
        user_private_key_secret_version: pulumi.Input[_builtins.str]
        """
        The name of the Secret Manager secret version to use as a ssh private key for Git operations. Must be in the format projects/*/secrets/*/versions/*.
        """
elif False:
    RepositoryGitRemoteSettingsSshAuthenticationConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryGitRemoteSettingsSshAuthenticationConfigArgs:
    def __init__(__self__, *,
                 host_public_key: pulumi.Input[_builtins.str],
                 user_private_key_secret_version: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] host_public_key: Content of a public SSH key to verify an identity of a remote Git host.
        :param pulumi.Input[_builtins.str] user_private_key_secret_version: The name of the Secret Manager secret version to use as a ssh private key for Git operations. Must be in the format projects/*/secrets/*/versions/*.
        """
        pulumi.set(__self__, "host_public_key", host_public_key)
        pulumi.set(__self__, "user_private_key_secret_version", user_private_key_secret_version)

    @_builtins.property
    @pulumi.getter(name="hostPublicKey")
    def host_public_key(self) -> pulumi.Input[_builtins.str]:
        """
        Content of a public SSH key to verify an identity of a remote Git host.
        """
        return pulumi.get(self, "host_public_key")

    @host_public_key.setter
    def host_public_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host_public_key", value)

    @_builtins.property
    @pulumi.getter(name="userPrivateKeySecretVersion")
    def user_private_key_secret_version(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Secret Manager secret version to use as a ssh private key for Git operations. Must be in the format projects/*/secrets/*/versions/*.
        """
        return pulumi.get(self, "user_private_key_secret_version")

    @user_private_key_secret_version.setter
    def user_private_key_secret_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_private_key_secret_version", value)


if not MYPY:
    class RepositoryIamBindingConditionArgsDict(TypedDict):
        expression: pulumi.Input[_builtins.str]
        title: pulumi.Input[_builtins.str]
        description: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    RepositoryIamBindingConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryIamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[_builtins.str],
                 title: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class RepositoryIamMemberConditionArgsDict(TypedDict):
        expression: pulumi.Input[_builtins.str]
        title: pulumi.Input[_builtins.str]
        description: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    RepositoryIamMemberConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryIamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[_builtins.str],
                 title: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class RepositoryReleaseConfigCodeCompilationConfigArgsDict(TypedDict):
        assertion_schema: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The default schema (BigQuery dataset ID) for assertions.
        """
        database_suffix: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The suffix that should be appended to all database (Google Cloud project ID) names.
        """
        default_database: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The default database (Google Cloud project ID).
        """
        default_location: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The default BigQuery location to use. Defaults to "US".
        See the BigQuery docs for a full list of locations: https://cloud.google.com/bigquery/docs/locations.
        """
        default_schema: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The default schema (BigQuery dataset ID).
        """
        schema_suffix: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The suffix that should be appended to all schema (BigQuery dataset ID) names.
        """
        table_prefix: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The prefix that should be prepended to all table names.
        """
        vars: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Optional. User-defined variables that are made available to project code during compilation.
        An object containing a list of "key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
elif False:
    RepositoryReleaseConfigCodeCompilationConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryReleaseConfigCodeCompilationConfigArgs:
    def __init__(__self__, *,
                 assertion_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 database_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 default_database: Optional[pulumi.Input[_builtins.str]] = None,
                 default_location: Optional[pulumi.Input[_builtins.str]] = None,
                 default_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 table_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 vars: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] assertion_schema: Optional. The default schema (BigQuery dataset ID) for assertions.
        :param pulumi.Input[_builtins.str] database_suffix: Optional. The suffix that should be appended to all database (Google Cloud project ID) names.
        :param pulumi.Input[_builtins.str] default_database: Optional. The default database (Google Cloud project ID).
        :param pulumi.Input[_builtins.str] default_location: Optional. The default BigQuery location to use. Defaults to "US".
               See the BigQuery docs for a full list of locations: https://cloud.google.com/bigquery/docs/locations.
        :param pulumi.Input[_builtins.str] default_schema: Optional. The default schema (BigQuery dataset ID).
        :param pulumi.Input[_builtins.str] schema_suffix: Optional. The suffix that should be appended to all schema (BigQuery dataset ID) names.
        :param pulumi.Input[_builtins.str] table_prefix: Optional. The prefix that should be prepended to all table names.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] vars: Optional. User-defined variables that are made available to project code during compilation.
               An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        if assertion_schema is not None:
            pulumi.set(__self__, "assertion_schema", assertion_schema)
        if database_suffix is not None:
            pulumi.set(__self__, "database_suffix", database_suffix)
        if default_database is not None:
            pulumi.set(__self__, "default_database", default_database)
        if default_location is not None:
            pulumi.set(__self__, "default_location", default_location)
        if default_schema is not None:
            pulumi.set(__self__, "default_schema", default_schema)
        if schema_suffix is not None:
            pulumi.set(__self__, "schema_suffix", schema_suffix)
        if table_prefix is not None:
            pulumi.set(__self__, "table_prefix", table_prefix)
        if vars is not None:
            pulumi.set(__self__, "vars", vars)

    @_builtins.property
    @pulumi.getter(name="assertionSchema")
    def assertion_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The default schema (BigQuery dataset ID) for assertions.
        """
        return pulumi.get(self, "assertion_schema")

    @assertion_schema.setter
    def assertion_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assertion_schema", value)

    @_builtins.property
    @pulumi.getter(name="databaseSuffix")
    def database_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The suffix that should be appended to all database (Google Cloud project ID) names.
        """
        return pulumi.get(self, "database_suffix")

    @database_suffix.setter
    def database_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_suffix", value)

    @_builtins.property
    @pulumi.getter(name="defaultDatabase")
    def default_database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The default database (Google Cloud project ID).
        """
        return pulumi.get(self, "default_database")

    @default_database.setter
    def default_database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_database", value)

    @_builtins.property
    @pulumi.getter(name="defaultLocation")
    def default_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The default BigQuery location to use. Defaults to "US".
        See the BigQuery docs for a full list of locations: https://cloud.google.com/bigquery/docs/locations.
        """
        return pulumi.get(self, "default_location")

    @default_location.setter
    def default_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_location", value)

    @_builtins.property
    @pulumi.getter(name="defaultSchema")
    def default_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The default schema (BigQuery dataset ID).
        """
        return pulumi.get(self, "default_schema")

    @default_schema.setter
    def default_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_schema", value)

    @_builtins.property
    @pulumi.getter(name="schemaSuffix")
    def schema_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The suffix that should be appended to all schema (BigQuery dataset ID) names.
        """
        return pulumi.get(self, "schema_suffix")

    @schema_suffix.setter
    def schema_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_suffix", value)

    @_builtins.property
    @pulumi.getter(name="tablePrefix")
    def table_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The prefix that should be prepended to all table names.
        """
        return pulumi.get(self, "table_prefix")

    @table_prefix.setter
    def table_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_prefix", value)

    @_builtins.property
    @pulumi.getter
    def vars(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. User-defined variables that are made available to project code during compilation.
        An object containing a list of "key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "vars")

    @vars.setter
    def vars(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vars", value)


if not MYPY:
    class RepositoryReleaseConfigRecentScheduledReleaseRecordArgsDict(TypedDict):
        compilation_result: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        The name of the created compilation result, if one was successfully created. Must be in the format projects/*/locations/*/repositories/*/compilationResults/*.
        """
        error_statuses: NotRequired[pulumi.Input[Sequence[pulumi.Input['RepositoryReleaseConfigRecentScheduledReleaseRecordErrorStatusArgsDict']]]]
        """
        (Output)
        The error status encountered upon this attempt to create the compilation result, if the attempt was unsuccessful.
        Structure is documented below.
        """
        release_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        The timestamp of this release attempt.
        """
elif False:
    RepositoryReleaseConfigRecentScheduledReleaseRecordArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryReleaseConfigRecentScheduledReleaseRecordArgs:
    def __init__(__self__, *,
                 compilation_result: Optional[pulumi.Input[_builtins.str]] = None,
                 error_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryReleaseConfigRecentScheduledReleaseRecordErrorStatusArgs']]]] = None,
                 release_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] compilation_result: (Output)
               The name of the created compilation result, if one was successfully created. Must be in the format projects/*/locations/*/repositories/*/compilationResults/*.
        :param pulumi.Input[Sequence[pulumi.Input['RepositoryReleaseConfigRecentScheduledReleaseRecordErrorStatusArgs']]] error_statuses: (Output)
               The error status encountered upon this attempt to create the compilation result, if the attempt was unsuccessful.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] release_time: (Output)
               The timestamp of this release attempt.
        """
        if compilation_result is not None:
            pulumi.set(__self__, "compilation_result", compilation_result)
        if error_statuses is not None:
            pulumi.set(__self__, "error_statuses", error_statuses)
        if release_time is not None:
            pulumi.set(__self__, "release_time", release_time)

    @_builtins.property
    @pulumi.getter(name="compilationResult")
    def compilation_result(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        The name of the created compilation result, if one was successfully created. Must be in the format projects/*/locations/*/repositories/*/compilationResults/*.
        """
        return pulumi.get(self, "compilation_result")

    @compilation_result.setter
    def compilation_result(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compilation_result", value)

    @_builtins.property
    @pulumi.getter(name="errorStatuses")
    def error_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryReleaseConfigRecentScheduledReleaseRecordErrorStatusArgs']]]]:
        """
        (Output)
        The error status encountered upon this attempt to create the compilation result, if the attempt was unsuccessful.
        Structure is documented below.
        """
        return pulumi.get(self, "error_statuses")

    @error_statuses.setter
    def error_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryReleaseConfigRecentScheduledReleaseRecordErrorStatusArgs']]]]):
        pulumi.set(self, "error_statuses", value)

    @_builtins.property
    @pulumi.getter(name="releaseTime")
    def release_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        The timestamp of this release attempt.
        """
        return pulumi.get(self, "release_time")

    @release_time.setter
    def release_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_time", value)


if not MYPY:
    class RepositoryReleaseConfigRecentScheduledReleaseRecordErrorStatusArgsDict(TypedDict):
        code: NotRequired[pulumi.Input[_builtins.int]]
        """
        (Output)
        The status code, which should be an enum value of google.rpc.Code.
        """
        message: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
elif False:
    RepositoryReleaseConfigRecentScheduledReleaseRecordErrorStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryReleaseConfigRecentScheduledReleaseRecordErrorStatusArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[_builtins.int]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] code: (Output)
               The status code, which should be an enum value of google.rpc.Code.
        :param pulumi.Input[_builtins.str] message: (Output)
               A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Output)
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "code", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)


if not MYPY:
    class RepositoryWorkflowConfigInvocationConfigArgsDict(TypedDict):
        fully_refresh_incremental_tables_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Optional. When set to true, any incremental tables will be fully refreshed.
        """
        included_tags: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Optional. The set of tags to include.
        """
        included_targets: NotRequired[pulumi.Input[Sequence[pulumi.Input['RepositoryWorkflowConfigInvocationConfigIncludedTargetArgsDict']]]]
        """
        Optional. The set of action identifiers to include.
        Structure is documented below.
        """
        service_account: NotRequired[pulumi.Input[_builtins.str]]
        """
        Optional. The service account to run workflow invocations under.
        """
        transitive_dependencies_included: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Optional. When set to true, transitive dependencies of included actions will be executed.
        """
        transitive_dependents_included: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Optional. When set to true, transitive dependents of included actions will be executed.
        """
elif False:
    RepositoryWorkflowConfigInvocationConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryWorkflowConfigInvocationConfigArgs:
    def __init__(__self__, *,
                 fully_refresh_incremental_tables_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 included_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 included_targets: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryWorkflowConfigInvocationConfigIncludedTargetArgs']]]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 transitive_dependencies_included: Optional[pulumi.Input[_builtins.bool]] = None,
                 transitive_dependents_included: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] fully_refresh_incremental_tables_enabled: Optional. When set to true, any incremental tables will be fully refreshed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] included_tags: Optional. The set of tags to include.
        :param pulumi.Input[Sequence[pulumi.Input['RepositoryWorkflowConfigInvocationConfigIncludedTargetArgs']]] included_targets: Optional. The set of action identifiers to include.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] service_account: Optional. The service account to run workflow invocations under.
        :param pulumi.Input[_builtins.bool] transitive_dependencies_included: Optional. When set to true, transitive dependencies of included actions will be executed.
        :param pulumi.Input[_builtins.bool] transitive_dependents_included: Optional. When set to true, transitive dependents of included actions will be executed.
        """
        if fully_refresh_incremental_tables_enabled is not None:
            pulumi.set(__self__, "fully_refresh_incremental_tables_enabled", fully_refresh_incremental_tables_enabled)
        if included_tags is not None:
            pulumi.set(__self__, "included_tags", included_tags)
        if included_targets is not None:
            pulumi.set(__self__, "included_targets", included_targets)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if transitive_dependencies_included is not None:
            pulumi.set(__self__, "transitive_dependencies_included", transitive_dependencies_included)
        if transitive_dependents_included is not None:
            pulumi.set(__self__, "transitive_dependents_included", transitive_dependents_included)

    @_builtins.property
    @pulumi.getter(name="fullyRefreshIncrementalTablesEnabled")
    def fully_refresh_incremental_tables_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. When set to true, any incremental tables will be fully refreshed.
        """
        return pulumi.get(self, "fully_refresh_incremental_tables_enabled")

    @fully_refresh_incremental_tables_enabled.setter
    def fully_refresh_incremental_tables_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fully_refresh_incremental_tables_enabled", value)

    @_builtins.property
    @pulumi.getter(name="includedTags")
    def included_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Optional. The set of tags to include.
        """
        return pulumi.get(self, "included_tags")

    @included_tags.setter
    def included_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "included_tags", value)

    @_builtins.property
    @pulumi.getter(name="includedTargets")
    def included_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryWorkflowConfigInvocationConfigIncludedTargetArgs']]]]:
        """
        Optional. The set of action identifiers to include.
        Structure is documented below.
        """
        return pulumi.get(self, "included_targets")

    @included_targets.setter
    def included_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryWorkflowConfigInvocationConfigIncludedTargetArgs']]]]):
        pulumi.set(self, "included_targets", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The service account to run workflow invocations under.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="transitiveDependenciesIncluded")
    def transitive_dependencies_included(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. When set to true, transitive dependencies of included actions will be executed.
        """
        return pulumi.get(self, "transitive_dependencies_included")

    @transitive_dependencies_included.setter
    def transitive_dependencies_included(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transitive_dependencies_included", value)

    @_builtins.property
    @pulumi.getter(name="transitiveDependentsIncluded")
    def transitive_dependents_included(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. When set to true, transitive dependents of included actions will be executed.
        """
        return pulumi.get(self, "transitive_dependents_included")

    @transitive_dependents_included.setter
    def transitive_dependents_included(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transitive_dependents_included", value)


if not MYPY:
    class RepositoryWorkflowConfigInvocationConfigIncludedTargetArgsDict(TypedDict):
        database: NotRequired[pulumi.Input[_builtins.str]]
        """
        The action's database (Google Cloud project ID).
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The action's name, within database and schema.
        """
        schema: NotRequired[pulumi.Input[_builtins.str]]
        """
        The action's schema (BigQuery dataset ID), within database.
        """
elif False:
    RepositoryWorkflowConfigInvocationConfigIncludedTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryWorkflowConfigInvocationConfigIncludedTargetArgs:
    def __init__(__self__, *,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] database: The action's database (Google Cloud project ID).
        :param pulumi.Input[_builtins.str] name: The action's name, within database and schema.
        :param pulumi.Input[_builtins.str] schema: The action's schema (BigQuery dataset ID), within database.
        """
        if database is not None:
            pulumi.set(__self__, "database", database)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action's database (Google Cloud project ID).
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action's name, within database and schema.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The action's schema (BigQuery dataset ID), within database.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)


if not MYPY:
    class RepositoryWorkflowConfigRecentScheduledExecutionRecordArgsDict(TypedDict):
        error_statuses: NotRequired[pulumi.Input[Sequence[pulumi.Input['RepositoryWorkflowConfigRecentScheduledExecutionRecordErrorStatusArgsDict']]]]
        """
        (Output)
        The error status encountered upon this attempt to create the workflow invocation, if the attempt was unsuccessful.
        Structure is documented below.
        """
        execution_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        The timestamp of this workflow attempt.
        """
        workflow_invocation: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        The name of the created workflow invocation, if one was successfully created. In the format projects/*/locations/*/repositories/*/workflowInvocations/*.
        """
elif False:
    RepositoryWorkflowConfigRecentScheduledExecutionRecordArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryWorkflowConfigRecentScheduledExecutionRecordArgs:
    def __init__(__self__, *,
                 error_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryWorkflowConfigRecentScheduledExecutionRecordErrorStatusArgs']]]] = None,
                 execution_time: Optional[pulumi.Input[_builtins.str]] = None,
                 workflow_invocation: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RepositoryWorkflowConfigRecentScheduledExecutionRecordErrorStatusArgs']]] error_statuses: (Output)
               The error status encountered upon this attempt to create the workflow invocation, if the attempt was unsuccessful.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] execution_time: (Output)
               The timestamp of this workflow attempt.
        :param pulumi.Input[_builtins.str] workflow_invocation: (Output)
               The name of the created workflow invocation, if one was successfully created. In the format projects/*/locations/*/repositories/*/workflowInvocations/*.
        """
        if error_statuses is not None:
            pulumi.set(__self__, "error_statuses", error_statuses)
        if execution_time is not None:
            pulumi.set(__self__, "execution_time", execution_time)
        if workflow_invocation is not None:
            pulumi.set(__self__, "workflow_invocation", workflow_invocation)

    @_builtins.property
    @pulumi.getter(name="errorStatuses")
    def error_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryWorkflowConfigRecentScheduledExecutionRecordErrorStatusArgs']]]]:
        """
        (Output)
        The error status encountered upon this attempt to create the workflow invocation, if the attempt was unsuccessful.
        Structure is documented below.
        """
        return pulumi.get(self, "error_statuses")

    @error_statuses.setter
    def error_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RepositoryWorkflowConfigRecentScheduledExecutionRecordErrorStatusArgs']]]]):
        pulumi.set(self, "error_statuses", value)

    @_builtins.property
    @pulumi.getter(name="executionTime")
    def execution_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        The timestamp of this workflow attempt.
        """
        return pulumi.get(self, "execution_time")

    @execution_time.setter
    def execution_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "execution_time", value)

    @_builtins.property
    @pulumi.getter(name="workflowInvocation")
    def workflow_invocation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        The name of the created workflow invocation, if one was successfully created. In the format projects/*/locations/*/repositories/*/workflowInvocations/*.
        """
        return pulumi.get(self, "workflow_invocation")

    @workflow_invocation.setter
    def workflow_invocation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workflow_invocation", value)


if not MYPY:
    class RepositoryWorkflowConfigRecentScheduledExecutionRecordErrorStatusArgsDict(TypedDict):
        code: NotRequired[pulumi.Input[_builtins.int]]
        """
        (Output)
        The status code, which should be an enum value of google.rpc.Code.
        """
        message: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
elif False:
    RepositoryWorkflowConfigRecentScheduledExecutionRecordErrorStatusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryWorkflowConfigRecentScheduledExecutionRecordErrorStatusArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[_builtins.int]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] code: (Output)
               The status code, which should be an enum value of google.rpc.Code.
        :param pulumi.Input[_builtins.str] message: (Output)
               A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Output)
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "code", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)


if not MYPY:
    class RepositoryWorkspaceCompilationOverridesArgsDict(TypedDict):
        default_database: NotRequired[pulumi.Input[_builtins.str]]
        """
        The default database (Google Cloud project ID).
        """
        schema_suffix: NotRequired[pulumi.Input[_builtins.str]]
        """
        The suffix that should be appended to all schema (BigQuery dataset ID) names.
        """
        table_prefix: NotRequired[pulumi.Input[_builtins.str]]
        """
        The prefix that should be prepended to all table names.
        """
elif False:
    RepositoryWorkspaceCompilationOverridesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryWorkspaceCompilationOverridesArgs:
    def __init__(__self__, *,
                 default_database: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 table_prefix: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] default_database: The default database (Google Cloud project ID).
        :param pulumi.Input[_builtins.str] schema_suffix: The suffix that should be appended to all schema (BigQuery dataset ID) names.
        :param pulumi.Input[_builtins.str] table_prefix: The prefix that should be prepended to all table names.
        """
        if default_database is not None:
            pulumi.set(__self__, "default_database", default_database)
        if schema_suffix is not None:
            pulumi.set(__self__, "schema_suffix", schema_suffix)
        if table_prefix is not None:
            pulumi.set(__self__, "table_prefix", table_prefix)

    @_builtins.property
    @pulumi.getter(name="defaultDatabase")
    def default_database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default database (Google Cloud project ID).
        """
        return pulumi.get(self, "default_database")

    @default_database.setter
    def default_database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_database", value)

    @_builtins.property
    @pulumi.getter(name="schemaSuffix")
    def schema_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The suffix that should be appended to all schema (BigQuery dataset ID) names.
        """
        return pulumi.get(self, "schema_suffix")

    @schema_suffix.setter
    def schema_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_suffix", value)

    @_builtins.property
    @pulumi.getter(name="tablePrefix")
    def table_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The prefix that should be prepended to all table names.
        """
        return pulumi.get(self, "table_prefix")

    @table_prefix.setter
    def table_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_prefix", value)


