# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 cluster_config: Optional[pulumi.Input['ClusterClusterConfigArgs']] = None,
                 graceful_decommission_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_cluster_config: Optional[pulumi.Input['ClusterVirtualClusterConfigArgs']] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input['ClusterClusterConfigArgs'] cluster_config: Allows you to configure various aspects of the cluster.
               Structure defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The list of the labels (key/value pairs) configured on the resource and to be applied to instances in the cluster.
               
               				**Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               				Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The name of the cluster, unique within the project and
               zone.
               
               - - -
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the `cluster` will exist. If it
               is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region in which the cluster and associated nodes will be created in.
               Defaults to `global`.
        :param pulumi.Input['ClusterVirtualClusterConfigArgs'] virtual_cluster_config: Allows you to configure a virtual Dataproc on GKE cluster.
               Structure defined below.
        """
        if cluster_config is not None:
            pulumi.set(__self__, "cluster_config", cluster_config)
        if graceful_decommission_timeout is not None:
            pulumi.set(__self__, "graceful_decommission_timeout", graceful_decommission_timeout)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if virtual_cluster_config is not None:
            pulumi.set(__self__, "virtual_cluster_config", virtual_cluster_config)

    @_builtins.property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> Optional[pulumi.Input['ClusterClusterConfigArgs']]:
        """
        Allows you to configure various aspects of the cluster.
        Structure defined below.
        """
        return pulumi.get(self, "cluster_config")

    @cluster_config.setter
    def cluster_config(self, value: Optional[pulumi.Input['ClusterClusterConfigArgs']]):
        pulumi.set(self, "cluster_config", value)

    @_builtins.property
    @pulumi.getter(name="gracefulDecommissionTimeout")
    def graceful_decommission_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "graceful_decommission_timeout")

    @graceful_decommission_timeout.setter
    def graceful_decommission_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "graceful_decommission_timeout", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The list of the labels (key/value pairs) configured on the resource and to be applied to instances in the cluster.

        				**Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        				Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the cluster, unique within the project and
        zone.

        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the `cluster` will exist. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which the cluster and associated nodes will be created in.
        Defaults to `global`.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="virtualClusterConfig")
    def virtual_cluster_config(self) -> Optional[pulumi.Input['ClusterVirtualClusterConfigArgs']]:
        """
        Allows you to configure a virtual Dataproc on GKE cluster.
        Structure defined below.
        """
        return pulumi.get(self, "virtual_cluster_config")

    @virtual_cluster_config.setter
    def virtual_cluster_config(self, value: Optional[pulumi.Input['ClusterVirtualClusterConfigArgs']]):
        pulumi.set(self, "virtual_cluster_config", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 cluster_config: Optional[pulumi.Input['ClusterClusterConfigArgs']] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 graceful_decommission_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_cluster_config: Optional[pulumi.Input['ClusterVirtualClusterConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input['ClusterClusterConfigArgs'] cluster_config: Allows you to configure various aspects of the cluster.
               Structure defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: The list of labels (key/value pairs) to be applied to
               instances in the cluster. GCP generates some itself including `goog-dataproc-cluster-name`
               which is the name of the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The list of the labels (key/value pairs) configured on the resource and to be applied to instances in the cluster.
               
               				**Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               				Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The name of the cluster, unique within the project and
               zone.
               
               - - -
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the `cluster` will exist. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] region: The region in which the cluster and associated nodes will be created in.
               Defaults to `global`.
        :param pulumi.Input['ClusterVirtualClusterConfigArgs'] virtual_cluster_config: Allows you to configure a virtual Dataproc on GKE cluster.
               Structure defined below.
        """
        if cluster_config is not None:
            pulumi.set(__self__, "cluster_config", cluster_config)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if graceful_decommission_timeout is not None:
            pulumi.set(__self__, "graceful_decommission_timeout", graceful_decommission_timeout)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if virtual_cluster_config is not None:
            pulumi.set(__self__, "virtual_cluster_config", virtual_cluster_config)

    @_builtins.property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> Optional[pulumi.Input['ClusterClusterConfigArgs']]:
        """
        Allows you to configure various aspects of the cluster.
        Structure defined below.
        """
        return pulumi.get(self, "cluster_config")

    @cluster_config.setter
    def cluster_config(self, value: Optional[pulumi.Input['ClusterClusterConfigArgs']]):
        pulumi.set(self, "cluster_config", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The list of labels (key/value pairs) to be applied to
        instances in the cluster. GCP generates some itself including `goog-dataproc-cluster-name`
        which is the name of the cluster.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="gracefulDecommissionTimeout")
    def graceful_decommission_timeout(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "graceful_decommission_timeout")

    @graceful_decommission_timeout.setter
    def graceful_decommission_timeout(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "graceful_decommission_timeout", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The list of the labels (key/value pairs) configured on the resource and to be applied to instances in the cluster.

        				**Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        				Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the cluster, unique within the project and
        zone.

        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the `cluster` will exist. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which the cluster and associated nodes will be created in.
        Defaults to `global`.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="virtualClusterConfig")
    def virtual_cluster_config(self) -> Optional[pulumi.Input['ClusterVirtualClusterConfigArgs']]:
        """
        Allows you to configure a virtual Dataproc on GKE cluster.
        Structure defined below.
        """
        return pulumi.get(self, "virtual_cluster_config")

    @virtual_cluster_config.setter
    def virtual_cluster_config(self, value: Optional[pulumi.Input['ClusterVirtualClusterConfigArgs']]):
        pulumi.set(self, "virtual_cluster_config", value)


@pulumi.type_token("gcp:dataproc/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_config: Optional[pulumi.Input[Union['ClusterClusterConfigArgs', 'ClusterClusterConfigArgsDict']]] = None,
                 graceful_decommission_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_cluster_config: Optional[pulumi.Input[Union['ClusterVirtualClusterConfigArgs', 'ClusterVirtualClusterConfigArgsDict']]] = None,
                 __props__=None):
        """
        Manages a Cloud Dataproc cluster resource within GCP.

        * [API documentation](https://cloud.google.com/dataproc/docs/reference/rest/v1/projects.regions.clusters)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dataproc/docs)

        !> **Warning:** Due to limitations of the API, all arguments except
        `labels`,`cluster_config.worker_config.num_instances` and `cluster_config.preemptible_worker_config.num_instances` are non-updatable. Changing `cluster_config.worker_config.min_num_instances` will be ignored. Changing others will cause recreation of the
        whole cluster!

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        simplecluster = gcp.dataproc.Cluster("simplecluster",
            name="simplecluster",
            region="us-central1")
        ```

        ### Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.serviceaccount.Account("default",
            account_id="service-account-id",
            display_name="Service Account")
        mycluster = gcp.dataproc.Cluster("mycluster",
            name="mycluster",
            region="us-central1",
            graceful_decommission_timeout="120s",
            labels={
                "foo": "bar",
            },
            cluster_config={
                "staging_bucket": "dataproc-staging-bucket",
                "cluster_tier": "CLUSTER_TIER_STANDARD",
                "master_config": {
                    "num_instances": 1,
                    "machine_type": "e2-medium",
                    "disk_config": {
                        "boot_disk_type": "pd-ssd",
                        "boot_disk_size_gb": 30,
                    },
                },
                "worker_config": {
                    "num_instances": 2,
                    "machine_type": "e2-medium",
                    "min_cpu_platform": "Intel Skylake",
                    "disk_config": {
                        "boot_disk_size_gb": 30,
                        "num_local_ssds": 1,
                    },
                },
                "preemptible_worker_config": {
                    "num_instances": 0,
                },
                "software_config": {
                    "image_version": "2.0.35-debian10",
                    "override_properties": {
                        "dataproc:dataproc.allow.zero.workers": "true",
                    },
                },
                "gce_cluster_config": {
                    "tags": [
                        "foo",
                        "bar",
                    ],
                    "service_account": default.email,
                    "service_account_scopes": ["cloud-platform"],
                },
                "initialization_actions": [{
                    "script": "gs://dataproc-initialization-actions/stackdriver/stackdriver.sh",
                    "timeout_sec": 500,
                }],
            })
        ```

        ### Using A GPU Accelerator

        ```python
        import pulumi
        import pulumi_gcp as gcp

        accelerated_cluster = gcp.dataproc.Cluster("accelerated_cluster",
            name="my-cluster-with-gpu",
            region="us-central1",
            cluster_config={
                "gce_cluster_config": {
                    "zone": "us-central1-a",
                },
                "master_config": {
                    "accelerators": [{
                        "accelerator_type": "nvidia-tesla-k80",
                        "accelerator_count": 1,
                    }],
                },
            })
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ClusterClusterConfigArgs', 'ClusterClusterConfigArgsDict']] cluster_config: Allows you to configure various aspects of the cluster.
               Structure defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The list of the labels (key/value pairs) configured on the resource and to be applied to instances in the cluster.
               
               				**Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               				Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The name of the cluster, unique within the project and
               zone.
               
               - - -
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the `cluster` will exist. If it
               is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region in which the cluster and associated nodes will be created in.
               Defaults to `global`.
        :param pulumi.Input[Union['ClusterVirtualClusterConfigArgs', 'ClusterVirtualClusterConfigArgsDict']] virtual_cluster_config: Allows you to configure a virtual Dataproc on GKE cluster.
               Structure defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ClusterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Cloud Dataproc cluster resource within GCP.

        * [API documentation](https://cloud.google.com/dataproc/docs/reference/rest/v1/projects.regions.clusters)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dataproc/docs)

        !> **Warning:** Due to limitations of the API, all arguments except
        `labels`,`cluster_config.worker_config.num_instances` and `cluster_config.preemptible_worker_config.num_instances` are non-updatable. Changing `cluster_config.worker_config.min_num_instances` will be ignored. Changing others will cause recreation of the
        whole cluster!

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        simplecluster = gcp.dataproc.Cluster("simplecluster",
            name="simplecluster",
            region="us-central1")
        ```

        ### Advanced

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.serviceaccount.Account("default",
            account_id="service-account-id",
            display_name="Service Account")
        mycluster = gcp.dataproc.Cluster("mycluster",
            name="mycluster",
            region="us-central1",
            graceful_decommission_timeout="120s",
            labels={
                "foo": "bar",
            },
            cluster_config={
                "staging_bucket": "dataproc-staging-bucket",
                "cluster_tier": "CLUSTER_TIER_STANDARD",
                "master_config": {
                    "num_instances": 1,
                    "machine_type": "e2-medium",
                    "disk_config": {
                        "boot_disk_type": "pd-ssd",
                        "boot_disk_size_gb": 30,
                    },
                },
                "worker_config": {
                    "num_instances": 2,
                    "machine_type": "e2-medium",
                    "min_cpu_platform": "Intel Skylake",
                    "disk_config": {
                        "boot_disk_size_gb": 30,
                        "num_local_ssds": 1,
                    },
                },
                "preemptible_worker_config": {
                    "num_instances": 0,
                },
                "software_config": {
                    "image_version": "2.0.35-debian10",
                    "override_properties": {
                        "dataproc:dataproc.allow.zero.workers": "true",
                    },
                },
                "gce_cluster_config": {
                    "tags": [
                        "foo",
                        "bar",
                    ],
                    "service_account": default.email,
                    "service_account_scopes": ["cloud-platform"],
                },
                "initialization_actions": [{
                    "script": "gs://dataproc-initialization-actions/stackdriver/stackdriver.sh",
                    "timeout_sec": 500,
                }],
            })
        ```

        ### Using A GPU Accelerator

        ```python
        import pulumi
        import pulumi_gcp as gcp

        accelerated_cluster = gcp.dataproc.Cluster("accelerated_cluster",
            name="my-cluster-with-gpu",
            region="us-central1",
            cluster_config={
                "gce_cluster_config": {
                    "zone": "us-central1-a",
                },
                "master_config": {
                    "accelerators": [{
                        "accelerator_type": "nvidia-tesla-k80",
                        "accelerator_count": 1,
                    }],
                },
            })
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_config: Optional[pulumi.Input[Union['ClusterClusterConfigArgs', 'ClusterClusterConfigArgsDict']]] = None,
                 graceful_decommission_timeout: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_cluster_config: Optional[pulumi.Input[Union['ClusterVirtualClusterConfigArgs', 'ClusterVirtualClusterConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["cluster_config"] = cluster_config
            __props__.__dict__["graceful_decommission_timeout"] = graceful_decommission_timeout
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["virtual_cluster_config"] = virtual_cluster_config
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Cluster, __self__).__init__(
            'gcp:dataproc/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_config: Optional[pulumi.Input[Union['ClusterClusterConfigArgs', 'ClusterClusterConfigArgsDict']]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            graceful_decommission_timeout: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_cluster_config: Optional[pulumi.Input[Union['ClusterVirtualClusterConfigArgs', 'ClusterVirtualClusterConfigArgsDict']]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ClusterClusterConfigArgs', 'ClusterClusterConfigArgsDict']] cluster_config: Allows you to configure various aspects of the cluster.
               Structure defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: The list of labels (key/value pairs) to be applied to
               instances in the cluster. GCP generates some itself including `goog-dataproc-cluster-name`
               which is the name of the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The list of the labels (key/value pairs) configured on the resource and to be applied to instances in the cluster.
               
               				**Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               				Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The name of the cluster, unique within the project and
               zone.
               
               - - -
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the `cluster` will exist. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] region: The region in which the cluster and associated nodes will be created in.
               Defaults to `global`.
        :param pulumi.Input[Union['ClusterVirtualClusterConfigArgs', 'ClusterVirtualClusterConfigArgsDict']] virtual_cluster_config: Allows you to configure a virtual Dataproc on GKE cluster.
               Structure defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["cluster_config"] = cluster_config
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["graceful_decommission_timeout"] = graceful_decommission_timeout
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["region"] = region
        __props__.__dict__["virtual_cluster_config"] = virtual_cluster_config
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> pulumi.Output['outputs.ClusterClusterConfig']:
        """
        Allows you to configure various aspects of the cluster.
        Structure defined below.
        """
        return pulumi.get(self, "cluster_config")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The list of labels (key/value pairs) to be applied to
        instances in the cluster. GCP generates some itself including `goog-dataproc-cluster-name`
        which is the name of the cluster.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="gracefulDecommissionTimeout")
    def graceful_decommission_timeout(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "graceful_decommission_timeout")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The list of the labels (key/value pairs) configured on the resource and to be applied to instances in the cluster.

        				**Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        				Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the cluster, unique within the project and
        zone.

        - - -
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the `cluster` will exist. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region in which the cluster and associated nodes will be created in.
        Defaults to `global`.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="virtualClusterConfig")
    def virtual_cluster_config(self) -> pulumi.Output['outputs.ClusterVirtualClusterConfig']:
        """
        Allows you to configure a virtual Dataproc on GKE cluster.
        Structure defined below.
        """
        return pulumi.get(self, "virtual_cluster_config")

