# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CxAgentArgs', 'CxAgent']

@pulumi.input_type
class CxAgentArgs:
    def __init__(__self__, *,
                 default_language_code: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 time_zone: pulumi.Input[_builtins.str],
                 advanced_settings: Optional[pulumi.Input['CxAgentAdvancedSettingsArgs']] = None,
                 avatar_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_chat_engine_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_spell_correction: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 gen_app_builder_settings: Optional[pulumi.Input['CxAgentGenAppBuilderSettingsArgs']] = None,
                 git_integration_settings: Optional[pulumi.Input['CxAgentGitIntegrationSettingsArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 security_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 speech_to_text_settings: Optional[pulumi.Input['CxAgentSpeechToTextSettingsArgs']] = None,
                 supported_language_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 text_to_speech_settings: Optional[pulumi.Input['CxAgentTextToSpeechSettingsArgs']] = None):
        """
        The set of arguments for constructing a CxAgent resource.
        :param pulumi.Input[_builtins.str] default_language_code: The default language of the agent as a language tag. [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
               for a list of the currently supported language codes. This field cannot be updated after creation.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the agent, unique within the location.
        :param pulumi.Input[_builtins.str] location: The name of the location this agent is located in.
               > **Note:** The first time you are deploying an Agent in your project you must configure location settings.
               This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
               Another options is to use global location so you don't need to manually configure location settings.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York,
               Europe/Paris.
        :param pulumi.Input['CxAgentAdvancedSettingsArgs'] advanced_settings: Hierarchical advanced settings for this agent. The settings exposed at the lower level overrides the settings exposed at the higher level.
               Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] avatar_uri: The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
        :param pulumi.Input[_builtins.str] description: The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
        :param pulumi.Input[_builtins.bool] enable_spell_correction: Indicates if automatic spell correction is enabled in detect intent requests.
        :param pulumi.Input[_builtins.bool] enable_stackdriver_logging: (Optional, Deprecated)
               Determines whether this agent should log conversation queries.
               
               > **Warning:** `enable_stackdriver_logging` is deprecated and will be removed in a future major release. Please use `advanced_settings.logging_settings.enable_stackdriver_logging`instead.
        :param pulumi.Input['CxAgentGenAppBuilderSettingsArgs'] gen_app_builder_settings: Gen App Builder-related agent-level settings.
               Structure is documented below.
        :param pulumi.Input['CxAgentGitIntegrationSettingsArgs'] git_integration_settings: Git integration settings for this agent.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] security_settings: Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        :param pulumi.Input['CxAgentSpeechToTextSettingsArgs'] speech_to_text_settings: Settings related to speech recognition.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] supported_language_codes: The list of all languages supported by this agent (except for the default_language_code).
        :param pulumi.Input['CxAgentTextToSpeechSettingsArgs'] text_to_speech_settings: Settings related to speech synthesizing.
               Structure is documented below.
        """
        pulumi.set(__self__, "default_language_code", default_language_code)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "time_zone", time_zone)
        if advanced_settings is not None:
            pulumi.set(__self__, "advanced_settings", advanced_settings)
        if avatar_uri is not None:
            pulumi.set(__self__, "avatar_uri", avatar_uri)
        if delete_chat_engine_on_destroy is not None:
            pulumi.set(__self__, "delete_chat_engine_on_destroy", delete_chat_engine_on_destroy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_spell_correction is not None:
            pulumi.set(__self__, "enable_spell_correction", enable_spell_correction)
        if enable_stackdriver_logging is not None:
            warnings.warn("""`enable_stackdriver_logging` is deprecated and will be removed in a future major release. Please use `advanced_settings.logging_settings.enable_stackdriver_logging`instead.""", DeprecationWarning)
            pulumi.log.warn("""enable_stackdriver_logging is deprecated: `enable_stackdriver_logging` is deprecated and will be removed in a future major release. Please use `advanced_settings.logging_settings.enable_stackdriver_logging`instead.""")
        if enable_stackdriver_logging is not None:
            pulumi.set(__self__, "enable_stackdriver_logging", enable_stackdriver_logging)
        if gen_app_builder_settings is not None:
            pulumi.set(__self__, "gen_app_builder_settings", gen_app_builder_settings)
        if git_integration_settings is not None:
            pulumi.set(__self__, "git_integration_settings", git_integration_settings)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if security_settings is not None:
            pulumi.set(__self__, "security_settings", security_settings)
        if speech_to_text_settings is not None:
            pulumi.set(__self__, "speech_to_text_settings", speech_to_text_settings)
        if supported_language_codes is not None:
            pulumi.set(__self__, "supported_language_codes", supported_language_codes)
        if text_to_speech_settings is not None:
            pulumi.set(__self__, "text_to_speech_settings", text_to_speech_settings)

    @_builtins.property
    @pulumi.getter(name="defaultLanguageCode")
    def default_language_code(self) -> pulumi.Input[_builtins.str]:
        """
        The default language of the agent as a language tag. [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
        for a list of the currently supported language codes. This field cannot be updated after creation.
        """
        return pulumi.get(self, "default_language_code")

    @default_language_code.setter
    def default_language_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_language_code", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The human-readable name of the agent, unique within the location.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the location this agent is located in.
        > **Note:** The first time you are deploying an Agent in your project you must configure location settings.
        This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
        Another options is to use global location so you don't need to manually configure location settings.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Input[_builtins.str]:
        """
        The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York,
        Europe/Paris.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter(name="advancedSettings")
    def advanced_settings(self) -> Optional[pulumi.Input['CxAgentAdvancedSettingsArgs']]:
        """
        Hierarchical advanced settings for this agent. The settings exposed at the lower level overrides the settings exposed at the higher level.
        Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_settings")

    @advanced_settings.setter
    def advanced_settings(self, value: Optional[pulumi.Input['CxAgentAdvancedSettingsArgs']]):
        pulumi.set(self, "advanced_settings", value)

    @_builtins.property
    @pulumi.getter(name="avatarUri")
    def avatar_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
        """
        return pulumi.get(self, "avatar_uri")

    @avatar_uri.setter
    def avatar_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "avatar_uri", value)

    @_builtins.property
    @pulumi.getter(name="deleteChatEngineOnDestroy")
    def delete_chat_engine_on_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "delete_chat_engine_on_destroy")

    @delete_chat_engine_on_destroy.setter
    def delete_chat_engine_on_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_chat_engine_on_destroy", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableSpellCorrection")
    def enable_spell_correction(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if automatic spell correction is enabled in detect intent requests.
        """
        return pulumi.get(self, "enable_spell_correction")

    @enable_spell_correction.setter
    def enable_spell_correction(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_spell_correction", value)

    @_builtins.property
    @pulumi.getter(name="enableStackdriverLogging")
    @_utilities.deprecated("""`enable_stackdriver_logging` is deprecated and will be removed in a future major release. Please use `advanced_settings.logging_settings.enable_stackdriver_logging`instead.""")
    def enable_stackdriver_logging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Optional, Deprecated)
        Determines whether this agent should log conversation queries.

        > **Warning:** `enable_stackdriver_logging` is deprecated and will be removed in a future major release. Please use `advanced_settings.logging_settings.enable_stackdriver_logging`instead.
        """
        return pulumi.get(self, "enable_stackdriver_logging")

    @enable_stackdriver_logging.setter
    def enable_stackdriver_logging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_stackdriver_logging", value)

    @_builtins.property
    @pulumi.getter(name="genAppBuilderSettings")
    def gen_app_builder_settings(self) -> Optional[pulumi.Input['CxAgentGenAppBuilderSettingsArgs']]:
        """
        Gen App Builder-related agent-level settings.
        Structure is documented below.
        """
        return pulumi.get(self, "gen_app_builder_settings")

    @gen_app_builder_settings.setter
    def gen_app_builder_settings(self, value: Optional[pulumi.Input['CxAgentGenAppBuilderSettingsArgs']]):
        pulumi.set(self, "gen_app_builder_settings", value)

    @_builtins.property
    @pulumi.getter(name="gitIntegrationSettings")
    def git_integration_settings(self) -> Optional[pulumi.Input['CxAgentGitIntegrationSettingsArgs']]:
        """
        Git integration settings for this agent.
        Structure is documented below.
        """
        return pulumi.get(self, "git_integration_settings")

    @git_integration_settings.setter
    def git_integration_settings(self, value: Optional[pulumi.Input['CxAgentGitIntegrationSettingsArgs']]):
        pulumi.set(self, "git_integration_settings", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        """
        return pulumi.get(self, "security_settings")

    @security_settings.setter
    def security_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_settings", value)

    @_builtins.property
    @pulumi.getter(name="speechToTextSettings")
    def speech_to_text_settings(self) -> Optional[pulumi.Input['CxAgentSpeechToTextSettingsArgs']]:
        """
        Settings related to speech recognition.
        Structure is documented below.
        """
        return pulumi.get(self, "speech_to_text_settings")

    @speech_to_text_settings.setter
    def speech_to_text_settings(self, value: Optional[pulumi.Input['CxAgentSpeechToTextSettingsArgs']]):
        pulumi.set(self, "speech_to_text_settings", value)

    @_builtins.property
    @pulumi.getter(name="supportedLanguageCodes")
    def supported_language_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of all languages supported by this agent (except for the default_language_code).
        """
        return pulumi.get(self, "supported_language_codes")

    @supported_language_codes.setter
    def supported_language_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "supported_language_codes", value)

    @_builtins.property
    @pulumi.getter(name="textToSpeechSettings")
    def text_to_speech_settings(self) -> Optional[pulumi.Input['CxAgentTextToSpeechSettingsArgs']]:
        """
        Settings related to speech synthesizing.
        Structure is documented below.
        """
        return pulumi.get(self, "text_to_speech_settings")

    @text_to_speech_settings.setter
    def text_to_speech_settings(self, value: Optional[pulumi.Input['CxAgentTextToSpeechSettingsArgs']]):
        pulumi.set(self, "text_to_speech_settings", value)


@pulumi.input_type
class _CxAgentState:
    def __init__(__self__, *,
                 advanced_settings: Optional[pulumi.Input['CxAgentAdvancedSettingsArgs']] = None,
                 avatar_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 default_language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_chat_engine_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_spell_correction: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 gen_app_builder_settings: Optional[pulumi.Input['CxAgentGenAppBuilderSettingsArgs']] = None,
                 git_integration_settings: Optional[pulumi.Input['CxAgentGitIntegrationSettingsArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 security_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 speech_to_text_settings: Optional[pulumi.Input['CxAgentSpeechToTextSettingsArgs']] = None,
                 start_flow: Optional[pulumi.Input[_builtins.str]] = None,
                 supported_language_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 text_to_speech_settings: Optional[pulumi.Input['CxAgentTextToSpeechSettingsArgs']] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CxAgent resources.
        :param pulumi.Input['CxAgentAdvancedSettingsArgs'] advanced_settings: Hierarchical advanced settings for this agent. The settings exposed at the lower level overrides the settings exposed at the higher level.
               Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] avatar_uri: The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
        :param pulumi.Input[_builtins.str] default_language_code: The default language of the agent as a language tag. [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
               for a list of the currently supported language codes. This field cannot be updated after creation.
        :param pulumi.Input[_builtins.str] description: The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the agent, unique within the location.
        :param pulumi.Input[_builtins.bool] enable_spell_correction: Indicates if automatic spell correction is enabled in detect intent requests.
        :param pulumi.Input[_builtins.bool] enable_stackdriver_logging: (Optional, Deprecated)
               Determines whether this agent should log conversation queries.
               
               > **Warning:** `enable_stackdriver_logging` is deprecated and will be removed in a future major release. Please use `advanced_settings.logging_settings.enable_stackdriver_logging`instead.
        :param pulumi.Input['CxAgentGenAppBuilderSettingsArgs'] gen_app_builder_settings: Gen App Builder-related agent-level settings.
               Structure is documented below.
        :param pulumi.Input['CxAgentGitIntegrationSettingsArgs'] git_integration_settings: Git integration settings for this agent.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The name of the location this agent is located in.
               > **Note:** The first time you are deploying an Agent in your project you must configure location settings.
               This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
               Another options is to use global location so you don't need to manually configure location settings.
        :param pulumi.Input[_builtins.str] name: The unique identifier of the agent.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] security_settings: Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        :param pulumi.Input['CxAgentSpeechToTextSettingsArgs'] speech_to_text_settings: Settings related to speech recognition.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] start_flow: Name of the start flow in this agent. A start flow will be automatically created when the agent is created, and can only be deleted by deleting the agent. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] supported_language_codes: The list of all languages supported by this agent (except for the default_language_code).
        :param pulumi.Input['CxAgentTextToSpeechSettingsArgs'] text_to_speech_settings: Settings related to speech synthesizing.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York,
               Europe/Paris.
        """
        if advanced_settings is not None:
            pulumi.set(__self__, "advanced_settings", advanced_settings)
        if avatar_uri is not None:
            pulumi.set(__self__, "avatar_uri", avatar_uri)
        if default_language_code is not None:
            pulumi.set(__self__, "default_language_code", default_language_code)
        if delete_chat_engine_on_destroy is not None:
            pulumi.set(__self__, "delete_chat_engine_on_destroy", delete_chat_engine_on_destroy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enable_spell_correction is not None:
            pulumi.set(__self__, "enable_spell_correction", enable_spell_correction)
        if enable_stackdriver_logging is not None:
            warnings.warn("""`enable_stackdriver_logging` is deprecated and will be removed in a future major release. Please use `advanced_settings.logging_settings.enable_stackdriver_logging`instead.""", DeprecationWarning)
            pulumi.log.warn("""enable_stackdriver_logging is deprecated: `enable_stackdriver_logging` is deprecated and will be removed in a future major release. Please use `advanced_settings.logging_settings.enable_stackdriver_logging`instead.""")
        if enable_stackdriver_logging is not None:
            pulumi.set(__self__, "enable_stackdriver_logging", enable_stackdriver_logging)
        if gen_app_builder_settings is not None:
            pulumi.set(__self__, "gen_app_builder_settings", gen_app_builder_settings)
        if git_integration_settings is not None:
            pulumi.set(__self__, "git_integration_settings", git_integration_settings)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if security_settings is not None:
            pulumi.set(__self__, "security_settings", security_settings)
        if speech_to_text_settings is not None:
            pulumi.set(__self__, "speech_to_text_settings", speech_to_text_settings)
        if start_flow is not None:
            pulumi.set(__self__, "start_flow", start_flow)
        if supported_language_codes is not None:
            pulumi.set(__self__, "supported_language_codes", supported_language_codes)
        if text_to_speech_settings is not None:
            pulumi.set(__self__, "text_to_speech_settings", text_to_speech_settings)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter(name="advancedSettings")
    def advanced_settings(self) -> Optional[pulumi.Input['CxAgentAdvancedSettingsArgs']]:
        """
        Hierarchical advanced settings for this agent. The settings exposed at the lower level overrides the settings exposed at the higher level.
        Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_settings")

    @advanced_settings.setter
    def advanced_settings(self, value: Optional[pulumi.Input['CxAgentAdvancedSettingsArgs']]):
        pulumi.set(self, "advanced_settings", value)

    @_builtins.property
    @pulumi.getter(name="avatarUri")
    def avatar_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
        """
        return pulumi.get(self, "avatar_uri")

    @avatar_uri.setter
    def avatar_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "avatar_uri", value)

    @_builtins.property
    @pulumi.getter(name="defaultLanguageCode")
    def default_language_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default language of the agent as a language tag. [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
        for a list of the currently supported language codes. This field cannot be updated after creation.
        """
        return pulumi.get(self, "default_language_code")

    @default_language_code.setter
    def default_language_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_language_code", value)

    @_builtins.property
    @pulumi.getter(name="deleteChatEngineOnDestroy")
    def delete_chat_engine_on_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "delete_chat_engine_on_destroy")

    @delete_chat_engine_on_destroy.setter
    def delete_chat_engine_on_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_chat_engine_on_destroy", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The human-readable name of the agent, unique within the location.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="enableSpellCorrection")
    def enable_spell_correction(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if automatic spell correction is enabled in detect intent requests.
        """
        return pulumi.get(self, "enable_spell_correction")

    @enable_spell_correction.setter
    def enable_spell_correction(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_spell_correction", value)

    @_builtins.property
    @pulumi.getter(name="enableStackdriverLogging")
    @_utilities.deprecated("""`enable_stackdriver_logging` is deprecated and will be removed in a future major release. Please use `advanced_settings.logging_settings.enable_stackdriver_logging`instead.""")
    def enable_stackdriver_logging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Optional, Deprecated)
        Determines whether this agent should log conversation queries.

        > **Warning:** `enable_stackdriver_logging` is deprecated and will be removed in a future major release. Please use `advanced_settings.logging_settings.enable_stackdriver_logging`instead.
        """
        return pulumi.get(self, "enable_stackdriver_logging")

    @enable_stackdriver_logging.setter
    def enable_stackdriver_logging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_stackdriver_logging", value)

    @_builtins.property
    @pulumi.getter(name="genAppBuilderSettings")
    def gen_app_builder_settings(self) -> Optional[pulumi.Input['CxAgentGenAppBuilderSettingsArgs']]:
        """
        Gen App Builder-related agent-level settings.
        Structure is documented below.
        """
        return pulumi.get(self, "gen_app_builder_settings")

    @gen_app_builder_settings.setter
    def gen_app_builder_settings(self, value: Optional[pulumi.Input['CxAgentGenAppBuilderSettingsArgs']]):
        pulumi.set(self, "gen_app_builder_settings", value)

    @_builtins.property
    @pulumi.getter(name="gitIntegrationSettings")
    def git_integration_settings(self) -> Optional[pulumi.Input['CxAgentGitIntegrationSettingsArgs']]:
        """
        Git integration settings for this agent.
        Structure is documented below.
        """
        return pulumi.get(self, "git_integration_settings")

    @git_integration_settings.setter
    def git_integration_settings(self, value: Optional[pulumi.Input['CxAgentGitIntegrationSettingsArgs']]):
        pulumi.set(self, "git_integration_settings", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the location this agent is located in.
        > **Note:** The first time you are deploying an Agent in your project you must configure location settings.
        This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
        Another options is to use global location so you don't need to manually configure location settings.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the agent.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        """
        return pulumi.get(self, "security_settings")

    @security_settings.setter
    def security_settings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_settings", value)

    @_builtins.property
    @pulumi.getter(name="speechToTextSettings")
    def speech_to_text_settings(self) -> Optional[pulumi.Input['CxAgentSpeechToTextSettingsArgs']]:
        """
        Settings related to speech recognition.
        Structure is documented below.
        """
        return pulumi.get(self, "speech_to_text_settings")

    @speech_to_text_settings.setter
    def speech_to_text_settings(self, value: Optional[pulumi.Input['CxAgentSpeechToTextSettingsArgs']]):
        pulumi.set(self, "speech_to_text_settings", value)

    @_builtins.property
    @pulumi.getter(name="startFlow")
    def start_flow(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the start flow in this agent. A start flow will be automatically created when the agent is created, and can only be deleted by deleting the agent. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        """
        return pulumi.get(self, "start_flow")

    @start_flow.setter
    def start_flow(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_flow", value)

    @_builtins.property
    @pulumi.getter(name="supportedLanguageCodes")
    def supported_language_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of all languages supported by this agent (except for the default_language_code).
        """
        return pulumi.get(self, "supported_language_codes")

    @supported_language_codes.setter
    def supported_language_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "supported_language_codes", value)

    @_builtins.property
    @pulumi.getter(name="textToSpeechSettings")
    def text_to_speech_settings(self) -> Optional[pulumi.Input['CxAgentTextToSpeechSettingsArgs']]:
        """
        Settings related to speech synthesizing.
        Structure is documented below.
        """
        return pulumi.get(self, "text_to_speech_settings")

    @text_to_speech_settings.setter
    def text_to_speech_settings(self, value: Optional[pulumi.Input['CxAgentTextToSpeechSettingsArgs']]):
        pulumi.set(self, "text_to_speech_settings", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York,
        Europe/Paris.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.type_token("gcp:diagflow/cxAgent:CxAgent")
class CxAgent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_settings: Optional[pulumi.Input[Union['CxAgentAdvancedSettingsArgs', 'CxAgentAdvancedSettingsArgsDict']]] = None,
                 avatar_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 default_language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_chat_engine_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_spell_correction: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 gen_app_builder_settings: Optional[pulumi.Input[Union['CxAgentGenAppBuilderSettingsArgs', 'CxAgentGenAppBuilderSettingsArgsDict']]] = None,
                 git_integration_settings: Optional[pulumi.Input[Union['CxAgentGitIntegrationSettingsArgs', 'CxAgentGitIntegrationSettingsArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 security_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 speech_to_text_settings: Optional[pulumi.Input[Union['CxAgentSpeechToTextSettingsArgs', 'CxAgentSpeechToTextSettingsArgsDict']]] = None,
                 supported_language_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 text_to_speech_settings: Optional[pulumi.Input[Union['CxAgentTextToSpeechSettingsArgs', 'CxAgentTextToSpeechSettingsArgsDict']]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Agents are best described as Natural Language Understanding (NLU) modules that transform user requests into actionable data. You can include agents in your app, product, or service to determine user intent and respond to the user in a natural way.

        To get more information about Agent, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Agent Full

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="dialogflowcx-bucket",
            location="US",
            uniform_bucket_level_access=True)
        full_agent = gcp.diagflow.CxAgent("full_agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            },
            advanced_settings={
                "audio_export_gcs_destination": {
                    "uri": bucket.url.apply(lambda url: f"{url}/prefix-"),
                },
                "speech_settings": {
                    "endpointer_sensitivity": 30,
                    "no_speech_timeout": "3.500s",
                    "use_timeout_based_endpointing": True,
                    "models": {
                        "name": "wrench",
                        "mass": "1.3kg",
                        "count": "3",
                    },
                },
                "dtmf_settings": {
                    "enabled": True,
                    "max_digits": 1,
                    "finish_digit": "#",
                },
                "logging_settings": {
                    "enable_stackdriver_logging": True,
                    "enable_interaction_logging": True,
                    "enable_consent_based_redaction": True,
                },
            },
            git_integration_settings={
                "github_settings": {
                    "display_name": "Github Repo",
                    "repository_uri": "https://api.github.com/repos/githubtraining/hellogitworld",
                    "tracking_branch": "main",
                    "access_token": "secret-token",
                    "branches": ["main"],
                },
            },
            text_to_speech_settings={
                "synthesize_speech_configs": json.dumps({
                    "en": {
                        "voice": {
                            "name": "en-US-Neural2-A",
                        },
                    },
                    "fr": {
                        "voice": {
                            "name": "fr-CA-Neural2-A",
                        },
                    },
                }),
            },
            gen_app_builder_settings={
                "engine": "projects/-/locations/-/collections/-/engines/-",
            })
        ```

        ## Import

        Agent can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/agents/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Agent can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxAgent:CxAgent default projects/{{project}}/locations/{{location}}/agents/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxAgent:CxAgent default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxAgent:CxAgent default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CxAgentAdvancedSettingsArgs', 'CxAgentAdvancedSettingsArgsDict']] advanced_settings: Hierarchical advanced settings for this agent. The settings exposed at the lower level overrides the settings exposed at the higher level.
               Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] avatar_uri: The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
        :param pulumi.Input[_builtins.str] default_language_code: The default language of the agent as a language tag. [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
               for a list of the currently supported language codes. This field cannot be updated after creation.
        :param pulumi.Input[_builtins.str] description: The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the agent, unique within the location.
        :param pulumi.Input[_builtins.bool] enable_spell_correction: Indicates if automatic spell correction is enabled in detect intent requests.
        :param pulumi.Input[_builtins.bool] enable_stackdriver_logging: (Optional, Deprecated)
               Determines whether this agent should log conversation queries.
               
               > **Warning:** `enable_stackdriver_logging` is deprecated and will be removed in a future major release. Please use `advanced_settings.logging_settings.enable_stackdriver_logging`instead.
        :param pulumi.Input[Union['CxAgentGenAppBuilderSettingsArgs', 'CxAgentGenAppBuilderSettingsArgsDict']] gen_app_builder_settings: Gen App Builder-related agent-level settings.
               Structure is documented below.
        :param pulumi.Input[Union['CxAgentGitIntegrationSettingsArgs', 'CxAgentGitIntegrationSettingsArgsDict']] git_integration_settings: Git integration settings for this agent.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The name of the location this agent is located in.
               > **Note:** The first time you are deploying an Agent in your project you must configure location settings.
               This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
               Another options is to use global location so you don't need to manually configure location settings.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] security_settings: Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        :param pulumi.Input[Union['CxAgentSpeechToTextSettingsArgs', 'CxAgentSpeechToTextSettingsArgsDict']] speech_to_text_settings: Settings related to speech recognition.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] supported_language_codes: The list of all languages supported by this agent (except for the default_language_code).
        :param pulumi.Input[Union['CxAgentTextToSpeechSettingsArgs', 'CxAgentTextToSpeechSettingsArgsDict']] text_to_speech_settings: Settings related to speech synthesizing.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York,
               Europe/Paris.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CxAgentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Agents are best described as Natural Language Understanding (NLU) modules that transform user requests into actionable data. You can include agents in your app, product, or service to determine user intent and respond to the user in a natural way.

        To get more information about Agent, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Agent Full

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="dialogflowcx-bucket",
            location="US",
            uniform_bucket_level_access=True)
        full_agent = gcp.diagflow.CxAgent("full_agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            },
            advanced_settings={
                "audio_export_gcs_destination": {
                    "uri": bucket.url.apply(lambda url: f"{url}/prefix-"),
                },
                "speech_settings": {
                    "endpointer_sensitivity": 30,
                    "no_speech_timeout": "3.500s",
                    "use_timeout_based_endpointing": True,
                    "models": {
                        "name": "wrench",
                        "mass": "1.3kg",
                        "count": "3",
                    },
                },
                "dtmf_settings": {
                    "enabled": True,
                    "max_digits": 1,
                    "finish_digit": "#",
                },
                "logging_settings": {
                    "enable_stackdriver_logging": True,
                    "enable_interaction_logging": True,
                    "enable_consent_based_redaction": True,
                },
            },
            git_integration_settings={
                "github_settings": {
                    "display_name": "Github Repo",
                    "repository_uri": "https://api.github.com/repos/githubtraining/hellogitworld",
                    "tracking_branch": "main",
                    "access_token": "secret-token",
                    "branches": ["main"],
                },
            },
            text_to_speech_settings={
                "synthesize_speech_configs": json.dumps({
                    "en": {
                        "voice": {
                            "name": "en-US-Neural2-A",
                        },
                    },
                    "fr": {
                        "voice": {
                            "name": "fr-CA-Neural2-A",
                        },
                    },
                }),
            },
            gen_app_builder_settings={
                "engine": "projects/-/locations/-/collections/-/engines/-",
            })
        ```

        ## Import

        Agent can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/agents/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Agent can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxAgent:CxAgent default projects/{{project}}/locations/{{location}}/agents/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxAgent:CxAgent default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxAgent:CxAgent default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CxAgentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CxAgentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_settings: Optional[pulumi.Input[Union['CxAgentAdvancedSettingsArgs', 'CxAgentAdvancedSettingsArgsDict']]] = None,
                 avatar_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 default_language_code: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_chat_engine_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_spell_correction: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[_builtins.bool]] = None,
                 gen_app_builder_settings: Optional[pulumi.Input[Union['CxAgentGenAppBuilderSettingsArgs', 'CxAgentGenAppBuilderSettingsArgsDict']]] = None,
                 git_integration_settings: Optional[pulumi.Input[Union['CxAgentGitIntegrationSettingsArgs', 'CxAgentGitIntegrationSettingsArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 security_settings: Optional[pulumi.Input[_builtins.str]] = None,
                 speech_to_text_settings: Optional[pulumi.Input[Union['CxAgentSpeechToTextSettingsArgs', 'CxAgentSpeechToTextSettingsArgsDict']]] = None,
                 supported_language_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 text_to_speech_settings: Optional[pulumi.Input[Union['CxAgentTextToSpeechSettingsArgs', 'CxAgentTextToSpeechSettingsArgsDict']]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CxAgentArgs.__new__(CxAgentArgs)

            __props__.__dict__["advanced_settings"] = advanced_settings
            __props__.__dict__["avatar_uri"] = avatar_uri
            if default_language_code is None and not opts.urn:
                raise TypeError("Missing required property 'default_language_code'")
            __props__.__dict__["default_language_code"] = default_language_code
            __props__.__dict__["delete_chat_engine_on_destroy"] = delete_chat_engine_on_destroy
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enable_spell_correction"] = enable_spell_correction
            __props__.__dict__["enable_stackdriver_logging"] = enable_stackdriver_logging
            __props__.__dict__["gen_app_builder_settings"] = gen_app_builder_settings
            __props__.__dict__["git_integration_settings"] = git_integration_settings
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["security_settings"] = security_settings
            __props__.__dict__["speech_to_text_settings"] = speech_to_text_settings
            __props__.__dict__["supported_language_codes"] = supported_language_codes
            __props__.__dict__["text_to_speech_settings"] = text_to_speech_settings
            if time_zone is None and not opts.urn:
                raise TypeError("Missing required property 'time_zone'")
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["name"] = None
            __props__.__dict__["start_flow"] = None
        super(CxAgent, __self__).__init__(
            'gcp:diagflow/cxAgent:CxAgent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_settings: Optional[pulumi.Input[Union['CxAgentAdvancedSettingsArgs', 'CxAgentAdvancedSettingsArgsDict']]] = None,
            avatar_uri: Optional[pulumi.Input[_builtins.str]] = None,
            default_language_code: Optional[pulumi.Input[_builtins.str]] = None,
            delete_chat_engine_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            enable_spell_correction: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_stackdriver_logging: Optional[pulumi.Input[_builtins.bool]] = None,
            gen_app_builder_settings: Optional[pulumi.Input[Union['CxAgentGenAppBuilderSettingsArgs', 'CxAgentGenAppBuilderSettingsArgsDict']]] = None,
            git_integration_settings: Optional[pulumi.Input[Union['CxAgentGitIntegrationSettingsArgs', 'CxAgentGitIntegrationSettingsArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            security_settings: Optional[pulumi.Input[_builtins.str]] = None,
            speech_to_text_settings: Optional[pulumi.Input[Union['CxAgentSpeechToTextSettingsArgs', 'CxAgentSpeechToTextSettingsArgsDict']]] = None,
            start_flow: Optional[pulumi.Input[_builtins.str]] = None,
            supported_language_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            text_to_speech_settings: Optional[pulumi.Input[Union['CxAgentTextToSpeechSettingsArgs', 'CxAgentTextToSpeechSettingsArgsDict']]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'CxAgent':
        """
        Get an existing CxAgent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CxAgentAdvancedSettingsArgs', 'CxAgentAdvancedSettingsArgsDict']] advanced_settings: Hierarchical advanced settings for this agent. The settings exposed at the lower level overrides the settings exposed at the higher level.
               Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] avatar_uri: The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
        :param pulumi.Input[_builtins.str] default_language_code: The default language of the agent as a language tag. [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
               for a list of the currently supported language codes. This field cannot be updated after creation.
        :param pulumi.Input[_builtins.str] description: The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the agent, unique within the location.
        :param pulumi.Input[_builtins.bool] enable_spell_correction: Indicates if automatic spell correction is enabled in detect intent requests.
        :param pulumi.Input[_builtins.bool] enable_stackdriver_logging: (Optional, Deprecated)
               Determines whether this agent should log conversation queries.
               
               > **Warning:** `enable_stackdriver_logging` is deprecated and will be removed in a future major release. Please use `advanced_settings.logging_settings.enable_stackdriver_logging`instead.
        :param pulumi.Input[Union['CxAgentGenAppBuilderSettingsArgs', 'CxAgentGenAppBuilderSettingsArgsDict']] gen_app_builder_settings: Gen App Builder-related agent-level settings.
               Structure is documented below.
        :param pulumi.Input[Union['CxAgentGitIntegrationSettingsArgs', 'CxAgentGitIntegrationSettingsArgsDict']] git_integration_settings: Git integration settings for this agent.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The name of the location this agent is located in.
               > **Note:** The first time you are deploying an Agent in your project you must configure location settings.
               This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
               Another options is to use global location so you don't need to manually configure location settings.
        :param pulumi.Input[_builtins.str] name: The unique identifier of the agent.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] security_settings: Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        :param pulumi.Input[Union['CxAgentSpeechToTextSettingsArgs', 'CxAgentSpeechToTextSettingsArgsDict']] speech_to_text_settings: Settings related to speech recognition.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] start_flow: Name of the start flow in this agent. A start flow will be automatically created when the agent is created, and can only be deleted by deleting the agent. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] supported_language_codes: The list of all languages supported by this agent (except for the default_language_code).
        :param pulumi.Input[Union['CxAgentTextToSpeechSettingsArgs', 'CxAgentTextToSpeechSettingsArgsDict']] text_to_speech_settings: Settings related to speech synthesizing.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] time_zone: The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York,
               Europe/Paris.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CxAgentState.__new__(_CxAgentState)

        __props__.__dict__["advanced_settings"] = advanced_settings
        __props__.__dict__["avatar_uri"] = avatar_uri
        __props__.__dict__["default_language_code"] = default_language_code
        __props__.__dict__["delete_chat_engine_on_destroy"] = delete_chat_engine_on_destroy
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enable_spell_correction"] = enable_spell_correction
        __props__.__dict__["enable_stackdriver_logging"] = enable_stackdriver_logging
        __props__.__dict__["gen_app_builder_settings"] = gen_app_builder_settings
        __props__.__dict__["git_integration_settings"] = git_integration_settings
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["security_settings"] = security_settings
        __props__.__dict__["speech_to_text_settings"] = speech_to_text_settings
        __props__.__dict__["start_flow"] = start_flow
        __props__.__dict__["supported_language_codes"] = supported_language_codes
        __props__.__dict__["text_to_speech_settings"] = text_to_speech_settings
        __props__.__dict__["time_zone"] = time_zone
        return CxAgent(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="advancedSettings")
    def advanced_settings(self) -> pulumi.Output['outputs.CxAgentAdvancedSettings']:
        """
        Hierarchical advanced settings for this agent. The settings exposed at the lower level overrides the settings exposed at the higher level.
        Hierarchy: Agent->Flow->Page->Fulfillment/Parameter.
        Structure is documented below.
        """
        return pulumi.get(self, "advanced_settings")

    @_builtins.property
    @pulumi.getter(name="avatarUri")
    def avatar_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URI of the agent's avatar. Avatars are used throughout the Dialogflow console and in the self-hosted Web Demo integration.
        """
        return pulumi.get(self, "avatar_uri")

    @_builtins.property
    @pulumi.getter(name="defaultLanguageCode")
    def default_language_code(self) -> pulumi.Output[_builtins.str]:
        """
        The default language of the agent as a language tag. [See Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language)
        for a list of the currently supported language codes. This field cannot be updated after creation.
        """
        return pulumi.get(self, "default_language_code")

    @_builtins.property
    @pulumi.getter(name="deleteChatEngineOnDestroy")
    def delete_chat_engine_on_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "delete_chat_engine_on_destroy")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of this agent. The maximum length is 500 characters. If exceeded, the request is rejected.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The human-readable name of the agent, unique within the location.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="enableSpellCorrection")
    def enable_spell_correction(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if automatic spell correction is enabled in detect intent requests.
        """
        return pulumi.get(self, "enable_spell_correction")

    @_builtins.property
    @pulumi.getter(name="enableStackdriverLogging")
    @_utilities.deprecated("""`enable_stackdriver_logging` is deprecated and will be removed in a future major release. Please use `advanced_settings.logging_settings.enable_stackdriver_logging`instead.""")
    def enable_stackdriver_logging(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Optional, Deprecated)
        Determines whether this agent should log conversation queries.

        > **Warning:** `enable_stackdriver_logging` is deprecated and will be removed in a future major release. Please use `advanced_settings.logging_settings.enable_stackdriver_logging`instead.
        """
        return pulumi.get(self, "enable_stackdriver_logging")

    @_builtins.property
    @pulumi.getter(name="genAppBuilderSettings")
    def gen_app_builder_settings(self) -> pulumi.Output['outputs.CxAgentGenAppBuilderSettings']:
        """
        Gen App Builder-related agent-level settings.
        Structure is documented below.
        """
        return pulumi.get(self, "gen_app_builder_settings")

    @_builtins.property
    @pulumi.getter(name="gitIntegrationSettings")
    def git_integration_settings(self) -> pulumi.Output[Optional['outputs.CxAgentGitIntegrationSettings']]:
        """
        Git integration settings for this agent.
        Structure is documented below.
        """
        return pulumi.get(self, "git_integration_settings")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the location this agent is located in.
        > **Note:** The first time you are deploying an Agent in your project you must configure location settings.
        This is a one time step but at the moment you can only [configure location settings](https://cloud.google.com/dialogflow/cx/docs/concept/region#location-settings) via the Dialogflow CX console.
        Another options is to use global location so you don't need to manually configure location settings.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the agent.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the SecuritySettings reference for the agent. Format: projects/<Project ID>/locations/<Location ID>/securitySettings/<Security Settings ID>.
        """
        return pulumi.get(self, "security_settings")

    @_builtins.property
    @pulumi.getter(name="speechToTextSettings")
    def speech_to_text_settings(self) -> pulumi.Output[Optional['outputs.CxAgentSpeechToTextSettings']]:
        """
        Settings related to speech recognition.
        Structure is documented below.
        """
        return pulumi.get(self, "speech_to_text_settings")

    @_builtins.property
    @pulumi.getter(name="startFlow")
    def start_flow(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the start flow in this agent. A start flow will be automatically created when the agent is created, and can only be deleted by deleting the agent. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
        """
        return pulumi.get(self, "start_flow")

    @_builtins.property
    @pulumi.getter(name="supportedLanguageCodes")
    def supported_language_codes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of all languages supported by this agent (except for the default_language_code).
        """
        return pulumi.get(self, "supported_language_codes")

    @_builtins.property
    @pulumi.getter(name="textToSpeechSettings")
    def text_to_speech_settings(self) -> pulumi.Output[Optional['outputs.CxAgentTextToSpeechSettings']]:
        """
        Settings related to speech synthesizing.
        Structure is documented below.
        """
        return pulumi.get(self, "text_to_speech_settings")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The time zone of this agent from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York,
        Europe/Paris.
        """
        return pulumi.get(self, "time_zone")

