# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CxPlaybookArgs', 'CxPlaybook']

@pulumi.input_type
class CxPlaybookArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 goal: pulumi.Input[_builtins.str],
                 instruction: Optional[pulumi.Input['CxPlaybookInstructionArgs']] = None,
                 llm_model_settings: Optional[pulumi.Input['CxPlaybookLlmModelSettingsArgs']] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 playbook_type: Optional[pulumi.Input[_builtins.str]] = None,
                 referenced_tools: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a CxPlaybook resource.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the playbook, unique within an agent.
        :param pulumi.Input[_builtins.str] goal: High level description of the goal the playbook intend to accomplish. A goal should be concise since it's visible to other playbooks that may reference this playbook.
        :param pulumi.Input['CxPlaybookInstructionArgs'] instruction: Instruction to accomplish target goal.
               Structure is documented below.
        :param pulumi.Input['CxPlaybookLlmModelSettingsArgs'] llm_model_settings: Llm model settings for the playbook.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] parent: The agent to create a Playbook for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[_builtins.str] playbook_type: Type of the playbook.
               Possible values are: `PLAYBOOK_TYPE_UNSPECIFIED`, `TASK`, `ROUTINE`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] referenced_tools: The resource name of tools referenced by the current playbook in the instructions. If not provided explicitly, they are will be implied using the tool being referenced in goal and steps.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "goal", goal)
        if instruction is not None:
            pulumi.set(__self__, "instruction", instruction)
        if llm_model_settings is not None:
            pulumi.set(__self__, "llm_model_settings", llm_model_settings)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if playbook_type is not None:
            pulumi.set(__self__, "playbook_type", playbook_type)
        if referenced_tools is not None:
            pulumi.set(__self__, "referenced_tools", referenced_tools)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The human-readable name of the playbook, unique within an agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def goal(self) -> pulumi.Input[_builtins.str]:
        """
        High level description of the goal the playbook intend to accomplish. A goal should be concise since it's visible to other playbooks that may reference this playbook.
        """
        return pulumi.get(self, "goal")

    @goal.setter
    def goal(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "goal", value)

    @_builtins.property
    @pulumi.getter
    def instruction(self) -> Optional[pulumi.Input['CxPlaybookInstructionArgs']]:
        """
        Instruction to accomplish target goal.
        Structure is documented below.
        """
        return pulumi.get(self, "instruction")

    @instruction.setter
    def instruction(self, value: Optional[pulumi.Input['CxPlaybookInstructionArgs']]):
        pulumi.set(self, "instruction", value)

    @_builtins.property
    @pulumi.getter(name="llmModelSettings")
    def llm_model_settings(self) -> Optional[pulumi.Input['CxPlaybookLlmModelSettingsArgs']]:
        """
        Llm model settings for the playbook.
        Structure is documented below.
        """
        return pulumi.get(self, "llm_model_settings")

    @llm_model_settings.setter
    def llm_model_settings(self, value: Optional[pulumi.Input['CxPlaybookLlmModelSettingsArgs']]):
        pulumi.set(self, "llm_model_settings", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The agent to create a Playbook for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="playbookType")
    def playbook_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the playbook.
        Possible values are: `PLAYBOOK_TYPE_UNSPECIFIED`, `TASK`, `ROUTINE`.
        """
        return pulumi.get(self, "playbook_type")

    @playbook_type.setter
    def playbook_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "playbook_type", value)

    @_builtins.property
    @pulumi.getter(name="referencedTools")
    def referenced_tools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The resource name of tools referenced by the current playbook in the instructions. If not provided explicitly, they are will be implied using the tool being referenced in goal and steps.
        """
        return pulumi.get(self, "referenced_tools")

    @referenced_tools.setter
    def referenced_tools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "referenced_tools", value)


@pulumi.input_type
class _CxPlaybookState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 goal: Optional[pulumi.Input[_builtins.str]] = None,
                 instruction: Optional[pulumi.Input['CxPlaybookInstructionArgs']] = None,
                 llm_model_settings: Optional[pulumi.Input['CxPlaybookLlmModelSettingsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 playbook_type: Optional[pulumi.Input[_builtins.str]] = None,
                 referenced_flows: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 referenced_playbooks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 referenced_tools: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 token_count: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CxPlaybook resources.
        :param pulumi.Input[_builtins.str] create_time: The timestamp of initial playbook creation.
               Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted. Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the playbook, unique within an agent.
        :param pulumi.Input[_builtins.str] goal: High level description of the goal the playbook intend to accomplish. A goal should be concise since it's visible to other playbooks that may reference this playbook.
        :param pulumi.Input['CxPlaybookInstructionArgs'] instruction: Instruction to accomplish target goal.
               Structure is documented below.
        :param pulumi.Input['CxPlaybookLlmModelSettingsArgs'] llm_model_settings: Llm model settings for the playbook.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The unique identifier of the Playbook.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/playbooks/<Playbook ID>.
        :param pulumi.Input[_builtins.str] parent: The agent to create a Playbook for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[_builtins.str] playbook_type: Type of the playbook.
               Possible values are: `PLAYBOOK_TYPE_UNSPECIFIED`, `TASK`, `ROUTINE`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] referenced_flows: The resource name of flows referenced by the current playbook in the instructions.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] referenced_playbooks: The resource name of other playbooks referenced by the current playbook in the instructions.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] referenced_tools: The resource name of tools referenced by the current playbook in the instructions. If not provided explicitly, they are will be implied using the tool being referenced in goal and steps.
        :param pulumi.Input[_builtins.str] token_count: Estimated number of tokes current playbook takes when sent to the LLM.
        :param pulumi.Input[_builtins.str] update_time: Last time the playbook version was updated.
               Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted. Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if goal is not None:
            pulumi.set(__self__, "goal", goal)
        if instruction is not None:
            pulumi.set(__self__, "instruction", instruction)
        if llm_model_settings is not None:
            pulumi.set(__self__, "llm_model_settings", llm_model_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if playbook_type is not None:
            pulumi.set(__self__, "playbook_type", playbook_type)
        if referenced_flows is not None:
            pulumi.set(__self__, "referenced_flows", referenced_flows)
        if referenced_playbooks is not None:
            pulumi.set(__self__, "referenced_playbooks", referenced_playbooks)
        if referenced_tools is not None:
            pulumi.set(__self__, "referenced_tools", referenced_tools)
        if token_count is not None:
            pulumi.set(__self__, "token_count", token_count)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of initial playbook creation.
        Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted. Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The human-readable name of the playbook, unique within an agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def goal(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        High level description of the goal the playbook intend to accomplish. A goal should be concise since it's visible to other playbooks that may reference this playbook.
        """
        return pulumi.get(self, "goal")

    @goal.setter
    def goal(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "goal", value)

    @_builtins.property
    @pulumi.getter
    def instruction(self) -> Optional[pulumi.Input['CxPlaybookInstructionArgs']]:
        """
        Instruction to accomplish target goal.
        Structure is documented below.
        """
        return pulumi.get(self, "instruction")

    @instruction.setter
    def instruction(self, value: Optional[pulumi.Input['CxPlaybookInstructionArgs']]):
        pulumi.set(self, "instruction", value)

    @_builtins.property
    @pulumi.getter(name="llmModelSettings")
    def llm_model_settings(self) -> Optional[pulumi.Input['CxPlaybookLlmModelSettingsArgs']]:
        """
        Llm model settings for the playbook.
        Structure is documented below.
        """
        return pulumi.get(self, "llm_model_settings")

    @llm_model_settings.setter
    def llm_model_settings(self, value: Optional[pulumi.Input['CxPlaybookLlmModelSettingsArgs']]):
        pulumi.set(self, "llm_model_settings", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the Playbook.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/playbooks/<Playbook ID>.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The agent to create a Playbook for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="playbookType")
    def playbook_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the playbook.
        Possible values are: `PLAYBOOK_TYPE_UNSPECIFIED`, `TASK`, `ROUTINE`.
        """
        return pulumi.get(self, "playbook_type")

    @playbook_type.setter
    def playbook_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "playbook_type", value)

    @_builtins.property
    @pulumi.getter(name="referencedFlows")
    def referenced_flows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The resource name of flows referenced by the current playbook in the instructions.
        """
        return pulumi.get(self, "referenced_flows")

    @referenced_flows.setter
    def referenced_flows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "referenced_flows", value)

    @_builtins.property
    @pulumi.getter(name="referencedPlaybooks")
    def referenced_playbooks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The resource name of other playbooks referenced by the current playbook in the instructions.
        """
        return pulumi.get(self, "referenced_playbooks")

    @referenced_playbooks.setter
    def referenced_playbooks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "referenced_playbooks", value)

    @_builtins.property
    @pulumi.getter(name="referencedTools")
    def referenced_tools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The resource name of tools referenced by the current playbook in the instructions. If not provided explicitly, they are will be implied using the tool being referenced in goal and steps.
        """
        return pulumi.get(self, "referenced_tools")

    @referenced_tools.setter
    def referenced_tools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "referenced_tools", value)

    @_builtins.property
    @pulumi.getter(name="tokenCount")
    def token_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Estimated number of tokes current playbook takes when sent to the LLM.
        """
        return pulumi.get(self, "token_count")

    @token_count.setter
    def token_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_count", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last time the playbook version was updated.
        Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted. Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:diagflow/cxPlaybook:CxPlaybook")
class CxPlaybook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 goal: Optional[pulumi.Input[_builtins.str]] = None,
                 instruction: Optional[pulumi.Input[Union['CxPlaybookInstructionArgs', 'CxPlaybookInstructionArgsDict']]] = None,
                 llm_model_settings: Optional[pulumi.Input[Union['CxPlaybookLlmModelSettingsArgs', 'CxPlaybookLlmModelSettingsArgsDict']]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 playbook_type: Optional[pulumi.Input[_builtins.str]] = None,
                 referenced_tools: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Playbook is the basic building block to instruct the LLM how to execute a certain task.

        To get more information about Playbook, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.playbooks)
        * How-to Guides
            * [Official CX Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Playbook Basic

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent-basic",
            location="global",
            default_language_code="en",
            time_zone="America/New_York",
            description="Example description.")
        my_playbook = gcp.diagflow.CxPlaybook("my-playbook",
            parent=agent.id,
            display_name="Example Display Name",
            goal="Example Goal",
            playbook_type="ROUTINE",
            instruction={
                "steps": [
                    {
                        "text": "step 1",
                        "steps": json.dumps([
                            {
                                "text": "step 1 1",
                            },
                            {
                                "text": "step 1 2",
                                "steps": [
                                    {
                                        "text": "step 1 2 1",
                                    },
                                    {
                                        "text": "step 1 2 2",
                                    },
                                ],
                            },
                            {
                                "text": "step 1 3",
                            },
                        ]),
                    },
                    {
                        "text": "step 2",
                    },
                    {
                        "text": "step 3",
                    },
                ],
            })
        ```
        ### Dialogflowcx Playbook Fulfillment

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            time_zone="America/New_York",
            description="Example description.")
        bucket = gcp.storage.Bucket("bucket",
            name="dialogflowcx-bucket",
            location="US",
            uniform_bucket_level_access=True)
        my_webhook = gcp.diagflow.CxWebhook("my_webhook",
            parent=agent.id,
            display_name="MyWebhook",
            generic_web_service={
                "uri": "https://example.com",
            })
        my_tool = gcp.diagflow.CxTool("my_tool",
            parent=agent.id,
            display_name="Example Tool",
            description="Example Description")
        my_generator = gcp.diagflow.CxGenerator("my_generator",
            parent=agent.id,
            display_name="TF Prompt generator",
            llm_model_settings={
                "model": "gemini-2.0-flash-001",
                "prompt_text": "Return me some great results",
            },
            prompt_text={
                "text": "Send me great results in french",
            },
            model_parameter={
                "temperature": 0.55,
            })
        my_playbook = gcp.diagflow.CxPlaybook("my-playbook",
            parent=agent.id,
            display_name="Playbook Example with Fulfillment",
            goal="Example Goal",
            instruction={
                "guidelines": "Example Guidelines",
                "steps": [
                    {
                        "text": "step 1",
                        "steps": json.dumps([
                            {
                                "text": "step 1 1",
                            },
                            {
                                "text": "step 1 2",
                                "steps": [
                                    {
                                        "text": "step 1 2 1",
                                    },
                                    {
                                        "text": "step 1 2 2",
                                    },
                                ],
                            },
                            {
                                "text": "step 1 3",
                            },
                        ]),
                    },
                    {
                        "text": "step 2",
                    },
                    {
                        "text": "step 3",
                    },
                ],
            },
            llm_model_settings={
                "model": "gemini-2.0-flash-001",
                "prompt_text": "Return me some great results",
            },
            referenced_tools=[my_tool.id])
        ```

        ## Import

        Playbook can be imported using any of these accepted formats:

        * `{{parent}}/playbooks/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, Playbook can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxPlaybook:CxPlaybook default {{parent}}/playbooks/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxPlaybook:CxPlaybook default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the playbook, unique within an agent.
        :param pulumi.Input[_builtins.str] goal: High level description of the goal the playbook intend to accomplish. A goal should be concise since it's visible to other playbooks that may reference this playbook.
        :param pulumi.Input[Union['CxPlaybookInstructionArgs', 'CxPlaybookInstructionArgsDict']] instruction: Instruction to accomplish target goal.
               Structure is documented below.
        :param pulumi.Input[Union['CxPlaybookLlmModelSettingsArgs', 'CxPlaybookLlmModelSettingsArgsDict']] llm_model_settings: Llm model settings for the playbook.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] parent: The agent to create a Playbook for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[_builtins.str] playbook_type: Type of the playbook.
               Possible values are: `PLAYBOOK_TYPE_UNSPECIFIED`, `TASK`, `ROUTINE`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] referenced_tools: The resource name of tools referenced by the current playbook in the instructions. If not provided explicitly, they are will be implied using the tool being referenced in goal and steps.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CxPlaybookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Playbook is the basic building block to instruct the LLM how to execute a certain task.

        To get more information about Playbook, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.playbooks)
        * How-to Guides
            * [Official CX Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Playbook Basic

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent-basic",
            location="global",
            default_language_code="en",
            time_zone="America/New_York",
            description="Example description.")
        my_playbook = gcp.diagflow.CxPlaybook("my-playbook",
            parent=agent.id,
            display_name="Example Display Name",
            goal="Example Goal",
            playbook_type="ROUTINE",
            instruction={
                "steps": [
                    {
                        "text": "step 1",
                        "steps": json.dumps([
                            {
                                "text": "step 1 1",
                            },
                            {
                                "text": "step 1 2",
                                "steps": [
                                    {
                                        "text": "step 1 2 1",
                                    },
                                    {
                                        "text": "step 1 2 2",
                                    },
                                ],
                            },
                            {
                                "text": "step 1 3",
                            },
                        ]),
                    },
                    {
                        "text": "step 2",
                    },
                    {
                        "text": "step 3",
                    },
                ],
            })
        ```
        ### Dialogflowcx Playbook Fulfillment

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            time_zone="America/New_York",
            description="Example description.")
        bucket = gcp.storage.Bucket("bucket",
            name="dialogflowcx-bucket",
            location="US",
            uniform_bucket_level_access=True)
        my_webhook = gcp.diagflow.CxWebhook("my_webhook",
            parent=agent.id,
            display_name="MyWebhook",
            generic_web_service={
                "uri": "https://example.com",
            })
        my_tool = gcp.diagflow.CxTool("my_tool",
            parent=agent.id,
            display_name="Example Tool",
            description="Example Description")
        my_generator = gcp.diagflow.CxGenerator("my_generator",
            parent=agent.id,
            display_name="TF Prompt generator",
            llm_model_settings={
                "model": "gemini-2.0-flash-001",
                "prompt_text": "Return me some great results",
            },
            prompt_text={
                "text": "Send me great results in french",
            },
            model_parameter={
                "temperature": 0.55,
            })
        my_playbook = gcp.diagflow.CxPlaybook("my-playbook",
            parent=agent.id,
            display_name="Playbook Example with Fulfillment",
            goal="Example Goal",
            instruction={
                "guidelines": "Example Guidelines",
                "steps": [
                    {
                        "text": "step 1",
                        "steps": json.dumps([
                            {
                                "text": "step 1 1",
                            },
                            {
                                "text": "step 1 2",
                                "steps": [
                                    {
                                        "text": "step 1 2 1",
                                    },
                                    {
                                        "text": "step 1 2 2",
                                    },
                                ],
                            },
                            {
                                "text": "step 1 3",
                            },
                        ]),
                    },
                    {
                        "text": "step 2",
                    },
                    {
                        "text": "step 3",
                    },
                ],
            },
            llm_model_settings={
                "model": "gemini-2.0-flash-001",
                "prompt_text": "Return me some great results",
            },
            referenced_tools=[my_tool.id])
        ```

        ## Import

        Playbook can be imported using any of these accepted formats:

        * `{{parent}}/playbooks/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, Playbook can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxPlaybook:CxPlaybook default {{parent}}/playbooks/{{name}}
        ```

        ```sh
        $ pulumi import gcp:diagflow/cxPlaybook:CxPlaybook default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CxPlaybookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CxPlaybookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 goal: Optional[pulumi.Input[_builtins.str]] = None,
                 instruction: Optional[pulumi.Input[Union['CxPlaybookInstructionArgs', 'CxPlaybookInstructionArgsDict']]] = None,
                 llm_model_settings: Optional[pulumi.Input[Union['CxPlaybookLlmModelSettingsArgs', 'CxPlaybookLlmModelSettingsArgsDict']]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 playbook_type: Optional[pulumi.Input[_builtins.str]] = None,
                 referenced_tools: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CxPlaybookArgs.__new__(CxPlaybookArgs)

            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if goal is None and not opts.urn:
                raise TypeError("Missing required property 'goal'")
            __props__.__dict__["goal"] = goal
            __props__.__dict__["instruction"] = instruction
            __props__.__dict__["llm_model_settings"] = llm_model_settings
            __props__.__dict__["parent"] = parent
            __props__.__dict__["playbook_type"] = playbook_type
            __props__.__dict__["referenced_tools"] = referenced_tools
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["referenced_flows"] = None
            __props__.__dict__["referenced_playbooks"] = None
            __props__.__dict__["token_count"] = None
            __props__.__dict__["update_time"] = None
        super(CxPlaybook, __self__).__init__(
            'gcp:diagflow/cxPlaybook:CxPlaybook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            goal: Optional[pulumi.Input[_builtins.str]] = None,
            instruction: Optional[pulumi.Input[Union['CxPlaybookInstructionArgs', 'CxPlaybookInstructionArgsDict']]] = None,
            llm_model_settings: Optional[pulumi.Input[Union['CxPlaybookLlmModelSettingsArgs', 'CxPlaybookLlmModelSettingsArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None,
            playbook_type: Optional[pulumi.Input[_builtins.str]] = None,
            referenced_flows: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            referenced_playbooks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            referenced_tools: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            token_count: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'CxPlaybook':
        """
        Get an existing CxPlaybook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The timestamp of initial playbook creation.
               Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted. Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the playbook, unique within an agent.
        :param pulumi.Input[_builtins.str] goal: High level description of the goal the playbook intend to accomplish. A goal should be concise since it's visible to other playbooks that may reference this playbook.
        :param pulumi.Input[Union['CxPlaybookInstructionArgs', 'CxPlaybookInstructionArgsDict']] instruction: Instruction to accomplish target goal.
               Structure is documented below.
        :param pulumi.Input[Union['CxPlaybookLlmModelSettingsArgs', 'CxPlaybookLlmModelSettingsArgsDict']] llm_model_settings: Llm model settings for the playbook.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The unique identifier of the Playbook.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/playbooks/<Playbook ID>.
        :param pulumi.Input[_builtins.str] parent: The agent to create a Playbook for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[_builtins.str] playbook_type: Type of the playbook.
               Possible values are: `PLAYBOOK_TYPE_UNSPECIFIED`, `TASK`, `ROUTINE`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] referenced_flows: The resource name of flows referenced by the current playbook in the instructions.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] referenced_playbooks: The resource name of other playbooks referenced by the current playbook in the instructions.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] referenced_tools: The resource name of tools referenced by the current playbook in the instructions. If not provided explicitly, they are will be implied using the tool being referenced in goal and steps.
        :param pulumi.Input[_builtins.str] token_count: Estimated number of tokes current playbook takes when sent to the LLM.
        :param pulumi.Input[_builtins.str] update_time: Last time the playbook version was updated.
               Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted. Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CxPlaybookState.__new__(_CxPlaybookState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["goal"] = goal
        __props__.__dict__["instruction"] = instruction
        __props__.__dict__["llm_model_settings"] = llm_model_settings
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["playbook_type"] = playbook_type
        __props__.__dict__["referenced_flows"] = referenced_flows
        __props__.__dict__["referenced_playbooks"] = referenced_playbooks
        __props__.__dict__["referenced_tools"] = referenced_tools
        __props__.__dict__["token_count"] = token_count
        __props__.__dict__["update_time"] = update_time
        return CxPlaybook(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of initial playbook creation.
        Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted. Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The human-readable name of the playbook, unique within an agent.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def goal(self) -> pulumi.Output[_builtins.str]:
        """
        High level description of the goal the playbook intend to accomplish. A goal should be concise since it's visible to other playbooks that may reference this playbook.
        """
        return pulumi.get(self, "goal")

    @_builtins.property
    @pulumi.getter
    def instruction(self) -> pulumi.Output[Optional['outputs.CxPlaybookInstruction']]:
        """
        Instruction to accomplish target goal.
        Structure is documented below.
        """
        return pulumi.get(self, "instruction")

    @_builtins.property
    @pulumi.getter(name="llmModelSettings")
    def llm_model_settings(self) -> pulumi.Output[Optional['outputs.CxPlaybookLlmModelSettings']]:
        """
        Llm model settings for the playbook.
        Structure is documented below.
        """
        return pulumi.get(self, "llm_model_settings")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the Playbook.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/playbooks/<Playbook ID>.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The agent to create a Playbook for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter(name="playbookType")
    def playbook_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type of the playbook.
        Possible values are: `PLAYBOOK_TYPE_UNSPECIFIED`, `TASK`, `ROUTINE`.
        """
        return pulumi.get(self, "playbook_type")

    @_builtins.property
    @pulumi.getter(name="referencedFlows")
    def referenced_flows(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The resource name of flows referenced by the current playbook in the instructions.
        """
        return pulumi.get(self, "referenced_flows")

    @_builtins.property
    @pulumi.getter(name="referencedPlaybooks")
    def referenced_playbooks(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The resource name of other playbooks referenced by the current playbook in the instructions.
        """
        return pulumi.get(self, "referenced_playbooks")

    @_builtins.property
    @pulumi.getter(name="referencedTools")
    def referenced_tools(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The resource name of tools referenced by the current playbook in the instructions. If not provided explicitly, they are will be implied using the tool being referenced in goal and steps.
        """
        return pulumi.get(self, "referenced_tools")

    @_builtins.property
    @pulumi.getter(name="tokenCount")
    def token_count(self) -> pulumi.Output[_builtins.str]:
        """
        Estimated number of tokes current playbook takes when sent to the LLM.
        """
        return pulumi.get(self, "token_count")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Last time the playbook version was updated.
        Uses RFC 3339, where generated output will always be Z-normalized and uses 0, 3, 6 or 9 fractional digits. Offsets other than "Z" are also accepted. Examples: "2014-10-02T15:01:23Z", "2014-10-02T15:01:23.045123456Z" or "2014-10-02T15:01:23+05:30".
        """
        return pulumi.get(self, "update_time")

