# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CxTestCaseArgs', 'CxTestCase']

@pulumi.input_type
class CxTestCaseArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 test_case_conversation_turns: Optional[pulumi.Input[Sequence[pulumi.Input['CxTestCaseTestCaseConversationTurnArgs']]]] = None,
                 test_config: Optional[pulumi.Input['CxTestCaseTestConfigArgs']] = None):
        """
        The set of arguments for constructing a CxTestCase resource.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the test case, unique within the agent. Limit of 200 characters.
        :param pulumi.Input[_builtins.str] notes: Additional freeform notes about the test case. Limit of 400 characters.
        :param pulumi.Input[_builtins.str] parent: The agent to create the test case for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags are short descriptions that users may apply to test cases for organizational and filtering purposes.
               Each tag should start with "#" and has a limit of 30 characters
        :param pulumi.Input[Sequence[pulumi.Input['CxTestCaseTestCaseConversationTurnArgs']]] test_case_conversation_turns: The conversation turns uttered when the test case was created, in chronological order. These include the canonical set of agent utterances that should occur when the agent is working properly.
               Structure is documented below.
        :param pulumi.Input['CxTestCaseTestConfigArgs'] test_config: Config for the test case.
               Structure is documented below.
        """
        pulumi.set(__self__, "display_name", display_name)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if test_case_conversation_turns is not None:
            pulumi.set(__self__, "test_case_conversation_turns", test_case_conversation_turns)
        if test_config is not None:
            pulumi.set(__self__, "test_config", test_config)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The human-readable name of the test case, unique within the agent. Limit of 200 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional freeform notes about the test case. Limit of 400 characters.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notes", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The agent to create the test case for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags are short descriptions that users may apply to test cases for organizational and filtering purposes.
        Each tag should start with "#" and has a limit of 30 characters
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="testCaseConversationTurns")
    def test_case_conversation_turns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxTestCaseTestCaseConversationTurnArgs']]]]:
        """
        The conversation turns uttered when the test case was created, in chronological order. These include the canonical set of agent utterances that should occur when the agent is working properly.
        Structure is documented below.
        """
        return pulumi.get(self, "test_case_conversation_turns")

    @test_case_conversation_turns.setter
    def test_case_conversation_turns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxTestCaseTestCaseConversationTurnArgs']]]]):
        pulumi.set(self, "test_case_conversation_turns", value)

    @_builtins.property
    @pulumi.getter(name="testConfig")
    def test_config(self) -> Optional[pulumi.Input['CxTestCaseTestConfigArgs']]:
        """
        Config for the test case.
        Structure is documented below.
        """
        return pulumi.get(self, "test_config")

    @test_config.setter
    def test_config(self, value: Optional[pulumi.Input['CxTestCaseTestConfigArgs']]):
        pulumi.set(self, "test_config", value)


@pulumi.input_type
class _CxTestCaseState:
    def __init__(__self__, *,
                 creation_time: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 last_test_results: Optional[pulumi.Input[Sequence[pulumi.Input['CxTestCaseLastTestResultArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 test_case_conversation_turns: Optional[pulumi.Input[Sequence[pulumi.Input['CxTestCaseTestCaseConversationTurnArgs']]]] = None,
                 test_config: Optional[pulumi.Input['CxTestCaseTestConfigArgs']] = None):
        """
        Input properties used for looking up and filtering CxTestCase resources.
        :param pulumi.Input[_builtins.str] creation_time: When the test was created. A timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the test case, unique within the agent. Limit of 200 characters.
        :param pulumi.Input[Sequence[pulumi.Input['CxTestCaseLastTestResultArgs']]] last_test_results: The latest test result.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The unique identifier of the page.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
        :param pulumi.Input[_builtins.str] notes: Additional freeform notes about the test case. Limit of 400 characters.
        :param pulumi.Input[_builtins.str] parent: The agent to create the test case for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags are short descriptions that users may apply to test cases for organizational and filtering purposes.
               Each tag should start with "#" and has a limit of 30 characters
        :param pulumi.Input[Sequence[pulumi.Input['CxTestCaseTestCaseConversationTurnArgs']]] test_case_conversation_turns: The conversation turns uttered when the test case was created, in chronological order. These include the canonical set of agent utterances that should occur when the agent is working properly.
               Structure is documented below.
        :param pulumi.Input['CxTestCaseTestConfigArgs'] test_config: Config for the test case.
               Structure is documented below.
        """
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if last_test_results is not None:
            pulumi.set(__self__, "last_test_results", last_test_results)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if test_case_conversation_turns is not None:
            pulumi.set(__self__, "test_case_conversation_turns", test_case_conversation_turns)
        if test_config is not None:
            pulumi.set(__self__, "test_config", test_config)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the test was created. A timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The human-readable name of the test case, unique within the agent. Limit of 200 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="lastTestResults")
    def last_test_results(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxTestCaseLastTestResultArgs']]]]:
        """
        The latest test result.
        Structure is documented below.
        """
        return pulumi.get(self, "last_test_results")

    @last_test_results.setter
    def last_test_results(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxTestCaseLastTestResultArgs']]]]):
        pulumi.set(self, "last_test_results", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the page.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional freeform notes about the test case. Limit of 400 characters.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notes", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The agent to create the test case for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags are short descriptions that users may apply to test cases for organizational and filtering purposes.
        Each tag should start with "#" and has a limit of 30 characters
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="testCaseConversationTurns")
    def test_case_conversation_turns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxTestCaseTestCaseConversationTurnArgs']]]]:
        """
        The conversation turns uttered when the test case was created, in chronological order. These include the canonical set of agent utterances that should occur when the agent is working properly.
        Structure is documented below.
        """
        return pulumi.get(self, "test_case_conversation_turns")

    @test_case_conversation_turns.setter
    def test_case_conversation_turns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxTestCaseTestCaseConversationTurnArgs']]]]):
        pulumi.set(self, "test_case_conversation_turns", value)

    @_builtins.property
    @pulumi.getter(name="testConfig")
    def test_config(self) -> Optional[pulumi.Input['CxTestCaseTestConfigArgs']]:
        """
        Config for the test case.
        Structure is documented below.
        """
        return pulumi.get(self, "test_config")

    @test_config.setter
    def test_config(self, value: Optional[pulumi.Input['CxTestCaseTestConfigArgs']]):
        pulumi.set(self, "test_config", value)


@pulumi.type_token("gcp:diagflow/cxTestCase:CxTestCase")
class CxTestCase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 test_case_conversation_turns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxTestCaseTestCaseConversationTurnArgs', 'CxTestCaseTestCaseConversationTurnArgsDict']]]]] = None,
                 test_config: Optional[pulumi.Input[Union['CxTestCaseTestConfigArgs', 'CxTestCaseTestConfigArgsDict']]] = None,
                 __props__=None):
        """
        You can use the built-in test feature to uncover bugs and prevent regressions. A test execution verifies that agent responses have not changed for end-user inputs defined in the test case.

        To get more information about TestCase, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.testCases)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Test Case Full

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://storage.cloud.google.com/dialogflow-test-host-image/cloud-logo.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        intent = gcp.diagflow.CxIntent("intent",
            parent=agent.id,
            display_name="MyIntent",
            priority=1,
            training_phrases=[{
                "parts": [{
                    "text": "training phrase",
                }],
                "repeat_count": 1,
            }])
        page = gcp.diagflow.CxPage("page",
            parent=agent.start_flow,
            display_name="MyPage",
            transition_routes=[{
                "intent": intent.id,
                "trigger_fulfillment": {
                    "messages": [{
                        "text": {
                            "texts": ["Training phrase response"],
                        },
                    }],
                },
            }],
            event_handlers=[{
                "event": "some-event",
                "trigger_fulfillment": {
                    "messages": [{
                        "text": {
                            "texts": ["Handling some event"],
                        },
                    }],
                },
            }])
        basic_test_case = gcp.diagflow.CxTestCase("basic_test_case",
            parent=agent.id,
            display_name="MyTestCase",
            tags=["#tag1"],
            notes="demonstrates a simple training phrase response",
            test_config={
                "tracking_parameters": ["some_param"],
                "page": page.id,
            },
            test_case_conversation_turns=[
                {
                    "user_input": {
                        "input": {
                            "language_code": "en",
                            "text": {
                                "text": "training phrase",
                            },
                        },
                        "injected_parameters": json.dumps({
                            "some_param": "1",
                        }),
                        "is_webhook_enabled": True,
                        "enable_sentiment_analysis": True,
                    },
                    "virtual_agent_output": {
                        "session_parameters": json.dumps({
                            "some_param": "1",
                        }),
                        "triggered_intent": {
                            "name": intent.id,
                        },
                        "current_page": {
                            "name": page.id,
                        },
                        "text_responses": [{
                            "texts": ["Training phrase response"],
                        }],
                    },
                },
                {
                    "user_input": {
                        "input": {
                            "event": {
                                "event": "some-event",
                            },
                        },
                    },
                    "virtual_agent_output": {
                        "current_page": {
                            "name": page.id,
                        },
                        "text_responses": [{
                            "texts": ["Handling some event"],
                        }],
                    },
                },
                {
                    "user_input": {
                        "input": {
                            "dtmf": {
                                "digits": "12",
                                "finish_digit": "3",
                            },
                        },
                    },
                    "virtual_agent_output": {
                        "text_responses": [{
                            "texts": ["I didn't get that. Can you say it again?"],
                        }],
                    },
                },
            ])
        ```

        ## Import

        TestCase can be imported using any of these accepted formats:

        * `{{parent}}/testCases/{{name}}`

        When using the `pulumi import` command, TestCase can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxTestCase:CxTestCase default {{parent}}/testCases/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the test case, unique within the agent. Limit of 200 characters.
        :param pulumi.Input[_builtins.str] notes: Additional freeform notes about the test case. Limit of 400 characters.
        :param pulumi.Input[_builtins.str] parent: The agent to create the test case for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags are short descriptions that users may apply to test cases for organizational and filtering purposes.
               Each tag should start with "#" and has a limit of 30 characters
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxTestCaseTestCaseConversationTurnArgs', 'CxTestCaseTestCaseConversationTurnArgsDict']]]] test_case_conversation_turns: The conversation turns uttered when the test case was created, in chronological order. These include the canonical set of agent utterances that should occur when the agent is working properly.
               Structure is documented below.
        :param pulumi.Input[Union['CxTestCaseTestConfigArgs', 'CxTestCaseTestConfigArgsDict']] test_config: Config for the test case.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CxTestCaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        You can use the built-in test feature to uncover bugs and prevent regressions. A test execution verifies that agent responses have not changed for end-user inputs defined in the test case.

        To get more information about TestCase, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.testCases)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage

        ### Dialogflowcx Test Case Full

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://storage.cloud.google.com/dialogflow-test-host-image/cloud-logo.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings={
                "enable_speech_adaptation": True,
            })
        intent = gcp.diagflow.CxIntent("intent",
            parent=agent.id,
            display_name="MyIntent",
            priority=1,
            training_phrases=[{
                "parts": [{
                    "text": "training phrase",
                }],
                "repeat_count": 1,
            }])
        page = gcp.diagflow.CxPage("page",
            parent=agent.start_flow,
            display_name="MyPage",
            transition_routes=[{
                "intent": intent.id,
                "trigger_fulfillment": {
                    "messages": [{
                        "text": {
                            "texts": ["Training phrase response"],
                        },
                    }],
                },
            }],
            event_handlers=[{
                "event": "some-event",
                "trigger_fulfillment": {
                    "messages": [{
                        "text": {
                            "texts": ["Handling some event"],
                        },
                    }],
                },
            }])
        basic_test_case = gcp.diagflow.CxTestCase("basic_test_case",
            parent=agent.id,
            display_name="MyTestCase",
            tags=["#tag1"],
            notes="demonstrates a simple training phrase response",
            test_config={
                "tracking_parameters": ["some_param"],
                "page": page.id,
            },
            test_case_conversation_turns=[
                {
                    "user_input": {
                        "input": {
                            "language_code": "en",
                            "text": {
                                "text": "training phrase",
                            },
                        },
                        "injected_parameters": json.dumps({
                            "some_param": "1",
                        }),
                        "is_webhook_enabled": True,
                        "enable_sentiment_analysis": True,
                    },
                    "virtual_agent_output": {
                        "session_parameters": json.dumps({
                            "some_param": "1",
                        }),
                        "triggered_intent": {
                            "name": intent.id,
                        },
                        "current_page": {
                            "name": page.id,
                        },
                        "text_responses": [{
                            "texts": ["Training phrase response"],
                        }],
                    },
                },
                {
                    "user_input": {
                        "input": {
                            "event": {
                                "event": "some-event",
                            },
                        },
                    },
                    "virtual_agent_output": {
                        "current_page": {
                            "name": page.id,
                        },
                        "text_responses": [{
                            "texts": ["Handling some event"],
                        }],
                    },
                },
                {
                    "user_input": {
                        "input": {
                            "dtmf": {
                                "digits": "12",
                                "finish_digit": "3",
                            },
                        },
                    },
                    "virtual_agent_output": {
                        "text_responses": [{
                            "texts": ["I didn't get that. Can you say it again?"],
                        }],
                    },
                },
            ])
        ```

        ## Import

        TestCase can be imported using any of these accepted formats:

        * `{{parent}}/testCases/{{name}}`

        When using the `pulumi import` command, TestCase can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:diagflow/cxTestCase:CxTestCase default {{parent}}/testCases/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CxTestCaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CxTestCaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 test_case_conversation_turns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxTestCaseTestCaseConversationTurnArgs', 'CxTestCaseTestCaseConversationTurnArgsDict']]]]] = None,
                 test_config: Optional[pulumi.Input[Union['CxTestCaseTestConfigArgs', 'CxTestCaseTestConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CxTestCaseArgs.__new__(CxTestCaseArgs)

            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["notes"] = notes
            __props__.__dict__["parent"] = parent
            __props__.__dict__["tags"] = tags
            __props__.__dict__["test_case_conversation_turns"] = test_case_conversation_turns
            __props__.__dict__["test_config"] = test_config
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["last_test_results"] = None
            __props__.__dict__["name"] = None
        super(CxTestCase, __self__).__init__(
            'gcp:diagflow/cxTestCase:CxTestCase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_time: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            last_test_results: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxTestCaseLastTestResultArgs', 'CxTestCaseLastTestResultArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notes: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            test_case_conversation_turns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CxTestCaseTestCaseConversationTurnArgs', 'CxTestCaseTestCaseConversationTurnArgsDict']]]]] = None,
            test_config: Optional[pulumi.Input[Union['CxTestCaseTestConfigArgs', 'CxTestCaseTestConfigArgsDict']]] = None) -> 'CxTestCase':
        """
        Get an existing CxTestCase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] creation_time: When the test was created. A timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] display_name: The human-readable name of the test case, unique within the agent. Limit of 200 characters.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxTestCaseLastTestResultArgs', 'CxTestCaseLastTestResultArgsDict']]]] last_test_results: The latest test result.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The unique identifier of the page.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
        :param pulumi.Input[_builtins.str] notes: Additional freeform notes about the test case. Limit of 400 characters.
        :param pulumi.Input[_builtins.str] parent: The agent to create the test case for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags are short descriptions that users may apply to test cases for organizational and filtering purposes.
               Each tag should start with "#" and has a limit of 30 characters
        :param pulumi.Input[Sequence[pulumi.Input[Union['CxTestCaseTestCaseConversationTurnArgs', 'CxTestCaseTestCaseConversationTurnArgsDict']]]] test_case_conversation_turns: The conversation turns uttered when the test case was created, in chronological order. These include the canonical set of agent utterances that should occur when the agent is working properly.
               Structure is documented below.
        :param pulumi.Input[Union['CxTestCaseTestConfigArgs', 'CxTestCaseTestConfigArgsDict']] test_config: Config for the test case.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CxTestCaseState.__new__(_CxTestCaseState)

        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["last_test_results"] = last_test_results
        __props__.__dict__["name"] = name
        __props__.__dict__["notes"] = notes
        __props__.__dict__["parent"] = parent
        __props__.__dict__["tags"] = tags
        __props__.__dict__["test_case_conversation_turns"] = test_case_conversation_turns
        __props__.__dict__["test_config"] = test_config
        return CxTestCase(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[_builtins.str]:
        """
        When the test was created. A timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The human-readable name of the test case, unique within the agent. Limit of 200 characters.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="lastTestResults")
    def last_test_results(self) -> pulumi.Output[Sequence['outputs.CxTestCaseLastTestResult']]:
        """
        The latest test result.
        Structure is documented below.
        """
        return pulumi.get(self, "last_test_results")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the page.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def notes(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Additional freeform notes about the test case. Limit of 400 characters.
        """
        return pulumi.get(self, "notes")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The agent to create the test case for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags are short descriptions that users may apply to test cases for organizational and filtering purposes.
        Each tag should start with "#" and has a limit of 30 characters
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="testCaseConversationTurns")
    def test_case_conversation_turns(self) -> pulumi.Output[Optional[Sequence['outputs.CxTestCaseTestCaseConversationTurn']]]:
        """
        The conversation turns uttered when the test case was created, in chronological order. These include the canonical set of agent utterances that should occur when the agent is working properly.
        Structure is documented below.
        """
        return pulumi.get(self, "test_case_conversation_turns")

    @_builtins.property
    @pulumi.getter(name="testConfig")
    def test_config(self) -> pulumi.Output[Optional['outputs.CxTestCaseTestConfig']]:
        """
        Config for the test case.
        Structure is documented below.
        """
        return pulumi.get(self, "test_config")

