# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RecommendationEngineArgs', 'RecommendationEngine']

@pulumi.input_type
class RecommendationEngineArgs:
    def __init__(__self__, *,
                 data_store_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 display_name: pulumi.Input[_builtins.str],
                 engine_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 common_config: Optional[pulumi.Input['RecommendationEngineCommonConfigArgs']] = None,
                 industry_vertical: Optional[pulumi.Input[_builtins.str]] = None,
                 media_recommendation_engine_config: Optional[pulumi.Input['RecommendationEngineMediaRecommendationEngineConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RecommendationEngine resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_store_ids: The data stores associated with this engine. For SOLUTION_TYPE_RECOMMENDATION type of engines, they can only associate with at most one data store.
        :param pulumi.Input[_builtins.str] display_name: Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        :param pulumi.Input[_builtins.str] engine_id: Unique ID to use for Recommendation Engine.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input['RecommendationEngineCommonConfigArgs'] common_config: Common config spec that specifies the metadata of the engine.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] industry_vertical: The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: If unspecified, default to GENERIC. Vertical on Engine has to match vertical of the DataStore liniked to the engine.
               Default value is `GENERIC`.
               Possible values are: `GENERIC`, `MEDIA`.
        :param pulumi.Input['RecommendationEngineMediaRecommendationEngineConfigArgs'] media_recommendation_engine_config: Configurations for a Media Recommendation Engine. Only applicable on the data stores
               with SOLUTION_TYPE_RECOMMENDATION solution type and MEDIA industry vertical.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "data_store_ids", data_store_ids)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "engine_id", engine_id)
        pulumi.set(__self__, "location", location)
        if common_config is not None:
            pulumi.set(__self__, "common_config", common_config)
        if industry_vertical is not None:
            pulumi.set(__self__, "industry_vertical", industry_vertical)
        if media_recommendation_engine_config is not None:
            pulumi.set(__self__, "media_recommendation_engine_config", media_recommendation_engine_config)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="dataStoreIds")
    def data_store_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The data stores associated with this engine. For SOLUTION_TYPE_RECOMMENDATION type of engines, they can only associate with at most one data store.
        """
        return pulumi.get(self, "data_store_ids")

    @data_store_ids.setter
    def data_store_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "data_store_ids", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique ID to use for Recommendation Engine.
        """
        return pulumi.get(self, "engine_id")

    @engine_id.setter
    def engine_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="commonConfig")
    def common_config(self) -> Optional[pulumi.Input['RecommendationEngineCommonConfigArgs']]:
        """
        Common config spec that specifies the metadata of the engine.
        Structure is documented below.
        """
        return pulumi.get(self, "common_config")

    @common_config.setter
    def common_config(self, value: Optional[pulumi.Input['RecommendationEngineCommonConfigArgs']]):
        pulumi.set(self, "common_config", value)

    @_builtins.property
    @pulumi.getter(name="industryVertical")
    def industry_vertical(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: If unspecified, default to GENERIC. Vertical on Engine has to match vertical of the DataStore liniked to the engine.
        Default value is `GENERIC`.
        Possible values are: `GENERIC`, `MEDIA`.
        """
        return pulumi.get(self, "industry_vertical")

    @industry_vertical.setter
    def industry_vertical(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "industry_vertical", value)

    @_builtins.property
    @pulumi.getter(name="mediaRecommendationEngineConfig")
    def media_recommendation_engine_config(self) -> Optional[pulumi.Input['RecommendationEngineMediaRecommendationEngineConfigArgs']]:
        """
        Configurations for a Media Recommendation Engine. Only applicable on the data stores
        with SOLUTION_TYPE_RECOMMENDATION solution type and MEDIA industry vertical.
        Structure is documented below.
        """
        return pulumi.get(self, "media_recommendation_engine_config")

    @media_recommendation_engine_config.setter
    def media_recommendation_engine_config(self, value: Optional[pulumi.Input['RecommendationEngineMediaRecommendationEngineConfigArgs']]):
        pulumi.set(self, "media_recommendation_engine_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _RecommendationEngineState:
    def __init__(__self__, *,
                 common_config: Optional[pulumi.Input['RecommendationEngineCommonConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 data_store_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 industry_vertical: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 media_recommendation_engine_config: Optional[pulumi.Input['RecommendationEngineMediaRecommendationEngineConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RecommendationEngine resources.
        :param pulumi.Input['RecommendationEngineCommonConfigArgs'] common_config: Common config spec that specifies the metadata of the engine.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Timestamp the Engine was created at.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_store_ids: The data stores associated with this engine. For SOLUTION_TYPE_RECOMMENDATION type of engines, they can only associate with at most one data store.
        :param pulumi.Input[_builtins.str] display_name: Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        :param pulumi.Input[_builtins.str] engine_id: Unique ID to use for Recommendation Engine.
        :param pulumi.Input[_builtins.str] industry_vertical: The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: If unspecified, default to GENERIC. Vertical on Engine has to match vertical of the DataStore liniked to the engine.
               Default value is `GENERIC`.
               Possible values are: `GENERIC`, `MEDIA`.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input['RecommendationEngineMediaRecommendationEngineConfigArgs'] media_recommendation_engine_config: Configurations for a Media Recommendation Engine. Only applicable on the data stores
               with SOLUTION_TYPE_RECOMMENDATION solution type and MEDIA industry vertical.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The unique full resource name of the recommendation engine. Values are of the format
               `projects/{project}/locations/{location}/collections/{collection}/engines/{engine_id}`.
               This field must be a UTF-8 encoded string with a length limit of 1024 characters.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] update_time: Timestamp the Engine was last updated.
        """
        if common_config is not None:
            pulumi.set(__self__, "common_config", common_config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_store_ids is not None:
            pulumi.set(__self__, "data_store_ids", data_store_ids)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if engine_id is not None:
            pulumi.set(__self__, "engine_id", engine_id)
        if industry_vertical is not None:
            pulumi.set(__self__, "industry_vertical", industry_vertical)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if media_recommendation_engine_config is not None:
            pulumi.set(__self__, "media_recommendation_engine_config", media_recommendation_engine_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="commonConfig")
    def common_config(self) -> Optional[pulumi.Input['RecommendationEngineCommonConfigArgs']]:
        """
        Common config spec that specifies the metadata of the engine.
        Structure is documented below.
        """
        return pulumi.get(self, "common_config")

    @common_config.setter
    def common_config(self, value: Optional[pulumi.Input['RecommendationEngineCommonConfigArgs']]):
        pulumi.set(self, "common_config", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp the Engine was created at.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="dataStoreIds")
    def data_store_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The data stores associated with this engine. For SOLUTION_TYPE_RECOMMENDATION type of engines, they can only associate with at most one data store.
        """
        return pulumi.get(self, "data_store_ids")

    @data_store_ids.setter
    def data_store_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "data_store_ids", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique ID to use for Recommendation Engine.
        """
        return pulumi.get(self, "engine_id")

    @engine_id.setter
    def engine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_id", value)

    @_builtins.property
    @pulumi.getter(name="industryVertical")
    def industry_vertical(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: If unspecified, default to GENERIC. Vertical on Engine has to match vertical of the DataStore liniked to the engine.
        Default value is `GENERIC`.
        Possible values are: `GENERIC`, `MEDIA`.
        """
        return pulumi.get(self, "industry_vertical")

    @industry_vertical.setter
    def industry_vertical(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "industry_vertical", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="mediaRecommendationEngineConfig")
    def media_recommendation_engine_config(self) -> Optional[pulumi.Input['RecommendationEngineMediaRecommendationEngineConfigArgs']]:
        """
        Configurations for a Media Recommendation Engine. Only applicable on the data stores
        with SOLUTION_TYPE_RECOMMENDATION solution type and MEDIA industry vertical.
        Structure is documented below.
        """
        return pulumi.get(self, "media_recommendation_engine_config")

    @media_recommendation_engine_config.setter
    def media_recommendation_engine_config(self, value: Optional[pulumi.Input['RecommendationEngineMediaRecommendationEngineConfigArgs']]):
        pulumi.set(self, "media_recommendation_engine_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique full resource name of the recommendation engine. Values are of the format
        `projects/{project}/locations/{location}/collections/{collection}/engines/{engine_id}`.
        This field must be a UTF-8 encoded string with a length limit of 1024 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp the Engine was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:discoveryengine/recommendationEngine:RecommendationEngine")
class RecommendationEngine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 common_config: Optional[pulumi.Input[Union['RecommendationEngineCommonConfigArgs', 'RecommendationEngineCommonConfigArgsDict']]] = None,
                 data_store_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 industry_vertical: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 media_recommendation_engine_config: Optional[pulumi.Input[Union['RecommendationEngineMediaRecommendationEngineConfigArgs', 'RecommendationEngineMediaRecommendationEngineConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Vertex AI Search recommendation apps.

        To get more information about RecommendationEngine, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1/projects.locations.collections.engines)
        * How-to Guides
            * [Create a Recommendation Engine](https://cloud.google.com/generative-ai-app-builder/docs/create-generic-recommendations-app)

        ## Example Usage

        ### Discoveryengine Recommendationengine Generic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        generic = gcp.discoveryengine.DataStore("generic",
            location="global",
            data_store_id="recommendation-datastore-id",
            display_name="tf-test-structured-datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_RECOMMENDATION"],
            create_advanced_site_search=False,
            skip_default_schema_creation=False)
        generic_recommendation_engine = gcp.discoveryengine.RecommendationEngine("generic",
            engine_id="recommendation-engine-id",
            location=generic.location,
            display_name="Example Recommendation Engine",
            data_store_ids=[generic.data_store_id],
            industry_vertical="GENERIC",
            common_config={
                "company_name": "test-company",
            })
        ```
        ### Discoveryengine Recommendationengine Media

        ```python
        import pulumi
        import pulumi_gcp as gcp

        media = gcp.discoveryengine.DataStore("media",
            location="global",
            data_store_id="recommendation-datastore-id",
            display_name="tf-test-structured-datastore",
            industry_vertical="MEDIA",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_RECOMMENDATION"],
            create_advanced_site_search=False,
            skip_default_schema_creation=False)
        media_recommendation_engine = gcp.discoveryengine.RecommendationEngine("media",
            engine_id="recommendation-engine-id",
            location=media.location,
            display_name="Example Media Recommendation Engine",
            data_store_ids=[media.data_store_id],
            industry_vertical="MEDIA",
            media_recommendation_engine_config={
                "type": "recommended-for-you",
                "optimization_objective": "ctr",
                "training_state": "PAUSED",
                "engine_features_config": {
                    "recommended_for_you_config": {
                        "context_event_type": "generic",
                    },
                },
            },
            common_config={
                "company_name": "test-company",
            })
        ```

        ## Import

        RecommendationEngine can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/collections/default_collection/engines/{{engine_id}}`

        * `{{project}}/{{location}}/{{engine_id}}`

        * `{{location}}/{{engine_id}}`

        When using the `pulumi import` command, RecommendationEngine can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/recommendationEngine:RecommendationEngine default projects/{{project}}/locations/{{location}}/collections/default_collection/engines/{{engine_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/recommendationEngine:RecommendationEngine default {{project}}/{{location}}/{{engine_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/recommendationEngine:RecommendationEngine default {{location}}/{{engine_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RecommendationEngineCommonConfigArgs', 'RecommendationEngineCommonConfigArgsDict']] common_config: Common config spec that specifies the metadata of the engine.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_store_ids: The data stores associated with this engine. For SOLUTION_TYPE_RECOMMENDATION type of engines, they can only associate with at most one data store.
        :param pulumi.Input[_builtins.str] display_name: Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        :param pulumi.Input[_builtins.str] engine_id: Unique ID to use for Recommendation Engine.
        :param pulumi.Input[_builtins.str] industry_vertical: The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: If unspecified, default to GENERIC. Vertical on Engine has to match vertical of the DataStore liniked to the engine.
               Default value is `GENERIC`.
               Possible values are: `GENERIC`, `MEDIA`.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[Union['RecommendationEngineMediaRecommendationEngineConfigArgs', 'RecommendationEngineMediaRecommendationEngineConfigArgsDict']] media_recommendation_engine_config: Configurations for a Media Recommendation Engine. Only applicable on the data stores
               with SOLUTION_TYPE_RECOMMENDATION solution type and MEDIA industry vertical.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RecommendationEngineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Vertex AI Search recommendation apps.

        To get more information about RecommendationEngine, see:

        * [API documentation](https://cloud.google.com/generative-ai-app-builder/docs/reference/rest/v1/projects.locations.collections.engines)
        * How-to Guides
            * [Create a Recommendation Engine](https://cloud.google.com/generative-ai-app-builder/docs/create-generic-recommendations-app)

        ## Example Usage

        ### Discoveryengine Recommendationengine Generic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        generic = gcp.discoveryengine.DataStore("generic",
            location="global",
            data_store_id="recommendation-datastore-id",
            display_name="tf-test-structured-datastore",
            industry_vertical="GENERIC",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_RECOMMENDATION"],
            create_advanced_site_search=False,
            skip_default_schema_creation=False)
        generic_recommendation_engine = gcp.discoveryengine.RecommendationEngine("generic",
            engine_id="recommendation-engine-id",
            location=generic.location,
            display_name="Example Recommendation Engine",
            data_store_ids=[generic.data_store_id],
            industry_vertical="GENERIC",
            common_config={
                "company_name": "test-company",
            })
        ```
        ### Discoveryengine Recommendationengine Media

        ```python
        import pulumi
        import pulumi_gcp as gcp

        media = gcp.discoveryengine.DataStore("media",
            location="global",
            data_store_id="recommendation-datastore-id",
            display_name="tf-test-structured-datastore",
            industry_vertical="MEDIA",
            content_config="NO_CONTENT",
            solution_types=["SOLUTION_TYPE_RECOMMENDATION"],
            create_advanced_site_search=False,
            skip_default_schema_creation=False)
        media_recommendation_engine = gcp.discoveryengine.RecommendationEngine("media",
            engine_id="recommendation-engine-id",
            location=media.location,
            display_name="Example Media Recommendation Engine",
            data_store_ids=[media.data_store_id],
            industry_vertical="MEDIA",
            media_recommendation_engine_config={
                "type": "recommended-for-you",
                "optimization_objective": "ctr",
                "training_state": "PAUSED",
                "engine_features_config": {
                    "recommended_for_you_config": {
                        "context_event_type": "generic",
                    },
                },
            },
            common_config={
                "company_name": "test-company",
            })
        ```

        ## Import

        RecommendationEngine can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/collections/default_collection/engines/{{engine_id}}`

        * `{{project}}/{{location}}/{{engine_id}}`

        * `{{location}}/{{engine_id}}`

        When using the `pulumi import` command, RecommendationEngine can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:discoveryengine/recommendationEngine:RecommendationEngine default projects/{{project}}/locations/{{location}}/collections/default_collection/engines/{{engine_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/recommendationEngine:RecommendationEngine default {{project}}/{{location}}/{{engine_id}}
        ```

        ```sh
        $ pulumi import gcp:discoveryengine/recommendationEngine:RecommendationEngine default {{location}}/{{engine_id}}
        ```

        :param str resource_name: The name of the resource.
        :param RecommendationEngineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RecommendationEngineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 common_config: Optional[pulumi.Input[Union['RecommendationEngineCommonConfigArgs', 'RecommendationEngineCommonConfigArgsDict']]] = None,
                 data_store_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 industry_vertical: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 media_recommendation_engine_config: Optional[pulumi.Input[Union['RecommendationEngineMediaRecommendationEngineConfigArgs', 'RecommendationEngineMediaRecommendationEngineConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RecommendationEngineArgs.__new__(RecommendationEngineArgs)

            __props__.__dict__["common_config"] = common_config
            if data_store_ids is None and not opts.urn:
                raise TypeError("Missing required property 'data_store_ids'")
            __props__.__dict__["data_store_ids"] = data_store_ids
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if engine_id is None and not opts.urn:
                raise TypeError("Missing required property 'engine_id'")
            __props__.__dict__["engine_id"] = engine_id
            __props__.__dict__["industry_vertical"] = industry_vertical
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["media_recommendation_engine_config"] = media_recommendation_engine_config
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(RecommendationEngine, __self__).__init__(
            'gcp:discoveryengine/recommendationEngine:RecommendationEngine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            common_config: Optional[pulumi.Input[Union['RecommendationEngineCommonConfigArgs', 'RecommendationEngineCommonConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            data_store_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            engine_id: Optional[pulumi.Input[_builtins.str]] = None,
            industry_vertical: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            media_recommendation_engine_config: Optional[pulumi.Input[Union['RecommendationEngineMediaRecommendationEngineConfigArgs', 'RecommendationEngineMediaRecommendationEngineConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'RecommendationEngine':
        """
        Get an existing RecommendationEngine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RecommendationEngineCommonConfigArgs', 'RecommendationEngineCommonConfigArgsDict']] common_config: Common config spec that specifies the metadata of the engine.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Timestamp the Engine was created at.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_store_ids: The data stores associated with this engine. For SOLUTION_TYPE_RECOMMENDATION type of engines, they can only associate with at most one data store.
        :param pulumi.Input[_builtins.str] display_name: Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        :param pulumi.Input[_builtins.str] engine_id: Unique ID to use for Recommendation Engine.
        :param pulumi.Input[_builtins.str] industry_vertical: The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: If unspecified, default to GENERIC. Vertical on Engine has to match vertical of the DataStore liniked to the engine.
               Default value is `GENERIC`.
               Possible values are: `GENERIC`, `MEDIA`.
        :param pulumi.Input[_builtins.str] location: The geographic location where the data store should reside. The value can
               only be one of "global", "us" and "eu".
        :param pulumi.Input[Union['RecommendationEngineMediaRecommendationEngineConfigArgs', 'RecommendationEngineMediaRecommendationEngineConfigArgsDict']] media_recommendation_engine_config: Configurations for a Media Recommendation Engine. Only applicable on the data stores
               with SOLUTION_TYPE_RECOMMENDATION solution type and MEDIA industry vertical.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The unique full resource name of the recommendation engine. Values are of the format
               `projects/{project}/locations/{location}/collections/{collection}/engines/{engine_id}`.
               This field must be a UTF-8 encoded string with a length limit of 1024 characters.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] update_time: Timestamp the Engine was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RecommendationEngineState.__new__(_RecommendationEngineState)

        __props__.__dict__["common_config"] = common_config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_store_ids"] = data_store_ids
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["engine_id"] = engine_id
        __props__.__dict__["industry_vertical"] = industry_vertical
        __props__.__dict__["location"] = location
        __props__.__dict__["media_recommendation_engine_config"] = media_recommendation_engine_config
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["update_time"] = update_time
        return RecommendationEngine(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="commonConfig")
    def common_config(self) -> pulumi.Output[Optional['outputs.RecommendationEngineCommonConfig']]:
        """
        Common config spec that specifies the metadata of the engine.
        Structure is documented below.
        """
        return pulumi.get(self, "common_config")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp the Engine was created at.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="dataStoreIds")
    def data_store_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The data stores associated with this engine. For SOLUTION_TYPE_RECOMMENDATION type of engines, they can only associate with at most one data store.
        """
        return pulumi.get(self, "data_store_ids")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Required. The display name of the engine. Should be human readable. UTF-8 encoded string with limit of 1024 characters.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique ID to use for Recommendation Engine.
        """
        return pulumi.get(self, "engine_id")

    @_builtins.property
    @pulumi.getter(name="industryVertical")
    def industry_vertical(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The industry vertical that the engine registers. The restriction of the Engine industry vertical is based on DataStore: If unspecified, default to GENERIC. Vertical on Engine has to match vertical of the DataStore liniked to the engine.
        Default value is `GENERIC`.
        Possible values are: `GENERIC`, `MEDIA`.
        """
        return pulumi.get(self, "industry_vertical")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The geographic location where the data store should reside. The value can
        only be one of "global", "us" and "eu".
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="mediaRecommendationEngineConfig")
    def media_recommendation_engine_config(self) -> pulumi.Output[Optional['outputs.RecommendationEngineMediaRecommendationEngineConfig']]:
        """
        Configurations for a Media Recommendation Engine. Only applicable on the data stores
        with SOLUTION_TYPE_RECOMMENDATION solution type and MEDIA industry vertical.
        Structure is documented below.
        """
        return pulumi.get(self, "media_recommendation_engine_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique full resource name of the recommendation engine. Values are of the format
        `projects/{project}/locations/{location}/collections/{collection}/engines/{engine_id}`.
        This field must be a UTF-8 encoded string with a length limit of 1024 characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp the Engine was last updated.
        """
        return pulumi.get(self, "update_time")

