# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ChannelArgs', 'Channel']

@pulumi.input_type
class ChannelArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 crypto_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 third_party_provider: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Channel resource.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[_builtins.str] crypto_key_name: Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        :param pulumi.Input[_builtins.str] name: The resource name of the channel. Must be unique within the location on the project.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] third_party_provider: The name of the event provider (e.g. Eventarc SaaS partner) associated with the channel. This provider will be granted permissions to publish events to the channel. Format: `projects/{project}/locations/{location}/providers/{provider_id}`.
        """
        pulumi.set(__self__, "location", location)
        if crypto_key_name is not None:
            pulumi.set(__self__, "crypto_key_name", crypto_key_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if third_party_provider is not None:
            pulumi.set(__self__, "third_party_provider", third_party_provider)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="cryptoKeyName")
    def crypto_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        """
        return pulumi.get(self, "crypto_key_name")

    @crypto_key_name.setter
    def crypto_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "crypto_key_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the channel. Must be unique within the location on the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="thirdPartyProvider")
    def third_party_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the event provider (e.g. Eventarc SaaS partner) associated with the channel. This provider will be granted permissions to publish events to the channel. Format: `projects/{project}/locations/{location}/providers/{provider_id}`.
        """
        return pulumi.get(self, "third_party_provider")

    @third_party_provider.setter
    def third_party_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "third_party_provider", value)


@pulumi.input_type
class _ChannelState:
    def __init__(__self__, *,
                 activation_token: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 crypto_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pubsub_topic: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 third_party_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Channel resources.
        :param pulumi.Input[_builtins.str] activation_token: The activation token for the channel. The token must be used by the provider to register the channel for publishing.
        :param pulumi.Input[_builtins.str] create_time: The creation time.
        :param pulumi.Input[_builtins.str] crypto_key_name: Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[_builtins.str] name: The resource name of the channel. Must be unique within the location on the project.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] pubsub_topic: The name of the Pub/Sub topic created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{project}/topics/{topic_id}`.
        :param pulumi.Input[_builtins.str] state: The state of a Channel.
        :param pulumi.Input[_builtins.str] third_party_provider: The name of the event provider (e.g. Eventarc SaaS partner) associated with the channel. This provider will be granted permissions to publish events to the channel. Format: `projects/{project}/locations/{location}/providers/{provider_id}`.
        :param pulumi.Input[_builtins.str] uid: Server assigned unique identifier for the channel. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[_builtins.str] update_time: The last-modified time.
        """
        if activation_token is not None:
            pulumi.set(__self__, "activation_token", activation_token)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if crypto_key_name is not None:
            pulumi.set(__self__, "crypto_key_name", crypto_key_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if third_party_provider is not None:
            pulumi.set(__self__, "third_party_provider", third_party_provider)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="activationToken")
    def activation_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The activation token for the channel. The token must be used by the provider to register the channel for publishing.
        """
        return pulumi.get(self, "activation_token")

    @activation_token.setter
    def activation_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "activation_token", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="cryptoKeyName")
    def crypto_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        """
        return pulumi.get(self, "crypto_key_name")

    @crypto_key_name.setter
    def crypto_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "crypto_key_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the channel. Must be unique within the location on the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Pub/Sub topic created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{project}/topics/{topic_id}`.
        """
        return pulumi.get(self, "pubsub_topic")

    @pubsub_topic.setter
    def pubsub_topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pubsub_topic", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of a Channel.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="thirdPartyProvider")
    def third_party_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the event provider (e.g. Eventarc SaaS partner) associated with the channel. This provider will be granted permissions to publish events to the channel. Format: `projects/{project}/locations/{location}/providers/{provider_id}`.
        """
        return pulumi.get(self, "third_party_provider")

    @third_party_provider.setter
    def third_party_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "third_party_provider", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server assigned unique identifier for the channel. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last-modified time.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:eventarc/channel:Channel")
class Channel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crypto_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 third_party_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The Eventarc Channel resource

        To get more information about Channel, see:

        * [API documentation](https://cloud.google.com/eventarc/docs/reference/rest/v1/projects.locations.channels)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/eventarc/standard/docs/third-parties/create-channels)

        ## Example Usage

        ### Eventarc Channel With Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.eventarc.Channel("primary",
            location="us-central1",
            name="some-channel",
            crypto_key_name="some-key",
            third_party_provider="projects/my-project-name/locations/us-central1/providers/datadog")
        ```

        ## Import

        Channel can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/channels/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Channel can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:eventarc/channel:Channel default projects/{{project}}/locations/{{location}}/channels/{{name}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/channel:Channel default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/channel:Channel default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] crypto_key_name: Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[_builtins.str] name: The resource name of the channel. Must be unique within the location on the project.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] third_party_provider: The name of the event provider (e.g. Eventarc SaaS partner) associated with the channel. This provider will be granted permissions to publish events to the channel. Format: `projects/{project}/locations/{location}/providers/{provider_id}`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ChannelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Eventarc Channel resource

        To get more information about Channel, see:

        * [API documentation](https://cloud.google.com/eventarc/docs/reference/rest/v1/projects.locations.channels)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/eventarc/standard/docs/third-parties/create-channels)

        ## Example Usage

        ### Eventarc Channel With Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.eventarc.Channel("primary",
            location="us-central1",
            name="some-channel",
            crypto_key_name="some-key",
            third_party_provider="projects/my-project-name/locations/us-central1/providers/datadog")
        ```

        ## Import

        Channel can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/channels/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Channel can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:eventarc/channel:Channel default projects/{{project}}/locations/{{location}}/channels/{{name}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/channel:Channel default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/channel:Channel default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crypto_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 third_party_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChannelArgs.__new__(ChannelArgs)

            __props__.__dict__["crypto_key_name"] = crypto_key_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["third_party_provider"] = third_party_provider
            __props__.__dict__["activation_token"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["pubsub_topic"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(Channel, __self__).__init__(
            'gcp:eventarc/channel:Channel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activation_token: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            crypto_key_name: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pubsub_topic: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            third_party_provider: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Channel':
        """
        Get an existing Channel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] activation_token: The activation token for the channel. The token must be used by the provider to register the channel for publishing.
        :param pulumi.Input[_builtins.str] create_time: The creation time.
        :param pulumi.Input[_builtins.str] crypto_key_name: Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[_builtins.str] name: The resource name of the channel. Must be unique within the location on the project.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] pubsub_topic: The name of the Pub/Sub topic created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{project}/topics/{topic_id}`.
        :param pulumi.Input[_builtins.str] state: The state of a Channel.
        :param pulumi.Input[_builtins.str] third_party_provider: The name of the event provider (e.g. Eventarc SaaS partner) associated with the channel. This provider will be granted permissions to publish events to the channel. Format: `projects/{project}/locations/{location}/providers/{provider_id}`.
        :param pulumi.Input[_builtins.str] uid: Server assigned unique identifier for the channel. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[_builtins.str] update_time: The last-modified time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ChannelState.__new__(_ChannelState)

        __props__.__dict__["activation_token"] = activation_token
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["crypto_key_name"] = crypto_key_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pubsub_topic"] = pubsub_topic
        __props__.__dict__["state"] = state
        __props__.__dict__["third_party_provider"] = third_party_provider
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Channel(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activationToken")
    def activation_token(self) -> pulumi.Output[_builtins.str]:
        """
        The activation token for the channel. The token must be used by the provider to register the channel for publishing.
        """
        return pulumi.get(self, "activation_token")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="cryptoKeyName")
    def crypto_key_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        """
        return pulumi.get(self, "crypto_key_name")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the channel. Must be unique within the location on the project.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Pub/Sub topic created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{project}/topics/{topic_id}`.
        """
        return pulumi.get(self, "pubsub_topic")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of a Channel.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="thirdPartyProvider")
    def third_party_provider(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the event provider (e.g. Eventarc SaaS partner) associated with the channel. This provider will be granted permissions to publish events to the channel. Format: `projects/{project}/locations/{location}/providers/{provider_id}`.
        """
        return pulumi.get(self, "third_party_provider")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        Server assigned unique identifier for the channel. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The last-modified time.
        """
        return pulumi.get(self, "update_time")

