# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PipelineArgs', 'Pipeline']

@pulumi.input_type
class PipelineArgs:
    def __init__(__self__, *,
                 destinations: pulumi.Input[Sequence[pulumi.Input['PipelineDestinationArgs']]],
                 location: pulumi.Input[_builtins.str],
                 pipeline_id: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 crypto_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 input_payload_format: Optional[pulumi.Input['PipelineInputPayloadFormatArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 logging_config: Optional[pulumi.Input['PipelineLoggingConfigArgs']] = None,
                 mediations: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineMediationArgs']]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_policy: Optional[pulumi.Input['PipelineRetryPolicyArgs']] = None):
        """
        The set of arguments for constructing a Pipeline resource.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineDestinationArgs']]] destinations: List of destinations to which messages will be forwarded. Currently,
               exactly one destination is supported per Pipeline.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] pipeline_id: The user-provided ID to be assigned to the Pipeline. It should match the
               format `^a-z?$`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: User-defined annotations. See https://google.aip.dev/128#annotations.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] crypto_key_name: Resource name of a KMS crypto key (managed by the user) used to
               encrypt/decrypt the event data. If not set, an internal Google-owned key
               will be used to encrypt messages. It must match the pattern
               "projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}".
        :param pulumi.Input[_builtins.str] display_name: Display name of resource.
        :param pulumi.Input['PipelineInputPayloadFormatArgs'] input_payload_format: Represents the format of message data.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User labels attached to the Pipeline that can be used to group
               resources. An object containing a list of "key": value pairs. Example: {
               "name": "wrench", "mass": "1.3kg", "count": "3" }.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['PipelineLoggingConfigArgs'] logging_config: The configuration for Platform Telemetry logging for Eventarc Advanced
               resources.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineMediationArgs']]] mediations: List of mediation operations to be performed on the message. Currently,
               only one Transformation operation is allowed in each Pipeline.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['PipelineRetryPolicyArgs'] retry_policy: The retry policy configuration for the Pipeline. The pipeline
               exponentially backs off in case the destination is non responsive or
               returns a retryable error code. The default semantics are as follows:
               The backoff starts with a 5 second delay and doubles the
               delay after each failed attempt (10 seconds, 20 seconds, 40 seconds, etc.).
               The delay is capped at 60 seconds by default.
               Please note that if you set the min_retry_delay and max_retry_delay fields
               to the same value this will make the duration between retries constant.
               Structure is documented below.
        """
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "pipeline_id", pipeline_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if crypto_key_name is not None:
            pulumi.set(__self__, "crypto_key_name", crypto_key_name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if input_payload_format is not None:
            pulumi.set(__self__, "input_payload_format", input_payload_format)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if mediations is not None:
            pulumi.set(__self__, "mediations", mediations)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input['PipelineDestinationArgs']]]:
        """
        List of destinations to which messages will be forwarded. Currently,
        exactly one destination is supported per Pipeline.
        Structure is documented below.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input['PipelineDestinationArgs']]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Input[_builtins.str]:
        """
        The user-provided ID to be assigned to the Pipeline. It should match the
        format `^a-z?$`.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pipeline_id", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-defined annotations. See https://google.aip.dev/128#annotations.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="cryptoKeyName")
    def crypto_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource name of a KMS crypto key (managed by the user) used to
        encrypt/decrypt the event data. If not set, an internal Google-owned key
        will be used to encrypt messages. It must match the pattern
        "projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}".
        """
        return pulumi.get(self, "crypto_key_name")

    @crypto_key_name.setter
    def crypto_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "crypto_key_name", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name of resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="inputPayloadFormat")
    def input_payload_format(self) -> Optional[pulumi.Input['PipelineInputPayloadFormatArgs']]:
        """
        Represents the format of message data.
        Structure is documented below.
        """
        return pulumi.get(self, "input_payload_format")

    @input_payload_format.setter
    def input_payload_format(self, value: Optional[pulumi.Input['PipelineInputPayloadFormatArgs']]):
        pulumi.set(self, "input_payload_format", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User labels attached to the Pipeline that can be used to group
        resources. An object containing a list of "key": value pairs. Example: {
        "name": "wrench", "mass": "1.3kg", "count": "3" }.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['PipelineLoggingConfigArgs']]:
        """
        The configuration for Platform Telemetry logging for Eventarc Advanced
        resources.
        Structure is documented below.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['PipelineLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @_builtins.property
    @pulumi.getter
    def mediations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineMediationArgs']]]]:
        """
        List of mediation operations to be performed on the message. Currently,
        only one Transformation operation is allowed in each Pipeline.
        Structure is documented below.
        """
        return pulumi.get(self, "mediations")

    @mediations.setter
    def mediations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineMediationArgs']]]]):
        pulumi.set(self, "mediations", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[pulumi.Input['PipelineRetryPolicyArgs']]:
        """
        The retry policy configuration for the Pipeline. The pipeline
        exponentially backs off in case the destination is non responsive or
        returns a retryable error code. The default semantics are as follows:
        The backoff starts with a 5 second delay and doubles the
        delay after each failed attempt (10 seconds, 20 seconds, 40 seconds, etc.).
        The delay is capped at 60 seconds by default.
        Please note that if you set the min_retry_delay and max_retry_delay fields
        to the same value this will make the duration between retries constant.
        Structure is documented below.
        """
        return pulumi.get(self, "retry_policy")

    @retry_policy.setter
    def retry_policy(self, value: Optional[pulumi.Input['PipelineRetryPolicyArgs']]):
        pulumi.set(self, "retry_policy", value)


@pulumi.input_type
class _PipelineState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 crypto_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDestinationArgs']]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 input_payload_format: Optional[pulumi.Input['PipelineInputPayloadFormatArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_config: Optional[pulumi.Input['PipelineLoggingConfigArgs']] = None,
                 mediations: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineMediationArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 retry_policy: Optional[pulumi.Input['PipelineRetryPolicyArgs']] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Pipeline resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: User-defined annotations. See https://google.aip.dev/128#annotations.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up
               to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and
               "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[_builtins.str] crypto_key_name: Resource name of a KMS crypto key (managed by the user) used to
               encrypt/decrypt the event data. If not set, an internal Google-owned key
               will be used to encrypt messages. It must match the pattern
               "projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}".
        :param pulumi.Input[Sequence[pulumi.Input['PipelineDestinationArgs']]] destinations: List of destinations to which messages will be forwarded. Currently,
               exactly one destination is supported per Pipeline.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] display_name: Display name of resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: This checksum is computed by the server based on the value of
               other fields, and might be sent only on create requests to ensure that the
               client has an up-to-date value before proceeding.
        :param pulumi.Input['PipelineInputPayloadFormatArgs'] input_payload_format: Represents the format of message data.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User labels attached to the Pipeline that can be used to group
               resources. An object containing a list of "key": value pairs. Example: {
               "name": "wrench", "mass": "1.3kg", "count": "3" }.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input['PipelineLoggingConfigArgs'] logging_config: The configuration for Platform Telemetry logging for Eventarc Advanced
               resources.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineMediationArgs']]] mediations: List of mediation operations to be performed on the message. Currently,
               only one Transformation operation is allowed in each Pipeline.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The resource name of the Pipeline. Must be unique within the
               location of the project and must be in
               `projects/{project}/locations/{location}/pipelines/{pipeline}` format.
        :param pulumi.Input[_builtins.str] pipeline_id: The user-provided ID to be assigned to the Pipeline. It should match the
               format `^a-z?$`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['PipelineRetryPolicyArgs'] retry_policy: The retry policy configuration for the Pipeline. The pipeline
               exponentially backs off in case the destination is non responsive or
               returns a retryable error code. The default semantics are as follows:
               The backoff starts with a 5 second delay and doubles the
               delay after each failed attempt (10 seconds, 20 seconds, 40 seconds, etc.).
               The delay is capped at 60 seconds by default.
               Please note that if you set the min_retry_delay and max_retry_delay fields
               to the same value this will make the duration between retries constant.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: Server-assigned unique identifier for the Pipeline. The value
               is a UUID4 string and guaranteed to remain unchanged until the resource is
               deleted.
        :param pulumi.Input[_builtins.str] update_time: The last-modified time.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up
               to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and
               "2014-10-02T15:01:23.045123456Z".
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if crypto_key_name is not None:
            pulumi.set(__self__, "crypto_key_name", crypto_key_name)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if input_payload_format is not None:
            pulumi.set(__self__, "input_payload_format", input_payload_format)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if mediations is not None:
            pulumi.set(__self__, "mediations", mediations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pipeline_id is not None:
            pulumi.set(__self__, "pipeline_id", pipeline_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-defined annotations. See https://google.aip.dev/128#annotations.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up
        to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and
        "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="cryptoKeyName")
    def crypto_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource name of a KMS crypto key (managed by the user) used to
        encrypt/decrypt the event data. If not set, an internal Google-owned key
        will be used to encrypt messages. It must match the pattern
        "projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}".
        """
        return pulumi.get(self, "crypto_key_name")

    @crypto_key_name.setter
    def crypto_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "crypto_key_name", value)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDestinationArgs']]]]:
        """
        List of destinations to which messages will be forwarded. Currently,
        exactly one destination is supported per Pipeline.
        Structure is documented below.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineDestinationArgs']]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name of resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This checksum is computed by the server based on the value of
        other fields, and might be sent only on create requests to ensure that the
        client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="inputPayloadFormat")
    def input_payload_format(self) -> Optional[pulumi.Input['PipelineInputPayloadFormatArgs']]:
        """
        Represents the format of message data.
        Structure is documented below.
        """
        return pulumi.get(self, "input_payload_format")

    @input_payload_format.setter
    def input_payload_format(self, value: Optional[pulumi.Input['PipelineInputPayloadFormatArgs']]):
        pulumi.set(self, "input_payload_format", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User labels attached to the Pipeline that can be used to group
        resources. An object containing a list of "key": value pairs. Example: {
        "name": "wrench", "mass": "1.3kg", "count": "3" }.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['PipelineLoggingConfigArgs']]:
        """
        The configuration for Platform Telemetry logging for Eventarc Advanced
        resources.
        Structure is documented below.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['PipelineLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @_builtins.property
    @pulumi.getter
    def mediations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineMediationArgs']]]]:
        """
        List of mediation operations to be performed on the message. Currently,
        only one Transformation operation is allowed in each Pipeline.
        Structure is documented below.
        """
        return pulumi.get(self, "mediations")

    @mediations.setter
    def mediations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineMediationArgs']]]]):
        pulumi.set(self, "mediations", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the Pipeline. Must be unique within the
        location of the project and must be in
        `projects/{project}/locations/{location}/pipelines/{pipeline}` format.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-provided ID to be assigned to the Pipeline. It should match the
        format `^a-z?$`.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pipeline_id", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[pulumi.Input['PipelineRetryPolicyArgs']]:
        """
        The retry policy configuration for the Pipeline. The pipeline
        exponentially backs off in case the destination is non responsive or
        returns a retryable error code. The default semantics are as follows:
        The backoff starts with a 5 second delay and doubles the
        delay after each failed attempt (10 seconds, 20 seconds, 40 seconds, etc.).
        The delay is capped at 60 seconds by default.
        Please note that if you set the min_retry_delay and max_retry_delay fields
        to the same value this will make the duration between retries constant.
        Structure is documented below.
        """
        return pulumi.get(self, "retry_policy")

    @retry_policy.setter
    def retry_policy(self, value: Optional[pulumi.Input['PipelineRetryPolicyArgs']]):
        pulumi.set(self, "retry_policy", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server-assigned unique identifier for the Pipeline. The value
        is a UUID4 string and guaranteed to remain unchanged until the resource is
        deleted.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last-modified time.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up
        to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and
        "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:eventarc/pipeline:Pipeline")
class Pipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 crypto_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineDestinationArgs', 'PipelineDestinationArgsDict']]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 input_payload_format: Optional[pulumi.Input[Union['PipelineInputPayloadFormatArgs', 'PipelineInputPayloadFormatArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_config: Optional[pulumi.Input[Union['PipelineLoggingConfigArgs', 'PipelineLoggingConfigArgsDict']]] = None,
                 mediations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineMediationArgs', 'PipelineMediationArgsDict']]]]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_policy: Optional[pulumi.Input[Union['PipelineRetryPolicyArgs', 'PipelineRetryPolicyArgsDict']]] = None,
                 __props__=None):
        """
        The Eventarc Pipeline resource

        To get more information about Pipeline, see:

        * [API documentation](https://cloud.google.com/eventarc/docs/reference/rest/v1/projects.locations.pipelines)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/eventarc/advanced/docs/receive-events/create-enrollment)

        ## Example Usage

        ### Eventarc Pipeline With Topic Destination

        ```python
        import pulumi
        import pulumi_gcp as gcp

        topic = gcp.pubsub.Topic("topic", name="some-topic")
        primary = gcp.eventarc.Pipeline("primary",
            location="us-central1",
            pipeline_id="some-pipeline",
            destinations=[{
                "topic": topic.id,
            }],
            labels={
                "test_label": "test-eventarc-label",
            },
            annotations={
                "test_annotation": "test-eventarc-annotation",
            },
            display_name="Testing Pipeline")
        ```
        ### Eventarc Pipeline With Http Destination

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.eventarc.Pipeline("primary",
            location="us-central1",
            pipeline_id="some-pipeline",
            destinations=[{
                "http_endpoint": {
                    "uri": "https://10.77.0.0:80/route",
                },
                "network_config": {
                    "network_attachment": "projects/my-project-name/regions/us-central1/networkAttachments/some-network-attachment",
                },
            }])
        ```
        ### Eventarc Pipeline With Workflow Destination

        ```python
        import pulumi
        import pulumi_gcp as gcp

        workflow = gcp.workflows.Workflow("workflow",
            name="some-workflow",
            deletion_protection=False,
            region="us-central1",
            source_contents=\"\"\"# This is a sample workflow, feel free to replace it with your source code
        #
        # This workflow does the following:
        # - reads current time and date information from an external API and stores
        #   the response in CurrentDateTime variable
        # - retrieves a list of Wikipedia articles related to the day of the week
        #   from CurrentDateTime
        # - returns the list of articles as an output of the workflow
        # FYI, In terraform you need to escape the $$ or it will cause errors.

        - getCurrentTime:
            call: http.get
            args:
                url: ${sys.get_env("url")}
            result: CurrentDateTime
        - readWikipedia:
            call: http.get
            args:
                url: https://en.wikipedia.org/w/api.php
                query:
                    action: opensearch
                    search: ${CurrentDateTime.body.dayOfTheWeek}
            result: WikiResult
        - returnOutput:
            return: ${WikiResult.body[1]}
        \"\"\")
        primary = gcp.eventarc.Pipeline("primary",
            location="us-central1",
            pipeline_id="some-pipeline",
            destinations=[{
                "workflow": workflow.id,
            }])
        ```
        ### Eventarc Pipeline With Oidc And Json Format

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.eventarc.Pipeline("primary",
            location="us-central1",
            pipeline_id="some-pipeline",
            destinations=[{
                "http_endpoint": {
                    "uri": "https://10.77.0.0:80/route",
                    "message_binding_template": "{\\"headers\\":{\\"new-header-key\\": \\"new-header-value\\"}}",
                },
                "network_config": {
                    "network_attachment": "projects/my-project-name/regions/us-central1/networkAttachments/some-network-attachment",
                },
                "authentication_config": {
                    "google_oidc": {
                        "service_account": "my@service-account.com",
                        "audience": "http://www.example.com",
                    },
                },
                "output_payload_format": {
                    "json": {},
                },
            }],
            input_payload_format={
                "json": {},
            },
            retry_policy={
                "max_retry_delay": "50s",
                "max_attempts": 2,
                "min_retry_delay": "40s",
            },
            mediations=[{
                "transformation": {
                    "transformation_template": \"\"\"{
        "id": message.id,
        "datacontenttype": "application/json",
        "data": "{ \\"scrubbed\\": \\"true\\" }"
        }
        \"\"\",
                },
            }],
            logging_config={
                "log_severity": "DEBUG",
            })
        ```
        ### Eventarc Pipeline With Oauth And Protobuf Format

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.eventarc.Pipeline("primary",
            location="us-central1",
            pipeline_id="some-pipeline",
            destinations=[{
                "http_endpoint": {
                    "uri": "https://10.77.0.0:80/route",
                    "message_binding_template": "{\\"headers\\":{\\"new-header-key\\": \\"new-header-value\\"}}",
                },
                "network_config": {
                    "network_attachment": "projects/my-project-name/regions/us-central1/networkAttachments/some-network-attachment",
                },
                "authentication_config": {
                    "oauth_token": {
                        "service_account": "my@service-account.com",
                        "scope": "https://www.googleapis.com/auth/cloud-platform",
                    },
                },
                "output_payload_format": {
                    "protobuf": {
                        "schema_definition": \"\"\"syntax = "proto3";
        message schema {
        string name = 1;
        string severity = 2;
        }
        \"\"\",
                    },
                },
            }],
            input_payload_format={
                "protobuf": {
                    "schema_definition": \"\"\"syntax = "proto3";
        message schema {
        string name = 1;
        string severity = 2;
        }
        \"\"\",
                },
            },
            retry_policy={
                "max_retry_delay": "50s",
                "max_attempts": 2,
                "min_retry_delay": "40s",
            },
            mediations=[{
                "transformation": {
                    "transformation_template": \"\"\"{
        "id": message.id,
        "datacontenttype": "application/json",
        "data": "{ \\"scrubbed\\": \\"true\\" }"
        }
        \"\"\",
                },
            }],
            logging_config={
                "log_severity": "DEBUG",
            })
        ```
        ### Eventarc Pipeline With Cmek And Avro Format

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.eventarc.Pipeline("primary",
            location="us-central1",
            pipeline_id="some-pipeline",
            crypto_key_name="some-key",
            destinations=[{
                "http_endpoint": {
                    "uri": "https://10.77.0.0:80/route",
                    "message_binding_template": "{\\"headers\\":{\\"new-header-key\\": \\"new-header-value\\"}}",
                },
                "network_config": {
                    "network_attachment": "projects/my-project-name/regions/us-central1/networkAttachments/some-network-attachment",
                },
                "output_payload_format": {
                    "avro": {
                        "schema_definition": "{\\"type\\": \\"record\\", \\"name\\": \\"my_record\\", \\"fields\\": [{\\"name\\": \\"my_field\\", \\"type\\": \\"string\\"}]}",
                    },
                },
            }],
            input_payload_format={
                "avro": {
                    "schema_definition": "{\\"type\\": \\"record\\", \\"name\\": \\"my_record\\", \\"fields\\": [{\\"name\\": \\"my_field\\", \\"type\\": \\"string\\"}]}",
                },
            },
            retry_policy={
                "max_retry_delay": "50s",
                "max_attempts": 2,
                "min_retry_delay": "40s",
            },
            mediations=[{
                "transformation": {
                    "transformation_template": \"\"\"{
        "id": message.id,
        "datacontenttype": "application/json",
        "data": "{ \\"scrubbed\\": \\"true\\" }"
        }
        \"\"\",
                },
            }],
            logging_config={
                "log_severity": "DEBUG",
            })
        ```

        ## Import

        Pipeline can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/pipelines/{{pipeline_id}}`

        * `{{project}}/{{location}}/{{pipeline_id}}`

        * `{{location}}/{{pipeline_id}}`

        When using the `pulumi import` command, Pipeline can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:eventarc/pipeline:Pipeline default projects/{{project}}/locations/{{location}}/pipelines/{{pipeline_id}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/pipeline:Pipeline default {{project}}/{{location}}/{{pipeline_id}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/pipeline:Pipeline default {{location}}/{{pipeline_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: User-defined annotations. See https://google.aip.dev/128#annotations.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] crypto_key_name: Resource name of a KMS crypto key (managed by the user) used to
               encrypt/decrypt the event data. If not set, an internal Google-owned key
               will be used to encrypt messages. It must match the pattern
               "projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}".
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineDestinationArgs', 'PipelineDestinationArgsDict']]]] destinations: List of destinations to which messages will be forwarded. Currently,
               exactly one destination is supported per Pipeline.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] display_name: Display name of resource.
        :param pulumi.Input[Union['PipelineInputPayloadFormatArgs', 'PipelineInputPayloadFormatArgsDict']] input_payload_format: Represents the format of message data.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User labels attached to the Pipeline that can be used to group
               resources. An object containing a list of "key": value pairs. Example: {
               "name": "wrench", "mass": "1.3kg", "count": "3" }.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Union['PipelineLoggingConfigArgs', 'PipelineLoggingConfigArgsDict']] logging_config: The configuration for Platform Telemetry logging for Eventarc Advanced
               resources.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineMediationArgs', 'PipelineMediationArgsDict']]]] mediations: List of mediation operations to be performed on the message. Currently,
               only one Transformation operation is allowed in each Pipeline.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] pipeline_id: The user-provided ID to be assigned to the Pipeline. It should match the
               format `^a-z?$`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['PipelineRetryPolicyArgs', 'PipelineRetryPolicyArgsDict']] retry_policy: The retry policy configuration for the Pipeline. The pipeline
               exponentially backs off in case the destination is non responsive or
               returns a retryable error code. The default semantics are as follows:
               The backoff starts with a 5 second delay and doubles the
               delay after each failed attempt (10 seconds, 20 seconds, 40 seconds, etc.).
               The delay is capped at 60 seconds by default.
               Please note that if you set the min_retry_delay and max_retry_delay fields
               to the same value this will make the duration between retries constant.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Eventarc Pipeline resource

        To get more information about Pipeline, see:

        * [API documentation](https://cloud.google.com/eventarc/docs/reference/rest/v1/projects.locations.pipelines)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/eventarc/advanced/docs/receive-events/create-enrollment)

        ## Example Usage

        ### Eventarc Pipeline With Topic Destination

        ```python
        import pulumi
        import pulumi_gcp as gcp

        topic = gcp.pubsub.Topic("topic", name="some-topic")
        primary = gcp.eventarc.Pipeline("primary",
            location="us-central1",
            pipeline_id="some-pipeline",
            destinations=[{
                "topic": topic.id,
            }],
            labels={
                "test_label": "test-eventarc-label",
            },
            annotations={
                "test_annotation": "test-eventarc-annotation",
            },
            display_name="Testing Pipeline")
        ```
        ### Eventarc Pipeline With Http Destination

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.eventarc.Pipeline("primary",
            location="us-central1",
            pipeline_id="some-pipeline",
            destinations=[{
                "http_endpoint": {
                    "uri": "https://10.77.0.0:80/route",
                },
                "network_config": {
                    "network_attachment": "projects/my-project-name/regions/us-central1/networkAttachments/some-network-attachment",
                },
            }])
        ```
        ### Eventarc Pipeline With Workflow Destination

        ```python
        import pulumi
        import pulumi_gcp as gcp

        workflow = gcp.workflows.Workflow("workflow",
            name="some-workflow",
            deletion_protection=False,
            region="us-central1",
            source_contents=\"\"\"# This is a sample workflow, feel free to replace it with your source code
        #
        # This workflow does the following:
        # - reads current time and date information from an external API and stores
        #   the response in CurrentDateTime variable
        # - retrieves a list of Wikipedia articles related to the day of the week
        #   from CurrentDateTime
        # - returns the list of articles as an output of the workflow
        # FYI, In terraform you need to escape the $$ or it will cause errors.

        - getCurrentTime:
            call: http.get
            args:
                url: ${sys.get_env("url")}
            result: CurrentDateTime
        - readWikipedia:
            call: http.get
            args:
                url: https://en.wikipedia.org/w/api.php
                query:
                    action: opensearch
                    search: ${CurrentDateTime.body.dayOfTheWeek}
            result: WikiResult
        - returnOutput:
            return: ${WikiResult.body[1]}
        \"\"\")
        primary = gcp.eventarc.Pipeline("primary",
            location="us-central1",
            pipeline_id="some-pipeline",
            destinations=[{
                "workflow": workflow.id,
            }])
        ```
        ### Eventarc Pipeline With Oidc And Json Format

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.eventarc.Pipeline("primary",
            location="us-central1",
            pipeline_id="some-pipeline",
            destinations=[{
                "http_endpoint": {
                    "uri": "https://10.77.0.0:80/route",
                    "message_binding_template": "{\\"headers\\":{\\"new-header-key\\": \\"new-header-value\\"}}",
                },
                "network_config": {
                    "network_attachment": "projects/my-project-name/regions/us-central1/networkAttachments/some-network-attachment",
                },
                "authentication_config": {
                    "google_oidc": {
                        "service_account": "my@service-account.com",
                        "audience": "http://www.example.com",
                    },
                },
                "output_payload_format": {
                    "json": {},
                },
            }],
            input_payload_format={
                "json": {},
            },
            retry_policy={
                "max_retry_delay": "50s",
                "max_attempts": 2,
                "min_retry_delay": "40s",
            },
            mediations=[{
                "transformation": {
                    "transformation_template": \"\"\"{
        "id": message.id,
        "datacontenttype": "application/json",
        "data": "{ \\"scrubbed\\": \\"true\\" }"
        }
        \"\"\",
                },
            }],
            logging_config={
                "log_severity": "DEBUG",
            })
        ```
        ### Eventarc Pipeline With Oauth And Protobuf Format

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.eventarc.Pipeline("primary",
            location="us-central1",
            pipeline_id="some-pipeline",
            destinations=[{
                "http_endpoint": {
                    "uri": "https://10.77.0.0:80/route",
                    "message_binding_template": "{\\"headers\\":{\\"new-header-key\\": \\"new-header-value\\"}}",
                },
                "network_config": {
                    "network_attachment": "projects/my-project-name/regions/us-central1/networkAttachments/some-network-attachment",
                },
                "authentication_config": {
                    "oauth_token": {
                        "service_account": "my@service-account.com",
                        "scope": "https://www.googleapis.com/auth/cloud-platform",
                    },
                },
                "output_payload_format": {
                    "protobuf": {
                        "schema_definition": \"\"\"syntax = "proto3";
        message schema {
        string name = 1;
        string severity = 2;
        }
        \"\"\",
                    },
                },
            }],
            input_payload_format={
                "protobuf": {
                    "schema_definition": \"\"\"syntax = "proto3";
        message schema {
        string name = 1;
        string severity = 2;
        }
        \"\"\",
                },
            },
            retry_policy={
                "max_retry_delay": "50s",
                "max_attempts": 2,
                "min_retry_delay": "40s",
            },
            mediations=[{
                "transformation": {
                    "transformation_template": \"\"\"{
        "id": message.id,
        "datacontenttype": "application/json",
        "data": "{ \\"scrubbed\\": \\"true\\" }"
        }
        \"\"\",
                },
            }],
            logging_config={
                "log_severity": "DEBUG",
            })
        ```
        ### Eventarc Pipeline With Cmek And Avro Format

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.eventarc.Pipeline("primary",
            location="us-central1",
            pipeline_id="some-pipeline",
            crypto_key_name="some-key",
            destinations=[{
                "http_endpoint": {
                    "uri": "https://10.77.0.0:80/route",
                    "message_binding_template": "{\\"headers\\":{\\"new-header-key\\": \\"new-header-value\\"}}",
                },
                "network_config": {
                    "network_attachment": "projects/my-project-name/regions/us-central1/networkAttachments/some-network-attachment",
                },
                "output_payload_format": {
                    "avro": {
                        "schema_definition": "{\\"type\\": \\"record\\", \\"name\\": \\"my_record\\", \\"fields\\": [{\\"name\\": \\"my_field\\", \\"type\\": \\"string\\"}]}",
                    },
                },
            }],
            input_payload_format={
                "avro": {
                    "schema_definition": "{\\"type\\": \\"record\\", \\"name\\": \\"my_record\\", \\"fields\\": [{\\"name\\": \\"my_field\\", \\"type\\": \\"string\\"}]}",
                },
            },
            retry_policy={
                "max_retry_delay": "50s",
                "max_attempts": 2,
                "min_retry_delay": "40s",
            },
            mediations=[{
                "transformation": {
                    "transformation_template": \"\"\"{
        "id": message.id,
        "datacontenttype": "application/json",
        "data": "{ \\"scrubbed\\": \\"true\\" }"
        }
        \"\"\",
                },
            }],
            logging_config={
                "log_severity": "DEBUG",
            })
        ```

        ## Import

        Pipeline can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/pipelines/{{pipeline_id}}`

        * `{{project}}/{{location}}/{{pipeline_id}}`

        * `{{location}}/{{pipeline_id}}`

        When using the `pulumi import` command, Pipeline can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:eventarc/pipeline:Pipeline default projects/{{project}}/locations/{{location}}/pipelines/{{pipeline_id}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/pipeline:Pipeline default {{project}}/{{location}}/{{pipeline_id}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/pipeline:Pipeline default {{location}}/{{pipeline_id}}
        ```

        :param str resource_name: The name of the resource.
        :param PipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 crypto_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineDestinationArgs', 'PipelineDestinationArgsDict']]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 input_payload_format: Optional[pulumi.Input[Union['PipelineInputPayloadFormatArgs', 'PipelineInputPayloadFormatArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_config: Optional[pulumi.Input[Union['PipelineLoggingConfigArgs', 'PipelineLoggingConfigArgsDict']]] = None,
                 mediations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineMediationArgs', 'PipelineMediationArgsDict']]]]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_policy: Optional[pulumi.Input[Union['PipelineRetryPolicyArgs', 'PipelineRetryPolicyArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineArgs.__new__(PipelineArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["crypto_key_name"] = crypto_key_name
            if destinations is None and not opts.urn:
                raise TypeError("Missing required property 'destinations'")
            __props__.__dict__["destinations"] = destinations
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["input_payload_format"] = input_payload_format
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["logging_config"] = logging_config
            __props__.__dict__["mediations"] = mediations
            if pipeline_id is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_id'")
            __props__.__dict__["pipeline_id"] = pipeline_id
            __props__.__dict__["project"] = project
            __props__.__dict__["retry_policy"] = retry_policy
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Pipeline, __self__).__init__(
            'gcp:eventarc/pipeline:Pipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            crypto_key_name: Optional[pulumi.Input[_builtins.str]] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineDestinationArgs', 'PipelineDestinationArgsDict']]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            input_payload_format: Optional[pulumi.Input[Union['PipelineInputPayloadFormatArgs', 'PipelineInputPayloadFormatArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            logging_config: Optional[pulumi.Input[Union['PipelineLoggingConfigArgs', 'PipelineLoggingConfigArgsDict']]] = None,
            mediations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineMediationArgs', 'PipelineMediationArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            retry_policy: Optional[pulumi.Input[Union['PipelineRetryPolicyArgs', 'PipelineRetryPolicyArgsDict']]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Pipeline':
        """
        Get an existing Pipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: User-defined annotations. See https://google.aip.dev/128#annotations.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up
               to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and
               "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[_builtins.str] crypto_key_name: Resource name of a KMS crypto key (managed by the user) used to
               encrypt/decrypt the event data. If not set, an internal Google-owned key
               will be used to encrypt messages. It must match the pattern
               "projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}".
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineDestinationArgs', 'PipelineDestinationArgsDict']]]] destinations: List of destinations to which messages will be forwarded. Currently,
               exactly one destination is supported per Pipeline.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] display_name: Display name of resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: This checksum is computed by the server based on the value of
               other fields, and might be sent only on create requests to ensure that the
               client has an up-to-date value before proceeding.
        :param pulumi.Input[Union['PipelineInputPayloadFormatArgs', 'PipelineInputPayloadFormatArgsDict']] input_payload_format: Represents the format of message data.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User labels attached to the Pipeline that can be used to group
               resources. An object containing a list of "key": value pairs. Example: {
               "name": "wrench", "mass": "1.3kg", "count": "3" }.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[Union['PipelineLoggingConfigArgs', 'PipelineLoggingConfigArgsDict']] logging_config: The configuration for Platform Telemetry logging for Eventarc Advanced
               resources.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineMediationArgs', 'PipelineMediationArgsDict']]]] mediations: List of mediation operations to be performed on the message. Currently,
               only one Transformation operation is allowed in each Pipeline.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The resource name of the Pipeline. Must be unique within the
               location of the project and must be in
               `projects/{project}/locations/{location}/pipelines/{pipeline}` format.
        :param pulumi.Input[_builtins.str] pipeline_id: The user-provided ID to be assigned to the Pipeline. It should match the
               format `^a-z?$`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['PipelineRetryPolicyArgs', 'PipelineRetryPolicyArgsDict']] retry_policy: The retry policy configuration for the Pipeline. The pipeline
               exponentially backs off in case the destination is non responsive or
               returns a retryable error code. The default semantics are as follows:
               The backoff starts with a 5 second delay and doubles the
               delay after each failed attempt (10 seconds, 20 seconds, 40 seconds, etc.).
               The delay is capped at 60 seconds by default.
               Please note that if you set the min_retry_delay and max_retry_delay fields
               to the same value this will make the duration between retries constant.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: Server-assigned unique identifier for the Pipeline. The value
               is a UUID4 string and guaranteed to remain unchanged until the resource is
               deleted.
        :param pulumi.Input[_builtins.str] update_time: The last-modified time.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up
               to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and
               "2014-10-02T15:01:23.045123456Z".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PipelineState.__new__(_PipelineState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["crypto_key_name"] = crypto_key_name
        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["input_payload_format"] = input_payload_format
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["logging_config"] = logging_config
        __props__.__dict__["mediations"] = mediations
        __props__.__dict__["name"] = name
        __props__.__dict__["pipeline_id"] = pipeline_id
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["retry_policy"] = retry_policy
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Pipeline(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        User-defined annotations. See https://google.aip.dev/128#annotations.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up
        to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and
        "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="cryptoKeyName")
    def crypto_key_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resource name of a KMS crypto key (managed by the user) used to
        encrypt/decrypt the event data. If not set, an internal Google-owned key
        will be used to encrypt messages. It must match the pattern
        "projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}".
        """
        return pulumi.get(self, "crypto_key_name")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Sequence['outputs.PipelineDestination']]:
        """
        List of destinations to which messages will be forwarded. Currently,
        exactly one destination is supported per Pipeline.
        Structure is documented below.
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Display name of resource.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        This checksum is computed by the server based on the value of
        other fields, and might be sent only on create requests to ensure that the
        client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="inputPayloadFormat")
    def input_payload_format(self) -> pulumi.Output[Optional['outputs.PipelineInputPayloadFormat']]:
        """
        Represents the format of message data.
        Structure is documented below.
        """
        return pulumi.get(self, "input_payload_format")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        User labels attached to the Pipeline that can be used to group
        resources. An object containing a list of "key": value pairs. Example: {
        "name": "wrench", "mass": "1.3kg", "count": "3" }.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> pulumi.Output['outputs.PipelineLoggingConfig']:
        """
        The configuration for Platform Telemetry logging for Eventarc Advanced
        resources.
        Structure is documented below.
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter
    def mediations(self) -> pulumi.Output[Optional[Sequence['outputs.PipelineMediation']]]:
        """
        List of mediation operations to be performed on the message. Currently,
        only one Transformation operation is allowed in each Pipeline.
        Structure is documented below.
        """
        return pulumi.get(self, "mediations")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the Pipeline. Must be unique within the
        location of the project and must be in
        `projects/{project}/locations/{location}/pipelines/{pipeline}` format.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Output[_builtins.str]:
        """
        The user-provided ID to be assigned to the Pipeline. It should match the
        format `^a-z?$`.
        """
        return pulumi.get(self, "pipeline_id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> pulumi.Output['outputs.PipelineRetryPolicy']:
        """
        The retry policy configuration for the Pipeline. The pipeline
        exponentially backs off in case the destination is non responsive or
        returns a retryable error code. The default semantics are as follows:
        The backoff starts with a 5 second delay and doubles the
        delay after each failed attempt (10 seconds, 20 seconds, 40 seconds, etc.).
        The delay is capped at 60 seconds by default.
        Please note that if you set the min_retry_delay and max_retry_delay fields
        to the same value this will make the duration between retries constant.
        Structure is documented below.
        """
        return pulumi.get(self, "retry_policy")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        Server-assigned unique identifier for the Pipeline. The value
        is a UUID4 string and guaranteed to remain unchanged until the resource is
        deleted.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The last-modified time.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up
        to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and
        "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

