# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TriggerArgs', 'Trigger']

@pulumi.input_type
class TriggerArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['TriggerDestinationArgs'],
                 location: pulumi.Input[_builtins.str],
                 matching_criterias: pulumi.Input[Sequence[pulumi.Input['TriggerMatchingCriteriaArgs']]],
                 channel: Optional[pulumi.Input[_builtins.str]] = None,
                 event_data_content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 transport: Optional[pulumi.Input['TriggerTransportArgs']] = None):
        """
        The set of arguments for constructing a Trigger resource.
        :param pulumi.Input['TriggerDestinationArgs'] destination: Required. Destination specifies where the events should be sent to.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[Sequence[pulumi.Input['TriggerMatchingCriteriaArgs']]] matching_criterias: Required. null The list of filters that applies to event attributes. Only events that match all the provided filters will be sent to the destination.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] channel: Optional. The name of the channel associated with the trigger in `projects/{project}/locations/{location}/channels/{channel}` format. You must provide a channel to receive events from Eventarc SaaS partners.
        :param pulumi.Input[_builtins.str] event_data_content_type: Optional. EventDataContentType specifies the type of payload in MIME format that is expected from the CloudEvent data field. This is set to `application/json` if the value is not defined.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. User labels attached to the triggers that can be used to group resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Required. The resource name of the trigger. Must be unique within the location on the project.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] service_account: Optional. The IAM service account email associated with the trigger. The service account represents the identity of the trigger. The principal who calls this API must have `iam.serviceAccounts.actAs` permission in the service account. See https://cloud.google.com/iam/docs/understanding-service-accounts#sa_common for more information. For Cloud Run destinations, this service account is used to generate identity tokens when invoking the service. See https://cloud.google.com/run/docs/triggering/pubsub-push#create-service-account for information on how to invoke authenticated Cloud Run services. In order to create Audit Log triggers, the service account should also have `roles/eventarc.eventReceiver` IAM role.
        :param pulumi.Input['TriggerTransportArgs'] transport: Optional. In order to deliver messages, Eventarc may use other GCP products as transport intermediary. This field contains a reference to that transport intermediary. This information can be used for debugging purposes.
               Structure is documented below.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "matching_criterias", matching_criterias)
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if event_data_content_type is not None:
            pulumi.set(__self__, "event_data_content_type", event_data_content_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if transport is not None:
            pulumi.set(__self__, "transport", transport)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input['TriggerDestinationArgs']:
        """
        Required. Destination specifies where the events should be sent to.
        Structure is documented below.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['TriggerDestinationArgs']):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="matchingCriterias")
    def matching_criterias(self) -> pulumi.Input[Sequence[pulumi.Input['TriggerMatchingCriteriaArgs']]]:
        """
        Required. null The list of filters that applies to event attributes. Only events that match all the provided filters will be sent to the destination.
        Structure is documented below.
        """
        return pulumi.get(self, "matching_criterias")

    @matching_criterias.setter
    def matching_criterias(self, value: pulumi.Input[Sequence[pulumi.Input['TriggerMatchingCriteriaArgs']]]):
        pulumi.set(self, "matching_criterias", value)

    @_builtins.property
    @pulumi.getter
    def channel(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The name of the channel associated with the trigger in `projects/{project}/locations/{location}/channels/{channel}` format. You must provide a channel to receive events from Eventarc SaaS partners.
        """
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channel", value)

    @_builtins.property
    @pulumi.getter(name="eventDataContentType")
    def event_data_content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. EventDataContentType specifies the type of payload in MIME format that is expected from the CloudEvent data field. This is set to `application/json` if the value is not defined.
        """
        return pulumi.get(self, "event_data_content_type")

    @event_data_content_type.setter
    def event_data_content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_data_content_type", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. User labels attached to the triggers that can be used to group resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. The resource name of the trigger. Must be unique within the location on the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The IAM service account email associated with the trigger. The service account represents the identity of the trigger. The principal who calls this API must have `iam.serviceAccounts.actAs` permission in the service account. See https://cloud.google.com/iam/docs/understanding-service-accounts#sa_common for more information. For Cloud Run destinations, this service account is used to generate identity tokens when invoking the service. See https://cloud.google.com/run/docs/triggering/pubsub-push#create-service-account for information on how to invoke authenticated Cloud Run services. In order to create Audit Log triggers, the service account should also have `roles/eventarc.eventReceiver` IAM role.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter
    def transport(self) -> Optional[pulumi.Input['TriggerTransportArgs']]:
        """
        Optional. In order to deliver messages, Eventarc may use other GCP products as transport intermediary. This field contains a reference to that transport intermediary. This information can be used for debugging purposes.
        Structure is documented below.
        """
        return pulumi.get(self, "transport")

    @transport.setter
    def transport(self, value: Optional[pulumi.Input['TriggerTransportArgs']]):
        pulumi.set(self, "transport", value)


@pulumi.input_type
class _TriggerState:
    def __init__(__self__, *,
                 channel: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input['TriggerDestinationArgs']] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 event_data_content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 matching_criterias: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerMatchingCriteriaArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 transport: Optional[pulumi.Input['TriggerTransportArgs']] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Trigger resources.
        :param pulumi.Input[_builtins.str] channel: Optional. The name of the channel associated with the trigger in `projects/{project}/locations/{location}/channels/{channel}` format. You must provide a channel to receive events from Eventarc SaaS partners.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] conditions: Output only. The reason(s) why a trigger is in FAILED state.
        :param pulumi.Input[_builtins.str] create_time: Output only. The creation time.
        :param pulumi.Input['TriggerDestinationArgs'] destination: Required. Destination specifies where the events should be sent to.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: Output only. This checksum is computed by the server based on the value of other fields, and may be sent only on create requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[_builtins.str] event_data_content_type: Optional. EventDataContentType specifies the type of payload in MIME format that is expected from the CloudEvent data field. This is set to `application/json` if the value is not defined.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. User labels attached to the triggers that can be used to group resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[Sequence[pulumi.Input['TriggerMatchingCriteriaArgs']]] matching_criterias: Required. null The list of filters that applies to event attributes. Only events that match all the provided filters will be sent to the destination.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Required. The resource name of the trigger. Must be unique within the location on the project.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] service_account: Optional. The IAM service account email associated with the trigger. The service account represents the identity of the trigger. The principal who calls this API must have `iam.serviceAccounts.actAs` permission in the service account. See https://cloud.google.com/iam/docs/understanding-service-accounts#sa_common for more information. For Cloud Run destinations, this service account is used to generate identity tokens when invoking the service. See https://cloud.google.com/run/docs/triggering/pubsub-push#create-service-account for information on how to invoke authenticated Cloud Run services. In order to create Audit Log triggers, the service account should also have `roles/eventarc.eventReceiver` IAM role.
        :param pulumi.Input['TriggerTransportArgs'] transport: Optional. In order to deliver messages, Eventarc may use other GCP products as transport intermediary. This field contains a reference to that transport intermediary. This information can be used for debugging purposes.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: Output only. Server assigned unique identifier for the trigger. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[_builtins.str] update_time: Output only. The last-modified time.
        """
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if event_data_content_type is not None:
            pulumi.set(__self__, "event_data_content_type", event_data_content_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if matching_criterias is not None:
            pulumi.set(__self__, "matching_criterias", matching_criterias)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if transport is not None:
            pulumi.set(__self__, "transport", transport)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def channel(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The name of the channel associated with the trigger in `projects/{project}/locations/{location}/channels/{channel}` format. You must provide a channel to receive events from Eventarc SaaS partners.
        """
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channel", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Output only. The reason(s) why a trigger is in FAILED state.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['TriggerDestinationArgs']]:
        """
        Required. Destination specifies where the events should be sent to.
        Structure is documented below.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['TriggerDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. This checksum is computed by the server based on the value of other fields, and may be sent only on create requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="eventDataContentType")
    def event_data_content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. EventDataContentType specifies the type of payload in MIME format that is expected from the CloudEvent data field. This is set to `application/json` if the value is not defined.
        """
        return pulumi.get(self, "event_data_content_type")

    @event_data_content_type.setter
    def event_data_content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_data_content_type", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. User labels attached to the triggers that can be used to group resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="matchingCriterias")
    def matching_criterias(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerMatchingCriteriaArgs']]]]:
        """
        Required. null The list of filters that applies to event attributes. Only events that match all the provided filters will be sent to the destination.
        Structure is documented below.
        """
        return pulumi.get(self, "matching_criterias")

    @matching_criterias.setter
    def matching_criterias(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerMatchingCriteriaArgs']]]]):
        pulumi.set(self, "matching_criterias", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. The resource name of the trigger. Must be unique within the location on the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The IAM service account email associated with the trigger. The service account represents the identity of the trigger. The principal who calls this API must have `iam.serviceAccounts.actAs` permission in the service account. See https://cloud.google.com/iam/docs/understanding-service-accounts#sa_common for more information. For Cloud Run destinations, this service account is used to generate identity tokens when invoking the service. See https://cloud.google.com/run/docs/triggering/pubsub-push#create-service-account for information on how to invoke authenticated Cloud Run services. In order to create Audit Log triggers, the service account should also have `roles/eventarc.eventReceiver` IAM role.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter
    def transport(self) -> Optional[pulumi.Input['TriggerTransportArgs']]:
        """
        Optional. In order to deliver messages, Eventarc may use other GCP products as transport intermediary. This field contains a reference to that transport intermediary. This information can be used for debugging purposes.
        Structure is documented below.
        """
        return pulumi.get(self, "transport")

    @transport.setter
    def transport(self, value: Optional[pulumi.Input['TriggerTransportArgs']]):
        pulumi.set(self, "transport", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Server assigned unique identifier for the trigger. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The last-modified time.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:eventarc/trigger:Trigger")
class Trigger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['TriggerDestinationArgs', 'TriggerDestinationArgsDict']]] = None,
                 event_data_content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 matching_criterias: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TriggerMatchingCriteriaArgs', 'TriggerMatchingCriteriaArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 transport: Optional[pulumi.Input[Union['TriggerTransportArgs', 'TriggerTransportArgsDict']]] = None,
                 __props__=None):
        """
        The Eventarc Trigger resource

        To get more information about Trigger, see:

        * [API documentation](https://cloud.google.com/eventarc/docs/reference/rest/v1/projects.locations.triggers)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/eventarc/standard/docs/overview#eventarc-triggers)

        ## Example Usage

        ### Eventarc Trigger With Cloud Run Destination

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foo = gcp.pubsub.Topic("foo", name="some-topic")
        default = gcp.cloudrun.Service("default",
            name="some-service",
            location="us-central1",
            template={
                "spec": {
                    "containers": [{
                        "image": "gcr.io/cloudrun/hello",
                        "ports": [{
                            "container_port": 8080,
                        }],
                    }],
                    "container_concurrency": 50,
                    "timeout_seconds": 100,
                },
            },
            traffics=[{
                "percent": 100,
                "latest_revision": True,
            }])
        primary = gcp.eventarc.Trigger("primary",
            name="some-trigger",
            location="us-central1",
            matching_criterias=[{
                "attribute": "type",
                "value": "google.cloud.pubsub.topic.v1.messagePublished",
            }],
            destination={
                "cloud_run_service": {
                    "service": default.name,
                    "region": "us-central1",
                },
            },
            labels={
                "foo": "bar",
            },
            transport={
                "pubsub": {
                    "topic": foo.id,
                },
            })
        ```

        ## Import

        Trigger can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/triggers/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Trigger can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:eventarc/trigger:Trigger default projects/{{project}}/locations/{{location}}/triggers/{{name}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/trigger:Trigger default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/trigger:Trigger default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] channel: Optional. The name of the channel associated with the trigger in `projects/{project}/locations/{location}/channels/{channel}` format. You must provide a channel to receive events from Eventarc SaaS partners.
        :param pulumi.Input[Union['TriggerDestinationArgs', 'TriggerDestinationArgsDict']] destination: Required. Destination specifies where the events should be sent to.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] event_data_content_type: Optional. EventDataContentType specifies the type of payload in MIME format that is expected from the CloudEvent data field. This is set to `application/json` if the value is not defined.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. User labels attached to the triggers that can be used to group resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['TriggerMatchingCriteriaArgs', 'TriggerMatchingCriteriaArgsDict']]]] matching_criterias: Required. null The list of filters that applies to event attributes. Only events that match all the provided filters will be sent to the destination.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Required. The resource name of the trigger. Must be unique within the location on the project.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] service_account: Optional. The IAM service account email associated with the trigger. The service account represents the identity of the trigger. The principal who calls this API must have `iam.serviceAccounts.actAs` permission in the service account. See https://cloud.google.com/iam/docs/understanding-service-accounts#sa_common for more information. For Cloud Run destinations, this service account is used to generate identity tokens when invoking the service. See https://cloud.google.com/run/docs/triggering/pubsub-push#create-service-account for information on how to invoke authenticated Cloud Run services. In order to create Audit Log triggers, the service account should also have `roles/eventarc.eventReceiver` IAM role.
        :param pulumi.Input[Union['TriggerTransportArgs', 'TriggerTransportArgsDict']] transport: Optional. In order to deliver messages, Eventarc may use other GCP products as transport intermediary. This field contains a reference to that transport intermediary. This information can be used for debugging purposes.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TriggerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Eventarc Trigger resource

        To get more information about Trigger, see:

        * [API documentation](https://cloud.google.com/eventarc/docs/reference/rest/v1/projects.locations.triggers)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/eventarc/standard/docs/overview#eventarc-triggers)

        ## Example Usage

        ### Eventarc Trigger With Cloud Run Destination

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foo = gcp.pubsub.Topic("foo", name="some-topic")
        default = gcp.cloudrun.Service("default",
            name="some-service",
            location="us-central1",
            template={
                "spec": {
                    "containers": [{
                        "image": "gcr.io/cloudrun/hello",
                        "ports": [{
                            "container_port": 8080,
                        }],
                    }],
                    "container_concurrency": 50,
                    "timeout_seconds": 100,
                },
            },
            traffics=[{
                "percent": 100,
                "latest_revision": True,
            }])
        primary = gcp.eventarc.Trigger("primary",
            name="some-trigger",
            location="us-central1",
            matching_criterias=[{
                "attribute": "type",
                "value": "google.cloud.pubsub.topic.v1.messagePublished",
            }],
            destination={
                "cloud_run_service": {
                    "service": default.name,
                    "region": "us-central1",
                },
            },
            labels={
                "foo": "bar",
            },
            transport={
                "pubsub": {
                    "topic": foo.id,
                },
            })
        ```

        ## Import

        Trigger can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/triggers/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Trigger can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:eventarc/trigger:Trigger default projects/{{project}}/locations/{{location}}/triggers/{{name}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/trigger:Trigger default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:eventarc/trigger:Trigger default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param TriggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TriggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['TriggerDestinationArgs', 'TriggerDestinationArgsDict']]] = None,
                 event_data_content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 matching_criterias: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TriggerMatchingCriteriaArgs', 'TriggerMatchingCriteriaArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 transport: Optional[pulumi.Input[Union['TriggerTransportArgs', 'TriggerTransportArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TriggerArgs.__new__(TriggerArgs)

            __props__.__dict__["channel"] = channel
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["event_data_content_type"] = event_data_content_type
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if matching_criterias is None and not opts.urn:
                raise TypeError("Missing required property 'matching_criterias'")
            __props__.__dict__["matching_criterias"] = matching_criterias
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["transport"] = transport
            __props__.__dict__["conditions"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Trigger, __self__).__init__(
            'gcp:eventarc/trigger:Trigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            channel: Optional[pulumi.Input[_builtins.str]] = None,
            conditions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[Union['TriggerDestinationArgs', 'TriggerDestinationArgsDict']]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            event_data_content_type: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            matching_criterias: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TriggerMatchingCriteriaArgs', 'TriggerMatchingCriteriaArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            service_account: Optional[pulumi.Input[_builtins.str]] = None,
            transport: Optional[pulumi.Input[Union['TriggerTransportArgs', 'TriggerTransportArgsDict']]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Trigger':
        """
        Get an existing Trigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] channel: Optional. The name of the channel associated with the trigger in `projects/{project}/locations/{location}/channels/{channel}` format. You must provide a channel to receive events from Eventarc SaaS partners.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] conditions: Output only. The reason(s) why a trigger is in FAILED state.
        :param pulumi.Input[_builtins.str] create_time: Output only. The creation time.
        :param pulumi.Input[Union['TriggerDestinationArgs', 'TriggerDestinationArgsDict']] destination: Required. Destination specifies where the events should be sent to.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: Output only. This checksum is computed by the server based on the value of other fields, and may be sent only on create requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[_builtins.str] event_data_content_type: Optional. EventDataContentType specifies the type of payload in MIME format that is expected from the CloudEvent data field. This is set to `application/json` if the value is not defined.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. User labels attached to the triggers that can be used to group resources.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[Sequence[pulumi.Input[Union['TriggerMatchingCriteriaArgs', 'TriggerMatchingCriteriaArgsDict']]]] matching_criterias: Required. null The list of filters that applies to event attributes. Only events that match all the provided filters will be sent to the destination.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Required. The resource name of the trigger. Must be unique within the location on the project.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] service_account: Optional. The IAM service account email associated with the trigger. The service account represents the identity of the trigger. The principal who calls this API must have `iam.serviceAccounts.actAs` permission in the service account. See https://cloud.google.com/iam/docs/understanding-service-accounts#sa_common for more information. For Cloud Run destinations, this service account is used to generate identity tokens when invoking the service. See https://cloud.google.com/run/docs/triggering/pubsub-push#create-service-account for information on how to invoke authenticated Cloud Run services. In order to create Audit Log triggers, the service account should also have `roles/eventarc.eventReceiver` IAM role.
        :param pulumi.Input[Union['TriggerTransportArgs', 'TriggerTransportArgsDict']] transport: Optional. In order to deliver messages, Eventarc may use other GCP products as transport intermediary. This field contains a reference to that transport intermediary. This information can be used for debugging purposes.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: Output only. Server assigned unique identifier for the trigger. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[_builtins.str] update_time: Output only. The last-modified time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TriggerState.__new__(_TriggerState)

        __props__.__dict__["channel"] = channel
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["destination"] = destination
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["event_data_content_type"] = event_data_content_type
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["matching_criterias"] = matching_criterias
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["transport"] = transport
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Trigger(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def channel(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. The name of the channel associated with the trigger in `projects/{project}/locations/{location}/channels/{channel}` format. You must provide a channel to receive events from Eventarc SaaS partners.
        """
        return pulumi.get(self, "channel")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Output only. The reason(s) why a trigger is in FAILED state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output['outputs.TriggerDestination']:
        """
        Required. Destination specifies where the events should be sent to.
        Structure is documented below.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. This checksum is computed by the server based on the value of other fields, and may be sent only on create requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="eventDataContentType")
    def event_data_content_type(self) -> pulumi.Output[_builtins.str]:
        """
        Optional. EventDataContentType specifies the type of payload in MIME format that is expected from the CloudEvent data field. This is set to `application/json` if the value is not defined.
        """
        return pulumi.get(self, "event_data_content_type")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Optional. User labels attached to the triggers that can be used to group resources.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="matchingCriterias")
    def matching_criterias(self) -> pulumi.Output[Sequence['outputs.TriggerMatchingCriteria']]:
        """
        Required. null The list of filters that applies to event attributes. Only events that match all the provided filters will be sent to the destination.
        Structure is documented below.
        """
        return pulumi.get(self, "matching_criterias")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Required. The resource name of the trigger. Must be unique within the location on the project.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. The IAM service account email associated with the trigger. The service account represents the identity of the trigger. The principal who calls this API must have `iam.serviceAccounts.actAs` permission in the service account. See https://cloud.google.com/iam/docs/understanding-service-accounts#sa_common for more information. For Cloud Run destinations, this service account is used to generate identity tokens when invoking the service. See https://cloud.google.com/run/docs/triggering/pubsub-push#create-service-account for information on how to invoke authenticated Cloud Run services. In order to create Audit Log triggers, the service account should also have `roles/eventarc.eventReceiver` IAM role.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def transport(self) -> pulumi.Output['outputs.TriggerTransport']:
        """
        Optional. In order to deliver messages, Eventarc may use other GCP products as transport intermediary. This field contains a reference to that transport intermediary. This information can be used for debugging purposes.
        Structure is documented below.
        """
        return pulumi.get(self, "transport")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Server assigned unique identifier for the trigger. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The last-modified time.
        """
        return pulumi.get(self, "update_time")

