# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HostingCustomDomainArgs', 'HostingCustomDomain']

@pulumi.input_type
class HostingCustomDomainArgs:
    def __init__(__self__, *,
                 custom_domain: pulumi.Input[_builtins.str],
                 site_id: pulumi.Input[_builtins.str],
                 cert_preference: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_target: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_dns_verification: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a HostingCustomDomain resource.
        :param pulumi.Input[_builtins.str] custom_domain: The ID of the `CustomDomain`, which is the domain name you'd like to use with Firebase Hosting.
        :param pulumi.Input[_builtins.str] site_id: The ID of the site in which to create this custom domain association.
        :param pulumi.Input[_builtins.str] cert_preference: A field that lets you specify which SSL certificate type Hosting creates
               for your domain name. Spark plan `CustomDomain`s only have access to the
               `GROUPED` cert type, while Blaze plan can select any option.
               Possible values are: `GROUPED`, `PROJECT_GROUPED`, `DEDICATED`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] redirect_target: A domain name that this CustomDomain should direct traffic towards. If
               specified, Hosting will respond to requests against this CustomDomain
               with an HTTP 301 code, and route traffic to the specified `redirect_target`
               instead.
        """
        pulumi.set(__self__, "custom_domain", custom_domain)
        pulumi.set(__self__, "site_id", site_id)
        if cert_preference is not None:
            pulumi.set(__self__, "cert_preference", cert_preference)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if redirect_target is not None:
            pulumi.set(__self__, "redirect_target", redirect_target)
        if wait_dns_verification is not None:
            pulumi.set(__self__, "wait_dns_verification", wait_dns_verification)

    @_builtins.property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the `CustomDomain`, which is the domain name you'd like to use with Firebase Hosting.
        """
        return pulumi.get(self, "custom_domain")

    @custom_domain.setter
    def custom_domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "custom_domain", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the site in which to create this custom domain association.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="certPreference")
    def cert_preference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A field that lets you specify which SSL certificate type Hosting creates
        for your domain name. Spark plan `CustomDomain`s only have access to the
        `GROUPED` cert type, while Blaze plan can select any option.
        Possible values are: `GROUPED`, `PROJECT_GROUPED`, `DEDICATED`.
        """
        return pulumi.get(self, "cert_preference")

    @cert_preference.setter
    def cert_preference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_preference", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="redirectTarget")
    def redirect_target(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A domain name that this CustomDomain should direct traffic towards. If
        specified, Hosting will respond to requests against this CustomDomain
        with an HTTP 301 code, and route traffic to the specified `redirect_target`
        instead.
        """
        return pulumi.get(self, "redirect_target")

    @redirect_target.setter
    def redirect_target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redirect_target", value)

    @_builtins.property
    @pulumi.getter(name="waitDnsVerification")
    def wait_dns_verification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "wait_dns_verification")

    @wait_dns_verification.setter
    def wait_dns_verification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_dns_verification", value)


@pulumi.input_type
class _HostingCustomDomainState:
    def __init__(__self__, *,
                 cert_preference: Optional[pulumi.Input[_builtins.str]] = None,
                 certs: Optional[pulumi.Input[Sequence[pulumi.Input['HostingCustomDomainCertArgs']]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_time: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 host_state: Optional[pulumi.Input[_builtins.str]] = None,
                 issues: Optional[pulumi.Input[Sequence[pulumi.Input['HostingCustomDomainIssueArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ownership_state: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
                 redirect_target: Optional[pulumi.Input[_builtins.str]] = None,
                 required_dns_updates: Optional[pulumi.Input[Sequence[pulumi.Input['HostingCustomDomainRequiredDnsUpdateArgs']]]] = None,
                 site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_dns_verification: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering HostingCustomDomain resources.
        :param pulumi.Input[_builtins.str] cert_preference: A field that lets you specify which SSL certificate type Hosting creates
               for your domain name. Spark plan `CustomDomain`s only have access to the
               `GROUPED` cert type, while Blaze plan can select any option.
               Possible values are: `GROUPED`, `PROJECT_GROUPED`, `DEDICATED`.
        :param pulumi.Input[Sequence[pulumi.Input['HostingCustomDomainCertArgs']]] certs: The SSL certificate Hosting has for this `CustomDomain`'s domain name.
               For new `CustomDomain`s, this often represents Hosting's intent to create
               a certificate, rather than an actual cert. Check the `state` field for
               more.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The `CustomDomain`'s create time.
        :param pulumi.Input[_builtins.str] custom_domain: The ID of the `CustomDomain`, which is the domain name you'd like to use with Firebase Hosting.
        :param pulumi.Input[_builtins.str] delete_time: The time the `CustomDomain` was deleted; null for `CustomDomains` that
               haven't been deleted. Deleted `CustomDomains` persist for approximately 30
               days, after which time Hosting removes them completely.
        :param pulumi.Input[_builtins.str] etag: A string that represents the current state of the `CustomDomain` and
               allows you to confirm its initial state in requests that would modify it.
        :param pulumi.Input[_builtins.str] expire_time: The minimum time before a soft-deleted `CustomDomain` is completely removed
               from Hosting; null for `CustomDomains` that haven't been deleted.
        :param pulumi.Input[_builtins.str] host_state: The host state of your domain name. Host state is determined by checking each
               IP address associated with your domain name to see if it's serving
               Hosting content.
               HOST_UNHOSTED:
               Your `CustomDomain`'s domain name isn't associated with any IP addresses.
               HOST_UNREACHABLE:
               Your `CustomDomain`'s domain name can't be reached. Hosting services' DNS
               queries to find your domain name's IP addresses resulted in errors. See
               your `CustomDomain`'s `issues` field for more details.
               HOST_MISMATCH:
               Your `CustomDomain`'s domain name has IP addresses that don't ultimately
               resolve to Hosting.
               HOST_CONFLICT:
               Your `CustomDomain`'s domain name has IP addresses that resolve to both
               Hosting and other services. To ensure consistent results, remove `A` and
               `AAAA` records related to non-Hosting services.
               HOST_ACTIVE:
               All requests against your `CustomDomain`'s domain name are served by
               Hosting. If the `CustomDomain`'s `OwnershipState` is also `ACTIVE`, Hosting
               serves your Hosting Site's content on the domain name.
        :param pulumi.Input[Sequence[pulumi.Input['HostingCustomDomainIssueArgs']]] issues: A set of errors Hosting systems encountered when trying to establish
               Hosting's ability to serve secure content for your domain name. Resolve
               these issues to ensure your `CustomDomain` behaves properly.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The fully-qualified name of the `CustomDomain`.
        :param pulumi.Input[_builtins.str] ownership_state: The ownership state of your domain name. Ownership is determined at a
               Firebase project level, and established by adding `TXT` records to your
               domain name's DNS records.
               Ownership cascades to subdomains. Granting a project ownership of `foo.com`
               also grants that project ownership over `bar.foo.com`, unless you add
               specific `TXT` records to `bar.foo.com` that grant a different project
               ownership.
               If your `CustomDomain` is in an `OwnershipState` other than
               `OWNERSHIP_ACTIVE` for more than 30 days and it hasn't been updated in at
               least 30 days, Hosting's ownership systems delete the `CustomDomain`.
               OWNERSHIP_MISSING:
               Your `CustomDomain`'s domain name has no Hosting-related ownership records;
               no Firebase project has permission to act on the domain name's behalf.
               OWNERSHIP_UNREACHABLE:
               Your `CustomDomain`'s domain name can't be reached. Hosting services' DNS
               queries to find your domain name's ownership records resulted in errors.
               See your `CustomDomain`'s `issues` field for more details.
               OWNERSHIP_MISMATCH:
               Your `CustomDomain`'s domain name is owned by another Firebase project.
               Remove the conflicting `TXT` records and replace them with project-specific
               records for your current Firebase project.
               OWNERSHIP_CONFLICT:
               Your `CustomDomain`'s domain name has conflicting `TXT` records that
               indicate ownership by both your current Firebase project and another
               project. Remove the other project's ownership records to grant the current
               project ownership.
               OWNERSHIP_PENDING:
               Your `CustomDomain`'s DNS records are configured correctly. Hosting will
               transfer ownership of your domain to this `CustomDomain` within 24 hours.
               OWNERSHIP_ACTIVE:
               Your `CustomDomain`'s domain name has `TXT` records that grant its project
               permission to act on its behalf.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] reconciling: if true, indicates that Hosting's systems are attempting to
               make the `CustomDomain`'s state match your preferred state. This is most
               frequently `true` when initially provisioning a `CustomDomain` or when creating
               a new SSL certificate to match an updated `cert_preference`
        :param pulumi.Input[_builtins.str] redirect_target: A domain name that this CustomDomain should direct traffic towards. If
               specified, Hosting will respond to requests against this CustomDomain
               with an HTTP 301 code, and route traffic to the specified `redirect_target`
               instead.
        :param pulumi.Input[Sequence[pulumi.Input['HostingCustomDomainRequiredDnsUpdateArgs']]] required_dns_updates: A set of updates you should make to the domain name's DNS records to
               let Hosting serve secure content on its behalf.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] site_id: The ID of the site in which to create this custom domain association.
        :param pulumi.Input[_builtins.str] update_time: The last time the `CustomDomain` was updated.
        """
        if cert_preference is not None:
            pulumi.set(__self__, "cert_preference", cert_preference)
        if certs is not None:
            pulumi.set(__self__, "certs", certs)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if custom_domain is not None:
            pulumi.set(__self__, "custom_domain", custom_domain)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if host_state is not None:
            pulumi.set(__self__, "host_state", host_state)
        if issues is not None:
            pulumi.set(__self__, "issues", issues)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ownership_state is not None:
            pulumi.set(__self__, "ownership_state", ownership_state)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if redirect_target is not None:
            pulumi.set(__self__, "redirect_target", redirect_target)
        if required_dns_updates is not None:
            pulumi.set(__self__, "required_dns_updates", required_dns_updates)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if wait_dns_verification is not None:
            pulumi.set(__self__, "wait_dns_verification", wait_dns_verification)

    @_builtins.property
    @pulumi.getter(name="certPreference")
    def cert_preference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A field that lets you specify which SSL certificate type Hosting creates
        for your domain name. Spark plan `CustomDomain`s only have access to the
        `GROUPED` cert type, while Blaze plan can select any option.
        Possible values are: `GROUPED`, `PROJECT_GROUPED`, `DEDICATED`.
        """
        return pulumi.get(self, "cert_preference")

    @cert_preference.setter
    def cert_preference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_preference", value)

    @_builtins.property
    @pulumi.getter
    def certs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HostingCustomDomainCertArgs']]]]:
        """
        The SSL certificate Hosting has for this `CustomDomain`'s domain name.
        For new `CustomDomain`s, this often represents Hosting's intent to create
        a certificate, rather than an actual cert. Check the `state` field for
        more.
        Structure is documented below.
        """
        return pulumi.get(self, "certs")

    @certs.setter
    def certs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HostingCustomDomainCertArgs']]]]):
        pulumi.set(self, "certs", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `CustomDomain`'s create time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the `CustomDomain`, which is the domain name you'd like to use with Firebase Hosting.
        """
        return pulumi.get(self, "custom_domain")

    @custom_domain.setter
    def custom_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_domain", value)

    @_builtins.property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time the `CustomDomain` was deleted; null for `CustomDomains` that
        haven't been deleted. Deleted `CustomDomains` persist for approximately 30
        days, after which time Hosting removes them completely.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_time", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string that represents the current state of the `CustomDomain` and
        allows you to confirm its initial state in requests that would modify it.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum time before a soft-deleted `CustomDomain` is completely removed
        from Hosting; null for `CustomDomains` that haven't been deleted.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @_builtins.property
    @pulumi.getter(name="hostState")
    def host_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host state of your domain name. Host state is determined by checking each
        IP address associated with your domain name to see if it's serving
        Hosting content.
        HOST_UNHOSTED:
        Your `CustomDomain`'s domain name isn't associated with any IP addresses.
        HOST_UNREACHABLE:
        Your `CustomDomain`'s domain name can't be reached. Hosting services' DNS
        queries to find your domain name's IP addresses resulted in errors. See
        your `CustomDomain`'s `issues` field for more details.
        HOST_MISMATCH:
        Your `CustomDomain`'s domain name has IP addresses that don't ultimately
        resolve to Hosting.
        HOST_CONFLICT:
        Your `CustomDomain`'s domain name has IP addresses that resolve to both
        Hosting and other services. To ensure consistent results, remove `A` and
        `AAAA` records related to non-Hosting services.
        HOST_ACTIVE:
        All requests against your `CustomDomain`'s domain name are served by
        Hosting. If the `CustomDomain`'s `OwnershipState` is also `ACTIVE`, Hosting
        serves your Hosting Site's content on the domain name.
        """
        return pulumi.get(self, "host_state")

    @host_state.setter
    def host_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_state", value)

    @_builtins.property
    @pulumi.getter
    def issues(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HostingCustomDomainIssueArgs']]]]:
        """
        A set of errors Hosting systems encountered when trying to establish
        Hosting's ability to serve secure content for your domain name. Resolve
        these issues to ensure your `CustomDomain` behaves properly.
        Structure is documented below.
        """
        return pulumi.get(self, "issues")

    @issues.setter
    def issues(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HostingCustomDomainIssueArgs']]]]):
        pulumi.set(self, "issues", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully-qualified name of the `CustomDomain`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownershipState")
    def ownership_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ownership state of your domain name. Ownership is determined at a
        Firebase project level, and established by adding `TXT` records to your
        domain name's DNS records.
        Ownership cascades to subdomains. Granting a project ownership of `foo.com`
        also grants that project ownership over `bar.foo.com`, unless you add
        specific `TXT` records to `bar.foo.com` that grant a different project
        ownership.
        If your `CustomDomain` is in an `OwnershipState` other than
        `OWNERSHIP_ACTIVE` for more than 30 days and it hasn't been updated in at
        least 30 days, Hosting's ownership systems delete the `CustomDomain`.
        OWNERSHIP_MISSING:
        Your `CustomDomain`'s domain name has no Hosting-related ownership records;
        no Firebase project has permission to act on the domain name's behalf.
        OWNERSHIP_UNREACHABLE:
        Your `CustomDomain`'s domain name can't be reached. Hosting services' DNS
        queries to find your domain name's ownership records resulted in errors.
        See your `CustomDomain`'s `issues` field for more details.
        OWNERSHIP_MISMATCH:
        Your `CustomDomain`'s domain name is owned by another Firebase project.
        Remove the conflicting `TXT` records and replace them with project-specific
        records for your current Firebase project.
        OWNERSHIP_CONFLICT:
        Your `CustomDomain`'s domain name has conflicting `TXT` records that
        indicate ownership by both your current Firebase project and another
        project. Remove the other project's ownership records to grant the current
        project ownership.
        OWNERSHIP_PENDING:
        Your `CustomDomain`'s DNS records are configured correctly. Hosting will
        transfer ownership of your domain to this `CustomDomain` within 24 hours.
        OWNERSHIP_ACTIVE:
        Your `CustomDomain`'s domain name has `TXT` records that grant its project
        permission to act on its behalf.
        """
        return pulumi.get(self, "ownership_state")

    @ownership_state.setter
    def ownership_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ownership_state", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        if true, indicates that Hosting's systems are attempting to
        make the `CustomDomain`'s state match your preferred state. This is most
        frequently `true` when initially provisioning a `CustomDomain` or when creating
        a new SSL certificate to match an updated `cert_preference`
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @_builtins.property
    @pulumi.getter(name="redirectTarget")
    def redirect_target(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A domain name that this CustomDomain should direct traffic towards. If
        specified, Hosting will respond to requests against this CustomDomain
        with an HTTP 301 code, and route traffic to the specified `redirect_target`
        instead.
        """
        return pulumi.get(self, "redirect_target")

    @redirect_target.setter
    def redirect_target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redirect_target", value)

    @_builtins.property
    @pulumi.getter(name="requiredDnsUpdates")
    def required_dns_updates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HostingCustomDomainRequiredDnsUpdateArgs']]]]:
        """
        A set of updates you should make to the domain name's DNS records to
        let Hosting serve secure content on its behalf.
        Structure is documented below.
        """
        return pulumi.get(self, "required_dns_updates")

    @required_dns_updates.setter
    def required_dns_updates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HostingCustomDomainRequiredDnsUpdateArgs']]]]):
        pulumi.set(self, "required_dns_updates", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the site in which to create this custom domain association.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last time the `CustomDomain` was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="waitDnsVerification")
    def wait_dns_verification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "wait_dns_verification")

    @wait_dns_verification.setter
    def wait_dns_verification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_dns_verification", value)


@pulumi.type_token("gcp:firebase/hostingCustomDomain:HostingCustomDomain")
class HostingCustomDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cert_preference: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_target: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_dns_verification: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Firebasehosting Customdomain Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingCustomDomain("default",
            project="my-project-name",
            site_id="site-id",
            custom_domain="custom.domain.com")
        ```
        ### Firebasehosting Customdomain Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-id-full")
        default_hosting_custom_domain = gcp.firebase.HostingCustomDomain("default",
            project="my-project-name",
            site_id=default.site_id,
            custom_domain="source.domain.com",
            cert_preference="GROUPED",
            redirect_target="destination.domain.com",
            wait_dns_verification=False)
        ```
        ### Firebasehosting Customdomain Cloud Run

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-id")
        default_service = gcp.cloudrunv2.Service("default",
            project="my-project-name",
            name="cloud-run-service-via-hosting",
            location="us-central1",
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                }],
            },
            deletion_protection=True)
        default_hosting_version = gcp.firebase.HostingVersion("default",
            site_id=default.site_id,
            config={
                "rewrites": [{
                    "glob": "/hello/**",
                    "run": {
                        "service_id": default_service.name,
                        "region": default_service.location,
                    },
                }],
            })
        default_hosting_release = gcp.firebase.HostingRelease("default",
            site_id=default.site_id,
            version_name=default_hosting_version.name,
            message="Cloud Run Integration")
        default_hosting_custom_domain = gcp.firebase.HostingCustomDomain("default",
            project="my-project-name",
            site_id=default.site_id,
            custom_domain="run.custom.domain.com",
            wait_dns_verification=False)
        ```

        ## Import

        CustomDomain can be imported using any of these accepted formats:

        * `projects/{{project}}/sites/{{site_id}}/customDomains/{{custom_domain}}`

        * `sites/{{site_id}}/customDomains/{{custom_domain}}`

        * `{{project}}/{{site_id}}/{{custom_domain}}`

        * `{{site_id}}/{{custom_domain}}`

        When using the `pulumi import` command, CustomDomain can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/hostingCustomDomain:HostingCustomDomain default projects/{{project}}/sites/{{site_id}}/customDomains/{{custom_domain}}
        ```

        ```sh
        $ pulumi import gcp:firebase/hostingCustomDomain:HostingCustomDomain default sites/{{site_id}}/customDomains/{{custom_domain}}
        ```

        ```sh
        $ pulumi import gcp:firebase/hostingCustomDomain:HostingCustomDomain default {{project}}/{{site_id}}/{{custom_domain}}
        ```

        ```sh
        $ pulumi import gcp:firebase/hostingCustomDomain:HostingCustomDomain default {{site_id}}/{{custom_domain}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cert_preference: A field that lets you specify which SSL certificate type Hosting creates
               for your domain name. Spark plan `CustomDomain`s only have access to the
               `GROUPED` cert type, while Blaze plan can select any option.
               Possible values are: `GROUPED`, `PROJECT_GROUPED`, `DEDICATED`.
        :param pulumi.Input[_builtins.str] custom_domain: The ID of the `CustomDomain`, which is the domain name you'd like to use with Firebase Hosting.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] redirect_target: A domain name that this CustomDomain should direct traffic towards. If
               specified, Hosting will respond to requests against this CustomDomain
               with an HTTP 301 code, and route traffic to the specified `redirect_target`
               instead.
        :param pulumi.Input[_builtins.str] site_id: The ID of the site in which to create this custom domain association.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostingCustomDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Firebasehosting Customdomain Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingCustomDomain("default",
            project="my-project-name",
            site_id="site-id",
            custom_domain="custom.domain.com")
        ```
        ### Firebasehosting Customdomain Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-id-full")
        default_hosting_custom_domain = gcp.firebase.HostingCustomDomain("default",
            project="my-project-name",
            site_id=default.site_id,
            custom_domain="source.domain.com",
            cert_preference="GROUPED",
            redirect_target="destination.domain.com",
            wait_dns_verification=False)
        ```
        ### Firebasehosting Customdomain Cloud Run

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.firebase.HostingSite("default",
            project="my-project-name",
            site_id="site-id")
        default_service = gcp.cloudrunv2.Service("default",
            project="my-project-name",
            name="cloud-run-service-via-hosting",
            location="us-central1",
            ingress="INGRESS_TRAFFIC_ALL",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/hello",
                }],
            },
            deletion_protection=True)
        default_hosting_version = gcp.firebase.HostingVersion("default",
            site_id=default.site_id,
            config={
                "rewrites": [{
                    "glob": "/hello/**",
                    "run": {
                        "service_id": default_service.name,
                        "region": default_service.location,
                    },
                }],
            })
        default_hosting_release = gcp.firebase.HostingRelease("default",
            site_id=default.site_id,
            version_name=default_hosting_version.name,
            message="Cloud Run Integration")
        default_hosting_custom_domain = gcp.firebase.HostingCustomDomain("default",
            project="my-project-name",
            site_id=default.site_id,
            custom_domain="run.custom.domain.com",
            wait_dns_verification=False)
        ```

        ## Import

        CustomDomain can be imported using any of these accepted formats:

        * `projects/{{project}}/sites/{{site_id}}/customDomains/{{custom_domain}}`

        * `sites/{{site_id}}/customDomains/{{custom_domain}}`

        * `{{project}}/{{site_id}}/{{custom_domain}}`

        * `{{site_id}}/{{custom_domain}}`

        When using the `pulumi import` command, CustomDomain can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/hostingCustomDomain:HostingCustomDomain default projects/{{project}}/sites/{{site_id}}/customDomains/{{custom_domain}}
        ```

        ```sh
        $ pulumi import gcp:firebase/hostingCustomDomain:HostingCustomDomain default sites/{{site_id}}/customDomains/{{custom_domain}}
        ```

        ```sh
        $ pulumi import gcp:firebase/hostingCustomDomain:HostingCustomDomain default {{project}}/{{site_id}}/{{custom_domain}}
        ```

        ```sh
        $ pulumi import gcp:firebase/hostingCustomDomain:HostingCustomDomain default {{site_id}}/{{custom_domain}}
        ```

        :param str resource_name: The name of the resource.
        :param HostingCustomDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostingCustomDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cert_preference: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_target: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_dns_verification: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostingCustomDomainArgs.__new__(HostingCustomDomainArgs)

            __props__.__dict__["cert_preference"] = cert_preference
            if custom_domain is None and not opts.urn:
                raise TypeError("Missing required property 'custom_domain'")
            __props__.__dict__["custom_domain"] = custom_domain
            __props__.__dict__["project"] = project
            __props__.__dict__["redirect_target"] = redirect_target
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["wait_dns_verification"] = wait_dns_verification
            __props__.__dict__["certs"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["expire_time"] = None
            __props__.__dict__["host_state"] = None
            __props__.__dict__["issues"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["ownership_state"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["required_dns_updates"] = None
            __props__.__dict__["update_time"] = None
        super(HostingCustomDomain, __self__).__init__(
            'gcp:firebase/hostingCustomDomain:HostingCustomDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cert_preference: Optional[pulumi.Input[_builtins.str]] = None,
            certs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HostingCustomDomainCertArgs', 'HostingCustomDomainCertArgsDict']]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            custom_domain: Optional[pulumi.Input[_builtins.str]] = None,
            delete_time: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            expire_time: Optional[pulumi.Input[_builtins.str]] = None,
            host_state: Optional[pulumi.Input[_builtins.str]] = None,
            issues: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HostingCustomDomainIssueArgs', 'HostingCustomDomainIssueArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            ownership_state: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
            redirect_target: Optional[pulumi.Input[_builtins.str]] = None,
            required_dns_updates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HostingCustomDomainRequiredDnsUpdateArgs', 'HostingCustomDomainRequiredDnsUpdateArgsDict']]]]] = None,
            site_id: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            wait_dns_verification: Optional[pulumi.Input[_builtins.bool]] = None) -> 'HostingCustomDomain':
        """
        Get an existing HostingCustomDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cert_preference: A field that lets you specify which SSL certificate type Hosting creates
               for your domain name. Spark plan `CustomDomain`s only have access to the
               `GROUPED` cert type, while Blaze plan can select any option.
               Possible values are: `GROUPED`, `PROJECT_GROUPED`, `DEDICATED`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HostingCustomDomainCertArgs', 'HostingCustomDomainCertArgsDict']]]] certs: The SSL certificate Hosting has for this `CustomDomain`'s domain name.
               For new `CustomDomain`s, this often represents Hosting's intent to create
               a certificate, rather than an actual cert. Check the `state` field for
               more.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The `CustomDomain`'s create time.
        :param pulumi.Input[_builtins.str] custom_domain: The ID of the `CustomDomain`, which is the domain name you'd like to use with Firebase Hosting.
        :param pulumi.Input[_builtins.str] delete_time: The time the `CustomDomain` was deleted; null for `CustomDomains` that
               haven't been deleted. Deleted `CustomDomains` persist for approximately 30
               days, after which time Hosting removes them completely.
        :param pulumi.Input[_builtins.str] etag: A string that represents the current state of the `CustomDomain` and
               allows you to confirm its initial state in requests that would modify it.
        :param pulumi.Input[_builtins.str] expire_time: The minimum time before a soft-deleted `CustomDomain` is completely removed
               from Hosting; null for `CustomDomains` that haven't been deleted.
        :param pulumi.Input[_builtins.str] host_state: The host state of your domain name. Host state is determined by checking each
               IP address associated with your domain name to see if it's serving
               Hosting content.
               HOST_UNHOSTED:
               Your `CustomDomain`'s domain name isn't associated with any IP addresses.
               HOST_UNREACHABLE:
               Your `CustomDomain`'s domain name can't be reached. Hosting services' DNS
               queries to find your domain name's IP addresses resulted in errors. See
               your `CustomDomain`'s `issues` field for more details.
               HOST_MISMATCH:
               Your `CustomDomain`'s domain name has IP addresses that don't ultimately
               resolve to Hosting.
               HOST_CONFLICT:
               Your `CustomDomain`'s domain name has IP addresses that resolve to both
               Hosting and other services. To ensure consistent results, remove `A` and
               `AAAA` records related to non-Hosting services.
               HOST_ACTIVE:
               All requests against your `CustomDomain`'s domain name are served by
               Hosting. If the `CustomDomain`'s `OwnershipState` is also `ACTIVE`, Hosting
               serves your Hosting Site's content on the domain name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HostingCustomDomainIssueArgs', 'HostingCustomDomainIssueArgsDict']]]] issues: A set of errors Hosting systems encountered when trying to establish
               Hosting's ability to serve secure content for your domain name. Resolve
               these issues to ensure your `CustomDomain` behaves properly.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The fully-qualified name of the `CustomDomain`.
        :param pulumi.Input[_builtins.str] ownership_state: The ownership state of your domain name. Ownership is determined at a
               Firebase project level, and established by adding `TXT` records to your
               domain name's DNS records.
               Ownership cascades to subdomains. Granting a project ownership of `foo.com`
               also grants that project ownership over `bar.foo.com`, unless you add
               specific `TXT` records to `bar.foo.com` that grant a different project
               ownership.
               If your `CustomDomain` is in an `OwnershipState` other than
               `OWNERSHIP_ACTIVE` for more than 30 days and it hasn't been updated in at
               least 30 days, Hosting's ownership systems delete the `CustomDomain`.
               OWNERSHIP_MISSING:
               Your `CustomDomain`'s domain name has no Hosting-related ownership records;
               no Firebase project has permission to act on the domain name's behalf.
               OWNERSHIP_UNREACHABLE:
               Your `CustomDomain`'s domain name can't be reached. Hosting services' DNS
               queries to find your domain name's ownership records resulted in errors.
               See your `CustomDomain`'s `issues` field for more details.
               OWNERSHIP_MISMATCH:
               Your `CustomDomain`'s domain name is owned by another Firebase project.
               Remove the conflicting `TXT` records and replace them with project-specific
               records for your current Firebase project.
               OWNERSHIP_CONFLICT:
               Your `CustomDomain`'s domain name has conflicting `TXT` records that
               indicate ownership by both your current Firebase project and another
               project. Remove the other project's ownership records to grant the current
               project ownership.
               OWNERSHIP_PENDING:
               Your `CustomDomain`'s DNS records are configured correctly. Hosting will
               transfer ownership of your domain to this `CustomDomain` within 24 hours.
               OWNERSHIP_ACTIVE:
               Your `CustomDomain`'s domain name has `TXT` records that grant its project
               permission to act on its behalf.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] reconciling: if true, indicates that Hosting's systems are attempting to
               make the `CustomDomain`'s state match your preferred state. This is most
               frequently `true` when initially provisioning a `CustomDomain` or when creating
               a new SSL certificate to match an updated `cert_preference`
        :param pulumi.Input[_builtins.str] redirect_target: A domain name that this CustomDomain should direct traffic towards. If
               specified, Hosting will respond to requests against this CustomDomain
               with an HTTP 301 code, and route traffic to the specified `redirect_target`
               instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HostingCustomDomainRequiredDnsUpdateArgs', 'HostingCustomDomainRequiredDnsUpdateArgsDict']]]] required_dns_updates: A set of updates you should make to the domain name's DNS records to
               let Hosting serve secure content on its behalf.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] site_id: The ID of the site in which to create this custom domain association.
        :param pulumi.Input[_builtins.str] update_time: The last time the `CustomDomain` was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostingCustomDomainState.__new__(_HostingCustomDomainState)

        __props__.__dict__["cert_preference"] = cert_preference
        __props__.__dict__["certs"] = certs
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["custom_domain"] = custom_domain
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["etag"] = etag
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["host_state"] = host_state
        __props__.__dict__["issues"] = issues
        __props__.__dict__["name"] = name
        __props__.__dict__["ownership_state"] = ownership_state
        __props__.__dict__["project"] = project
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["redirect_target"] = redirect_target
        __props__.__dict__["required_dns_updates"] = required_dns_updates
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["wait_dns_verification"] = wait_dns_verification
        return HostingCustomDomain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certPreference")
    def cert_preference(self) -> pulumi.Output[_builtins.str]:
        """
        A field that lets you specify which SSL certificate type Hosting creates
        for your domain name. Spark plan `CustomDomain`s only have access to the
        `GROUPED` cert type, while Blaze plan can select any option.
        Possible values are: `GROUPED`, `PROJECT_GROUPED`, `DEDICATED`.
        """
        return pulumi.get(self, "cert_preference")

    @_builtins.property
    @pulumi.getter
    def certs(self) -> pulumi.Output[Sequence['outputs.HostingCustomDomainCert']]:
        """
        The SSL certificate Hosting has for this `CustomDomain`'s domain name.
        For new `CustomDomain`s, this often represents Hosting's intent to create
        a certificate, rather than an actual cert. Check the `state` field for
        more.
        Structure is documented below.
        """
        return pulumi.get(self, "certs")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The `CustomDomain`'s create time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the `CustomDomain`, which is the domain name you'd like to use with Firebase Hosting.
        """
        return pulumi.get(self, "custom_domain")

    @_builtins.property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time the `CustomDomain` was deleted; null for `CustomDomains` that
        haven't been deleted. Deleted `CustomDomains` persist for approximately 30
        days, after which time Hosting removes them completely.
        """
        return pulumi.get(self, "delete_time")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        A string that represents the current state of the `CustomDomain` and
        allows you to confirm its initial state in requests that would modify it.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[_builtins.str]:
        """
        The minimum time before a soft-deleted `CustomDomain` is completely removed
        from Hosting; null for `CustomDomains` that haven't been deleted.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter(name="hostState")
    def host_state(self) -> pulumi.Output[_builtins.str]:
        """
        The host state of your domain name. Host state is determined by checking each
        IP address associated with your domain name to see if it's serving
        Hosting content.
        HOST_UNHOSTED:
        Your `CustomDomain`'s domain name isn't associated with any IP addresses.
        HOST_UNREACHABLE:
        Your `CustomDomain`'s domain name can't be reached. Hosting services' DNS
        queries to find your domain name's IP addresses resulted in errors. See
        your `CustomDomain`'s `issues` field for more details.
        HOST_MISMATCH:
        Your `CustomDomain`'s domain name has IP addresses that don't ultimately
        resolve to Hosting.
        HOST_CONFLICT:
        Your `CustomDomain`'s domain name has IP addresses that resolve to both
        Hosting and other services. To ensure consistent results, remove `A` and
        `AAAA` records related to non-Hosting services.
        HOST_ACTIVE:
        All requests against your `CustomDomain`'s domain name are served by
        Hosting. If the `CustomDomain`'s `OwnershipState` is also `ACTIVE`, Hosting
        serves your Hosting Site's content on the domain name.
        """
        return pulumi.get(self, "host_state")

    @_builtins.property
    @pulumi.getter
    def issues(self) -> pulumi.Output[Sequence['outputs.HostingCustomDomainIssue']]:
        """
        A set of errors Hosting systems encountered when trying to establish
        Hosting's ability to serve secure content for your domain name. Resolve
        these issues to ensure your `CustomDomain` behaves properly.
        Structure is documented below.
        """
        return pulumi.get(self, "issues")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully-qualified name of the `CustomDomain`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownershipState")
    def ownership_state(self) -> pulumi.Output[_builtins.str]:
        """
        The ownership state of your domain name. Ownership is determined at a
        Firebase project level, and established by adding `TXT` records to your
        domain name's DNS records.
        Ownership cascades to subdomains. Granting a project ownership of `foo.com`
        also grants that project ownership over `bar.foo.com`, unless you add
        specific `TXT` records to `bar.foo.com` that grant a different project
        ownership.
        If your `CustomDomain` is in an `OwnershipState` other than
        `OWNERSHIP_ACTIVE` for more than 30 days and it hasn't been updated in at
        least 30 days, Hosting's ownership systems delete the `CustomDomain`.
        OWNERSHIP_MISSING:
        Your `CustomDomain`'s domain name has no Hosting-related ownership records;
        no Firebase project has permission to act on the domain name's behalf.
        OWNERSHIP_UNREACHABLE:
        Your `CustomDomain`'s domain name can't be reached. Hosting services' DNS
        queries to find your domain name's ownership records resulted in errors.
        See your `CustomDomain`'s `issues` field for more details.
        OWNERSHIP_MISMATCH:
        Your `CustomDomain`'s domain name is owned by another Firebase project.
        Remove the conflicting `TXT` records and replace them with project-specific
        records for your current Firebase project.
        OWNERSHIP_CONFLICT:
        Your `CustomDomain`'s domain name has conflicting `TXT` records that
        indicate ownership by both your current Firebase project and another
        project. Remove the other project's ownership records to grant the current
        project ownership.
        OWNERSHIP_PENDING:
        Your `CustomDomain`'s DNS records are configured correctly. Hosting will
        transfer ownership of your domain to this `CustomDomain` within 24 hours.
        OWNERSHIP_ACTIVE:
        Your `CustomDomain`'s domain name has `TXT` records that grant its project
        permission to act on its behalf.
        """
        return pulumi.get(self, "ownership_state")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[_builtins.bool]:
        """
        if true, indicates that Hosting's systems are attempting to
        make the `CustomDomain`'s state match your preferred state. This is most
        frequently `true` when initially provisioning a `CustomDomain` or when creating
        a new SSL certificate to match an updated `cert_preference`
        """
        return pulumi.get(self, "reconciling")

    @_builtins.property
    @pulumi.getter(name="redirectTarget")
    def redirect_target(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A domain name that this CustomDomain should direct traffic towards. If
        specified, Hosting will respond to requests against this CustomDomain
        with an HTTP 301 code, and route traffic to the specified `redirect_target`
        instead.
        """
        return pulumi.get(self, "redirect_target")

    @_builtins.property
    @pulumi.getter(name="requiredDnsUpdates")
    def required_dns_updates(self) -> pulumi.Output[Sequence['outputs.HostingCustomDomainRequiredDnsUpdate']]:
        """
        A set of updates you should make to the domain name's DNS records to
        let Hosting serve secure content on its behalf.
        Structure is documented below.
        """
        return pulumi.get(self, "required_dns_updates")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the site in which to create this custom domain association.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The last time the `CustomDomain` was updated.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="waitDnsVerification")
    def wait_dns_verification(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "wait_dns_verification")

