# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetHl7V2StoreIamPolicyResult',
    'AwaitableGetHl7V2StoreIamPolicyResult',
    'get_hl7_v2_store_iam_policy',
    'get_hl7_v2_store_iam_policy_output',
]

@pulumi.output_type
class GetHl7V2StoreIamPolicyResult:
    """
    A collection of values returned by getHl7V2StoreIamPolicy.
    """
    def __init__(__self__, etag=None, hl7_v2_store_id=None, id=None, policy_data=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if hl7_v2_store_id and not isinstance(hl7_v2_store_id, str):
            raise TypeError("Expected argument 'hl7_v2_store_id' to be a str")
        pulumi.set(__self__, "hl7_v2_store_id", hl7_v2_store_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="hl7V2StoreId")
    def hl7_v2_store_id(self) -> _builtins.str:
        return pulumi.get(self, "hl7_v2_store_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> _builtins.str:
        """
        (Computed) The policy data
        """
        return pulumi.get(self, "policy_data")


class AwaitableGetHl7V2StoreIamPolicyResult(GetHl7V2StoreIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHl7V2StoreIamPolicyResult(
            etag=self.etag,
            hl7_v2_store_id=self.hl7_v2_store_id,
            id=self.id,
            policy_data=self.policy_data)


def get_hl7_v2_store_iam_policy(hl7_v2_store_id: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHl7V2StoreIamPolicyResult:
    """
    Retrieves the current IAM policy data for a Google Cloud Healthcare HL7v2 store.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.healthcare.get_hl7_v2_store_iam_policy(hl7_v2_store_id=hl7_v2_store["id"])
    ```


    :param _builtins.str hl7_v2_store_id: The HL7v2 store ID, in the form
           `{project_id}/{location_name}/{dataset_name}/{hl7_v2_store_name}` or
           `{location_name}/{dataset_name}/{hl7_v2_store_name}`. In the second form, the provider's
           project setting will be used as a fallback.
    """
    __args__ = dict()
    __args__['hl7V2StoreId'] = hl7_v2_store_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:healthcare/getHl7V2StoreIamPolicy:getHl7V2StoreIamPolicy', __args__, opts=opts, typ=GetHl7V2StoreIamPolicyResult).value

    return AwaitableGetHl7V2StoreIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        hl7_v2_store_id=pulumi.get(__ret__, 'hl7_v2_store_id'),
        id=pulumi.get(__ret__, 'id'),
        policy_data=pulumi.get(__ret__, 'policy_data'))
def get_hl7_v2_store_iam_policy_output(hl7_v2_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHl7V2StoreIamPolicyResult]:
    """
    Retrieves the current IAM policy data for a Google Cloud Healthcare HL7v2 store.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.healthcare.get_hl7_v2_store_iam_policy(hl7_v2_store_id=hl7_v2_store["id"])
    ```


    :param _builtins.str hl7_v2_store_id: The HL7v2 store ID, in the form
           `{project_id}/{location_name}/{dataset_name}/{hl7_v2_store_name}` or
           `{location_name}/{dataset_name}/{hl7_v2_store_name}`. In the second form, the provider's
           project setting will be used as a fallback.
    """
    __args__ = dict()
    __args__['hl7V2StoreId'] = hl7_v2_store_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:healthcare/getHl7V2StoreIamPolicy:getHl7V2StoreIamPolicy', __args__, opts=opts, typ=GetHl7V2StoreIamPolicyResult)
    return __ret__.apply(lambda __response__: GetHl7V2StoreIamPolicyResult(
        etag=pulumi.get(__response__, 'etag'),
        hl7_v2_store_id=pulumi.get(__response__, 'hl7_v2_store_id'),
        id=pulumi.get(__response__, 'id'),
        policy_data=pulumi.get(__response__, 'policy_data')))
