# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkforcePoolProviderArgs', 'WorkforcePoolProvider']

@pulumi.input_type
class WorkforcePoolProviderArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 provider_id: pulumi.Input[_builtins.str],
                 workforce_pool_id: pulumi.Input[_builtins.str],
                 attribute_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 attribute_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_attributes_oauth2_client: Optional[pulumi.Input['WorkforcePoolProviderExtraAttributesOauth2ClientArgs']] = None,
                 oidc: Optional[pulumi.Input['WorkforcePoolProviderOidcArgs']] = None,
                 saml: Optional[pulumi.Input['WorkforcePoolProviderSamlArgs']] = None):
        """
        The set of arguments for constructing a WorkforcePoolProvider resource.
        :param pulumi.Input[_builtins.str] location: The location for the resource.
        :param pulumi.Input[_builtins.str] provider_id: The ID for the provider, which becomes the final component of the resource name.
               This value must be 4-32 characters, and may contain the characters [a-z0-9-].
               The prefix `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input[_builtins.str] workforce_pool_id: The ID to use for the pool, which becomes the final component of the resource name.
               The IDs must be a globally unique string of 6 to 63 lowercase letters, digits, or hyphens.
               It must start with a letter, and cannot have a trailing hyphen.
               The prefix `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input[_builtins.str] attribute_condition: A [Common Expression Language](https://opensource.google/projects/cel) expression, in
               plain text, to restrict what otherwise valid authentication credentials issued by the
               provider should not be accepted.
               The expression must output a boolean representing whether to allow the federation.
               The following keywords may be referenced in the expressions:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] attribute_mapping: Maps attributes from the authentication credentials issued by an external identity provider
               to Google Cloud attributes, such as `subject` and `segment`.
               Each key must be a string specifying the Google Cloud IAM attribute to map to.
               The following keys are supported:
               * `google.subject`: The principal IAM is authenticating. You can reference this value in IAM bindings.
               This is also the subject that appears in Cloud Logging logs. This is a required field and
               the mapped subject cannot exceed 127 bytes.
               * `google.groups`: Groups the authenticating user belongs to. You can grant groups access to
               resources using an IAM `principalSet` binding; access applies to all members of the group.
               * `google.display_name`: The name of the authenticated user. This is an optional field and
               the mapped display name cannot exceed 100 bytes. If not set, `google.subject` will be displayed instead.
               This attribute cannot be referenced in IAM bindings.
               * `google.profile_photo`: The URL that specifies the authenticated user's thumbnail photo.
               This is an optional field. When set, the image will be visible as the user's profile picture.
               If not set, a generic user icon will be displayed instead.
               This attribute cannot be referenced in IAM bindings.
               You can also provide custom attributes by specifying `attribute.{custom_attribute}`, where {custom_attribute}
               is the name of the custom attribute to be mapped. You can define a maximum of 50 custom attributes.
               The maximum length of a mapped attribute key is 100 characters, and the key may only contain the characters [a-z0-9_].
               You can reference these attributes in IAM policies to define fine-grained access for a workforce pool
               to Google Cloud resources. For example:
               * `google.subject`:
               `principal://iam.googleapis.com/locations/{location}/workforcePools/{pool}/subject/{value}`
               * `google.groups`:
               `principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/group/{value}`
               * `attribute.{custom_attribute}`:
               `principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/attribute.{custom_attribute}/{value}`
               Each value must be a [Common Expression Language](https://opensource.google/projects/cel)
               function that maps an identity provider credential to the normalized attribute specified
               by the corresponding map key.
               You can use the `assertion` keyword in the expression to access a JSON representation of
               the authentication credential issued by the provider.
               The maximum length of an attribute mapping expression is 2048 characters. When evaluated,
               the total size of all mapped attributes must not exceed 8KB.
               For OIDC providers, you must supply a custom mapping that includes the `google.subject` attribute.
               For example, the following maps the sub claim of the incoming credential to the `subject` attribute
               on a Google token:
               ```
               {"google.subject": "assertion.sub"}
               ```
               An object containing a list of `"key": value` pairs.
               Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
        :param pulumi.Input[_builtins.str] description: A user-specified description of the provider. Cannot exceed 256 characters.
        :param pulumi.Input[_builtins.bool] disabled: Whether the provider is disabled. You cannot use a disabled provider to exchange tokens.
               However, existing tokens still grant access.
        :param pulumi.Input[_builtins.str] display_name: A user-specified display name for the provider. Cannot exceed 32 characters.
        :param pulumi.Input['WorkforcePoolProviderExtraAttributesOauth2ClientArgs'] extra_attributes_oauth2_client: The configuration for OAuth 2.0 client used to get the additional user
               attributes. This should be used when users can't get the desired claims
               in authentication credentials. Currently this configuration is only
               supported with SAML and OIDC protocol.
               Structure is documented below.
        :param pulumi.Input['WorkforcePoolProviderOidcArgs'] oidc: Represents an OpenId Connect 1.0 identity provider.
               Structure is documented below.
        :param pulumi.Input['WorkforcePoolProviderSamlArgs'] saml: Represents a SAML identity provider.
               Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "provider_id", provider_id)
        pulumi.set(__self__, "workforce_pool_id", workforce_pool_id)
        if attribute_condition is not None:
            pulumi.set(__self__, "attribute_condition", attribute_condition)
        if attribute_mapping is not None:
            pulumi.set(__self__, "attribute_mapping", attribute_mapping)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if extra_attributes_oauth2_client is not None:
            pulumi.set(__self__, "extra_attributes_oauth2_client", extra_attributes_oauth2_client)
        if oidc is not None:
            pulumi.set(__self__, "oidc", oidc)
        if saml is not None:
            pulumi.set(__self__, "saml", saml)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location for the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID for the provider, which becomes the final component of the resource name.
        This value must be 4-32 characters, and may contain the characters [a-z0-9-].
        The prefix `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "provider_id")

    @provider_id.setter
    def provider_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provider_id", value)

    @_builtins.property
    @pulumi.getter(name="workforcePoolId")
    def workforce_pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID to use for the pool, which becomes the final component of the resource name.
        The IDs must be a globally unique string of 6 to 63 lowercase letters, digits, or hyphens.
        It must start with a letter, and cannot have a trailing hyphen.
        The prefix `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "workforce_pool_id")

    @workforce_pool_id.setter
    def workforce_pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workforce_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="attributeCondition")
    def attribute_condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A [Common Expression Language](https://opensource.google/projects/cel) expression, in
        plain text, to restrict what otherwise valid authentication credentials issued by the
        provider should not be accepted.
        The expression must output a boolean representing whether to allow the federation.
        The following keywords may be referenced in the expressions:
        """
        return pulumi.get(self, "attribute_condition")

    @attribute_condition.setter
    def attribute_condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attribute_condition", value)

    @_builtins.property
    @pulumi.getter(name="attributeMapping")
    def attribute_mapping(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Maps attributes from the authentication credentials issued by an external identity provider
        to Google Cloud attributes, such as `subject` and `segment`.
        Each key must be a string specifying the Google Cloud IAM attribute to map to.
        The following keys are supported:
        * `google.subject`: The principal IAM is authenticating. You can reference this value in IAM bindings.
        This is also the subject that appears in Cloud Logging logs. This is a required field and
        the mapped subject cannot exceed 127 bytes.
        * `google.groups`: Groups the authenticating user belongs to. You can grant groups access to
        resources using an IAM `principalSet` binding; access applies to all members of the group.
        * `google.display_name`: The name of the authenticated user. This is an optional field and
        the mapped display name cannot exceed 100 bytes. If not set, `google.subject` will be displayed instead.
        This attribute cannot be referenced in IAM bindings.
        * `google.profile_photo`: The URL that specifies the authenticated user's thumbnail photo.
        This is an optional field. When set, the image will be visible as the user's profile picture.
        If not set, a generic user icon will be displayed instead.
        This attribute cannot be referenced in IAM bindings.
        You can also provide custom attributes by specifying `attribute.{custom_attribute}`, where {custom_attribute}
        is the name of the custom attribute to be mapped. You can define a maximum of 50 custom attributes.
        The maximum length of a mapped attribute key is 100 characters, and the key may only contain the characters [a-z0-9_].
        You can reference these attributes in IAM policies to define fine-grained access for a workforce pool
        to Google Cloud resources. For example:
        * `google.subject`:
        `principal://iam.googleapis.com/locations/{location}/workforcePools/{pool}/subject/{value}`
        * `google.groups`:
        `principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/group/{value}`
        * `attribute.{custom_attribute}`:
        `principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/attribute.{custom_attribute}/{value}`
        Each value must be a [Common Expression Language](https://opensource.google/projects/cel)
        function that maps an identity provider credential to the normalized attribute specified
        by the corresponding map key.
        You can use the `assertion` keyword in the expression to access a JSON representation of
        the authentication credential issued by the provider.
        The maximum length of an attribute mapping expression is 2048 characters. When evaluated,
        the total size of all mapped attributes must not exceed 8KB.
        For OIDC providers, you must supply a custom mapping that includes the `google.subject` attribute.
        For example, the following maps the sub claim of the incoming credential to the `subject` attribute
        on a Google token:
        ```
        {"google.subject": "assertion.sub"}
        ```
        An object containing a list of `"key": value` pairs.
        Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
        """
        return pulumi.get(self, "attribute_mapping")

    @attribute_mapping.setter
    def attribute_mapping(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "attribute_mapping", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-specified description of the provider. Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the provider is disabled. You cannot use a disabled provider to exchange tokens.
        However, existing tokens still grant access.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-specified display name for the provider. Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="extraAttributesOauth2Client")
    def extra_attributes_oauth2_client(self) -> Optional[pulumi.Input['WorkforcePoolProviderExtraAttributesOauth2ClientArgs']]:
        """
        The configuration for OAuth 2.0 client used to get the additional user
        attributes. This should be used when users can't get the desired claims
        in authentication credentials. Currently this configuration is only
        supported with SAML and OIDC protocol.
        Structure is documented below.
        """
        return pulumi.get(self, "extra_attributes_oauth2_client")

    @extra_attributes_oauth2_client.setter
    def extra_attributes_oauth2_client(self, value: Optional[pulumi.Input['WorkforcePoolProviderExtraAttributesOauth2ClientArgs']]):
        pulumi.set(self, "extra_attributes_oauth2_client", value)

    @_builtins.property
    @pulumi.getter
    def oidc(self) -> Optional[pulumi.Input['WorkforcePoolProviderOidcArgs']]:
        """
        Represents an OpenId Connect 1.0 identity provider.
        Structure is documented below.
        """
        return pulumi.get(self, "oidc")

    @oidc.setter
    def oidc(self, value: Optional[pulumi.Input['WorkforcePoolProviderOidcArgs']]):
        pulumi.set(self, "oidc", value)

    @_builtins.property
    @pulumi.getter
    def saml(self) -> Optional[pulumi.Input['WorkforcePoolProviderSamlArgs']]:
        """
        Represents a SAML identity provider.
        Structure is documented below.
        """
        return pulumi.get(self, "saml")

    @saml.setter
    def saml(self, value: Optional[pulumi.Input['WorkforcePoolProviderSamlArgs']]):
        pulumi.set(self, "saml", value)


@pulumi.input_type
class _WorkforcePoolProviderState:
    def __init__(__self__, *,
                 attribute_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 attribute_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_attributes_oauth2_client: Optional[pulumi.Input['WorkforcePoolProviderExtraAttributesOauth2ClientArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc: Optional[pulumi.Input['WorkforcePoolProviderOidcArgs']] = None,
                 provider_id: Optional[pulumi.Input[_builtins.str]] = None,
                 saml: Optional[pulumi.Input['WorkforcePoolProviderSamlArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 workforce_pool_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkforcePoolProvider resources.
        :param pulumi.Input[_builtins.str] attribute_condition: A [Common Expression Language](https://opensource.google/projects/cel) expression, in
               plain text, to restrict what otherwise valid authentication credentials issued by the
               provider should not be accepted.
               The expression must output a boolean representing whether to allow the federation.
               The following keywords may be referenced in the expressions:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] attribute_mapping: Maps attributes from the authentication credentials issued by an external identity provider
               to Google Cloud attributes, such as `subject` and `segment`.
               Each key must be a string specifying the Google Cloud IAM attribute to map to.
               The following keys are supported:
               * `google.subject`: The principal IAM is authenticating. You can reference this value in IAM bindings.
               This is also the subject that appears in Cloud Logging logs. This is a required field and
               the mapped subject cannot exceed 127 bytes.
               * `google.groups`: Groups the authenticating user belongs to. You can grant groups access to
               resources using an IAM `principalSet` binding; access applies to all members of the group.
               * `google.display_name`: The name of the authenticated user. This is an optional field and
               the mapped display name cannot exceed 100 bytes. If not set, `google.subject` will be displayed instead.
               This attribute cannot be referenced in IAM bindings.
               * `google.profile_photo`: The URL that specifies the authenticated user's thumbnail photo.
               This is an optional field. When set, the image will be visible as the user's profile picture.
               If not set, a generic user icon will be displayed instead.
               This attribute cannot be referenced in IAM bindings.
               You can also provide custom attributes by specifying `attribute.{custom_attribute}`, where {custom_attribute}
               is the name of the custom attribute to be mapped. You can define a maximum of 50 custom attributes.
               The maximum length of a mapped attribute key is 100 characters, and the key may only contain the characters [a-z0-9_].
               You can reference these attributes in IAM policies to define fine-grained access for a workforce pool
               to Google Cloud resources. For example:
               * `google.subject`:
               `principal://iam.googleapis.com/locations/{location}/workforcePools/{pool}/subject/{value}`
               * `google.groups`:
               `principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/group/{value}`
               * `attribute.{custom_attribute}`:
               `principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/attribute.{custom_attribute}/{value}`
               Each value must be a [Common Expression Language](https://opensource.google/projects/cel)
               function that maps an identity provider credential to the normalized attribute specified
               by the corresponding map key.
               You can use the `assertion` keyword in the expression to access a JSON representation of
               the authentication credential issued by the provider.
               The maximum length of an attribute mapping expression is 2048 characters. When evaluated,
               the total size of all mapped attributes must not exceed 8KB.
               For OIDC providers, you must supply a custom mapping that includes the `google.subject` attribute.
               For example, the following maps the sub claim of the incoming credential to the `subject` attribute
               on a Google token:
               ```
               {"google.subject": "assertion.sub"}
               ```
               An object containing a list of `"key": value` pairs.
               Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
        :param pulumi.Input[_builtins.str] description: A user-specified description of the provider. Cannot exceed 256 characters.
        :param pulumi.Input[_builtins.bool] disabled: Whether the provider is disabled. You cannot use a disabled provider to exchange tokens.
               However, existing tokens still grant access.
        :param pulumi.Input[_builtins.str] display_name: A user-specified display name for the provider. Cannot exceed 32 characters.
        :param pulumi.Input['WorkforcePoolProviderExtraAttributesOauth2ClientArgs'] extra_attributes_oauth2_client: The configuration for OAuth 2.0 client used to get the additional user
               attributes. This should be used when users can't get the desired claims
               in authentication credentials. Currently this configuration is only
               supported with SAML and OIDC protocol.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The location for the resource.
        :param pulumi.Input[_builtins.str] name: Output only. The resource name of the provider.
               Format: `locations/{location}/workforcePools/{workforcePoolId}/providers/{providerId}`
        :param pulumi.Input['WorkforcePoolProviderOidcArgs'] oidc: Represents an OpenId Connect 1.0 identity provider.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] provider_id: The ID for the provider, which becomes the final component of the resource name.
               This value must be 4-32 characters, and may contain the characters [a-z0-9-].
               The prefix `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input['WorkforcePoolProviderSamlArgs'] saml: Represents a SAML identity provider.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: The current state of the provider.
               * STATE_UNSPECIFIED: State unspecified.
               * ACTIVE: The provider is active and may be used to validate authentication credentials.
               * DELETED: The provider is soft-deleted. Soft-deleted providers are permanently
               deleted after approximately 30 days. You can restore a soft-deleted provider using
               [providers.undelete](https://cloud.google.com/iam/docs/reference/rest/v1/locations.workforcePools.providers/undelete#google.iam.admin.v1.WorkforcePools.UndeleteWorkforcePoolProvider).
        :param pulumi.Input[_builtins.str] workforce_pool_id: The ID to use for the pool, which becomes the final component of the resource name.
               The IDs must be a globally unique string of 6 to 63 lowercase letters, digits, or hyphens.
               It must start with a letter, and cannot have a trailing hyphen.
               The prefix `gcp-` is reserved for use by Google, and may not be specified.
        """
        if attribute_condition is not None:
            pulumi.set(__self__, "attribute_condition", attribute_condition)
        if attribute_mapping is not None:
            pulumi.set(__self__, "attribute_mapping", attribute_mapping)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if extra_attributes_oauth2_client is not None:
            pulumi.set(__self__, "extra_attributes_oauth2_client", extra_attributes_oauth2_client)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oidc is not None:
            pulumi.set(__self__, "oidc", oidc)
        if provider_id is not None:
            pulumi.set(__self__, "provider_id", provider_id)
        if saml is not None:
            pulumi.set(__self__, "saml", saml)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if workforce_pool_id is not None:
            pulumi.set(__self__, "workforce_pool_id", workforce_pool_id)

    @_builtins.property
    @pulumi.getter(name="attributeCondition")
    def attribute_condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A [Common Expression Language](https://opensource.google/projects/cel) expression, in
        plain text, to restrict what otherwise valid authentication credentials issued by the
        provider should not be accepted.
        The expression must output a boolean representing whether to allow the federation.
        The following keywords may be referenced in the expressions:
        """
        return pulumi.get(self, "attribute_condition")

    @attribute_condition.setter
    def attribute_condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "attribute_condition", value)

    @_builtins.property
    @pulumi.getter(name="attributeMapping")
    def attribute_mapping(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Maps attributes from the authentication credentials issued by an external identity provider
        to Google Cloud attributes, such as `subject` and `segment`.
        Each key must be a string specifying the Google Cloud IAM attribute to map to.
        The following keys are supported:
        * `google.subject`: The principal IAM is authenticating. You can reference this value in IAM bindings.
        This is also the subject that appears in Cloud Logging logs. This is a required field and
        the mapped subject cannot exceed 127 bytes.
        * `google.groups`: Groups the authenticating user belongs to. You can grant groups access to
        resources using an IAM `principalSet` binding; access applies to all members of the group.
        * `google.display_name`: The name of the authenticated user. This is an optional field and
        the mapped display name cannot exceed 100 bytes. If not set, `google.subject` will be displayed instead.
        This attribute cannot be referenced in IAM bindings.
        * `google.profile_photo`: The URL that specifies the authenticated user's thumbnail photo.
        This is an optional field. When set, the image will be visible as the user's profile picture.
        If not set, a generic user icon will be displayed instead.
        This attribute cannot be referenced in IAM bindings.
        You can also provide custom attributes by specifying `attribute.{custom_attribute}`, where {custom_attribute}
        is the name of the custom attribute to be mapped. You can define a maximum of 50 custom attributes.
        The maximum length of a mapped attribute key is 100 characters, and the key may only contain the characters [a-z0-9_].
        You can reference these attributes in IAM policies to define fine-grained access for a workforce pool
        to Google Cloud resources. For example:
        * `google.subject`:
        `principal://iam.googleapis.com/locations/{location}/workforcePools/{pool}/subject/{value}`
        * `google.groups`:
        `principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/group/{value}`
        * `attribute.{custom_attribute}`:
        `principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/attribute.{custom_attribute}/{value}`
        Each value must be a [Common Expression Language](https://opensource.google/projects/cel)
        function that maps an identity provider credential to the normalized attribute specified
        by the corresponding map key.
        You can use the `assertion` keyword in the expression to access a JSON representation of
        the authentication credential issued by the provider.
        The maximum length of an attribute mapping expression is 2048 characters. When evaluated,
        the total size of all mapped attributes must not exceed 8KB.
        For OIDC providers, you must supply a custom mapping that includes the `google.subject` attribute.
        For example, the following maps the sub claim of the incoming credential to the `subject` attribute
        on a Google token:
        ```
        {"google.subject": "assertion.sub"}
        ```
        An object containing a list of `"key": value` pairs.
        Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
        """
        return pulumi.get(self, "attribute_mapping")

    @attribute_mapping.setter
    def attribute_mapping(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "attribute_mapping", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-specified description of the provider. Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the provider is disabled. You cannot use a disabled provider to exchange tokens.
        However, existing tokens still grant access.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-specified display name for the provider. Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="extraAttributesOauth2Client")
    def extra_attributes_oauth2_client(self) -> Optional[pulumi.Input['WorkforcePoolProviderExtraAttributesOauth2ClientArgs']]:
        """
        The configuration for OAuth 2.0 client used to get the additional user
        attributes. This should be used when users can't get the desired claims
        in authentication credentials. Currently this configuration is only
        supported with SAML and OIDC protocol.
        Structure is documented below.
        """
        return pulumi.get(self, "extra_attributes_oauth2_client")

    @extra_attributes_oauth2_client.setter
    def extra_attributes_oauth2_client(self, value: Optional[pulumi.Input['WorkforcePoolProviderExtraAttributesOauth2ClientArgs']]):
        pulumi.set(self, "extra_attributes_oauth2_client", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location for the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The resource name of the provider.
        Format: `locations/{location}/workforcePools/{workforcePoolId}/providers/{providerId}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def oidc(self) -> Optional[pulumi.Input['WorkforcePoolProviderOidcArgs']]:
        """
        Represents an OpenId Connect 1.0 identity provider.
        Structure is documented below.
        """
        return pulumi.get(self, "oidc")

    @oidc.setter
    def oidc(self, value: Optional[pulumi.Input['WorkforcePoolProviderOidcArgs']]):
        pulumi.set(self, "oidc", value)

    @_builtins.property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID for the provider, which becomes the final component of the resource name.
        This value must be 4-32 characters, and may contain the characters [a-z0-9-].
        The prefix `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "provider_id")

    @provider_id.setter
    def provider_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_id", value)

    @_builtins.property
    @pulumi.getter
    def saml(self) -> Optional[pulumi.Input['WorkforcePoolProviderSamlArgs']]:
        """
        Represents a SAML identity provider.
        Structure is documented below.
        """
        return pulumi.get(self, "saml")

    @saml.setter
    def saml(self, value: Optional[pulumi.Input['WorkforcePoolProviderSamlArgs']]):
        pulumi.set(self, "saml", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the provider.
        * STATE_UNSPECIFIED: State unspecified.
        * ACTIVE: The provider is active and may be used to validate authentication credentials.
        * DELETED: The provider is soft-deleted. Soft-deleted providers are permanently
        deleted after approximately 30 days. You can restore a soft-deleted provider using
        [providers.undelete](https://cloud.google.com/iam/docs/reference/rest/v1/locations.workforcePools.providers/undelete#google.iam.admin.v1.WorkforcePools.UndeleteWorkforcePoolProvider).
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="workforcePoolId")
    def workforce_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID to use for the pool, which becomes the final component of the resource name.
        The IDs must be a globally unique string of 6 to 63 lowercase letters, digits, or hyphens.
        It must start with a letter, and cannot have a trailing hyphen.
        The prefix `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "workforce_pool_id")

    @workforce_pool_id.setter
    def workforce_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workforce_pool_id", value)


@pulumi.type_token("gcp:iam/workforcePoolProvider:WorkforcePoolProvider")
class WorkforcePoolProvider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 attribute_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_attributes_oauth2_client: Optional[pulumi.Input[Union['WorkforcePoolProviderExtraAttributesOauth2ClientArgs', 'WorkforcePoolProviderExtraAttributesOauth2ClientArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc: Optional[pulumi.Input[Union['WorkforcePoolProviderOidcArgs', 'WorkforcePoolProviderOidcArgsDict']]] = None,
                 provider_id: Optional[pulumi.Input[_builtins.str]] = None,
                 saml: Optional[pulumi.Input[Union['WorkforcePoolProviderSamlArgs', 'WorkforcePoolProviderSamlArgsDict']]] = None,
                 workforce_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A configuration for an external identity provider.

        To get more information about WorkforcePoolProvider, see:

        * [API documentation](https://cloud.google.com/iam/docs/reference/rest/v1/locations.workforcePools.providers)
        * How-to Guides
            * [Configure a provider within the workforce pool](https://cloud.google.com/iam/docs/manage-workforce-identity-pools-providers#configure_a_provider_within_the_workforce_pool)

        > **Note:** Ask your Google Cloud account team to request access to workforce identity federation for your
        billing/quota project. The account team notifies you when the project is granted access.

        ## Example Usage

        ### Iam Workforce Pool Provider Saml Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkforcePool("pool",
            workforce_pool_id="example-pool",
            parent="organizations/123456789",
            location="global")
        example = gcp.iam.WorkforcePoolProvider("example",
            workforce_pool_id=pool.workforce_pool_id,
            location=pool.location,
            provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            saml={
                "idp_metadata_xml": "<?xml version=\\"1.0\\"?><md:EntityDescriptor xmlns:md=\\"urn:oasis:names:tc:SAML:2.0:metadata\\" entityID=\\"https://test.com\\"><md:IDPSSODescriptor protocolSupportEnumeration=\\"urn:oasis:names:tc:SAML:2.0:protocol\\"> <md:KeyDescriptor use=\\"signing\\"><ds:KeyInfo xmlns:ds=\\"http://www.w3.org/2000/09/xmldsig#\\"><ds:X509Data><ds:X509Certificate>MIIDpDCCAoygAwIBAgIGAX7/5qPhMA0GCSqGSIb3DQEBCwUAMIGSMQswCQYDVQQGEwJVUzETMBEGA1UECAwKQ2FsaWZvcm5pYTEWMBQGA1UEBwwNU2FuIEZyYW5jaXNjbzENMAsGA1UECgwET2t0YTEUMBIGA1UECwwLU1NPUHJvdmlkZXIxEzARBgNVBAMMCmRldi00NTg0MjExHDAaBgkqhkiG9w0BCQEWDWluZm9Ab2t0YS5jb20wHhcNMjIwMjE2MDAxOTEyWhcNMzIwMjE2MDAyMDEyWjCBkjELMAkGA1UEBhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExFjAUBgNVBAcMDVNhbiBGcmFuY2lzY28xDTALBgNVBAoMBE9rdGExFDASBgNVBAsMC1NTT1Byb3ZpZGVyMRMwEQYDVQQDDApkZXYtNDU4NDIxMRwwGgYJKoZIhvcNAQkBFg1pbmZvQG9rdGEuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxrBl7GKz52cRpxF9xCsirnRuMxnhFBaUrsHqAQrLqWmdlpNYZTVg+T9iQ+aq/iE68L+BRZcZniKIvW58wqqS0ltXVvIkXuDSvnvnkkI5yMIVErR20K8jSOKQm1FmK+fgAJ4koshFiu9oLiqu0Ejc0DuL3/XRsb4RuxjktKTb1khgBBtb+7idEk0sFR0RPefAweXImJkDHDm7SxjDwGJUubbqpdTxasPr0W+AHI1VUzsUsTiHAoyb0XDkYqHfDzhj/ZdIEl4zHQ3bEZvlD984ztAnmX2SuFLLKfXeAAGHei8MMixJvwxYkkPeYZ/5h8WgBZPP4heS2CPjwYExt29L8QIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQARjJFz++a9Z5IQGFzsZMrX2EDR5ML4xxUiQkbhld1S1PljOLcYFARDmUC2YYHOueU4ee8Jid9nPGEUebV/4Jok+b+oQh+dWMgiWjSLI7h5q4OYZ3VJtdlVwgMFt2iz+/4yBKMUZ50g3Qgg36vE34us+eKitg759JgCNsibxn0qtJgSPm0sgP2L6yTaLnoEUbXBRxCwynTSkp9ZijZqEzbhN0e2dWv7Rx/nfpohpDP6vEiFImKFHpDSv3M/5de1ytQzPFrZBYt9WlzlYwE1aD9FHCxdd+rWgYMVVoRaRmndpV/Rq3QUuDuFJtaoX11bC7ExkOpg9KstZzA63i3VcfYv</ds:X509Certificate></ds:X509Data></ds:KeyInfo></md:KeyDescriptor><md:SingleSignOnService Binding=\\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\\" Location=\\"https://test.com/sso\\"/></md:IDPSSODescriptor></md:EntityDescriptor>",
            })
        ```
        ### Iam Workforce Pool Provider Saml Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkforcePool("pool",
            workforce_pool_id="example-pool",
            parent="organizations/123456789",
            location="global")
        example = gcp.iam.WorkforcePoolProvider("example",
            workforce_pool_id=pool.workforce_pool_id,
            location=pool.location,
            provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            saml={
                "idp_metadata_xml": "<?xml version=\\"1.0\\"?><md:EntityDescriptor xmlns:md=\\"urn:oasis:names:tc:SAML:2.0:metadata\\" entityID=\\"https://sts.windows.net/826602fe-2101-470c-9d71-ee1343668989\\"><md:IDPSSODescriptor protocolSupportEnumeration=\\"urn:oasis:names:tc:SAML:2.0:protocol\\"> <md:KeyDescriptor use=\\"signing\\"><ds:KeyInfo xmlns:ds=\\"http://www.w3.org/2000/09/xmldsig#\\"><ds:X509Data><ds:X509Certificate>MIIDpDCCAoygAwIBAgIGAX7/5qPhMA0GCSqGSIb3DQEBCwUAMIGSMQswCQYDVQQGEwJVUzETMBEGA1UECAwKQ2FsaWZvcm5pYTEWMBQGA1UEBwwNU2FuIEZyYW5jaXNjbzENMAsGA1UECgwET2t0YTEUMBIGA1UECwwLU1NPUHJvdmlkZXIxEzARBgNVBAMMCmRldi00NTg0MjExHDAaBgkqhkiG9w0BCQEWDWluZm9Ab2t0YS5jb20wHhcNMjIwMjE2MDAxOTEyWhcNMzIwMjE2MDAyMDEyWjCBkjELMAkGA1UEBhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExFjAUBgNVBAcMDVNhbiBGcmFuY2lzY28xDTALBgNVBAoMBE9rdGExFDASBgNVBAsMC1NTT1Byb3ZpZGVyMRMwEQYDVQQDDApkZXYtNDU4NDIxMRwwGgYJKoZIhvcNAQkBFg1pbmZvQG9rdGEuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxrBl7GKz52cRpxF9xCsirnRuMxnhFBaUrsHqAQrLqWmdlpNYZTVg+T9iQ+aq/iE68L+BRZcZniKIvW58wqqS0ltXVvIkXuDSvnvnkkI5yMIVErR20K8jSOKQm1FmK+fgAJ4koshFiu9oLiqu0Ejc0DuL3/XRsb4RuxjktKTb1khgBBtb+7idEk0sFR0RPefAweXImJkDHDm7SxjDwGJUubbqpdTxasPr0W+AHI1VUzsUsTiHAoyb0XDkYqHfDzhj/ZdIEl4zHQ3bEZvlD984ztAnmX2SuFLLKfXeAAGHei8MMixJvwxYkkPeYZ/5h8WgBZPP4heS2CPjwYExt29L8QIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQARjJFz++a9Z5IQGFzsZMrX2EDR5ML4xxUiQkbhld1S1PljOLcYFARDmUC2YYHOueU4ee8Jid9nPGEUebV/4Jok+b+oQh+dWMgiWjSLI7h5q4OYZ3VJtdlVwgMFt2iz+/4yBKMUZ50g3Qgg36vE34us+eKitg759JgCNsibxn0qtJgSPm0sgP2L6yTaLnoEUbXBRxCwynTSkp9ZijZqEzbhN0e2dWv7Rx/nfpohpDP6vEiFImKFHpDSv3M/5de1ytQzPFrZBYt9WlzlYwE1aD9FHCxdd+rWgYMVVoRaRmndpV/Rq3QUuDuFJtaoX11bC7ExkOpg9KstZzA63i3VcfYv</ds:X509Certificate></ds:X509Data></ds:KeyInfo></md:KeyDescriptor><md:SingleSignOnService Binding=\\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\\" Location=\\"https://test.com/sso\\"/></md:IDPSSODescriptor></md:EntityDescriptor>",
            },
            extra_attributes_oauth2_client={
                "issuer_uri": "https://login.microsoftonline.com/826602fe-2101-470c-9d71-ee1343668989/v2.0",
                "client_id": "client-id",
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
                "attributes_type": "AZURE_AD_GROUPS_ID",
                "query_parameters": {
                    "filter": "mail:gcp",
                },
            },
            display_name="Display name",
            description="A sample SAML workforce pool provider.",
            disabled=False,
            attribute_condition="true")
        ```
        ### Iam Workforce Pool Provider Oidc Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkforcePool("pool",
            workforce_pool_id="example-pool",
            parent="organizations/123456789",
            location="global")
        example = gcp.iam.WorkforcePoolProvider("example",
            workforce_pool_id=pool.workforce_pool_id,
            location=pool.location,
            provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            oidc={
                "issuer_uri": "https://accounts.thirdparty.com",
                "client_id": "client-id",
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
                "web_sso_config": {
                    "response_type": "CODE",
                    "assertion_claims_behavior": "MERGE_USER_INFO_OVER_ID_TOKEN_CLAIMS",
                },
            })
        ```
        ### Iam Workforce Pool Provider Oidc Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkforcePool("pool",
            workforce_pool_id="example-pool",
            parent="organizations/123456789",
            location="global")
        example = gcp.iam.WorkforcePoolProvider("example",
            workforce_pool_id=pool.workforce_pool_id,
            location=pool.location,
            provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            oidc={
                "issuer_uri": "https://login.microsoftonline.com/826602fe-2101-470c-9d71-ee1343668989/v2.0",
                "client_id": "client-id",
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
                "web_sso_config": {
                    "response_type": "CODE",
                    "assertion_claims_behavior": "MERGE_USER_INFO_OVER_ID_TOKEN_CLAIMS",
                    "additional_scopes": [
                        "groups",
                        "roles",
                    ],
                },
            },
            extra_attributes_oauth2_client={
                "issuer_uri": "https://login.microsoftonline.com/826602fe-2101-470c-9d71-ee1343668989/v2.0",
                "client_id": "client-id",
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
                "attributes_type": "AZURE_AD_GROUPS_MAIL",
                "query_parameters": {
                    "filter": "mail:sales",
                },
            },
            display_name="Display name",
            description="A sample OIDC workforce pool provider.",
            disabled=False,
            attribute_condition="true")
        ```
        ### Iam Workforce Pool Provider Extra Attributes Oauth2 Config Client Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkforcePool("pool",
            workforce_pool_id="example-pool",
            parent="organizations/123456789",
            location="global")
        example = gcp.iam.WorkforcePoolProvider("example",
            workforce_pool_id=pool.workforce_pool_id,
            location=pool.location,
            provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            oidc={
                "issuer_uri": "https://sts.windows.net/826602fe-2101-470c-9d71-ee1343668989/",
                "client_id": "https://analysis.windows.net/powerbi/connector/GoogleBigQuery",
                "web_sso_config": {
                    "response_type": "CODE",
                    "assertion_claims_behavior": "MERGE_USER_INFO_OVER_ID_TOKEN_CLAIMS",
                },
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
            },
            extra_attributes_oauth2_client={
                "issuer_uri": "https://login.microsoftonline.com/826602fe-2101-470c-9d71-ee1343668989/v2.0",
                "client_id": "client-id",
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
                "attributes_type": "AZURE_AD_GROUPS_MAIL",
            })
        ```
        ### Iam Workforce Pool Provider Extra Attributes Oauth2 Config Client Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkforcePool("pool",
            workforce_pool_id="example-pool",
            parent="organizations/123456789",
            location="global")
        example = gcp.iam.WorkforcePoolProvider("example",
            workforce_pool_id=pool.workforce_pool_id,
            location=pool.location,
            provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            oidc={
                "issuer_uri": "https://sts.windows.net/826602fe-2101-470c-9d71-ee1343668989/",
                "client_id": "https://analysis.windows.net/powerbi/connector/GoogleBigQuery",
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
                "web_sso_config": {
                    "response_type": "CODE",
                    "assertion_claims_behavior": "MERGE_USER_INFO_OVER_ID_TOKEN_CLAIMS",
                },
            },
            extra_attributes_oauth2_client={
                "issuer_uri": "https://login.microsoftonline.com/826602fe-2101-470c-9d71-ee1343668989/v2.0",
                "client_id": "client-id",
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
                "attributes_type": "AZURE_AD_GROUPS_MAIL",
                "query_parameters": {
                    "filter": "mail:gcp",
                },
            })
        ```

        ## Import

        WorkforcePoolProvider can be imported using any of these accepted formats:

        * `locations/{{location}}/workforcePools/{{workforce_pool_id}}/providers/{{provider_id}}`

        * `{{location}}/{{workforce_pool_id}}/{{provider_id}}`

        When using the `pulumi import` command, WorkforcePoolProvider can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/workforcePoolProvider:WorkforcePoolProvider default locations/{{location}}/workforcePools/{{workforce_pool_id}}/providers/{{provider_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workforcePoolProvider:WorkforcePoolProvider default {{location}}/{{workforce_pool_id}}/{{provider_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] attribute_condition: A [Common Expression Language](https://opensource.google/projects/cel) expression, in
               plain text, to restrict what otherwise valid authentication credentials issued by the
               provider should not be accepted.
               The expression must output a boolean representing whether to allow the federation.
               The following keywords may be referenced in the expressions:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] attribute_mapping: Maps attributes from the authentication credentials issued by an external identity provider
               to Google Cloud attributes, such as `subject` and `segment`.
               Each key must be a string specifying the Google Cloud IAM attribute to map to.
               The following keys are supported:
               * `google.subject`: The principal IAM is authenticating. You can reference this value in IAM bindings.
               This is also the subject that appears in Cloud Logging logs. This is a required field and
               the mapped subject cannot exceed 127 bytes.
               * `google.groups`: Groups the authenticating user belongs to. You can grant groups access to
               resources using an IAM `principalSet` binding; access applies to all members of the group.
               * `google.display_name`: The name of the authenticated user. This is an optional field and
               the mapped display name cannot exceed 100 bytes. If not set, `google.subject` will be displayed instead.
               This attribute cannot be referenced in IAM bindings.
               * `google.profile_photo`: The URL that specifies the authenticated user's thumbnail photo.
               This is an optional field. When set, the image will be visible as the user's profile picture.
               If not set, a generic user icon will be displayed instead.
               This attribute cannot be referenced in IAM bindings.
               You can also provide custom attributes by specifying `attribute.{custom_attribute}`, where {custom_attribute}
               is the name of the custom attribute to be mapped. You can define a maximum of 50 custom attributes.
               The maximum length of a mapped attribute key is 100 characters, and the key may only contain the characters [a-z0-9_].
               You can reference these attributes in IAM policies to define fine-grained access for a workforce pool
               to Google Cloud resources. For example:
               * `google.subject`:
               `principal://iam.googleapis.com/locations/{location}/workforcePools/{pool}/subject/{value}`
               * `google.groups`:
               `principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/group/{value}`
               * `attribute.{custom_attribute}`:
               `principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/attribute.{custom_attribute}/{value}`
               Each value must be a [Common Expression Language](https://opensource.google/projects/cel)
               function that maps an identity provider credential to the normalized attribute specified
               by the corresponding map key.
               You can use the `assertion` keyword in the expression to access a JSON representation of
               the authentication credential issued by the provider.
               The maximum length of an attribute mapping expression is 2048 characters. When evaluated,
               the total size of all mapped attributes must not exceed 8KB.
               For OIDC providers, you must supply a custom mapping that includes the `google.subject` attribute.
               For example, the following maps the sub claim of the incoming credential to the `subject` attribute
               on a Google token:
               ```
               {"google.subject": "assertion.sub"}
               ```
               An object containing a list of `"key": value` pairs.
               Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
        :param pulumi.Input[_builtins.str] description: A user-specified description of the provider. Cannot exceed 256 characters.
        :param pulumi.Input[_builtins.bool] disabled: Whether the provider is disabled. You cannot use a disabled provider to exchange tokens.
               However, existing tokens still grant access.
        :param pulumi.Input[_builtins.str] display_name: A user-specified display name for the provider. Cannot exceed 32 characters.
        :param pulumi.Input[Union['WorkforcePoolProviderExtraAttributesOauth2ClientArgs', 'WorkforcePoolProviderExtraAttributesOauth2ClientArgsDict']] extra_attributes_oauth2_client: The configuration for OAuth 2.0 client used to get the additional user
               attributes. This should be used when users can't get the desired claims
               in authentication credentials. Currently this configuration is only
               supported with SAML and OIDC protocol.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The location for the resource.
        :param pulumi.Input[Union['WorkforcePoolProviderOidcArgs', 'WorkforcePoolProviderOidcArgsDict']] oidc: Represents an OpenId Connect 1.0 identity provider.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] provider_id: The ID for the provider, which becomes the final component of the resource name.
               This value must be 4-32 characters, and may contain the characters [a-z0-9-].
               The prefix `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input[Union['WorkforcePoolProviderSamlArgs', 'WorkforcePoolProviderSamlArgsDict']] saml: Represents a SAML identity provider.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] workforce_pool_id: The ID to use for the pool, which becomes the final component of the resource name.
               The IDs must be a globally unique string of 6 to 63 lowercase letters, digits, or hyphens.
               It must start with a letter, and cannot have a trailing hyphen.
               The prefix `gcp-` is reserved for use by Google, and may not be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkforcePoolProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A configuration for an external identity provider.

        To get more information about WorkforcePoolProvider, see:

        * [API documentation](https://cloud.google.com/iam/docs/reference/rest/v1/locations.workforcePools.providers)
        * How-to Guides
            * [Configure a provider within the workforce pool](https://cloud.google.com/iam/docs/manage-workforce-identity-pools-providers#configure_a_provider_within_the_workforce_pool)

        > **Note:** Ask your Google Cloud account team to request access to workforce identity federation for your
        billing/quota project. The account team notifies you when the project is granted access.

        ## Example Usage

        ### Iam Workforce Pool Provider Saml Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkforcePool("pool",
            workforce_pool_id="example-pool",
            parent="organizations/123456789",
            location="global")
        example = gcp.iam.WorkforcePoolProvider("example",
            workforce_pool_id=pool.workforce_pool_id,
            location=pool.location,
            provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            saml={
                "idp_metadata_xml": "<?xml version=\\"1.0\\"?><md:EntityDescriptor xmlns:md=\\"urn:oasis:names:tc:SAML:2.0:metadata\\" entityID=\\"https://test.com\\"><md:IDPSSODescriptor protocolSupportEnumeration=\\"urn:oasis:names:tc:SAML:2.0:protocol\\"> <md:KeyDescriptor use=\\"signing\\"><ds:KeyInfo xmlns:ds=\\"http://www.w3.org/2000/09/xmldsig#\\"><ds:X509Data><ds:X509Certificate>MIIDpDCCAoygAwIBAgIGAX7/5qPhMA0GCSqGSIb3DQEBCwUAMIGSMQswCQYDVQQGEwJVUzETMBEGA1UECAwKQ2FsaWZvcm5pYTEWMBQGA1UEBwwNU2FuIEZyYW5jaXNjbzENMAsGA1UECgwET2t0YTEUMBIGA1UECwwLU1NPUHJvdmlkZXIxEzARBgNVBAMMCmRldi00NTg0MjExHDAaBgkqhkiG9w0BCQEWDWluZm9Ab2t0YS5jb20wHhcNMjIwMjE2MDAxOTEyWhcNMzIwMjE2MDAyMDEyWjCBkjELMAkGA1UEBhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExFjAUBgNVBAcMDVNhbiBGcmFuY2lzY28xDTALBgNVBAoMBE9rdGExFDASBgNVBAsMC1NTT1Byb3ZpZGVyMRMwEQYDVQQDDApkZXYtNDU4NDIxMRwwGgYJKoZIhvcNAQkBFg1pbmZvQG9rdGEuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxrBl7GKz52cRpxF9xCsirnRuMxnhFBaUrsHqAQrLqWmdlpNYZTVg+T9iQ+aq/iE68L+BRZcZniKIvW58wqqS0ltXVvIkXuDSvnvnkkI5yMIVErR20K8jSOKQm1FmK+fgAJ4koshFiu9oLiqu0Ejc0DuL3/XRsb4RuxjktKTb1khgBBtb+7idEk0sFR0RPefAweXImJkDHDm7SxjDwGJUubbqpdTxasPr0W+AHI1VUzsUsTiHAoyb0XDkYqHfDzhj/ZdIEl4zHQ3bEZvlD984ztAnmX2SuFLLKfXeAAGHei8MMixJvwxYkkPeYZ/5h8WgBZPP4heS2CPjwYExt29L8QIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQARjJFz++a9Z5IQGFzsZMrX2EDR5ML4xxUiQkbhld1S1PljOLcYFARDmUC2YYHOueU4ee8Jid9nPGEUebV/4Jok+b+oQh+dWMgiWjSLI7h5q4OYZ3VJtdlVwgMFt2iz+/4yBKMUZ50g3Qgg36vE34us+eKitg759JgCNsibxn0qtJgSPm0sgP2L6yTaLnoEUbXBRxCwynTSkp9ZijZqEzbhN0e2dWv7Rx/nfpohpDP6vEiFImKFHpDSv3M/5de1ytQzPFrZBYt9WlzlYwE1aD9FHCxdd+rWgYMVVoRaRmndpV/Rq3QUuDuFJtaoX11bC7ExkOpg9KstZzA63i3VcfYv</ds:X509Certificate></ds:X509Data></ds:KeyInfo></md:KeyDescriptor><md:SingleSignOnService Binding=\\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\\" Location=\\"https://test.com/sso\\"/></md:IDPSSODescriptor></md:EntityDescriptor>",
            })
        ```
        ### Iam Workforce Pool Provider Saml Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkforcePool("pool",
            workforce_pool_id="example-pool",
            parent="organizations/123456789",
            location="global")
        example = gcp.iam.WorkforcePoolProvider("example",
            workforce_pool_id=pool.workforce_pool_id,
            location=pool.location,
            provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            saml={
                "idp_metadata_xml": "<?xml version=\\"1.0\\"?><md:EntityDescriptor xmlns:md=\\"urn:oasis:names:tc:SAML:2.0:metadata\\" entityID=\\"https://sts.windows.net/826602fe-2101-470c-9d71-ee1343668989\\"><md:IDPSSODescriptor protocolSupportEnumeration=\\"urn:oasis:names:tc:SAML:2.0:protocol\\"> <md:KeyDescriptor use=\\"signing\\"><ds:KeyInfo xmlns:ds=\\"http://www.w3.org/2000/09/xmldsig#\\"><ds:X509Data><ds:X509Certificate>MIIDpDCCAoygAwIBAgIGAX7/5qPhMA0GCSqGSIb3DQEBCwUAMIGSMQswCQYDVQQGEwJVUzETMBEGA1UECAwKQ2FsaWZvcm5pYTEWMBQGA1UEBwwNU2FuIEZyYW5jaXNjbzENMAsGA1UECgwET2t0YTEUMBIGA1UECwwLU1NPUHJvdmlkZXIxEzARBgNVBAMMCmRldi00NTg0MjExHDAaBgkqhkiG9w0BCQEWDWluZm9Ab2t0YS5jb20wHhcNMjIwMjE2MDAxOTEyWhcNMzIwMjE2MDAyMDEyWjCBkjELMAkGA1UEBhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExFjAUBgNVBAcMDVNhbiBGcmFuY2lzY28xDTALBgNVBAoMBE9rdGExFDASBgNVBAsMC1NTT1Byb3ZpZGVyMRMwEQYDVQQDDApkZXYtNDU4NDIxMRwwGgYJKoZIhvcNAQkBFg1pbmZvQG9rdGEuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxrBl7GKz52cRpxF9xCsirnRuMxnhFBaUrsHqAQrLqWmdlpNYZTVg+T9iQ+aq/iE68L+BRZcZniKIvW58wqqS0ltXVvIkXuDSvnvnkkI5yMIVErR20K8jSOKQm1FmK+fgAJ4koshFiu9oLiqu0Ejc0DuL3/XRsb4RuxjktKTb1khgBBtb+7idEk0sFR0RPefAweXImJkDHDm7SxjDwGJUubbqpdTxasPr0W+AHI1VUzsUsTiHAoyb0XDkYqHfDzhj/ZdIEl4zHQ3bEZvlD984ztAnmX2SuFLLKfXeAAGHei8MMixJvwxYkkPeYZ/5h8WgBZPP4heS2CPjwYExt29L8QIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQARjJFz++a9Z5IQGFzsZMrX2EDR5ML4xxUiQkbhld1S1PljOLcYFARDmUC2YYHOueU4ee8Jid9nPGEUebV/4Jok+b+oQh+dWMgiWjSLI7h5q4OYZ3VJtdlVwgMFt2iz+/4yBKMUZ50g3Qgg36vE34us+eKitg759JgCNsibxn0qtJgSPm0sgP2L6yTaLnoEUbXBRxCwynTSkp9ZijZqEzbhN0e2dWv7Rx/nfpohpDP6vEiFImKFHpDSv3M/5de1ytQzPFrZBYt9WlzlYwE1aD9FHCxdd+rWgYMVVoRaRmndpV/Rq3QUuDuFJtaoX11bC7ExkOpg9KstZzA63i3VcfYv</ds:X509Certificate></ds:X509Data></ds:KeyInfo></md:KeyDescriptor><md:SingleSignOnService Binding=\\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\\" Location=\\"https://test.com/sso\\"/></md:IDPSSODescriptor></md:EntityDescriptor>",
            },
            extra_attributes_oauth2_client={
                "issuer_uri": "https://login.microsoftonline.com/826602fe-2101-470c-9d71-ee1343668989/v2.0",
                "client_id": "client-id",
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
                "attributes_type": "AZURE_AD_GROUPS_ID",
                "query_parameters": {
                    "filter": "mail:gcp",
                },
            },
            display_name="Display name",
            description="A sample SAML workforce pool provider.",
            disabled=False,
            attribute_condition="true")
        ```
        ### Iam Workforce Pool Provider Oidc Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkforcePool("pool",
            workforce_pool_id="example-pool",
            parent="organizations/123456789",
            location="global")
        example = gcp.iam.WorkforcePoolProvider("example",
            workforce_pool_id=pool.workforce_pool_id,
            location=pool.location,
            provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            oidc={
                "issuer_uri": "https://accounts.thirdparty.com",
                "client_id": "client-id",
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
                "web_sso_config": {
                    "response_type": "CODE",
                    "assertion_claims_behavior": "MERGE_USER_INFO_OVER_ID_TOKEN_CLAIMS",
                },
            })
        ```
        ### Iam Workforce Pool Provider Oidc Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkforcePool("pool",
            workforce_pool_id="example-pool",
            parent="organizations/123456789",
            location="global")
        example = gcp.iam.WorkforcePoolProvider("example",
            workforce_pool_id=pool.workforce_pool_id,
            location=pool.location,
            provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            oidc={
                "issuer_uri": "https://login.microsoftonline.com/826602fe-2101-470c-9d71-ee1343668989/v2.0",
                "client_id": "client-id",
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
                "web_sso_config": {
                    "response_type": "CODE",
                    "assertion_claims_behavior": "MERGE_USER_INFO_OVER_ID_TOKEN_CLAIMS",
                    "additional_scopes": [
                        "groups",
                        "roles",
                    ],
                },
            },
            extra_attributes_oauth2_client={
                "issuer_uri": "https://login.microsoftonline.com/826602fe-2101-470c-9d71-ee1343668989/v2.0",
                "client_id": "client-id",
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
                "attributes_type": "AZURE_AD_GROUPS_MAIL",
                "query_parameters": {
                    "filter": "mail:sales",
                },
            },
            display_name="Display name",
            description="A sample OIDC workforce pool provider.",
            disabled=False,
            attribute_condition="true")
        ```
        ### Iam Workforce Pool Provider Extra Attributes Oauth2 Config Client Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkforcePool("pool",
            workforce_pool_id="example-pool",
            parent="organizations/123456789",
            location="global")
        example = gcp.iam.WorkforcePoolProvider("example",
            workforce_pool_id=pool.workforce_pool_id,
            location=pool.location,
            provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            oidc={
                "issuer_uri": "https://sts.windows.net/826602fe-2101-470c-9d71-ee1343668989/",
                "client_id": "https://analysis.windows.net/powerbi/connector/GoogleBigQuery",
                "web_sso_config": {
                    "response_type": "CODE",
                    "assertion_claims_behavior": "MERGE_USER_INFO_OVER_ID_TOKEN_CLAIMS",
                },
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
            },
            extra_attributes_oauth2_client={
                "issuer_uri": "https://login.microsoftonline.com/826602fe-2101-470c-9d71-ee1343668989/v2.0",
                "client_id": "client-id",
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
                "attributes_type": "AZURE_AD_GROUPS_MAIL",
            })
        ```
        ### Iam Workforce Pool Provider Extra Attributes Oauth2 Config Client Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pool = gcp.iam.WorkforcePool("pool",
            workforce_pool_id="example-pool",
            parent="organizations/123456789",
            location="global")
        example = gcp.iam.WorkforcePoolProvider("example",
            workforce_pool_id=pool.workforce_pool_id,
            location=pool.location,
            provider_id="example-prvdr",
            attribute_mapping={
                "google.subject": "assertion.sub",
            },
            oidc={
                "issuer_uri": "https://sts.windows.net/826602fe-2101-470c-9d71-ee1343668989/",
                "client_id": "https://analysis.windows.net/powerbi/connector/GoogleBigQuery",
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
                "web_sso_config": {
                    "response_type": "CODE",
                    "assertion_claims_behavior": "MERGE_USER_INFO_OVER_ID_TOKEN_CLAIMS",
                },
            },
            extra_attributes_oauth2_client={
                "issuer_uri": "https://login.microsoftonline.com/826602fe-2101-470c-9d71-ee1343668989/v2.0",
                "client_id": "client-id",
                "client_secret": {
                    "value": {
                        "plain_text": "client-secret",
                    },
                },
                "attributes_type": "AZURE_AD_GROUPS_MAIL",
                "query_parameters": {
                    "filter": "mail:gcp",
                },
            })
        ```

        ## Import

        WorkforcePoolProvider can be imported using any of these accepted formats:

        * `locations/{{location}}/workforcePools/{{workforce_pool_id}}/providers/{{provider_id}}`

        * `{{location}}/{{workforce_pool_id}}/{{provider_id}}`

        When using the `pulumi import` command, WorkforcePoolProvider can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/workforcePoolProvider:WorkforcePoolProvider default locations/{{location}}/workforcePools/{{workforce_pool_id}}/providers/{{provider_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workforcePoolProvider:WorkforcePoolProvider default {{location}}/{{workforce_pool_id}}/{{provider_id}}
        ```

        :param str resource_name: The name of the resource.
        :param WorkforcePoolProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkforcePoolProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attribute_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 attribute_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extra_attributes_oauth2_client: Optional[pulumi.Input[Union['WorkforcePoolProviderExtraAttributesOauth2ClientArgs', 'WorkforcePoolProviderExtraAttributesOauth2ClientArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 oidc: Optional[pulumi.Input[Union['WorkforcePoolProviderOidcArgs', 'WorkforcePoolProviderOidcArgsDict']]] = None,
                 provider_id: Optional[pulumi.Input[_builtins.str]] = None,
                 saml: Optional[pulumi.Input[Union['WorkforcePoolProviderSamlArgs', 'WorkforcePoolProviderSamlArgsDict']]] = None,
                 workforce_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkforcePoolProviderArgs.__new__(WorkforcePoolProviderArgs)

            __props__.__dict__["attribute_condition"] = attribute_condition
            __props__.__dict__["attribute_mapping"] = attribute_mapping
            __props__.__dict__["description"] = description
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["extra_attributes_oauth2_client"] = extra_attributes_oauth2_client
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["oidc"] = oidc
            if provider_id is None and not opts.urn:
                raise TypeError("Missing required property 'provider_id'")
            __props__.__dict__["provider_id"] = provider_id
            __props__.__dict__["saml"] = saml
            if workforce_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'workforce_pool_id'")
            __props__.__dict__["workforce_pool_id"] = workforce_pool_id
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
        super(WorkforcePoolProvider, __self__).__init__(
            'gcp:iam/workforcePoolProvider:WorkforcePoolProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attribute_condition: Optional[pulumi.Input[_builtins.str]] = None,
            attribute_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            extra_attributes_oauth2_client: Optional[pulumi.Input[Union['WorkforcePoolProviderExtraAttributesOauth2ClientArgs', 'WorkforcePoolProviderExtraAttributesOauth2ClientArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            oidc: Optional[pulumi.Input[Union['WorkforcePoolProviderOidcArgs', 'WorkforcePoolProviderOidcArgsDict']]] = None,
            provider_id: Optional[pulumi.Input[_builtins.str]] = None,
            saml: Optional[pulumi.Input[Union['WorkforcePoolProviderSamlArgs', 'WorkforcePoolProviderSamlArgsDict']]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            workforce_pool_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkforcePoolProvider':
        """
        Get an existing WorkforcePoolProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] attribute_condition: A [Common Expression Language](https://opensource.google/projects/cel) expression, in
               plain text, to restrict what otherwise valid authentication credentials issued by the
               provider should not be accepted.
               The expression must output a boolean representing whether to allow the federation.
               The following keywords may be referenced in the expressions:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] attribute_mapping: Maps attributes from the authentication credentials issued by an external identity provider
               to Google Cloud attributes, such as `subject` and `segment`.
               Each key must be a string specifying the Google Cloud IAM attribute to map to.
               The following keys are supported:
               * `google.subject`: The principal IAM is authenticating. You can reference this value in IAM bindings.
               This is also the subject that appears in Cloud Logging logs. This is a required field and
               the mapped subject cannot exceed 127 bytes.
               * `google.groups`: Groups the authenticating user belongs to. You can grant groups access to
               resources using an IAM `principalSet` binding; access applies to all members of the group.
               * `google.display_name`: The name of the authenticated user. This is an optional field and
               the mapped display name cannot exceed 100 bytes. If not set, `google.subject` will be displayed instead.
               This attribute cannot be referenced in IAM bindings.
               * `google.profile_photo`: The URL that specifies the authenticated user's thumbnail photo.
               This is an optional field. When set, the image will be visible as the user's profile picture.
               If not set, a generic user icon will be displayed instead.
               This attribute cannot be referenced in IAM bindings.
               You can also provide custom attributes by specifying `attribute.{custom_attribute}`, where {custom_attribute}
               is the name of the custom attribute to be mapped. You can define a maximum of 50 custom attributes.
               The maximum length of a mapped attribute key is 100 characters, and the key may only contain the characters [a-z0-9_].
               You can reference these attributes in IAM policies to define fine-grained access for a workforce pool
               to Google Cloud resources. For example:
               * `google.subject`:
               `principal://iam.googleapis.com/locations/{location}/workforcePools/{pool}/subject/{value}`
               * `google.groups`:
               `principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/group/{value}`
               * `attribute.{custom_attribute}`:
               `principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/attribute.{custom_attribute}/{value}`
               Each value must be a [Common Expression Language](https://opensource.google/projects/cel)
               function that maps an identity provider credential to the normalized attribute specified
               by the corresponding map key.
               You can use the `assertion` keyword in the expression to access a JSON representation of
               the authentication credential issued by the provider.
               The maximum length of an attribute mapping expression is 2048 characters. When evaluated,
               the total size of all mapped attributes must not exceed 8KB.
               For OIDC providers, you must supply a custom mapping that includes the `google.subject` attribute.
               For example, the following maps the sub claim of the incoming credential to the `subject` attribute
               on a Google token:
               ```
               {"google.subject": "assertion.sub"}
               ```
               An object containing a list of `"key": value` pairs.
               Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
        :param pulumi.Input[_builtins.str] description: A user-specified description of the provider. Cannot exceed 256 characters.
        :param pulumi.Input[_builtins.bool] disabled: Whether the provider is disabled. You cannot use a disabled provider to exchange tokens.
               However, existing tokens still grant access.
        :param pulumi.Input[_builtins.str] display_name: A user-specified display name for the provider. Cannot exceed 32 characters.
        :param pulumi.Input[Union['WorkforcePoolProviderExtraAttributesOauth2ClientArgs', 'WorkforcePoolProviderExtraAttributesOauth2ClientArgsDict']] extra_attributes_oauth2_client: The configuration for OAuth 2.0 client used to get the additional user
               attributes. This should be used when users can't get the desired claims
               in authentication credentials. Currently this configuration is only
               supported with SAML and OIDC protocol.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The location for the resource.
        :param pulumi.Input[_builtins.str] name: Output only. The resource name of the provider.
               Format: `locations/{location}/workforcePools/{workforcePoolId}/providers/{providerId}`
        :param pulumi.Input[Union['WorkforcePoolProviderOidcArgs', 'WorkforcePoolProviderOidcArgsDict']] oidc: Represents an OpenId Connect 1.0 identity provider.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] provider_id: The ID for the provider, which becomes the final component of the resource name.
               This value must be 4-32 characters, and may contain the characters [a-z0-9-].
               The prefix `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input[Union['WorkforcePoolProviderSamlArgs', 'WorkforcePoolProviderSamlArgsDict']] saml: Represents a SAML identity provider.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: The current state of the provider.
               * STATE_UNSPECIFIED: State unspecified.
               * ACTIVE: The provider is active and may be used to validate authentication credentials.
               * DELETED: The provider is soft-deleted. Soft-deleted providers are permanently
               deleted after approximately 30 days. You can restore a soft-deleted provider using
               [providers.undelete](https://cloud.google.com/iam/docs/reference/rest/v1/locations.workforcePools.providers/undelete#google.iam.admin.v1.WorkforcePools.UndeleteWorkforcePoolProvider).
        :param pulumi.Input[_builtins.str] workforce_pool_id: The ID to use for the pool, which becomes the final component of the resource name.
               The IDs must be a globally unique string of 6 to 63 lowercase letters, digits, or hyphens.
               It must start with a letter, and cannot have a trailing hyphen.
               The prefix `gcp-` is reserved for use by Google, and may not be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkforcePoolProviderState.__new__(_WorkforcePoolProviderState)

        __props__.__dict__["attribute_condition"] = attribute_condition
        __props__.__dict__["attribute_mapping"] = attribute_mapping
        __props__.__dict__["description"] = description
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["extra_attributes_oauth2_client"] = extra_attributes_oauth2_client
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["oidc"] = oidc
        __props__.__dict__["provider_id"] = provider_id
        __props__.__dict__["saml"] = saml
        __props__.__dict__["state"] = state
        __props__.__dict__["workforce_pool_id"] = workforce_pool_id
        return WorkforcePoolProvider(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="attributeCondition")
    def attribute_condition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A [Common Expression Language](https://opensource.google/projects/cel) expression, in
        plain text, to restrict what otherwise valid authentication credentials issued by the
        provider should not be accepted.
        The expression must output a boolean representing whether to allow the federation.
        The following keywords may be referenced in the expressions:
        """
        return pulumi.get(self, "attribute_condition")

    @_builtins.property
    @pulumi.getter(name="attributeMapping")
    def attribute_mapping(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Maps attributes from the authentication credentials issued by an external identity provider
        to Google Cloud attributes, such as `subject` and `segment`.
        Each key must be a string specifying the Google Cloud IAM attribute to map to.
        The following keys are supported:
        * `google.subject`: The principal IAM is authenticating. You can reference this value in IAM bindings.
        This is also the subject that appears in Cloud Logging logs. This is a required field and
        the mapped subject cannot exceed 127 bytes.
        * `google.groups`: Groups the authenticating user belongs to. You can grant groups access to
        resources using an IAM `principalSet` binding; access applies to all members of the group.
        * `google.display_name`: The name of the authenticated user. This is an optional field and
        the mapped display name cannot exceed 100 bytes. If not set, `google.subject` will be displayed instead.
        This attribute cannot be referenced in IAM bindings.
        * `google.profile_photo`: The URL that specifies the authenticated user's thumbnail photo.
        This is an optional field. When set, the image will be visible as the user's profile picture.
        If not set, a generic user icon will be displayed instead.
        This attribute cannot be referenced in IAM bindings.
        You can also provide custom attributes by specifying `attribute.{custom_attribute}`, where {custom_attribute}
        is the name of the custom attribute to be mapped. You can define a maximum of 50 custom attributes.
        The maximum length of a mapped attribute key is 100 characters, and the key may only contain the characters [a-z0-9_].
        You can reference these attributes in IAM policies to define fine-grained access for a workforce pool
        to Google Cloud resources. For example:
        * `google.subject`:
        `principal://iam.googleapis.com/locations/{location}/workforcePools/{pool}/subject/{value}`
        * `google.groups`:
        `principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/group/{value}`
        * `attribute.{custom_attribute}`:
        `principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/attribute.{custom_attribute}/{value}`
        Each value must be a [Common Expression Language](https://opensource.google/projects/cel)
        function that maps an identity provider credential to the normalized attribute specified
        by the corresponding map key.
        You can use the `assertion` keyword in the expression to access a JSON representation of
        the authentication credential issued by the provider.
        The maximum length of an attribute mapping expression is 2048 characters. When evaluated,
        the total size of all mapped attributes must not exceed 8KB.
        For OIDC providers, you must supply a custom mapping that includes the `google.subject` attribute.
        For example, the following maps the sub claim of the incoming credential to the `subject` attribute
        on a Google token:
        ```
        {"google.subject": "assertion.sub"}
        ```
        An object containing a list of `"key": value` pairs.
        Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
        """
        return pulumi.get(self, "attribute_mapping")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A user-specified description of the provider. Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the provider is disabled. You cannot use a disabled provider to exchange tokens.
        However, existing tokens still grant access.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A user-specified display name for the provider. Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="extraAttributesOauth2Client")
    def extra_attributes_oauth2_client(self) -> pulumi.Output[Optional['outputs.WorkforcePoolProviderExtraAttributesOauth2Client']]:
        """
        The configuration for OAuth 2.0 client used to get the additional user
        attributes. This should be used when users can't get the desired claims
        in authentication credentials. Currently this configuration is only
        supported with SAML and OIDC protocol.
        Structure is documented below.
        """
        return pulumi.get(self, "extra_attributes_oauth2_client")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location for the resource.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The resource name of the provider.
        Format: `locations/{location}/workforcePools/{workforcePoolId}/providers/{providerId}`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def oidc(self) -> pulumi.Output[Optional['outputs.WorkforcePoolProviderOidc']]:
        """
        Represents an OpenId Connect 1.0 identity provider.
        Structure is documented below.
        """
        return pulumi.get(self, "oidc")

    @_builtins.property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID for the provider, which becomes the final component of the resource name.
        This value must be 4-32 characters, and may contain the characters [a-z0-9-].
        The prefix `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "provider_id")

    @_builtins.property
    @pulumi.getter
    def saml(self) -> pulumi.Output[Optional['outputs.WorkforcePoolProviderSaml']]:
        """
        Represents a SAML identity provider.
        Structure is documented below.
        """
        return pulumi.get(self, "saml")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the provider.
        * STATE_UNSPECIFIED: State unspecified.
        * ACTIVE: The provider is active and may be used to validate authentication credentials.
        * DELETED: The provider is soft-deleted. Soft-deleted providers are permanently
        deleted after approximately 30 days. You can restore a soft-deleted provider using
        [providers.undelete](https://cloud.google.com/iam/docs/reference/rest/v1/locations.workforcePools.providers/undelete#google.iam.admin.v1.WorkforcePools.UndeleteWorkforcePoolProvider).
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="workforcePoolId")
    def workforce_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID to use for the pool, which becomes the final component of the resource name.
        The IDs must be a globally unique string of 6 to 63 lowercase letters, digits, or hyphens.
        It must start with a letter, and cannot have a trailing hyphen.
        The prefix `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "workforce_pool_id")

