# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkloadIdentityPoolArgs', 'WorkloadIdentityPool']

@pulumi.input_type
class WorkloadIdentityPoolArgs:
    def __init__(__self__, *,
                 workload_identity_pool_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 inline_certificate_issuance_config: Optional[pulumi.Input['WorkloadIdentityPoolInlineCertificateIssuanceConfigArgs']] = None,
                 inline_trust_config: Optional[pulumi.Input['WorkloadIdentityPoolInlineTrustConfigArgs']] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WorkloadIdentityPool resource.
        :param pulumi.Input[_builtins.str] workload_identity_pool_id: The ID to use for the pool, which becomes the final component of the resource name. This
               value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
               `gcp-` is reserved for use by Google, and may not be specified.
        :param pulumi.Input[_builtins.str] description: A description of the pool. Cannot exceed 256 characters.
        :param pulumi.Input[_builtins.bool] disabled: Whether the pool is disabled. You cannot use a disabled pool to exchange tokens, or use
               existing tokens to access resources. If the pool is re-enabled, existing tokens grant
               access again.
        :param pulumi.Input[_builtins.str] display_name: A display name for the pool. Cannot exceed 32 characters.
        :param pulumi.Input['WorkloadIdentityPoolInlineCertificateIssuanceConfigArgs'] inline_certificate_issuance_config: Represents configuration for generating mutual TLS (mTLS) certificates for the identities
               within this pool. Defines the Certificate Authority (CA) pool resources and configurations
               required for issuance and rotation of mTLS workload certificates.
               Structure is documented below.
        :param pulumi.Input['WorkloadIdentityPoolInlineTrustConfigArgs'] inline_trust_config: Represents config to add additional trusted trust domains. Defines configuration for extending
               trust to additional trust domains. By establishing trust with another domain, the current
               domain will recognize and accept certificates issued by entities within the trusted domains.
               Note that a trust domain automatically trusts itself, eliminating the need for explicit
               configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] mode: The mode for the pool is operating in. Pools with an unspecified mode will operate as if they
               are in `FEDERATION_ONLY` mode.
               
               > **Note** This field cannot be changed after the Workload Identity Pool is created. While
               `pulumi preview` may show an update if you change this field's value, `pulumi up`
               **will fail with an API error** (such as `Error 400: Attempted to update an immutable field.`).
               To specify a different `mode`, please create a new Workload Identity Pool resource.
               * `FEDERATION_ONLY`: Pools can only be used for federating external workload identities into
               Google Cloud. Unless otherwise noted, no structure or format constraints are applied to
               workload identities in a `FEDERATION_ONLY` mode pool, and you may not create any resources
               within the pool besides providers.
               * `TRUST_DOMAIN`: Pools can be used to assign identities to Google Cloud workloads. All
               identities within a `TRUST_DOMAIN` mode pool must consist of a single namespace and individual
               workload identifier. The subject identifier for all identities must conform to the following
               format: `ns/<namespace>/sa/<workload_identifier>`.
               `iam.WorkloadIdentityPoolProvider`s cannot be created within `TRUST_DOMAIN`
               mode pools.
               Possible values are: `FEDERATION_ONLY`, `TRUST_DOMAIN`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "workload_identity_pool_id", workload_identity_pool_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if inline_certificate_issuance_config is not None:
            pulumi.set(__self__, "inline_certificate_issuance_config", inline_certificate_issuance_config)
        if inline_trust_config is not None:
            pulumi.set(__self__, "inline_trust_config", inline_trust_config)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="workloadIdentityPoolId")
    def workload_identity_pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID to use for the pool, which becomes the final component of the resource name. This
        value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
        `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "workload_identity_pool_id")

    @workload_identity_pool_id.setter
    def workload_identity_pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workload_identity_pool_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the pool. Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the pool is disabled. You cannot use a disabled pool to exchange tokens, or use
        existing tokens to access resources. If the pool is re-enabled, existing tokens grant
        access again.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A display name for the pool. Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="inlineCertificateIssuanceConfig")
    def inline_certificate_issuance_config(self) -> Optional[pulumi.Input['WorkloadIdentityPoolInlineCertificateIssuanceConfigArgs']]:
        """
        Represents configuration for generating mutual TLS (mTLS) certificates for the identities
        within this pool. Defines the Certificate Authority (CA) pool resources and configurations
        required for issuance and rotation of mTLS workload certificates.
        Structure is documented below.
        """
        return pulumi.get(self, "inline_certificate_issuance_config")

    @inline_certificate_issuance_config.setter
    def inline_certificate_issuance_config(self, value: Optional[pulumi.Input['WorkloadIdentityPoolInlineCertificateIssuanceConfigArgs']]):
        pulumi.set(self, "inline_certificate_issuance_config", value)

    @_builtins.property
    @pulumi.getter(name="inlineTrustConfig")
    def inline_trust_config(self) -> Optional[pulumi.Input['WorkloadIdentityPoolInlineTrustConfigArgs']]:
        """
        Represents config to add additional trusted trust domains. Defines configuration for extending
        trust to additional trust domains. By establishing trust with another domain, the current
        domain will recognize and accept certificates issued by entities within the trusted domains.
        Note that a trust domain automatically trusts itself, eliminating the need for explicit
        configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "inline_trust_config")

    @inline_trust_config.setter
    def inline_trust_config(self, value: Optional[pulumi.Input['WorkloadIdentityPoolInlineTrustConfigArgs']]):
        pulumi.set(self, "inline_trust_config", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode for the pool is operating in. Pools with an unspecified mode will operate as if they
        are in `FEDERATION_ONLY` mode.

        > **Note** This field cannot be changed after the Workload Identity Pool is created. While
        `pulumi preview` may show an update if you change this field's value, `pulumi up`
        **will fail with an API error** (such as `Error 400: Attempted to update an immutable field.`).
        To specify a different `mode`, please create a new Workload Identity Pool resource.
        * `FEDERATION_ONLY`: Pools can only be used for federating external workload identities into
        Google Cloud. Unless otherwise noted, no structure or format constraints are applied to
        workload identities in a `FEDERATION_ONLY` mode pool, and you may not create any resources
        within the pool besides providers.
        * `TRUST_DOMAIN`: Pools can be used to assign identities to Google Cloud workloads. All
        identities within a `TRUST_DOMAIN` mode pool must consist of a single namespace and individual
        workload identifier. The subject identifier for all identities must conform to the following
        format: `ns/<namespace>/sa/<workload_identifier>`.
        `iam.WorkloadIdentityPoolProvider`s cannot be created within `TRUST_DOMAIN`
        mode pools.
        Possible values are: `FEDERATION_ONLY`, `TRUST_DOMAIN`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _WorkloadIdentityPoolState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 inline_certificate_issuance_config: Optional[pulumi.Input['WorkloadIdentityPoolInlineCertificateIssuanceConfigArgs']] = None,
                 inline_trust_config: Optional[pulumi.Input['WorkloadIdentityPoolInlineTrustConfigArgs']] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_identity_pool_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkloadIdentityPool resources.
        :param pulumi.Input[_builtins.str] description: A description of the pool. Cannot exceed 256 characters.
        :param pulumi.Input[_builtins.bool] disabled: Whether the pool is disabled. You cannot use a disabled pool to exchange tokens, or use
               existing tokens to access resources. If the pool is re-enabled, existing tokens grant
               access again.
        :param pulumi.Input[_builtins.str] display_name: A display name for the pool. Cannot exceed 32 characters.
        :param pulumi.Input['WorkloadIdentityPoolInlineCertificateIssuanceConfigArgs'] inline_certificate_issuance_config: Represents configuration for generating mutual TLS (mTLS) certificates for the identities
               within this pool. Defines the Certificate Authority (CA) pool resources and configurations
               required for issuance and rotation of mTLS workload certificates.
               Structure is documented below.
        :param pulumi.Input['WorkloadIdentityPoolInlineTrustConfigArgs'] inline_trust_config: Represents config to add additional trusted trust domains. Defines configuration for extending
               trust to additional trust domains. By establishing trust with another domain, the current
               domain will recognize and accept certificates issued by entities within the trusted domains.
               Note that a trust domain automatically trusts itself, eliminating the need for explicit
               configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] mode: The mode for the pool is operating in. Pools with an unspecified mode will operate as if they
               are in `FEDERATION_ONLY` mode.
               
               > **Note** This field cannot be changed after the Workload Identity Pool is created. While
               `pulumi preview` may show an update if you change this field's value, `pulumi up`
               **will fail with an API error** (such as `Error 400: Attempted to update an immutable field.`).
               To specify a different `mode`, please create a new Workload Identity Pool resource.
               * `FEDERATION_ONLY`: Pools can only be used for federating external workload identities into
               Google Cloud. Unless otherwise noted, no structure or format constraints are applied to
               workload identities in a `FEDERATION_ONLY` mode pool, and you may not create any resources
               within the pool besides providers.
               * `TRUST_DOMAIN`: Pools can be used to assign identities to Google Cloud workloads. All
               identities within a `TRUST_DOMAIN` mode pool must consist of a single namespace and individual
               workload identifier. The subject identifier for all identities must conform to the following
               format: `ns/<namespace>/sa/<workload_identifier>`.
               `iam.WorkloadIdentityPoolProvider`s cannot be created within `TRUST_DOMAIN`
               mode pools.
               Possible values are: `FEDERATION_ONLY`, `TRUST_DOMAIN`.
        :param pulumi.Input[_builtins.str] name: The resource name of the pool as
               `projects/{project_number}/locations/global/workloadIdentityPools/{workload_identity_pool_id}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] state: The state of the pool.
               * `STATE_UNSPECIFIED`: State unspecified.
               * `ACTIVE`: The pool is active, and may be used in Google Cloud policies.
               * `DELETED`: The pool is soft-deleted. Soft-deleted pools are permanently deleted after
               approximately 30 days. You can restore a soft-deleted pool using
               `UndeleteWorkloadIdentityPool`. You cannot reuse the ID of a soft-deleted pool until it is
               permanently deleted. While a pool is deleted, you cannot use it to exchange tokens, or
               use existing tokens to access resources. If the pool is undeleted, existing tokens grant
               access again.
        :param pulumi.Input[_builtins.str] workload_identity_pool_id: The ID to use for the pool, which becomes the final component of the resource name. This
               value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
               `gcp-` is reserved for use by Google, and may not be specified.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if inline_certificate_issuance_config is not None:
            pulumi.set(__self__, "inline_certificate_issuance_config", inline_certificate_issuance_config)
        if inline_trust_config is not None:
            pulumi.set(__self__, "inline_trust_config", inline_trust_config)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if workload_identity_pool_id is not None:
            pulumi.set(__self__, "workload_identity_pool_id", workload_identity_pool_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the pool. Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the pool is disabled. You cannot use a disabled pool to exchange tokens, or use
        existing tokens to access resources. If the pool is re-enabled, existing tokens grant
        access again.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A display name for the pool. Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="inlineCertificateIssuanceConfig")
    def inline_certificate_issuance_config(self) -> Optional[pulumi.Input['WorkloadIdentityPoolInlineCertificateIssuanceConfigArgs']]:
        """
        Represents configuration for generating mutual TLS (mTLS) certificates for the identities
        within this pool. Defines the Certificate Authority (CA) pool resources and configurations
        required for issuance and rotation of mTLS workload certificates.
        Structure is documented below.
        """
        return pulumi.get(self, "inline_certificate_issuance_config")

    @inline_certificate_issuance_config.setter
    def inline_certificate_issuance_config(self, value: Optional[pulumi.Input['WorkloadIdentityPoolInlineCertificateIssuanceConfigArgs']]):
        pulumi.set(self, "inline_certificate_issuance_config", value)

    @_builtins.property
    @pulumi.getter(name="inlineTrustConfig")
    def inline_trust_config(self) -> Optional[pulumi.Input['WorkloadIdentityPoolInlineTrustConfigArgs']]:
        """
        Represents config to add additional trusted trust domains. Defines configuration for extending
        trust to additional trust domains. By establishing trust with another domain, the current
        domain will recognize and accept certificates issued by entities within the trusted domains.
        Note that a trust domain automatically trusts itself, eliminating the need for explicit
        configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "inline_trust_config")

    @inline_trust_config.setter
    def inline_trust_config(self, value: Optional[pulumi.Input['WorkloadIdentityPoolInlineTrustConfigArgs']]):
        pulumi.set(self, "inline_trust_config", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode for the pool is operating in. Pools with an unspecified mode will operate as if they
        are in `FEDERATION_ONLY` mode.

        > **Note** This field cannot be changed after the Workload Identity Pool is created. While
        `pulumi preview` may show an update if you change this field's value, `pulumi up`
        **will fail with an API error** (such as `Error 400: Attempted to update an immutable field.`).
        To specify a different `mode`, please create a new Workload Identity Pool resource.
        * `FEDERATION_ONLY`: Pools can only be used for federating external workload identities into
        Google Cloud. Unless otherwise noted, no structure or format constraints are applied to
        workload identities in a `FEDERATION_ONLY` mode pool, and you may not create any resources
        within the pool besides providers.
        * `TRUST_DOMAIN`: Pools can be used to assign identities to Google Cloud workloads. All
        identities within a `TRUST_DOMAIN` mode pool must consist of a single namespace and individual
        workload identifier. The subject identifier for all identities must conform to the following
        format: `ns/<namespace>/sa/<workload_identifier>`.
        `iam.WorkloadIdentityPoolProvider`s cannot be created within `TRUST_DOMAIN`
        mode pools.
        Possible values are: `FEDERATION_ONLY`, `TRUST_DOMAIN`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the pool as
        `projects/{project_number}/locations/global/workloadIdentityPools/{workload_identity_pool_id}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the pool.
        * `STATE_UNSPECIFIED`: State unspecified.
        * `ACTIVE`: The pool is active, and may be used in Google Cloud policies.
        * `DELETED`: The pool is soft-deleted. Soft-deleted pools are permanently deleted after
        approximately 30 days. You can restore a soft-deleted pool using
        `UndeleteWorkloadIdentityPool`. You cannot reuse the ID of a soft-deleted pool until it is
        permanently deleted. While a pool is deleted, you cannot use it to exchange tokens, or
        use existing tokens to access resources. If the pool is undeleted, existing tokens grant
        access again.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="workloadIdentityPoolId")
    def workload_identity_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID to use for the pool, which becomes the final component of the resource name. This
        value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
        `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "workload_identity_pool_id")

    @workload_identity_pool_id.setter
    def workload_identity_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workload_identity_pool_id", value)


@pulumi.type_token("gcp:iam/workloadIdentityPool:WorkloadIdentityPool")
class WorkloadIdentityPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 inline_certificate_issuance_config: Optional[pulumi.Input[Union['WorkloadIdentityPoolInlineCertificateIssuanceConfigArgs', 'WorkloadIdentityPoolInlineCertificateIssuanceConfigArgsDict']]] = None,
                 inline_trust_config: Optional[pulumi.Input[Union['WorkloadIdentityPoolInlineTrustConfigArgs', 'WorkloadIdentityPoolInlineTrustConfigArgsDict']]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_identity_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Represents a collection of external workload identities. You can define IAM policies to
        grant these identities access to Google Cloud resources.

        To get more information about WorkloadIdentityPool, see:

        * [API documentation](https://cloud.google.com/iam/docs/reference/rest/v1/projects.locations.workloadIdentityPools)
        * How-to Guides
            * [Configure managed workload identity authentication for Compute Engine](https://cloud.google.com/iam/docs/create-managed-workload-identities)
            * [Configure managed workload identity authentication for GKE](https://cloud.google.com/iam/docs/create-managed-workload-identities-gke)
            * [Managing workload identity pools](https://cloud.google.com/iam/docs/manage-workload-identity-pools-providers#pools)

        ## Example Usage

        ### Iam Workload Identity Pool Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.iam.WorkloadIdentityPool("example", workload_identity_pool_id="example-pool")
        ```
        ### Iam Workload Identity Pool Full Federation Only Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.iam.WorkloadIdentityPool("example",
            workload_identity_pool_id="example-pool",
            display_name="Name of the pool",
            description="Identity pool operates in FEDERATION_ONLY mode",
            disabled=True,
            mode="FEDERATION_ONLY")
        ```
        ### Iam Workload Identity Pool Full Trust Domain Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        example = gcp.iam.WorkloadIdentityPool("example",
            workload_identity_pool_id="example-pool",
            display_name="Name of the pool",
            description="Identity pool operates in TRUST_DOMAIN mode",
            disabled=True,
            mode="TRUST_DOMAIN",
            inline_certificate_issuance_config={
                "ca_pools": {
                    "us-central1": "projects/project-bar/locations/us-central1/caPools/ca-pool-bar",
                    "asia-east2": "projects/project-foo/locations/asia-east2/caPools/ca-pool-foo",
                },
                "lifetime": "86400s",
                "rotation_window_percentage": 50,
                "key_algorithm": "ECDSA_P256",
            },
            inline_trust_config={
                "additional_trust_bundles": [
                    {
                        "trust_domain": "example.com",
                        "trust_anchors": [
                            {
                                "pem_certificate": std.file(input="test-fixtures/trust_anchor_1.pem").result,
                            },
                            {
                                "pem_certificate": std.file(input="test-fixtures/trust_anchor_2.pem").result,
                            },
                        ],
                    },
                    {
                        "trust_domain": "example.net",
                        "trust_anchors": [
                            {
                                "pem_certificate": std.file(input="test-fixtures/trust_anchor_3.pem").result,
                            },
                            {
                                "pem_certificate": std.file(input="test-fixtures/trust_anchor_4.pem").result,
                            },
                        ],
                    },
                ],
            })
        ```

        ## Import

        WorkloadIdentityPool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/workloadIdentityPools/{{workload_identity_pool_id}}`

        * `{{project}}/{{workload_identity_pool_id}}`

        * `{{workload_identity_pool_id}}`

        When using the `pulumi import` command, WorkloadIdentityPool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPool:WorkloadIdentityPool default projects/{{project}}/locations/global/workloadIdentityPools/{{workload_identity_pool_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPool:WorkloadIdentityPool default {{project}}/{{workload_identity_pool_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPool:WorkloadIdentityPool default {{workload_identity_pool_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description of the pool. Cannot exceed 256 characters.
        :param pulumi.Input[_builtins.bool] disabled: Whether the pool is disabled. You cannot use a disabled pool to exchange tokens, or use
               existing tokens to access resources. If the pool is re-enabled, existing tokens grant
               access again.
        :param pulumi.Input[_builtins.str] display_name: A display name for the pool. Cannot exceed 32 characters.
        :param pulumi.Input[Union['WorkloadIdentityPoolInlineCertificateIssuanceConfigArgs', 'WorkloadIdentityPoolInlineCertificateIssuanceConfigArgsDict']] inline_certificate_issuance_config: Represents configuration for generating mutual TLS (mTLS) certificates for the identities
               within this pool. Defines the Certificate Authority (CA) pool resources and configurations
               required for issuance and rotation of mTLS workload certificates.
               Structure is documented below.
        :param pulumi.Input[Union['WorkloadIdentityPoolInlineTrustConfigArgs', 'WorkloadIdentityPoolInlineTrustConfigArgsDict']] inline_trust_config: Represents config to add additional trusted trust domains. Defines configuration for extending
               trust to additional trust domains. By establishing trust with another domain, the current
               domain will recognize and accept certificates issued by entities within the trusted domains.
               Note that a trust domain automatically trusts itself, eliminating the need for explicit
               configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] mode: The mode for the pool is operating in. Pools with an unspecified mode will operate as if they
               are in `FEDERATION_ONLY` mode.
               
               > **Note** This field cannot be changed after the Workload Identity Pool is created. While
               `pulumi preview` may show an update if you change this field's value, `pulumi up`
               **will fail with an API error** (such as `Error 400: Attempted to update an immutable field.`).
               To specify a different `mode`, please create a new Workload Identity Pool resource.
               * `FEDERATION_ONLY`: Pools can only be used for federating external workload identities into
               Google Cloud. Unless otherwise noted, no structure or format constraints are applied to
               workload identities in a `FEDERATION_ONLY` mode pool, and you may not create any resources
               within the pool besides providers.
               * `TRUST_DOMAIN`: Pools can be used to assign identities to Google Cloud workloads. All
               identities within a `TRUST_DOMAIN` mode pool must consist of a single namespace and individual
               workload identifier. The subject identifier for all identities must conform to the following
               format: `ns/<namespace>/sa/<workload_identifier>`.
               `iam.WorkloadIdentityPoolProvider`s cannot be created within `TRUST_DOMAIN`
               mode pools.
               Possible values are: `FEDERATION_ONLY`, `TRUST_DOMAIN`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] workload_identity_pool_id: The ID to use for the pool, which becomes the final component of the resource name. This
               value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
               `gcp-` is reserved for use by Google, and may not be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkloadIdentityPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a collection of external workload identities. You can define IAM policies to
        grant these identities access to Google Cloud resources.

        To get more information about WorkloadIdentityPool, see:

        * [API documentation](https://cloud.google.com/iam/docs/reference/rest/v1/projects.locations.workloadIdentityPools)
        * How-to Guides
            * [Configure managed workload identity authentication for Compute Engine](https://cloud.google.com/iam/docs/create-managed-workload-identities)
            * [Configure managed workload identity authentication for GKE](https://cloud.google.com/iam/docs/create-managed-workload-identities-gke)
            * [Managing workload identity pools](https://cloud.google.com/iam/docs/manage-workload-identity-pools-providers#pools)

        ## Example Usage

        ### Iam Workload Identity Pool Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.iam.WorkloadIdentityPool("example", workload_identity_pool_id="example-pool")
        ```
        ### Iam Workload Identity Pool Full Federation Only Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.iam.WorkloadIdentityPool("example",
            workload_identity_pool_id="example-pool",
            display_name="Name of the pool",
            description="Identity pool operates in FEDERATION_ONLY mode",
            disabled=True,
            mode="FEDERATION_ONLY")
        ```
        ### Iam Workload Identity Pool Full Trust Domain Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        example = gcp.iam.WorkloadIdentityPool("example",
            workload_identity_pool_id="example-pool",
            display_name="Name of the pool",
            description="Identity pool operates in TRUST_DOMAIN mode",
            disabled=True,
            mode="TRUST_DOMAIN",
            inline_certificate_issuance_config={
                "ca_pools": {
                    "us-central1": "projects/project-bar/locations/us-central1/caPools/ca-pool-bar",
                    "asia-east2": "projects/project-foo/locations/asia-east2/caPools/ca-pool-foo",
                },
                "lifetime": "86400s",
                "rotation_window_percentage": 50,
                "key_algorithm": "ECDSA_P256",
            },
            inline_trust_config={
                "additional_trust_bundles": [
                    {
                        "trust_domain": "example.com",
                        "trust_anchors": [
                            {
                                "pem_certificate": std.file(input="test-fixtures/trust_anchor_1.pem").result,
                            },
                            {
                                "pem_certificate": std.file(input="test-fixtures/trust_anchor_2.pem").result,
                            },
                        ],
                    },
                    {
                        "trust_domain": "example.net",
                        "trust_anchors": [
                            {
                                "pem_certificate": std.file(input="test-fixtures/trust_anchor_3.pem").result,
                            },
                            {
                                "pem_certificate": std.file(input="test-fixtures/trust_anchor_4.pem").result,
                            },
                        ],
                    },
                ],
            })
        ```

        ## Import

        WorkloadIdentityPool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/workloadIdentityPools/{{workload_identity_pool_id}}`

        * `{{project}}/{{workload_identity_pool_id}}`

        * `{{workload_identity_pool_id}}`

        When using the `pulumi import` command, WorkloadIdentityPool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPool:WorkloadIdentityPool default projects/{{project}}/locations/global/workloadIdentityPools/{{workload_identity_pool_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPool:WorkloadIdentityPool default {{project}}/{{workload_identity_pool_id}}
        ```

        ```sh
        $ pulumi import gcp:iam/workloadIdentityPool:WorkloadIdentityPool default {{workload_identity_pool_id}}
        ```

        :param str resource_name: The name of the resource.
        :param WorkloadIdentityPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkloadIdentityPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 inline_certificate_issuance_config: Optional[pulumi.Input[Union['WorkloadIdentityPoolInlineCertificateIssuanceConfigArgs', 'WorkloadIdentityPoolInlineCertificateIssuanceConfigArgsDict']]] = None,
                 inline_trust_config: Optional[pulumi.Input[Union['WorkloadIdentityPoolInlineTrustConfigArgs', 'WorkloadIdentityPoolInlineTrustConfigArgsDict']]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_identity_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkloadIdentityPoolArgs.__new__(WorkloadIdentityPoolArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["inline_certificate_issuance_config"] = inline_certificate_issuance_config
            __props__.__dict__["inline_trust_config"] = inline_trust_config
            __props__.__dict__["mode"] = mode
            __props__.__dict__["project"] = project
            if workload_identity_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'workload_identity_pool_id'")
            __props__.__dict__["workload_identity_pool_id"] = workload_identity_pool_id
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
        super(WorkloadIdentityPool, __self__).__init__(
            'gcp:iam/workloadIdentityPool:WorkloadIdentityPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            inline_certificate_issuance_config: Optional[pulumi.Input[Union['WorkloadIdentityPoolInlineCertificateIssuanceConfigArgs', 'WorkloadIdentityPoolInlineCertificateIssuanceConfigArgsDict']]] = None,
            inline_trust_config: Optional[pulumi.Input[Union['WorkloadIdentityPoolInlineTrustConfigArgs', 'WorkloadIdentityPoolInlineTrustConfigArgsDict']]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            workload_identity_pool_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkloadIdentityPool':
        """
        Get an existing WorkloadIdentityPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description of the pool. Cannot exceed 256 characters.
        :param pulumi.Input[_builtins.bool] disabled: Whether the pool is disabled. You cannot use a disabled pool to exchange tokens, or use
               existing tokens to access resources. If the pool is re-enabled, existing tokens grant
               access again.
        :param pulumi.Input[_builtins.str] display_name: A display name for the pool. Cannot exceed 32 characters.
        :param pulumi.Input[Union['WorkloadIdentityPoolInlineCertificateIssuanceConfigArgs', 'WorkloadIdentityPoolInlineCertificateIssuanceConfigArgsDict']] inline_certificate_issuance_config: Represents configuration for generating mutual TLS (mTLS) certificates for the identities
               within this pool. Defines the Certificate Authority (CA) pool resources and configurations
               required for issuance and rotation of mTLS workload certificates.
               Structure is documented below.
        :param pulumi.Input[Union['WorkloadIdentityPoolInlineTrustConfigArgs', 'WorkloadIdentityPoolInlineTrustConfigArgsDict']] inline_trust_config: Represents config to add additional trusted trust domains. Defines configuration for extending
               trust to additional trust domains. By establishing trust with another domain, the current
               domain will recognize and accept certificates issued by entities within the trusted domains.
               Note that a trust domain automatically trusts itself, eliminating the need for explicit
               configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] mode: The mode for the pool is operating in. Pools with an unspecified mode will operate as if they
               are in `FEDERATION_ONLY` mode.
               
               > **Note** This field cannot be changed after the Workload Identity Pool is created. While
               `pulumi preview` may show an update if you change this field's value, `pulumi up`
               **will fail with an API error** (such as `Error 400: Attempted to update an immutable field.`).
               To specify a different `mode`, please create a new Workload Identity Pool resource.
               * `FEDERATION_ONLY`: Pools can only be used for federating external workload identities into
               Google Cloud. Unless otherwise noted, no structure or format constraints are applied to
               workload identities in a `FEDERATION_ONLY` mode pool, and you may not create any resources
               within the pool besides providers.
               * `TRUST_DOMAIN`: Pools can be used to assign identities to Google Cloud workloads. All
               identities within a `TRUST_DOMAIN` mode pool must consist of a single namespace and individual
               workload identifier. The subject identifier for all identities must conform to the following
               format: `ns/<namespace>/sa/<workload_identifier>`.
               `iam.WorkloadIdentityPoolProvider`s cannot be created within `TRUST_DOMAIN`
               mode pools.
               Possible values are: `FEDERATION_ONLY`, `TRUST_DOMAIN`.
        :param pulumi.Input[_builtins.str] name: The resource name of the pool as
               `projects/{project_number}/locations/global/workloadIdentityPools/{workload_identity_pool_id}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] state: The state of the pool.
               * `STATE_UNSPECIFIED`: State unspecified.
               * `ACTIVE`: The pool is active, and may be used in Google Cloud policies.
               * `DELETED`: The pool is soft-deleted. Soft-deleted pools are permanently deleted after
               approximately 30 days. You can restore a soft-deleted pool using
               `UndeleteWorkloadIdentityPool`. You cannot reuse the ID of a soft-deleted pool until it is
               permanently deleted. While a pool is deleted, you cannot use it to exchange tokens, or
               use existing tokens to access resources. If the pool is undeleted, existing tokens grant
               access again.
        :param pulumi.Input[_builtins.str] workload_identity_pool_id: The ID to use for the pool, which becomes the final component of the resource name. This
               value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
               `gcp-` is reserved for use by Google, and may not be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkloadIdentityPoolState.__new__(_WorkloadIdentityPoolState)

        __props__.__dict__["description"] = description
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["inline_certificate_issuance_config"] = inline_certificate_issuance_config
        __props__.__dict__["inline_trust_config"] = inline_trust_config
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["state"] = state
        __props__.__dict__["workload_identity_pool_id"] = workload_identity_pool_id
        return WorkloadIdentityPool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the pool. Cannot exceed 256 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the pool is disabled. You cannot use a disabled pool to exchange tokens, or use
        existing tokens to access resources. If the pool is re-enabled, existing tokens grant
        access again.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A display name for the pool. Cannot exceed 32 characters.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="inlineCertificateIssuanceConfig")
    def inline_certificate_issuance_config(self) -> pulumi.Output[Optional['outputs.WorkloadIdentityPoolInlineCertificateIssuanceConfig']]:
        """
        Represents configuration for generating mutual TLS (mTLS) certificates for the identities
        within this pool. Defines the Certificate Authority (CA) pool resources and configurations
        required for issuance and rotation of mTLS workload certificates.
        Structure is documented below.
        """
        return pulumi.get(self, "inline_certificate_issuance_config")

    @_builtins.property
    @pulumi.getter(name="inlineTrustConfig")
    def inline_trust_config(self) -> pulumi.Output[Optional['outputs.WorkloadIdentityPoolInlineTrustConfig']]:
        """
        Represents config to add additional trusted trust domains. Defines configuration for extending
        trust to additional trust domains. By establishing trust with another domain, the current
        domain will recognize and accept certificates issued by entities within the trusted domains.
        Note that a trust domain automatically trusts itself, eliminating the need for explicit
        configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "inline_trust_config")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The mode for the pool is operating in. Pools with an unspecified mode will operate as if they
        are in `FEDERATION_ONLY` mode.

        > **Note** This field cannot be changed after the Workload Identity Pool is created. While
        `pulumi preview` may show an update if you change this field's value, `pulumi up`
        **will fail with an API error** (such as `Error 400: Attempted to update an immutable field.`).
        To specify a different `mode`, please create a new Workload Identity Pool resource.
        * `FEDERATION_ONLY`: Pools can only be used for federating external workload identities into
        Google Cloud. Unless otherwise noted, no structure or format constraints are applied to
        workload identities in a `FEDERATION_ONLY` mode pool, and you may not create any resources
        within the pool besides providers.
        * `TRUST_DOMAIN`: Pools can be used to assign identities to Google Cloud workloads. All
        identities within a `TRUST_DOMAIN` mode pool must consist of a single namespace and individual
        workload identifier. The subject identifier for all identities must conform to the following
        format: `ns/<namespace>/sa/<workload_identifier>`.
        `iam.WorkloadIdentityPoolProvider`s cannot be created within `TRUST_DOMAIN`
        mode pools.
        Possible values are: `FEDERATION_ONLY`, `TRUST_DOMAIN`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the pool as
        `projects/{project_number}/locations/global/workloadIdentityPools/{workload_identity_pool_id}`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the pool.
        * `STATE_UNSPECIFIED`: State unspecified.
        * `ACTIVE`: The pool is active, and may be used in Google Cloud policies.
        * `DELETED`: The pool is soft-deleted. Soft-deleted pools are permanently deleted after
        approximately 30 days. You can restore a soft-deleted pool using
        `UndeleteWorkloadIdentityPool`. You cannot reuse the ID of a soft-deleted pool until it is
        permanently deleted. While a pool is deleted, you cannot use it to exchange tokens, or
        use existing tokens to access resources. If the pool is undeleted, existing tokens grant
        access again.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="workloadIdentityPoolId")
    def workload_identity_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID to use for the pool, which becomes the final component of the resource name. This
        value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
        `gcp-` is reserved for use by Google, and may not be specified.
        """
        return pulumi.get(self, "workload_identity_pool_id")

