# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ClientArgs', 'Client']

@pulumi.input_type
class ClientArgs:
    def __init__(__self__, *,
                 brand: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a Client resource.
        :param pulumi.Input[_builtins.str] brand: Identifier of the brand to which this client
               is attached to. The format is
               `projects/{project_number}/brands/{brand_id}`.
        :param pulumi.Input[_builtins.str] display_name: Human-friendly name given to the OAuth client.
        """
        pulumi.set(__self__, "brand", brand)
        pulumi.set(__self__, "display_name", display_name)

    @_builtins.property
    @pulumi.getter
    def brand(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the brand to which this client
        is attached to. The format is
        `projects/{project_number}/brands/{brand_id}`.
        """
        return pulumi.get(self, "brand")

    @brand.setter
    def brand(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "brand", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Human-friendly name given to the OAuth client.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class _ClientState:
    def __init__(__self__, *,
                 brand: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Client resources.
        :param pulumi.Input[_builtins.str] brand: Identifier of the brand to which this client
               is attached to. The format is
               `projects/{project_number}/brands/{brand_id}`.
        :param pulumi.Input[_builtins.str] client_id: Output only. Unique identifier of the OAuth client.
        :param pulumi.Input[_builtins.str] display_name: Human-friendly name given to the OAuth client.
        :param pulumi.Input[_builtins.str] secret: Output only. Client secret of the OAuth client.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        if brand is not None:
            pulumi.set(__self__, "brand", brand)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @_builtins.property
    @pulumi.getter
    def brand(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the brand to which this client
        is attached to. The format is
        `projects/{project_number}/brands/{brand_id}`.
        """
        return pulumi.get(self, "brand")

    @brand.setter
    def brand(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "brand", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Unique identifier of the OAuth client.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-friendly name given to the OAuth client.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Client secret of the OAuth client.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret", value)


@pulumi.type_token("gcp:iap/client:Client")
class Client(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 brand: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Iap Client

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="my-project",
            name="my-project",
            org_id="123456789",
            deletion_policy="DELETE")
        project_service = gcp.projects.Service("project_service",
            project=project.project_id,
            service="iap.googleapis.com")
        project_brand = gcp.iap.Brand("project_brand",
            support_email="support@example.com",
            application_title="Cloud IAP protected Application",
            project=project_service.project)
        project_client = gcp.iap.Client("project_client",
            display_name="Test Client",
            brand=project_brand.name)
        ```

        ## Import

        Client can be imported using any of these accepted formats:

        * `{{brand}}/identityAwareProxyClients/{{client_id}}`

        * `{{brand}}/{{client_id}}`

        When using the `pulumi import` command, Client can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iap/client:Client default {{brand}}/identityAwareProxyClients/{{client_id}}
        ```

        ```sh
        $ pulumi import gcp:iap/client:Client default {{brand}}/{{client_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] brand: Identifier of the brand to which this client
               is attached to. The format is
               `projects/{project_number}/brands/{brand_id}`.
        :param pulumi.Input[_builtins.str] display_name: Human-friendly name given to the OAuth client.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClientArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Iap Client

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="my-project",
            name="my-project",
            org_id="123456789",
            deletion_policy="DELETE")
        project_service = gcp.projects.Service("project_service",
            project=project.project_id,
            service="iap.googleapis.com")
        project_brand = gcp.iap.Brand("project_brand",
            support_email="support@example.com",
            application_title="Cloud IAP protected Application",
            project=project_service.project)
        project_client = gcp.iap.Client("project_client",
            display_name="Test Client",
            brand=project_brand.name)
        ```

        ## Import

        Client can be imported using any of these accepted formats:

        * `{{brand}}/identityAwareProxyClients/{{client_id}}`

        * `{{brand}}/{{client_id}}`

        When using the `pulumi import` command, Client can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:iap/client:Client default {{brand}}/identityAwareProxyClients/{{client_id}}
        ```

        ```sh
        $ pulumi import gcp:iap/client:Client default {{brand}}/{{client_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ClientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 brand: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClientArgs.__new__(ClientArgs)

            if brand is None and not opts.urn:
                raise TypeError("Missing required property 'brand'")
            __props__.__dict__["brand"] = brand
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["client_id"] = None
            __props__.__dict__["secret"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Client, __self__).__init__(
            'gcp:iap/client:Client',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            brand: Optional[pulumi.Input[_builtins.str]] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            secret: Optional[pulumi.Input[_builtins.str]] = None) -> 'Client':
        """
        Get an existing Client resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] brand: Identifier of the brand to which this client
               is attached to. The format is
               `projects/{project_number}/brands/{brand_id}`.
        :param pulumi.Input[_builtins.str] client_id: Output only. Unique identifier of the OAuth client.
        :param pulumi.Input[_builtins.str] display_name: Human-friendly name given to the OAuth client.
        :param pulumi.Input[_builtins.str] secret: Output only. Client secret of the OAuth client.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClientState.__new__(_ClientState)

        __props__.__dict__["brand"] = brand
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["secret"] = secret
        return Client(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def brand(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the brand to which this client
        is attached to. The format is
        `projects/{project_number}/brands/{brand_id}`.
        """
        return pulumi.get(self, "brand")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Unique identifier of the OAuth client.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Human-friendly name given to the OAuth client.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Client secret of the OAuth client.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "secret")

