# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CryptoKeyVersionArgs', 'CryptoKeyVersion']

@pulumi.input_type
class CryptoKeyVersionArgs:
    def __init__(__self__, *,
                 crypto_key: pulumi.Input[_builtins.str],
                 external_protection_level_options: Optional[pulumi.Input['CryptoKeyVersionExternalProtectionLevelOptionsArgs']] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CryptoKeyVersion resource.
        :param pulumi.Input[_builtins.str] crypto_key: The name of the cryptoKey associated with the CryptoKeyVersions.
               Format: `'projects/{{project}}/locations/{{location}}/keyRings/{{keyring}}/cryptoKeys/{{cryptoKey}}'`
        :param pulumi.Input['CryptoKeyVersionExternalProtectionLevelOptionsArgs'] external_protection_level_options: ExternalProtectionLevelOptions stores a group of additional fields for configuring a CryptoKeyVersion that are specific to the EXTERNAL protection level and EXTERNAL_VPC protection levels.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: The current state of the CryptoKeyVersion. Note: you can only specify this field to manually `ENABLE` or `DISABLE` the CryptoKeyVersion,
               otherwise the value of this field is always retrieved automatically.
               Possible values are: `PENDING_GENERATION`, `ENABLED`, `DISABLED`, `DESTROYED`, `DESTROY_SCHEDULED`, `PENDING_IMPORT`, `IMPORT_FAILED`.
        """
        pulumi.set(__self__, "crypto_key", crypto_key)
        if external_protection_level_options is not None:
            pulumi.set(__self__, "external_protection_level_options", external_protection_level_options)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="cryptoKey")
    def crypto_key(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the cryptoKey associated with the CryptoKeyVersions.
        Format: `'projects/{{project}}/locations/{{location}}/keyRings/{{keyring}}/cryptoKeys/{{cryptoKey}}'`
        """
        return pulumi.get(self, "crypto_key")

    @crypto_key.setter
    def crypto_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "crypto_key", value)

    @_builtins.property
    @pulumi.getter(name="externalProtectionLevelOptions")
    def external_protection_level_options(self) -> Optional[pulumi.Input['CryptoKeyVersionExternalProtectionLevelOptionsArgs']]:
        """
        ExternalProtectionLevelOptions stores a group of additional fields for configuring a CryptoKeyVersion that are specific to the EXTERNAL protection level and EXTERNAL_VPC protection levels.
        Structure is documented below.
        """
        return pulumi.get(self, "external_protection_level_options")

    @external_protection_level_options.setter
    def external_protection_level_options(self, value: Optional[pulumi.Input['CryptoKeyVersionExternalProtectionLevelOptionsArgs']]):
        pulumi.set(self, "external_protection_level_options", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the CryptoKeyVersion. Note: you can only specify this field to manually `ENABLE` or `DISABLE` the CryptoKeyVersion,
        otherwise the value of this field is always retrieved automatically.
        Possible values are: `PENDING_GENERATION`, `ENABLED`, `DISABLED`, `DESTROYED`, `DESTROY_SCHEDULED`, `PENDING_IMPORT`, `IMPORT_FAILED`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _CryptoKeyVersionState:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 attestations: Optional[pulumi.Input[Sequence[pulumi.Input['CryptoKeyVersionAttestationArgs']]]] = None,
                 crypto_key: Optional[pulumi.Input[_builtins.str]] = None,
                 external_protection_level_options: Optional[pulumi.Input['CryptoKeyVersionExternalProtectionLevelOptionsArgs']] = None,
                 generate_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protection_level: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CryptoKeyVersion resources.
        :param pulumi.Input[_builtins.str] algorithm: The CryptoKeyVersionAlgorithm that this CryptoKeyVersion supports.
        :param pulumi.Input[Sequence[pulumi.Input['CryptoKeyVersionAttestationArgs']]] attestations: Statement that was generated and signed by the HSM at key creation time. Use this statement to verify attributes of the key as stored on the HSM, independently of Google.
               Only provided for key versions with protectionLevel HSM.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] crypto_key: The name of the cryptoKey associated with the CryptoKeyVersions.
               Format: `'projects/{{project}}/locations/{{location}}/keyRings/{{keyring}}/cryptoKeys/{{cryptoKey}}'`
        :param pulumi.Input['CryptoKeyVersionExternalProtectionLevelOptionsArgs'] external_protection_level_options: ExternalProtectionLevelOptions stores a group of additional fields for configuring a CryptoKeyVersion that are specific to the EXTERNAL protection level and EXTERNAL_VPC protection levels.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] generate_time: The time this CryptoKeyVersion key material was generated
        :param pulumi.Input[_builtins.str] name: The resource name for this CryptoKeyVersion.
        :param pulumi.Input[_builtins.str] protection_level: The ProtectionLevel describing how crypto operations are performed with this CryptoKeyVersion.
        :param pulumi.Input[_builtins.str] state: The current state of the CryptoKeyVersion. Note: you can only specify this field to manually `ENABLE` or `DISABLE` the CryptoKeyVersion,
               otherwise the value of this field is always retrieved automatically.
               Possible values are: `PENDING_GENERATION`, `ENABLED`, `DISABLED`, `DESTROYED`, `DESTROY_SCHEDULED`, `PENDING_IMPORT`, `IMPORT_FAILED`.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if attestations is not None:
            pulumi.set(__self__, "attestations", attestations)
        if crypto_key is not None:
            pulumi.set(__self__, "crypto_key", crypto_key)
        if external_protection_level_options is not None:
            pulumi.set(__self__, "external_protection_level_options", external_protection_level_options)
        if generate_time is not None:
            pulumi.set(__self__, "generate_time", generate_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protection_level is not None:
            pulumi.set(__self__, "protection_level", protection_level)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CryptoKeyVersionAlgorithm that this CryptoKeyVersion supports.
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "algorithm", value)

    @_builtins.property
    @pulumi.getter
    def attestations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CryptoKeyVersionAttestationArgs']]]]:
        """
        Statement that was generated and signed by the HSM at key creation time. Use this statement to verify attributes of the key as stored on the HSM, independently of Google.
        Only provided for key versions with protectionLevel HSM.
        Structure is documented below.
        """
        return pulumi.get(self, "attestations")

    @attestations.setter
    def attestations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CryptoKeyVersionAttestationArgs']]]]):
        pulumi.set(self, "attestations", value)

    @_builtins.property
    @pulumi.getter(name="cryptoKey")
    def crypto_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the cryptoKey associated with the CryptoKeyVersions.
        Format: `'projects/{{project}}/locations/{{location}}/keyRings/{{keyring}}/cryptoKeys/{{cryptoKey}}'`
        """
        return pulumi.get(self, "crypto_key")

    @crypto_key.setter
    def crypto_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "crypto_key", value)

    @_builtins.property
    @pulumi.getter(name="externalProtectionLevelOptions")
    def external_protection_level_options(self) -> Optional[pulumi.Input['CryptoKeyVersionExternalProtectionLevelOptionsArgs']]:
        """
        ExternalProtectionLevelOptions stores a group of additional fields for configuring a CryptoKeyVersion that are specific to the EXTERNAL protection level and EXTERNAL_VPC protection levels.
        Structure is documented below.
        """
        return pulumi.get(self, "external_protection_level_options")

    @external_protection_level_options.setter
    def external_protection_level_options(self, value: Optional[pulumi.Input['CryptoKeyVersionExternalProtectionLevelOptionsArgs']]):
        pulumi.set(self, "external_protection_level_options", value)

    @_builtins.property
    @pulumi.getter(name="generateTime")
    def generate_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time this CryptoKeyVersion key material was generated
        """
        return pulumi.get(self, "generate_time")

    @generate_time.setter
    def generate_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "generate_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name for this CryptoKeyVersion.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="protectionLevel")
    def protection_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ProtectionLevel describing how crypto operations are performed with this CryptoKeyVersion.
        """
        return pulumi.get(self, "protection_level")

    @protection_level.setter
    def protection_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protection_level", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the CryptoKeyVersion. Note: you can only specify this field to manually `ENABLE` or `DISABLE` the CryptoKeyVersion,
        otherwise the value of this field is always retrieved automatically.
        Possible values are: `PENDING_GENERATION`, `ENABLED`, `DISABLED`, `DESTROYED`, `DESTROY_SCHEDULED`, `PENDING_IMPORT`, `IMPORT_FAILED`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("gcp:kms/cryptoKeyVersion:CryptoKeyVersion")
class CryptoKeyVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crypto_key: Optional[pulumi.Input[_builtins.str]] = None,
                 external_protection_level_options: Optional[pulumi.Input[Union['CryptoKeyVersionExternalProtectionLevelOptionsArgs', 'CryptoKeyVersionExternalProtectionLevelOptionsArgsDict']]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A `CryptoKeyVersion` represents an individual cryptographic key, and the associated key material.

        Destroying a cryptoKeyVersion will not delete the resource from the project.

        To get more information about CryptoKeyVersion, see:

        * [API documentation](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions)
        * How-to Guides
            * [Creating a key Version](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions/create)

        ## Example Usage

        ### Kms Crypto Key Version Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        keyring = gcp.kms.KeyRing("keyring",
            name="keyring-example",
            location="global")
        cryptokey = gcp.kms.CryptoKey("cryptokey",
            name="crypto-key-example",
            key_ring=keyring.id,
            rotation_period="7776000s")
        example_key = gcp.kms.CryptoKeyVersion("example-key", crypto_key=cryptokey.id)
        ```

        ## Import

        CryptoKeyVersion can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, CryptoKeyVersion can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:kms/cryptoKeyVersion:CryptoKeyVersion default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] crypto_key: The name of the cryptoKey associated with the CryptoKeyVersions.
               Format: `'projects/{{project}}/locations/{{location}}/keyRings/{{keyring}}/cryptoKeys/{{cryptoKey}}'`
        :param pulumi.Input[Union['CryptoKeyVersionExternalProtectionLevelOptionsArgs', 'CryptoKeyVersionExternalProtectionLevelOptionsArgsDict']] external_protection_level_options: ExternalProtectionLevelOptions stores a group of additional fields for configuring a CryptoKeyVersion that are specific to the EXTERNAL protection level and EXTERNAL_VPC protection levels.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] state: The current state of the CryptoKeyVersion. Note: you can only specify this field to manually `ENABLE` or `DISABLE` the CryptoKeyVersion,
               otherwise the value of this field is always retrieved automatically.
               Possible values are: `PENDING_GENERATION`, `ENABLED`, `DISABLED`, `DESTROYED`, `DESTROY_SCHEDULED`, `PENDING_IMPORT`, `IMPORT_FAILED`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CryptoKeyVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A `CryptoKeyVersion` represents an individual cryptographic key, and the associated key material.

        Destroying a cryptoKeyVersion will not delete the resource from the project.

        To get more information about CryptoKeyVersion, see:

        * [API documentation](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions)
        * How-to Guides
            * [Creating a key Version](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions/create)

        ## Example Usage

        ### Kms Crypto Key Version Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        keyring = gcp.kms.KeyRing("keyring",
            name="keyring-example",
            location="global")
        cryptokey = gcp.kms.CryptoKey("cryptokey",
            name="crypto-key-example",
            key_ring=keyring.id,
            rotation_period="7776000s")
        example_key = gcp.kms.CryptoKeyVersion("example-key", crypto_key=cryptokey.id)
        ```

        ## Import

        CryptoKeyVersion can be imported using any of these accepted formats:

        * `{{name}}`

        When using the `pulumi import` command, CryptoKeyVersion can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:kms/cryptoKeyVersion:CryptoKeyVersion default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CryptoKeyVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CryptoKeyVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crypto_key: Optional[pulumi.Input[_builtins.str]] = None,
                 external_protection_level_options: Optional[pulumi.Input[Union['CryptoKeyVersionExternalProtectionLevelOptionsArgs', 'CryptoKeyVersionExternalProtectionLevelOptionsArgsDict']]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CryptoKeyVersionArgs.__new__(CryptoKeyVersionArgs)

            if crypto_key is None and not opts.urn:
                raise TypeError("Missing required property 'crypto_key'")
            __props__.__dict__["crypto_key"] = crypto_key
            __props__.__dict__["external_protection_level_options"] = external_protection_level_options
            __props__.__dict__["state"] = state
            __props__.__dict__["algorithm"] = None
            __props__.__dict__["attestations"] = None
            __props__.__dict__["generate_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["protection_level"] = None
        super(CryptoKeyVersion, __self__).__init__(
            'gcp:kms/cryptoKeyVersion:CryptoKeyVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            attestations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CryptoKeyVersionAttestationArgs', 'CryptoKeyVersionAttestationArgsDict']]]]] = None,
            crypto_key: Optional[pulumi.Input[_builtins.str]] = None,
            external_protection_level_options: Optional[pulumi.Input[Union['CryptoKeyVersionExternalProtectionLevelOptionsArgs', 'CryptoKeyVersionExternalProtectionLevelOptionsArgsDict']]] = None,
            generate_time: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            protection_level: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'CryptoKeyVersion':
        """
        Get an existing CryptoKeyVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] algorithm: The CryptoKeyVersionAlgorithm that this CryptoKeyVersion supports.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CryptoKeyVersionAttestationArgs', 'CryptoKeyVersionAttestationArgsDict']]]] attestations: Statement that was generated and signed by the HSM at key creation time. Use this statement to verify attributes of the key as stored on the HSM, independently of Google.
               Only provided for key versions with protectionLevel HSM.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] crypto_key: The name of the cryptoKey associated with the CryptoKeyVersions.
               Format: `'projects/{{project}}/locations/{{location}}/keyRings/{{keyring}}/cryptoKeys/{{cryptoKey}}'`
        :param pulumi.Input[Union['CryptoKeyVersionExternalProtectionLevelOptionsArgs', 'CryptoKeyVersionExternalProtectionLevelOptionsArgsDict']] external_protection_level_options: ExternalProtectionLevelOptions stores a group of additional fields for configuring a CryptoKeyVersion that are specific to the EXTERNAL protection level and EXTERNAL_VPC protection levels.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] generate_time: The time this CryptoKeyVersion key material was generated
        :param pulumi.Input[_builtins.str] name: The resource name for this CryptoKeyVersion.
        :param pulumi.Input[_builtins.str] protection_level: The ProtectionLevel describing how crypto operations are performed with this CryptoKeyVersion.
        :param pulumi.Input[_builtins.str] state: The current state of the CryptoKeyVersion. Note: you can only specify this field to manually `ENABLE` or `DISABLE` the CryptoKeyVersion,
               otherwise the value of this field is always retrieved automatically.
               Possible values are: `PENDING_GENERATION`, `ENABLED`, `DISABLED`, `DESTROYED`, `DESTROY_SCHEDULED`, `PENDING_IMPORT`, `IMPORT_FAILED`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CryptoKeyVersionState.__new__(_CryptoKeyVersionState)

        __props__.__dict__["algorithm"] = algorithm
        __props__.__dict__["attestations"] = attestations
        __props__.__dict__["crypto_key"] = crypto_key
        __props__.__dict__["external_protection_level_options"] = external_protection_level_options
        __props__.__dict__["generate_time"] = generate_time
        __props__.__dict__["name"] = name
        __props__.__dict__["protection_level"] = protection_level
        __props__.__dict__["state"] = state
        return CryptoKeyVersion(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        The CryptoKeyVersionAlgorithm that this CryptoKeyVersion supports.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def attestations(self) -> pulumi.Output[Sequence['outputs.CryptoKeyVersionAttestation']]:
        """
        Statement that was generated and signed by the HSM at key creation time. Use this statement to verify attributes of the key as stored on the HSM, independently of Google.
        Only provided for key versions with protectionLevel HSM.
        Structure is documented below.
        """
        return pulumi.get(self, "attestations")

    @_builtins.property
    @pulumi.getter(name="cryptoKey")
    def crypto_key(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the cryptoKey associated with the CryptoKeyVersions.
        Format: `'projects/{{project}}/locations/{{location}}/keyRings/{{keyring}}/cryptoKeys/{{cryptoKey}}'`
        """
        return pulumi.get(self, "crypto_key")

    @_builtins.property
    @pulumi.getter(name="externalProtectionLevelOptions")
    def external_protection_level_options(self) -> pulumi.Output[Optional['outputs.CryptoKeyVersionExternalProtectionLevelOptions']]:
        """
        ExternalProtectionLevelOptions stores a group of additional fields for configuring a CryptoKeyVersion that are specific to the EXTERNAL protection level and EXTERNAL_VPC protection levels.
        Structure is documented below.
        """
        return pulumi.get(self, "external_protection_level_options")

    @_builtins.property
    @pulumi.getter(name="generateTime")
    def generate_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time this CryptoKeyVersion key material was generated
        """
        return pulumi.get(self, "generate_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name for this CryptoKeyVersion.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="protectionLevel")
    def protection_level(self) -> pulumi.Output[_builtins.str]:
        """
        The ProtectionLevel describing how crypto operations are performed with this CryptoKeyVersion.
        """
        return pulumi.get(self, "protection_level")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the CryptoKeyVersion. Note: you can only specify this field to manually `ENABLE` or `DISABLE` the CryptoKeyVersion,
        otherwise the value of this field is always retrieved automatically.
        Possible values are: `PENDING_GENERATION`, `ENABLED`, `DISABLED`, `DESTROYED`, `DESTROY_SCHEDULED`, `PENDING_IMPORT`, `IMPORT_FAILED`.
        """
        return pulumi.get(self, "state")

