# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCryptoKeyVersionsResult',
    'AwaitableGetCryptoKeyVersionsResult',
    'get_crypto_key_versions',
    'get_crypto_key_versions_output',
]

@pulumi.output_type
class GetCryptoKeyVersionsResult:
    """
    A collection of values returned by getCryptoKeyVersions.
    """
    def __init__(__self__, crypto_key=None, filter=None, id=None, public_keys=None, versions=None):
        if crypto_key and not isinstance(crypto_key, str):
            raise TypeError("Expected argument 'crypto_key' to be a str")
        pulumi.set(__self__, "crypto_key", crypto_key)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if public_keys and not isinstance(public_keys, list):
            raise TypeError("Expected argument 'public_keys' to be a list")
        pulumi.set(__self__, "public_keys", public_keys)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="cryptoKey")
    def crypto_key(self) -> _builtins.str:
        return pulumi.get(self, "crypto_key")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Sequence['outputs.GetCryptoKeyVersionsPublicKeyResult']:
        return pulumi.get(self, "public_keys")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetCryptoKeyVersionsVersionResult']:
        """
        A list of all the retrieved crypto key versions from the provided crypto key. This list is influenced by the provided filter argument.
        """
        return pulumi.get(self, "versions")


class AwaitableGetCryptoKeyVersionsResult(GetCryptoKeyVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCryptoKeyVersionsResult(
            crypto_key=self.crypto_key,
            filter=self.filter,
            id=self.id,
            public_keys=self.public_keys,
            versions=self.versions)


def get_crypto_key_versions(crypto_key: Optional[_builtins.str] = None,
                            filter: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCryptoKeyVersionsResult:
    """
    Provides access to Google Cloud Platform KMS CryptoKeyVersions. For more information see
    [the official documentation](https://cloud.google.com/kms/docs/object-hierarchy#key_version)
    and
    [API](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_key_ring = gcp.kms.get_kms_key_ring(name="my-key-ring",
        location="us-central1")
    my_crypto_key = gcp.kms.get_kms_crypto_key(name="my-crypto-key",
        key_ring=my_key_ring.id)
    my_crypto_key_versions = gcp.kms.get_crypto_key_versions(crypto_key=my_key["id"])
    ```


    :param _builtins.str crypto_key: The `id` of the Google Cloud Platform CryptoKey to which the key version belongs. This is also the `id` field of the 
           `kms.CryptoKey` resource/datasource.
    :param _builtins.str filter: The filter argument is used to add a filter query parameter that limits which versions are retrieved by the data source: ?filter={{filter}}. When no value is provided there is no filtering.
           
           Example filter values if filtering on name. Note: names take the form projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}/cryptoKeys/{{cryptoKey}}/cryptoKeyVersions.
           
           * `"name:my-key-"` will retrieve cryptoKeyVersions that contain "my-key-" anywhere in their name.
           * `"name=projects/my-project/locations/global/keyRings/my-key-ring/cryptoKeys/my-key-1/cryptoKeyVersions/my-version-1"` will only retrieve a key with that exact name.
           
           [See the documentation about using filters](https://cloud.google.com/kms/docs/sorting-and-filtering)
    """
    __args__ = dict()
    __args__['cryptoKey'] = crypto_key
    __args__['filter'] = filter
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:kms/getCryptoKeyVersions:getCryptoKeyVersions', __args__, opts=opts, typ=GetCryptoKeyVersionsResult).value

    return AwaitableGetCryptoKeyVersionsResult(
        crypto_key=pulumi.get(__ret__, 'crypto_key'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        public_keys=pulumi.get(__ret__, 'public_keys'),
        versions=pulumi.get(__ret__, 'versions'))
def get_crypto_key_versions_output(crypto_key: Optional[pulumi.Input[_builtins.str]] = None,
                                   filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCryptoKeyVersionsResult]:
    """
    Provides access to Google Cloud Platform KMS CryptoKeyVersions. For more information see
    [the official documentation](https://cloud.google.com/kms/docs/object-hierarchy#key_version)
    and
    [API](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_key_ring = gcp.kms.get_kms_key_ring(name="my-key-ring",
        location="us-central1")
    my_crypto_key = gcp.kms.get_kms_crypto_key(name="my-crypto-key",
        key_ring=my_key_ring.id)
    my_crypto_key_versions = gcp.kms.get_crypto_key_versions(crypto_key=my_key["id"])
    ```


    :param _builtins.str crypto_key: The `id` of the Google Cloud Platform CryptoKey to which the key version belongs. This is also the `id` field of the 
           `kms.CryptoKey` resource/datasource.
    :param _builtins.str filter: The filter argument is used to add a filter query parameter that limits which versions are retrieved by the data source: ?filter={{filter}}. When no value is provided there is no filtering.
           
           Example filter values if filtering on name. Note: names take the form projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}/cryptoKeys/{{cryptoKey}}/cryptoKeyVersions.
           
           * `"name:my-key-"` will retrieve cryptoKeyVersions that contain "my-key-" anywhere in their name.
           * `"name=projects/my-project/locations/global/keyRings/my-key-ring/cryptoKeys/my-key-1/cryptoKeyVersions/my-version-1"` will only retrieve a key with that exact name.
           
           [See the documentation about using filters](https://cloud.google.com/kms/docs/sorting-and-filtering)
    """
    __args__ = dict()
    __args__['cryptoKey'] = crypto_key
    __args__['filter'] = filter
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:kms/getCryptoKeyVersions:getCryptoKeyVersions', __args__, opts=opts, typ=GetCryptoKeyVersionsResult)
    return __ret__.apply(lambda __response__: GetCryptoKeyVersionsResult(
        crypto_key=pulumi.get(__response__, 'crypto_key'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        public_keys=pulumi.get(__response__, 'public_keys'),
        versions=pulumi.get(__response__, 'versions')))
