# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['KeyHandleArgs', 'KeyHandle']

@pulumi.input_type
class KeyHandleArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 resource_type_selector: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a KeyHandle resource.
        :param pulumi.Input[_builtins.str] location: The location for the KeyHandle.
               A full list of valid locations can be found by running `gcloud kms locations list`.
        :param pulumi.Input[_builtins.str] resource_type_selector: Selector of the resource type where we want to protect resources.
               For example, `storage.googleapis.com/Bucket`.
        :param pulumi.Input[_builtins.str] name: The resource name for the KeyHandle.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "resource_type_selector", resource_type_selector)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location for the KeyHandle.
        A full list of valid locations can be found by running `gcloud kms locations list`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypeSelector")
    def resource_type_selector(self) -> pulumi.Input[_builtins.str]:
        """
        Selector of the resource type where we want to protect resources.
        For example, `storage.googleapis.com/Bucket`.
        """
        return pulumi.get(self, "resource_type_selector")

    @resource_type_selector.setter
    def resource_type_selector(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_type_selector", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name for the KeyHandle.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _KeyHandleState:
    def __init__(__self__, *,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type_selector: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KeyHandle resources.
        :param pulumi.Input[_builtins.str] kms_key: A reference to a Cloud KMS CryptoKey that can be used for CMEK in the requested
               product/project/location, for example
               `projects/1/locations/us-east1/keyRings/foo/cryptoKeys/bar-ffffff`
        :param pulumi.Input[_builtins.str] location: The location for the KeyHandle.
               A full list of valid locations can be found by running `gcloud kms locations list`.
        :param pulumi.Input[_builtins.str] name: The resource name for the KeyHandle.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] resource_type_selector: Selector of the resource type where we want to protect resources.
               For example, `storage.googleapis.com/Bucket`.
        """
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if resource_type_selector is not None:
            pulumi.set(__self__, "resource_type_selector", resource_type_selector)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A reference to a Cloud KMS CryptoKey that can be used for CMEK in the requested
        product/project/location, for example
        `projects/1/locations/us-east1/keyRings/foo/cryptoKeys/bar-ffffff`
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location for the KeyHandle.
        A full list of valid locations can be found by running `gcloud kms locations list`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name for the KeyHandle.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypeSelector")
    def resource_type_selector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Selector of the resource type where we want to protect resources.
        For example, `storage.googleapis.com/Bucket`.
        """
        return pulumi.get(self, "resource_type_selector")

    @resource_type_selector.setter
    def resource_type_selector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type_selector", value)


@pulumi.type_token("gcp:kms/keyHandle:KeyHandle")
class KeyHandle(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type_selector: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Kms Key Handle Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        # Create Folder in GCP Organization
        autokms_folder = gcp.organizations.Folder("autokms_folder",
            display_name="my-folder",
            parent="organizations/123456789",
            deletion_protection=False)
        # Create the key project
        key_project = gcp.organizations.Project("key_project",
            project_id="key-proj",
            name="key-proj",
            folder_id=autokms_folder.folder_id,
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE",
            opts = pulumi.ResourceOptions(depends_on=[autokms_folder]))
        # Create the resource project
        resource_project = gcp.organizations.Project("resource_project",
            project_id="res-proj",
            name="res-proj",
            folder_id=autokms_folder.folder_id,
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE",
            opts = pulumi.ResourceOptions(depends_on=[autokms_folder]))
        # Enable the Cloud KMS API
        kms_api_service = gcp.projects.Service("kms_api_service",
            service="cloudkms.googleapis.com",
            project=key_project.project_id,
            disable_on_destroy=False,
            disable_dependent_services=True,
            opts = pulumi.ResourceOptions(depends_on=[key_project]))
        # Wait delay after enabling APIs
        wait_enable_service_api = time.index.Sleep("wait_enable_service_api", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[kms_api_service]))
        #Create KMS Service Agent
        kms_service_agent = gcp.projects.ServiceIdentity("kms_service_agent",
            service="cloudkms.googleapis.com",
            project=key_project.number,
            opts = pulumi.ResourceOptions(depends_on=[wait_enable_service_api]))
        # Wait delay after creating service agent.
        wait_service_agent = time.index.Sleep("wait_service_agent", create_duration=10s,
        opts = pulumi.ResourceOptions(depends_on=[kms_service_agent]))
        #Grant the KMS Service Agent the Cloud KMS Admin role
        autokey_project_admin = gcp.projects.IAMMember("autokey_project_admin",
            project=key_project.project_id,
            role="roles/cloudkms.admin",
            member=key_project.number.apply(lambda number: f"serviceAccount:service-{number}@gcp-sa-cloudkms.iam.gserviceaccount.com"),
            opts = pulumi.ResourceOptions(depends_on=[wait_service_agent]))
        # Wait delay after granting IAM permissions
        wait_srv_acc_permissions = time.index.Sleep("wait_srv_acc_permissions", create_duration=10s,
        opts = pulumi.ResourceOptions(depends_on=[autokey_project_admin]))
        autokey_config = gcp.kms.AutokeyConfig("autokey_config",
            folder=autokms_folder.folder_id,
            key_project=key_project.project_id.apply(lambda project_id: f"projects/{project_id}"),
            opts = pulumi.ResourceOptions(depends_on=[wait_srv_acc_permissions]))
        # Wait delay for autokey config to take effect
        wait_autokey_config = time.index.Sleep("wait_autokey_config", create_duration=10s,
        opts = pulumi.ResourceOptions(depends_on=[autokey_config]))
        example_keyhandle = gcp.kms.KeyHandle("example-keyhandle",
            project=resource_project.project_id,
            name="tf-test-key-handle",
            location="global",
            resource_type_selector="storage.googleapis.com/Bucket",
            opts = pulumi.ResourceOptions(depends_on=[wait_autokey_config]))
        ```

        ## Import

        KeyHandle can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/keyHandles/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, KeyHandle can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:kms/keyHandle:KeyHandle default projects/{{project}}/locations/{{location}}/keyHandles/{{name}}
        ```

        ```sh
        $ pulumi import gcp:kms/keyHandle:KeyHandle default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:kms/keyHandle:KeyHandle default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] location: The location for the KeyHandle.
               A full list of valid locations can be found by running `gcloud kms locations list`.
        :param pulumi.Input[_builtins.str] name: The resource name for the KeyHandle.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] resource_type_selector: Selector of the resource type where we want to protect resources.
               For example, `storage.googleapis.com/Bucket`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyHandleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Kms Key Handle Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        # Create Folder in GCP Organization
        autokms_folder = gcp.organizations.Folder("autokms_folder",
            display_name="my-folder",
            parent="organizations/123456789",
            deletion_protection=False)
        # Create the key project
        key_project = gcp.organizations.Project("key_project",
            project_id="key-proj",
            name="key-proj",
            folder_id=autokms_folder.folder_id,
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE",
            opts = pulumi.ResourceOptions(depends_on=[autokms_folder]))
        # Create the resource project
        resource_project = gcp.organizations.Project("resource_project",
            project_id="res-proj",
            name="res-proj",
            folder_id=autokms_folder.folder_id,
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE",
            opts = pulumi.ResourceOptions(depends_on=[autokms_folder]))
        # Enable the Cloud KMS API
        kms_api_service = gcp.projects.Service("kms_api_service",
            service="cloudkms.googleapis.com",
            project=key_project.project_id,
            disable_on_destroy=False,
            disable_dependent_services=True,
            opts = pulumi.ResourceOptions(depends_on=[key_project]))
        # Wait delay after enabling APIs
        wait_enable_service_api = time.index.Sleep("wait_enable_service_api", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[kms_api_service]))
        #Create KMS Service Agent
        kms_service_agent = gcp.projects.ServiceIdentity("kms_service_agent",
            service="cloudkms.googleapis.com",
            project=key_project.number,
            opts = pulumi.ResourceOptions(depends_on=[wait_enable_service_api]))
        # Wait delay after creating service agent.
        wait_service_agent = time.index.Sleep("wait_service_agent", create_duration=10s,
        opts = pulumi.ResourceOptions(depends_on=[kms_service_agent]))
        #Grant the KMS Service Agent the Cloud KMS Admin role
        autokey_project_admin = gcp.projects.IAMMember("autokey_project_admin",
            project=key_project.project_id,
            role="roles/cloudkms.admin",
            member=key_project.number.apply(lambda number: f"serviceAccount:service-{number}@gcp-sa-cloudkms.iam.gserviceaccount.com"),
            opts = pulumi.ResourceOptions(depends_on=[wait_service_agent]))
        # Wait delay after granting IAM permissions
        wait_srv_acc_permissions = time.index.Sleep("wait_srv_acc_permissions", create_duration=10s,
        opts = pulumi.ResourceOptions(depends_on=[autokey_project_admin]))
        autokey_config = gcp.kms.AutokeyConfig("autokey_config",
            folder=autokms_folder.folder_id,
            key_project=key_project.project_id.apply(lambda project_id: f"projects/{project_id}"),
            opts = pulumi.ResourceOptions(depends_on=[wait_srv_acc_permissions]))
        # Wait delay for autokey config to take effect
        wait_autokey_config = time.index.Sleep("wait_autokey_config", create_duration=10s,
        opts = pulumi.ResourceOptions(depends_on=[autokey_config]))
        example_keyhandle = gcp.kms.KeyHandle("example-keyhandle",
            project=resource_project.project_id,
            name="tf-test-key-handle",
            location="global",
            resource_type_selector="storage.googleapis.com/Bucket",
            opts = pulumi.ResourceOptions(depends_on=[wait_autokey_config]))
        ```

        ## Import

        KeyHandle can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/keyHandles/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, KeyHandle can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:kms/keyHandle:KeyHandle default projects/{{project}}/locations/{{location}}/keyHandles/{{name}}
        ```

        ```sh
        $ pulumi import gcp:kms/keyHandle:KeyHandle default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:kms/keyHandle:KeyHandle default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param KeyHandleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyHandleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type_selector: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyHandleArgs.__new__(KeyHandleArgs)

            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if resource_type_selector is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type_selector'")
            __props__.__dict__["resource_type_selector"] = resource_type_selector
            __props__.__dict__["kms_key"] = None
        super(KeyHandle, __self__).__init__(
            'gcp:kms/keyHandle:KeyHandle',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            kms_key: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            resource_type_selector: Optional[pulumi.Input[_builtins.str]] = None) -> 'KeyHandle':
        """
        Get an existing KeyHandle resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] kms_key: A reference to a Cloud KMS CryptoKey that can be used for CMEK in the requested
               product/project/location, for example
               `projects/1/locations/us-east1/keyRings/foo/cryptoKeys/bar-ffffff`
        :param pulumi.Input[_builtins.str] location: The location for the KeyHandle.
               A full list of valid locations can be found by running `gcloud kms locations list`.
        :param pulumi.Input[_builtins.str] name: The resource name for the KeyHandle.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] resource_type_selector: Selector of the resource type where we want to protect resources.
               For example, `storage.googleapis.com/Bucket`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyHandleState.__new__(_KeyHandleState)

        __props__.__dict__["kms_key"] = kms_key
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["resource_type_selector"] = resource_type_selector
        return KeyHandle(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> pulumi.Output[_builtins.str]:
        """
        A reference to a Cloud KMS CryptoKey that can be used for CMEK in the requested
        product/project/location, for example
        `projects/1/locations/us-east1/keyRings/foo/cryptoKeys/bar-ffffff`
        """
        return pulumi.get(self, "kms_key")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location for the KeyHandle.
        A full list of valid locations can be found by running `gcloud kms locations list`.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name for the KeyHandle.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="resourceTypeSelector")
    def resource_type_selector(self) -> pulumi.Output[_builtins.str]:
        """
        Selector of the resource type where we want to protect resources.
        For example, `storage.googleapis.com/Bucket`.
        """
        return pulumi.get(self, "resource_type_selector")

