# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'BillingAccountBucketConfigCmekSettingsArgs',
    'BillingAccountBucketConfigCmekSettingsArgsDict',
    'BillingAccountBucketConfigIndexConfigArgs',
    'BillingAccountBucketConfigIndexConfigArgsDict',
    'BillingAccountSinkBigqueryOptionsArgs',
    'BillingAccountSinkBigqueryOptionsArgsDict',
    'BillingAccountSinkExclusionArgs',
    'BillingAccountSinkExclusionArgsDict',
    'FolderBucketConfigCmekSettingsArgs',
    'FolderBucketConfigCmekSettingsArgsDict',
    'FolderBucketConfigIndexConfigArgs',
    'FolderBucketConfigIndexConfigArgsDict',
    'FolderSinkBigqueryOptionsArgs',
    'FolderSinkBigqueryOptionsArgsDict',
    'FolderSinkExclusionArgs',
    'FolderSinkExclusionArgsDict',
    'LinkedDatasetBigqueryDatasetArgs',
    'LinkedDatasetBigqueryDatasetArgsDict',
    'LogViewIamBindingConditionArgs',
    'LogViewIamBindingConditionArgsDict',
    'LogViewIamMemberConditionArgs',
    'LogViewIamMemberConditionArgsDict',
    'MetricBucketOptionsArgs',
    'MetricBucketOptionsArgsDict',
    'MetricBucketOptionsExplicitBucketsArgs',
    'MetricBucketOptionsExplicitBucketsArgsDict',
    'MetricBucketOptionsExponentialBucketsArgs',
    'MetricBucketOptionsExponentialBucketsArgsDict',
    'MetricBucketOptionsLinearBucketsArgs',
    'MetricBucketOptionsLinearBucketsArgsDict',
    'MetricMetricDescriptorArgs',
    'MetricMetricDescriptorArgsDict',
    'MetricMetricDescriptorLabelArgs',
    'MetricMetricDescriptorLabelArgsDict',
    'OrganizationBucketConfigCmekSettingsArgs',
    'OrganizationBucketConfigCmekSettingsArgsDict',
    'OrganizationBucketConfigIndexConfigArgs',
    'OrganizationBucketConfigIndexConfigArgsDict',
    'OrganizationSinkBigqueryOptionsArgs',
    'OrganizationSinkBigqueryOptionsArgsDict',
    'OrganizationSinkExclusionArgs',
    'OrganizationSinkExclusionArgsDict',
    'ProjectBucketConfigCmekSettingsArgs',
    'ProjectBucketConfigCmekSettingsArgsDict',
    'ProjectBucketConfigIndexConfigArgs',
    'ProjectBucketConfigIndexConfigArgsDict',
    'ProjectSinkBigqueryOptionsArgs',
    'ProjectSinkBigqueryOptionsArgsDict',
    'ProjectSinkExclusionArgs',
    'ProjectSinkExclusionArgsDict',
]

MYPY = False

if not MYPY:
    class BillingAccountBucketConfigCmekSettingsArgsDict(TypedDict):
        kms_key_name: pulumi.Input[_builtins.str]
        """
        The resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
        To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
        The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        kms_key_version_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The CryptoKeyVersion resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]"
        For example:
        "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
        This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The resource name of the bucket. For example: "projects/my-project-id/locations/my-location/buckets/my-bucket-id"
        """
        service_account_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The service account associated with a project for which CMEK will apply.
        Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
elif False:
    BillingAccountBucketConfigCmekSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BillingAccountBucketConfigCmekSettingsArgs:
    def __init__(__self__, *,
                 kms_key_name: pulumi.Input[_builtins.str],
                 kms_key_version_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] kms_key_name: The resource name for the configured Cloud KMS key.
               KMS key name format:
               "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
               To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
               The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        :param pulumi.Input[_builtins.str] kms_key_version_name: The CryptoKeyVersion resource name for the configured Cloud KMS key.
               KMS key name format:
               "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]"
               For example:
               "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
               This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        :param pulumi.Input[_builtins.str] name: The resource name of the bucket. For example: "projects/my-project-id/locations/my-location/buckets/my-bucket-id"
        :param pulumi.Input[_builtins.str] service_account_id: The service account associated with a project for which CMEK will apply.
               Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_version_name is not None:
            pulumi.set(__self__, "kms_key_version_name", kms_key_version_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Input[_builtins.str]:
        """
        The resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
        To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
        The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kms_key_name", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersionName")
    def kms_key_version_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CryptoKeyVersion resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]"
        For example:
        "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
        This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        """
        return pulumi.get(self, "kms_key_version_name")

    @kms_key_version_name.setter
    def kms_key_version_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_version_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the bucket. For example: "projects/my-project-id/locations/my-location/buckets/my-bucket-id"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service account associated with a project for which CMEK will apply.
        Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)


if not MYPY:
    class BillingAccountBucketConfigIndexConfigArgsDict(TypedDict):
        field_path: pulumi.Input[_builtins.str]
        """
        The LogEntry field path to index.
        Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        """
        type: pulumi.Input[_builtins.str]
        """
        The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
elif False:
    BillingAccountBucketConfigIndexConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BillingAccountBucketConfigIndexConfigArgs:
    def __init__(__self__, *,
                 field_path: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] field_path: The LogEntry field path to index.
               Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        :param pulumi.Input[_builtins.str] type: The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
        pulumi.set(__self__, "field_path", field_path)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> pulumi.Input[_builtins.str]:
        """
        The LogEntry field path to index.
        Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        """
        return pulumi.get(self, "field_path")

    @field_path.setter
    def field_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "field_path", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class BillingAccountSinkBigqueryOptionsArgsDict(TypedDict):
        use_partitioned_tables: pulumi.Input[_builtins.bool]
        """
        Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
        By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
        tables, the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
        has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
elif False:
    BillingAccountSinkBigqueryOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BillingAccountSinkBigqueryOptionsArgs:
    def __init__(__self__, *,
                 use_partitioned_tables: pulumi.Input[_builtins.bool]):
        """
        :param pulumi.Input[_builtins.bool] use_partitioned_tables: Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
               By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
               tables, the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
               has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        pulumi.set(__self__, "use_partitioned_tables", use_partitioned_tables)

    @_builtins.property
    @pulumi.getter(name="usePartitionedTables")
    def use_partitioned_tables(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
        By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
        tables, the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
        has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        return pulumi.get(self, "use_partitioned_tables")

    @use_partitioned_tables.setter
    def use_partitioned_tables(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "use_partitioned_tables", value)


if not MYPY:
    class BillingAccountSinkExclusionArgsDict(TypedDict):
        filter: pulumi.Input[_builtins.str]
        """
        An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        name: pulumi.Input[_builtins.str]
        """
        A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        A description of this exclusion.
        """
        disabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
elif False:
    BillingAccountSinkExclusionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BillingAccountSinkExclusionArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] filter: An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param pulumi.Input[_builtins.str] name: A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        :param pulumi.Input[_builtins.str] description: A description of this exclusion.
        :param pulumi.Input[_builtins.bool] disabled: If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Input[_builtins.str]:
        """
        An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of this exclusion.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)


if not MYPY:
    class FolderBucketConfigCmekSettingsArgsDict(TypedDict):
        kms_key_name: pulumi.Input[_builtins.str]
        """
        The resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
        To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
        The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        kms_key_version_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The CryptoKeyVersion resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]"
        For example:
        "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
        This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The resource name of the bucket. For example: "folders/my-folder-id/locations/my-location/buckets/my-bucket-id"
        """
        service_account_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The service account associated with a project for which CMEK will apply.
        Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
elif False:
    FolderBucketConfigCmekSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FolderBucketConfigCmekSettingsArgs:
    def __init__(__self__, *,
                 kms_key_name: pulumi.Input[_builtins.str],
                 kms_key_version_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] kms_key_name: The resource name for the configured Cloud KMS key.
               KMS key name format:
               "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
               To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
               The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        :param pulumi.Input[_builtins.str] kms_key_version_name: The CryptoKeyVersion resource name for the configured Cloud KMS key.
               KMS key name format:
               "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]"
               For example:
               "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
               This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        :param pulumi.Input[_builtins.str] name: The resource name of the bucket. For example: "folders/my-folder-id/locations/my-location/buckets/my-bucket-id"
        :param pulumi.Input[_builtins.str] service_account_id: The service account associated with a project for which CMEK will apply.
               Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_version_name is not None:
            pulumi.set(__self__, "kms_key_version_name", kms_key_version_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Input[_builtins.str]:
        """
        The resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
        To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
        The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kms_key_name", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersionName")
    def kms_key_version_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CryptoKeyVersion resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]"
        For example:
        "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
        This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        """
        return pulumi.get(self, "kms_key_version_name")

    @kms_key_version_name.setter
    def kms_key_version_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_version_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the bucket. For example: "folders/my-folder-id/locations/my-location/buckets/my-bucket-id"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service account associated with a project for which CMEK will apply.
        Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)


if not MYPY:
    class FolderBucketConfigIndexConfigArgsDict(TypedDict):
        field_path: pulumi.Input[_builtins.str]
        """
        The LogEntry field path to index.
        Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        """
        type: pulumi.Input[_builtins.str]
        """
        The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
elif False:
    FolderBucketConfigIndexConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FolderBucketConfigIndexConfigArgs:
    def __init__(__self__, *,
                 field_path: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] field_path: The LogEntry field path to index.
               Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        :param pulumi.Input[_builtins.str] type: The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
        pulumi.set(__self__, "field_path", field_path)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> pulumi.Input[_builtins.str]:
        """
        The LogEntry field path to index.
        Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        """
        return pulumi.get(self, "field_path")

    @field_path.setter
    def field_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "field_path", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class FolderSinkBigqueryOptionsArgsDict(TypedDict):
        use_partitioned_tables: pulumi.Input[_builtins.bool]
        """
        Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
        By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
        tables, the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
        has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
elif False:
    FolderSinkBigqueryOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FolderSinkBigqueryOptionsArgs:
    def __init__(__self__, *,
                 use_partitioned_tables: pulumi.Input[_builtins.bool]):
        """
        :param pulumi.Input[_builtins.bool] use_partitioned_tables: Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
               By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
               tables, the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
               has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        pulumi.set(__self__, "use_partitioned_tables", use_partitioned_tables)

    @_builtins.property
    @pulumi.getter(name="usePartitionedTables")
    def use_partitioned_tables(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
        By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
        tables, the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
        has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        return pulumi.get(self, "use_partitioned_tables")

    @use_partitioned_tables.setter
    def use_partitioned_tables(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "use_partitioned_tables", value)


if not MYPY:
    class FolderSinkExclusionArgsDict(TypedDict):
        filter: pulumi.Input[_builtins.str]
        """
        An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        name: pulumi.Input[_builtins.str]
        """
        A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        A description of this exclusion.
        """
        disabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
elif False:
    FolderSinkExclusionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FolderSinkExclusionArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] filter: An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param pulumi.Input[_builtins.str] name: A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        :param pulumi.Input[_builtins.str] description: A description of this exclusion.
        :param pulumi.Input[_builtins.bool] disabled: If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Input[_builtins.str]:
        """
        An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of this exclusion.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)


if not MYPY:
    class LinkedDatasetBigqueryDatasetArgsDict(TypedDict):
        dataset_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        Output only. The full resource name of the BigQuery dataset. The DATASET_ID will match the ID
        of the link, so the link must match the naming restrictions of BigQuery datasets
        (alphanumeric characters and underscores only). The dataset will have a resource path of
        "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET_ID]"
        """
elif False:
    LinkedDatasetBigqueryDatasetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LinkedDatasetBigqueryDatasetArgs:
    def __init__(__self__, *,
                 dataset_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] dataset_id: (Output)
               Output only. The full resource name of the BigQuery dataset. The DATASET_ID will match the ID
               of the link, so the link must match the naming restrictions of BigQuery datasets
               (alphanumeric characters and underscores only). The dataset will have a resource path of
               "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET_ID]"
        """
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Output only. The full resource name of the BigQuery dataset. The DATASET_ID will match the ID
        of the link, so the link must match the naming restrictions of BigQuery datasets
        (alphanumeric characters and underscores only). The dataset will have a resource path of
        "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET_ID]"
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset_id", value)


if not MYPY:
    class LogViewIamBindingConditionArgsDict(TypedDict):
        expression: pulumi.Input[_builtins.str]
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        title: pulumi.Input[_builtins.str]
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    LogViewIamBindingConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LogViewIamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[_builtins.str],
                 title: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[_builtins.str] title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class LogViewIamMemberConditionArgsDict(TypedDict):
        expression: pulumi.Input[_builtins.str]
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        title: pulumi.Input[_builtins.str]
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    LogViewIamMemberConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LogViewIamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[_builtins.str],
                 title: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[_builtins.str] title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class MetricBucketOptionsArgsDict(TypedDict):
        explicit_buckets: NotRequired[pulumi.Input['MetricBucketOptionsExplicitBucketsArgsDict']]
        """
        Specifies a set of buckets with arbitrary widths.
        Structure is documented below.
        """
        exponential_buckets: NotRequired[pulumi.Input['MetricBucketOptionsExponentialBucketsArgsDict']]
        """
        Specifies an exponential sequence of buckets that have a width that is proportional to the value of
        the lower bound. Each bucket represents a constant relative uncertainty on a specific value in the bucket.
        Structure is documented below.
        """
        linear_buckets: NotRequired[pulumi.Input['MetricBucketOptionsLinearBucketsArgsDict']]
        """
        Specifies a linear sequence of buckets that all have the same width (except overflow and underflow).
        Each bucket represents a constant absolute uncertainty on the specific value in the bucket.
        Structure is documented below.
        """
elif False:
    MetricBucketOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MetricBucketOptionsArgs:
    def __init__(__self__, *,
                 explicit_buckets: Optional[pulumi.Input['MetricBucketOptionsExplicitBucketsArgs']] = None,
                 exponential_buckets: Optional[pulumi.Input['MetricBucketOptionsExponentialBucketsArgs']] = None,
                 linear_buckets: Optional[pulumi.Input['MetricBucketOptionsLinearBucketsArgs']] = None):
        """
        :param pulumi.Input['MetricBucketOptionsExplicitBucketsArgs'] explicit_buckets: Specifies a set of buckets with arbitrary widths.
               Structure is documented below.
        :param pulumi.Input['MetricBucketOptionsExponentialBucketsArgs'] exponential_buckets: Specifies an exponential sequence of buckets that have a width that is proportional to the value of
               the lower bound. Each bucket represents a constant relative uncertainty on a specific value in the bucket.
               Structure is documented below.
        :param pulumi.Input['MetricBucketOptionsLinearBucketsArgs'] linear_buckets: Specifies a linear sequence of buckets that all have the same width (except overflow and underflow).
               Each bucket represents a constant absolute uncertainty on the specific value in the bucket.
               Structure is documented below.
        """
        if explicit_buckets is not None:
            pulumi.set(__self__, "explicit_buckets", explicit_buckets)
        if exponential_buckets is not None:
            pulumi.set(__self__, "exponential_buckets", exponential_buckets)
        if linear_buckets is not None:
            pulumi.set(__self__, "linear_buckets", linear_buckets)

    @_builtins.property
    @pulumi.getter(name="explicitBuckets")
    def explicit_buckets(self) -> Optional[pulumi.Input['MetricBucketOptionsExplicitBucketsArgs']]:
        """
        Specifies a set of buckets with arbitrary widths.
        Structure is documented below.
        """
        return pulumi.get(self, "explicit_buckets")

    @explicit_buckets.setter
    def explicit_buckets(self, value: Optional[pulumi.Input['MetricBucketOptionsExplicitBucketsArgs']]):
        pulumi.set(self, "explicit_buckets", value)

    @_builtins.property
    @pulumi.getter(name="exponentialBuckets")
    def exponential_buckets(self) -> Optional[pulumi.Input['MetricBucketOptionsExponentialBucketsArgs']]:
        """
        Specifies an exponential sequence of buckets that have a width that is proportional to the value of
        the lower bound. Each bucket represents a constant relative uncertainty on a specific value in the bucket.
        Structure is documented below.
        """
        return pulumi.get(self, "exponential_buckets")

    @exponential_buckets.setter
    def exponential_buckets(self, value: Optional[pulumi.Input['MetricBucketOptionsExponentialBucketsArgs']]):
        pulumi.set(self, "exponential_buckets", value)

    @_builtins.property
    @pulumi.getter(name="linearBuckets")
    def linear_buckets(self) -> Optional[pulumi.Input['MetricBucketOptionsLinearBucketsArgs']]:
        """
        Specifies a linear sequence of buckets that all have the same width (except overflow and underflow).
        Each bucket represents a constant absolute uncertainty on the specific value in the bucket.
        Structure is documented below.
        """
        return pulumi.get(self, "linear_buckets")

    @linear_buckets.setter
    def linear_buckets(self, value: Optional[pulumi.Input['MetricBucketOptionsLinearBucketsArgs']]):
        pulumi.set(self, "linear_buckets", value)


if not MYPY:
    class MetricBucketOptionsExplicitBucketsArgsDict(TypedDict):
        bounds: pulumi.Input[Sequence[pulumi.Input[_builtins.float]]]
        """
        The values must be monotonically increasing.
        """
elif False:
    MetricBucketOptionsExplicitBucketsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MetricBucketOptionsExplicitBucketsArgs:
    def __init__(__self__, *,
                 bounds: pulumi.Input[Sequence[pulumi.Input[_builtins.float]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.float]]] bounds: The values must be monotonically increasing.
        """
        pulumi.set(__self__, "bounds", bounds)

    @_builtins.property
    @pulumi.getter
    def bounds(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.float]]]:
        """
        The values must be monotonically increasing.
        """
        return pulumi.get(self, "bounds")

    @bounds.setter
    def bounds(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.float]]]):
        pulumi.set(self, "bounds", value)


if not MYPY:
    class MetricBucketOptionsExponentialBucketsArgsDict(TypedDict):
        growth_factor: pulumi.Input[_builtins.float]
        """
        Must be greater than 1.
        """
        num_finite_buckets: pulumi.Input[_builtins.int]
        """
        Must be greater than 0.
        """
        scale: pulumi.Input[_builtins.float]
        """
        Must be greater than 0.
        """
elif False:
    MetricBucketOptionsExponentialBucketsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MetricBucketOptionsExponentialBucketsArgs:
    def __init__(__self__, *,
                 growth_factor: pulumi.Input[_builtins.float],
                 num_finite_buckets: pulumi.Input[_builtins.int],
                 scale: pulumi.Input[_builtins.float]):
        """
        :param pulumi.Input[_builtins.float] growth_factor: Must be greater than 1.
        :param pulumi.Input[_builtins.int] num_finite_buckets: Must be greater than 0.
        :param pulumi.Input[_builtins.float] scale: Must be greater than 0.
        """
        pulumi.set(__self__, "growth_factor", growth_factor)
        pulumi.set(__self__, "num_finite_buckets", num_finite_buckets)
        pulumi.set(__self__, "scale", scale)

    @_builtins.property
    @pulumi.getter(name="growthFactor")
    def growth_factor(self) -> pulumi.Input[_builtins.float]:
        """
        Must be greater than 1.
        """
        return pulumi.get(self, "growth_factor")

    @growth_factor.setter
    def growth_factor(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "growth_factor", value)

    @_builtins.property
    @pulumi.getter(name="numFiniteBuckets")
    def num_finite_buckets(self) -> pulumi.Input[_builtins.int]:
        """
        Must be greater than 0.
        """
        return pulumi.get(self, "num_finite_buckets")

    @num_finite_buckets.setter
    def num_finite_buckets(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "num_finite_buckets", value)

    @_builtins.property
    @pulumi.getter
    def scale(self) -> pulumi.Input[_builtins.float]:
        """
        Must be greater than 0.
        """
        return pulumi.get(self, "scale")

    @scale.setter
    def scale(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "scale", value)


if not MYPY:
    class MetricBucketOptionsLinearBucketsArgsDict(TypedDict):
        num_finite_buckets: pulumi.Input[_builtins.int]
        """
        Must be greater than 0.
        """
        offset: pulumi.Input[_builtins.float]
        """
        Lower bound of the first bucket.
        """
        width: pulumi.Input[_builtins.float]
        """
        Must be greater than 0.
        """
elif False:
    MetricBucketOptionsLinearBucketsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MetricBucketOptionsLinearBucketsArgs:
    def __init__(__self__, *,
                 num_finite_buckets: pulumi.Input[_builtins.int],
                 offset: pulumi.Input[_builtins.float],
                 width: pulumi.Input[_builtins.float]):
        """
        :param pulumi.Input[_builtins.int] num_finite_buckets: Must be greater than 0.
        :param pulumi.Input[_builtins.float] offset: Lower bound of the first bucket.
        :param pulumi.Input[_builtins.float] width: Must be greater than 0.
        """
        pulumi.set(__self__, "num_finite_buckets", num_finite_buckets)
        pulumi.set(__self__, "offset", offset)
        pulumi.set(__self__, "width", width)

    @_builtins.property
    @pulumi.getter(name="numFiniteBuckets")
    def num_finite_buckets(self) -> pulumi.Input[_builtins.int]:
        """
        Must be greater than 0.
        """
        return pulumi.get(self, "num_finite_buckets")

    @num_finite_buckets.setter
    def num_finite_buckets(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "num_finite_buckets", value)

    @_builtins.property
    @pulumi.getter
    def offset(self) -> pulumi.Input[_builtins.float]:
        """
        Lower bound of the first bucket.
        """
        return pulumi.get(self, "offset")

    @offset.setter
    def offset(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "offset", value)

    @_builtins.property
    @pulumi.getter
    def width(self) -> pulumi.Input[_builtins.float]:
        """
        Must be greater than 0.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "width", value)


if not MYPY:
    class MetricMetricDescriptorArgsDict(TypedDict):
        metric_kind: pulumi.Input[_builtins.str]
        """
        Whether the metric records instantaneous values, changes to a value, etc.
        Some combinations of metricKind and valueType might not be supported.
        For counter metrics, set this to DELTA.
        Possible values are: `DELTA`, `GAUGE`, `CUMULATIVE`.
        """
        value_type: pulumi.Input[_builtins.str]
        """
        Whether the measurement is an integer, a floating-point number, etc.
        Some combinations of metricKind and valueType might not be supported.
        For counter metrics, set this to INT64.
        Possible values are: `BOOL`, `INT64`, `DOUBLE`, `STRING`, `DISTRIBUTION`, `MONEY`.
        """
        display_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        A concise name for the metric, which can be displayed in user interfaces. Use sentence case
        without an ending period, for example "Request count". This field is optional but it is
        recommended to be set for any metrics associated with user-visible concepts, such as Quota.
        """
        labels: NotRequired[pulumi.Input[Sequence[pulumi.Input['MetricMetricDescriptorLabelArgsDict']]]]
        """
        The set of labels that can be used to describe a specific instance of this metric type. For
        example, the appengine.googleapis.com/http/server/response_latencies metric type has a label
        for the HTTP response code, response_code, so you can look at latencies for successful responses
        or just for responses that failed.
        Structure is documented below.
        """
        unit: NotRequired[pulumi.Input[_builtins.str]]
        """
        The unit in which the metric value is reported. It is only applicable if the valueType is
        `INT64`, `DOUBLE`, or `DISTRIBUTION`. The supported units are a subset of
        [The Unified Code for Units of Measure](http://unitsofmeasure.org/ucum.html) standard
        """
elif False:
    MetricMetricDescriptorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MetricMetricDescriptorArgs:
    def __init__(__self__, *,
                 metric_kind: pulumi.Input[_builtins.str],
                 value_type: pulumi.Input[_builtins.str],
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['MetricMetricDescriptorLabelArgs']]]] = None,
                 unit: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] metric_kind: Whether the metric records instantaneous values, changes to a value, etc.
               Some combinations of metricKind and valueType might not be supported.
               For counter metrics, set this to DELTA.
               Possible values are: `DELTA`, `GAUGE`, `CUMULATIVE`.
        :param pulumi.Input[_builtins.str] value_type: Whether the measurement is an integer, a floating-point number, etc.
               Some combinations of metricKind and valueType might not be supported.
               For counter metrics, set this to INT64.
               Possible values are: `BOOL`, `INT64`, `DOUBLE`, `STRING`, `DISTRIBUTION`, `MONEY`.
        :param pulumi.Input[_builtins.str] display_name: A concise name for the metric, which can be displayed in user interfaces. Use sentence case
               without an ending period, for example "Request count". This field is optional but it is
               recommended to be set for any metrics associated with user-visible concepts, such as Quota.
        :param pulumi.Input[Sequence[pulumi.Input['MetricMetricDescriptorLabelArgs']]] labels: The set of labels that can be used to describe a specific instance of this metric type. For
               example, the appengine.googleapis.com/http/server/response_latencies metric type has a label
               for the HTTP response code, response_code, so you can look at latencies for successful responses
               or just for responses that failed.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] unit: The unit in which the metric value is reported. It is only applicable if the valueType is
               `INT64`, `DOUBLE`, or `DISTRIBUTION`. The supported units are a subset of
               [The Unified Code for Units of Measure](http://unitsofmeasure.org/ucum.html) standard
        """
        pulumi.set(__self__, "metric_kind", metric_kind)
        pulumi.set(__self__, "value_type", value_type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @_builtins.property
    @pulumi.getter(name="metricKind")
    def metric_kind(self) -> pulumi.Input[_builtins.str]:
        """
        Whether the metric records instantaneous values, changes to a value, etc.
        Some combinations of metricKind and valueType might not be supported.
        For counter metrics, set this to DELTA.
        Possible values are: `DELTA`, `GAUGE`, `CUMULATIVE`.
        """
        return pulumi.get(self, "metric_kind")

    @metric_kind.setter
    def metric_kind(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "metric_kind", value)

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> pulumi.Input[_builtins.str]:
        """
        Whether the measurement is an integer, a floating-point number, etc.
        Some combinations of metricKind and valueType might not be supported.
        For counter metrics, set this to INT64.
        Possible values are: `BOOL`, `INT64`, `DOUBLE`, `STRING`, `DISTRIBUTION`, `MONEY`.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value_type", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A concise name for the metric, which can be displayed in user interfaces. Use sentence case
        without an ending period, for example "Request count". This field is optional but it is
        recommended to be set for any metrics associated with user-visible concepts, such as Quota.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricMetricDescriptorLabelArgs']]]]:
        """
        The set of labels that can be used to describe a specific instance of this metric type. For
        example, the appengine.googleapis.com/http/server/response_latencies metric type has a label
        for the HTTP response code, response_code, so you can look at latencies for successful responses
        or just for responses that failed.
        Structure is documented below.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricMetricDescriptorLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit in which the metric value is reported. It is only applicable if the valueType is
        `INT64`, `DOUBLE`, or `DISTRIBUTION`. The supported units are a subset of
        [The Unified Code for Units of Measure](http://unitsofmeasure.org/ucum.html) standard
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unit", value)


if not MYPY:
    class MetricMetricDescriptorLabelArgsDict(TypedDict):
        key: pulumi.Input[_builtins.str]
        """
        The label key.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        A human-readable description for the label.
        """
        value_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of data that can be assigned to the label.
        Default value is `STRING`.
        Possible values are: `BOOL`, `INT64`, `STRING`.
        """
elif False:
    MetricMetricDescriptorLabelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MetricMetricDescriptorLabelArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 value_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] key: The label key.
        :param pulumi.Input[_builtins.str] description: A human-readable description for the label.
        :param pulumi.Input[_builtins.str] value_type: The type of data that can be assigned to the label.
               Default value is `STRING`.
               Possible values are: `BOOL`, `INT64`, `STRING`.
        """
        pulumi.set(__self__, "key", key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The label key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable description for the label.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of data that can be assigned to the label.
        Default value is `STRING`.
        Possible values are: `BOOL`, `INT64`, `STRING`.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value_type", value)


if not MYPY:
    class OrganizationBucketConfigCmekSettingsArgsDict(TypedDict):
        kms_key_name: pulumi.Input[_builtins.str]
        """
        The resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
        To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
        The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        kms_key_version_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The CryptoKeyVersion resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]"
        For example:
        "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
        This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The resource name of the bucket. For example: "organizations/my-organization-id/locations/my-location/buckets/my-bucket-id"
        """
        service_account_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The service account associated with a project for which CMEK will apply.
        Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
elif False:
    OrganizationBucketConfigCmekSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OrganizationBucketConfigCmekSettingsArgs:
    def __init__(__self__, *,
                 kms_key_name: pulumi.Input[_builtins.str],
                 kms_key_version_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] kms_key_name: The resource name for the configured Cloud KMS key.
               KMS key name format:
               "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
               To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
               The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        :param pulumi.Input[_builtins.str] kms_key_version_name: The CryptoKeyVersion resource name for the configured Cloud KMS key.
               KMS key name format:
               "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]"
               For example:
               "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
               This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        :param pulumi.Input[_builtins.str] name: The resource name of the bucket. For example: "organizations/my-organization-id/locations/my-location/buckets/my-bucket-id"
        :param pulumi.Input[_builtins.str] service_account_id: The service account associated with a project for which CMEK will apply.
               Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_version_name is not None:
            pulumi.set(__self__, "kms_key_version_name", kms_key_version_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Input[_builtins.str]:
        """
        The resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
        To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
        The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kms_key_name", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersionName")
    def kms_key_version_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CryptoKeyVersion resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]"
        For example:
        "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
        This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        """
        return pulumi.get(self, "kms_key_version_name")

    @kms_key_version_name.setter
    def kms_key_version_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_version_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the bucket. For example: "organizations/my-organization-id/locations/my-location/buckets/my-bucket-id"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service account associated with a project for which CMEK will apply.
        Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)


if not MYPY:
    class OrganizationBucketConfigIndexConfigArgsDict(TypedDict):
        field_path: pulumi.Input[_builtins.str]
        """
        The LogEntry field path to index.
        Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        """
        type: pulumi.Input[_builtins.str]
        """
        The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
elif False:
    OrganizationBucketConfigIndexConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OrganizationBucketConfigIndexConfigArgs:
    def __init__(__self__, *,
                 field_path: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] field_path: The LogEntry field path to index.
               Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        :param pulumi.Input[_builtins.str] type: The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
        pulumi.set(__self__, "field_path", field_path)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> pulumi.Input[_builtins.str]:
        """
        The LogEntry field path to index.
        Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        """
        return pulumi.get(self, "field_path")

    @field_path.setter
    def field_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "field_path", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class OrganizationSinkBigqueryOptionsArgsDict(TypedDict):
        use_partitioned_tables: pulumi.Input[_builtins.bool]
        """
        Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
        By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
        tables the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
        has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
elif False:
    OrganizationSinkBigqueryOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OrganizationSinkBigqueryOptionsArgs:
    def __init__(__self__, *,
                 use_partitioned_tables: pulumi.Input[_builtins.bool]):
        """
        :param pulumi.Input[_builtins.bool] use_partitioned_tables: Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
               By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
               tables the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
               has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        pulumi.set(__self__, "use_partitioned_tables", use_partitioned_tables)

    @_builtins.property
    @pulumi.getter(name="usePartitionedTables")
    def use_partitioned_tables(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
        By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
        tables the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
        has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        return pulumi.get(self, "use_partitioned_tables")

    @use_partitioned_tables.setter
    def use_partitioned_tables(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "use_partitioned_tables", value)


if not MYPY:
    class OrganizationSinkExclusionArgsDict(TypedDict):
        filter: pulumi.Input[_builtins.str]
        """
        An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        name: pulumi.Input[_builtins.str]
        """
        A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        A description of this exclusion.
        """
        disabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
elif False:
    OrganizationSinkExclusionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OrganizationSinkExclusionArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] filter: An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param pulumi.Input[_builtins.str] name: A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        :param pulumi.Input[_builtins.str] description: A description of this exclusion.
        :param pulumi.Input[_builtins.bool] disabled: If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Input[_builtins.str]:
        """
        An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of this exclusion.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)


if not MYPY:
    class ProjectBucketConfigCmekSettingsArgsDict(TypedDict):
        kms_key_name: pulumi.Input[_builtins.str]
        """
        The resource name for the configured Cloud KMS key.
        KMS key name format:
        `'projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]'`
        To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
        The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        kms_key_version_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The CryptoKeyVersion resource name for the configured Cloud KMS key.
        KMS key name format:
        `'projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]'`
        For example:
        "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
        This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The resource name of the CMEK settings.
        """
        service_account_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The service account associated with a project for which CMEK will apply.
        Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
elif False:
    ProjectBucketConfigCmekSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProjectBucketConfigCmekSettingsArgs:
    def __init__(__self__, *,
                 kms_key_name: pulumi.Input[_builtins.str],
                 kms_key_version_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] kms_key_name: The resource name for the configured Cloud KMS key.
               KMS key name format:
               `'projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]'`
               To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
               The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        :param pulumi.Input[_builtins.str] kms_key_version_name: The CryptoKeyVersion resource name for the configured Cloud KMS key.
               KMS key name format:
               `'projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]'`
               For example:
               "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
               This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        :param pulumi.Input[_builtins.str] name: The resource name of the CMEK settings.
        :param pulumi.Input[_builtins.str] service_account_id: The service account associated with a project for which CMEK will apply.
               Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_version_name is not None:
            pulumi.set(__self__, "kms_key_version_name", kms_key_version_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Input[_builtins.str]:
        """
        The resource name for the configured Cloud KMS key.
        KMS key name format:
        `'projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]'`
        To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
        The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kms_key_name", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersionName")
    def kms_key_version_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CryptoKeyVersion resource name for the configured Cloud KMS key.
        KMS key name format:
        `'projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]'`
        For example:
        "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
        This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        """
        return pulumi.get(self, "kms_key_version_name")

    @kms_key_version_name.setter
    def kms_key_version_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_version_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the CMEK settings.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service account associated with a project for which CMEK will apply.
        Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_id", value)


if not MYPY:
    class ProjectBucketConfigIndexConfigArgsDict(TypedDict):
        field_path: pulumi.Input[_builtins.str]
        """
        The LogEntry field path to index.
        Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        """
        type: pulumi.Input[_builtins.str]
        """
        The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
elif False:
    ProjectBucketConfigIndexConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProjectBucketConfigIndexConfigArgs:
    def __init__(__self__, *,
                 field_path: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] field_path: The LogEntry field path to index.
               Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        :param pulumi.Input[_builtins.str] type: The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
        pulumi.set(__self__, "field_path", field_path)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> pulumi.Input[_builtins.str]:
        """
        The LogEntry field path to index.
        Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        """
        return pulumi.get(self, "field_path")

    @field_path.setter
    def field_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "field_path", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ProjectSinkBigqueryOptionsArgsDict(TypedDict):
        use_partitioned_tables: pulumi.Input[_builtins.bool]
        """
        Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
        By default, Logging creates dated tables based on the log entries' timestamps, e.g. `syslog_20170523`. With partitioned
        tables the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
        has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
elif False:
    ProjectSinkBigqueryOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProjectSinkBigqueryOptionsArgs:
    def __init__(__self__, *,
                 use_partitioned_tables: pulumi.Input[_builtins.bool]):
        """
        :param pulumi.Input[_builtins.bool] use_partitioned_tables: Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
               By default, Logging creates dated tables based on the log entries' timestamps, e.g. `syslog_20170523`. With partitioned
               tables the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
               has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        pulumi.set(__self__, "use_partitioned_tables", use_partitioned_tables)

    @_builtins.property
    @pulumi.getter(name="usePartitionedTables")
    def use_partitioned_tables(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
        By default, Logging creates dated tables based on the log entries' timestamps, e.g. `syslog_20170523`. With partitioned
        tables the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
        has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        return pulumi.get(self, "use_partitioned_tables")

    @use_partitioned_tables.setter
    def use_partitioned_tables(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "use_partitioned_tables", value)


if not MYPY:
    class ProjectSinkExclusionArgsDict(TypedDict):
        filter: pulumi.Input[_builtins.str]
        """
        An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        name: pulumi.Input[_builtins.str]
        """
        A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        A description of this exclusion.
        """
        disabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
elif False:
    ProjectSinkExclusionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProjectSinkExclusionArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] filter: An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param pulumi.Input[_builtins.str] name: A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        :param pulumi.Input[_builtins.str] description: A description of this exclusion.
        :param pulumi.Input[_builtins.bool] disabled: If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Input[_builtins.str]:
        """
        An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of this exclusion.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)


