# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LogScopeArgs', 'LogScope']

@pulumi.input_type
class LogScopeArgs:
    def __init__(__self__, *,
                 resource_names: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LogScope resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_names: Names of one or more parent resources : *  \\`projects/[PROJECT_ID]\\` May alternatively be one or more views : * \\`projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]\\` A log scope can include a maximum of 50 projects and a maximum of 100 resources in total.
        :param pulumi.Input[_builtins.str] description: Describes this log scopes.
        :param pulumi.Input[_builtins.str] location: The location of the resource. The only supported location is global so far.
        :param pulumi.Input[_builtins.str] name: The resource name of the log scope. For example: \\`projects/my-project/locations/global/logScopes/my-log-scope\\`
        :param pulumi.Input[_builtins.str] parent: The parent of the resource.
        """
        pulumi.set(__self__, "resource_names", resource_names)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)

    @_builtins.property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Names of one or more parent resources : *  \\`projects/[PROJECT_ID]\\` May alternatively be one or more views : * \\`projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]\\` A log scope can include a maximum of 50 projects and a maximum of 100 resources in total.
        """
        return pulumi.get(self, "resource_names")

    @resource_names.setter
    def resource_names(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "resource_names", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes this log scopes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the resource. The only supported location is global so far.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the log scope. For example: \\`projects/my-project/locations/global/logScopes/my-log-scope\\`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The parent of the resource.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)


@pulumi.input_type
class _LogScopeState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LogScope resources.
        :param pulumi.Input[_builtins.str] create_time: Output only. The creation timestamp of the log scopes.
        :param pulumi.Input[_builtins.str] description: Describes this log scopes.
        :param pulumi.Input[_builtins.str] location: The location of the resource. The only supported location is global so far.
        :param pulumi.Input[_builtins.str] name: The resource name of the log scope. For example: \\`projects/my-project/locations/global/logScopes/my-log-scope\\`
        :param pulumi.Input[_builtins.str] parent: The parent of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_names: Names of one or more parent resources : *  \\`projects/[PROJECT_ID]\\` May alternatively be one or more views : * \\`projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]\\` A log scope can include a maximum of 50 projects and a maximum of 100 resources in total.
        :param pulumi.Input[_builtins.str] update_time: Output only. The last update timestamp of the log scopes.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if resource_names is not None:
            pulumi.set(__self__, "resource_names", resource_names)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The creation timestamp of the log scopes.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes this log scopes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the resource. The only supported location is global so far.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the log scope. For example: \\`projects/my-project/locations/global/logScopes/my-log-scope\\`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The parent of the resource.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Names of one or more parent resources : *  \\`projects/[PROJECT_ID]\\` May alternatively be one or more views : * \\`projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]\\` A log scope can include a maximum of 50 projects and a maximum of 100 resources in total.
        """
        return pulumi.get(self, "resource_names")

    @resource_names.setter
    def resource_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_names", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The last update timestamp of the log scopes.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:logging/logScope:LogScope")
class LogScope(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Describes a group of resources to read log entries from

        To get more information about LogScope, see:

        * [API documentation](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.locations.logScopes)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/logging/docs/apis)

        ## Example Usage

        ### Logging Log Scope Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        logging_log_scope = gcp.logging.LogScope("logging_log_scope",
            parent="projects/my-project-name",
            location="global",
            name="projects/my-project-name/locations/global/logScopes/my-log-scope",
            resource_names=[
                "projects/my-project-name",
                "projects/my-project-name/locations/global/buckets/_Default/views/view1",
                "projects/my-project-name/locations/global/buckets/_Default/views/view2",
            ],
            description="A log scope configured with Terraform")
        ```

        ## Import

        LogScope can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/logScopes/{{name}}`

        When using the `pulumi import` command, LogScope can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:logging/logScope:LogScope default {{parent}}/locations/{{location}}/logScopes/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Describes this log scopes.
        :param pulumi.Input[_builtins.str] location: The location of the resource. The only supported location is global so far.
        :param pulumi.Input[_builtins.str] name: The resource name of the log scope. For example: \\`projects/my-project/locations/global/logScopes/my-log-scope\\`
        :param pulumi.Input[_builtins.str] parent: The parent of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_names: Names of one or more parent resources : *  \\`projects/[PROJECT_ID]\\` May alternatively be one or more views : * \\`projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]\\` A log scope can include a maximum of 50 projects and a maximum of 100 resources in total.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogScopeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Describes a group of resources to read log entries from

        To get more information about LogScope, see:

        * [API documentation](https://cloud.google.com/logging/docs/reference/v2/rest/v2/projects.locations.logScopes)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/logging/docs/apis)

        ## Example Usage

        ### Logging Log Scope Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        logging_log_scope = gcp.logging.LogScope("logging_log_scope",
            parent="projects/my-project-name",
            location="global",
            name="projects/my-project-name/locations/global/logScopes/my-log-scope",
            resource_names=[
                "projects/my-project-name",
                "projects/my-project-name/locations/global/buckets/_Default/views/view1",
                "projects/my-project-name/locations/global/buckets/_Default/views/view2",
            ],
            description="A log scope configured with Terraform")
        ```

        ## Import

        LogScope can be imported using any of these accepted formats:

        * `{{parent}}/locations/{{location}}/logScopes/{{name}}`

        When using the `pulumi import` command, LogScope can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:logging/logScope:LogScope default {{parent}}/locations/{{location}}/logScopes/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param LogScopeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogScopeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogScopeArgs.__new__(LogScopeArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["parent"] = parent
            if resource_names is None and not opts.urn:
                raise TypeError("Missing required property 'resource_names'")
            __props__.__dict__["resource_names"] = resource_names
            __props__.__dict__["create_time"] = None
            __props__.__dict__["update_time"] = None
        super(LogScope, __self__).__init__(
            'gcp:logging/logScope:LogScope',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None,
            resource_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'LogScope':
        """
        Get an existing LogScope resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Output only. The creation timestamp of the log scopes.
        :param pulumi.Input[_builtins.str] description: Describes this log scopes.
        :param pulumi.Input[_builtins.str] location: The location of the resource. The only supported location is global so far.
        :param pulumi.Input[_builtins.str] name: The resource name of the log scope. For example: \\`projects/my-project/locations/global/logScopes/my-log-scope\\`
        :param pulumi.Input[_builtins.str] parent: The parent of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_names: Names of one or more parent resources : *  \\`projects/[PROJECT_ID]\\` May alternatively be one or more views : * \\`projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]\\` A log scope can include a maximum of 50 projects and a maximum of 100 resources in total.
        :param pulumi.Input[_builtins.str] update_time: Output only. The last update timestamp of the log scopes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogScopeState.__new__(_LogScopeState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["resource_names"] = resource_names
        __props__.__dict__["update_time"] = update_time
        return LogScope(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The creation timestamp of the log scopes.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Describes this log scopes.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the resource. The only supported location is global so far.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the log scope. For example: \\`projects/my-project/locations/global/logScopes/my-log-scope\\`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[_builtins.str]:
        """
        The parent of the resource.
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter(name="resourceNames")
    def resource_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Names of one or more parent resources : *  \\`projects/[PROJECT_ID]\\` May alternatively be one or more views : * \\`projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]\\` A log scope can include a maximum of 50 projects and a maximum of 100 resources in total.
        """
        return pulumi.get(self, "resource_names")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The last update timestamp of the log scopes.
        """
        return pulumi.get(self, "update_time")

