# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BillingAccountBucketConfigCmekSettings',
    'BillingAccountBucketConfigIndexConfig',
    'BillingAccountSinkBigqueryOptions',
    'BillingAccountSinkExclusion',
    'FolderBucketConfigCmekSettings',
    'FolderBucketConfigIndexConfig',
    'FolderSinkBigqueryOptions',
    'FolderSinkExclusion',
    'LinkedDatasetBigqueryDataset',
    'LogViewIamBindingCondition',
    'LogViewIamMemberCondition',
    'MetricBucketOptions',
    'MetricBucketOptionsExplicitBuckets',
    'MetricBucketOptionsExponentialBuckets',
    'MetricBucketOptionsLinearBuckets',
    'MetricMetricDescriptor',
    'MetricMetricDescriptorLabel',
    'OrganizationBucketConfigCmekSettings',
    'OrganizationBucketConfigIndexConfig',
    'OrganizationSinkBigqueryOptions',
    'OrganizationSinkExclusion',
    'ProjectBucketConfigCmekSettings',
    'ProjectBucketConfigIndexConfig',
    'ProjectSinkBigqueryOptions',
    'ProjectSinkExclusion',
    'GetSinkBigqueryOptionResult',
    'GetSinkExclusionResult',
]

@pulumi.output_type
class BillingAccountBucketConfigCmekSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "kmsKeyVersionName":
            suggest = "kms_key_version_name"
        elif key == "serviceAccountId":
            suggest = "service_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BillingAccountBucketConfigCmekSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BillingAccountBucketConfigCmekSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BillingAccountBucketConfigCmekSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: _builtins.str,
                 kms_key_version_name: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 service_account_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str kms_key_name: The resource name for the configured Cloud KMS key.
               KMS key name format:
               "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
               To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
               The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        :param _builtins.str kms_key_version_name: The CryptoKeyVersion resource name for the configured Cloud KMS key.
               KMS key name format:
               "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]"
               For example:
               "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
               This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        :param _builtins.str name: The resource name of the bucket. For example: "projects/my-project-id/locations/my-location/buckets/my-bucket-id"
        :param _builtins.str service_account_id: The service account associated with a project for which CMEK will apply.
               Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_version_name is not None:
            pulumi.set(__self__, "kms_key_version_name", kms_key_version_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> _builtins.str:
        """
        The resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
        To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
        The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersionName")
    def kms_key_version_name(self) -> Optional[_builtins.str]:
        """
        The CryptoKeyVersion resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]"
        For example:
        "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
        This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        """
        return pulumi.get(self, "kms_key_version_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The resource name of the bucket. For example: "projects/my-project-id/locations/my-location/buckets/my-bucket-id"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[_builtins.str]:
        """
        The service account associated with a project for which CMEK will apply.
        Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "service_account_id")


@pulumi.output_type
class BillingAccountBucketConfigIndexConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldPath":
            suggest = "field_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BillingAccountBucketConfigIndexConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BillingAccountBucketConfigIndexConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BillingAccountBucketConfigIndexConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_path: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str field_path: The LogEntry field path to index.
               Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        :param _builtins.str type: The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
        pulumi.set(__self__, "field_path", field_path)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> _builtins.str:
        """
        The LogEntry field path to index.
        Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        """
        return pulumi.get(self, "field_path")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class BillingAccountSinkBigqueryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "usePartitionedTables":
            suggest = "use_partitioned_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BillingAccountSinkBigqueryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BillingAccountSinkBigqueryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BillingAccountSinkBigqueryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_partitioned_tables: _builtins.bool):
        """
        :param _builtins.bool use_partitioned_tables: Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
               By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
               tables, the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
               has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        pulumi.set(__self__, "use_partitioned_tables", use_partitioned_tables)

    @_builtins.property
    @pulumi.getter(name="usePartitionedTables")
    def use_partitioned_tables(self) -> _builtins.bool:
        """
        Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
        By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
        tables, the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
        has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        return pulumi.get(self, "use_partitioned_tables")


@pulumi.output_type
class BillingAccountSinkExclusion(dict):
    def __init__(__self__, *,
                 filter: _builtins.str,
                 name: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 disabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str filter: An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param _builtins.str name: A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        :param _builtins.str description: A description of this exclusion.
        :param _builtins.bool disabled: If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> _builtins.str:
        """
        An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        A description of this exclusion.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[_builtins.bool]:
        """
        If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class FolderBucketConfigCmekSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "kmsKeyVersionName":
            suggest = "kms_key_version_name"
        elif key == "serviceAccountId":
            suggest = "service_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FolderBucketConfigCmekSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FolderBucketConfigCmekSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FolderBucketConfigCmekSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: _builtins.str,
                 kms_key_version_name: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 service_account_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str kms_key_name: The resource name for the configured Cloud KMS key.
               KMS key name format:
               "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
               To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
               The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        :param _builtins.str kms_key_version_name: The CryptoKeyVersion resource name for the configured Cloud KMS key.
               KMS key name format:
               "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]"
               For example:
               "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
               This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        :param _builtins.str name: The resource name of the bucket. For example: "folders/my-folder-id/locations/my-location/buckets/my-bucket-id"
        :param _builtins.str service_account_id: The service account associated with a project for which CMEK will apply.
               Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_version_name is not None:
            pulumi.set(__self__, "kms_key_version_name", kms_key_version_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> _builtins.str:
        """
        The resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
        To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
        The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersionName")
    def kms_key_version_name(self) -> Optional[_builtins.str]:
        """
        The CryptoKeyVersion resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]"
        For example:
        "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
        This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        """
        return pulumi.get(self, "kms_key_version_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The resource name of the bucket. For example: "folders/my-folder-id/locations/my-location/buckets/my-bucket-id"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[_builtins.str]:
        """
        The service account associated with a project for which CMEK will apply.
        Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "service_account_id")


@pulumi.output_type
class FolderBucketConfigIndexConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldPath":
            suggest = "field_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FolderBucketConfigIndexConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FolderBucketConfigIndexConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FolderBucketConfigIndexConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_path: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str field_path: The LogEntry field path to index.
               Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        :param _builtins.str type: The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
        pulumi.set(__self__, "field_path", field_path)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> _builtins.str:
        """
        The LogEntry field path to index.
        Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        """
        return pulumi.get(self, "field_path")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FolderSinkBigqueryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "usePartitionedTables":
            suggest = "use_partitioned_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FolderSinkBigqueryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FolderSinkBigqueryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FolderSinkBigqueryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_partitioned_tables: _builtins.bool):
        """
        :param _builtins.bool use_partitioned_tables: Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
               By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
               tables, the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
               has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        pulumi.set(__self__, "use_partitioned_tables", use_partitioned_tables)

    @_builtins.property
    @pulumi.getter(name="usePartitionedTables")
    def use_partitioned_tables(self) -> _builtins.bool:
        """
        Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
        By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
        tables, the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
        has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        return pulumi.get(self, "use_partitioned_tables")


@pulumi.output_type
class FolderSinkExclusion(dict):
    def __init__(__self__, *,
                 filter: _builtins.str,
                 name: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 disabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str filter: An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param _builtins.str name: A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        :param _builtins.str description: A description of this exclusion.
        :param _builtins.bool disabled: If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> _builtins.str:
        """
        An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        A description of this exclusion.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[_builtins.bool]:
        """
        If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class LinkedDatasetBigqueryDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinkedDatasetBigqueryDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinkedDatasetBigqueryDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinkedDatasetBigqueryDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str dataset_id: (Output)
               Output only. The full resource name of the BigQuery dataset. The DATASET_ID will match the ID
               of the link, so the link must match the naming restrictions of BigQuery datasets
               (alphanumeric characters and underscores only). The dataset will have a resource path of
               "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET_ID]"
        """
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)

    @_builtins.property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[_builtins.str]:
        """
        (Output)
        Output only. The full resource name of the BigQuery dataset. The DATASET_ID will match the ID
        of the link, so the link must match the naming restrictions of BigQuery datasets
        (alphanumeric characters and underscores only). The dataset will have a resource path of
        "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET_ID]"
        """
        return pulumi.get(self, "dataset_id")


@pulumi.output_type
class LogViewIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class LogViewIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class MetricBucketOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "explicitBuckets":
            suggest = "explicit_buckets"
        elif key == "exponentialBuckets":
            suggest = "exponential_buckets"
        elif key == "linearBuckets":
            suggest = "linear_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricBucketOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricBucketOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricBucketOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 explicit_buckets: Optional['outputs.MetricBucketOptionsExplicitBuckets'] = None,
                 exponential_buckets: Optional['outputs.MetricBucketOptionsExponentialBuckets'] = None,
                 linear_buckets: Optional['outputs.MetricBucketOptionsLinearBuckets'] = None):
        """
        :param 'MetricBucketOptionsExplicitBucketsArgs' explicit_buckets: Specifies a set of buckets with arbitrary widths.
               Structure is documented below.
        :param 'MetricBucketOptionsExponentialBucketsArgs' exponential_buckets: Specifies an exponential sequence of buckets that have a width that is proportional to the value of
               the lower bound. Each bucket represents a constant relative uncertainty on a specific value in the bucket.
               Structure is documented below.
        :param 'MetricBucketOptionsLinearBucketsArgs' linear_buckets: Specifies a linear sequence of buckets that all have the same width (except overflow and underflow).
               Each bucket represents a constant absolute uncertainty on the specific value in the bucket.
               Structure is documented below.
        """
        if explicit_buckets is not None:
            pulumi.set(__self__, "explicit_buckets", explicit_buckets)
        if exponential_buckets is not None:
            pulumi.set(__self__, "exponential_buckets", exponential_buckets)
        if linear_buckets is not None:
            pulumi.set(__self__, "linear_buckets", linear_buckets)

    @_builtins.property
    @pulumi.getter(name="explicitBuckets")
    def explicit_buckets(self) -> Optional['outputs.MetricBucketOptionsExplicitBuckets']:
        """
        Specifies a set of buckets with arbitrary widths.
        Structure is documented below.
        """
        return pulumi.get(self, "explicit_buckets")

    @_builtins.property
    @pulumi.getter(name="exponentialBuckets")
    def exponential_buckets(self) -> Optional['outputs.MetricBucketOptionsExponentialBuckets']:
        """
        Specifies an exponential sequence of buckets that have a width that is proportional to the value of
        the lower bound. Each bucket represents a constant relative uncertainty on a specific value in the bucket.
        Structure is documented below.
        """
        return pulumi.get(self, "exponential_buckets")

    @_builtins.property
    @pulumi.getter(name="linearBuckets")
    def linear_buckets(self) -> Optional['outputs.MetricBucketOptionsLinearBuckets']:
        """
        Specifies a linear sequence of buckets that all have the same width (except overflow and underflow).
        Each bucket represents a constant absolute uncertainty on the specific value in the bucket.
        Structure is documented below.
        """
        return pulumi.get(self, "linear_buckets")


@pulumi.output_type
class MetricBucketOptionsExplicitBuckets(dict):
    def __init__(__self__, *,
                 bounds: Sequence[_builtins.float]):
        """
        :param Sequence[_builtins.float] bounds: The values must be monotonically increasing.
        """
        pulumi.set(__self__, "bounds", bounds)

    @_builtins.property
    @pulumi.getter
    def bounds(self) -> Sequence[_builtins.float]:
        """
        The values must be monotonically increasing.
        """
        return pulumi.get(self, "bounds")


@pulumi.output_type
class MetricBucketOptionsExponentialBuckets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "growthFactor":
            suggest = "growth_factor"
        elif key == "numFiniteBuckets":
            suggest = "num_finite_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricBucketOptionsExponentialBuckets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricBucketOptionsExponentialBuckets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricBucketOptionsExponentialBuckets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 growth_factor: _builtins.float,
                 num_finite_buckets: _builtins.int,
                 scale: _builtins.float):
        """
        :param _builtins.float growth_factor: Must be greater than 1.
        :param _builtins.int num_finite_buckets: Must be greater than 0.
        :param _builtins.float scale: Must be greater than 0.
        """
        pulumi.set(__self__, "growth_factor", growth_factor)
        pulumi.set(__self__, "num_finite_buckets", num_finite_buckets)
        pulumi.set(__self__, "scale", scale)

    @_builtins.property
    @pulumi.getter(name="growthFactor")
    def growth_factor(self) -> _builtins.float:
        """
        Must be greater than 1.
        """
        return pulumi.get(self, "growth_factor")

    @_builtins.property
    @pulumi.getter(name="numFiniteBuckets")
    def num_finite_buckets(self) -> _builtins.int:
        """
        Must be greater than 0.
        """
        return pulumi.get(self, "num_finite_buckets")

    @_builtins.property
    @pulumi.getter
    def scale(self) -> _builtins.float:
        """
        Must be greater than 0.
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class MetricBucketOptionsLinearBuckets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numFiniteBuckets":
            suggest = "num_finite_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricBucketOptionsLinearBuckets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricBucketOptionsLinearBuckets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricBucketOptionsLinearBuckets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 num_finite_buckets: _builtins.int,
                 offset: _builtins.float,
                 width: _builtins.float):
        """
        :param _builtins.int num_finite_buckets: Must be greater than 0.
        :param _builtins.float offset: Lower bound of the first bucket.
        :param _builtins.float width: Must be greater than 0.
        """
        pulumi.set(__self__, "num_finite_buckets", num_finite_buckets)
        pulumi.set(__self__, "offset", offset)
        pulumi.set(__self__, "width", width)

    @_builtins.property
    @pulumi.getter(name="numFiniteBuckets")
    def num_finite_buckets(self) -> _builtins.int:
        """
        Must be greater than 0.
        """
        return pulumi.get(self, "num_finite_buckets")

    @_builtins.property
    @pulumi.getter
    def offset(self) -> _builtins.float:
        """
        Lower bound of the first bucket.
        """
        return pulumi.get(self, "offset")

    @_builtins.property
    @pulumi.getter
    def width(self) -> _builtins.float:
        """
        Must be greater than 0.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class MetricMetricDescriptor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricKind":
            suggest = "metric_kind"
        elif key == "valueType":
            suggest = "value_type"
        elif key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricMetricDescriptor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricMetricDescriptor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricMetricDescriptor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_kind: _builtins.str,
                 value_type: _builtins.str,
                 display_name: Optional[_builtins.str] = None,
                 labels: Optional[Sequence['outputs.MetricMetricDescriptorLabel']] = None,
                 unit: Optional[_builtins.str] = None):
        """
        :param _builtins.str metric_kind: Whether the metric records instantaneous values, changes to a value, etc.
               Some combinations of metricKind and valueType might not be supported.
               For counter metrics, set this to DELTA.
               Possible values are: `DELTA`, `GAUGE`, `CUMULATIVE`.
        :param _builtins.str value_type: Whether the measurement is an integer, a floating-point number, etc.
               Some combinations of metricKind and valueType might not be supported.
               For counter metrics, set this to INT64.
               Possible values are: `BOOL`, `INT64`, `DOUBLE`, `STRING`, `DISTRIBUTION`, `MONEY`.
        :param _builtins.str display_name: A concise name for the metric, which can be displayed in user interfaces. Use sentence case
               without an ending period, for example "Request count". This field is optional but it is
               recommended to be set for any metrics associated with user-visible concepts, such as Quota.
        :param Sequence['MetricMetricDescriptorLabelArgs'] labels: The set of labels that can be used to describe a specific instance of this metric type. For
               example, the appengine.googleapis.com/http/server/response_latencies metric type has a label
               for the HTTP response code, response_code, so you can look at latencies for successful responses
               or just for responses that failed.
               Structure is documented below.
        :param _builtins.str unit: The unit in which the metric value is reported. It is only applicable if the valueType is
               `INT64`, `DOUBLE`, or `DISTRIBUTION`. The supported units are a subset of
               [The Unified Code for Units of Measure](http://unitsofmeasure.org/ucum.html) standard
        """
        pulumi.set(__self__, "metric_kind", metric_kind)
        pulumi.set(__self__, "value_type", value_type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @_builtins.property
    @pulumi.getter(name="metricKind")
    def metric_kind(self) -> _builtins.str:
        """
        Whether the metric records instantaneous values, changes to a value, etc.
        Some combinations of metricKind and valueType might not be supported.
        For counter metrics, set this to DELTA.
        Possible values are: `DELTA`, `GAUGE`, `CUMULATIVE`.
        """
        return pulumi.get(self, "metric_kind")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> _builtins.str:
        """
        Whether the measurement is an integer, a floating-point number, etc.
        Some combinations of metricKind and valueType might not be supported.
        For counter metrics, set this to INT64.
        Possible values are: `BOOL`, `INT64`, `DOUBLE`, `STRING`, `DISTRIBUTION`, `MONEY`.
        """
        return pulumi.get(self, "value_type")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A concise name for the metric, which can be displayed in user interfaces. Use sentence case
        without an ending period, for example "Request count". This field is optional but it is
        recommended to be set for any metrics associated with user-visible concepts, such as Quota.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Sequence['outputs.MetricMetricDescriptorLabel']]:
        """
        The set of labels that can be used to describe a specific instance of this metric type. For
        example, the appengine.googleapis.com/http/server/response_latencies metric type has a label
        for the HTTP response code, response_code, so you can look at latencies for successful responses
        or just for responses that failed.
        Structure is documented below.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def unit(self) -> Optional[_builtins.str]:
        """
        The unit in which the metric value is reported. It is only applicable if the valueType is
        `INT64`, `DOUBLE`, or `DISTRIBUTION`. The supported units are a subset of
        [The Unified Code for Units of Measure](http://unitsofmeasure.org/ucum.html) standard
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class MetricMetricDescriptorLabel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricMetricDescriptorLabel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricMetricDescriptorLabel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricMetricDescriptorLabel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 value_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: The label key.
        :param _builtins.str description: A human-readable description for the label.
        :param _builtins.str value_type: The type of data that can be assigned to the label.
               Default value is `STRING`.
               Possible values are: `BOOL`, `INT64`, `STRING`.
        """
        pulumi.set(__self__, "key", key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The label key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        A human-readable description for the label.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[_builtins.str]:
        """
        The type of data that can be assigned to the label.
        Default value is `STRING`.
        Possible values are: `BOOL`, `INT64`, `STRING`.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class OrganizationBucketConfigCmekSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "kmsKeyVersionName":
            suggest = "kms_key_version_name"
        elif key == "serviceAccountId":
            suggest = "service_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrganizationBucketConfigCmekSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrganizationBucketConfigCmekSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrganizationBucketConfigCmekSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: _builtins.str,
                 kms_key_version_name: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 service_account_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str kms_key_name: The resource name for the configured Cloud KMS key.
               KMS key name format:
               "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
               To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
               The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        :param _builtins.str kms_key_version_name: The CryptoKeyVersion resource name for the configured Cloud KMS key.
               KMS key name format:
               "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]"
               For example:
               "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
               This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        :param _builtins.str name: The resource name of the bucket. For example: "organizations/my-organization-id/locations/my-location/buckets/my-bucket-id"
        :param _builtins.str service_account_id: The service account associated with a project for which CMEK will apply.
               Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_version_name is not None:
            pulumi.set(__self__, "kms_key_version_name", kms_key_version_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> _builtins.str:
        """
        The resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
        To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
        The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersionName")
    def kms_key_version_name(self) -> Optional[_builtins.str]:
        """
        The CryptoKeyVersion resource name for the configured Cloud KMS key.
        KMS key name format:
        "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]"
        For example:
        "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
        This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        """
        return pulumi.get(self, "kms_key_version_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The resource name of the bucket. For example: "organizations/my-organization-id/locations/my-location/buckets/my-bucket-id"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[_builtins.str]:
        """
        The service account associated with a project for which CMEK will apply.
        Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "service_account_id")


@pulumi.output_type
class OrganizationBucketConfigIndexConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldPath":
            suggest = "field_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrganizationBucketConfigIndexConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrganizationBucketConfigIndexConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrganizationBucketConfigIndexConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_path: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str field_path: The LogEntry field path to index.
               Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        :param _builtins.str type: The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
        pulumi.set(__self__, "field_path", field_path)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> _builtins.str:
        """
        The LogEntry field path to index.
        Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        """
        return pulumi.get(self, "field_path")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class OrganizationSinkBigqueryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "usePartitionedTables":
            suggest = "use_partitioned_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrganizationSinkBigqueryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrganizationSinkBigqueryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrganizationSinkBigqueryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_partitioned_tables: _builtins.bool):
        """
        :param _builtins.bool use_partitioned_tables: Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
               By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
               tables the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
               has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        pulumi.set(__self__, "use_partitioned_tables", use_partitioned_tables)

    @_builtins.property
    @pulumi.getter(name="usePartitionedTables")
    def use_partitioned_tables(self) -> _builtins.bool:
        """
        Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
        By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned
        tables the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
        has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        return pulumi.get(self, "use_partitioned_tables")


@pulumi.output_type
class OrganizationSinkExclusion(dict):
    def __init__(__self__, *,
                 filter: _builtins.str,
                 name: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 disabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str filter: An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param _builtins.str name: A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        :param _builtins.str description: A description of this exclusion.
        :param _builtins.bool disabled: If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> _builtins.str:
        """
        An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        A description of this exclusion.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[_builtins.bool]:
        """
        If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class ProjectBucketConfigCmekSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "kmsKeyVersionName":
            suggest = "kms_key_version_name"
        elif key == "serviceAccountId":
            suggest = "service_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectBucketConfigCmekSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectBucketConfigCmekSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectBucketConfigCmekSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: _builtins.str,
                 kms_key_version_name: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 service_account_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str kms_key_name: The resource name for the configured Cloud KMS key.
               KMS key name format:
               `'projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]'`
               To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
               The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        :param _builtins.str kms_key_version_name: The CryptoKeyVersion resource name for the configured Cloud KMS key.
               KMS key name format:
               `'projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]'`
               For example:
               "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
               This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        :param _builtins.str name: The resource name of the CMEK settings.
        :param _builtins.str service_account_id: The service account associated with a project for which CMEK will apply.
               Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
               See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_version_name is not None:
            pulumi.set(__self__, "kms_key_version_name", kms_key_version_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> _builtins.str:
        """
        The resource name for the configured Cloud KMS key.
        KMS key name format:
        `'projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]'`
        To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
        The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersionName")
    def kms_key_version_name(self) -> Optional[_builtins.str]:
        """
        The CryptoKeyVersion resource name for the configured Cloud KMS key.
        KMS key name format:
        `'projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]/cryptoKeyVersions/[VERSION]'`
        For example:
        "projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key/cryptoKeyVersions/1"
        This is a read-only field used to convey the specific configured CryptoKeyVersion of kms_key that has been configured. It will be populated in cases where the CMEK settings are bound to a single key version.
        """
        return pulumi.get(self, "kms_key_version_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The resource name of the CMEK settings.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[_builtins.str]:
        """
        The service account associated with a project for which CMEK will apply.
        Before enabling CMEK for a logging bucket, you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the service account associated with the project for which CMEK will apply. Use [v2.getCmekSettings](https://cloud.google.com/logging/docs/reference/v2/rest/v2/TopLevel/getCmekSettings#google.logging.v2.ConfigServiceV2.GetCmekSettings) to obtain the service account ID.
        See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
        """
        return pulumi.get(self, "service_account_id")


@pulumi.output_type
class ProjectBucketConfigIndexConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldPath":
            suggest = "field_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectBucketConfigIndexConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectBucketConfigIndexConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectBucketConfigIndexConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_path: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str field_path: The LogEntry field path to index.
               Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        :param _builtins.str type: The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
        pulumi.set(__self__, "field_path", field_path)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> _builtins.str:
        """
        The LogEntry field path to index.
        Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation](https://cloud.google.com/logging/docs/analyze/custom-index) for details.
        """
        return pulumi.get(self, "field_path")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of data in this index. Allowed types include `INDEX_TYPE_UNSPECIFIED`, `INDEX_TYPE_STRING` and `INDEX_TYPE_INTEGER`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ProjectSinkBigqueryOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "usePartitionedTables":
            suggest = "use_partitioned_tables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectSinkBigqueryOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectSinkBigqueryOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectSinkBigqueryOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_partitioned_tables: _builtins.bool):
        """
        :param _builtins.bool use_partitioned_tables: Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
               By default, Logging creates dated tables based on the log entries' timestamps, e.g. `syslog_20170523`. With partitioned
               tables the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
               has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        pulumi.set(__self__, "use_partitioned_tables", use_partitioned_tables)

    @_builtins.property
    @pulumi.getter(name="usePartitionedTables")
    def use_partitioned_tables(self) -> _builtins.bool:
        """
        Whether to use [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables).
        By default, Logging creates dated tables based on the log entries' timestamps, e.g. `syslog_20170523`. With partitioned
        tables the date suffix is no longer present and [special query syntax](https://cloud.google.com/bigquery/docs/querying-partitioned-tables)
        has to be used instead. In both cases, tables are sharded based on UTC timezone.
        """
        return pulumi.get(self, "use_partitioned_tables")


@pulumi.output_type
class ProjectSinkExclusion(dict):
    def __init__(__self__, *,
                 filter: _builtins.str,
                 name: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 disabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str filter: An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param _builtins.str name: A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        :param _builtins.str description: A description of this exclusion.
        :param _builtins.bool disabled: If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> _builtins.str:
        """
        An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries. See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A client-assigned identifier, such as `load-balancer-exclusion`. Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        A description of this exclusion.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[_builtins.bool]:
        """
        If set to True, then this exclusion is disabled and it does not exclude any log entries.
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class GetSinkBigqueryOptionResult(dict):
    def __init__(__self__, *,
                 use_partitioned_tables: _builtins.bool):
        """
        :param _builtins.bool use_partitioned_tables: Whether [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables) are used.
        """
        pulumi.set(__self__, "use_partitioned_tables", use_partitioned_tables)

    @_builtins.property
    @pulumi.getter(name="usePartitionedTables")
    def use_partitioned_tables(self) -> _builtins.bool:
        """
        Whether [BigQuery's partition tables](https://cloud.google.com/bigquery/docs/partitioned-tables) are used.
        """
        return pulumi.get(self, "use_partitioned_tables")


@pulumi.output_type
class GetSinkExclusionResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 disabled: _builtins.bool,
                 filter: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str description: A description of this exclusion.
        :param _builtins.bool disabled: Whether this exclusion is disabled and it does not exclude any log entries.
        :param _builtins.str filter: An advanced logs filter that matches the log entries to be excluded.
        :param _builtins.str name: A client-assigned identifier, such as `load-balancer-exclusion`.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A description of this exclusion.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> _builtins.bool:
        """
        Whether this exclusion is disabled and it does not exclude any log entries.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> _builtins.str:
        """
        An advanced logs filter that matches the log entries to be excluded.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A client-assigned identifier, such as `load-balancer-exclusion`.
        """
        return pulumi.get(self, "name")


