# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BackupArgs', 'Backup']

@pulumi.input_type
class BackupArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 vault_name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 source_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
                 source_volume: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Backup resource.
        :param pulumi.Input[_builtins.str] location: Location of the backup.
        :param pulumi.Input[_builtins.str] vault_name: Name of the backup vault to store the backup in.
        :param pulumi.Input[_builtins.str] description: A description of the backup with 2048 characters or less. Requests with longer descriptions will be rejected.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The resource name of the backup. Needs to be unique per location.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] source_snapshot: If specified, backup will be created from the given snapshot. If not specified,
               there will be a new snapshot taken to initiate the backup creation.
               Format: `projects/{{projectId}}/locations/{{location}}/volumes/{{volumename}}/snapshots/{{snapshotname}}``
        :param pulumi.Input[_builtins.str] source_volume: ID of volumes this backup belongs to. Format: `projects/{{projects_id}}/locations/{{location}}/volumes/{{name}}``
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "vault_name", vault_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if source_snapshot is not None:
            pulumi.set(__self__, "source_snapshot", source_snapshot)
        if source_volume is not None:
            pulumi.set(__self__, "source_volume", source_volume)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Location of the backup.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="vaultName")
    def vault_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the backup vault to store the backup in.
        """
        return pulumi.get(self, "vault_name")

    @vault_name.setter
    def vault_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the backup with 2048 characters or less. Requests with longer descriptions will be rejected.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the backup. Needs to be unique per location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If specified, backup will be created from the given snapshot. If not specified,
        there will be a new snapshot taken to initiate the backup creation.
        Format: `projects/{{projectId}}/locations/{{location}}/volumes/{{volumename}}/snapshots/{{snapshotname}}``
        """
        return pulumi.get(self, "source_snapshot")

    @source_snapshot.setter
    def source_snapshot(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="sourceVolume")
    def source_volume(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of volumes this backup belongs to. Format: `projects/{{projects_id}}/locations/{{location}}/volumes/{{name}}``
        """
        return pulumi.get(self, "source_volume")

    @source_volume.setter
    def source_volume(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_volume", value)


@pulumi.input_type
class _BackupState:
    def __init__(__self__, *,
                 backup_region: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_type: Optional[pulumi.Input[_builtins.str]] = None,
                 chain_storage_bytes: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 source_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
                 source_volume: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_name: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_region: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_usage_bytes: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Backup resources.
        :param pulumi.Input[_builtins.str] backup_region: Region in which backup is stored.
        :param pulumi.Input[_builtins.str] backup_type: Type of backup, manually created or created by a backup policy. Possible Values : [TYPE_UNSPECIFIED, MANUAL, SCHEDULED]
        :param pulumi.Input[_builtins.str] chain_storage_bytes: Backups of a volume build incrementally on top of each other. They form a "backup chain".
               Total size of all backups in a chain in bytes = baseline backup size + sum(incremental backup size)
        :param pulumi.Input[_builtins.str] create_time: Create time of the backup. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param pulumi.Input[_builtins.str] description: A description of the backup with 2048 characters or less. Requests with longer descriptions will be rejected.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location of the backup.
        :param pulumi.Input[_builtins.str] name: The resource name of the backup. Needs to be unique per location.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] source_snapshot: If specified, backup will be created from the given snapshot. If not specified,
               there will be a new snapshot taken to initiate the backup creation.
               Format: `projects/{{projectId}}/locations/{{location}}/volumes/{{volumename}}/snapshots/{{snapshotname}}``
        :param pulumi.Input[_builtins.str] source_volume: ID of volumes this backup belongs to. Format: `projects/{{projects_id}}/locations/{{location}}/volumes/{{name}}``
        :param pulumi.Input[_builtins.str] state: The state of the Backup Vault. Possible Values : [STATE_UNSPECIFIED, CREATING, UPLOADING, READY, DELETING, ERROR, UPDATING]
        :param pulumi.Input[_builtins.str] vault_name: Name of the backup vault to store the backup in.
        :param pulumi.Input[_builtins.str] volume_region: Region of the volume from which the backup was created.
        :param pulumi.Input[_builtins.str] volume_usage_bytes: Size of the file system when the backup was created. When creating a new volume from the backup, the volume capacity will have to be at least as big.
        """
        if backup_region is not None:
            pulumi.set(__self__, "backup_region", backup_region)
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if chain_storage_bytes is not None:
            pulumi.set(__self__, "chain_storage_bytes", chain_storage_bytes)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if source_snapshot is not None:
            pulumi.set(__self__, "source_snapshot", source_snapshot)
        if source_volume is not None:
            pulumi.set(__self__, "source_volume", source_volume)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if vault_name is not None:
            pulumi.set(__self__, "vault_name", vault_name)
        if volume_region is not None:
            pulumi.set(__self__, "volume_region", volume_region)
        if volume_usage_bytes is not None:
            pulumi.set(__self__, "volume_usage_bytes", volume_usage_bytes)

    @_builtins.property
    @pulumi.getter(name="backupRegion")
    def backup_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region in which backup is stored.
        """
        return pulumi.get(self, "backup_region")

    @backup_region.setter
    def backup_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_region", value)

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of backup, manually created or created by a backup policy. Possible Values : [TYPE_UNSPECIFIED, MANUAL, SCHEDULED]
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_type", value)

    @_builtins.property
    @pulumi.getter(name="chainStorageBytes")
    def chain_storage_bytes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backups of a volume build incrementally on top of each other. They form a "backup chain".
        Total size of all backups in a chain in bytes = baseline backup size + sum(incremental backup size)
        """
        return pulumi.get(self, "chain_storage_bytes")

    @chain_storage_bytes.setter
    def chain_storage_bytes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "chain_storage_bytes", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create time of the backup. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the backup with 2048 characters or less. Requests with longer descriptions will be rejected.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Location of the backup.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the backup. Needs to be unique per location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If specified, backup will be created from the given snapshot. If not specified,
        there will be a new snapshot taken to initiate the backup creation.
        Format: `projects/{{projectId}}/locations/{{location}}/volumes/{{volumename}}/snapshots/{{snapshotname}}``
        """
        return pulumi.get(self, "source_snapshot")

    @source_snapshot.setter
    def source_snapshot(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="sourceVolume")
    def source_volume(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of volumes this backup belongs to. Format: `projects/{{projects_id}}/locations/{{location}}/volumes/{{name}}``
        """
        return pulumi.get(self, "source_volume")

    @source_volume.setter
    def source_volume(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_volume", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the Backup Vault. Possible Values : [STATE_UNSPECIFIED, CREATING, UPLOADING, READY, DELETING, ERROR, UPDATING]
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="vaultName")
    def vault_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the backup vault to store the backup in.
        """
        return pulumi.get(self, "vault_name")

    @vault_name.setter
    def vault_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_name", value)

    @_builtins.property
    @pulumi.getter(name="volumeRegion")
    def volume_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region of the volume from which the backup was created.
        """
        return pulumi.get(self, "volume_region")

    @volume_region.setter
    def volume_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_region", value)

    @_builtins.property
    @pulumi.getter(name="volumeUsageBytes")
    def volume_usage_bytes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Size of the file system when the backup was created. When creating a new volume from the backup, the volume capacity will have to be at least as big.
        """
        return pulumi.get(self, "volume_usage_bytes")

    @volume_usage_bytes.setter
    def volume_usage_bytes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_usage_bytes", value)


@pulumi.type_token("gcp:netapp/backup:Backup")
class Backup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 source_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
                 source_volume: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        NetApp Volumes supports volume backups, which are copies of your volumes
        stored independently from the volume. Backups are stored in backup vaults,
        which are containers for backups. If a volume is lost or deleted, you can
        use backups to restore your data to a new volume.

        When you create the first backup of a volume, all of the volume's used
        data is sent to the backup vault. Subsequent backups of the same volume
        only include data that has changed from the previous backup. This allows
        for fast incremental-forever backups and reduces the required capacity
        inside the backup vault.

        You can create manual and scheduled backups. Manual backups can be taken
        from a volume or from an existing volume snapshot. Scheduled backups
        require a backup policy.

        To get more information about Backup, see:

        * [API documentation](https://cloud.google.com/netapp/volumes/docs/reference/rest/v1/projects.locations.backupVaults.backups)
        * How-to Guides
            * [Documentation](https://cloud.google.com/netapp/volumes/docs/protect-data/about-volume-backups)

        ## Example Usage

        ### Netapp Backup

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_network(name="network")
        default_storage_pool = gcp.netapp.StoragePool("default",
            name="backup-pool",
            location="us-central1",
            service_level="PREMIUM",
            capacity_gib="2048",
            network=default.id)
        default_backup_vault = gcp.netapp.BackupVault("default",
            name="backup-vault",
            location=default_storage_pool.location)
        default_volume = gcp.netapp.Volume("default",
            name="backup-volume",
            location=default_storage_pool.location,
            capacity_gib="100",
            share_name="backup-volume",
            storage_pool=default_storage_pool.name,
            protocols=["NFSV3"],
            deletion_policy="FORCE",
            backup_config={
                "backup_vault": default_backup_vault.id,
            })
        test_backup = gcp.netapp.Backup("test_backup",
            name="test-backup",
            location=default_backup_vault.location,
            vault_name=default_backup_vault.name,
            source_volume=default_volume.id)
        ```

        ## Import

        Backup can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backupVaults/{{vault_name}}/backups/{{name}}`

        * `{{project}}/{{location}}/{{vault_name}}/{{name}}`

        * `{{location}}/{{vault_name}}/{{name}}`

        When using the `pulumi import` command, Backup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:netapp/backup:Backup default projects/{{project}}/locations/{{location}}/backupVaults/{{vault_name}}/backups/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/backup:Backup default {{project}}/{{location}}/{{vault_name}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/backup:Backup default {{location}}/{{vault_name}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description of the backup with 2048 characters or less. Requests with longer descriptions will be rejected.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location of the backup.
        :param pulumi.Input[_builtins.str] name: The resource name of the backup. Needs to be unique per location.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] source_snapshot: If specified, backup will be created from the given snapshot. If not specified,
               there will be a new snapshot taken to initiate the backup creation.
               Format: `projects/{{projectId}}/locations/{{location}}/volumes/{{volumename}}/snapshots/{{snapshotname}}``
        :param pulumi.Input[_builtins.str] source_volume: ID of volumes this backup belongs to. Format: `projects/{{projects_id}}/locations/{{location}}/volumes/{{name}}``
        :param pulumi.Input[_builtins.str] vault_name: Name of the backup vault to store the backup in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        NetApp Volumes supports volume backups, which are copies of your volumes
        stored independently from the volume. Backups are stored in backup vaults,
        which are containers for backups. If a volume is lost or deleted, you can
        use backups to restore your data to a new volume.

        When you create the first backup of a volume, all of the volume's used
        data is sent to the backup vault. Subsequent backups of the same volume
        only include data that has changed from the previous backup. This allows
        for fast incremental-forever backups and reduces the required capacity
        inside the backup vault.

        You can create manual and scheduled backups. Manual backups can be taken
        from a volume or from an existing volume snapshot. Scheduled backups
        require a backup policy.

        To get more information about Backup, see:

        * [API documentation](https://cloud.google.com/netapp/volumes/docs/reference/rest/v1/projects.locations.backupVaults.backups)
        * How-to Guides
            * [Documentation](https://cloud.google.com/netapp/volumes/docs/protect-data/about-volume-backups)

        ## Example Usage

        ### Netapp Backup

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.get_network(name="network")
        default_storage_pool = gcp.netapp.StoragePool("default",
            name="backup-pool",
            location="us-central1",
            service_level="PREMIUM",
            capacity_gib="2048",
            network=default.id)
        default_backup_vault = gcp.netapp.BackupVault("default",
            name="backup-vault",
            location=default_storage_pool.location)
        default_volume = gcp.netapp.Volume("default",
            name="backup-volume",
            location=default_storage_pool.location,
            capacity_gib="100",
            share_name="backup-volume",
            storage_pool=default_storage_pool.name,
            protocols=["NFSV3"],
            deletion_policy="FORCE",
            backup_config={
                "backup_vault": default_backup_vault.id,
            })
        test_backup = gcp.netapp.Backup("test_backup",
            name="test-backup",
            location=default_backup_vault.location,
            vault_name=default_backup_vault.name,
            source_volume=default_volume.id)
        ```

        ## Import

        Backup can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backupVaults/{{vault_name}}/backups/{{name}}`

        * `{{project}}/{{location}}/{{vault_name}}/{{name}}`

        * `{{location}}/{{vault_name}}/{{name}}`

        When using the `pulumi import` command, Backup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:netapp/backup:Backup default projects/{{project}}/locations/{{location}}/backupVaults/{{vault_name}}/backups/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/backup:Backup default {{project}}/{{location}}/{{vault_name}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:netapp/backup:Backup default {{location}}/{{vault_name}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param BackupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 source_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
                 source_volume: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupArgs.__new__(BackupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["source_snapshot"] = source_snapshot
            __props__.__dict__["source_volume"] = source_volume
            if vault_name is None and not opts.urn:
                raise TypeError("Missing required property 'vault_name'")
            __props__.__dict__["vault_name"] = vault_name
            __props__.__dict__["backup_region"] = None
            __props__.__dict__["backup_type"] = None
            __props__.__dict__["chain_storage_bytes"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["volume_region"] = None
            __props__.__dict__["volume_usage_bytes"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Backup, __self__).__init__(
            'gcp:netapp/backup:Backup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_region: Optional[pulumi.Input[_builtins.str]] = None,
            backup_type: Optional[pulumi.Input[_builtins.str]] = None,
            chain_storage_bytes: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            source_snapshot: Optional[pulumi.Input[_builtins.str]] = None,
            source_volume: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            vault_name: Optional[pulumi.Input[_builtins.str]] = None,
            volume_region: Optional[pulumi.Input[_builtins.str]] = None,
            volume_usage_bytes: Optional[pulumi.Input[_builtins.str]] = None) -> 'Backup':
        """
        Get an existing Backup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_region: Region in which backup is stored.
        :param pulumi.Input[_builtins.str] backup_type: Type of backup, manually created or created by a backup policy. Possible Values : [TYPE_UNSPECIFIED, MANUAL, SCHEDULED]
        :param pulumi.Input[_builtins.str] chain_storage_bytes: Backups of a volume build incrementally on top of each other. They form a "backup chain".
               Total size of all backups in a chain in bytes = baseline backup size + sum(incremental backup size)
        :param pulumi.Input[_builtins.str] create_time: Create time of the backup. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        :param pulumi.Input[_builtins.str] description: A description of the backup with 2048 characters or less. Requests with longer descriptions will be rejected.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location of the backup.
        :param pulumi.Input[_builtins.str] name: The resource name of the backup. Needs to be unique per location.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] source_snapshot: If specified, backup will be created from the given snapshot. If not specified,
               there will be a new snapshot taken to initiate the backup creation.
               Format: `projects/{{projectId}}/locations/{{location}}/volumes/{{volumename}}/snapshots/{{snapshotname}}``
        :param pulumi.Input[_builtins.str] source_volume: ID of volumes this backup belongs to. Format: `projects/{{projects_id}}/locations/{{location}}/volumes/{{name}}``
        :param pulumi.Input[_builtins.str] state: The state of the Backup Vault. Possible Values : [STATE_UNSPECIFIED, CREATING, UPLOADING, READY, DELETING, ERROR, UPDATING]
        :param pulumi.Input[_builtins.str] vault_name: Name of the backup vault to store the backup in.
        :param pulumi.Input[_builtins.str] volume_region: Region of the volume from which the backup was created.
        :param pulumi.Input[_builtins.str] volume_usage_bytes: Size of the file system when the backup was created. When creating a new volume from the backup, the volume capacity will have to be at least as big.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupState.__new__(_BackupState)

        __props__.__dict__["backup_region"] = backup_region
        __props__.__dict__["backup_type"] = backup_type
        __props__.__dict__["chain_storage_bytes"] = chain_storage_bytes
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["source_snapshot"] = source_snapshot
        __props__.__dict__["source_volume"] = source_volume
        __props__.__dict__["state"] = state
        __props__.__dict__["vault_name"] = vault_name
        __props__.__dict__["volume_region"] = volume_region
        __props__.__dict__["volume_usage_bytes"] = volume_usage_bytes
        return Backup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupRegion")
    def backup_region(self) -> pulumi.Output[_builtins.str]:
        """
        Region in which backup is stored.
        """
        return pulumi.get(self, "backup_region")

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of backup, manually created or created by a backup policy. Possible Values : [TYPE_UNSPECIFIED, MANUAL, SCHEDULED]
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="chainStorageBytes")
    def chain_storage_bytes(self) -> pulumi.Output[_builtins.str]:
        """
        Backups of a volume build incrementally on top of each other. They form a "backup chain".
        Total size of all backups in a chain in bytes = baseline backup size + sum(incremental backup size)
        """
        return pulumi.get(self, "chain_storage_bytes")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Create time of the backup. A timestamp in RFC3339 UTC "Zulu" format. Examples: "2023-06-22T09:13:01.617Z".
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the backup with 2048 characters or less. Requests with longer descriptions will be rejected.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels as key value pairs. Example: `{ "owner": "Bob", "department": "finance", "purpose": "testing" }`.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Location of the backup.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the backup. Needs to be unique per location.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If specified, backup will be created from the given snapshot. If not specified,
        there will be a new snapshot taken to initiate the backup creation.
        Format: `projects/{{projectId}}/locations/{{location}}/volumes/{{volumename}}/snapshots/{{snapshotname}}``
        """
        return pulumi.get(self, "source_snapshot")

    @_builtins.property
    @pulumi.getter(name="sourceVolume")
    def source_volume(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of volumes this backup belongs to. Format: `projects/{{projects_id}}/locations/{{location}}/volumes/{{name}}``
        """
        return pulumi.get(self, "source_volume")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The state of the Backup Vault. Possible Values : [STATE_UNSPECIFIED, CREATING, UPLOADING, READY, DELETING, ERROR, UPDATING]
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="vaultName")
    def vault_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the backup vault to store the backup in.
        """
        return pulumi.get(self, "vault_name")

    @_builtins.property
    @pulumi.getter(name="volumeRegion")
    def volume_region(self) -> pulumi.Output[_builtins.str]:
        """
        Region of the volume from which the backup was created.
        """
        return pulumi.get(self, "volume_region")

    @_builtins.property
    @pulumi.getter(name="volumeUsageBytes")
    def volume_usage_bytes(self) -> pulumi.Output[_builtins.str]:
        """
        Size of the file system when the backup was created. When creating a new volume from the backup, the volume capacity will have to be at least as big.
        """
        return pulumi.get(self, "volume_usage_bytes")

