# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthzPolicyArgs', 'AuthzPolicy']

@pulumi.input_type
class AuthzPolicyArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 target: pulumi.Input['AuthzPolicyTargetArgs'],
                 custom_provider: Optional[pulumi.Input['AuthzPolicyCustomProviderArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 http_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AuthzPolicyHttpRuleArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AuthzPolicy resource.
        :param pulumi.Input[_builtins.str] action: When the action is CUSTOM, customProvider must be specified.
               When the action is ALLOW, only requests matching the policy will be allowed.
               When the action is DENY, only requests matching the policy will be denied.
               When a request arrives, the policies are evaluated in the following order:
               1. If there is a CUSTOM policy that matches the request, the CUSTOM policy is evaluated using the custom authorization providers and the request is denied if the provider rejects the request.
               2. If there are any DENY policies that match the request, the request is denied.
               3. If there are no ALLOW policies for the resource or if any of the ALLOW policies match the request, the request is allowed.
               4. Else the request is denied by default if none of the configured AuthzPolicies with ALLOW action match the request.
               Possible values are: `ALLOW`, `DENY`, `CUSTOM`.
        :param pulumi.Input[_builtins.str] location: The location of the resource.
        :param pulumi.Input['AuthzPolicyTargetArgs'] target: Specifies the set of resources to which this policy should be applied to.
               Structure is documented below.
        :param pulumi.Input['AuthzPolicyCustomProviderArgs'] custom_provider: Required if the action is CUSTOM. Allows delegating authorization decisions to Cloud IAP or to Service Extensions. One of cloudIap or authzExtension must be specified.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['AuthzPolicyHttpRuleArgs']]] http_rules: A list of authorization HTTP rules to match against the incoming request.A policy match occurs when at least one HTTP rule matches the request or when no HTTP rules are specified in the policy. At least one HTTP Rule is required for Allow or Deny Action.
               Limited to 5 rules.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of labels associated with the AuthzExtension resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Identifier. Name of the AuthzPolicy resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "target", target)
        if custom_provider is not None:
            pulumi.set(__self__, "custom_provider", custom_provider)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if http_rules is not None:
            pulumi.set(__self__, "http_rules", http_rules)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        When the action is CUSTOM, customProvider must be specified.
        When the action is ALLOW, only requests matching the policy will be allowed.
        When the action is DENY, only requests matching the policy will be denied.
        When a request arrives, the policies are evaluated in the following order:
        1. If there is a CUSTOM policy that matches the request, the CUSTOM policy is evaluated using the custom authorization providers and the request is denied if the provider rejects the request.
        2. If there are any DENY policies that match the request, the request is denied.
        3. If there are no ALLOW policies for the resource or if any of the ALLOW policies match the request, the request is allowed.
        4. Else the request is denied by default if none of the configured AuthzPolicies with ALLOW action match the request.
        Possible values are: `ALLOW`, `DENY`, `CUSTOM`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Input['AuthzPolicyTargetArgs']:
        """
        Specifies the set of resources to which this policy should be applied to.
        Structure is documented below.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input['AuthzPolicyTargetArgs']):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="customProvider")
    def custom_provider(self) -> Optional[pulumi.Input['AuthzPolicyCustomProviderArgs']]:
        """
        Required if the action is CUSTOM. Allows delegating authorization decisions to Cloud IAP or to Service Extensions. One of cloudIap or authzExtension must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_provider")

    @custom_provider.setter
    def custom_provider(self, value: Optional[pulumi.Input['AuthzPolicyCustomProviderArgs']]):
        pulumi.set(self, "custom_provider", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="httpRules")
    def http_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthzPolicyHttpRuleArgs']]]]:
        """
        A list of authorization HTTP rules to match against the incoming request.A policy match occurs when at least one HTTP rule matches the request or when no HTTP rules are specified in the policy. At least one HTTP Rule is required for Allow or Deny Action.
        Limited to 5 rules.
        Structure is documented below.
        """
        return pulumi.get(self, "http_rules")

    @http_rules.setter
    def http_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthzPolicyHttpRuleArgs']]]]):
        pulumi.set(self, "http_rules", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of labels associated with the AuthzExtension resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. Name of the AuthzPolicy resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _AuthzPolicyState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_provider: Optional[pulumi.Input['AuthzPolicyCustomProviderArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 http_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AuthzPolicyHttpRuleArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target: Optional[pulumi.Input['AuthzPolicyTargetArgs']] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthzPolicy resources.
        :param pulumi.Input[_builtins.str] action: When the action is CUSTOM, customProvider must be specified.
               When the action is ALLOW, only requests matching the policy will be allowed.
               When the action is DENY, only requests matching the policy will be denied.
               When a request arrives, the policies are evaluated in the following order:
               1. If there is a CUSTOM policy that matches the request, the CUSTOM policy is evaluated using the custom authorization providers and the request is denied if the provider rejects the request.
               2. If there are any DENY policies that match the request, the request is denied.
               3. If there are no ALLOW policies for the resource or if any of the ALLOW policies match the request, the request is allowed.
               4. Else the request is denied by default if none of the configured AuthzPolicies with ALLOW action match the request.
               Possible values are: `ALLOW`, `DENY`, `CUSTOM`.
        :param pulumi.Input[_builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input['AuthzPolicyCustomProviderArgs'] custom_provider: Required if the action is CUSTOM. Allows delegating authorization decisions to Cloud IAP or to Service Extensions. One of cloudIap or authzExtension must be specified.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input['AuthzPolicyHttpRuleArgs']]] http_rules: A list of authorization HTTP rules to match against the incoming request.A policy match occurs when at least one HTTP rule matches the request or when no HTTP rules are specified in the policy. At least one HTTP Rule is required for Allow or Deny Action.
               Limited to 5 rules.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of labels associated with the AuthzExtension resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the resource.
        :param pulumi.Input[_builtins.str] name: Identifier. Name of the AuthzPolicy resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['AuthzPolicyTargetArgs'] target: Specifies the set of resources to which this policy should be applied to.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: The timestamp when the resource was updated.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if custom_provider is not None:
            pulumi.set(__self__, "custom_provider", custom_provider)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if http_rules is not None:
            pulumi.set(__self__, "http_rules", http_rules)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When the action is CUSTOM, customProvider must be specified.
        When the action is ALLOW, only requests matching the policy will be allowed.
        When the action is DENY, only requests matching the policy will be denied.
        When a request arrives, the policies are evaluated in the following order:
        1. If there is a CUSTOM policy that matches the request, the CUSTOM policy is evaluated using the custom authorization providers and the request is denied if the provider rejects the request.
        2. If there are any DENY policies that match the request, the request is denied.
        3. If there are no ALLOW policies for the resource or if any of the ALLOW policies match the request, the request is allowed.
        4. Else the request is denied by default if none of the configured AuthzPolicies with ALLOW action match the request.
        Possible values are: `ALLOW`, `DENY`, `CUSTOM`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="customProvider")
    def custom_provider(self) -> Optional[pulumi.Input['AuthzPolicyCustomProviderArgs']]:
        """
        Required if the action is CUSTOM. Allows delegating authorization decisions to Cloud IAP or to Service Extensions. One of cloudIap or authzExtension must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_provider")

    @custom_provider.setter
    def custom_provider(self, value: Optional[pulumi.Input['AuthzPolicyCustomProviderArgs']]):
        pulumi.set(self, "custom_provider", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="httpRules")
    def http_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthzPolicyHttpRuleArgs']]]]:
        """
        A list of authorization HTTP rules to match against the incoming request.A policy match occurs when at least one HTTP rule matches the request or when no HTTP rules are specified in the policy. At least one HTTP Rule is required for Allow or Deny Action.
        Limited to 5 rules.
        Structure is documented below.
        """
        return pulumi.get(self, "http_rules")

    @http_rules.setter
    def http_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthzPolicyHttpRuleArgs']]]]):
        pulumi.set(self, "http_rules", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of labels associated with the AuthzExtension resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. Name of the AuthzPolicy resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['AuthzPolicyTargetArgs']]:
        """
        Specifies the set of resources to which this policy should be applied to.
        Structure is documented below.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['AuthzPolicyTargetArgs']]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the resource was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:networksecurity/authzPolicy:AuthzPolicy")
class AuthzPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_provider: Optional[pulumi.Input[Union['AuthzPolicyCustomProviderArgs', 'AuthzPolicyCustomProviderArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 http_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthzPolicyHttpRuleArgs', 'AuthzPolicyHttpRuleArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[Union['AuthzPolicyTargetArgs', 'AuthzPolicyTargetArgsDict']]] = None,
                 __props__=None):
        """
        AuthzPolicy is a resource that allows to forward traffic to a callout backend designed to scan the traffic for security purposes.

        To get more information about AuthzPolicy, see:

        * [API documentation](https://cloud.google.com/load-balancing/docs/reference/network-security/rest/v1beta1/projects.locations.authzPolicies)

        ## Example Usage

        ## Import

        AuthzPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/authzPolicies/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, AuthzPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/authzPolicy:AuthzPolicy default projects/{{project}}/locations/{{location}}/authzPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/authzPolicy:AuthzPolicy default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/authzPolicy:AuthzPolicy default {{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/authzPolicy:AuthzPolicy default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: When the action is CUSTOM, customProvider must be specified.
               When the action is ALLOW, only requests matching the policy will be allowed.
               When the action is DENY, only requests matching the policy will be denied.
               When a request arrives, the policies are evaluated in the following order:
               1. If there is a CUSTOM policy that matches the request, the CUSTOM policy is evaluated using the custom authorization providers and the request is denied if the provider rejects the request.
               2. If there are any DENY policies that match the request, the request is denied.
               3. If there are no ALLOW policies for the resource or if any of the ALLOW policies match the request, the request is allowed.
               4. Else the request is denied by default if none of the configured AuthzPolicies with ALLOW action match the request.
               Possible values are: `ALLOW`, `DENY`, `CUSTOM`.
        :param pulumi.Input[Union['AuthzPolicyCustomProviderArgs', 'AuthzPolicyCustomProviderArgsDict']] custom_provider: Required if the action is CUSTOM. Allows delegating authorization decisions to Cloud IAP or to Service Extensions. One of cloudIap or authzExtension must be specified.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthzPolicyHttpRuleArgs', 'AuthzPolicyHttpRuleArgsDict']]]] http_rules: A list of authorization HTTP rules to match against the incoming request.A policy match occurs when at least one HTTP rule matches the request or when no HTTP rules are specified in the policy. At least one HTTP Rule is required for Allow or Deny Action.
               Limited to 5 rules.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of labels associated with the AuthzExtension resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the resource.
        :param pulumi.Input[_builtins.str] name: Identifier. Name of the AuthzPolicy resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['AuthzPolicyTargetArgs', 'AuthzPolicyTargetArgsDict']] target: Specifies the set of resources to which this policy should be applied to.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthzPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AuthzPolicy is a resource that allows to forward traffic to a callout backend designed to scan the traffic for security purposes.

        To get more information about AuthzPolicy, see:

        * [API documentation](https://cloud.google.com/load-balancing/docs/reference/network-security/rest/v1beta1/projects.locations.authzPolicies)

        ## Example Usage

        ## Import

        AuthzPolicy can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/authzPolicies/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, AuthzPolicy can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networksecurity/authzPolicy:AuthzPolicy default projects/{{project}}/locations/{{location}}/authzPolicies/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/authzPolicy:AuthzPolicy default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/authzPolicy:AuthzPolicy default {{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networksecurity/authzPolicy:AuthzPolicy default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AuthzPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthzPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_provider: Optional[pulumi.Input[Union['AuthzPolicyCustomProviderArgs', 'AuthzPolicyCustomProviderArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 http_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthzPolicyHttpRuleArgs', 'AuthzPolicyHttpRuleArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 target: Optional[pulumi.Input[Union['AuthzPolicyTargetArgs', 'AuthzPolicyTargetArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthzPolicyArgs.__new__(AuthzPolicyArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["custom_provider"] = custom_provider
            __props__.__dict__["description"] = description
            __props__.__dict__["http_rules"] = http_rules
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if target is None and not opts.urn:
                raise TypeError("Missing required property 'target'")
            __props__.__dict__["target"] = target
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AuthzPolicy, __self__).__init__(
            'gcp:networksecurity/authzPolicy:AuthzPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            custom_provider: Optional[pulumi.Input[Union['AuthzPolicyCustomProviderArgs', 'AuthzPolicyCustomProviderArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            http_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AuthzPolicyHttpRuleArgs', 'AuthzPolicyHttpRuleArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target: Optional[pulumi.Input[Union['AuthzPolicyTargetArgs', 'AuthzPolicyTargetArgsDict']]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuthzPolicy':
        """
        Get an existing AuthzPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: When the action is CUSTOM, customProvider must be specified.
               When the action is ALLOW, only requests matching the policy will be allowed.
               When the action is DENY, only requests matching the policy will be denied.
               When a request arrives, the policies are evaluated in the following order:
               1. If there is a CUSTOM policy that matches the request, the CUSTOM policy is evaluated using the custom authorization providers and the request is denied if the provider rejects the request.
               2. If there are any DENY policies that match the request, the request is denied.
               3. If there are no ALLOW policies for the resource or if any of the ALLOW policies match the request, the request is allowed.
               4. Else the request is denied by default if none of the configured AuthzPolicies with ALLOW action match the request.
               Possible values are: `ALLOW`, `DENY`, `CUSTOM`.
        :param pulumi.Input[_builtins.str] create_time: The timestamp when the resource was created.
        :param pulumi.Input[Union['AuthzPolicyCustomProviderArgs', 'AuthzPolicyCustomProviderArgsDict']] custom_provider: Required if the action is CUSTOM. Allows delegating authorization decisions to Cloud IAP or to Service Extensions. One of cloudIap or authzExtension must be specified.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AuthzPolicyHttpRuleArgs', 'AuthzPolicyHttpRuleArgsDict']]]] http_rules: A list of authorization HTTP rules to match against the incoming request.A policy match occurs when at least one HTTP rule matches the request or when no HTTP rules are specified in the policy. At least one HTTP Rule is required for Allow or Deny Action.
               Limited to 5 rules.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of labels associated with the AuthzExtension resource.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location of the resource.
        :param pulumi.Input[_builtins.str] name: Identifier. Name of the AuthzPolicy resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['AuthzPolicyTargetArgs', 'AuthzPolicyTargetArgsDict']] target: Specifies the set of resources to which this policy should be applied to.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: The timestamp when the resource was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthzPolicyState.__new__(_AuthzPolicyState)

        __props__.__dict__["action"] = action
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["custom_provider"] = custom_provider
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["http_rules"] = http_rules
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["target"] = target
        __props__.__dict__["update_time"] = update_time
        return AuthzPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        When the action is CUSTOM, customProvider must be specified.
        When the action is ALLOW, only requests matching the policy will be allowed.
        When the action is DENY, only requests matching the policy will be denied.
        When a request arrives, the policies are evaluated in the following order:
        1. If there is a CUSTOM policy that matches the request, the CUSTOM policy is evaluated using the custom authorization providers and the request is denied if the provider rejects the request.
        2. If there are any DENY policies that match the request, the request is denied.
        3. If there are no ALLOW policies for the resource or if any of the ALLOW policies match the request, the request is allowed.
        4. Else the request is denied by default if none of the configured AuthzPolicies with ALLOW action match the request.
        Possible values are: `ALLOW`, `DENY`, `CUSTOM`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="customProvider")
    def custom_provider(self) -> pulumi.Output[Optional['outputs.AuthzPolicyCustomProvider']]:
        """
        Required if the action is CUSTOM. Allows delegating authorization decisions to Cloud IAP or to Service Extensions. One of cloudIap or authzExtension must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "custom_provider")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="httpRules")
    def http_rules(self) -> pulumi.Output[Optional[Sequence['outputs.AuthzPolicyHttpRule']]]:
        """
        A list of authorization HTTP rules to match against the incoming request.A policy match occurs when at least one HTTP rule matches the request or when no HTTP rules are specified in the policy. At least one HTTP Rule is required for Allow or Deny Action.
        Limited to 5 rules.
        Structure is documented below.
        """
        return pulumi.get(self, "http_rules")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Set of labels associated with the AuthzExtension resource.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the resource.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. Name of the AuthzPolicy resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Output['outputs.AuthzPolicyTarget']:
        """
        Specifies the set of resources to which this policy should be applied to.
        Structure is documented below.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the resource was updated.
        """
        return pulumi.get(self, "update_time")

