# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAutonomousDatabasesResult',
    'AwaitableGetAutonomousDatabasesResult',
    'get_autonomous_databases',
    'get_autonomous_databases_output',
]

@pulumi.output_type
class GetAutonomousDatabasesResult:
    """
    A collection of values returned by getAutonomousDatabases.
    """
    def __init__(__self__, autonomous_databases=None, id=None, location=None, project=None):
        if autonomous_databases and not isinstance(autonomous_databases, list):
            raise TypeError("Expected argument 'autonomous_databases' to be a list")
        pulumi.set(__self__, "autonomous_databases", autonomous_databases)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabases")
    def autonomous_databases(self) -> Sequence['outputs.GetAutonomousDatabasesAutonomousDatabaseResult']:
        return pulumi.get(self, "autonomous_databases")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")


class AwaitableGetAutonomousDatabasesResult(GetAutonomousDatabasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDatabasesResult(
            autonomous_databases=self.autonomous_databases,
            id=self.id,
            location=self.location,
            project=self.project)


def get_autonomous_databases(location: Optional[_builtins.str] = None,
                             project: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDatabasesResult:
    """
    List all AutonomousDatabases.

    For more information see the
    [API](https://cloud.google.com/oracle/database/docs/reference/rest/v1/projects.locations.autonomousDatabases).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_adbs = gcp.oracledatabase.get_autonomous_databases(location="us-east4")
    ```


    :param _builtins.str location: The location of the resource.
           
           - - -
    :param _builtins.str project: The project to which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:oracledatabase/getAutonomousDatabases:getAutonomousDatabases', __args__, opts=opts, typ=GetAutonomousDatabasesResult).value

    return AwaitableGetAutonomousDatabasesResult(
        autonomous_databases=pulumi.get(__ret__, 'autonomous_databases'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        project=pulumi.get(__ret__, 'project'))
def get_autonomous_databases_output(location: Optional[pulumi.Input[_builtins.str]] = None,
                                    project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousDatabasesResult]:
    """
    List all AutonomousDatabases.

    For more information see the
    [API](https://cloud.google.com/oracle/database/docs/reference/rest/v1/projects.locations.autonomousDatabases).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_adbs = gcp.oracledatabase.get_autonomous_databases(location="us-east4")
    ```


    :param _builtins.str location: The location of the resource.
           
           - - -
    :param _builtins.str project: The project to which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:oracledatabase/getAutonomousDatabases:getAutonomousDatabases', __args__, opts=opts, typ=GetAutonomousDatabasesResult)
    return __ret__.apply(lambda __response__: GetAutonomousDatabasesResult(
        autonomous_databases=pulumi.get(__response__, 'autonomous_databases'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        project=pulumi.get(__response__, 'project')))
