# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCloudVmClustersResult',
    'AwaitableGetCloudVmClustersResult',
    'get_cloud_vm_clusters',
    'get_cloud_vm_clusters_output',
]

@pulumi.output_type
class GetCloudVmClustersResult:
    """
    A collection of values returned by getCloudVmClusters.
    """
    def __init__(__self__, cloud_vm_clusters=None, id=None, location=None, project=None):
        if cloud_vm_clusters and not isinstance(cloud_vm_clusters, list):
            raise TypeError("Expected argument 'cloud_vm_clusters' to be a list")
        pulumi.set(__self__, "cloud_vm_clusters", cloud_vm_clusters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="cloudVmClusters")
    def cloud_vm_clusters(self) -> Sequence['outputs.GetCloudVmClustersCloudVmClusterResult']:
        return pulumi.get(self, "cloud_vm_clusters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")


class AwaitableGetCloudVmClustersResult(GetCloudVmClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudVmClustersResult(
            cloud_vm_clusters=self.cloud_vm_clusters,
            id=self.id,
            location=self.location,
            project=self.project)


def get_cloud_vm_clusters(location: Optional[_builtins.str] = None,
                          project: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudVmClustersResult:
    """
    List all CloudVmClusters.

    For more information see the
    [API](https://cloud.google.com/oracle/database/docs/reference/rest/v1/projects.locations.cloudVmClusters).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_vmclusters = gcp.oracledatabase.get_cloud_vm_clusters(location="us-east4")
    ```


    :param _builtins.str location: The location of the resource.
           
           - - -
    :param _builtins.str project: The project to which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:oracledatabase/getCloudVmClusters:getCloudVmClusters', __args__, opts=opts, typ=GetCloudVmClustersResult).value

    return AwaitableGetCloudVmClustersResult(
        cloud_vm_clusters=pulumi.get(__ret__, 'cloud_vm_clusters'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        project=pulumi.get(__ret__, 'project'))
def get_cloud_vm_clusters_output(location: Optional[pulumi.Input[_builtins.str]] = None,
                                 project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudVmClustersResult]:
    """
    List all CloudVmClusters.

    For more information see the
    [API](https://cloud.google.com/oracle/database/docs/reference/rest/v1/projects.locations.cloudVmClusters).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_vmclusters = gcp.oracledatabase.get_cloud_vm_clusters(location="us-east4")
    ```


    :param _builtins.str location: The location of the resource.
           
           - - -
    :param _builtins.str project: The project to which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:oracledatabase/getCloudVmClusters:getCloudVmClusters', __args__, opts=opts, typ=GetCloudVmClustersResult)
    return __ret__.apply(lambda __response__: GetCloudVmClustersResult(
        cloud_vm_clusters=pulumi.get(__response__, 'cloud_vm_clusters'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        project=pulumi.get(__response__, 'project')))
