# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OdbSubnetArgs', 'OdbSubnet']

@pulumi.input_type
class OdbSubnetArgs:
    def __init__(__self__, *,
                 cidr_range: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 odb_subnet_id: pulumi.Input[_builtins.str],
                 odbnetwork: pulumi.Input[_builtins.str],
                 purpose: pulumi.Input[_builtins.str],
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OdbSubnet resource.
        :param pulumi.Input[_builtins.str] cidr_range: The CIDR range of the subnet.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] odb_subnet_id: The ID of the OdbSubnet to create. This value is restricted
               to (^a-z?$) and must be a maximum of 63
               characters in length. The value must start with a letter and end with
               a letter or a number.
        :param pulumi.Input[_builtins.str] odbnetwork: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] purpose: Purpose of the subnet.
               Possible values:
               CLIENT_SUBNET
               BACKUP_SUBNET
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels or tags associated with the resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "cidr_range", cidr_range)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "odb_subnet_id", odb_subnet_id)
        pulumi.set(__self__, "odbnetwork", odbnetwork)
        pulumi.set(__self__, "purpose", purpose)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="cidrRange")
    def cidr_range(self) -> pulumi.Input[_builtins.str]:
        """
        The CIDR range of the subnet.
        """
        return pulumi.get(self, "cidr_range")

    @cidr_range.setter
    def cidr_range(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cidr_range", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="odbSubnetId")
    def odb_subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the OdbSubnet to create. This value is restricted
        to (^a-z?$) and must be a maximum of 63
        characters in length. The value must start with a letter and end with
        a letter or a number.
        """
        return pulumi.get(self, "odb_subnet_id")

    @odb_subnet_id.setter
    def odb_subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "odb_subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def odbnetwork(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "odbnetwork")

    @odbnetwork.setter
    def odbnetwork(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "odbnetwork", value)

    @_builtins.property
    @pulumi.getter
    def purpose(self) -> pulumi.Input[_builtins.str]:
        """
        Purpose of the subnet.
        Possible values:
        CLIENT_SUBNET
        BACKUP_SUBNET
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "purpose", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels or tags associated with the resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _OdbSubnetState:
    def __init__(__self__, *,
                 cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 odbnetwork: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 purpose: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OdbSubnet resources.
        :param pulumi.Input[_builtins.str] cidr_range: The CIDR range of the subnet.
        :param pulumi.Input[_builtins.str] create_time: The date and time that the OdbNetwork was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels or tags associated with the resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The name of the OdbSubnet resource in the following format:
               projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        :param pulumi.Input[_builtins.str] odb_subnet_id: The ID of the OdbSubnet to create. This value is restricted
               to (^a-z?$) and must be a maximum of 63
               characters in length. The value must start with a letter and end with
               a letter or a number.
        :param pulumi.Input[_builtins.str] odbnetwork: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] purpose: Purpose of the subnet.
               Possible values:
               CLIENT_SUBNET
               BACKUP_SUBNET
        :param pulumi.Input[_builtins.str] state: State of the ODB Subnet.
               Possible values:
               PROVISIONING
               AVAILABLE
               TERMINATING
               FAILED
        """
        if cidr_range is not None:
            pulumi.set(__self__, "cidr_range", cidr_range)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if odb_subnet_id is not None:
            pulumi.set(__self__, "odb_subnet_id", odb_subnet_id)
        if odbnetwork is not None:
            pulumi.set(__self__, "odbnetwork", odbnetwork)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="cidrRange")
    def cidr_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR range of the subnet.
        """
        return pulumi.get(self, "cidr_range")

    @cidr_range.setter
    def cidr_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr_range", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time that the OdbNetwork was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels or tags associated with the resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The name of the OdbSubnet resource in the following format:
        projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="odbSubnetId")
    def odb_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the OdbSubnet to create. This value is restricted
        to (^a-z?$) and must be a maximum of 63
        characters in length. The value must start with a letter and end with
        a letter or a number.
        """
        return pulumi.get(self, "odb_subnet_id")

    @odb_subnet_id.setter
    def odb_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "odb_subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def odbnetwork(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "odbnetwork")

    @odbnetwork.setter
    def odbnetwork(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "odbnetwork", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Purpose of the subnet.
        Possible values:
        CLIENT_SUBNET
        BACKUP_SUBNET
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "purpose", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the ODB Subnet.
        Possible values:
        PROVISIONING
        AVAILABLE
        TERMINATING
        FAILED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("gcp:oracledatabase/odbSubnet:OdbSubnet")
class OdbSubnet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 odbnetwork: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        An OdbSubnet resource which represents a subnet under an OdbNetwork.

        To get more information about OdbSubnet, see:
        * How-to Guides
            * [OracleDatabase@Google Cloud](https://cloud.google.com/oracle/database/docs/overview')

        ## Example Usage

        ### Oracledatabase Odbsubnet

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_odbsubnet = gcp.oracledatabase.OdbSubnet("my-odbsubnet",
            odb_subnet_id="my-odbsubnet",
            location="europe-west2",
            project="my-project",
            odbnetwork="my-odbnetwork",
            cidr_range="10.1.1.0/24",
            purpose="CLIENT_SUBNET",
            labels={
                "terraform_created": "true",
            },
            deletion_protection=True)
        ```

        ## Import

        OdbSubnet can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/odbNetworks/{{odbnetwork}}/odbSubnets/{{odb_subnet_id}}`

        * `{{project}}/{{location}}/{{odbnetwork}}/{{odb_subnet_id}}`

        * `{{location}}/{{odbnetwork}}/{{odb_subnet_id}}`

        When using the `pulumi import` command, OdbSubnet can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:oracledatabase/odbSubnet:OdbSubnet default projects/{{project}}/locations/{{location}}/odbNetworks/{{odbnetwork}}/odbSubnets/{{odb_subnet_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/odbSubnet:OdbSubnet default {{project}}/{{location}}/{{odbnetwork}}/{{odb_subnet_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/odbSubnet:OdbSubnet default {{location}}/{{odbnetwork}}/{{odb_subnet_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cidr_range: The CIDR range of the subnet.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels or tags associated with the resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] odb_subnet_id: The ID of the OdbSubnet to create. This value is restricted
               to (^a-z?$) and must be a maximum of 63
               characters in length. The value must start with a letter and end with
               a letter or a number.
        :param pulumi.Input[_builtins.str] odbnetwork: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] purpose: Purpose of the subnet.
               Possible values:
               CLIENT_SUBNET
               BACKUP_SUBNET
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OdbSubnetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An OdbSubnet resource which represents a subnet under an OdbNetwork.

        To get more information about OdbSubnet, see:
        * How-to Guides
            * [OracleDatabase@Google Cloud](https://cloud.google.com/oracle/database/docs/overview')

        ## Example Usage

        ### Oracledatabase Odbsubnet

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_odbsubnet = gcp.oracledatabase.OdbSubnet("my-odbsubnet",
            odb_subnet_id="my-odbsubnet",
            location="europe-west2",
            project="my-project",
            odbnetwork="my-odbnetwork",
            cidr_range="10.1.1.0/24",
            purpose="CLIENT_SUBNET",
            labels={
                "terraform_created": "true",
            },
            deletion_protection=True)
        ```

        ## Import

        OdbSubnet can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/odbNetworks/{{odbnetwork}}/odbSubnets/{{odb_subnet_id}}`

        * `{{project}}/{{location}}/{{odbnetwork}}/{{odb_subnet_id}}`

        * `{{location}}/{{odbnetwork}}/{{odb_subnet_id}}`

        When using the `pulumi import` command, OdbSubnet can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:oracledatabase/odbSubnet:OdbSubnet default projects/{{project}}/locations/{{location}}/odbNetworks/{{odbnetwork}}/odbSubnets/{{odb_subnet_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/odbSubnet:OdbSubnet default {{project}}/{{location}}/{{odbnetwork}}/{{odb_subnet_id}}
        ```

        ```sh
        $ pulumi import gcp:oracledatabase/odbSubnet:OdbSubnet default {{location}}/{{odbnetwork}}/{{odb_subnet_id}}
        ```

        :param str resource_name: The name of the resource.
        :param OdbSubnetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OdbSubnetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 odbnetwork: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OdbSubnetArgs.__new__(OdbSubnetArgs)

            if cidr_range is None and not opts.urn:
                raise TypeError("Missing required property 'cidr_range'")
            __props__.__dict__["cidr_range"] = cidr_range
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if odb_subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'odb_subnet_id'")
            __props__.__dict__["odb_subnet_id"] = odb_subnet_id
            if odbnetwork is None and not opts.urn:
                raise TypeError("Missing required property 'odbnetwork'")
            __props__.__dict__["odbnetwork"] = odbnetwork
            __props__.__dict__["project"] = project
            if purpose is None and not opts.urn:
                raise TypeError("Missing required property 'purpose'")
            __props__.__dict__["purpose"] = purpose
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(OdbSubnet, __self__).__init__(
            'gcp:oracledatabase/odbSubnet:OdbSubnet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            odb_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            odbnetwork: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            purpose: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'OdbSubnet':
        """
        Get an existing OdbSubnet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cidr_range: The CIDR range of the subnet.
        :param pulumi.Input[_builtins.str] create_time: The date and time that the OdbNetwork was created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels or tags associated with the resource.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] name: Identifier. The name of the OdbSubnet resource in the following format:
               projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        :param pulumi.Input[_builtins.str] odb_subnet_id: The ID of the OdbSubnet to create. This value is restricted
               to (^a-z?$) and must be a maximum of 63
               characters in length. The value must start with a letter and end with
               a letter or a number.
        :param pulumi.Input[_builtins.str] odbnetwork: Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] purpose: Purpose of the subnet.
               Possible values:
               CLIENT_SUBNET
               BACKUP_SUBNET
        :param pulumi.Input[_builtins.str] state: State of the ODB Subnet.
               Possible values:
               PROVISIONING
               AVAILABLE
               TERMINATING
               FAILED
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OdbSubnetState.__new__(_OdbSubnetState)

        __props__.__dict__["cidr_range"] = cidr_range
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["odb_subnet_id"] = odb_subnet_id
        __props__.__dict__["odbnetwork"] = odbnetwork
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["purpose"] = purpose
        __props__.__dict__["state"] = state
        return OdbSubnet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cidrRange")
    def cidr_range(self) -> pulumi.Output[_builtins.str]:
        """
        The CIDR range of the subnet.
        """
        return pulumi.get(self, "cidr_range")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time that the OdbNetwork was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels or tags associated with the resource.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The name of the OdbSubnet resource in the following format:
        projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="odbSubnetId")
    def odb_subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the OdbSubnet to create. This value is restricted
        to (^a-z?$) and must be a maximum of 63
        characters in length. The value must start with a letter and end with
        a letter or a number.
        """
        return pulumi.get(self, "odb_subnet_id")

    @_builtins.property
    @pulumi.getter
    def odbnetwork(self) -> pulumi.Output[_builtins.str]:
        """
        Resource ID segment making up resource `name`. It identifies the resource within its parent collection as described in https://google.aip.dev/122.
        """
        return pulumi.get(self, "odbnetwork")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def purpose(self) -> pulumi.Output[_builtins.str]:
        """
        Purpose of the subnet.
        Possible values:
        CLIENT_SUBNET
        BACKUP_SUBNET
        """
        return pulumi.get(self, "purpose")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        State of the ODB Subnet.
        Possible values:
        PROVISIONING
        AVAILABLE
        TERMINATING
        FAILED
        """
        return pulumi.get(self, "state")

