# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBillingAccountResult',
    'AwaitableGetBillingAccountResult',
    'get_billing_account',
    'get_billing_account_output',
]

@pulumi.output_type
class GetBillingAccountResult:
    """
    A collection of values returned by getBillingAccount.
    """
    def __init__(__self__, billing_account=None, currency_code=None, display_name=None, id=None, lookup_projects=None, name=None, open=None, project_ids=None):
        if billing_account and not isinstance(billing_account, str):
            raise TypeError("Expected argument 'billing_account' to be a str")
        pulumi.set(__self__, "billing_account", billing_account)
        if currency_code and not isinstance(currency_code, str):
            raise TypeError("Expected argument 'currency_code' to be a str")
        pulumi.set(__self__, "currency_code", currency_code)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lookup_projects and not isinstance(lookup_projects, bool):
            raise TypeError("Expected argument 'lookup_projects' to be a bool")
        pulumi.set(__self__, "lookup_projects", lookup_projects)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if open and not isinstance(open, bool):
            raise TypeError("Expected argument 'open' to be a bool")
        pulumi.set(__self__, "open", open)
        if project_ids and not isinstance(project_ids, list):
            raise TypeError("Expected argument 'project_ids' to be a list")
        pulumi.set(__self__, "project_ids", project_ids)

    @_builtins.property
    @pulumi.getter(name="billingAccount")
    def billing_account(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "billing_account")

    @_builtins.property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> _builtins.str:
        """
        The currency code of the billing account, e.g. `USD`.
        """
        return pulumi.get(self, "currency_code")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lookupProjects")
    def lookup_projects(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "lookup_projects")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name of the billing account in the form `billingAccounts/{billing_account_id}`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def open(self) -> _builtins.bool:
        return pulumi.get(self, "open")

    @_builtins.property
    @pulumi.getter(name="projectIds")
    def project_ids(self) -> Sequence[_builtins.str]:
        """
        The IDs of any projects associated with the billing account. `lookup_projects` must not be false
        for this to be populated.
        """
        return pulumi.get(self, "project_ids")


class AwaitableGetBillingAccountResult(GetBillingAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBillingAccountResult(
            billing_account=self.billing_account,
            currency_code=self.currency_code,
            display_name=self.display_name,
            id=self.id,
            lookup_projects=self.lookup_projects,
            name=self.name,
            open=self.open,
            project_ids=self.project_ids)


def get_billing_account(billing_account: Optional[_builtins.str] = None,
                        display_name: Optional[_builtins.str] = None,
                        lookup_projects: Optional[_builtins.bool] = None,
                        open: Optional[_builtins.bool] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBillingAccountResult:
    """
    Use this data source to get information about a Google Billing Account.

    ```python
    import pulumi
    import pulumi_gcp as gcp

    acct = gcp.organizations.get_billing_account(display_name="My Billing Account",
        open=True)
    my_project = gcp.organizations.Project("my_project",
        name="My Project",
        project_id="your-project-id",
        org_id="1234567",
        billing_account=acct.id)
    ```


    :param _builtins.str billing_account: The name of the billing account in the form `{billing_account_id}` or `billingAccounts/{billing_account_id}`.
    :param _builtins.str display_name: The display name of the billing account.
    :param _builtins.bool lookup_projects: `true` if projects associated with the billing account should be read, `false` if this step
           should be skipped. Setting `false` may be useful if the user permissions do not allow listing projects. Defaults to `true`.
           
           > **NOTE:** One of `billing_account` or `display_name` must be specified.
    :param _builtins.bool open: `true` if the billing account is open, `false` if the billing account is closed.
    """
    __args__ = dict()
    __args__['billingAccount'] = billing_account
    __args__['displayName'] = display_name
    __args__['lookupProjects'] = lookup_projects
    __args__['open'] = open
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:organizations/getBillingAccount:getBillingAccount', __args__, opts=opts, typ=GetBillingAccountResult).value

    return AwaitableGetBillingAccountResult(
        billing_account=pulumi.get(__ret__, 'billing_account'),
        currency_code=pulumi.get(__ret__, 'currency_code'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        lookup_projects=pulumi.get(__ret__, 'lookup_projects'),
        name=pulumi.get(__ret__, 'name'),
        open=pulumi.get(__ret__, 'open'),
        project_ids=pulumi.get(__ret__, 'project_ids'))
def get_billing_account_output(billing_account: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               lookup_projects: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                               open: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBillingAccountResult]:
    """
    Use this data source to get information about a Google Billing Account.

    ```python
    import pulumi
    import pulumi_gcp as gcp

    acct = gcp.organizations.get_billing_account(display_name="My Billing Account",
        open=True)
    my_project = gcp.organizations.Project("my_project",
        name="My Project",
        project_id="your-project-id",
        org_id="1234567",
        billing_account=acct.id)
    ```


    :param _builtins.str billing_account: The name of the billing account in the form `{billing_account_id}` or `billingAccounts/{billing_account_id}`.
    :param _builtins.str display_name: The display name of the billing account.
    :param _builtins.bool lookup_projects: `true` if projects associated with the billing account should be read, `false` if this step
           should be skipped. Setting `false` may be useful if the user permissions do not allow listing projects. Defaults to `true`.
           
           > **NOTE:** One of `billing_account` or `display_name` must be specified.
    :param _builtins.bool open: `true` if the billing account is open, `false` if the billing account is closed.
    """
    __args__ = dict()
    __args__['billingAccount'] = billing_account
    __args__['displayName'] = display_name
    __args__['lookupProjects'] = lookup_projects
    __args__['open'] = open
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:organizations/getBillingAccount:getBillingAccount', __args__, opts=opts, typ=GetBillingAccountResult)
    return __ret__.apply(lambda __response__: GetBillingAccountResult(
        billing_account=pulumi.get(__response__, 'billing_account'),
        currency_code=pulumi.get(__response__, 'currency_code'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        lookup_projects=pulumi.get(__response__, 'lookup_projects'),
        name=pulumi.get(__response__, 'name'),
        open=pulumi.get(__response__, 'open'),
        project_ids=pulumi.get(__response__, 'project_ids')))
