# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OsPolicyAssignmentArgs', 'OsPolicyAssignment']

@pulumi.input_type
class OsPolicyAssignmentArgs:
    def __init__(__self__, *,
                 instance_filter: pulumi.Input['OsPolicyAssignmentInstanceFilterArgs'],
                 location: pulumi.Input[_builtins.str],
                 os_policies: pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]],
                 rollout: pulumi.Input['OsPolicyAssignmentRolloutArgs'],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_await_rollout: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a OsPolicyAssignment resource.
        :param pulumi.Input['OsPolicyAssignmentInstanceFilterArgs'] instance_filter: Filter to select VMs. Structure is
               documented below.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]] os_policies: List of OS policies to be applied to the VMs.
               Structure is documented below.
        :param pulumi.Input['OsPolicyAssignmentRolloutArgs'] rollout: Rollout to deploy the OS policy assignment. A rollout
               is triggered in the following situations: 1) OSPolicyAssignment is created.
               2) OSPolicyAssignment is updated and the update contains changes to one of
               the following fields: - instance_filter - os_policies 3) OSPolicyAssignment
               is deleted. Structure is documented below.
        :param pulumi.Input[_builtins.str] description: OS policy assignment description. Length of the description is limited to 1024 characters.
        :param pulumi.Input[_builtins.str] name: Resource name.
        :param pulumi.Input[_builtins.str] project: The project for the resource
        :param pulumi.Input[_builtins.bool] skip_await_rollout: Set to true to skip awaiting rollout during resource creation and update.
        """
        pulumi.set(__self__, "instance_filter", instance_filter)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "os_policies", os_policies)
        pulumi.set(__self__, "rollout", rollout)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if skip_await_rollout is not None:
            pulumi.set(__self__, "skip_await_rollout", skip_await_rollout)

    @_builtins.property
    @pulumi.getter(name="instanceFilter")
    def instance_filter(self) -> pulumi.Input['OsPolicyAssignmentInstanceFilterArgs']:
        """
        Filter to select VMs. Structure is
        documented below.
        """
        return pulumi.get(self, "instance_filter")

    @instance_filter.setter
    def instance_filter(self, value: pulumi.Input['OsPolicyAssignmentInstanceFilterArgs']):
        pulumi.set(self, "instance_filter", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="osPolicies")
    def os_policies(self) -> pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]]:
        """
        List of OS policies to be applied to the VMs.
        Structure is documented below.
        """
        return pulumi.get(self, "os_policies")

    @os_policies.setter
    def os_policies(self, value: pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]]):
        pulumi.set(self, "os_policies", value)

    @_builtins.property
    @pulumi.getter
    def rollout(self) -> pulumi.Input['OsPolicyAssignmentRolloutArgs']:
        """
        Rollout to deploy the OS policy assignment. A rollout
        is triggered in the following situations: 1) OSPolicyAssignment is created.
        2) OSPolicyAssignment is updated and the update contains changes to one of
        the following fields: - instance_filter - os_policies 3) OSPolicyAssignment
        is deleted. Structure is documented below.
        """
        return pulumi.get(self, "rollout")

    @rollout.setter
    def rollout(self, value: pulumi.Input['OsPolicyAssignmentRolloutArgs']):
        pulumi.set(self, "rollout", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OS policy assignment description. Length of the description is limited to 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="skipAwaitRollout")
    def skip_await_rollout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to skip awaiting rollout during resource creation and update.
        """
        return pulumi.get(self, "skip_await_rollout")

    @skip_await_rollout.setter
    def skip_await_rollout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_await_rollout", value)


@pulumi.input_type
class _OsPolicyAssignmentState:
    def __init__(__self__, *,
                 baseline: Optional[pulumi.Input[_builtins.bool]] = None,
                 deleted: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_filter: Optional[pulumi.Input['OsPolicyAssignmentInstanceFilterArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_policies: Optional[pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
                 revision_create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rollout: Optional[pulumi.Input['OsPolicyAssignmentRolloutArgs']] = None,
                 rollout_state: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_await_rollout: Optional[pulumi.Input[_builtins.bool]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OsPolicyAssignment resources.
        :param pulumi.Input[_builtins.bool] baseline: Output only. Indicates that this revision has been successfully
               rolled out in this zone and new VMs will be assigned OS policies from this
               revision. For a given OS policy assignment, there is only one revision with
               a value of `true` for this field.
        :param pulumi.Input[_builtins.bool] deleted: Output only. Indicates that this revision deletes the OS policy
               assignment.
        :param pulumi.Input[_builtins.str] description: OS policy assignment description. Length of the description is limited to 1024 characters.
        :param pulumi.Input[_builtins.str] etag: The etag for this OS policy assignment. If this is provided on
               update, it must match the server's etag.
        :param pulumi.Input['OsPolicyAssignmentInstanceFilterArgs'] instance_filter: Filter to select VMs. Structure is
               documented below.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[_builtins.str] name: Resource name.
        :param pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]] os_policies: List of OS policies to be applied to the VMs.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The project for the resource
        :param pulumi.Input[_builtins.bool] reconciling: Output only. Indicates that reconciliation is in progress
               for the revision. This value is `true` when the `rollout_state` is one of:
        :param pulumi.Input[_builtins.str] revision_create_time: Output only. The timestamp that the revision was
               created.
        :param pulumi.Input[_builtins.str] revision_id: Output only. The assignment revision ID A new revision is
               committed whenever a rollout is triggered for a OS policy assignment
        :param pulumi.Input['OsPolicyAssignmentRolloutArgs'] rollout: Rollout to deploy the OS policy assignment. A rollout
               is triggered in the following situations: 1) OSPolicyAssignment is created.
               2) OSPolicyAssignment is updated and the update contains changes to one of
               the following fields: - instance_filter - os_policies 3) OSPolicyAssignment
               is deleted. Structure is documented below.
        :param pulumi.Input[_builtins.str] rollout_state: Output only. OS policy assignment rollout state
        :param pulumi.Input[_builtins.bool] skip_await_rollout: Set to true to skip awaiting rollout during resource creation and update.
        :param pulumi.Input[_builtins.str] uid: Output only. Server generated unique id for the OS policy assignment
               resource.
        """
        if baseline is not None:
            pulumi.set(__self__, "baseline", baseline)
        if deleted is not None:
            pulumi.set(__self__, "deleted", deleted)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if instance_filter is not None:
            pulumi.set(__self__, "instance_filter", instance_filter)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_policies is not None:
            pulumi.set(__self__, "os_policies", os_policies)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if revision_create_time is not None:
            pulumi.set(__self__, "revision_create_time", revision_create_time)
        if revision_id is not None:
            pulumi.set(__self__, "revision_id", revision_id)
        if rollout is not None:
            pulumi.set(__self__, "rollout", rollout)
        if rollout_state is not None:
            pulumi.set(__self__, "rollout_state", rollout_state)
        if skip_await_rollout is not None:
            pulumi.set(__self__, "skip_await_rollout", skip_await_rollout)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def baseline(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Output only. Indicates that this revision has been successfully
        rolled out in this zone and new VMs will be assigned OS policies from this
        revision. For a given OS policy assignment, there is only one revision with
        a value of `true` for this field.
        """
        return pulumi.get(self, "baseline")

    @baseline.setter
    def baseline(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "baseline", value)

    @_builtins.property
    @pulumi.getter
    def deleted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Output only. Indicates that this revision deletes the OS policy
        assignment.
        """
        return pulumi.get(self, "deleted")

    @deleted.setter
    def deleted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deleted", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OS policy assignment description. Length of the description is limited to 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The etag for this OS policy assignment. If this is provided on
        update, it must match the server's etag.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="instanceFilter")
    def instance_filter(self) -> Optional[pulumi.Input['OsPolicyAssignmentInstanceFilterArgs']]:
        """
        Filter to select VMs. Structure is
        documented below.
        """
        return pulumi.get(self, "instance_filter")

    @instance_filter.setter
    def instance_filter(self, value: Optional[pulumi.Input['OsPolicyAssignmentInstanceFilterArgs']]):
        pulumi.set(self, "instance_filter", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="osPolicies")
    def os_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]]]:
        """
        List of OS policies to be applied to the VMs.
        Structure is documented below.
        """
        return pulumi.get(self, "os_policies")

    @os_policies.setter
    def os_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]]]):
        pulumi.set(self, "os_policies", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Output only. Indicates that reconciliation is in progress
        for the revision. This value is `true` when the `rollout_state` is one of:
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @_builtins.property
    @pulumi.getter(name="revisionCreateTime")
    def revision_create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The timestamp that the revision was
        created.
        """
        return pulumi.get(self, "revision_create_time")

    @revision_create_time.setter
    def revision_create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revision_create_time", value)

    @_builtins.property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The assignment revision ID A new revision is
        committed whenever a rollout is triggered for a OS policy assignment
        """
        return pulumi.get(self, "revision_id")

    @revision_id.setter
    def revision_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revision_id", value)

    @_builtins.property
    @pulumi.getter
    def rollout(self) -> Optional[pulumi.Input['OsPolicyAssignmentRolloutArgs']]:
        """
        Rollout to deploy the OS policy assignment. A rollout
        is triggered in the following situations: 1) OSPolicyAssignment is created.
        2) OSPolicyAssignment is updated and the update contains changes to one of
        the following fields: - instance_filter - os_policies 3) OSPolicyAssignment
        is deleted. Structure is documented below.
        """
        return pulumi.get(self, "rollout")

    @rollout.setter
    def rollout(self, value: Optional[pulumi.Input['OsPolicyAssignmentRolloutArgs']]):
        pulumi.set(self, "rollout", value)

    @_builtins.property
    @pulumi.getter(name="rolloutState")
    def rollout_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. OS policy assignment rollout state
        """
        return pulumi.get(self, "rollout_state")

    @rollout_state.setter
    def rollout_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rollout_state", value)

    @_builtins.property
    @pulumi.getter(name="skipAwaitRollout")
    def skip_await_rollout(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set to true to skip awaiting rollout during resource creation and update.
        """
        return pulumi.get(self, "skip_await_rollout")

    @skip_await_rollout.setter
    def skip_await_rollout(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_await_rollout", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Server generated unique id for the OS policy assignment
        resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)


@pulumi.type_token("gcp:osconfig/osPolicyAssignment:OsPolicyAssignment")
class OsPolicyAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_filter: Optional[pulumi.Input[Union['OsPolicyAssignmentInstanceFilterArgs', 'OsPolicyAssignmentInstanceFilterArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OsPolicyAssignmentOsPolicyArgs', 'OsPolicyAssignmentOsPolicyArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rollout: Optional[pulumi.Input[Union['OsPolicyAssignmentRolloutArgs', 'OsPolicyAssignmentRolloutArgsDict']]] = None,
                 skip_await_rollout: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        OS policy assignment is an API resource that is used to apply a set of OS
        policies to a dynamically targeted group of Compute Engine VM instances. An OS
        policy is used to define the desired state configuration for a Compute Engine VM
        instance through a set of configuration resources that provide capabilities such
        as installing or removing software packages, or executing a script. For more
        information about the OS policy resource definitions and examples, see
        [OS policy and OS policy assignment](https://cloud.google.com/compute/docs/os-configuration-management/working-with-os-policies).

        To get more information about OSPolicyAssignment, see:

        *   [API documentation](https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments)
        *   How-to Guides
            *   [Official Documentation](https://cloud.google.com/compute/docs/os-configuration-management/create-os-policy-assignment)

        ## Example Usage

        ### Os Config Os Policy Assignment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.osconfig.OsPolicyAssignment("primary",
            instance_filter={
                "all": False,
                "exclusion_labels": [{
                    "labels": {
                        "label-two": "value-two",
                    },
                }],
                "inclusion_labels": [{
                    "labels": {
                        "label-one": "value-one",
                    },
                }],
                "inventories": [{
                    "os_short_name": "centos",
                    "os_version": "8.*",
                }],
            },
            location="us-central1-a",
            name="policy-assignment",
            os_policies=[{
                "id": "policy",
                "mode": "VALIDATION",
                "resource_groups": [{
                    "resources": [
                        {
                            "id": "apt-to-yum",
                            "repository": {
                                "apt": {
                                    "archive_type": "DEB",
                                    "components": ["doc"],
                                    "distribution": "debian",
                                    "uri": "https://atl.mirrors.clouvider.net/debian",
                                    "gpg_key": ".gnupg/pubring.kbx",
                                },
                            },
                        },
                        {
                            "id": "exec1",
                            "exec_": {
                                "validate": {
                                    "interpreter": "SHELL",
                                    "args": ["arg1"],
                                    "file": {
                                        "local_path": "$HOME/script.sh",
                                    },
                                    "output_file_path": "$HOME/out",
                                },
                                "enforce": {
                                    "interpreter": "SHELL",
                                    "args": ["arg1"],
                                    "file": {
                                        "allow_insecure": True,
                                        "remote": {
                                            "uri": "https://www.example.com/script.sh",
                                            "sha256_checksum": "c7938fed83afdccbb0e86a2a2e4cad7d5035012ca3214b4a61268393635c3063",
                                        },
                                    },
                                    "output_file_path": "$HOME/out",
                                },
                            },
                        },
                    ],
                    "inventory_filters": [{
                        "os_short_name": "centos",
                        "os_version": "8.*",
                    }],
                }],
                "allow_no_resource_group_match": False,
                "description": "A test os policy",
            }],
            rollout={
                "disruption_budget": {
                    "percent": 100,
                },
                "min_wait_duration": "3s",
            },
            description="A test os policy assignment")
        ```

        ## Import

        OSPolicyAssignment can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/osPolicyAssignments/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, OSPolicyAssignment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default projects/{{project}}/locations/{{location}}/osPolicyAssignments/{{name}}
        ```

        ```sh
        $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: OS policy assignment description. Length of the description is limited to 1024 characters.
        :param pulumi.Input[Union['OsPolicyAssignmentInstanceFilterArgs', 'OsPolicyAssignmentInstanceFilterArgsDict']] instance_filter: Filter to select VMs. Structure is
               documented below.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[_builtins.str] name: Resource name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OsPolicyAssignmentOsPolicyArgs', 'OsPolicyAssignmentOsPolicyArgsDict']]]] os_policies: List of OS policies to be applied to the VMs.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The project for the resource
        :param pulumi.Input[Union['OsPolicyAssignmentRolloutArgs', 'OsPolicyAssignmentRolloutArgsDict']] rollout: Rollout to deploy the OS policy assignment. A rollout
               is triggered in the following situations: 1) OSPolicyAssignment is created.
               2) OSPolicyAssignment is updated and the update contains changes to one of
               the following fields: - instance_filter - os_policies 3) OSPolicyAssignment
               is deleted. Structure is documented below.
        :param pulumi.Input[_builtins.bool] skip_await_rollout: Set to true to skip awaiting rollout during resource creation and update.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OsPolicyAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        OS policy assignment is an API resource that is used to apply a set of OS
        policies to a dynamically targeted group of Compute Engine VM instances. An OS
        policy is used to define the desired state configuration for a Compute Engine VM
        instance through a set of configuration resources that provide capabilities such
        as installing or removing software packages, or executing a script. For more
        information about the OS policy resource definitions and examples, see
        [OS policy and OS policy assignment](https://cloud.google.com/compute/docs/os-configuration-management/working-with-os-policies).

        To get more information about OSPolicyAssignment, see:

        *   [API documentation](https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments)
        *   How-to Guides
            *   [Official Documentation](https://cloud.google.com/compute/docs/os-configuration-management/create-os-policy-assignment)

        ## Example Usage

        ### Os Config Os Policy Assignment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.osconfig.OsPolicyAssignment("primary",
            instance_filter={
                "all": False,
                "exclusion_labels": [{
                    "labels": {
                        "label-two": "value-two",
                    },
                }],
                "inclusion_labels": [{
                    "labels": {
                        "label-one": "value-one",
                    },
                }],
                "inventories": [{
                    "os_short_name": "centos",
                    "os_version": "8.*",
                }],
            },
            location="us-central1-a",
            name="policy-assignment",
            os_policies=[{
                "id": "policy",
                "mode": "VALIDATION",
                "resource_groups": [{
                    "resources": [
                        {
                            "id": "apt-to-yum",
                            "repository": {
                                "apt": {
                                    "archive_type": "DEB",
                                    "components": ["doc"],
                                    "distribution": "debian",
                                    "uri": "https://atl.mirrors.clouvider.net/debian",
                                    "gpg_key": ".gnupg/pubring.kbx",
                                },
                            },
                        },
                        {
                            "id": "exec1",
                            "exec_": {
                                "validate": {
                                    "interpreter": "SHELL",
                                    "args": ["arg1"],
                                    "file": {
                                        "local_path": "$HOME/script.sh",
                                    },
                                    "output_file_path": "$HOME/out",
                                },
                                "enforce": {
                                    "interpreter": "SHELL",
                                    "args": ["arg1"],
                                    "file": {
                                        "allow_insecure": True,
                                        "remote": {
                                            "uri": "https://www.example.com/script.sh",
                                            "sha256_checksum": "c7938fed83afdccbb0e86a2a2e4cad7d5035012ca3214b4a61268393635c3063",
                                        },
                                    },
                                    "output_file_path": "$HOME/out",
                                },
                            },
                        },
                    ],
                    "inventory_filters": [{
                        "os_short_name": "centos",
                        "os_version": "8.*",
                    }],
                }],
                "allow_no_resource_group_match": False,
                "description": "A test os policy",
            }],
            rollout={
                "disruption_budget": {
                    "percent": 100,
                },
                "min_wait_duration": "3s",
            },
            description="A test os policy assignment")
        ```

        ## Import

        OSPolicyAssignment can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/osPolicyAssignments/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, OSPolicyAssignment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default projects/{{project}}/locations/{{location}}/osPolicyAssignments/{{name}}
        ```

        ```sh
        $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param OsPolicyAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OsPolicyAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_filter: Optional[pulumi.Input[Union['OsPolicyAssignmentInstanceFilterArgs', 'OsPolicyAssignmentInstanceFilterArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OsPolicyAssignmentOsPolicyArgs', 'OsPolicyAssignmentOsPolicyArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 rollout: Optional[pulumi.Input[Union['OsPolicyAssignmentRolloutArgs', 'OsPolicyAssignmentRolloutArgsDict']]] = None,
                 skip_await_rollout: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OsPolicyAssignmentArgs.__new__(OsPolicyAssignmentArgs)

            __props__.__dict__["description"] = description
            if instance_filter is None and not opts.urn:
                raise TypeError("Missing required property 'instance_filter'")
            __props__.__dict__["instance_filter"] = instance_filter
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if os_policies is None and not opts.urn:
                raise TypeError("Missing required property 'os_policies'")
            __props__.__dict__["os_policies"] = os_policies
            __props__.__dict__["project"] = project
            if rollout is None and not opts.urn:
                raise TypeError("Missing required property 'rollout'")
            __props__.__dict__["rollout"] = rollout
            __props__.__dict__["skip_await_rollout"] = skip_await_rollout
            __props__.__dict__["baseline"] = None
            __props__.__dict__["deleted"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["revision_create_time"] = None
            __props__.__dict__["revision_id"] = None
            __props__.__dict__["rollout_state"] = None
            __props__.__dict__["uid"] = None
        super(OsPolicyAssignment, __self__).__init__(
            'gcp:osconfig/osPolicyAssignment:OsPolicyAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            baseline: Optional[pulumi.Input[_builtins.bool]] = None,
            deleted: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            instance_filter: Optional[pulumi.Input[Union['OsPolicyAssignmentInstanceFilterArgs', 'OsPolicyAssignmentInstanceFilterArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            os_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OsPolicyAssignmentOsPolicyArgs', 'OsPolicyAssignmentOsPolicyArgsDict']]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
            revision_create_time: Optional[pulumi.Input[_builtins.str]] = None,
            revision_id: Optional[pulumi.Input[_builtins.str]] = None,
            rollout: Optional[pulumi.Input[Union['OsPolicyAssignmentRolloutArgs', 'OsPolicyAssignmentRolloutArgsDict']]] = None,
            rollout_state: Optional[pulumi.Input[_builtins.str]] = None,
            skip_await_rollout: Optional[pulumi.Input[_builtins.bool]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None) -> 'OsPolicyAssignment':
        """
        Get an existing OsPolicyAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] baseline: Output only. Indicates that this revision has been successfully
               rolled out in this zone and new VMs will be assigned OS policies from this
               revision. For a given OS policy assignment, there is only one revision with
               a value of `true` for this field.
        :param pulumi.Input[_builtins.bool] deleted: Output only. Indicates that this revision deletes the OS policy
               assignment.
        :param pulumi.Input[_builtins.str] description: OS policy assignment description. Length of the description is limited to 1024 characters.
        :param pulumi.Input[_builtins.str] etag: The etag for this OS policy assignment. If this is provided on
               update, it must match the server's etag.
        :param pulumi.Input[Union['OsPolicyAssignmentInstanceFilterArgs', 'OsPolicyAssignmentInstanceFilterArgsDict']] instance_filter: Filter to select VMs. Structure is
               documented below.
        :param pulumi.Input[_builtins.str] location: The location for the resource
        :param pulumi.Input[_builtins.str] name: Resource name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OsPolicyAssignmentOsPolicyArgs', 'OsPolicyAssignmentOsPolicyArgsDict']]]] os_policies: List of OS policies to be applied to the VMs.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The project for the resource
        :param pulumi.Input[_builtins.bool] reconciling: Output only. Indicates that reconciliation is in progress
               for the revision. This value is `true` when the `rollout_state` is one of:
        :param pulumi.Input[_builtins.str] revision_create_time: Output only. The timestamp that the revision was
               created.
        :param pulumi.Input[_builtins.str] revision_id: Output only. The assignment revision ID A new revision is
               committed whenever a rollout is triggered for a OS policy assignment
        :param pulumi.Input[Union['OsPolicyAssignmentRolloutArgs', 'OsPolicyAssignmentRolloutArgsDict']] rollout: Rollout to deploy the OS policy assignment. A rollout
               is triggered in the following situations: 1) OSPolicyAssignment is created.
               2) OSPolicyAssignment is updated and the update contains changes to one of
               the following fields: - instance_filter - os_policies 3) OSPolicyAssignment
               is deleted. Structure is documented below.
        :param pulumi.Input[_builtins.str] rollout_state: Output only. OS policy assignment rollout state
        :param pulumi.Input[_builtins.bool] skip_await_rollout: Set to true to skip awaiting rollout during resource creation and update.
        :param pulumi.Input[_builtins.str] uid: Output only. Server generated unique id for the OS policy assignment
               resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OsPolicyAssignmentState.__new__(_OsPolicyAssignmentState)

        __props__.__dict__["baseline"] = baseline
        __props__.__dict__["deleted"] = deleted
        __props__.__dict__["description"] = description
        __props__.__dict__["etag"] = etag
        __props__.__dict__["instance_filter"] = instance_filter
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["os_policies"] = os_policies
        __props__.__dict__["project"] = project
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["revision_create_time"] = revision_create_time
        __props__.__dict__["revision_id"] = revision_id
        __props__.__dict__["rollout"] = rollout
        __props__.__dict__["rollout_state"] = rollout_state
        __props__.__dict__["skip_await_rollout"] = skip_await_rollout
        __props__.__dict__["uid"] = uid
        return OsPolicyAssignment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def baseline(self) -> pulumi.Output[_builtins.bool]:
        """
        Output only. Indicates that this revision has been successfully
        rolled out in this zone and new VMs will be assigned OS policies from this
        revision. For a given OS policy assignment, there is only one revision with
        a value of `true` for this field.
        """
        return pulumi.get(self, "baseline")

    @_builtins.property
    @pulumi.getter
    def deleted(self) -> pulumi.Output[_builtins.bool]:
        """
        Output only. Indicates that this revision deletes the OS policy
        assignment.
        """
        return pulumi.get(self, "deleted")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        OS policy assignment description. Length of the description is limited to 1024 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        The etag for this OS policy assignment. If this is provided on
        update, it must match the server's etag.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="instanceFilter")
    def instance_filter(self) -> pulumi.Output['outputs.OsPolicyAssignmentInstanceFilter']:
        """
        Filter to select VMs. Structure is
        documented below.
        """
        return pulumi.get(self, "instance_filter")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osPolicies")
    def os_policies(self) -> pulumi.Output[Sequence['outputs.OsPolicyAssignmentOsPolicy']]:
        """
        List of OS policies to be applied to the VMs.
        Structure is documented below.
        """
        return pulumi.get(self, "os_policies")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[_builtins.bool]:
        """
        Output only. Indicates that reconciliation is in progress
        for the revision. This value is `true` when the `rollout_state` is one of:
        """
        return pulumi.get(self, "reconciling")

    @_builtins.property
    @pulumi.getter(name="revisionCreateTime")
    def revision_create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The timestamp that the revision was
        created.
        """
        return pulumi.get(self, "revision_create_time")

    @_builtins.property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The assignment revision ID A new revision is
        committed whenever a rollout is triggered for a OS policy assignment
        """
        return pulumi.get(self, "revision_id")

    @_builtins.property
    @pulumi.getter
    def rollout(self) -> pulumi.Output['outputs.OsPolicyAssignmentRollout']:
        """
        Rollout to deploy the OS policy assignment. A rollout
        is triggered in the following situations: 1) OSPolicyAssignment is created.
        2) OSPolicyAssignment is updated and the update contains changes to one of
        the following fields: - instance_filter - os_policies 3) OSPolicyAssignment
        is deleted. Structure is documented below.
        """
        return pulumi.get(self, "rollout")

    @_builtins.property
    @pulumi.getter(name="rolloutState")
    def rollout_state(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. OS policy assignment rollout state
        """
        return pulumi.get(self, "rollout_state")

    @_builtins.property
    @pulumi.getter(name="skipAwaitRollout")
    def skip_await_rollout(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set to true to skip awaiting rollout during resource creation and update.
        """
        return pulumi.get(self, "skip_await_rollout")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Server generated unique id for the OS policy assignment
        resource.
        """
        return pulumi.get(self, "uid")

