# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRegionalParameterVersionResult',
    'AwaitableGetRegionalParameterVersionResult',
    'get_regional_parameter_version',
    'get_regional_parameter_version_output',
]

@pulumi.output_type
class GetRegionalParameterVersionResult:
    """
    A collection of values returned by getRegionalParameterVersion.
    """
    def __init__(__self__, create_time=None, disabled=None, id=None, kms_key_version=None, location=None, name=None, parameter=None, parameter_data=None, parameter_version_id=None, project=None, update_time=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if disabled and not isinstance(disabled, bool):
            raise TypeError("Expected argument 'disabled' to be a bool")
        pulumi.set(__self__, "disabled", disabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kms_key_version and not isinstance(kms_key_version, str):
            raise TypeError("Expected argument 'kms_key_version' to be a str")
        pulumi.set(__self__, "kms_key_version", kms_key_version)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parameter and not isinstance(parameter, str):
            raise TypeError("Expected argument 'parameter' to be a str")
        pulumi.set(__self__, "parameter", parameter)
        if parameter_data and not isinstance(parameter_data, str):
            raise TypeError("Expected argument 'parameter_data' to be a str")
        pulumi.set(__self__, "parameter_data", parameter_data)
        if parameter_version_id and not isinstance(parameter_version_id, str):
            raise TypeError("Expected argument 'parameter_version_id' to be a str")
        pulumi.set(__self__, "parameter_version_id", parameter_version_id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The time at which the Regional Parameter Version was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> _builtins.bool:
        """
        The current state of the Regional Parameter Version.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersion")
    def kms_key_version(self) -> _builtins.str:
        """
        The resource name of the Cloud KMS CryptoKeyVersion used to decrypt regional parameter version payload. Format `projects/{{project}}/locations/{{location}}/keyRings/{{key_ring}}/cryptoKeys/{{crypto_key}}/cryptoKeyVersions/{{crypto_key_version}}`
        """
        return pulumi.get(self, "kms_key_version")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The resource name of the Regional Parameter Version. Format:
        `projects/{{project}}/locations/{{location}}/parameters/{{parameter_id}}/versions/{{parameter_version_id}}`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parameter(self) -> _builtins.str:
        return pulumi.get(self, "parameter")

    @_builtins.property
    @pulumi.getter(name="parameterData")
    def parameter_data(self) -> _builtins.str:
        """
        The regional parameter data.
        """
        return pulumi.get(self, "parameter_data")

    @_builtins.property
    @pulumi.getter(name="parameterVersionId")
    def parameter_version_id(self) -> _builtins.str:
        return pulumi.get(self, "parameter_version_id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        The time at which the Regional Parameter Version was last updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetRegionalParameterVersionResult(GetRegionalParameterVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionalParameterVersionResult(
            create_time=self.create_time,
            disabled=self.disabled,
            id=self.id,
            kms_key_version=self.kms_key_version,
            location=self.location,
            name=self.name,
            parameter=self.parameter,
            parameter_data=self.parameter_data,
            parameter_version_id=self.parameter_version_id,
            project=self.project,
            update_time=self.update_time)


def get_regional_parameter_version(location: Optional[_builtins.str] = None,
                                   parameter: Optional[_builtins.str] = None,
                                   parameter_version_id: Optional[_builtins.str] = None,
                                   project: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionalParameterVersionResult:
    """
    Get the value and metadata from a Parameter Manager Regional Parameter version. For more information see the [official documentation](https://cloud.google.com/secret-manager/parameter-manager/docs/overview) and [API](https://cloud.google.com/secret-manager/parameter-manager/docs/reference/rest/v1/projects.locations.parameters.versions).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    basic = gcp.parametermanager.get_regional_parameter_version(parameter="test-regional-parameter",
        parameter_version_id="test-regional-parameter-version",
        location="us-central1")
    ```


    :param _builtins.str location: The location of regional parameter.
    :param _builtins.str parameter: The parameter for obtaining the Regional Parameter Version.
           This can be either the reference of the regional parameter as in `projects/{{project}}/locations/{{location}}/parameters/{{parameter_id}}` or only the name of the regional parameter as in `{{parameter_id}}`.
    :param _builtins.str parameter_version_id: The version of the regional parameter to get.
    :param _builtins.str project: The project for retrieving the Regional Parameter Version. If it's not specified, 
           the provider project will be used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['parameter'] = parameter
    __args__['parameterVersionId'] = parameter_version_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:parametermanager/getRegionalParameterVersion:getRegionalParameterVersion', __args__, opts=opts, typ=GetRegionalParameterVersionResult).value

    return AwaitableGetRegionalParameterVersionResult(
        create_time=pulumi.get(__ret__, 'create_time'),
        disabled=pulumi.get(__ret__, 'disabled'),
        id=pulumi.get(__ret__, 'id'),
        kms_key_version=pulumi.get(__ret__, 'kms_key_version'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        parameter=pulumi.get(__ret__, 'parameter'),
        parameter_data=pulumi.get(__ret__, 'parameter_data'),
        parameter_version_id=pulumi.get(__ret__, 'parameter_version_id'),
        project=pulumi.get(__ret__, 'project'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_regional_parameter_version_output(location: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          parameter: Optional[pulumi.Input[_builtins.str]] = None,
                                          parameter_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegionalParameterVersionResult]:
    """
    Get the value and metadata from a Parameter Manager Regional Parameter version. For more information see the [official documentation](https://cloud.google.com/secret-manager/parameter-manager/docs/overview) and [API](https://cloud.google.com/secret-manager/parameter-manager/docs/reference/rest/v1/projects.locations.parameters.versions).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    basic = gcp.parametermanager.get_regional_parameter_version(parameter="test-regional-parameter",
        parameter_version_id="test-regional-parameter-version",
        location="us-central1")
    ```


    :param _builtins.str location: The location of regional parameter.
    :param _builtins.str parameter: The parameter for obtaining the Regional Parameter Version.
           This can be either the reference of the regional parameter as in `projects/{{project}}/locations/{{location}}/parameters/{{parameter_id}}` or only the name of the regional parameter as in `{{parameter_id}}`.
    :param _builtins.str parameter_version_id: The version of the regional parameter to get.
    :param _builtins.str project: The project for retrieving the Regional Parameter Version. If it's not specified, 
           the provider project will be used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['parameter'] = parameter
    __args__['parameterVersionId'] = parameter_version_id
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:parametermanager/getRegionalParameterVersion:getRegionalParameterVersion', __args__, opts=opts, typ=GetRegionalParameterVersionResult)
    return __ret__.apply(lambda __response__: GetRegionalParameterVersionResult(
        create_time=pulumi.get(__response__, 'create_time'),
        disabled=pulumi.get(__response__, 'disabled'),
        id=pulumi.get(__response__, 'id'),
        kms_key_version=pulumi.get(__response__, 'kms_key_version'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        parameter=pulumi.get(__response__, 'parameter'),
        parameter_data=pulumi.get(__response__, 'parameter_data'),
        parameter_version_id=pulumi.get(__response__, 'parameter_version_id'),
        project=pulumi.get(__response__, 'project'),
        update_time=pulumi.get(__response__, 'update_time')))
