# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 service: pulumi.Input[_builtins.str],
                 check_if_service_has_usage_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_dependent_services: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[_builtins.str] service: The service to enable.
        :param pulumi.Input[_builtins.bool] check_if_service_has_usage_on_destroy: Beta
               If `true`, the usage of the service to be disabled will be checked and an error
               will be returned if the service to be disabled has usage in last 30 days.
               Defaults to `false`.
        :param pulumi.Input[_builtins.bool] disable_dependent_services: If `true`, services that are enabled
               and which depend on this service should also be disabled when this service is
               destroyed. If `false` or unset, an error will be generated if any enabled
               services depend on this service when destroying it.
        :param pulumi.Input[_builtins.str] project: The project ID. If not provided, the provider project
               is used.
        """
        pulumi.set(__self__, "service", service)
        if check_if_service_has_usage_on_destroy is not None:
            pulumi.set(__self__, "check_if_service_has_usage_on_destroy", check_if_service_has_usage_on_destroy)
        if disable_dependent_services is not None:
            pulumi.set(__self__, "disable_dependent_services", disable_dependent_services)
        if disable_on_destroy is not None:
            pulumi.set(__self__, "disable_on_destroy", disable_on_destroy)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Input[_builtins.str]:
        """
        The service to enable.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter(name="checkIfServiceHasUsageOnDestroy")
    def check_if_service_has_usage_on_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Beta
        If `true`, the usage of the service to be disabled will be checked and an error
        will be returned if the service to be disabled has usage in last 30 days.
        Defaults to `false`.
        """
        return pulumi.get(self, "check_if_service_has_usage_on_destroy")

    @check_if_service_has_usage_on_destroy.setter
    def check_if_service_has_usage_on_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "check_if_service_has_usage_on_destroy", value)

    @_builtins.property
    @pulumi.getter(name="disableDependentServices")
    def disable_dependent_services(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, services that are enabled
        and which depend on this service should also be disabled when this service is
        destroyed. If `false` or unset, an error will be generated if any enabled
        services depend on this service when destroying it.
        """
        return pulumi.get(self, "disable_dependent_services")

    @disable_dependent_services.setter
    def disable_dependent_services(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_dependent_services", value)

    @_builtins.property
    @pulumi.getter(name="disableOnDestroy")
    def disable_on_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "disable_on_destroy")

    @disable_on_destroy.setter
    def disable_on_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_on_destroy", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project ID. If not provided, the provider project
        is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 check_if_service_has_usage_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_dependent_services: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[_builtins.bool] check_if_service_has_usage_on_destroy: Beta
               If `true`, the usage of the service to be disabled will be checked and an error
               will be returned if the service to be disabled has usage in last 30 days.
               Defaults to `false`.
        :param pulumi.Input[_builtins.bool] disable_dependent_services: If `true`, services that are enabled
               and which depend on this service should also be disabled when this service is
               destroyed. If `false` or unset, an error will be generated if any enabled
               services depend on this service when destroying it.
        :param pulumi.Input[_builtins.str] project: The project ID. If not provided, the provider project
               is used.
        :param pulumi.Input[_builtins.str] service: The service to enable.
        """
        if check_if_service_has_usage_on_destroy is not None:
            pulumi.set(__self__, "check_if_service_has_usage_on_destroy", check_if_service_has_usage_on_destroy)
        if disable_dependent_services is not None:
            pulumi.set(__self__, "disable_dependent_services", disable_dependent_services)
        if disable_on_destroy is not None:
            pulumi.set(__self__, "disable_on_destroy", disable_on_destroy)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter(name="checkIfServiceHasUsageOnDestroy")
    def check_if_service_has_usage_on_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Beta
        If `true`, the usage of the service to be disabled will be checked and an error
        will be returned if the service to be disabled has usage in last 30 days.
        Defaults to `false`.
        """
        return pulumi.get(self, "check_if_service_has_usage_on_destroy")

    @check_if_service_has_usage_on_destroy.setter
    def check_if_service_has_usage_on_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "check_if_service_has_usage_on_destroy", value)

    @_builtins.property
    @pulumi.getter(name="disableDependentServices")
    def disable_dependent_services(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, services that are enabled
        and which depend on this service should also be disabled when this service is
        destroyed. If `false` or unset, an error will be generated if any enabled
        services depend on this service when destroying it.
        """
        return pulumi.get(self, "disable_dependent_services")

    @disable_dependent_services.setter
    def disable_dependent_services(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_dependent_services", value)

    @_builtins.property
    @pulumi.getter(name="disableOnDestroy")
    def disable_on_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "disable_on_destroy")

    @disable_on_destroy.setter
    def disable_on_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_on_destroy", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project ID. If not provided, the provider project
        is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service to enable.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service", value)


@pulumi.type_token("gcp:projects/service:Service")
class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 check_if_service_has_usage_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_dependent_services: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.projects.Service("project",
            project="your-project-id",
            service="iam.googleapis.com",
            disable_on_destroy=False)
        ```

        ## Import

        Project services can be imported using the `project_id` and `service`, e.g.

        * `{{project_id}}/{{service}}`

        When using the `pulumi import` command, project services can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:projects/service:Service default {{project_id}}/{{service}}
        ```

        Note that unlike other resources that fail if they already exist,

        `pulumi up` can be successfully used to verify already enabled services.

        This means that when importing existing resources into Terraform, you can either

        import the `google_project_service` resources or treat them as new

        infrastructure and run `pulumi up` to add them to state.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] check_if_service_has_usage_on_destroy: Beta
               If `true`, the usage of the service to be disabled will be checked and an error
               will be returned if the service to be disabled has usage in last 30 days.
               Defaults to `false`.
        :param pulumi.Input[_builtins.bool] disable_dependent_services: If `true`, services that are enabled
               and which depend on this service should also be disabled when this service is
               destroyed. If `false` or unset, an error will be generated if any enabled
               services depend on this service when destroying it.
        :param pulumi.Input[_builtins.str] project: The project ID. If not provided, the provider project
               is used.
        :param pulumi.Input[_builtins.str] service: The service to enable.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.projects.Service("project",
            project="your-project-id",
            service="iam.googleapis.com",
            disable_on_destroy=False)
        ```

        ## Import

        Project services can be imported using the `project_id` and `service`, e.g.

        * `{{project_id}}/{{service}}`

        When using the `pulumi import` command, project services can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:projects/service:Service default {{project_id}}/{{service}}
        ```

        Note that unlike other resources that fail if they already exist,

        `pulumi up` can be successfully used to verify already enabled services.

        This means that when importing existing resources into Terraform, you can either

        import the `google_project_service` resources or treat them as new

        infrastructure and run `pulumi up` to add them to state.

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 check_if_service_has_usage_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_dependent_services: Optional[pulumi.Input[_builtins.bool]] = None,
                 disable_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["check_if_service_has_usage_on_destroy"] = check_if_service_has_usage_on_destroy
            __props__.__dict__["disable_dependent_services"] = disable_dependent_services
            __props__.__dict__["disable_on_destroy"] = disable_on_destroy
            __props__.__dict__["project"] = project
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
        super(Service, __self__).__init__(
            'gcp:projects/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            check_if_service_has_usage_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_dependent_services: Optional[pulumi.Input[_builtins.bool]] = None,
            disable_on_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            service: Optional[pulumi.Input[_builtins.str]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] check_if_service_has_usage_on_destroy: Beta
               If `true`, the usage of the service to be disabled will be checked and an error
               will be returned if the service to be disabled has usage in last 30 days.
               Defaults to `false`.
        :param pulumi.Input[_builtins.bool] disable_dependent_services: If `true`, services that are enabled
               and which depend on this service should also be disabled when this service is
               destroyed. If `false` or unset, an error will be generated if any enabled
               services depend on this service when destroying it.
        :param pulumi.Input[_builtins.str] project: The project ID. If not provided, the provider project
               is used.
        :param pulumi.Input[_builtins.str] service: The service to enable.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["check_if_service_has_usage_on_destroy"] = check_if_service_has_usage_on_destroy
        __props__.__dict__["disable_dependent_services"] = disable_dependent_services
        __props__.__dict__["disable_on_destroy"] = disable_on_destroy
        __props__.__dict__["project"] = project
        __props__.__dict__["service"] = service
        return Service(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="checkIfServiceHasUsageOnDestroy")
    def check_if_service_has_usage_on_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Beta
        If `true`, the usage of the service to be disabled will be checked and an error
        will be returned if the service to be disabled has usage in last 30 days.
        Defaults to `false`.
        """
        return pulumi.get(self, "check_if_service_has_usage_on_destroy")

    @_builtins.property
    @pulumi.getter(name="disableDependentServices")
    def disable_dependent_services(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If `true`, services that are enabled
        and which depend on this service should also be disabled when this service is
        destroyed. If `false` or unset, an error will be generated if any enabled
        services depend on this service when destroying it.
        """
        return pulumi.get(self, "disable_dependent_services")

    @_builtins.property
    @pulumi.getter(name="disableOnDestroy")
    def disable_on_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "disable_on_destroy")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The project ID. If not provided, the provider project
        is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Output[_builtins.str]:
        """
        The service to enable.
        """
        return pulumi.get(self, "service")

