# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterUserCreatedConnectionsArgs', 'ClusterUserCreatedConnections']

@pulumi.input_type
class ClusterUserCreatedConnectionsArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[_builtins.str],
                 cluster_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterUserCreatedConnectionsClusterEndpointArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ClusterUserCreatedConnections resource.
        :param pulumi.Input[_builtins.str] region: The name of the region of the Redis cluster these endpoints should be added to.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterUserCreatedConnectionsClusterEndpointArgs']]] cluster_endpoints: A list of cluster endpoints
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the Redis cluster these endpoints should be added to.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "region", region)
        if cluster_endpoints is not None:
            pulumi.set(__self__, "cluster_endpoints", cluster_endpoints)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the region of the Redis cluster these endpoints should be added to.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="clusterEndpoints")
    def cluster_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterUserCreatedConnectionsClusterEndpointArgs']]]]:
        """
        A list of cluster endpoints
        Structure is documented below.
        """
        return pulumi.get(self, "cluster_endpoints")

    @cluster_endpoints.setter
    def cluster_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterUserCreatedConnectionsClusterEndpointArgs']]]]):
        pulumi.set(self, "cluster_endpoints", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Redis cluster these endpoints should be added to.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ClusterUserCreatedConnectionsState:
    def __init__(__self__, *,
                 cluster_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterUserCreatedConnectionsClusterEndpointArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ClusterUserCreatedConnections resources.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterUserCreatedConnectionsClusterEndpointArgs']]] cluster_endpoints: A list of cluster endpoints
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the Redis cluster these endpoints should be added to.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The name of the region of the Redis cluster these endpoints should be added to.
        """
        if cluster_endpoints is not None:
            pulumi.set(__self__, "cluster_endpoints", cluster_endpoints)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="clusterEndpoints")
    def cluster_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterUserCreatedConnectionsClusterEndpointArgs']]]]:
        """
        A list of cluster endpoints
        Structure is documented below.
        """
        return pulumi.get(self, "cluster_endpoints")

    @cluster_endpoints.setter
    def cluster_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterUserCreatedConnectionsClusterEndpointArgs']]]]):
        pulumi.set(self, "cluster_endpoints", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Redis cluster these endpoints should be added to.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the region of the Redis cluster these endpoints should be added to.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("gcp:redis/clusterUserCreatedConnections:ClusterUserCreatedConnections")
class ClusterUserCreatedConnections(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterUserCreatedConnectionsClusterEndpointArgs', 'ClusterUserCreatedConnectionsClusterEndpointArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Redis Cluster User Created Connections

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network1 = gcp.compute.Network("network1",
            name="net1",
            auto_create_subnetworks=False)
        subnet_network1 = gcp.compute.Subnetwork("subnet_network1",
            name="subnet-net1",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=network1.id)
        ip1_network1 = gcp.compute.Address("ip1_network1",
            name="ip1-net1",
            region="us-central1",
            subnetwork=subnet_network1.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        # redis cluster without endpoint
        cluster_user_conn_cluster = gcp.redis.Cluster("cluster-user-conn",
            name="cluster-user-conn",
            shard_count=3,
            region="us-central1",
            replica_count=0,
            deletion_protection_enabled=False)
        forwarding_rule1_network1 = gcp.compute.ForwardingRule("forwarding_rule1_network1",
            name="fwd1-net1",
            region="us-central1",
            ip_address=ip1_network1.id,
            load_balancing_scheme="",
            network=network1.id,
            target=cluster_user_conn_cluster.psc_service_attachments[0].service_attachment)
        ip2_network1 = gcp.compute.Address("ip2_network1",
            name="ip2-net1",
            region="us-central1",
            subnetwork=subnet_network1.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        forwarding_rule2_network1 = gcp.compute.ForwardingRule("forwarding_rule2_network1",
            name="fwd2-net1",
            region="us-central1",
            ip_address=ip2_network1.id,
            load_balancing_scheme="",
            network=network1.id,
            target=cluster_user_conn_cluster.psc_service_attachments[1].service_attachment)
        network2 = gcp.compute.Network("network2",
            name="network2",
            auto_create_subnetworks=False)
        subnet_network2 = gcp.compute.Subnetwork("subnet_network2",
            name="subnet-net2",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=network2.id)
        ip1_network2 = gcp.compute.Address("ip1_network2",
            name="ip1-net2",
            region="us-central1",
            subnetwork=subnet_network2.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        forwarding_rule1_network2 = gcp.compute.ForwardingRule("forwarding_rule1_network2",
            name="fwd1-net2",
            region="us-central1",
            ip_address=ip1_network2.id,
            load_balancing_scheme="",
            network=network2.id,
            target=cluster_user_conn_cluster.psc_service_attachments[0].service_attachment)
        ip2_network2 = gcp.compute.Address("ip2_network2",
            name="ip2-net2",
            region="us-central1",
            subnetwork=subnet_network2.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        forwarding_rule2_network2 = gcp.compute.ForwardingRule("forwarding_rule2_network2",
            name="fwd2-net2",
            region="us-central1",
            ip_address=ip2_network2.id,
            load_balancing_scheme="",
            network=network2.id,
            target=cluster_user_conn_cluster.psc_service_attachments[1].service_attachment)
        project = gcp.organizations.get_project()
        cluster_user_conn = gcp.redis.ClusterUserCreatedConnections("cluster-user-conn",
            name="cluster-user-conn",
            region="us-central1",
            cluster_endpoints=[
                {
                    "connections": [
                        {
                            "psc_connection": {
                                "psc_connection_id": forwarding_rule1_network1.psc_connection_id,
                                "address": ip1_network1.address,
                                "forwarding_rule": forwarding_rule1_network1.id,
                                "network": network1.id,
                                "project_id": project.project_id,
                                "service_attachment": cluster_user_conn_cluster.psc_service_attachments[0].service_attachment,
                            },
                        },
                        {
                            "psc_connection": {
                                "psc_connection_id": forwarding_rule2_network1.psc_connection_id,
                                "address": ip2_network1.address,
                                "forwarding_rule": forwarding_rule2_network1.id,
                                "network": network1.id,
                                "service_attachment": cluster_user_conn_cluster.psc_service_attachments[1].service_attachment,
                            },
                        },
                    ],
                },
                {
                    "connections": [
                        {
                            "psc_connection": {
                                "psc_connection_id": forwarding_rule1_network2.psc_connection_id,
                                "address": ip1_network2.address,
                                "forwarding_rule": forwarding_rule1_network2.id,
                                "network": network2.id,
                                "service_attachment": cluster_user_conn_cluster.psc_service_attachments[0].service_attachment,
                            },
                        },
                        {
                            "psc_connection": {
                                "psc_connection_id": forwarding_rule2_network2.psc_connection_id,
                                "address": ip2_network2.address,
                                "forwarding_rule": forwarding_rule2_network2.id,
                                "network": network2.id,
                                "service_attachment": cluster_user_conn_cluster.psc_service_attachments[1].service_attachment,
                            },
                        },
                    ],
                },
            ])
        ```
        ### Redis Cluster User And Auto Created Connections

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network2 = gcp.compute.Network("network2",
            name="network2",
            auto_create_subnetworks=False)
        subnet_network2 = gcp.compute.Subnetwork("subnet_network2",
            name="subnet-net2",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=network2.id)
        ip1_network2 = gcp.compute.Address("ip1_network2",
            name="ip1-net2",
            region="us-central1",
            subnetwork=subnet_network2.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        network1 = gcp.compute.Network("network1",
            name="net1",
            auto_create_subnetworks=False)
        subnet_network1 = gcp.compute.Subnetwork("subnet_network1",
            name="subnet-net1",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=network1.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="scpolicy",
            location="us-central1",
            service_class="gcp-memorystore-redis",
            description="my basic service connection policy",
            network=network1.id,
            psc_config={
                "subnetworks": [subnet_network1.id],
            })
        # redis cluster without endpoint
        cluster_user_auto_conn_cluster = gcp.redis.Cluster("cluster-user-auto-conn",
            name="cluster-user-auto-conn",
            shard_count=3,
            region="us-central1",
            replica_count=0,
            deletion_protection_enabled=False,
            psc_configs=[{
                "network": network1.id,
            }],
            opts = pulumi.ResourceOptions(depends_on=[default]))
        forwarding_rule1_network2 = gcp.compute.ForwardingRule("forwarding_rule1_network2",
            name="fwd1-net2",
            region="us-central1",
            ip_address=ip1_network2.id,
            load_balancing_scheme="",
            network=network2.id,
            target=cluster_user_auto_conn_cluster.psc_service_attachments[0].service_attachment)
        ip2_network2 = gcp.compute.Address("ip2_network2",
            name="ip2-net2",
            region="us-central1",
            subnetwork=subnet_network2.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        forwarding_rule2_network2 = gcp.compute.ForwardingRule("forwarding_rule2_network2",
            name="fwd2-net2",
            region="us-central1",
            ip_address=ip2_network2.id,
            load_balancing_scheme="",
            network=network2.id,
            target=cluster_user_auto_conn_cluster.psc_service_attachments[1].service_attachment)
        cluster_user_auto_conn = gcp.redis.ClusterUserCreatedConnections("cluster-user-auto-conn",
            name="cluster-user-auto-conn",
            region="us-central1",
            cluster_endpoints=[{
                "connections": [
                    {
                        "psc_connection": {
                            "psc_connection_id": forwarding_rule1_network2.psc_connection_id,
                            "address": ip1_network2.address,
                            "forwarding_rule": forwarding_rule1_network2.id,
                            "network": network2.id,
                            "service_attachment": cluster_user_auto_conn_cluster.psc_service_attachments[0].service_attachment,
                        },
                    },
                    {
                        "psc_connection": {
                            "psc_connection_id": forwarding_rule2_network2.psc_connection_id,
                            "address": ip2_network2.address,
                            "forwarding_rule": forwarding_rule2_network2.id,
                            "network": network2.id,
                            "service_attachment": cluster_user_auto_conn_cluster.psc_service_attachments[1].service_attachment,
                        },
                    },
                ],
            }])
        ```

        ## Import

        ClusterUserCreatedConnections can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/clusters/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, ClusterUserCreatedConnections can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:redis/clusterUserCreatedConnections:ClusterUserCreatedConnections default projects/{{project}}/locations/{{region}}/clusters/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/clusterUserCreatedConnections:ClusterUserCreatedConnections default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/clusterUserCreatedConnections:ClusterUserCreatedConnections default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/clusterUserCreatedConnections:ClusterUserCreatedConnections default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterUserCreatedConnectionsClusterEndpointArgs', 'ClusterUserCreatedConnectionsClusterEndpointArgsDict']]]] cluster_endpoints: A list of cluster endpoints
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the Redis cluster these endpoints should be added to.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The name of the region of the Redis cluster these endpoints should be added to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterUserCreatedConnectionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Redis Cluster User Created Connections

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network1 = gcp.compute.Network("network1",
            name="net1",
            auto_create_subnetworks=False)
        subnet_network1 = gcp.compute.Subnetwork("subnet_network1",
            name="subnet-net1",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=network1.id)
        ip1_network1 = gcp.compute.Address("ip1_network1",
            name="ip1-net1",
            region="us-central1",
            subnetwork=subnet_network1.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        # redis cluster without endpoint
        cluster_user_conn_cluster = gcp.redis.Cluster("cluster-user-conn",
            name="cluster-user-conn",
            shard_count=3,
            region="us-central1",
            replica_count=0,
            deletion_protection_enabled=False)
        forwarding_rule1_network1 = gcp.compute.ForwardingRule("forwarding_rule1_network1",
            name="fwd1-net1",
            region="us-central1",
            ip_address=ip1_network1.id,
            load_balancing_scheme="",
            network=network1.id,
            target=cluster_user_conn_cluster.psc_service_attachments[0].service_attachment)
        ip2_network1 = gcp.compute.Address("ip2_network1",
            name="ip2-net1",
            region="us-central1",
            subnetwork=subnet_network1.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        forwarding_rule2_network1 = gcp.compute.ForwardingRule("forwarding_rule2_network1",
            name="fwd2-net1",
            region="us-central1",
            ip_address=ip2_network1.id,
            load_balancing_scheme="",
            network=network1.id,
            target=cluster_user_conn_cluster.psc_service_attachments[1].service_attachment)
        network2 = gcp.compute.Network("network2",
            name="network2",
            auto_create_subnetworks=False)
        subnet_network2 = gcp.compute.Subnetwork("subnet_network2",
            name="subnet-net2",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=network2.id)
        ip1_network2 = gcp.compute.Address("ip1_network2",
            name="ip1-net2",
            region="us-central1",
            subnetwork=subnet_network2.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        forwarding_rule1_network2 = gcp.compute.ForwardingRule("forwarding_rule1_network2",
            name="fwd1-net2",
            region="us-central1",
            ip_address=ip1_network2.id,
            load_balancing_scheme="",
            network=network2.id,
            target=cluster_user_conn_cluster.psc_service_attachments[0].service_attachment)
        ip2_network2 = gcp.compute.Address("ip2_network2",
            name="ip2-net2",
            region="us-central1",
            subnetwork=subnet_network2.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        forwarding_rule2_network2 = gcp.compute.ForwardingRule("forwarding_rule2_network2",
            name="fwd2-net2",
            region="us-central1",
            ip_address=ip2_network2.id,
            load_balancing_scheme="",
            network=network2.id,
            target=cluster_user_conn_cluster.psc_service_attachments[1].service_attachment)
        project = gcp.organizations.get_project()
        cluster_user_conn = gcp.redis.ClusterUserCreatedConnections("cluster-user-conn",
            name="cluster-user-conn",
            region="us-central1",
            cluster_endpoints=[
                {
                    "connections": [
                        {
                            "psc_connection": {
                                "psc_connection_id": forwarding_rule1_network1.psc_connection_id,
                                "address": ip1_network1.address,
                                "forwarding_rule": forwarding_rule1_network1.id,
                                "network": network1.id,
                                "project_id": project.project_id,
                                "service_attachment": cluster_user_conn_cluster.psc_service_attachments[0].service_attachment,
                            },
                        },
                        {
                            "psc_connection": {
                                "psc_connection_id": forwarding_rule2_network1.psc_connection_id,
                                "address": ip2_network1.address,
                                "forwarding_rule": forwarding_rule2_network1.id,
                                "network": network1.id,
                                "service_attachment": cluster_user_conn_cluster.psc_service_attachments[1].service_attachment,
                            },
                        },
                    ],
                },
                {
                    "connections": [
                        {
                            "psc_connection": {
                                "psc_connection_id": forwarding_rule1_network2.psc_connection_id,
                                "address": ip1_network2.address,
                                "forwarding_rule": forwarding_rule1_network2.id,
                                "network": network2.id,
                                "service_attachment": cluster_user_conn_cluster.psc_service_attachments[0].service_attachment,
                            },
                        },
                        {
                            "psc_connection": {
                                "psc_connection_id": forwarding_rule2_network2.psc_connection_id,
                                "address": ip2_network2.address,
                                "forwarding_rule": forwarding_rule2_network2.id,
                                "network": network2.id,
                                "service_attachment": cluster_user_conn_cluster.psc_service_attachments[1].service_attachment,
                            },
                        },
                    ],
                },
            ])
        ```
        ### Redis Cluster User And Auto Created Connections

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network2 = gcp.compute.Network("network2",
            name="network2",
            auto_create_subnetworks=False)
        subnet_network2 = gcp.compute.Subnetwork("subnet_network2",
            name="subnet-net2",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=network2.id)
        ip1_network2 = gcp.compute.Address("ip1_network2",
            name="ip1-net2",
            region="us-central1",
            subnetwork=subnet_network2.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        network1 = gcp.compute.Network("network1",
            name="net1",
            auto_create_subnetworks=False)
        subnet_network1 = gcp.compute.Subnetwork("subnet_network1",
            name="subnet-net1",
            ip_cidr_range="10.0.0.248/29",
            region="us-central1",
            network=network1.id)
        default = gcp.networkconnectivity.ServiceConnectionPolicy("default",
            name="scpolicy",
            location="us-central1",
            service_class="gcp-memorystore-redis",
            description="my basic service connection policy",
            network=network1.id,
            psc_config={
                "subnetworks": [subnet_network1.id],
            })
        # redis cluster without endpoint
        cluster_user_auto_conn_cluster = gcp.redis.Cluster("cluster-user-auto-conn",
            name="cluster-user-auto-conn",
            shard_count=3,
            region="us-central1",
            replica_count=0,
            deletion_protection_enabled=False,
            psc_configs=[{
                "network": network1.id,
            }],
            opts = pulumi.ResourceOptions(depends_on=[default]))
        forwarding_rule1_network2 = gcp.compute.ForwardingRule("forwarding_rule1_network2",
            name="fwd1-net2",
            region="us-central1",
            ip_address=ip1_network2.id,
            load_balancing_scheme="",
            network=network2.id,
            target=cluster_user_auto_conn_cluster.psc_service_attachments[0].service_attachment)
        ip2_network2 = gcp.compute.Address("ip2_network2",
            name="ip2-net2",
            region="us-central1",
            subnetwork=subnet_network2.id,
            address_type="INTERNAL",
            purpose="GCE_ENDPOINT")
        forwarding_rule2_network2 = gcp.compute.ForwardingRule("forwarding_rule2_network2",
            name="fwd2-net2",
            region="us-central1",
            ip_address=ip2_network2.id,
            load_balancing_scheme="",
            network=network2.id,
            target=cluster_user_auto_conn_cluster.psc_service_attachments[1].service_attachment)
        cluster_user_auto_conn = gcp.redis.ClusterUserCreatedConnections("cluster-user-auto-conn",
            name="cluster-user-auto-conn",
            region="us-central1",
            cluster_endpoints=[{
                "connections": [
                    {
                        "psc_connection": {
                            "psc_connection_id": forwarding_rule1_network2.psc_connection_id,
                            "address": ip1_network2.address,
                            "forwarding_rule": forwarding_rule1_network2.id,
                            "network": network2.id,
                            "service_attachment": cluster_user_auto_conn_cluster.psc_service_attachments[0].service_attachment,
                        },
                    },
                    {
                        "psc_connection": {
                            "psc_connection_id": forwarding_rule2_network2.psc_connection_id,
                            "address": ip2_network2.address,
                            "forwarding_rule": forwarding_rule2_network2.id,
                            "network": network2.id,
                            "service_attachment": cluster_user_auto_conn_cluster.psc_service_attachments[1].service_attachment,
                        },
                    },
                ],
            }])
        ```

        ## Import

        ClusterUserCreatedConnections can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/clusters/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, ClusterUserCreatedConnections can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:redis/clusterUserCreatedConnections:ClusterUserCreatedConnections default projects/{{project}}/locations/{{region}}/clusters/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/clusterUserCreatedConnections:ClusterUserCreatedConnections default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/clusterUserCreatedConnections:ClusterUserCreatedConnections default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/clusterUserCreatedConnections:ClusterUserCreatedConnections default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ClusterUserCreatedConnectionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterUserCreatedConnectionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterUserCreatedConnectionsClusterEndpointArgs', 'ClusterUserCreatedConnectionsClusterEndpointArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterUserCreatedConnectionsArgs.__new__(ClusterUserCreatedConnectionsArgs)

            __props__.__dict__["cluster_endpoints"] = cluster_endpoints
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
        super(ClusterUserCreatedConnections, __self__).__init__(
            'gcp:redis/clusterUserCreatedConnections:ClusterUserCreatedConnections',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterUserCreatedConnectionsClusterEndpointArgs', 'ClusterUserCreatedConnectionsClusterEndpointArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'ClusterUserCreatedConnections':
        """
        Get an existing ClusterUserCreatedConnections resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterUserCreatedConnectionsClusterEndpointArgs', 'ClusterUserCreatedConnectionsClusterEndpointArgsDict']]]] cluster_endpoints: A list of cluster endpoints
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the Redis cluster these endpoints should be added to.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The name of the region of the Redis cluster these endpoints should be added to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterUserCreatedConnectionsState.__new__(_ClusterUserCreatedConnectionsState)

        __props__.__dict__["cluster_endpoints"] = cluster_endpoints
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        return ClusterUserCreatedConnections(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterEndpoints")
    def cluster_endpoints(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterUserCreatedConnectionsClusterEndpoint']]]:
        """
        A list of cluster endpoints
        Structure is documented below.
        """
        return pulumi.get(self, "cluster_endpoints")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Redis cluster these endpoints should be added to.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the region of the Redis cluster these endpoints should be added to.
        """
        return pulumi.get(self, "region")

