# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CapabilityArgs', 'Capability']

@pulumi.input_type
class CapabilityArgs:
    def __init__(__self__, *,
                 capability_name: pulumi.Input[_builtins.str],
                 parent: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.bool]):
        """
        The set of arguments for constructing a Capability resource.
        :param pulumi.Input[_builtins.str] capability_name: Capability name that should be updated on the folder.
        :param pulumi.Input[_builtins.str] parent: Folder on which Capability needs to be updated in the format folders/folder_id.
        :param pulumi.Input[_builtins.bool] value: Capability Value.
        """
        pulumi.set(__self__, "capability_name", capability_name)
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="capabilityName")
    def capability_name(self) -> pulumi.Input[_builtins.str]:
        """
        Capability name that should be updated on the folder.
        """
        return pulumi.get(self, "capability_name")

    @capability_name.setter
    def capability_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "capability_name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Input[_builtins.str]:
        """
        Folder on which Capability needs to be updated in the format folders/folder_id.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.bool]:
        """
        Capability Value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class _CapabilityState:
    def __init__(__self__, *,
                 capability_name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Capability resources.
        :param pulumi.Input[_builtins.str] capability_name: Capability name that should be updated on the folder.
        :param pulumi.Input[_builtins.str] parent: Folder on which Capability needs to be updated in the format folders/folder_id.
        :param pulumi.Input[_builtins.bool] value: Capability Value.
        """
        if capability_name is not None:
            pulumi.set(__self__, "capability_name", capability_name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="capabilityName")
    def capability_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Capability name that should be updated on the folder.
        """
        return pulumi.get(self, "capability_name")

    @capability_name.setter
    def capability_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capability_name", value)

    @_builtins.property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Folder on which Capability needs to be updated in the format folders/folder_id.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Capability Value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "value", value)


@pulumi.type_token("gcp:resourcemanager/capability:Capability")
class Capability(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capability_name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Resource Manager Capability

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        folder = gcp.organizations.Folder("folder",
            display_name="my-folder",
            parent="organizations/123456789",
            deletion_protection=False)
        wait60s = time.index.Sleep("wait_60s", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[folder]))
        capability = gcp.resourcemanager.Capability("capability",
            value=True,
            parent=folder.name,
            capability_name="app-management",
            opts = pulumi.ResourceOptions(depends_on=[wait60s]))
        ```

        ## Import

        Capability can be imported using any of these accepted formats:

        * `{{parent}}/capabilities/{{capability_name}}`

        * `{{parent}}/{{capability_name}}`

        When using the `pulumi import` command, Capability can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:resourcemanager/capability:Capability default {{parent}}/capabilities/{{capability_name}}
        ```

        ```sh
        $ pulumi import gcp:resourcemanager/capability:Capability default {{parent}}/{{capability_name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] capability_name: Capability name that should be updated on the folder.
        :param pulumi.Input[_builtins.str] parent: Folder on which Capability needs to be updated in the format folders/folder_id.
        :param pulumi.Input[_builtins.bool] value: Capability Value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CapabilityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Resource Manager Capability

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        folder = gcp.organizations.Folder("folder",
            display_name="my-folder",
            parent="organizations/123456789",
            deletion_protection=False)
        wait60s = time.index.Sleep("wait_60s", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[folder]))
        capability = gcp.resourcemanager.Capability("capability",
            value=True,
            parent=folder.name,
            capability_name="app-management",
            opts = pulumi.ResourceOptions(depends_on=[wait60s]))
        ```

        ## Import

        Capability can be imported using any of these accepted formats:

        * `{{parent}}/capabilities/{{capability_name}}`

        * `{{parent}}/{{capability_name}}`

        When using the `pulumi import` command, Capability can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:resourcemanager/capability:Capability default {{parent}}/capabilities/{{capability_name}}
        ```

        ```sh
        $ pulumi import gcp:resourcemanager/capability:Capability default {{parent}}/{{capability_name}}
        ```

        :param str resource_name: The name of the resource.
        :param CapabilityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CapabilityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capability_name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CapabilityArgs.__new__(CapabilityArgs)

            if capability_name is None and not opts.urn:
                raise TypeError("Missing required property 'capability_name'")
            __props__.__dict__["capability_name"] = capability_name
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
        super(Capability, __self__).__init__(
            'gcp:resourcemanager/capability:Capability',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capability_name: Optional[pulumi.Input[_builtins.str]] = None,
            parent: Optional[pulumi.Input[_builtins.str]] = None,
            value: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Capability':
        """
        Get an existing Capability resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] capability_name: Capability name that should be updated on the folder.
        :param pulumi.Input[_builtins.str] parent: Folder on which Capability needs to be updated in the format folders/folder_id.
        :param pulumi.Input[_builtins.bool] value: Capability Value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CapabilityState.__new__(_CapabilityState)

        __props__.__dict__["capability_name"] = capability_name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["value"] = value
        return Capability(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="capabilityName")
    def capability_name(self) -> pulumi.Output[_builtins.str]:
        """
        Capability name that should be updated on the folder.
        """
        return pulumi.get(self, "capability_name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> pulumi.Output[_builtins.str]:
        """
        Folder on which Capability needs to be updated in the format folders/folder_id.
        """
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Output[_builtins.bool]:
        """
        Capability Value.
        """
        return pulumi.get(self, "value")

