# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 private_config: Optional[pulumi.Input['InstancePrivateConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 workforce_identity_federation_config: Optional[pulumi.Input['InstanceWorkforceIdentityFederationConfigArgs']] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] instance_id: The name for the Instance.
        :param pulumi.Input[_builtins.str] location: The location for the Instance.
        :param pulumi.Input[_builtins.str] deletion_policy: The deletion policy for the instance. Setting `ABANDON` allows the resource
               to be abandoned, rather than deleted. Setting `DELETE` deletes the resource
               and all its contents. Setting `PREVENT` prevents the resource from accidental
               deletion by erroring out during plan.
               Default is `DELETE`.  Possible values are:
               * DELETE
               * PREVENT
               * ABANDON
        :param pulumi.Input[_builtins.str] kms_key: Customer-managed encryption key name, in the format projects/*/locations/*/keyRings/*/cryptoKeys/*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['InstancePrivateConfigArgs'] private_config: Private settings for private instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['InstanceWorkforceIdentityFederationConfigArgs'] workforce_identity_federation_config: Configuration for Workforce Identity Federation to support third party identity provider.
               If unset, defaults to the Google OIDC IdP.
               Structure is documented below.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "location", location)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if private_config is not None:
            pulumi.set(__self__, "private_config", private_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if workforce_identity_federation_config is not None:
            pulumi.set(__self__, "workforce_identity_federation_config", workforce_identity_federation_config)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The name for the Instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location for the Instance.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The deletion policy for the instance. Setting `ABANDON` allows the resource
        to be abandoned, rather than deleted. Setting `DELETE` deletes the resource
        and all its contents. Setting `PREVENT` prevents the resource from accidental
        deletion by erroring out during plan.
        Default is `DELETE`.  Possible values are:
        * DELETE
        * PREVENT
        * ABANDON
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Customer-managed encryption key name, in the format projects/*/locations/*/keyRings/*/cryptoKeys/*.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels as key value pairs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="privateConfig")
    def private_config(self) -> Optional[pulumi.Input['InstancePrivateConfigArgs']]:
        """
        Private settings for private instance.
        Structure is documented below.
        """
        return pulumi.get(self, "private_config")

    @private_config.setter
    def private_config(self, value: Optional[pulumi.Input['InstancePrivateConfigArgs']]):
        pulumi.set(self, "private_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="workforceIdentityFederationConfig")
    def workforce_identity_federation_config(self) -> Optional[pulumi.Input['InstanceWorkforceIdentityFederationConfigArgs']]:
        """
        Configuration for Workforce Identity Federation to support third party identity provider.
        If unset, defaults to the Google OIDC IdP.
        Structure is documented below.
        """
        return pulumi.get(self, "workforce_identity_federation_config")

    @workforce_identity_federation_config.setter
    def workforce_identity_federation_config(self, value: Optional[pulumi.Input['InstanceWorkforceIdentityFederationConfigArgs']]):
        pulumi.set(self, "workforce_identity_federation_config", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 host_configs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceHostConfigArgs']]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_config: Optional[pulumi.Input['InstancePrivateConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 state_note: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 workforce_identity_federation_config: Optional[pulumi.Input['InstanceWorkforceIdentityFederationConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] create_time: Time the Instance was created in UTC.
        :param pulumi.Input[_builtins.str] deletion_policy: The deletion policy for the instance. Setting `ABANDON` allows the resource
               to be abandoned, rather than deleted. Setting `DELETE` deletes the resource
               and all its contents. Setting `PREVENT` prevents the resource from accidental
               deletion by erroring out during plan.
               Default is `DELETE`.  Possible values are:
               * DELETE
               * PREVENT
               * ABANDON
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceHostConfigArgs']]] host_configs: A list of hostnames for this instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] instance_id: The name for the Instance.
        :param pulumi.Input[_builtins.str] kms_key: Customer-managed encryption key name, in the format projects/*/locations/*/keyRings/*/cryptoKeys/*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location for the Instance.
        :param pulumi.Input[_builtins.str] name: The resource name for the Instance.
        :param pulumi.Input['InstancePrivateConfigArgs'] private_config: Private settings for private instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] state: The current state of the Instance.
        :param pulumi.Input[_builtins.str] state_note: Provides information about the current instance state.
        :param pulumi.Input[_builtins.str] update_time: Time the Instance was updated in UTC.
        :param pulumi.Input['InstanceWorkforceIdentityFederationConfigArgs'] workforce_identity_federation_config: Configuration for Workforce Identity Federation to support third party identity provider.
               If unset, defaults to the Google OIDC IdP.
               Structure is documented below.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if host_configs is not None:
            pulumi.set(__self__, "host_configs", host_configs)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_config is not None:
            pulumi.set(__self__, "private_config", private_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_note is not None:
            pulumi.set(__self__, "state_note", state_note)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if workforce_identity_federation_config is not None:
            pulumi.set(__self__, "workforce_identity_federation_config", workforce_identity_federation_config)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the Instance was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The deletion policy for the instance. Setting `ABANDON` allows the resource
        to be abandoned, rather than deleted. Setting `DELETE` deletes the resource
        and all its contents. Setting `PREVENT` prevents the resource from accidental
        deletion by erroring out during plan.
        Default is `DELETE`.  Possible values are:
        * DELETE
        * PREVENT
        * ABANDON
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="hostConfigs")
    def host_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceHostConfigArgs']]]]:
        """
        A list of hostnames for this instance.
        Structure is documented below.
        """
        return pulumi.get(self, "host_configs")

    @host_configs.setter
    def host_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceHostConfigArgs']]]]):
        pulumi.set(self, "host_configs", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the Instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Customer-managed encryption key name, in the format projects/*/locations/*/keyRings/*/cryptoKeys/*.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels as key value pairs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location for the Instance.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name for the Instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateConfig")
    def private_config(self) -> Optional[pulumi.Input['InstancePrivateConfigArgs']]:
        """
        Private settings for private instance.
        Structure is documented below.
        """
        return pulumi.get(self, "private_config")

    @private_config.setter
    def private_config(self, value: Optional[pulumi.Input['InstancePrivateConfigArgs']]):
        pulumi.set(self, "private_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the Instance.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="stateNote")
    def state_note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provides information about the current instance state.
        """
        return pulumi.get(self, "state_note")

    @state_note.setter
    def state_note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state_note", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the Instance was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="workforceIdentityFederationConfig")
    def workforce_identity_federation_config(self) -> Optional[pulumi.Input['InstanceWorkforceIdentityFederationConfigArgs']]:
        """
        Configuration for Workforce Identity Federation to support third party identity provider.
        If unset, defaults to the Google OIDC IdP.
        Structure is documented below.
        """
        return pulumi.get(self, "workforce_identity_federation_config")

    @workforce_identity_federation_config.setter
    def workforce_identity_federation_config(self, value: Optional[pulumi.Input['InstanceWorkforceIdentityFederationConfigArgs']]):
        pulumi.set(self, "workforce_identity_federation_config", value)


@pulumi.type_token("gcp:securesourcemanager/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 private_config: Optional[pulumi.Input[Union['InstancePrivateConfigArgs', 'InstancePrivateConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 workforce_identity_federation_config: Optional[pulumi.Input[Union['InstanceWorkforceIdentityFederationConfigArgs', 'InstanceWorkforceIdentityFederationConfigArgsDict']]] = None,
                 __props__=None):
        """
        Instances are deployed to an available Google Cloud region and are accessible via their web interface.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/secure-source-manager/docs/reference/rest/v1/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/secure-source-manager/docs/create-instance)

        ## Example Usage

        ### Secure Source Manager Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.securesourcemanager.Instance("default",
            location="us-central1",
            instance_id="my-instance",
            labels={
                "foo": "bar",
            },
            deletion_policy="PREVENT")
        ```
        ### Secure Source Manager Instance Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        crypto_key_binding = gcp.kms.CryptoKeyIAMMember("crypto_key_binding",
            crypto_key_id="my-key",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-sourcemanager.iam.gserviceaccount.com")
        default = gcp.securesourcemanager.Instance("default",
            location="us-central1",
            instance_id="my-instance",
            kms_key="my-key",
            deletion_policy="PREVENT",
            opts = pulumi.ResourceOptions(depends_on=[crypto_key_binding]))
        ```
        ### Secure Source Manager Instance Private

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        ca_pool = gcp.certificateauthority.CaPool("ca_pool",
            name="ca-pool",
            location="us-central1",
            tier="ENTERPRISE",
            publishing_options={
                "publish_ca_cert": True,
                "publish_crl": True,
            })
        root_ca = gcp.certificateauthority.Authority("root_ca",
            pool=ca_pool.name,
            certificate_authority_id="root-ca",
            location="us-central1",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "google",
                        "common_name": "my-certificate-authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            ignore_active_certificates_on_deletion=True,
            skip_grace_period=True)
        project = gcp.organizations.get_project()
        ca_pool_binding = gcp.certificateauthority.CaPoolIamBinding("ca_pool_binding",
            ca_pool=ca_pool.id,
            role="roles/privateca.certificateRequester",
            members=[f"serviceAccount:service-{project.number}@gcp-sa-sourcemanager.iam.gserviceaccount.com"])
        # ca pool IAM permissions can take time to propagate
        wait120_seconds = time.index.Sleep("wait_120_seconds", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[ca_pool_binding]))
        default = gcp.securesourcemanager.Instance("default",
            instance_id="my-instance",
            location="us-central1",
            private_config={
                "is_private": True,
                "ca_pool": ca_pool.id,
            },
            deletion_policy="PREVENT",
            opts = pulumi.ResourceOptions(depends_on=[
                    root_ca,
                    wait120_seconds,
                ]))
        ```
        ### Secure Source Manager Instance Private Psc Backend

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = gcp.organizations.get_project()
        ca_pool = gcp.certificateauthority.CaPool("ca_pool",
            name="ca-pool",
            location="us-central1",
            tier="ENTERPRISE",
            publishing_options={
                "publish_ca_cert": True,
                "publish_crl": True,
            })
        root_ca = gcp.certificateauthority.Authority("root_ca",
            pool=ca_pool.name,
            certificate_authority_id="root-ca",
            location="us-central1",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "google",
                        "common_name": "my-certificate-authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            ignore_active_certificates_on_deletion=True,
            skip_grace_period=True)
        ca_pool_binding = gcp.certificateauthority.CaPoolIamBinding("ca_pool_binding",
            ca_pool=ca_pool.id,
            role="roles/privateca.certificateRequester",
            members=[f"serviceAccount:service-{project.number}@gcp-sa-sourcemanager.iam.gserviceaccount.com"])
        # ca pool IAM permissions can take time to propagate
        wait120_seconds = time.index.Sleep("wait_120_seconds", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[ca_pool_binding]))
        # See https://cloud.google.com/secure-source-manager/docs/create-private-service-connect-instance#root-ca-api
        default = gcp.securesourcemanager.Instance("default",
            instance_id="my-instance",
            location="us-central1",
            private_config={
                "is_private": True,
                "ca_pool": ca_pool.id,
            },
            deletion_policy="PREVENT",
            opts = pulumi.ResourceOptions(depends_on=[
                    root_ca,
                    wait120_seconds,
                ]))
        # Connect SSM private instance with L4 proxy ILB.
        network = gcp.compute.Network("network",
            name="my-network",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnet",
            region="us-central1",
            network=network.id,
            ip_cidr_range="10.0.1.0/24",
            private_ip_google_access=True)
        psc_neg = gcp.compute.RegionNetworkEndpointGroup("psc_neg",
            name="my-neg",
            region="us-central1",
            network_endpoint_type="PRIVATE_SERVICE_CONNECT",
            psc_target_service=default.private_config.http_service_attachment,
            network=network.id,
            subnetwork=subnet.id)
        backend_service = gcp.compute.RegionBackendService("backend_service",
            name="my-backend-service",
            region="us-central1",
            protocol="TCP",
            load_balancing_scheme="INTERNAL_MANAGED",
            backends=[{
                "group": psc_neg.id,
                "balancing_mode": "UTILIZATION",
                "capacity_scaler": 1,
            }])
        proxy_subnet = gcp.compute.Subnetwork("proxy_subnet",
            name="my-proxy-subnet",
            region="us-central1",
            network=network.id,
            ip_cidr_range="10.0.2.0/24",
            purpose="REGIONAL_MANAGED_PROXY",
            role="ACTIVE")
        target_proxy = gcp.compute.RegionTargetTcpProxy("target_proxy",
            name="my-target-proxy",
            region="us-central1",
            backend_service=backend_service.id)
        fw_rule_target_proxy = gcp.compute.ForwardingRule("fw_rule_target_proxy",
            name="fw-rule-target-proxy",
            region="us-central1",
            load_balancing_scheme="INTERNAL_MANAGED",
            ip_protocol="TCP",
            port_range="443",
            target=target_proxy.id,
            network=network.id,
            subnetwork=subnet.id,
            network_tier="PREMIUM",
            opts = pulumi.ResourceOptions(depends_on=[proxy_subnet]))
        private_zone = gcp.dns.ManagedZone("private_zone",
            name="my-dns-zone",
            dns_name="p.sourcemanager.dev.",
            visibility="private",
            private_visibility_config={
                "networks": [{
                    "network_url": network.id,
                }],
            })
        ssm_instance_html_record = gcp.dns.RecordSet("ssm_instance_html_record",
            name=default.host_configs.apply(lambda host_configs: f"{host_configs[0].html}."),
            type="A",
            ttl=300,
            managed_zone=private_zone.name,
            rrdatas=[fw_rule_target_proxy.ip_address])
        ssm_instance_api_record = gcp.dns.RecordSet("ssm_instance_api_record",
            name=default.host_configs.apply(lambda host_configs: f"{host_configs[0].api}."),
            type="A",
            ttl=300,
            managed_zone=private_zone.name,
            rrdatas=[fw_rule_target_proxy.ip_address])
        ssm_instance_git_record = gcp.dns.RecordSet("ssm_instance_git_record",
            name=default.host_configs.apply(lambda host_configs: f"{host_configs[0].git_http}."),
            type="A",
            ttl=300,
            managed_zone=private_zone.name,
            rrdatas=[fw_rule_target_proxy.ip_address])
        ```
        ### Secure Source Manager Instance Private Psc Endpoint

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = gcp.organizations.get_project()
        ca_pool = gcp.certificateauthority.CaPool("ca_pool",
            name="ca-pool",
            location="us-central1",
            tier="ENTERPRISE",
            publishing_options={
                "publish_ca_cert": True,
                "publish_crl": True,
            })
        root_ca = gcp.certificateauthority.Authority("root_ca",
            pool=ca_pool.name,
            certificate_authority_id="root-ca",
            location="us-central1",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "google",
                        "common_name": "my-certificate-authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            ignore_active_certificates_on_deletion=True,
            skip_grace_period=True)
        ca_pool_binding = gcp.certificateauthority.CaPoolIamBinding("ca_pool_binding",
            ca_pool=ca_pool.id,
            role="roles/privateca.certificateRequester",
            members=[f"serviceAccount:service-{project.number}@gcp-sa-sourcemanager.iam.gserviceaccount.com"])
        # ca pool IAM permissions can take time to propagate
        wait120_seconds = time.index.Sleep("wait_120_seconds", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[ca_pool_binding]))
        # See https://cloud.google.com/secure-source-manager/docs/create-private-service-connect-instance#root-ca-api
        default = gcp.securesourcemanager.Instance("default",
            instance_id="my-instance",
            location="us-central1",
            private_config={
                "is_private": True,
                "ca_pool": ca_pool.id,
            },
            deletion_policy="PREVENT",
            opts = pulumi.ResourceOptions(depends_on=[
                    root_ca,
                    wait120_seconds,
                ]))
        # Connect SSM private instance with endpoint.
        network = gcp.compute.Network("network",
            name="my-network",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnet",
            region="us-central1",
            network=network.id,
            ip_cidr_range="10.0.60.0/24",
            private_ip_google_access=True)
        address = gcp.compute.Address("address",
            name="my-address",
            region="us-central1",
            address="10.0.60.100",
            address_type="INTERNAL",
            subnetwork=subnet.id)
        fw_rule_service_attachment = gcp.compute.ForwardingRule("fw_rule_service_attachment",
            name="fw-rule-service-attachment",
            region="us-central1",
            load_balancing_scheme="",
            ip_address=address.id,
            network=network.id,
            target=default.private_config.http_service_attachment)
        private_zone = gcp.dns.ManagedZone("private_zone",
            name="my-dns-zone",
            dns_name="p.sourcemanager.dev.",
            visibility="private",
            private_visibility_config={
                "networks": [{
                    "network_url": network.id,
                }],
            })
        ssm_instance_html_record = gcp.dns.RecordSet("ssm_instance_html_record",
            name=default.host_configs.apply(lambda host_configs: f"{host_configs[0].html}."),
            type="A",
            ttl=300,
            managed_zone=private_zone.name,
            rrdatas=[fw_rule_service_attachment.ip_address])
        ssm_instance_api_record = gcp.dns.RecordSet("ssm_instance_api_record",
            name=default.host_configs.apply(lambda host_configs: f"{host_configs[0].api}."),
            type="A",
            ttl=300,
            managed_zone=private_zone.name,
            rrdatas=[fw_rule_service_attachment.ip_address])
        ssm_instance_git_record = gcp.dns.RecordSet("ssm_instance_git_record",
            name=default.host_configs.apply(lambda host_configs: f"{host_configs[0].git_http}."),
            type="A",
            ttl=300,
            managed_zone=private_zone.name,
            rrdatas=[fw_rule_service_attachment.ip_address])
        ```
        ### Secure Source Manager Instance Workforce Identity Federation

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.securesourcemanager.Instance("default",
            location="us-central1",
            instance_id="my-instance",
            workforce_identity_federation_config={
                "enabled": True,
            },
            deletion_policy="PREVENT")
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance_id}}`

        * `{{project}}/{{location}}/{{instance_id}}`

        * `{{location}}/{{instance_id}}`

        * `{{instance_id}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securesourcemanager/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/instance:Instance default {{project}}/{{location}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/instance:Instance default {{location}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/instance:Instance default {{instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] deletion_policy: The deletion policy for the instance. Setting `ABANDON` allows the resource
               to be abandoned, rather than deleted. Setting `DELETE` deletes the resource
               and all its contents. Setting `PREVENT` prevents the resource from accidental
               deletion by erroring out during plan.
               Default is `DELETE`.  Possible values are:
               * DELETE
               * PREVENT
               * ABANDON
        :param pulumi.Input[_builtins.str] instance_id: The name for the Instance.
        :param pulumi.Input[_builtins.str] kms_key: Customer-managed encryption key name, in the format projects/*/locations/*/keyRings/*/cryptoKeys/*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location for the Instance.
        :param pulumi.Input[Union['InstancePrivateConfigArgs', 'InstancePrivateConfigArgsDict']] private_config: Private settings for private instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['InstanceWorkforceIdentityFederationConfigArgs', 'InstanceWorkforceIdentityFederationConfigArgsDict']] workforce_identity_federation_config: Configuration for Workforce Identity Federation to support third party identity provider.
               If unset, defaults to the Google OIDC IdP.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Instances are deployed to an available Google Cloud region and are accessible via their web interface.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/secure-source-manager/docs/reference/rest/v1/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/secure-source-manager/docs/create-instance)

        ## Example Usage

        ### Secure Source Manager Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.securesourcemanager.Instance("default",
            location="us-central1",
            instance_id="my-instance",
            labels={
                "foo": "bar",
            },
            deletion_policy="PREVENT")
        ```
        ### Secure Source Manager Instance Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        crypto_key_binding = gcp.kms.CryptoKeyIAMMember("crypto_key_binding",
            crypto_key_id="my-key",
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-sourcemanager.iam.gserviceaccount.com")
        default = gcp.securesourcemanager.Instance("default",
            location="us-central1",
            instance_id="my-instance",
            kms_key="my-key",
            deletion_policy="PREVENT",
            opts = pulumi.ResourceOptions(depends_on=[crypto_key_binding]))
        ```
        ### Secure Source Manager Instance Private

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        ca_pool = gcp.certificateauthority.CaPool("ca_pool",
            name="ca-pool",
            location="us-central1",
            tier="ENTERPRISE",
            publishing_options={
                "publish_ca_cert": True,
                "publish_crl": True,
            })
        root_ca = gcp.certificateauthority.Authority("root_ca",
            pool=ca_pool.name,
            certificate_authority_id="root-ca",
            location="us-central1",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "google",
                        "common_name": "my-certificate-authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            ignore_active_certificates_on_deletion=True,
            skip_grace_period=True)
        project = gcp.organizations.get_project()
        ca_pool_binding = gcp.certificateauthority.CaPoolIamBinding("ca_pool_binding",
            ca_pool=ca_pool.id,
            role="roles/privateca.certificateRequester",
            members=[f"serviceAccount:service-{project.number}@gcp-sa-sourcemanager.iam.gserviceaccount.com"])
        # ca pool IAM permissions can take time to propagate
        wait120_seconds = time.index.Sleep("wait_120_seconds", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[ca_pool_binding]))
        default = gcp.securesourcemanager.Instance("default",
            instance_id="my-instance",
            location="us-central1",
            private_config={
                "is_private": True,
                "ca_pool": ca_pool.id,
            },
            deletion_policy="PREVENT",
            opts = pulumi.ResourceOptions(depends_on=[
                    root_ca,
                    wait120_seconds,
                ]))
        ```
        ### Secure Source Manager Instance Private Psc Backend

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = gcp.organizations.get_project()
        ca_pool = gcp.certificateauthority.CaPool("ca_pool",
            name="ca-pool",
            location="us-central1",
            tier="ENTERPRISE",
            publishing_options={
                "publish_ca_cert": True,
                "publish_crl": True,
            })
        root_ca = gcp.certificateauthority.Authority("root_ca",
            pool=ca_pool.name,
            certificate_authority_id="root-ca",
            location="us-central1",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "google",
                        "common_name": "my-certificate-authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            ignore_active_certificates_on_deletion=True,
            skip_grace_period=True)
        ca_pool_binding = gcp.certificateauthority.CaPoolIamBinding("ca_pool_binding",
            ca_pool=ca_pool.id,
            role="roles/privateca.certificateRequester",
            members=[f"serviceAccount:service-{project.number}@gcp-sa-sourcemanager.iam.gserviceaccount.com"])
        # ca pool IAM permissions can take time to propagate
        wait120_seconds = time.index.Sleep("wait_120_seconds", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[ca_pool_binding]))
        # See https://cloud.google.com/secure-source-manager/docs/create-private-service-connect-instance#root-ca-api
        default = gcp.securesourcemanager.Instance("default",
            instance_id="my-instance",
            location="us-central1",
            private_config={
                "is_private": True,
                "ca_pool": ca_pool.id,
            },
            deletion_policy="PREVENT",
            opts = pulumi.ResourceOptions(depends_on=[
                    root_ca,
                    wait120_seconds,
                ]))
        # Connect SSM private instance with L4 proxy ILB.
        network = gcp.compute.Network("network",
            name="my-network",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnet",
            region="us-central1",
            network=network.id,
            ip_cidr_range="10.0.1.0/24",
            private_ip_google_access=True)
        psc_neg = gcp.compute.RegionNetworkEndpointGroup("psc_neg",
            name="my-neg",
            region="us-central1",
            network_endpoint_type="PRIVATE_SERVICE_CONNECT",
            psc_target_service=default.private_config.http_service_attachment,
            network=network.id,
            subnetwork=subnet.id)
        backend_service = gcp.compute.RegionBackendService("backend_service",
            name="my-backend-service",
            region="us-central1",
            protocol="TCP",
            load_balancing_scheme="INTERNAL_MANAGED",
            backends=[{
                "group": psc_neg.id,
                "balancing_mode": "UTILIZATION",
                "capacity_scaler": 1,
            }])
        proxy_subnet = gcp.compute.Subnetwork("proxy_subnet",
            name="my-proxy-subnet",
            region="us-central1",
            network=network.id,
            ip_cidr_range="10.0.2.0/24",
            purpose="REGIONAL_MANAGED_PROXY",
            role="ACTIVE")
        target_proxy = gcp.compute.RegionTargetTcpProxy("target_proxy",
            name="my-target-proxy",
            region="us-central1",
            backend_service=backend_service.id)
        fw_rule_target_proxy = gcp.compute.ForwardingRule("fw_rule_target_proxy",
            name="fw-rule-target-proxy",
            region="us-central1",
            load_balancing_scheme="INTERNAL_MANAGED",
            ip_protocol="TCP",
            port_range="443",
            target=target_proxy.id,
            network=network.id,
            subnetwork=subnet.id,
            network_tier="PREMIUM",
            opts = pulumi.ResourceOptions(depends_on=[proxy_subnet]))
        private_zone = gcp.dns.ManagedZone("private_zone",
            name="my-dns-zone",
            dns_name="p.sourcemanager.dev.",
            visibility="private",
            private_visibility_config={
                "networks": [{
                    "network_url": network.id,
                }],
            })
        ssm_instance_html_record = gcp.dns.RecordSet("ssm_instance_html_record",
            name=default.host_configs.apply(lambda host_configs: f"{host_configs[0].html}."),
            type="A",
            ttl=300,
            managed_zone=private_zone.name,
            rrdatas=[fw_rule_target_proxy.ip_address])
        ssm_instance_api_record = gcp.dns.RecordSet("ssm_instance_api_record",
            name=default.host_configs.apply(lambda host_configs: f"{host_configs[0].api}."),
            type="A",
            ttl=300,
            managed_zone=private_zone.name,
            rrdatas=[fw_rule_target_proxy.ip_address])
        ssm_instance_git_record = gcp.dns.RecordSet("ssm_instance_git_record",
            name=default.host_configs.apply(lambda host_configs: f"{host_configs[0].git_http}."),
            type="A",
            ttl=300,
            managed_zone=private_zone.name,
            rrdatas=[fw_rule_target_proxy.ip_address])
        ```
        ### Secure Source Manager Instance Private Psc Endpoint

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        project = gcp.organizations.get_project()
        ca_pool = gcp.certificateauthority.CaPool("ca_pool",
            name="ca-pool",
            location="us-central1",
            tier="ENTERPRISE",
            publishing_options={
                "publish_ca_cert": True,
                "publish_crl": True,
            })
        root_ca = gcp.certificateauthority.Authority("root_ca",
            pool=ca_pool.name,
            certificate_authority_id="root-ca",
            location="us-central1",
            config={
                "subject_config": {
                    "subject": {
                        "organization": "google",
                        "common_name": "my-certificate-authority",
                    },
                },
                "x509_config": {
                    "ca_options": {
                        "is_ca": True,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "cert_sign": True,
                            "crl_sign": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                        },
                    },
                },
            },
            key_spec={
                "algorithm": "RSA_PKCS1_4096_SHA256",
            },
            deletion_protection=False,
            ignore_active_certificates_on_deletion=True,
            skip_grace_period=True)
        ca_pool_binding = gcp.certificateauthority.CaPoolIamBinding("ca_pool_binding",
            ca_pool=ca_pool.id,
            role="roles/privateca.certificateRequester",
            members=[f"serviceAccount:service-{project.number}@gcp-sa-sourcemanager.iam.gserviceaccount.com"])
        # ca pool IAM permissions can take time to propagate
        wait120_seconds = time.index.Sleep("wait_120_seconds", create_duration=120s,
        opts = pulumi.ResourceOptions(depends_on=[ca_pool_binding]))
        # See https://cloud.google.com/secure-source-manager/docs/create-private-service-connect-instance#root-ca-api
        default = gcp.securesourcemanager.Instance("default",
            instance_id="my-instance",
            location="us-central1",
            private_config={
                "is_private": True,
                "ca_pool": ca_pool.id,
            },
            deletion_policy="PREVENT",
            opts = pulumi.ResourceOptions(depends_on=[
                    root_ca,
                    wait120_seconds,
                ]))
        # Connect SSM private instance with endpoint.
        network = gcp.compute.Network("network",
            name="my-network",
            auto_create_subnetworks=False)
        subnet = gcp.compute.Subnetwork("subnet",
            name="my-subnet",
            region="us-central1",
            network=network.id,
            ip_cidr_range="10.0.60.0/24",
            private_ip_google_access=True)
        address = gcp.compute.Address("address",
            name="my-address",
            region="us-central1",
            address="10.0.60.100",
            address_type="INTERNAL",
            subnetwork=subnet.id)
        fw_rule_service_attachment = gcp.compute.ForwardingRule("fw_rule_service_attachment",
            name="fw-rule-service-attachment",
            region="us-central1",
            load_balancing_scheme="",
            ip_address=address.id,
            network=network.id,
            target=default.private_config.http_service_attachment)
        private_zone = gcp.dns.ManagedZone("private_zone",
            name="my-dns-zone",
            dns_name="p.sourcemanager.dev.",
            visibility="private",
            private_visibility_config={
                "networks": [{
                    "network_url": network.id,
                }],
            })
        ssm_instance_html_record = gcp.dns.RecordSet("ssm_instance_html_record",
            name=default.host_configs.apply(lambda host_configs: f"{host_configs[0].html}."),
            type="A",
            ttl=300,
            managed_zone=private_zone.name,
            rrdatas=[fw_rule_service_attachment.ip_address])
        ssm_instance_api_record = gcp.dns.RecordSet("ssm_instance_api_record",
            name=default.host_configs.apply(lambda host_configs: f"{host_configs[0].api}."),
            type="A",
            ttl=300,
            managed_zone=private_zone.name,
            rrdatas=[fw_rule_service_attachment.ip_address])
        ssm_instance_git_record = gcp.dns.RecordSet("ssm_instance_git_record",
            name=default.host_configs.apply(lambda host_configs: f"{host_configs[0].git_http}."),
            type="A",
            ttl=300,
            managed_zone=private_zone.name,
            rrdatas=[fw_rule_service_attachment.ip_address])
        ```
        ### Secure Source Manager Instance Workforce Identity Federation

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.securesourcemanager.Instance("default",
            location="us-central1",
            instance_id="my-instance",
            workforce_identity_federation_config={
                "enabled": True,
            },
            deletion_policy="PREVENT")
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance_id}}`

        * `{{project}}/{{location}}/{{instance_id}}`

        * `{{location}}/{{instance_id}}`

        * `{{instance_id}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:securesourcemanager/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/instance:Instance default {{project}}/{{location}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/instance:Instance default {{location}}/{{instance_id}}
        ```

        ```sh
        $ pulumi import gcp:securesourcemanager/instance:Instance default {{instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 private_config: Optional[pulumi.Input[Union['InstancePrivateConfigArgs', 'InstancePrivateConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 workforce_identity_federation_config: Optional[pulumi.Input[Union['InstanceWorkforceIdentityFederationConfigArgs', 'InstanceWorkforceIdentityFederationConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["deletion_policy"] = deletion_policy
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["kms_key"] = kms_key
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["private_config"] = private_config
            __props__.__dict__["project"] = project
            __props__.__dict__["workforce_identity_federation_config"] = workforce_identity_federation_config
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["host_configs"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_note"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'gcp:securesourcemanager/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            host_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceHostConfigArgs', 'InstanceHostConfigArgsDict']]]]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_config: Optional[pulumi.Input[Union['InstancePrivateConfigArgs', 'InstancePrivateConfigArgsDict']]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            state_note: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            workforce_identity_federation_config: Optional[pulumi.Input[Union['InstanceWorkforceIdentityFederationConfigArgs', 'InstanceWorkforceIdentityFederationConfigArgsDict']]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Time the Instance was created in UTC.
        :param pulumi.Input[_builtins.str] deletion_policy: The deletion policy for the instance. Setting `ABANDON` allows the resource
               to be abandoned, rather than deleted. Setting `DELETE` deletes the resource
               and all its contents. Setting `PREVENT` prevents the resource from accidental
               deletion by erroring out during plan.
               Default is `DELETE`.  Possible values are:
               * DELETE
               * PREVENT
               * ABANDON
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceHostConfigArgs', 'InstanceHostConfigArgsDict']]]] host_configs: A list of hostnames for this instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] instance_id: The name for the Instance.
        :param pulumi.Input[_builtins.str] kms_key: Customer-managed encryption key name, in the format projects/*/locations/*/keyRings/*/cryptoKeys/*.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels as key value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The location for the Instance.
        :param pulumi.Input[_builtins.str] name: The resource name for the Instance.
        :param pulumi.Input[Union['InstancePrivateConfigArgs', 'InstancePrivateConfigArgsDict']] private_config: Private settings for private instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] state: The current state of the Instance.
        :param pulumi.Input[_builtins.str] state_note: Provides information about the current instance state.
        :param pulumi.Input[_builtins.str] update_time: Time the Instance was updated in UTC.
        :param pulumi.Input[Union['InstanceWorkforceIdentityFederationConfigArgs', 'InstanceWorkforceIdentityFederationConfigArgsDict']] workforce_identity_federation_config: Configuration for Workforce Identity Federation to support third party identity provider.
               If unset, defaults to the Google OIDC IdP.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletion_policy"] = deletion_policy
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["host_configs"] = host_configs
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["kms_key"] = kms_key
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["private_config"] = private_config
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["state"] = state
        __props__.__dict__["state_note"] = state_note
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["workforce_identity_federation_config"] = workforce_identity_federation_config
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the Instance was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The deletion policy for the instance. Setting `ABANDON` allows the resource
        to be abandoned, rather than deleted. Setting `DELETE` deletes the resource
        and all its contents. Setting `PREVENT` prevents the resource from accidental
        deletion by erroring out during plan.
        Default is `DELETE`.  Possible values are:
        * DELETE
        * PREVENT
        * ABANDON
        """
        return pulumi.get(self, "deletion_policy")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="hostConfigs")
    def host_configs(self) -> pulumi.Output[Sequence['outputs.InstanceHostConfig']]:
        """
        A list of hostnames for this instance.
        Structure is documented below.
        """
        return pulumi.get(self, "host_configs")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the Instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Customer-managed encryption key name, in the format projects/*/locations/*/keyRings/*/cryptoKeys/*.
        """
        return pulumi.get(self, "kms_key")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels as key value pairs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location for the Instance.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name for the Instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateConfig")
    def private_config(self) -> pulumi.Output[Optional['outputs.InstancePrivateConfig']]:
        """
        Private settings for private instance.
        Structure is documented below.
        """
        return pulumi.get(self, "private_config")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the Instance.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateNote")
    def state_note(self) -> pulumi.Output[_builtins.str]:
        """
        Provides information about the current instance state.
        """
        return pulumi.get(self, "state_note")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the Instance was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="workforceIdentityFederationConfig")
    def workforce_identity_federation_config(self) -> pulumi.Output[Optional['outputs.InstanceWorkforceIdentityFederationConfig']]:
        """
        Configuration for Workforce Identity Federation to support third party identity provider.
        If unset, defaults to the Google OIDC IdP.
        Structure is documented below.
        """
        return pulumi.get(self, "workforce_identity_federation_config")

