# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDatabaseResult',
    'AwaitableGetDatabaseResult',
    'get_database',
    'get_database_output',
]

@pulumi.output_type
class GetDatabaseResult:
    """
    A collection of values returned by getDatabase.
    """
    def __init__(__self__, database_dialect=None, ddls=None, default_time_zone=None, deletion_protection=None, enable_drop_protection=None, encryption_configs=None, id=None, instance=None, name=None, project=None, state=None, version_retention_period=None):
        if database_dialect and not isinstance(database_dialect, str):
            raise TypeError("Expected argument 'database_dialect' to be a str")
        pulumi.set(__self__, "database_dialect", database_dialect)
        if ddls and not isinstance(ddls, list):
            raise TypeError("Expected argument 'ddls' to be a list")
        pulumi.set(__self__, "ddls", ddls)
        if default_time_zone and not isinstance(default_time_zone, str):
            raise TypeError("Expected argument 'default_time_zone' to be a str")
        pulumi.set(__self__, "default_time_zone", default_time_zone)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enable_drop_protection and not isinstance(enable_drop_protection, bool):
            raise TypeError("Expected argument 'enable_drop_protection' to be a bool")
        pulumi.set(__self__, "enable_drop_protection", enable_drop_protection)
        if encryption_configs and not isinstance(encryption_configs, list):
            raise TypeError("Expected argument 'encryption_configs' to be a list")
        pulumi.set(__self__, "encryption_configs", encryption_configs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance and not isinstance(instance, str):
            raise TypeError("Expected argument 'instance' to be a str")
        pulumi.set(__self__, "instance", instance)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if version_retention_period and not isinstance(version_retention_period, str):
            raise TypeError("Expected argument 'version_retention_period' to be a str")
        pulumi.set(__self__, "version_retention_period", version_retention_period)

    @_builtins.property
    @pulumi.getter(name="databaseDialect")
    def database_dialect(self) -> _builtins.str:
        return pulumi.get(self, "database_dialect")

    @_builtins.property
    @pulumi.getter
    def ddls(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ddls")

    @_builtins.property
    @pulumi.getter(name="defaultTimeZone")
    def default_time_zone(self) -> _builtins.str:
        return pulumi.get(self, "default_time_zone")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="enableDropProtection")
    def enable_drop_protection(self) -> _builtins.bool:
        return pulumi.get(self, "enable_drop_protection")

    @_builtins.property
    @pulumi.getter(name="encryptionConfigs")
    def encryption_configs(self) -> Sequence['outputs.GetDatabaseEncryptionConfigResult']:
        return pulumi.get(self, "encryption_configs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def instance(self) -> _builtins.str:
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="versionRetentionPeriod")
    def version_retention_period(self) -> _builtins.str:
        return pulumi.get(self, "version_retention_period")


class AwaitableGetDatabaseResult(GetDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseResult(
            database_dialect=self.database_dialect,
            ddls=self.ddls,
            default_time_zone=self.default_time_zone,
            deletion_protection=self.deletion_protection,
            enable_drop_protection=self.enable_drop_protection,
            encryption_configs=self.encryption_configs,
            id=self.id,
            instance=self.instance,
            name=self.name,
            project=self.project,
            state=self.state,
            version_retention_period=self.version_retention_period)


def get_database(instance: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 project: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseResult:
    """
    Get a spanner database from Google Cloud by its name and instance name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.spanner.get_database(name="foo",
        instance=instance["name"])
    ```


    :param _builtins.str instance: The name of the database's spanner instance.
           
           - - -
    :param _builtins.str name: The name of the spanner database.
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['instance'] = instance
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:spanner/getDatabase:getDatabase', __args__, opts=opts, typ=GetDatabaseResult).value

    return AwaitableGetDatabaseResult(
        database_dialect=pulumi.get(__ret__, 'database_dialect'),
        ddls=pulumi.get(__ret__, 'ddls'),
        default_time_zone=pulumi.get(__ret__, 'default_time_zone'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        enable_drop_protection=pulumi.get(__ret__, 'enable_drop_protection'),
        encryption_configs=pulumi.get(__ret__, 'encryption_configs'),
        id=pulumi.get(__ret__, 'id'),
        instance=pulumi.get(__ret__, 'instance'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        state=pulumi.get(__ret__, 'state'),
        version_retention_period=pulumi.get(__ret__, 'version_retention_period'))
def get_database_output(instance: Optional[pulumi.Input[_builtins.str]] = None,
                        name: Optional[pulumi.Input[_builtins.str]] = None,
                        project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseResult]:
    """
    Get a spanner database from Google Cloud by its name and instance name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.spanner.get_database(name="foo",
        instance=instance["name"])
    ```


    :param _builtins.str instance: The name of the database's spanner instance.
           
           - - -
    :param _builtins.str name: The name of the spanner database.
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['instance'] = instance
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:spanner/getDatabase:getDatabase', __args__, opts=opts, typ=GetDatabaseResult)
    return __ret__.apply(lambda __response__: GetDatabaseResult(
        database_dialect=pulumi.get(__response__, 'database_dialect'),
        ddls=pulumi.get(__response__, 'ddls'),
        default_time_zone=pulumi.get(__response__, 'default_time_zone'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        enable_drop_protection=pulumi.get(__response__, 'enable_drop_protection'),
        encryption_configs=pulumi.get(__response__, 'encryption_configs'),
        id=pulumi.get(__response__, 'id'),
        instance=pulumi.get(__response__, 'instance'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        state=pulumi.get(__response__, 'state'),
        version_retention_period=pulumi.get(__response__, 'version_retention_period')))
