# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BackupScheduleEncryptionConfig',
    'BackupScheduleFullBackupSpec',
    'BackupScheduleIncrementalBackupSpec',
    'BackupScheduleSpec',
    'BackupScheduleSpecCronSpec',
    'DatabaseEncryptionConfig',
    'DatabaseIAMBindingCondition',
    'DatabaseIAMMemberCondition',
    'InstanceAutoscalingConfig',
    'InstanceAutoscalingConfigAsymmetricAutoscalingOption',
    'InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverrides',
    'InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimits',
    'InstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelection',
    'InstanceAutoscalingConfigAutoscalingLimits',
    'InstanceAutoscalingConfigAutoscalingTargets',
    'InstanceConfigReplica',
    'InstanceIAMBindingCondition',
    'InstanceIAMMemberCondition',
    'GetDatabaseEncryptionConfigResult',
    'GetInstanceAutoscalingConfigResult',
    'GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionResult',
    'GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionOverrideResult',
    'GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionOverrideAutoscalingLimitResult',
    'GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelectionResult',
    'GetInstanceAutoscalingConfigAutoscalingLimitResult',
    'GetInstanceAutoscalingConfigAutoscalingTargetResult',
]

@pulumi.output_type
class BackupScheduleEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionType":
            suggest = "encryption_type"
        elif key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "kmsKeyNames":
            suggest = "kms_key_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupScheduleEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupScheduleEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupScheduleEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_type: _builtins.str,
                 kms_key_name: Optional[_builtins.str] = None,
                 kms_key_names: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str encryption_type: The encryption type of backups created by the backup schedule.
               Possible values are USE_DATABASE_ENCRYPTION, GOOGLE_DEFAULT_ENCRYPTION, or CUSTOMER_MANAGED_ENCRYPTION.
               If you use CUSTOMER_MANAGED_ENCRYPTION, you must specify a kmsKeyName.
               If your backup type is incremental-backup, the encryption type must be GOOGLE_DEFAULT_ENCRYPTION.
               Possible values are: `USE_DATABASE_ENCRYPTION`, `GOOGLE_DEFAULT_ENCRYPTION`, `CUSTOMER_MANAGED_ENCRYPTION`.
        :param _builtins.str kms_key_name: The resource name of the Cloud KMS key to use for encryption.
               Format: 'projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}'
        :param Sequence[_builtins.str] kms_key_names: Fully qualified name of the KMS keys to use to encrypt this database. The keys must exist
               in the same locations as the Spanner Database.
        """
        pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_names is not None:
            pulumi.set(__self__, "kms_key_names", kms_key_names)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> _builtins.str:
        """
        The encryption type of backups created by the backup schedule.
        Possible values are USE_DATABASE_ENCRYPTION, GOOGLE_DEFAULT_ENCRYPTION, or CUSTOMER_MANAGED_ENCRYPTION.
        If you use CUSTOMER_MANAGED_ENCRYPTION, you must specify a kmsKeyName.
        If your backup type is incremental-backup, the encryption type must be GOOGLE_DEFAULT_ENCRYPTION.
        Possible values are: `USE_DATABASE_ENCRYPTION`, `GOOGLE_DEFAULT_ENCRYPTION`, `CUSTOMER_MANAGED_ENCRYPTION`.
        """
        return pulumi.get(self, "encryption_type")

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[_builtins.str]:
        """
        The resource name of the Cloud KMS key to use for encryption.
        Format: 'projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}'
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter(name="kmsKeyNames")
    def kms_key_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Fully qualified name of the KMS keys to use to encrypt this database. The keys must exist
        in the same locations as the Spanner Database.
        """
        return pulumi.get(self, "kms_key_names")


@pulumi.output_type
class BackupScheduleFullBackupSpec(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class BackupScheduleIncrementalBackupSpec(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class BackupScheduleSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronSpec":
            suggest = "cron_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupScheduleSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupScheduleSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupScheduleSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_spec: Optional['outputs.BackupScheduleSpecCronSpec'] = None):
        """
        :param 'BackupScheduleSpecCronSpecArgs' cron_spec: Cron style schedule specification..
               Structure is documented below.
        """
        if cron_spec is not None:
            pulumi.set(__self__, "cron_spec", cron_spec)

    @_builtins.property
    @pulumi.getter(name="cronSpec")
    def cron_spec(self) -> Optional['outputs.BackupScheduleSpecCronSpec']:
        """
        Cron style schedule specification..
        Structure is documented below.
        """
        return pulumi.get(self, "cron_spec")


@pulumi.output_type
class BackupScheduleSpecCronSpec(dict):
    def __init__(__self__, *,
                 text: Optional[_builtins.str] = None):
        """
        :param _builtins.str text: Textual representation of the crontab. User can customize the
               backup frequency and the backup version time using the cron
               expression. The version time must be in UTC timzeone.
               The backup will contain an externally consistent copy of the
               database at the version time. Allowed frequencies are 12 hour, 1 day,
               1 week and 1 month. Examples of valid cron specifications:
               0 2/12 * * * : every 12 hours at (2, 14) hours past midnight in UTC.
               0 2,14 * * * : every 12 hours at (2,14) hours past midnight in UTC.
               0 2 * * *    : once a day at 2 past midnight in UTC.
               0 2 * * 0    : once a week every Sunday at 2 past midnight in UTC.
               0 2 8 * *    : once a month on 8th day at 2 past midnight in UTC.
        """
        if text is not None:
            pulumi.set(__self__, "text", text)

    @_builtins.property
    @pulumi.getter
    def text(self) -> Optional[_builtins.str]:
        """
        Textual representation of the crontab. User can customize the
        backup frequency and the backup version time using the cron
        expression. The version time must be in UTC timzeone.
        The backup will contain an externally consistent copy of the
        database at the version time. Allowed frequencies are 12 hour, 1 day,
        1 week and 1 month. Examples of valid cron specifications:
        0 2/12 * * * : every 12 hours at (2, 14) hours past midnight in UTC.
        0 2,14 * * * : every 12 hours at (2,14) hours past midnight in UTC.
        0 2 * * *    : once a day at 2 past midnight in UTC.
        0 2 * * 0    : once a week every Sunday at 2 past midnight in UTC.
        0 2 8 * *    : once a month on 8th day at 2 past midnight in UTC.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class DatabaseEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "kmsKeyNames":
            suggest = "kms_key_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[_builtins.str] = None,
                 kms_key_names: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str kms_key_name: Fully qualified name of the KMS key to use to encrypt this database. This key must exist
               in the same location as the Spanner Database.
        :param Sequence[_builtins.str] kms_key_names: Fully qualified name of the KMS keys to use to encrypt this database. The keys must exist
               in the same locations as the Spanner Database.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if kms_key_names is not None:
            pulumi.set(__self__, "kms_key_names", kms_key_names)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[_builtins.str]:
        """
        Fully qualified name of the KMS key to use to encrypt this database. This key must exist
        in the same location as the Spanner Database.
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter(name="kmsKeyNames")
    def kms_key_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Fully qualified name of the KMS keys to use to encrypt this database. The keys must exist
        in the same locations as the Spanner Database.
        """
        return pulumi.get(self, "kms_key_names")


@pulumi.output_type
class DatabaseIAMBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class DatabaseIAMMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class InstanceAutoscalingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "asymmetricAutoscalingOptions":
            suggest = "asymmetric_autoscaling_options"
        elif key == "autoscalingLimits":
            suggest = "autoscaling_limits"
        elif key == "autoscalingTargets":
            suggest = "autoscaling_targets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAutoscalingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAutoscalingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAutoscalingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 asymmetric_autoscaling_options: Optional[Sequence['outputs.InstanceAutoscalingConfigAsymmetricAutoscalingOption']] = None,
                 autoscaling_limits: Optional['outputs.InstanceAutoscalingConfigAutoscalingLimits'] = None,
                 autoscaling_targets: Optional['outputs.InstanceAutoscalingConfigAutoscalingTargets'] = None):
        """
        :param Sequence['InstanceAutoscalingConfigAsymmetricAutoscalingOptionArgs'] asymmetric_autoscaling_options: Asymmetric autoscaling options for specific replicas.
               Structure is documented below.
        :param 'InstanceAutoscalingConfigAutoscalingLimitsArgs' autoscaling_limits: Defines scale in controls to reduce the risk of response latency
               and outages due to abrupt scale-in events. Users can define the minimum and
               maximum compute capacity allocated to the instance, and the autoscaler will
               only scale within that range. Users can either use nodes or processing
               units to specify the limits, but should use the same unit to set both the
               min_limit and max_limit.
               Structure is documented below.
        :param 'InstanceAutoscalingConfigAutoscalingTargetsArgs' autoscaling_targets: Defines scale in controls to reduce the risk of response latency
               and outages due to abrupt scale-in events
               Structure is documented below.
        """
        if asymmetric_autoscaling_options is not None:
            pulumi.set(__self__, "asymmetric_autoscaling_options", asymmetric_autoscaling_options)
        if autoscaling_limits is not None:
            pulumi.set(__self__, "autoscaling_limits", autoscaling_limits)
        if autoscaling_targets is not None:
            pulumi.set(__self__, "autoscaling_targets", autoscaling_targets)

    @_builtins.property
    @pulumi.getter(name="asymmetricAutoscalingOptions")
    def asymmetric_autoscaling_options(self) -> Optional[Sequence['outputs.InstanceAutoscalingConfigAsymmetricAutoscalingOption']]:
        """
        Asymmetric autoscaling options for specific replicas.
        Structure is documented below.
        """
        return pulumi.get(self, "asymmetric_autoscaling_options")

    @_builtins.property
    @pulumi.getter(name="autoscalingLimits")
    def autoscaling_limits(self) -> Optional['outputs.InstanceAutoscalingConfigAutoscalingLimits']:
        """
        Defines scale in controls to reduce the risk of response latency
        and outages due to abrupt scale-in events. Users can define the minimum and
        maximum compute capacity allocated to the instance, and the autoscaler will
        only scale within that range. Users can either use nodes or processing
        units to specify the limits, but should use the same unit to set both the
        min_limit and max_limit.
        Structure is documented below.
        """
        return pulumi.get(self, "autoscaling_limits")

    @_builtins.property
    @pulumi.getter(name="autoscalingTargets")
    def autoscaling_targets(self) -> Optional['outputs.InstanceAutoscalingConfigAutoscalingTargets']:
        """
        Defines scale in controls to reduce the risk of response latency
        and outages due to abrupt scale-in events
        Structure is documented below.
        """
        return pulumi.get(self, "autoscaling_targets")


@pulumi.output_type
class InstanceAutoscalingConfigAsymmetricAutoscalingOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicaSelection":
            suggest = "replica_selection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAutoscalingConfigAsymmetricAutoscalingOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAutoscalingConfigAsymmetricAutoscalingOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAutoscalingConfigAsymmetricAutoscalingOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 overrides: 'outputs.InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverrides',
                 replica_selection: 'outputs.InstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelection'):
        """
        :param 'InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesArgs' overrides: A nested object resource.
               Structure is documented below.
        :param 'InstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelectionArgs' replica_selection: A nested object resource.
               Structure is documented below.
        """
        pulumi.set(__self__, "overrides", overrides)
        pulumi.set(__self__, "replica_selection", replica_selection)

    @_builtins.property
    @pulumi.getter
    def overrides(self) -> 'outputs.InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverrides':
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "overrides")

    @_builtins.property
    @pulumi.getter(name="replicaSelection")
    def replica_selection(self) -> 'outputs.InstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelection':
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "replica_selection")


@pulumi.output_type
class InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverrides(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscalingLimits":
            suggest = "autoscaling_limits"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverrides. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverrides.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverrides.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling_limits: 'outputs.InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimits'):
        """
        :param 'InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimitsArgs' autoscaling_limits: A nested object resource.
               Structure is documented below.
        """
        pulumi.set(__self__, "autoscaling_limits", autoscaling_limits)

    @_builtins.property
    @pulumi.getter(name="autoscalingLimits")
    def autoscaling_limits(self) -> 'outputs.InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimits':
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "autoscaling_limits")


@pulumi.output_type
class InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNodes":
            suggest = "max_nodes"
        elif key == "minNodes":
            suggest = "min_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAutoscalingConfigAsymmetricAutoscalingOptionOverridesAutoscalingLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_nodes: _builtins.int,
                 min_nodes: _builtins.int):
        """
        :param _builtins.int max_nodes: The maximum number of nodes for this specific replica.
        :param _builtins.int min_nodes: The minimum number of nodes for this specific replica.
        """
        pulumi.set(__self__, "max_nodes", max_nodes)
        pulumi.set(__self__, "min_nodes", min_nodes)

    @_builtins.property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> _builtins.int:
        """
        The maximum number of nodes for this specific replica.
        """
        return pulumi.get(self, "max_nodes")

    @_builtins.property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> _builtins.int:
        """
        The minimum number of nodes for this specific replica.
        """
        return pulumi.get(self, "min_nodes")


@pulumi.output_type
class InstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelection(dict):
    def __init__(__self__, *,
                 location: _builtins.str):
        """
        :param _builtins.str location: The location of the replica to apply asymmetric autoscaling options.
        """
        pulumi.set(__self__, "location", location)

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The location of the replica to apply asymmetric autoscaling options.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class InstanceAutoscalingConfigAutoscalingLimits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNodes":
            suggest = "max_nodes"
        elif key == "maxProcessingUnits":
            suggest = "max_processing_units"
        elif key == "minNodes":
            suggest = "min_nodes"
        elif key == "minProcessingUnits":
            suggest = "min_processing_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAutoscalingConfigAutoscalingLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAutoscalingConfigAutoscalingLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAutoscalingConfigAutoscalingLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_nodes: Optional[_builtins.int] = None,
                 max_processing_units: Optional[_builtins.int] = None,
                 min_nodes: Optional[_builtins.int] = None,
                 min_processing_units: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_nodes: The maximum number of nodes for this specific replica.
        :param _builtins.int max_processing_units: Specifies maximum number of processing units allocated to the instance.
               If set, this number should be multiples of 1000 and be greater than or equal to
               min_processing_units.
        :param _builtins.int min_nodes: The minimum number of nodes for this specific replica.
        :param _builtins.int min_processing_units: Specifies minimum number of processing units allocated to the instance.
               If set, this number should be multiples of 1000.
        """
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if max_processing_units is not None:
            pulumi.set(__self__, "max_processing_units", max_processing_units)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if min_processing_units is not None:
            pulumi.set(__self__, "min_processing_units", min_processing_units)

    @_builtins.property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[_builtins.int]:
        """
        The maximum number of nodes for this specific replica.
        """
        return pulumi.get(self, "max_nodes")

    @_builtins.property
    @pulumi.getter(name="maxProcessingUnits")
    def max_processing_units(self) -> Optional[_builtins.int]:
        """
        Specifies maximum number of processing units allocated to the instance.
        If set, this number should be multiples of 1000 and be greater than or equal to
        min_processing_units.
        """
        return pulumi.get(self, "max_processing_units")

    @_builtins.property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[_builtins.int]:
        """
        The minimum number of nodes for this specific replica.
        """
        return pulumi.get(self, "min_nodes")

    @_builtins.property
    @pulumi.getter(name="minProcessingUnits")
    def min_processing_units(self) -> Optional[_builtins.int]:
        """
        Specifies minimum number of processing units allocated to the instance.
        If set, this number should be multiples of 1000.
        """
        return pulumi.get(self, "min_processing_units")


@pulumi.output_type
class InstanceAutoscalingConfigAutoscalingTargets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "highPriorityCpuUtilizationPercent":
            suggest = "high_priority_cpu_utilization_percent"
        elif key == "storageUtilizationPercent":
            suggest = "storage_utilization_percent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAutoscalingConfigAutoscalingTargets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAutoscalingConfigAutoscalingTargets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAutoscalingConfigAutoscalingTargets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 high_priority_cpu_utilization_percent: Optional[_builtins.int] = None,
                 storage_utilization_percent: Optional[_builtins.int] = None):
        """
        :param _builtins.int high_priority_cpu_utilization_percent: Specifies the target high priority cpu utilization percentage that the autoscaler
               should be trying to achieve for the instance.
               This number is on a scale from 0 (no utilization) to 100 (full utilization)..
        :param _builtins.int storage_utilization_percent: Specifies the target storage utilization percentage that the autoscaler
               should be trying to achieve for the instance.
               This number is on a scale from 0 (no utilization) to 100 (full utilization).
        """
        if high_priority_cpu_utilization_percent is not None:
            pulumi.set(__self__, "high_priority_cpu_utilization_percent", high_priority_cpu_utilization_percent)
        if storage_utilization_percent is not None:
            pulumi.set(__self__, "storage_utilization_percent", storage_utilization_percent)

    @_builtins.property
    @pulumi.getter(name="highPriorityCpuUtilizationPercent")
    def high_priority_cpu_utilization_percent(self) -> Optional[_builtins.int]:
        """
        Specifies the target high priority cpu utilization percentage that the autoscaler
        should be trying to achieve for the instance.
        This number is on a scale from 0 (no utilization) to 100 (full utilization)..
        """
        return pulumi.get(self, "high_priority_cpu_utilization_percent")

    @_builtins.property
    @pulumi.getter(name="storageUtilizationPercent")
    def storage_utilization_percent(self) -> Optional[_builtins.int]:
        """
        Specifies the target storage utilization percentage that the autoscaler
        should be trying to achieve for the instance.
        This number is on a scale from 0 (no utilization) to 100 (full utilization).
        """
        return pulumi.get(self, "storage_utilization_percent")


@pulumi.output_type
class InstanceConfigReplica(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultLeaderLocation":
            suggest = "default_leader_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceConfigReplica. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceConfigReplica.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceConfigReplica.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_leader_location: Optional[_builtins.bool] = None,
                 location: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.bool default_leader_location: If true, this location is designated as the default leader location where
               leader replicas are placed.
        :param _builtins.str location: The location of the serving resources, e.g. "us-central1".
        :param _builtins.str type: Indicates the type of replica.  See the [replica types
               documentation](https://cloud.google.com/spanner/docs/replication#replica_types)
               for more details.
               Possible values are: `READ_WRITE`, `READ_ONLY`, `WITNESS`.
        """
        if default_leader_location is not None:
            pulumi.set(__self__, "default_leader_location", default_leader_location)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="defaultLeaderLocation")
    def default_leader_location(self) -> Optional[_builtins.bool]:
        """
        If true, this location is designated as the default leader location where
        leader replicas are placed.
        """
        return pulumi.get(self, "default_leader_location")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        """
        The location of the serving resources, e.g. "us-central1".
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Indicates the type of replica.  See the [replica types
        documentation](https://cloud.google.com/spanner/docs/replication#replica_types)
        for more details.
        Possible values are: `READ_WRITE`, `READ_ONLY`, `WITNESS`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class InstanceIAMBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class InstanceIAMMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class GetDatabaseEncryptionConfigResult(dict):
    def __init__(__self__, *,
                 kms_key_name: _builtins.str,
                 kms_key_names: Sequence[_builtins.str]):
        """
        :param _builtins.str kms_key_name: Fully qualified name of the KMS key to use to encrypt this database. This key must exist
               in the same location as the Spanner Database.
        :param Sequence[_builtins.str] kms_key_names: Fully qualified name of the KMS keys to use to encrypt this database. The keys must exist
               in the same locations as the Spanner Database.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        pulumi.set(__self__, "kms_key_names", kms_key_names)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> _builtins.str:
        """
        Fully qualified name of the KMS key to use to encrypt this database. This key must exist
        in the same location as the Spanner Database.
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter(name="kmsKeyNames")
    def kms_key_names(self) -> Sequence[_builtins.str]:
        """
        Fully qualified name of the KMS keys to use to encrypt this database. The keys must exist
        in the same locations as the Spanner Database.
        """
        return pulumi.get(self, "kms_key_names")


@pulumi.output_type
class GetInstanceAutoscalingConfigResult(dict):
    def __init__(__self__, *,
                 asymmetric_autoscaling_options: Sequence['outputs.GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionResult'],
                 autoscaling_limits: Sequence['outputs.GetInstanceAutoscalingConfigAutoscalingLimitResult'],
                 autoscaling_targets: Sequence['outputs.GetInstanceAutoscalingConfigAutoscalingTargetResult']):
        """
        :param Sequence['GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionArgs'] asymmetric_autoscaling_options: Asymmetric autoscaling options for specific replicas.
        :param Sequence['GetInstanceAutoscalingConfigAutoscalingLimitArgs'] autoscaling_limits: Defines scale in controls to reduce the risk of response latency
               and outages due to abrupt scale-in events. Users can define the minimum and
               maximum compute capacity allocated to the instance, and the autoscaler will
               only scale within that range. Users can either use nodes or processing
               units to specify the limits, but should use the same unit to set both the
               min_limit and max_limit.
        :param Sequence['GetInstanceAutoscalingConfigAutoscalingTargetArgs'] autoscaling_targets: Defines scale in controls to reduce the risk of response latency
               and outages due to abrupt scale-in events
        """
        pulumi.set(__self__, "asymmetric_autoscaling_options", asymmetric_autoscaling_options)
        pulumi.set(__self__, "autoscaling_limits", autoscaling_limits)
        pulumi.set(__self__, "autoscaling_targets", autoscaling_targets)

    @_builtins.property
    @pulumi.getter(name="asymmetricAutoscalingOptions")
    def asymmetric_autoscaling_options(self) -> Sequence['outputs.GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionResult']:
        """
        Asymmetric autoscaling options for specific replicas.
        """
        return pulumi.get(self, "asymmetric_autoscaling_options")

    @_builtins.property
    @pulumi.getter(name="autoscalingLimits")
    def autoscaling_limits(self) -> Sequence['outputs.GetInstanceAutoscalingConfigAutoscalingLimitResult']:
        """
        Defines scale in controls to reduce the risk of response latency
        and outages due to abrupt scale-in events. Users can define the minimum and
        maximum compute capacity allocated to the instance, and the autoscaler will
        only scale within that range. Users can either use nodes or processing
        units to specify the limits, but should use the same unit to set both the
        min_limit and max_limit.
        """
        return pulumi.get(self, "autoscaling_limits")

    @_builtins.property
    @pulumi.getter(name="autoscalingTargets")
    def autoscaling_targets(self) -> Sequence['outputs.GetInstanceAutoscalingConfigAutoscalingTargetResult']:
        """
        Defines scale in controls to reduce the risk of response latency
        and outages due to abrupt scale-in events
        """
        return pulumi.get(self, "autoscaling_targets")


@pulumi.output_type
class GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionResult(dict):
    def __init__(__self__, *,
                 overrides: Sequence['outputs.GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionOverrideResult'],
                 replica_selections: Sequence['outputs.GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelectionResult']):
        """
        :param Sequence['GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionOverrideArgs'] overrides: A nested object resource.
        :param Sequence['GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelectionArgs'] replica_selections: A nested object resource.
        """
        pulumi.set(__self__, "overrides", overrides)
        pulumi.set(__self__, "replica_selections", replica_selections)

    @_builtins.property
    @pulumi.getter
    def overrides(self) -> Sequence['outputs.GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionOverrideResult']:
        """
        A nested object resource.
        """
        return pulumi.get(self, "overrides")

    @_builtins.property
    @pulumi.getter(name="replicaSelections")
    def replica_selections(self) -> Sequence['outputs.GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelectionResult']:
        """
        A nested object resource.
        """
        return pulumi.get(self, "replica_selections")


@pulumi.output_type
class GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionOverrideResult(dict):
    def __init__(__self__, *,
                 autoscaling_limits: Sequence['outputs.GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionOverrideAutoscalingLimitResult']):
        """
        :param Sequence['GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionOverrideAutoscalingLimitArgs'] autoscaling_limits: A nested object resource.
        """
        pulumi.set(__self__, "autoscaling_limits", autoscaling_limits)

    @_builtins.property
    @pulumi.getter(name="autoscalingLimits")
    def autoscaling_limits(self) -> Sequence['outputs.GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionOverrideAutoscalingLimitResult']:
        """
        A nested object resource.
        """
        return pulumi.get(self, "autoscaling_limits")


@pulumi.output_type
class GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionOverrideAutoscalingLimitResult(dict):
    def __init__(__self__, *,
                 max_nodes: _builtins.int,
                 min_nodes: _builtins.int):
        """
        :param _builtins.int max_nodes: The maximum number of nodes for this specific replica.
        :param _builtins.int min_nodes: The minimum number of nodes for this specific replica.
        """
        pulumi.set(__self__, "max_nodes", max_nodes)
        pulumi.set(__self__, "min_nodes", min_nodes)

    @_builtins.property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> _builtins.int:
        """
        The maximum number of nodes for this specific replica.
        """
        return pulumi.get(self, "max_nodes")

    @_builtins.property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> _builtins.int:
        """
        The minimum number of nodes for this specific replica.
        """
        return pulumi.get(self, "min_nodes")


@pulumi.output_type
class GetInstanceAutoscalingConfigAsymmetricAutoscalingOptionReplicaSelectionResult(dict):
    def __init__(__self__, *,
                 location: _builtins.str):
        """
        :param _builtins.str location: The location of the replica to apply asymmetric autoscaling options.
        """
        pulumi.set(__self__, "location", location)

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The location of the replica to apply asymmetric autoscaling options.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class GetInstanceAutoscalingConfigAutoscalingLimitResult(dict):
    def __init__(__self__, *,
                 max_nodes: _builtins.int,
                 max_processing_units: _builtins.int,
                 min_nodes: _builtins.int,
                 min_processing_units: _builtins.int):
        """
        :param _builtins.int max_nodes: Specifies maximum number of nodes allocated to the instance. If set, this number
               should be greater than or equal to min_nodes.
        :param _builtins.int max_processing_units: Specifies maximum number of processing units allocated to the instance.
               If set, this number should be multiples of 1000 and be greater than or equal to
               min_processing_units.
        :param _builtins.int min_nodes: Specifies number of nodes allocated to the instance. If set, this number
               should be greater than or equal to 1.
        :param _builtins.int min_processing_units: Specifies minimum number of processing units allocated to the instance.
               If set, this number should be multiples of 1000.
        """
        pulumi.set(__self__, "max_nodes", max_nodes)
        pulumi.set(__self__, "max_processing_units", max_processing_units)
        pulumi.set(__self__, "min_nodes", min_nodes)
        pulumi.set(__self__, "min_processing_units", min_processing_units)

    @_builtins.property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> _builtins.int:
        """
        Specifies maximum number of nodes allocated to the instance. If set, this number
        should be greater than or equal to min_nodes.
        """
        return pulumi.get(self, "max_nodes")

    @_builtins.property
    @pulumi.getter(name="maxProcessingUnits")
    def max_processing_units(self) -> _builtins.int:
        """
        Specifies maximum number of processing units allocated to the instance.
        If set, this number should be multiples of 1000 and be greater than or equal to
        min_processing_units.
        """
        return pulumi.get(self, "max_processing_units")

    @_builtins.property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> _builtins.int:
        """
        Specifies number of nodes allocated to the instance. If set, this number
        should be greater than or equal to 1.
        """
        return pulumi.get(self, "min_nodes")

    @_builtins.property
    @pulumi.getter(name="minProcessingUnits")
    def min_processing_units(self) -> _builtins.int:
        """
        Specifies minimum number of processing units allocated to the instance.
        If set, this number should be multiples of 1000.
        """
        return pulumi.get(self, "min_processing_units")


@pulumi.output_type
class GetInstanceAutoscalingConfigAutoscalingTargetResult(dict):
    def __init__(__self__, *,
                 high_priority_cpu_utilization_percent: _builtins.int,
                 storage_utilization_percent: _builtins.int):
        """
        :param _builtins.int high_priority_cpu_utilization_percent: Specifies the target high priority cpu utilization percentage that the autoscaler
               should be trying to achieve for the instance.
               This number is on a scale from 0 (no utilization) to 100 (full utilization)..
        :param _builtins.int storage_utilization_percent: Specifies the target storage utilization percentage that the autoscaler
               should be trying to achieve for the instance.
               This number is on a scale from 0 (no utilization) to 100 (full utilization).
        """
        pulumi.set(__self__, "high_priority_cpu_utilization_percent", high_priority_cpu_utilization_percent)
        pulumi.set(__self__, "storage_utilization_percent", storage_utilization_percent)

    @_builtins.property
    @pulumi.getter(name="highPriorityCpuUtilizationPercent")
    def high_priority_cpu_utilization_percent(self) -> _builtins.int:
        """
        Specifies the target high priority cpu utilization percentage that the autoscaler
        should be trying to achieve for the instance.
        This number is on a scale from 0 (no utilization) to 100 (full utilization)..
        """
        return pulumi.get(self, "high_priority_cpu_utilization_percent")

    @_builtins.property
    @pulumi.getter(name="storageUtilizationPercent")
    def storage_utilization_percent(self) -> _builtins.int:
        """
        Specifies the target storage utilization percentage that the autoscaler
        should be trying to achieve for the instance.
        This number is on a scale from 0 (no utilization) to 100 (full utilization).
        """
        return pulumi.get(self, "storage_utilization_percent")


