# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ControlProjectIntelligenceConfigArgs', 'ControlProjectIntelligenceConfig']

@pulumi.input_type
class ControlProjectIntelligenceConfigArgs:
    def __init__(__self__, *,
                 edition_config: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input['ControlProjectIntelligenceConfigFilterArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ControlProjectIntelligenceConfig resource.
        :param pulumi.Input[_builtins.str] edition_config: Edition configuration of the Storage Intelligence resource. Valid values are INHERIT, TRIAL, DISABLED and STANDARD.
        :param pulumi.Input['ControlProjectIntelligenceConfigFilterArgs'] filter: Filter over location and bucket using include or exclude semantics. Resources that match the include or exclude filter are exclusively included or excluded from the Storage Intelligence plan.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Identifier of the GCP project. For GCP project, this field can be project name or project number.
        """
        if edition_config is not None:
            pulumi.set(__self__, "edition_config", edition_config)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="editionConfig")
    def edition_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Edition configuration of the Storage Intelligence resource. Valid values are INHERIT, TRIAL, DISABLED and STANDARD.
        """
        return pulumi.get(self, "edition_config")

    @edition_config.setter
    def edition_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edition_config", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['ControlProjectIntelligenceConfigFilterArgs']]:
        """
        Filter over location and bucket using include or exclude semantics. Resources that match the include or exclude filter are exclusively included or excluded from the Storage Intelligence plan.
        Structure is documented below.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['ControlProjectIntelligenceConfigFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the GCP project. For GCP project, this field can be project name or project number.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ControlProjectIntelligenceConfigState:
    def __init__(__self__, *,
                 edition_config: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_intelligence_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ControlProjectIntelligenceConfigEffectiveIntelligenceConfigArgs']]]] = None,
                 filter: Optional[pulumi.Input['ControlProjectIntelligenceConfigFilterArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 trial_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ControlProjectIntelligenceConfigTrialConfigArgs']]]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ControlProjectIntelligenceConfig resources.
        :param pulumi.Input[_builtins.str] edition_config: Edition configuration of the Storage Intelligence resource. Valid values are INHERIT, TRIAL, DISABLED and STANDARD.
        :param pulumi.Input[Sequence[pulumi.Input['ControlProjectIntelligenceConfigEffectiveIntelligenceConfigArgs']]] effective_intelligence_configs: The Intelligence config that is effective for the resource.
               Structure is documented below.
        :param pulumi.Input['ControlProjectIntelligenceConfigFilterArgs'] filter: Filter over location and bucket using include or exclude semantics. Resources that match the include or exclude filter are exclusively included or excluded from the Storage Intelligence plan.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Identifier of the GCP project. For GCP project, this field can be project name or project number.
        :param pulumi.Input[Sequence[pulumi.Input['ControlProjectIntelligenceConfigTrialConfigArgs']]] trial_configs: The trial configuration of the Storage Intelligence resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: The time at which the Storage Intelligence Config resource is last updated.
        """
        if edition_config is not None:
            pulumi.set(__self__, "edition_config", edition_config)
        if effective_intelligence_configs is not None:
            pulumi.set(__self__, "effective_intelligence_configs", effective_intelligence_configs)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if trial_configs is not None:
            pulumi.set(__self__, "trial_configs", trial_configs)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="editionConfig")
    def edition_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Edition configuration of the Storage Intelligence resource. Valid values are INHERIT, TRIAL, DISABLED and STANDARD.
        """
        return pulumi.get(self, "edition_config")

    @edition_config.setter
    def edition_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edition_config", value)

    @_builtins.property
    @pulumi.getter(name="effectiveIntelligenceConfigs")
    def effective_intelligence_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ControlProjectIntelligenceConfigEffectiveIntelligenceConfigArgs']]]]:
        """
        The Intelligence config that is effective for the resource.
        Structure is documented below.
        """
        return pulumi.get(self, "effective_intelligence_configs")

    @effective_intelligence_configs.setter
    def effective_intelligence_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ControlProjectIntelligenceConfigEffectiveIntelligenceConfigArgs']]]]):
        pulumi.set(self, "effective_intelligence_configs", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['ControlProjectIntelligenceConfigFilterArgs']]:
        """
        Filter over location and bucket using include or exclude semantics. Resources that match the include or exclude filter are exclusively included or excluded from the Storage Intelligence plan.
        Structure is documented below.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['ControlProjectIntelligenceConfigFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the GCP project. For GCP project, this field can be project name or project number.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="trialConfigs")
    def trial_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ControlProjectIntelligenceConfigTrialConfigArgs']]]]:
        """
        The trial configuration of the Storage Intelligence resource.
        Structure is documented below.
        """
        return pulumi.get(self, "trial_configs")

    @trial_configs.setter
    def trial_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ControlProjectIntelligenceConfigTrialConfigArgs']]]]):
        pulumi.set(self, "trial_configs", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the Storage Intelligence Config resource is last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:storage/controlProjectIntelligenceConfig:ControlProjectIntelligenceConfig")
class ControlProjectIntelligenceConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 edition_config: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[Union['ControlProjectIntelligenceConfigFilterArgs', 'ControlProjectIntelligenceConfigFilterArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Storage Control Project Intelligence Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.storage.ControlProjectIntelligenceConfig("example",
            name="test-project",
            edition_config="TRIAL",
            filter={
                "included_cloud_storage_buckets": {
                    "bucket_id_regexes": [
                        "test-id-1*",
                        "test-id-2*",
                    ],
                },
            })
        ```

        ## Import

        ProjectIntelligenceConfig can be imported using any of these accepted formats:

        * `projects/{{name}}/locations/global/intelligenceConfig`

        * `{{name}}`

        When using the `pulumi import` command, ProjectIntelligenceConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:storage/controlProjectIntelligenceConfig:ControlProjectIntelligenceConfig default projects/{{name}}/locations/global/intelligenceConfig
        ```

        ```sh
        $ pulumi import gcp:storage/controlProjectIntelligenceConfig:ControlProjectIntelligenceConfig default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] edition_config: Edition configuration of the Storage Intelligence resource. Valid values are INHERIT, TRIAL, DISABLED and STANDARD.
        :param pulumi.Input[Union['ControlProjectIntelligenceConfigFilterArgs', 'ControlProjectIntelligenceConfigFilterArgsDict']] filter: Filter over location and bucket using include or exclude semantics. Resources that match the include or exclude filter are exclusively included or excluded from the Storage Intelligence plan.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Identifier of the GCP project. For GCP project, this field can be project name or project number.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ControlProjectIntelligenceConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Storage Control Project Intelligence Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.storage.ControlProjectIntelligenceConfig("example",
            name="test-project",
            edition_config="TRIAL",
            filter={
                "included_cloud_storage_buckets": {
                    "bucket_id_regexes": [
                        "test-id-1*",
                        "test-id-2*",
                    ],
                },
            })
        ```

        ## Import

        ProjectIntelligenceConfig can be imported using any of these accepted formats:

        * `projects/{{name}}/locations/global/intelligenceConfig`

        * `{{name}}`

        When using the `pulumi import` command, ProjectIntelligenceConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:storage/controlProjectIntelligenceConfig:ControlProjectIntelligenceConfig default projects/{{name}}/locations/global/intelligenceConfig
        ```

        ```sh
        $ pulumi import gcp:storage/controlProjectIntelligenceConfig:ControlProjectIntelligenceConfig default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ControlProjectIntelligenceConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ControlProjectIntelligenceConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 edition_config: Optional[pulumi.Input[_builtins.str]] = None,
                 filter: Optional[pulumi.Input[Union['ControlProjectIntelligenceConfigFilterArgs', 'ControlProjectIntelligenceConfigFilterArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ControlProjectIntelligenceConfigArgs.__new__(ControlProjectIntelligenceConfigArgs)

            __props__.__dict__["edition_config"] = edition_config
            __props__.__dict__["filter"] = filter
            __props__.__dict__["name"] = name
            __props__.__dict__["effective_intelligence_configs"] = None
            __props__.__dict__["trial_configs"] = None
            __props__.__dict__["update_time"] = None
        super(ControlProjectIntelligenceConfig, __self__).__init__(
            'gcp:storage/controlProjectIntelligenceConfig:ControlProjectIntelligenceConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            edition_config: Optional[pulumi.Input[_builtins.str]] = None,
            effective_intelligence_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ControlProjectIntelligenceConfigEffectiveIntelligenceConfigArgs', 'ControlProjectIntelligenceConfigEffectiveIntelligenceConfigArgsDict']]]]] = None,
            filter: Optional[pulumi.Input[Union['ControlProjectIntelligenceConfigFilterArgs', 'ControlProjectIntelligenceConfigFilterArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            trial_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ControlProjectIntelligenceConfigTrialConfigArgs', 'ControlProjectIntelligenceConfigTrialConfigArgsDict']]]]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'ControlProjectIntelligenceConfig':
        """
        Get an existing ControlProjectIntelligenceConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] edition_config: Edition configuration of the Storage Intelligence resource. Valid values are INHERIT, TRIAL, DISABLED and STANDARD.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ControlProjectIntelligenceConfigEffectiveIntelligenceConfigArgs', 'ControlProjectIntelligenceConfigEffectiveIntelligenceConfigArgsDict']]]] effective_intelligence_configs: The Intelligence config that is effective for the resource.
               Structure is documented below.
        :param pulumi.Input[Union['ControlProjectIntelligenceConfigFilterArgs', 'ControlProjectIntelligenceConfigFilterArgsDict']] filter: Filter over location and bucket using include or exclude semantics. Resources that match the include or exclude filter are exclusively included or excluded from the Storage Intelligence plan.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Identifier of the GCP project. For GCP project, this field can be project name or project number.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ControlProjectIntelligenceConfigTrialConfigArgs', 'ControlProjectIntelligenceConfigTrialConfigArgsDict']]]] trial_configs: The trial configuration of the Storage Intelligence resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: The time at which the Storage Intelligence Config resource is last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ControlProjectIntelligenceConfigState.__new__(_ControlProjectIntelligenceConfigState)

        __props__.__dict__["edition_config"] = edition_config
        __props__.__dict__["effective_intelligence_configs"] = effective_intelligence_configs
        __props__.__dict__["filter"] = filter
        __props__.__dict__["name"] = name
        __props__.__dict__["trial_configs"] = trial_configs
        __props__.__dict__["update_time"] = update_time
        return ControlProjectIntelligenceConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="editionConfig")
    def edition_config(self) -> pulumi.Output[_builtins.str]:
        """
        Edition configuration of the Storage Intelligence resource. Valid values are INHERIT, TRIAL, DISABLED and STANDARD.
        """
        return pulumi.get(self, "edition_config")

    @_builtins.property
    @pulumi.getter(name="effectiveIntelligenceConfigs")
    def effective_intelligence_configs(self) -> pulumi.Output[Sequence['outputs.ControlProjectIntelligenceConfigEffectiveIntelligenceConfig']]:
        """
        The Intelligence config that is effective for the resource.
        Structure is documented below.
        """
        return pulumi.get(self, "effective_intelligence_configs")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional['outputs.ControlProjectIntelligenceConfigFilter']]:
        """
        Filter over location and bucket using include or exclude semantics. Resources that match the include or exclude filter are exclusively included or excluded from the Storage Intelligence plan.
        Structure is documented below.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the GCP project. For GCP project, this field can be project name or project number.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="trialConfigs")
    def trial_configs(self) -> pulumi.Output[Sequence['outputs.ControlProjectIntelligenceConfigTrialConfig']]:
        """
        The trial configuration of the Storage Intelligence resource.
        Structure is documented below.
        """
        return pulumi.get(self, "trial_configs")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the Storage Intelligence Config resource is last updated.
        """
        return pulumi.get(self, "update_time")

