# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBucketObjectsResult',
    'AwaitableGetBucketObjectsResult',
    'get_bucket_objects',
    'get_bucket_objects_output',
]

@pulumi.output_type
class GetBucketObjectsResult:
    """
    A collection of values returned by getBucketObjects.
    """
    def __init__(__self__, bucket=None, bucket_objects=None, id=None, match_glob=None, prefix=None):
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if bucket_objects and not isinstance(bucket_objects, list):
            raise TypeError("Expected argument 'bucket_objects' to be a list")
        pulumi.set(__self__, "bucket_objects", bucket_objects)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if match_glob and not isinstance(match_glob, str):
            raise TypeError("Expected argument 'match_glob' to be a str")
        pulumi.set(__self__, "match_glob", match_glob)
        if prefix and not isinstance(prefix, str):
            raise TypeError("Expected argument 'prefix' to be a str")
        pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="bucketObjects")
    def bucket_objects(self) -> Sequence['outputs.GetBucketObjectsBucketObjectResult']:
        """
        A list of retrieved objects contained in the provided GCS bucket. Structure is defined below.
        """
        return pulumi.get(self, "bucket_objects")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="matchGlob")
    def match_glob(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "match_glob")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "prefix")


class AwaitableGetBucketObjectsResult(GetBucketObjectsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBucketObjectsResult(
            bucket=self.bucket,
            bucket_objects=self.bucket_objects,
            id=self.id,
            match_glob=self.match_glob,
            prefix=self.prefix)


def get_bucket_objects(bucket: Optional[_builtins.str] = None,
                       match_glob: Optional[_builtins.str] = None,
                       prefix: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBucketObjectsResult:
    """
    Gets existing objects inside an existing bucket in Google Cloud Storage service (GCS).
    See [the official documentation](https://cloud.google.com/storage/docs/key-terms#objects)
    and [API](https://cloud.google.com/storage/docs/json_api/v1/objects/list).

    ## Example Usage

    Example files stored within a bucket.

    ```python
    import pulumi
    import pulumi_gcp as gcp

    files = gcp.storage.get_bucket_objects(bucket="file-store")
    ```


    :param _builtins.str bucket: The name of the containing bucket.
    :param _builtins.str match_glob: A glob pattern used to filter results (for example, `foo*bar`).
    :param _builtins.str prefix: Filter results to include only objects whose names begin with this prefix.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['matchGlob'] = match_glob
    __args__['prefix'] = prefix
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:storage/getBucketObjects:getBucketObjects', __args__, opts=opts, typ=GetBucketObjectsResult).value

    return AwaitableGetBucketObjectsResult(
        bucket=pulumi.get(__ret__, 'bucket'),
        bucket_objects=pulumi.get(__ret__, 'bucket_objects'),
        id=pulumi.get(__ret__, 'id'),
        match_glob=pulumi.get(__ret__, 'match_glob'),
        prefix=pulumi.get(__ret__, 'prefix'))
def get_bucket_objects_output(bucket: Optional[pulumi.Input[_builtins.str]] = None,
                              match_glob: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              prefix: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBucketObjectsResult]:
    """
    Gets existing objects inside an existing bucket in Google Cloud Storage service (GCS).
    See [the official documentation](https://cloud.google.com/storage/docs/key-terms#objects)
    and [API](https://cloud.google.com/storage/docs/json_api/v1/objects/list).

    ## Example Usage

    Example files stored within a bucket.

    ```python
    import pulumi
    import pulumi_gcp as gcp

    files = gcp.storage.get_bucket_objects(bucket="file-store")
    ```


    :param _builtins.str bucket: The name of the containing bucket.
    :param _builtins.str match_glob: A glob pattern used to filter results (for example, `foo*bar`).
    :param _builtins.str prefix: Filter results to include only objects whose names begin with this prefix.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['matchGlob'] = match_glob
    __args__['prefix'] = prefix
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:storage/getBucketObjects:getBucketObjects', __args__, opts=opts, typ=GetBucketObjectsResult)
    return __ret__.apply(lambda __response__: GetBucketObjectsResult(
        bucket=pulumi.get(__response__, 'bucket'),
        bucket_objects=pulumi.get(__response__, 'bucket_objects'),
        id=pulumi.get(__response__, 'id'),
        match_glob=pulumi.get(__response__, 'match_glob'),
        prefix=pulumi.get(__response__, 'prefix')))
