# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InsightsDatasetConfigArgs', 'InsightsDatasetConfig']

@pulumi.input_type
class InsightsDatasetConfigArgs:
    def __init__(__self__, *,
                 dataset_config_id: pulumi.Input[_builtins.str],
                 identity: pulumi.Input['InsightsDatasetConfigIdentityArgs'],
                 location: pulumi.Input[_builtins.str],
                 retention_period_days: pulumi.Input[_builtins.int],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cloud_storage_buckets: Optional[pulumi.Input['InsightsDatasetConfigExcludeCloudStorageBucketsArgs']] = None,
                 exclude_cloud_storage_locations: Optional[pulumi.Input['InsightsDatasetConfigExcludeCloudStorageLocationsArgs']] = None,
                 include_cloud_storage_buckets: Optional[pulumi.Input['InsightsDatasetConfigIncludeCloudStorageBucketsArgs']] = None,
                 include_cloud_storage_locations: Optional[pulumi.Input['InsightsDatasetConfigIncludeCloudStorageLocationsArgs']] = None,
                 include_newly_created_buckets: Optional[pulumi.Input[_builtins.bool]] = None,
                 link_dataset: Optional[pulumi.Input[_builtins.bool]] = None,
                 organization_number: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_scope: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 source_folders: Optional[pulumi.Input['InsightsDatasetConfigSourceFoldersArgs']] = None,
                 source_projects: Optional[pulumi.Input['InsightsDatasetConfigSourceProjectsArgs']] = None):
        """
        The set of arguments for constructing a InsightsDatasetConfig resource.
        :param pulumi.Input[_builtins.str] dataset_config_id: The user-defined ID of the DatasetConfig
        :param pulumi.Input['InsightsDatasetConfigIdentityArgs'] identity: Identity used by DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The location of the DatasetConfig.
        :param pulumi.Input[_builtins.int] retention_period_days: Number of days of history that must be retained.
        :param pulumi.Input[_builtins.str] description: An optional user-provided description for the dataset configuration with a maximum length of 256 characters.
        :param pulumi.Input['InsightsDatasetConfigExcludeCloudStorageBucketsArgs'] exclude_cloud_storage_buckets: Defined the options for excluding cloud storage buckets for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input['InsightsDatasetConfigExcludeCloudStorageLocationsArgs'] exclude_cloud_storage_locations: Defines the options for excluding cloud storage locations for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input['InsightsDatasetConfigIncludeCloudStorageBucketsArgs'] include_cloud_storage_buckets: Defines the options for including cloud storage buckets for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input['InsightsDatasetConfigIncludeCloudStorageLocationsArgs'] include_cloud_storage_locations: Defines the options for including cloud storage locations for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] include_newly_created_buckets: If set to true, the request includes all the newly created buckets in the dataset that meet the inclusion and exclusion rules.
        :param pulumi.Input[_builtins.str] organization_number: Organization resource ID that the source projects should belong to.
               Projects that do not belong to the provided organization are not considered when creating the dataset.
        :param pulumi.Input[_builtins.bool] organization_scope: Defines the options for providing a source organization for the DatasetConfig.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['InsightsDatasetConfigSourceFoldersArgs'] source_folders: Defines the options for providing source folders for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input['InsightsDatasetConfigSourceProjectsArgs'] source_projects: Defines the options for providing source projects for the DatasetConfig.
               Structure is documented below.
        """
        pulumi.set(__self__, "dataset_config_id", dataset_config_id)
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "retention_period_days", retention_period_days)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclude_cloud_storage_buckets is not None:
            pulumi.set(__self__, "exclude_cloud_storage_buckets", exclude_cloud_storage_buckets)
        if exclude_cloud_storage_locations is not None:
            pulumi.set(__self__, "exclude_cloud_storage_locations", exclude_cloud_storage_locations)
        if include_cloud_storage_buckets is not None:
            pulumi.set(__self__, "include_cloud_storage_buckets", include_cloud_storage_buckets)
        if include_cloud_storage_locations is not None:
            pulumi.set(__self__, "include_cloud_storage_locations", include_cloud_storage_locations)
        if include_newly_created_buckets is not None:
            pulumi.set(__self__, "include_newly_created_buckets", include_newly_created_buckets)
        if link_dataset is not None:
            pulumi.set(__self__, "link_dataset", link_dataset)
        if organization_number is not None:
            pulumi.set(__self__, "organization_number", organization_number)
        if organization_scope is not None:
            pulumi.set(__self__, "organization_scope", organization_scope)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if source_folders is not None:
            pulumi.set(__self__, "source_folders", source_folders)
        if source_projects is not None:
            pulumi.set(__self__, "source_projects", source_projects)

    @_builtins.property
    @pulumi.getter(name="datasetConfigId")
    def dataset_config_id(self) -> pulumi.Input[_builtins.str]:
        """
        The user-defined ID of the DatasetConfig
        """
        return pulumi.get(self, "dataset_config_id")

    @dataset_config_id.setter
    def dataset_config_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dataset_config_id", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Input['InsightsDatasetConfigIdentityArgs']:
        """
        Identity used by DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input['InsightsDatasetConfigIdentityArgs']):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the DatasetConfig.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriodDays")
    def retention_period_days(self) -> pulumi.Input[_builtins.int]:
        """
        Number of days of history that must be retained.
        """
        return pulumi.get(self, "retention_period_days")

    @retention_period_days.setter
    def retention_period_days(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "retention_period_days", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional user-provided description for the dataset configuration with a maximum length of 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="excludeCloudStorageBuckets")
    def exclude_cloud_storage_buckets(self) -> Optional[pulumi.Input['InsightsDatasetConfigExcludeCloudStorageBucketsArgs']]:
        """
        Defined the options for excluding cloud storage buckets for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "exclude_cloud_storage_buckets")

    @exclude_cloud_storage_buckets.setter
    def exclude_cloud_storage_buckets(self, value: Optional[pulumi.Input['InsightsDatasetConfigExcludeCloudStorageBucketsArgs']]):
        pulumi.set(self, "exclude_cloud_storage_buckets", value)

    @_builtins.property
    @pulumi.getter(name="excludeCloudStorageLocations")
    def exclude_cloud_storage_locations(self) -> Optional[pulumi.Input['InsightsDatasetConfigExcludeCloudStorageLocationsArgs']]:
        """
        Defines the options for excluding cloud storage locations for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "exclude_cloud_storage_locations")

    @exclude_cloud_storage_locations.setter
    def exclude_cloud_storage_locations(self, value: Optional[pulumi.Input['InsightsDatasetConfigExcludeCloudStorageLocationsArgs']]):
        pulumi.set(self, "exclude_cloud_storage_locations", value)

    @_builtins.property
    @pulumi.getter(name="includeCloudStorageBuckets")
    def include_cloud_storage_buckets(self) -> Optional[pulumi.Input['InsightsDatasetConfigIncludeCloudStorageBucketsArgs']]:
        """
        Defines the options for including cloud storage buckets for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "include_cloud_storage_buckets")

    @include_cloud_storage_buckets.setter
    def include_cloud_storage_buckets(self, value: Optional[pulumi.Input['InsightsDatasetConfigIncludeCloudStorageBucketsArgs']]):
        pulumi.set(self, "include_cloud_storage_buckets", value)

    @_builtins.property
    @pulumi.getter(name="includeCloudStorageLocations")
    def include_cloud_storage_locations(self) -> Optional[pulumi.Input['InsightsDatasetConfigIncludeCloudStorageLocationsArgs']]:
        """
        Defines the options for including cloud storage locations for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "include_cloud_storage_locations")

    @include_cloud_storage_locations.setter
    def include_cloud_storage_locations(self, value: Optional[pulumi.Input['InsightsDatasetConfigIncludeCloudStorageLocationsArgs']]):
        pulumi.set(self, "include_cloud_storage_locations", value)

    @_builtins.property
    @pulumi.getter(name="includeNewlyCreatedBuckets")
    def include_newly_created_buckets(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, the request includes all the newly created buckets in the dataset that meet the inclusion and exclusion rules.
        """
        return pulumi.get(self, "include_newly_created_buckets")

    @include_newly_created_buckets.setter
    def include_newly_created_buckets(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_newly_created_buckets", value)

    @_builtins.property
    @pulumi.getter(name="linkDataset")
    def link_dataset(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "link_dataset")

    @link_dataset.setter
    def link_dataset(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "link_dataset", value)

    @_builtins.property
    @pulumi.getter(name="organizationNumber")
    def organization_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization resource ID that the source projects should belong to.
        Projects that do not belong to the provided organization are not considered when creating the dataset.
        """
        return pulumi.get(self, "organization_number")

    @organization_number.setter
    def organization_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_number", value)

    @_builtins.property
    @pulumi.getter(name="organizationScope")
    def organization_scope(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines the options for providing a source organization for the DatasetConfig.
        """
        return pulumi.get(self, "organization_scope")

    @organization_scope.setter
    def organization_scope(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "organization_scope", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="sourceFolders")
    def source_folders(self) -> Optional[pulumi.Input['InsightsDatasetConfigSourceFoldersArgs']]:
        """
        Defines the options for providing source folders for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "source_folders")

    @source_folders.setter
    def source_folders(self, value: Optional[pulumi.Input['InsightsDatasetConfigSourceFoldersArgs']]):
        pulumi.set(self, "source_folders", value)

    @_builtins.property
    @pulumi.getter(name="sourceProjects")
    def source_projects(self) -> Optional[pulumi.Input['InsightsDatasetConfigSourceProjectsArgs']]:
        """
        Defines the options for providing source projects for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "source_projects")

    @source_projects.setter
    def source_projects(self, value: Optional[pulumi.Input['InsightsDatasetConfigSourceProjectsArgs']]):
        pulumi.set(self, "source_projects", value)


@pulumi.input_type
class _InsightsDatasetConfigState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dataset_config_state: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cloud_storage_buckets: Optional[pulumi.Input['InsightsDatasetConfigExcludeCloudStorageBucketsArgs']] = None,
                 exclude_cloud_storage_locations: Optional[pulumi.Input['InsightsDatasetConfigExcludeCloudStorageLocationsArgs']] = None,
                 identity: Optional[pulumi.Input['InsightsDatasetConfigIdentityArgs']] = None,
                 include_cloud_storage_buckets: Optional[pulumi.Input['InsightsDatasetConfigIncludeCloudStorageBucketsArgs']] = None,
                 include_cloud_storage_locations: Optional[pulumi.Input['InsightsDatasetConfigIncludeCloudStorageLocationsArgs']] = None,
                 include_newly_created_buckets: Optional[pulumi.Input[_builtins.bool]] = None,
                 link_dataset: Optional[pulumi.Input[_builtins.bool]] = None,
                 links: Optional[pulumi.Input[Sequence[pulumi.Input['InsightsDatasetConfigLinkArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_number: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_scope: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period_days: Optional[pulumi.Input[_builtins.int]] = None,
                 source_folders: Optional[pulumi.Input['InsightsDatasetConfigSourceFoldersArgs']] = None,
                 source_projects: Optional[pulumi.Input['InsightsDatasetConfigSourceProjectsArgs']] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InsightsDatasetConfig resources.
        :param pulumi.Input[_builtins.str] create_time: The UTC time at which the DatasetConfig was created. This is auto-populated.
        :param pulumi.Input[_builtins.str] dataset_config_id: The user-defined ID of the DatasetConfig
        :param pulumi.Input[_builtins.str] dataset_config_state: State of the DatasetConfig.
        :param pulumi.Input[_builtins.str] description: An optional user-provided description for the dataset configuration with a maximum length of 256 characters.
        :param pulumi.Input['InsightsDatasetConfigExcludeCloudStorageBucketsArgs'] exclude_cloud_storage_buckets: Defined the options for excluding cloud storage buckets for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input['InsightsDatasetConfigExcludeCloudStorageLocationsArgs'] exclude_cloud_storage_locations: Defines the options for excluding cloud storage locations for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input['InsightsDatasetConfigIdentityArgs'] identity: Identity used by DatasetConfig.
               Structure is documented below.
        :param pulumi.Input['InsightsDatasetConfigIncludeCloudStorageBucketsArgs'] include_cloud_storage_buckets: Defines the options for including cloud storage buckets for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input['InsightsDatasetConfigIncludeCloudStorageLocationsArgs'] include_cloud_storage_locations: Defines the options for including cloud storage locations for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] include_newly_created_buckets: If set to true, the request includes all the newly created buckets in the dataset that meet the inclusion and exclusion rules.
        :param pulumi.Input[Sequence[pulumi.Input['InsightsDatasetConfigLinkArgs']]] links: Details of the linked DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The location of the DatasetConfig.
        :param pulumi.Input[_builtins.str] name: The full canonical resource name of the DatasetConfig (e.g., projects/P/locations/L/datasetConfigs/ID).
        :param pulumi.Input[_builtins.str] organization_number: Organization resource ID that the source projects should belong to.
               Projects that do not belong to the provided organization are not considered when creating the dataset.
        :param pulumi.Input[_builtins.bool] organization_scope: Defines the options for providing a source organization for the DatasetConfig.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.int] retention_period_days: Number of days of history that must be retained.
        :param pulumi.Input['InsightsDatasetConfigSourceFoldersArgs'] source_folders: Defines the options for providing source folders for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input['InsightsDatasetConfigSourceProjectsArgs'] source_projects: Defines the options for providing source projects for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: System generated unique identifier for the resource.
        :param pulumi.Input[_builtins.str] update_time: The UTC time at which the DatasetConfig was updated. This is auto-populated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dataset_config_id is not None:
            pulumi.set(__self__, "dataset_config_id", dataset_config_id)
        if dataset_config_state is not None:
            pulumi.set(__self__, "dataset_config_state", dataset_config_state)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclude_cloud_storage_buckets is not None:
            pulumi.set(__self__, "exclude_cloud_storage_buckets", exclude_cloud_storage_buckets)
        if exclude_cloud_storage_locations is not None:
            pulumi.set(__self__, "exclude_cloud_storage_locations", exclude_cloud_storage_locations)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if include_cloud_storage_buckets is not None:
            pulumi.set(__self__, "include_cloud_storage_buckets", include_cloud_storage_buckets)
        if include_cloud_storage_locations is not None:
            pulumi.set(__self__, "include_cloud_storage_locations", include_cloud_storage_locations)
        if include_newly_created_buckets is not None:
            pulumi.set(__self__, "include_newly_created_buckets", include_newly_created_buckets)
        if link_dataset is not None:
            pulumi.set(__self__, "link_dataset", link_dataset)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_number is not None:
            pulumi.set(__self__, "organization_number", organization_number)
        if organization_scope is not None:
            pulumi.set(__self__, "organization_scope", organization_scope)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if retention_period_days is not None:
            pulumi.set(__self__, "retention_period_days", retention_period_days)
        if source_folders is not None:
            pulumi.set(__self__, "source_folders", source_folders)
        if source_projects is not None:
            pulumi.set(__self__, "source_projects", source_projects)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UTC time at which the DatasetConfig was created. This is auto-populated.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="datasetConfigId")
    def dataset_config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-defined ID of the DatasetConfig
        """
        return pulumi.get(self, "dataset_config_id")

    @dataset_config_id.setter
    def dataset_config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset_config_id", value)

    @_builtins.property
    @pulumi.getter(name="datasetConfigState")
    def dataset_config_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the DatasetConfig.
        """
        return pulumi.get(self, "dataset_config_state")

    @dataset_config_state.setter
    def dataset_config_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset_config_state", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional user-provided description for the dataset configuration with a maximum length of 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="excludeCloudStorageBuckets")
    def exclude_cloud_storage_buckets(self) -> Optional[pulumi.Input['InsightsDatasetConfigExcludeCloudStorageBucketsArgs']]:
        """
        Defined the options for excluding cloud storage buckets for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "exclude_cloud_storage_buckets")

    @exclude_cloud_storage_buckets.setter
    def exclude_cloud_storage_buckets(self, value: Optional[pulumi.Input['InsightsDatasetConfigExcludeCloudStorageBucketsArgs']]):
        pulumi.set(self, "exclude_cloud_storage_buckets", value)

    @_builtins.property
    @pulumi.getter(name="excludeCloudStorageLocations")
    def exclude_cloud_storage_locations(self) -> Optional[pulumi.Input['InsightsDatasetConfigExcludeCloudStorageLocationsArgs']]:
        """
        Defines the options for excluding cloud storage locations for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "exclude_cloud_storage_locations")

    @exclude_cloud_storage_locations.setter
    def exclude_cloud_storage_locations(self, value: Optional[pulumi.Input['InsightsDatasetConfigExcludeCloudStorageLocationsArgs']]):
        pulumi.set(self, "exclude_cloud_storage_locations", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['InsightsDatasetConfigIdentityArgs']]:
        """
        Identity used by DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['InsightsDatasetConfigIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="includeCloudStorageBuckets")
    def include_cloud_storage_buckets(self) -> Optional[pulumi.Input['InsightsDatasetConfigIncludeCloudStorageBucketsArgs']]:
        """
        Defines the options for including cloud storage buckets for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "include_cloud_storage_buckets")

    @include_cloud_storage_buckets.setter
    def include_cloud_storage_buckets(self, value: Optional[pulumi.Input['InsightsDatasetConfigIncludeCloudStorageBucketsArgs']]):
        pulumi.set(self, "include_cloud_storage_buckets", value)

    @_builtins.property
    @pulumi.getter(name="includeCloudStorageLocations")
    def include_cloud_storage_locations(self) -> Optional[pulumi.Input['InsightsDatasetConfigIncludeCloudStorageLocationsArgs']]:
        """
        Defines the options for including cloud storage locations for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "include_cloud_storage_locations")

    @include_cloud_storage_locations.setter
    def include_cloud_storage_locations(self, value: Optional[pulumi.Input['InsightsDatasetConfigIncludeCloudStorageLocationsArgs']]):
        pulumi.set(self, "include_cloud_storage_locations", value)

    @_builtins.property
    @pulumi.getter(name="includeNewlyCreatedBuckets")
    def include_newly_created_buckets(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, the request includes all the newly created buckets in the dataset that meet the inclusion and exclusion rules.
        """
        return pulumi.get(self, "include_newly_created_buckets")

    @include_newly_created_buckets.setter
    def include_newly_created_buckets(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_newly_created_buckets", value)

    @_builtins.property
    @pulumi.getter(name="linkDataset")
    def link_dataset(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "link_dataset")

    @link_dataset.setter
    def link_dataset(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "link_dataset", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InsightsDatasetConfigLinkArgs']]]]:
        """
        Details of the linked DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InsightsDatasetConfigLinkArgs']]]]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the DatasetConfig.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full canonical resource name of the DatasetConfig (e.g., projects/P/locations/L/datasetConfigs/ID).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationNumber")
    def organization_number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization resource ID that the source projects should belong to.
        Projects that do not belong to the provided organization are not considered when creating the dataset.
        """
        return pulumi.get(self, "organization_number")

    @organization_number.setter
    def organization_number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_number", value)

    @_builtins.property
    @pulumi.getter(name="organizationScope")
    def organization_scope(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Defines the options for providing a source organization for the DatasetConfig.
        """
        return pulumi.get(self, "organization_scope")

    @organization_scope.setter
    def organization_scope(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "organization_scope", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriodDays")
    def retention_period_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of days of history that must be retained.
        """
        return pulumi.get(self, "retention_period_days")

    @retention_period_days.setter
    def retention_period_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_period_days", value)

    @_builtins.property
    @pulumi.getter(name="sourceFolders")
    def source_folders(self) -> Optional[pulumi.Input['InsightsDatasetConfigSourceFoldersArgs']]:
        """
        Defines the options for providing source folders for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "source_folders")

    @source_folders.setter
    def source_folders(self, value: Optional[pulumi.Input['InsightsDatasetConfigSourceFoldersArgs']]):
        pulumi.set(self, "source_folders", value)

    @_builtins.property
    @pulumi.getter(name="sourceProjects")
    def source_projects(self) -> Optional[pulumi.Input['InsightsDatasetConfigSourceProjectsArgs']]:
        """
        Defines the options for providing source projects for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "source_projects")

    @source_projects.setter
    def source_projects(self, value: Optional[pulumi.Input['InsightsDatasetConfigSourceProjectsArgs']]):
        pulumi.set(self, "source_projects", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        System generated unique identifier for the resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UTC time at which the DatasetConfig was updated. This is auto-populated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:storage/insightsDatasetConfig:InsightsDatasetConfig")
class InsightsDatasetConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cloud_storage_buckets: Optional[pulumi.Input[Union['InsightsDatasetConfigExcludeCloudStorageBucketsArgs', 'InsightsDatasetConfigExcludeCloudStorageBucketsArgsDict']]] = None,
                 exclude_cloud_storage_locations: Optional[pulumi.Input[Union['InsightsDatasetConfigExcludeCloudStorageLocationsArgs', 'InsightsDatasetConfigExcludeCloudStorageLocationsArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['InsightsDatasetConfigIdentityArgs', 'InsightsDatasetConfigIdentityArgsDict']]] = None,
                 include_cloud_storage_buckets: Optional[pulumi.Input[Union['InsightsDatasetConfigIncludeCloudStorageBucketsArgs', 'InsightsDatasetConfigIncludeCloudStorageBucketsArgsDict']]] = None,
                 include_cloud_storage_locations: Optional[pulumi.Input[Union['InsightsDatasetConfigIncludeCloudStorageLocationsArgs', 'InsightsDatasetConfigIncludeCloudStorageLocationsArgsDict']]] = None,
                 include_newly_created_buckets: Optional[pulumi.Input[_builtins.bool]] = None,
                 link_dataset: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_number: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_scope: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period_days: Optional[pulumi.Input[_builtins.int]] = None,
                 source_folders: Optional[pulumi.Input[Union['InsightsDatasetConfigSourceFoldersArgs', 'InsightsDatasetConfigSourceFoldersArgsDict']]] = None,
                 source_projects: Optional[pulumi.Input[Union['InsightsDatasetConfigSourceProjectsArgs', 'InsightsDatasetConfigSourceProjectsArgsDict']]] = None,
                 __props__=None):
        """
        Represents a Storage Insights DatasetConfig.

        To get more information about DatasetConfig, see:

        * [API documentation](https://cloud.google.com/storage/docs/insights/reference/rest/v1/projects.locations.datasetConfigs)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/storage/docs/insights/datasets)

        ## Example Usage

        ### Storage Insights Dataset Config Includes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        config_includes = gcp.storage.InsightsDatasetConfig("config_includes",
            location="us-central1",
            dataset_config_id="my_config_includes",
            retention_period_days=1,
            source_projects={
                "project_numbers": [
                    "123",
                    "456",
                    "789",
                ],
            },
            identity={
                "type": "IDENTITY_TYPE_PER_CONFIG",
            },
            description="Sample Description",
            link_dataset=False,
            include_newly_created_buckets=True,
            include_cloud_storage_locations={
                "locations": ["us-east1"],
            },
            include_cloud_storage_buckets={
                "cloud_storage_buckets": [
                    {
                        "bucket_name": "sample-bucket",
                    },
                    {
                        "bucket_name": "sample-regex",
                    },
                ],
            })
        ```
        ### Storage Insights Dataset Config Excludes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        config_excludes = gcp.storage.InsightsDatasetConfig("config_excludes",
            location="us-central1",
            dataset_config_id="my_config_excludes",
            retention_period_days=1,
            organization_scope=True,
            identity={
                "type": "IDENTITY_TYPE_PER_PROJECT",
            },
            exclude_cloud_storage_locations={
                "locations": ["us-east1"],
            },
            exclude_cloud_storage_buckets={
                "cloud_storage_buckets": [
                    {
                        "bucket_name": "sample-bucket",
                    },
                    {
                        "bucket_name": "sample-regex",
                    },
                ],
            })
        ```

        ## Import

        DatasetConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/datasetConfigs/{{dataset_config_id}}`

        * `{{project}}/{{location}}/{{dataset_config_id}}`

        * `{{location}}/{{dataset_config_id}}`

        When using the `pulumi import` command, DatasetConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:storage/insightsDatasetConfig:InsightsDatasetConfig default projects/{{project}}/locations/{{location}}/datasetConfigs/{{dataset_config_id}}
        ```

        ```sh
        $ pulumi import gcp:storage/insightsDatasetConfig:InsightsDatasetConfig default {{project}}/{{location}}/{{dataset_config_id}}
        ```

        ```sh
        $ pulumi import gcp:storage/insightsDatasetConfig:InsightsDatasetConfig default {{location}}/{{dataset_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dataset_config_id: The user-defined ID of the DatasetConfig
        :param pulumi.Input[_builtins.str] description: An optional user-provided description for the dataset configuration with a maximum length of 256 characters.
        :param pulumi.Input[Union['InsightsDatasetConfigExcludeCloudStorageBucketsArgs', 'InsightsDatasetConfigExcludeCloudStorageBucketsArgsDict']] exclude_cloud_storage_buckets: Defined the options for excluding cloud storage buckets for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[Union['InsightsDatasetConfigExcludeCloudStorageLocationsArgs', 'InsightsDatasetConfigExcludeCloudStorageLocationsArgsDict']] exclude_cloud_storage_locations: Defines the options for excluding cloud storage locations for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[Union['InsightsDatasetConfigIdentityArgs', 'InsightsDatasetConfigIdentityArgsDict']] identity: Identity used by DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[Union['InsightsDatasetConfigIncludeCloudStorageBucketsArgs', 'InsightsDatasetConfigIncludeCloudStorageBucketsArgsDict']] include_cloud_storage_buckets: Defines the options for including cloud storage buckets for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[Union['InsightsDatasetConfigIncludeCloudStorageLocationsArgs', 'InsightsDatasetConfigIncludeCloudStorageLocationsArgsDict']] include_cloud_storage_locations: Defines the options for including cloud storage locations for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] include_newly_created_buckets: If set to true, the request includes all the newly created buckets in the dataset that meet the inclusion and exclusion rules.
        :param pulumi.Input[_builtins.str] location: The location of the DatasetConfig.
        :param pulumi.Input[_builtins.str] organization_number: Organization resource ID that the source projects should belong to.
               Projects that do not belong to the provided organization are not considered when creating the dataset.
        :param pulumi.Input[_builtins.bool] organization_scope: Defines the options for providing a source organization for the DatasetConfig.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.int] retention_period_days: Number of days of history that must be retained.
        :param pulumi.Input[Union['InsightsDatasetConfigSourceFoldersArgs', 'InsightsDatasetConfigSourceFoldersArgsDict']] source_folders: Defines the options for providing source folders for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[Union['InsightsDatasetConfigSourceProjectsArgs', 'InsightsDatasetConfigSourceProjectsArgsDict']] source_projects: Defines the options for providing source projects for the DatasetConfig.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InsightsDatasetConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a Storage Insights DatasetConfig.

        To get more information about DatasetConfig, see:

        * [API documentation](https://cloud.google.com/storage/docs/insights/reference/rest/v1/projects.locations.datasetConfigs)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/storage/docs/insights/datasets)

        ## Example Usage

        ### Storage Insights Dataset Config Includes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        config_includes = gcp.storage.InsightsDatasetConfig("config_includes",
            location="us-central1",
            dataset_config_id="my_config_includes",
            retention_period_days=1,
            source_projects={
                "project_numbers": [
                    "123",
                    "456",
                    "789",
                ],
            },
            identity={
                "type": "IDENTITY_TYPE_PER_CONFIG",
            },
            description="Sample Description",
            link_dataset=False,
            include_newly_created_buckets=True,
            include_cloud_storage_locations={
                "locations": ["us-east1"],
            },
            include_cloud_storage_buckets={
                "cloud_storage_buckets": [
                    {
                        "bucket_name": "sample-bucket",
                    },
                    {
                        "bucket_name": "sample-regex",
                    },
                ],
            })
        ```
        ### Storage Insights Dataset Config Excludes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        config_excludes = gcp.storage.InsightsDatasetConfig("config_excludes",
            location="us-central1",
            dataset_config_id="my_config_excludes",
            retention_period_days=1,
            organization_scope=True,
            identity={
                "type": "IDENTITY_TYPE_PER_PROJECT",
            },
            exclude_cloud_storage_locations={
                "locations": ["us-east1"],
            },
            exclude_cloud_storage_buckets={
                "cloud_storage_buckets": [
                    {
                        "bucket_name": "sample-bucket",
                    },
                    {
                        "bucket_name": "sample-regex",
                    },
                ],
            })
        ```

        ## Import

        DatasetConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/datasetConfigs/{{dataset_config_id}}`

        * `{{project}}/{{location}}/{{dataset_config_id}}`

        * `{{location}}/{{dataset_config_id}}`

        When using the `pulumi import` command, DatasetConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:storage/insightsDatasetConfig:InsightsDatasetConfig default projects/{{project}}/locations/{{location}}/datasetConfigs/{{dataset_config_id}}
        ```

        ```sh
        $ pulumi import gcp:storage/insightsDatasetConfig:InsightsDatasetConfig default {{project}}/{{location}}/{{dataset_config_id}}
        ```

        ```sh
        $ pulumi import gcp:storage/insightsDatasetConfig:InsightsDatasetConfig default {{location}}/{{dataset_config_id}}
        ```

        :param str resource_name: The name of the resource.
        :param InsightsDatasetConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InsightsDatasetConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cloud_storage_buckets: Optional[pulumi.Input[Union['InsightsDatasetConfigExcludeCloudStorageBucketsArgs', 'InsightsDatasetConfigExcludeCloudStorageBucketsArgsDict']]] = None,
                 exclude_cloud_storage_locations: Optional[pulumi.Input[Union['InsightsDatasetConfigExcludeCloudStorageLocationsArgs', 'InsightsDatasetConfigExcludeCloudStorageLocationsArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['InsightsDatasetConfigIdentityArgs', 'InsightsDatasetConfigIdentityArgsDict']]] = None,
                 include_cloud_storage_buckets: Optional[pulumi.Input[Union['InsightsDatasetConfigIncludeCloudStorageBucketsArgs', 'InsightsDatasetConfigIncludeCloudStorageBucketsArgsDict']]] = None,
                 include_cloud_storage_locations: Optional[pulumi.Input[Union['InsightsDatasetConfigIncludeCloudStorageLocationsArgs', 'InsightsDatasetConfigIncludeCloudStorageLocationsArgsDict']]] = None,
                 include_newly_created_buckets: Optional[pulumi.Input[_builtins.bool]] = None,
                 link_dataset: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_number: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_scope: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period_days: Optional[pulumi.Input[_builtins.int]] = None,
                 source_folders: Optional[pulumi.Input[Union['InsightsDatasetConfigSourceFoldersArgs', 'InsightsDatasetConfigSourceFoldersArgsDict']]] = None,
                 source_projects: Optional[pulumi.Input[Union['InsightsDatasetConfigSourceProjectsArgs', 'InsightsDatasetConfigSourceProjectsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InsightsDatasetConfigArgs.__new__(InsightsDatasetConfigArgs)

            if dataset_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'dataset_config_id'")
            __props__.__dict__["dataset_config_id"] = dataset_config_id
            __props__.__dict__["description"] = description
            __props__.__dict__["exclude_cloud_storage_buckets"] = exclude_cloud_storage_buckets
            __props__.__dict__["exclude_cloud_storage_locations"] = exclude_cloud_storage_locations
            if identity is None and not opts.urn:
                raise TypeError("Missing required property 'identity'")
            __props__.__dict__["identity"] = identity
            __props__.__dict__["include_cloud_storage_buckets"] = include_cloud_storage_buckets
            __props__.__dict__["include_cloud_storage_locations"] = include_cloud_storage_locations
            __props__.__dict__["include_newly_created_buckets"] = include_newly_created_buckets
            __props__.__dict__["link_dataset"] = link_dataset
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["organization_number"] = organization_number
            __props__.__dict__["organization_scope"] = organization_scope
            __props__.__dict__["project"] = project
            if retention_period_days is None and not opts.urn:
                raise TypeError("Missing required property 'retention_period_days'")
            __props__.__dict__["retention_period_days"] = retention_period_days
            __props__.__dict__["source_folders"] = source_folders
            __props__.__dict__["source_projects"] = source_projects
            __props__.__dict__["create_time"] = None
            __props__.__dict__["dataset_config_state"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(InsightsDatasetConfig, __self__).__init__(
            'gcp:storage/insightsDatasetConfig:InsightsDatasetConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            dataset_config_id: Optional[pulumi.Input[_builtins.str]] = None,
            dataset_config_state: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            exclude_cloud_storage_buckets: Optional[pulumi.Input[Union['InsightsDatasetConfigExcludeCloudStorageBucketsArgs', 'InsightsDatasetConfigExcludeCloudStorageBucketsArgsDict']]] = None,
            exclude_cloud_storage_locations: Optional[pulumi.Input[Union['InsightsDatasetConfigExcludeCloudStorageLocationsArgs', 'InsightsDatasetConfigExcludeCloudStorageLocationsArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['InsightsDatasetConfigIdentityArgs', 'InsightsDatasetConfigIdentityArgsDict']]] = None,
            include_cloud_storage_buckets: Optional[pulumi.Input[Union['InsightsDatasetConfigIncludeCloudStorageBucketsArgs', 'InsightsDatasetConfigIncludeCloudStorageBucketsArgsDict']]] = None,
            include_cloud_storage_locations: Optional[pulumi.Input[Union['InsightsDatasetConfigIncludeCloudStorageLocationsArgs', 'InsightsDatasetConfigIncludeCloudStorageLocationsArgsDict']]] = None,
            include_newly_created_buckets: Optional[pulumi.Input[_builtins.bool]] = None,
            link_dataset: Optional[pulumi.Input[_builtins.bool]] = None,
            links: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InsightsDatasetConfigLinkArgs', 'InsightsDatasetConfigLinkArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_number: Optional[pulumi.Input[_builtins.str]] = None,
            organization_scope: Optional[pulumi.Input[_builtins.bool]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            retention_period_days: Optional[pulumi.Input[_builtins.int]] = None,
            source_folders: Optional[pulumi.Input[Union['InsightsDatasetConfigSourceFoldersArgs', 'InsightsDatasetConfigSourceFoldersArgsDict']]] = None,
            source_projects: Optional[pulumi.Input[Union['InsightsDatasetConfigSourceProjectsArgs', 'InsightsDatasetConfigSourceProjectsArgsDict']]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'InsightsDatasetConfig':
        """
        Get an existing InsightsDatasetConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The UTC time at which the DatasetConfig was created. This is auto-populated.
        :param pulumi.Input[_builtins.str] dataset_config_id: The user-defined ID of the DatasetConfig
        :param pulumi.Input[_builtins.str] dataset_config_state: State of the DatasetConfig.
        :param pulumi.Input[_builtins.str] description: An optional user-provided description for the dataset configuration with a maximum length of 256 characters.
        :param pulumi.Input[Union['InsightsDatasetConfigExcludeCloudStorageBucketsArgs', 'InsightsDatasetConfigExcludeCloudStorageBucketsArgsDict']] exclude_cloud_storage_buckets: Defined the options for excluding cloud storage buckets for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[Union['InsightsDatasetConfigExcludeCloudStorageLocationsArgs', 'InsightsDatasetConfigExcludeCloudStorageLocationsArgsDict']] exclude_cloud_storage_locations: Defines the options for excluding cloud storage locations for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[Union['InsightsDatasetConfigIdentityArgs', 'InsightsDatasetConfigIdentityArgsDict']] identity: Identity used by DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[Union['InsightsDatasetConfigIncludeCloudStorageBucketsArgs', 'InsightsDatasetConfigIncludeCloudStorageBucketsArgsDict']] include_cloud_storage_buckets: Defines the options for including cloud storage buckets for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[Union['InsightsDatasetConfigIncludeCloudStorageLocationsArgs', 'InsightsDatasetConfigIncludeCloudStorageLocationsArgsDict']] include_cloud_storage_locations: Defines the options for including cloud storage locations for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] include_newly_created_buckets: If set to true, the request includes all the newly created buckets in the dataset that meet the inclusion and exclusion rules.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InsightsDatasetConfigLinkArgs', 'InsightsDatasetConfigLinkArgsDict']]]] links: Details of the linked DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The location of the DatasetConfig.
        :param pulumi.Input[_builtins.str] name: The full canonical resource name of the DatasetConfig (e.g., projects/P/locations/L/datasetConfigs/ID).
        :param pulumi.Input[_builtins.str] organization_number: Organization resource ID that the source projects should belong to.
               Projects that do not belong to the provided organization are not considered when creating the dataset.
        :param pulumi.Input[_builtins.bool] organization_scope: Defines the options for providing a source organization for the DatasetConfig.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.int] retention_period_days: Number of days of history that must be retained.
        :param pulumi.Input[Union['InsightsDatasetConfigSourceFoldersArgs', 'InsightsDatasetConfigSourceFoldersArgsDict']] source_folders: Defines the options for providing source folders for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[Union['InsightsDatasetConfigSourceProjectsArgs', 'InsightsDatasetConfigSourceProjectsArgsDict']] source_projects: Defines the options for providing source projects for the DatasetConfig.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: System generated unique identifier for the resource.
        :param pulumi.Input[_builtins.str] update_time: The UTC time at which the DatasetConfig was updated. This is auto-populated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InsightsDatasetConfigState.__new__(_InsightsDatasetConfigState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dataset_config_id"] = dataset_config_id
        __props__.__dict__["dataset_config_state"] = dataset_config_state
        __props__.__dict__["description"] = description
        __props__.__dict__["exclude_cloud_storage_buckets"] = exclude_cloud_storage_buckets
        __props__.__dict__["exclude_cloud_storage_locations"] = exclude_cloud_storage_locations
        __props__.__dict__["identity"] = identity
        __props__.__dict__["include_cloud_storage_buckets"] = include_cloud_storage_buckets
        __props__.__dict__["include_cloud_storage_locations"] = include_cloud_storage_locations
        __props__.__dict__["include_newly_created_buckets"] = include_newly_created_buckets
        __props__.__dict__["link_dataset"] = link_dataset
        __props__.__dict__["links"] = links
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_number"] = organization_number
        __props__.__dict__["organization_scope"] = organization_scope
        __props__.__dict__["project"] = project
        __props__.__dict__["retention_period_days"] = retention_period_days
        __props__.__dict__["source_folders"] = source_folders
        __props__.__dict__["source_projects"] = source_projects
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return InsightsDatasetConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The UTC time at which the DatasetConfig was created. This is auto-populated.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="datasetConfigId")
    def dataset_config_id(self) -> pulumi.Output[_builtins.str]:
        """
        The user-defined ID of the DatasetConfig
        """
        return pulumi.get(self, "dataset_config_id")

    @_builtins.property
    @pulumi.getter(name="datasetConfigState")
    def dataset_config_state(self) -> pulumi.Output[_builtins.str]:
        """
        State of the DatasetConfig.
        """
        return pulumi.get(self, "dataset_config_state")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional user-provided description for the dataset configuration with a maximum length of 256 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="excludeCloudStorageBuckets")
    def exclude_cloud_storage_buckets(self) -> pulumi.Output[Optional['outputs.InsightsDatasetConfigExcludeCloudStorageBuckets']]:
        """
        Defined the options for excluding cloud storage buckets for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "exclude_cloud_storage_buckets")

    @_builtins.property
    @pulumi.getter(name="excludeCloudStorageLocations")
    def exclude_cloud_storage_locations(self) -> pulumi.Output[Optional['outputs.InsightsDatasetConfigExcludeCloudStorageLocations']]:
        """
        Defines the options for excluding cloud storage locations for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "exclude_cloud_storage_locations")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output['outputs.InsightsDatasetConfigIdentity']:
        """
        Identity used by DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="includeCloudStorageBuckets")
    def include_cloud_storage_buckets(self) -> pulumi.Output[Optional['outputs.InsightsDatasetConfigIncludeCloudStorageBuckets']]:
        """
        Defines the options for including cloud storage buckets for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "include_cloud_storage_buckets")

    @_builtins.property
    @pulumi.getter(name="includeCloudStorageLocations")
    def include_cloud_storage_locations(self) -> pulumi.Output[Optional['outputs.InsightsDatasetConfigIncludeCloudStorageLocations']]:
        """
        Defines the options for including cloud storage locations for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "include_cloud_storage_locations")

    @_builtins.property
    @pulumi.getter(name="includeNewlyCreatedBuckets")
    def include_newly_created_buckets(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to true, the request includes all the newly created buckets in the dataset that meet the inclusion and exclusion rules.
        """
        return pulumi.get(self, "include_newly_created_buckets")

    @_builtins.property
    @pulumi.getter(name="linkDataset")
    def link_dataset(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "link_dataset")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output[Sequence['outputs.InsightsDatasetConfigLink']]:
        """
        Details of the linked DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the DatasetConfig.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The full canonical resource name of the DatasetConfig (e.g., projects/P/locations/L/datasetConfigs/ID).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationNumber")
    def organization_number(self) -> pulumi.Output[_builtins.str]:
        """
        Organization resource ID that the source projects should belong to.
        Projects that do not belong to the provided organization are not considered when creating the dataset.
        """
        return pulumi.get(self, "organization_number")

    @_builtins.property
    @pulumi.getter(name="organizationScope")
    def organization_scope(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Defines the options for providing a source organization for the DatasetConfig.
        """
        return pulumi.get(self, "organization_scope")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="retentionPeriodDays")
    def retention_period_days(self) -> pulumi.Output[_builtins.int]:
        """
        Number of days of history that must be retained.
        """
        return pulumi.get(self, "retention_period_days")

    @_builtins.property
    @pulumi.getter(name="sourceFolders")
    def source_folders(self) -> pulumi.Output[Optional['outputs.InsightsDatasetConfigSourceFolders']]:
        """
        Defines the options for providing source folders for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "source_folders")

    @_builtins.property
    @pulumi.getter(name="sourceProjects")
    def source_projects(self) -> pulumi.Output[Optional['outputs.InsightsDatasetConfigSourceProjects']]:
        """
        Defines the options for providing source projects for the DatasetConfig.
        Structure is documented below.
        """
        return pulumi.get(self, "source_projects")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        System generated unique identifier for the resource.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The UTC time at which the DatasetConfig was updated. This is auto-populated.
        """
        return pulumi.get(self, "update_time")

