# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetTagKeyResult',
    'AwaitableGetTagKeyResult',
    'get_tag_key',
    'get_tag_key_output',
]

@pulumi.output_type
class GetTagKeyResult:
    """
    A collection of values returned by getTagKey.
    """
    def __init__(__self__, create_time=None, description=None, id=None, name=None, namespaced_name=None, parent=None, short_name=None, update_time=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespaced_name and not isinstance(namespaced_name, str):
            raise TypeError("Expected argument 'namespaced_name' to be a str")
        pulumi.set(__self__, "namespaced_name", namespaced_name)
        if parent and not isinstance(parent, str):
            raise TypeError("Expected argument 'parent' to be a str")
        pulumi.set(__self__, "parent", parent)
        if short_name and not isinstance(short_name, str):
            raise TypeError("Expected argument 'short_name' to be a str")
        pulumi.set(__self__, "short_name", short_name)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Creation time.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        an identifier for the resource with format `tagKeys/{{name}}`
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The generated numeric id for the TagKey.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namespacedName")
    def namespaced_name(self) -> _builtins.str:
        """
        Namespaced name of the TagKey which is in the format `{parentNamespace}/{shortName}`.
        """
        return pulumi.get(self, "namespaced_name")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> _builtins.str:
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter(name="shortName")
    def short_name(self) -> _builtins.str:
        return pulumi.get(self, "short_name")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        Update time.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")


class AwaitableGetTagKeyResult(GetTagKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTagKeyResult(
            create_time=self.create_time,
            description=self.description,
            id=self.id,
            name=self.name,
            namespaced_name=self.namespaced_name,
            parent=self.parent,
            short_name=self.short_name,
            update_time=self.update_time)


def get_tag_key(parent: Optional[_builtins.str] = None,
                short_name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTagKeyResult:
    """
    Get a tag key by org or project `parent` and `short_name`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    environment_tag_key = gcp.tags.get_tag_key(parent="organizations/12345",
        short_name="environment")
    ```
    ```python
    import pulumi
    import pulumi_gcp as gcp

    environment_tag_key = gcp.tags.get_tag_key(parent="projects/abc",
        short_name="environment")
    ```


    :param _builtins.str parent: The resource name of the parent organization or project. It can be in format `organizations/{org_id}` or `projects/{project_id_or_number}`.
    :param _builtins.str short_name: The tag key's short_name.
    """
    __args__ = dict()
    __args__['parent'] = parent
    __args__['shortName'] = short_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:tags/getTagKey:getTagKey', __args__, opts=opts, typ=GetTagKeyResult).value

    return AwaitableGetTagKeyResult(
        create_time=pulumi.get(__ret__, 'create_time'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        namespaced_name=pulumi.get(__ret__, 'namespaced_name'),
        parent=pulumi.get(__ret__, 'parent'),
        short_name=pulumi.get(__ret__, 'short_name'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_tag_key_output(parent: Optional[pulumi.Input[_builtins.str]] = None,
                       short_name: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTagKeyResult]:
    """
    Get a tag key by org or project `parent` and `short_name`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    environment_tag_key = gcp.tags.get_tag_key(parent="organizations/12345",
        short_name="environment")
    ```
    ```python
    import pulumi
    import pulumi_gcp as gcp

    environment_tag_key = gcp.tags.get_tag_key(parent="projects/abc",
        short_name="environment")
    ```


    :param _builtins.str parent: The resource name of the parent organization or project. It can be in format `organizations/{org_id}` or `projects/{project_id_or_number}`.
    :param _builtins.str short_name: The tag key's short_name.
    """
    __args__ = dict()
    __args__['parent'] = parent
    __args__['shortName'] = short_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:tags/getTagKey:getTagKey', __args__, opts=opts, typ=GetTagKeyResult)
    return __ret__.apply(lambda __response__: GetTagKeyResult(
        create_time=pulumi.get(__response__, 'create_time'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        namespaced_name=pulumi.get(__response__, 'namespaced_name'),
        parent=pulumi.get(__response__, 'parent'),
        short_name=pulumi.get(__response__, 'short_name'),
        update_time=pulumi.get(__response__, 'update_time')))
