# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AiFeatureOnlineStoreFeatureviewArgs', 'AiFeatureOnlineStoreFeatureview']

@pulumi.input_type
class AiFeatureOnlineStoreFeatureviewArgs:
    def __init__(__self__, *,
                 feature_online_store: pulumi.Input[_builtins.str],
                 big_query_source: Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewBigQuerySourceArgs']] = None,
                 feature_registry_source: Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_config: Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewSyncConfigArgs']] = None,
                 vector_search_config: Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgs']] = None):
        """
        The set of arguments for constructing a AiFeatureOnlineStoreFeatureview resource.
        :param pulumi.Input[_builtins.str] feature_online_store: The name of the FeatureOnlineStore to use for the featureview.
        :param pulumi.Input['AiFeatureOnlineStoreFeatureviewBigQuerySourceArgs'] big_query_source: Configures how data is supposed to be extracted from a BigQuery source to be loaded onto the FeatureOnlineStore.
               Structure is documented below.
        :param pulumi.Input['AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgs'] feature_registry_source: Configures the features from a Feature Registry source that need to be loaded onto the FeatureOnlineStore.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to this FeatureView.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Name of the FeatureView. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region for the resource. It should be the same as the featureonlinestore region.
        :param pulumi.Input['AiFeatureOnlineStoreFeatureviewSyncConfigArgs'] sync_config: Configures when data is to be synced/updated for this FeatureView. At the end of the sync the latest featureValues for each entityId of this FeatureView are made ready for online serving.
               Structure is documented below.
        :param pulumi.Input['AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgs'] vector_search_config: Configuration for vector search. It contains the required configurations to create an index from source data, so that approximate nearest neighbor (a.k.a ANN) algorithms search can be performed during online serving.
               Structure is documented below.
        """
        pulumi.set(__self__, "feature_online_store", feature_online_store)
        if big_query_source is not None:
            pulumi.set(__self__, "big_query_source", big_query_source)
        if feature_registry_source is not None:
            pulumi.set(__self__, "feature_registry_source", feature_registry_source)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sync_config is not None:
            pulumi.set(__self__, "sync_config", sync_config)
        if vector_search_config is not None:
            pulumi.set(__self__, "vector_search_config", vector_search_config)

    @_builtins.property
    @pulumi.getter(name="featureOnlineStore")
    def feature_online_store(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the FeatureOnlineStore to use for the featureview.
        """
        return pulumi.get(self, "feature_online_store")

    @feature_online_store.setter
    def feature_online_store(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "feature_online_store", value)

    @_builtins.property
    @pulumi.getter(name="bigQuerySource")
    def big_query_source(self) -> Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewBigQuerySourceArgs']]:
        """
        Configures how data is supposed to be extracted from a BigQuery source to be loaded onto the FeatureOnlineStore.
        Structure is documented below.
        """
        return pulumi.get(self, "big_query_source")

    @big_query_source.setter
    def big_query_source(self, value: Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewBigQuerySourceArgs']]):
        pulumi.set(self, "big_query_source", value)

    @_builtins.property
    @pulumi.getter(name="featureRegistrySource")
    def feature_registry_source(self) -> Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgs']]:
        """
        Configures the features from a Feature Registry source that need to be loaded onto the FeatureOnlineStore.
        Structure is documented below.
        """
        return pulumi.get(self, "feature_registry_source")

    @feature_registry_source.setter
    def feature_registry_source(self, value: Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgs']]):
        pulumi.set(self, "feature_registry_source", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs to assign to this FeatureView.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the FeatureView. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region for the resource. It should be the same as the featureonlinestore region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="syncConfig")
    def sync_config(self) -> Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewSyncConfigArgs']]:
        """
        Configures when data is to be synced/updated for this FeatureView. At the end of the sync the latest featureValues for each entityId of this FeatureView are made ready for online serving.
        Structure is documented below.
        """
        return pulumi.get(self, "sync_config")

    @sync_config.setter
    def sync_config(self, value: Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewSyncConfigArgs']]):
        pulumi.set(self, "sync_config", value)

    @_builtins.property
    @pulumi.getter(name="vectorSearchConfig")
    def vector_search_config(self) -> Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgs']]:
        """
        Configuration for vector search. It contains the required configurations to create an index from source data, so that approximate nearest neighbor (a.k.a ANN) algorithms search can be performed during online serving.
        Structure is documented below.
        """
        return pulumi.get(self, "vector_search_config")

    @vector_search_config.setter
    def vector_search_config(self, value: Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgs']]):
        pulumi.set(self, "vector_search_config", value)


@pulumi.input_type
class _AiFeatureOnlineStoreFeatureviewState:
    def __init__(__self__, *,
                 big_query_source: Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewBigQuerySourceArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 feature_online_store: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_registry_source: Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_config: Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewSyncConfigArgs']] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 vector_search_config: Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgs']] = None):
        """
        Input properties used for looking up and filtering AiFeatureOnlineStoreFeatureview resources.
        :param pulumi.Input['AiFeatureOnlineStoreFeatureviewBigQuerySourceArgs'] big_query_source: Configures how data is supposed to be extracted from a BigQuery source to be loaded onto the FeatureOnlineStore.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The timestamp of when the featureOnlinestore was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] feature_online_store: The name of the FeatureOnlineStore to use for the featureview.
        :param pulumi.Input['AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgs'] feature_registry_source: Configures the features from a Feature Registry source that need to be loaded onto the FeatureOnlineStore.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to this FeatureView.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Name of the FeatureView. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] region: The region for the resource. It should be the same as the featureonlinestore region.
        :param pulumi.Input['AiFeatureOnlineStoreFeatureviewSyncConfigArgs'] sync_config: Configures when data is to be synced/updated for this FeatureView. At the end of the sync the latest featureValues for each entityId of this FeatureView are made ready for online serving.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: The timestamp of when the featureOnlinestore was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input['AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgs'] vector_search_config: Configuration for vector search. It contains the required configurations to create an index from source data, so that approximate nearest neighbor (a.k.a ANN) algorithms search can be performed during online serving.
               Structure is documented below.
        """
        if big_query_source is not None:
            pulumi.set(__self__, "big_query_source", big_query_source)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if feature_online_store is not None:
            pulumi.set(__self__, "feature_online_store", feature_online_store)
        if feature_registry_source is not None:
            pulumi.set(__self__, "feature_registry_source", feature_registry_source)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sync_config is not None:
            pulumi.set(__self__, "sync_config", sync_config)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vector_search_config is not None:
            pulumi.set(__self__, "vector_search_config", vector_search_config)

    @_builtins.property
    @pulumi.getter(name="bigQuerySource")
    def big_query_source(self) -> Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewBigQuerySourceArgs']]:
        """
        Configures how data is supposed to be extracted from a BigQuery source to be loaded onto the FeatureOnlineStore.
        Structure is documented below.
        """
        return pulumi.get(self, "big_query_source")

    @big_query_source.setter
    def big_query_source(self, value: Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewBigQuerySourceArgs']]):
        pulumi.set(self, "big_query_source", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of when the featureOnlinestore was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="featureOnlineStore")
    def feature_online_store(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the FeatureOnlineStore to use for the featureview.
        """
        return pulumi.get(self, "feature_online_store")

    @feature_online_store.setter
    def feature_online_store(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feature_online_store", value)

    @_builtins.property
    @pulumi.getter(name="featureRegistrySource")
    def feature_registry_source(self) -> Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgs']]:
        """
        Configures the features from a Feature Registry source that need to be loaded onto the FeatureOnlineStore.
        Structure is documented below.
        """
        return pulumi.get(self, "feature_registry_source")

    @feature_registry_source.setter
    def feature_registry_source(self, value: Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgs']]):
        pulumi.set(self, "feature_registry_source", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs to assign to this FeatureView.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the FeatureView. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region for the resource. It should be the same as the featureonlinestore region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="syncConfig")
    def sync_config(self) -> Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewSyncConfigArgs']]:
        """
        Configures when data is to be synced/updated for this FeatureView. At the end of the sync the latest featureValues for each entityId of this FeatureView are made ready for online serving.
        Structure is documented below.
        """
        return pulumi.get(self, "sync_config")

    @sync_config.setter
    def sync_config(self, value: Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewSyncConfigArgs']]):
        pulumi.set(self, "sync_config", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of when the featureOnlinestore was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="vectorSearchConfig")
    def vector_search_config(self) -> Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgs']]:
        """
        Configuration for vector search. It contains the required configurations to create an index from source data, so that approximate nearest neighbor (a.k.a ANN) algorithms search can be performed during online serving.
        Structure is documented below.
        """
        return pulumi.get(self, "vector_search_config")

    @vector_search_config.setter
    def vector_search_config(self, value: Optional[pulumi.Input['AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgs']]):
        pulumi.set(self, "vector_search_config", value)


@pulumi.type_token("gcp:vertex/aiFeatureOnlineStoreFeatureview:AiFeatureOnlineStoreFeatureview")
class AiFeatureOnlineStoreFeatureview(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 big_query_source: Optional[pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewBigQuerySourceArgs', 'AiFeatureOnlineStoreFeatureviewBigQuerySourceArgsDict']]] = None,
                 feature_online_store: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_registry_source: Optional[pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgs', 'AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_config: Optional[pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewSyncConfigArgs', 'AiFeatureOnlineStoreFeatureviewSyncConfigArgsDict']]] = None,
                 vector_search_config: Optional[pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgs', 'AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgsDict']]] = None,
                 __props__=None):
        """
        FeatureView is representation of values that the FeatureOnlineStore will serve based on its syncConfig.

        To get more information about FeatureOnlineStoreFeatureview, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.featureOnlineStores.featureViews)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vertex-ai/docs)

        ## Example Usage

        ### Vertex Ai Featureonlinestore Featureview

        ```python
        import pulumi
        import pulumi_gcp as gcp

        featureonlinestore = gcp.vertex.AiFeatureOnlineStore("featureonlinestore",
            name="example_feature_view",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            bigtable={
                "auto_scaling": {
                    "min_node_count": 1,
                    "max_node_count": 2,
                    "cpu_utilization_target": 80,
                },
            })
        tf_test_dataset = gcp.bigquery.Dataset("tf-test-dataset",
            dataset_id="example_feature_view",
            friendly_name="test",
            description="This is a test description",
            location="US")
        tf_test_table = gcp.bigquery.Table("tf-test-table",
            deletion_protection=False,
            dataset_id=tf_test_dataset.dataset_id,
            table_id="example_feature_view",
            schema=\"\"\"  [
          {
            "name": "entity_id",
            "mode": "NULLABLE",
            "type": "STRING",
            "description": "Test default entity_id"
          },
            {
            "name": "test_entity_column",
            "mode": "NULLABLE",
            "type": "STRING",
            "description": "test secondary entity column"
          },
          {
            "name": "feature_timestamp",
            "mode": "NULLABLE",
            "type": "TIMESTAMP",
            "description": "Default timestamp value"
          }
        ]
        \"\"\")
        featureview = gcp.vertex.AiFeatureOnlineStoreFeatureview("featureview",
            name="example_feature_view",
            region="us-central1",
            feature_online_store=featureonlinestore.name,
            sync_config={
                "cron": "0 0 * * *",
            },
            big_query_source={
                "uri": pulumi.Output.all(
                    project=tf_test_table.project,
                    dataset_id=tf_test_table.dataset_id,
                    table_id=tf_test_table.table_id
        ).apply(lambda resolved_outputs: f"bq://{resolved_outputs['project']}.{resolved_outputs['dataset_id']}.{resolved_outputs['table_id']}")
        ,
                "entity_id_columns": ["test_entity_column"],
            })
        project = gcp.organizations.get_project()
        ```
        ### Vertex Ai Featureonlinestore Featureview Feature Registry

        ```python
        import pulumi
        import pulumi_gcp as gcp

        featureonlinestore = gcp.vertex.AiFeatureOnlineStore("featureonlinestore",
            name="example_feature_view_feature_registry",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            bigtable={
                "auto_scaling": {
                    "min_node_count": 1,
                    "max_node_count": 2,
                    "cpu_utilization_target": 80,
                },
            })
        sample_dataset = gcp.bigquery.Dataset("sample_dataset",
            dataset_id="example_feature_view_feature_registry",
            friendly_name="test",
            description="This is a test description",
            location="US")
        sample_table = gcp.bigquery.Table("sample_table",
            deletion_protection=False,
            dataset_id=sample_dataset.dataset_id,
            table_id="example_feature_view_feature_registry",
            schema=\"\"\"[
            {
                "name": "feature_id",
                "type": "STRING",
                "mode": "NULLABLE"
            },
            {
                "name": "example_feature_view_feature_registry",
                "type": "STRING",
                "mode": "NULLABLE"
            },
            {
                "name": "feature_timestamp",
                "type": "TIMESTAMP",
                "mode": "NULLABLE"
            }
        ]
        \"\"\")
        sample_feature_group = gcp.vertex.AiFeatureGroup("sample_feature_group",
            name="example_feature_view_feature_registry",
            description="A sample feature group",
            region="us-central1",
            labels={
                "label-one": "value-one",
            },
            big_query={
                "big_query_source": {
                    "input_uri": pulumi.Output.all(
                        project=sample_table.project,
                        dataset_id=sample_table.dataset_id,
                        table_id=sample_table.table_id
        ).apply(lambda resolved_outputs: f"bq://{resolved_outputs['project']}.{resolved_outputs['dataset_id']}.{resolved_outputs['table_id']}")
        ,
                },
                "entity_id_columns": ["feature_id"],
            })
        sample_feature = gcp.vertex.AiFeatureGroupFeature("sample_feature",
            name="example_feature_view_feature_registry",
            region="us-central1",
            feature_group=sample_feature_group.name,
            description="A sample feature",
            labels={
                "label-one": "value-one",
            })
        featureview_featureregistry = gcp.vertex.AiFeatureOnlineStoreFeatureview("featureview_featureregistry",
            name="example_feature_view_feature_registry",
            region="us-central1",
            feature_online_store=featureonlinestore.name,
            sync_config={
                "cron": "0 0 * * *",
            },
            feature_registry_source={
                "feature_groups": [{
                    "feature_group_id": sample_feature_group.name,
                    "feature_ids": [sample_feature.name],
                }],
            })
        ```
        ### Vertex Ai Featureonlinestore Featureview Cross Project

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        test_project = gcp.organizations.get_project()
        project = gcp.organizations.Project("project",
            project_id="tf-test_92130",
            name="tf-test_16199",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        wait60_seconds = time.index.Sleep("wait_60_seconds", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[project]))
        vertexai = gcp.projects.Service("vertexai",
            service="aiplatform.googleapis.com",
            project=project.project_id,
            disable_on_destroy=False,
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        featureonlinestore = gcp.vertex.AiFeatureOnlineStore("featureonlinestore",
            name="example_cross_project_featureview",
            project=project.project_id,
            labels={
                "foo": "bar",
            },
            region="us-central1",
            bigtable={
                "auto_scaling": {
                    "min_node_count": 1,
                    "max_node_count": 2,
                    "cpu_utilization_target": 80,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[vertexai]))
        sample_dataset = gcp.bigquery.Dataset("sample_dataset",
            dataset_id="example_cross_project_featureview",
            friendly_name="test",
            description="This is a test description",
            location="US")
        viewer = gcp.bigquery.DatasetIamMember("viewer",
            project=test_project.project_id,
            dataset_id=sample_dataset.dataset_id,
            role="roles/bigquery.dataViewer",
            member=project.number.apply(lambda number: f"serviceAccount:service-{number}@gcp-sa-aiplatform.iam.gserviceaccount.com"),
            opts = pulumi.ResourceOptions(depends_on=[featureonlinestore]))
        wait30_seconds = time.index.Sleep("wait_30_seconds", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[viewer]))
        sample_table = gcp.bigquery.Table("sample_table",
            deletion_protection=False,
            dataset_id=sample_dataset.dataset_id,
            table_id="example_cross_project_featureview",
            schema=\"\"\"[
            {
                "name": "feature_id",
                "type": "STRING",
                "mode": "NULLABLE"
            },
            {
                "name": "example_cross_project_featureview",
                "type": "STRING",
                "mode": "NULLABLE"
            },
            {
                "name": "feature_timestamp",
                "type": "TIMESTAMP",
                "mode": "NULLABLE"
            }
        ]
        \"\"\")
        sample_feature_group = gcp.vertex.AiFeatureGroup("sample_feature_group",
            name="example_cross_project_featureview",
            description="A sample feature group",
            region="us-central1",
            labels={
                "label-one": "value-one",
            },
            big_query={
                "big_query_source": {
                    "input_uri": pulumi.Output.all(
                        project=sample_table.project,
                        dataset_id=sample_table.dataset_id,
                        table_id=sample_table.table_id
        ).apply(lambda resolved_outputs: f"bq://{resolved_outputs['project']}.{resolved_outputs['dataset_id']}.{resolved_outputs['table_id']}")
        ,
                },
                "entity_id_columns": ["feature_id"],
            })
        sample_feature = gcp.vertex.AiFeatureGroupFeature("sample_feature",
            name="example_cross_project_featureview",
            region="us-central1",
            feature_group=sample_feature_group.name,
            description="A sample feature",
            labels={
                "label-one": "value-one",
            })
        cross_project_featureview = gcp.vertex.AiFeatureOnlineStoreFeatureview("cross_project_featureview",
            name="example_cross_project_featureview",
            project=project.project_id,
            region="us-central1",
            feature_online_store=featureonlinestore.name,
            sync_config={
                "cron": "0 0 * * *",
            },
            feature_registry_source={
                "feature_groups": [{
                    "feature_group_id": sample_feature_group.name,
                    "feature_ids": [sample_feature.name],
                }],
                "project_number": test_project.number,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    vertexai,
                    wait30_seconds,
                ]))
        ```
        ### Vertex Ai Featureonlinestore Featureview With Vector Search

        ```python
        import pulumi
        import pulumi_gcp as gcp

        featureonlinestore = gcp.vertex.AiFeatureOnlineStore("featureonlinestore",
            name="example_feature_view_vector_search",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            optimized={},
            embedding_management={
                "enabled": True,
            })
        tf_test_dataset = gcp.bigquery.Dataset("tf-test-dataset",
            dataset_id="example_feature_view_vector_search",
            friendly_name="test",
            description="This is a test description",
            location="US")
        tf_test_table = gcp.bigquery.Table("tf-test-table",
            deletion_protection=False,
            dataset_id=tf_test_dataset.dataset_id,
            table_id="example_feature_view_vector_search",
            schema=\"\"\"[
        {
          "name": "test_primary_id",
          "mode": "NULLABLE",
          "type": "STRING",
          "description": "primary test id"
        },
        {
          "name": "embedding",
          "mode": "REPEATED",
          "type": "FLOAT",
          "description": "embedding column for primary_id column"
        },
        {
          "name": "country",
          "mode": "NULLABLE",
          "type": "STRING",
          "description": "country"
        },
        {
          "name": "test_crowding_column",
          "mode": "NULLABLE",
          "type": "INTEGER",
          "description": "test crowding column"
        },
        {
          "name": "entity_id",
          "mode": "NULLABLE",
          "type": "STRING",
          "description": "Test default entity_id"
        },
        {
          "name": "test_entity_column",
          "mode": "NULLABLE",
          "type": "STRING",
          "description": "test secondary entity column"
        },
        {
          "name": "feature_timestamp",
          "mode": "NULLABLE",
          "type": "TIMESTAMP",
          "description": "Default timestamp value"
        }
        ]
        \"\"\")
        featureview_vector_search = gcp.vertex.AiFeatureOnlineStoreFeatureview("featureview_vector_search",
            name="example_feature_view_vector_search",
            region="us-central1",
            feature_online_store=featureonlinestore.name,
            sync_config={
                "cron": "0 0 * * *",
            },
            big_query_source={
                "uri": pulumi.Output.all(
                    project=tf_test_table.project,
                    dataset_id=tf_test_table.dataset_id,
                    table_id=tf_test_table.table_id
        ).apply(lambda resolved_outputs: f"bq://{resolved_outputs['project']}.{resolved_outputs['dataset_id']}.{resolved_outputs['table_id']}")
        ,
                "entity_id_columns": ["test_entity_column"],
            },
            vector_search_config={
                "embedding_column": "embedding",
                "filter_columns": ["country"],
                "crowding_column": "test_crowding_column",
                "distance_measure_type": "DOT_PRODUCT_DISTANCE",
                "tree_ah_config": {
                    "leaf_node_embedding_count": "1000",
                },
                "embedding_dimension": 2,
            })
        project = gcp.organizations.get_project()
        ```

        ## Import

        FeatureOnlineStoreFeatureview can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/featureOnlineStores/{{feature_online_store}}/featureViews/{{name}}`

        * `{{project}}/{{region}}/{{feature_online_store}}/{{name}}`

        * `{{region}}/{{feature_online_store}}/{{name}}`

        * `{{feature_online_store}}/{{name}}`

        When using the `pulumi import` command, FeatureOnlineStoreFeatureview can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiFeatureOnlineStoreFeatureview:AiFeatureOnlineStoreFeatureview default projects/{{project}}/locations/{{region}}/featureOnlineStores/{{feature_online_store}}/featureViews/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureOnlineStoreFeatureview:AiFeatureOnlineStoreFeatureview default {{project}}/{{region}}/{{feature_online_store}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureOnlineStoreFeatureview:AiFeatureOnlineStoreFeatureview default {{region}}/{{feature_online_store}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureOnlineStoreFeatureview:AiFeatureOnlineStoreFeatureview default {{feature_online_store}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewBigQuerySourceArgs', 'AiFeatureOnlineStoreFeatureviewBigQuerySourceArgsDict']] big_query_source: Configures how data is supposed to be extracted from a BigQuery source to be loaded onto the FeatureOnlineStore.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] feature_online_store: The name of the FeatureOnlineStore to use for the featureview.
        :param pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgs', 'AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgsDict']] feature_registry_source: Configures the features from a Feature Registry source that need to be loaded onto the FeatureOnlineStore.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to this FeatureView.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Name of the FeatureView. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region for the resource. It should be the same as the featureonlinestore region.
        :param pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewSyncConfigArgs', 'AiFeatureOnlineStoreFeatureviewSyncConfigArgsDict']] sync_config: Configures when data is to be synced/updated for this FeatureView. At the end of the sync the latest featureValues for each entityId of this FeatureView are made ready for online serving.
               Structure is documented below.
        :param pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgs', 'AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgsDict']] vector_search_config: Configuration for vector search. It contains the required configurations to create an index from source data, so that approximate nearest neighbor (a.k.a ANN) algorithms search can be performed during online serving.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AiFeatureOnlineStoreFeatureviewArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        FeatureView is representation of values that the FeatureOnlineStore will serve based on its syncConfig.

        To get more information about FeatureOnlineStoreFeatureview, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.featureOnlineStores.featureViews)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vertex-ai/docs)

        ## Example Usage

        ### Vertex Ai Featureonlinestore Featureview

        ```python
        import pulumi
        import pulumi_gcp as gcp

        featureonlinestore = gcp.vertex.AiFeatureOnlineStore("featureonlinestore",
            name="example_feature_view",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            bigtable={
                "auto_scaling": {
                    "min_node_count": 1,
                    "max_node_count": 2,
                    "cpu_utilization_target": 80,
                },
            })
        tf_test_dataset = gcp.bigquery.Dataset("tf-test-dataset",
            dataset_id="example_feature_view",
            friendly_name="test",
            description="This is a test description",
            location="US")
        tf_test_table = gcp.bigquery.Table("tf-test-table",
            deletion_protection=False,
            dataset_id=tf_test_dataset.dataset_id,
            table_id="example_feature_view",
            schema=\"\"\"  [
          {
            "name": "entity_id",
            "mode": "NULLABLE",
            "type": "STRING",
            "description": "Test default entity_id"
          },
            {
            "name": "test_entity_column",
            "mode": "NULLABLE",
            "type": "STRING",
            "description": "test secondary entity column"
          },
          {
            "name": "feature_timestamp",
            "mode": "NULLABLE",
            "type": "TIMESTAMP",
            "description": "Default timestamp value"
          }
        ]
        \"\"\")
        featureview = gcp.vertex.AiFeatureOnlineStoreFeatureview("featureview",
            name="example_feature_view",
            region="us-central1",
            feature_online_store=featureonlinestore.name,
            sync_config={
                "cron": "0 0 * * *",
            },
            big_query_source={
                "uri": pulumi.Output.all(
                    project=tf_test_table.project,
                    dataset_id=tf_test_table.dataset_id,
                    table_id=tf_test_table.table_id
        ).apply(lambda resolved_outputs: f"bq://{resolved_outputs['project']}.{resolved_outputs['dataset_id']}.{resolved_outputs['table_id']}")
        ,
                "entity_id_columns": ["test_entity_column"],
            })
        project = gcp.organizations.get_project()
        ```
        ### Vertex Ai Featureonlinestore Featureview Feature Registry

        ```python
        import pulumi
        import pulumi_gcp as gcp

        featureonlinestore = gcp.vertex.AiFeatureOnlineStore("featureonlinestore",
            name="example_feature_view_feature_registry",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            bigtable={
                "auto_scaling": {
                    "min_node_count": 1,
                    "max_node_count": 2,
                    "cpu_utilization_target": 80,
                },
            })
        sample_dataset = gcp.bigquery.Dataset("sample_dataset",
            dataset_id="example_feature_view_feature_registry",
            friendly_name="test",
            description="This is a test description",
            location="US")
        sample_table = gcp.bigquery.Table("sample_table",
            deletion_protection=False,
            dataset_id=sample_dataset.dataset_id,
            table_id="example_feature_view_feature_registry",
            schema=\"\"\"[
            {
                "name": "feature_id",
                "type": "STRING",
                "mode": "NULLABLE"
            },
            {
                "name": "example_feature_view_feature_registry",
                "type": "STRING",
                "mode": "NULLABLE"
            },
            {
                "name": "feature_timestamp",
                "type": "TIMESTAMP",
                "mode": "NULLABLE"
            }
        ]
        \"\"\")
        sample_feature_group = gcp.vertex.AiFeatureGroup("sample_feature_group",
            name="example_feature_view_feature_registry",
            description="A sample feature group",
            region="us-central1",
            labels={
                "label-one": "value-one",
            },
            big_query={
                "big_query_source": {
                    "input_uri": pulumi.Output.all(
                        project=sample_table.project,
                        dataset_id=sample_table.dataset_id,
                        table_id=sample_table.table_id
        ).apply(lambda resolved_outputs: f"bq://{resolved_outputs['project']}.{resolved_outputs['dataset_id']}.{resolved_outputs['table_id']}")
        ,
                },
                "entity_id_columns": ["feature_id"],
            })
        sample_feature = gcp.vertex.AiFeatureGroupFeature("sample_feature",
            name="example_feature_view_feature_registry",
            region="us-central1",
            feature_group=sample_feature_group.name,
            description="A sample feature",
            labels={
                "label-one": "value-one",
            })
        featureview_featureregistry = gcp.vertex.AiFeatureOnlineStoreFeatureview("featureview_featureregistry",
            name="example_feature_view_feature_registry",
            region="us-central1",
            feature_online_store=featureonlinestore.name,
            sync_config={
                "cron": "0 0 * * *",
            },
            feature_registry_source={
                "feature_groups": [{
                    "feature_group_id": sample_feature_group.name,
                    "feature_ids": [sample_feature.name],
                }],
            })
        ```
        ### Vertex Ai Featureonlinestore Featureview Cross Project

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_time as time

        test_project = gcp.organizations.get_project()
        project = gcp.organizations.Project("project",
            project_id="tf-test_92130",
            name="tf-test_16199",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000",
            deletion_policy="DELETE")
        wait60_seconds = time.index.Sleep("wait_60_seconds", create_duration=60s,
        opts = pulumi.ResourceOptions(depends_on=[project]))
        vertexai = gcp.projects.Service("vertexai",
            service="aiplatform.googleapis.com",
            project=project.project_id,
            disable_on_destroy=False,
            opts = pulumi.ResourceOptions(depends_on=[wait60_seconds]))
        featureonlinestore = gcp.vertex.AiFeatureOnlineStore("featureonlinestore",
            name="example_cross_project_featureview",
            project=project.project_id,
            labels={
                "foo": "bar",
            },
            region="us-central1",
            bigtable={
                "auto_scaling": {
                    "min_node_count": 1,
                    "max_node_count": 2,
                    "cpu_utilization_target": 80,
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[vertexai]))
        sample_dataset = gcp.bigquery.Dataset("sample_dataset",
            dataset_id="example_cross_project_featureview",
            friendly_name="test",
            description="This is a test description",
            location="US")
        viewer = gcp.bigquery.DatasetIamMember("viewer",
            project=test_project.project_id,
            dataset_id=sample_dataset.dataset_id,
            role="roles/bigquery.dataViewer",
            member=project.number.apply(lambda number: f"serviceAccount:service-{number}@gcp-sa-aiplatform.iam.gserviceaccount.com"),
            opts = pulumi.ResourceOptions(depends_on=[featureonlinestore]))
        wait30_seconds = time.index.Sleep("wait_30_seconds", create_duration=30s,
        opts = pulumi.ResourceOptions(depends_on=[viewer]))
        sample_table = gcp.bigquery.Table("sample_table",
            deletion_protection=False,
            dataset_id=sample_dataset.dataset_id,
            table_id="example_cross_project_featureview",
            schema=\"\"\"[
            {
                "name": "feature_id",
                "type": "STRING",
                "mode": "NULLABLE"
            },
            {
                "name": "example_cross_project_featureview",
                "type": "STRING",
                "mode": "NULLABLE"
            },
            {
                "name": "feature_timestamp",
                "type": "TIMESTAMP",
                "mode": "NULLABLE"
            }
        ]
        \"\"\")
        sample_feature_group = gcp.vertex.AiFeatureGroup("sample_feature_group",
            name="example_cross_project_featureview",
            description="A sample feature group",
            region="us-central1",
            labels={
                "label-one": "value-one",
            },
            big_query={
                "big_query_source": {
                    "input_uri": pulumi.Output.all(
                        project=sample_table.project,
                        dataset_id=sample_table.dataset_id,
                        table_id=sample_table.table_id
        ).apply(lambda resolved_outputs: f"bq://{resolved_outputs['project']}.{resolved_outputs['dataset_id']}.{resolved_outputs['table_id']}")
        ,
                },
                "entity_id_columns": ["feature_id"],
            })
        sample_feature = gcp.vertex.AiFeatureGroupFeature("sample_feature",
            name="example_cross_project_featureview",
            region="us-central1",
            feature_group=sample_feature_group.name,
            description="A sample feature",
            labels={
                "label-one": "value-one",
            })
        cross_project_featureview = gcp.vertex.AiFeatureOnlineStoreFeatureview("cross_project_featureview",
            name="example_cross_project_featureview",
            project=project.project_id,
            region="us-central1",
            feature_online_store=featureonlinestore.name,
            sync_config={
                "cron": "0 0 * * *",
            },
            feature_registry_source={
                "feature_groups": [{
                    "feature_group_id": sample_feature_group.name,
                    "feature_ids": [sample_feature.name],
                }],
                "project_number": test_project.number,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    vertexai,
                    wait30_seconds,
                ]))
        ```
        ### Vertex Ai Featureonlinestore Featureview With Vector Search

        ```python
        import pulumi
        import pulumi_gcp as gcp

        featureonlinestore = gcp.vertex.AiFeatureOnlineStore("featureonlinestore",
            name="example_feature_view_vector_search",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            optimized={},
            embedding_management={
                "enabled": True,
            })
        tf_test_dataset = gcp.bigquery.Dataset("tf-test-dataset",
            dataset_id="example_feature_view_vector_search",
            friendly_name="test",
            description="This is a test description",
            location="US")
        tf_test_table = gcp.bigquery.Table("tf-test-table",
            deletion_protection=False,
            dataset_id=tf_test_dataset.dataset_id,
            table_id="example_feature_view_vector_search",
            schema=\"\"\"[
        {
          "name": "test_primary_id",
          "mode": "NULLABLE",
          "type": "STRING",
          "description": "primary test id"
        },
        {
          "name": "embedding",
          "mode": "REPEATED",
          "type": "FLOAT",
          "description": "embedding column for primary_id column"
        },
        {
          "name": "country",
          "mode": "NULLABLE",
          "type": "STRING",
          "description": "country"
        },
        {
          "name": "test_crowding_column",
          "mode": "NULLABLE",
          "type": "INTEGER",
          "description": "test crowding column"
        },
        {
          "name": "entity_id",
          "mode": "NULLABLE",
          "type": "STRING",
          "description": "Test default entity_id"
        },
        {
          "name": "test_entity_column",
          "mode": "NULLABLE",
          "type": "STRING",
          "description": "test secondary entity column"
        },
        {
          "name": "feature_timestamp",
          "mode": "NULLABLE",
          "type": "TIMESTAMP",
          "description": "Default timestamp value"
        }
        ]
        \"\"\")
        featureview_vector_search = gcp.vertex.AiFeatureOnlineStoreFeatureview("featureview_vector_search",
            name="example_feature_view_vector_search",
            region="us-central1",
            feature_online_store=featureonlinestore.name,
            sync_config={
                "cron": "0 0 * * *",
            },
            big_query_source={
                "uri": pulumi.Output.all(
                    project=tf_test_table.project,
                    dataset_id=tf_test_table.dataset_id,
                    table_id=tf_test_table.table_id
        ).apply(lambda resolved_outputs: f"bq://{resolved_outputs['project']}.{resolved_outputs['dataset_id']}.{resolved_outputs['table_id']}")
        ,
                "entity_id_columns": ["test_entity_column"],
            },
            vector_search_config={
                "embedding_column": "embedding",
                "filter_columns": ["country"],
                "crowding_column": "test_crowding_column",
                "distance_measure_type": "DOT_PRODUCT_DISTANCE",
                "tree_ah_config": {
                    "leaf_node_embedding_count": "1000",
                },
                "embedding_dimension": 2,
            })
        project = gcp.organizations.get_project()
        ```

        ## Import

        FeatureOnlineStoreFeatureview can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/featureOnlineStores/{{feature_online_store}}/featureViews/{{name}}`

        * `{{project}}/{{region}}/{{feature_online_store}}/{{name}}`

        * `{{region}}/{{feature_online_store}}/{{name}}`

        * `{{feature_online_store}}/{{name}}`

        When using the `pulumi import` command, FeatureOnlineStoreFeatureview can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiFeatureOnlineStoreFeatureview:AiFeatureOnlineStoreFeatureview default projects/{{project}}/locations/{{region}}/featureOnlineStores/{{feature_online_store}}/featureViews/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureOnlineStoreFeatureview:AiFeatureOnlineStoreFeatureview default {{project}}/{{region}}/{{feature_online_store}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureOnlineStoreFeatureview:AiFeatureOnlineStoreFeatureview default {{region}}/{{feature_online_store}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiFeatureOnlineStoreFeatureview:AiFeatureOnlineStoreFeatureview default {{feature_online_store}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AiFeatureOnlineStoreFeatureviewArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AiFeatureOnlineStoreFeatureviewArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 big_query_source: Optional[pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewBigQuerySourceArgs', 'AiFeatureOnlineStoreFeatureviewBigQuerySourceArgsDict']]] = None,
                 feature_online_store: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_registry_source: Optional[pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgs', 'AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_config: Optional[pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewSyncConfigArgs', 'AiFeatureOnlineStoreFeatureviewSyncConfigArgsDict']]] = None,
                 vector_search_config: Optional[pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgs', 'AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AiFeatureOnlineStoreFeatureviewArgs.__new__(AiFeatureOnlineStoreFeatureviewArgs)

            __props__.__dict__["big_query_source"] = big_query_source
            if feature_online_store is None and not opts.urn:
                raise TypeError("Missing required property 'feature_online_store'")
            __props__.__dict__["feature_online_store"] = feature_online_store
            __props__.__dict__["feature_registry_source"] = feature_registry_source
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["sync_config"] = sync_config
            __props__.__dict__["vector_search_config"] = vector_search_config
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AiFeatureOnlineStoreFeatureview, __self__).__init__(
            'gcp:vertex/aiFeatureOnlineStoreFeatureview:AiFeatureOnlineStoreFeatureview',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            big_query_source: Optional[pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewBigQuerySourceArgs', 'AiFeatureOnlineStoreFeatureviewBigQuerySourceArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            feature_online_store: Optional[pulumi.Input[_builtins.str]] = None,
            feature_registry_source: Optional[pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgs', 'AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            sync_config: Optional[pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewSyncConfigArgs', 'AiFeatureOnlineStoreFeatureviewSyncConfigArgsDict']]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            vector_search_config: Optional[pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgs', 'AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgsDict']]] = None) -> 'AiFeatureOnlineStoreFeatureview':
        """
        Get an existing AiFeatureOnlineStoreFeatureview resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewBigQuerySourceArgs', 'AiFeatureOnlineStoreFeatureviewBigQuerySourceArgsDict']] big_query_source: Configures how data is supposed to be extracted from a BigQuery source to be loaded onto the FeatureOnlineStore.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The timestamp of when the featureOnlinestore was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] feature_online_store: The name of the FeatureOnlineStore to use for the featureview.
        :param pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgs', 'AiFeatureOnlineStoreFeatureviewFeatureRegistrySourceArgsDict']] feature_registry_source: Configures the features from a Feature Registry source that need to be loaded onto the FeatureOnlineStore.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to this FeatureView.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: Name of the FeatureView. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] region: The region for the resource. It should be the same as the featureonlinestore region.
        :param pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewSyncConfigArgs', 'AiFeatureOnlineStoreFeatureviewSyncConfigArgsDict']] sync_config: Configures when data is to be synced/updated for this FeatureView. At the end of the sync the latest featureValues for each entityId of this FeatureView are made ready for online serving.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: The timestamp of when the featureOnlinestore was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input[Union['AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgs', 'AiFeatureOnlineStoreFeatureviewVectorSearchConfigArgsDict']] vector_search_config: Configuration for vector search. It contains the required configurations to create an index from source data, so that approximate nearest neighbor (a.k.a ANN) algorithms search can be performed during online serving.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AiFeatureOnlineStoreFeatureviewState.__new__(_AiFeatureOnlineStoreFeatureviewState)

        __props__.__dict__["big_query_source"] = big_query_source
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["feature_online_store"] = feature_online_store
        __props__.__dict__["feature_registry_source"] = feature_registry_source
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["region"] = region
        __props__.__dict__["sync_config"] = sync_config
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["vector_search_config"] = vector_search_config
        return AiFeatureOnlineStoreFeatureview(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bigQuerySource")
    def big_query_source(self) -> pulumi.Output[Optional['outputs.AiFeatureOnlineStoreFeatureviewBigQuerySource']]:
        """
        Configures how data is supposed to be extracted from a BigQuery source to be loaded onto the FeatureOnlineStore.
        Structure is documented below.
        """
        return pulumi.get(self, "big_query_source")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of when the featureOnlinestore was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="featureOnlineStore")
    def feature_online_store(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the FeatureOnlineStore to use for the featureview.
        """
        return pulumi.get(self, "feature_online_store")

    @_builtins.property
    @pulumi.getter(name="featureRegistrySource")
    def feature_registry_source(self) -> pulumi.Output[Optional['outputs.AiFeatureOnlineStoreFeatureviewFeatureRegistrySource']]:
        """
        Configures the features from a Feature Registry source that need to be loaded onto the FeatureOnlineStore.
        Structure is documented below.
        """
        return pulumi.get(self, "feature_registry_source")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs to assign to this FeatureView.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the FeatureView. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region for the resource. It should be the same as the featureonlinestore region.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="syncConfig")
    def sync_config(self) -> pulumi.Output[Optional['outputs.AiFeatureOnlineStoreFeatureviewSyncConfig']]:
        """
        Configures when data is to be synced/updated for this FeatureView. At the end of the sync the latest featureValues for each entityId of this FeatureView are made ready for online serving.
        Structure is documented below.
        """
        return pulumi.get(self, "sync_config")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of when the featureOnlinestore was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="vectorSearchConfig")
    def vector_search_config(self) -> pulumi.Output[Optional['outputs.AiFeatureOnlineStoreFeatureviewVectorSearchConfig']]:
        """
        Configuration for vector search. It contains the required configurations to create an index from source data, so that approximate nearest neighbor (a.k.a ANN) algorithms search can be performed during online serving.
        Structure is documented below.
        """
        return pulumi.get(self, "vector_search_config")

