# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AiIndexArgs', 'AiIndex']

@pulumi.input_type
class AiIndexArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 index_update_method: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input['AiIndexMetadataArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AiIndex resource.
        :param pulumi.Input[_builtins.str] display_name: The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        :param pulumi.Input[_builtins.str] description: The description of the Index.
        :param pulumi.Input[_builtins.str] index_update_method: The update method to use with this Index. The value must be the followings. If not set, BATCH_UPDATE will be used by default.
               * BATCH_UPDATE: user can call indexes.patch with files on Cloud Storage of datapoints to update.
               * STREAM_UPDATE: user can call indexes.upsertDatapoints/DeleteDatapoints to update the Index and the updates will be applied in corresponding DeployedIndexes in nearly real-time.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels with user-defined metadata to organize your Indexes.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['AiIndexMetadataArgs'] metadata: Additional information about the Index.
               Although this field is not marked as required in the API specification, it is currently required when creating an Index and must be provided.
               Attempts to create an Index without this field will result in an API error.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region of the index. eg us-central1
        """
        pulumi.set(__self__, "display_name", display_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if index_update_method is not None:
            pulumi.set(__self__, "index_update_method", index_update_method)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Index.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="indexUpdateMethod")
    def index_update_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The update method to use with this Index. The value must be the followings. If not set, BATCH_UPDATE will be used by default.
        * BATCH_UPDATE: user can call indexes.patch with files on Cloud Storage of datapoints to update.
        * STREAM_UPDATE: user can call indexes.upsertDatapoints/DeleteDatapoints to update the Index and the updates will be applied in corresponding DeployedIndexes in nearly real-time.
        """
        return pulumi.get(self, "index_update_method")

    @index_update_method.setter
    def index_update_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "index_update_method", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels with user-defined metadata to organize your Indexes.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['AiIndexMetadataArgs']]:
        """
        Additional information about the Index.
        Although this field is not marked as required in the API specification, it is currently required when creating an Index and must be provided.
        Attempts to create an Index without this field will result in an API error.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['AiIndexMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the index. eg us-central1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AiIndexState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 deployed_indexes: Optional[pulumi.Input[Sequence[pulumi.Input['AiIndexDeployedIndexArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 index_stats: Optional[pulumi.Input[Sequence[pulumi.Input['AiIndexIndexStatArgs']]]] = None,
                 index_update_method: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input['AiIndexMetadataArgs']] = None,
                 metadata_schema_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AiIndex resources.
        :param pulumi.Input[_builtins.str] create_time: The timestamp of when the Index was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input[Sequence[pulumi.Input['AiIndexDeployedIndexArgs']]] deployed_indexes: The pointers to DeployedIndexes created from this Index. An Index can be only deleted if all its DeployedIndexes had been undeployed first.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: The description of the Index.
        :param pulumi.Input[_builtins.str] display_name: The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: Used to perform consistent read-modify-write updates.
        :param pulumi.Input[Sequence[pulumi.Input['AiIndexIndexStatArgs']]] index_stats: Stats of the index resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] index_update_method: The update method to use with this Index. The value must be the followings. If not set, BATCH_UPDATE will be used by default.
               * BATCH_UPDATE: user can call indexes.patch with files on Cloud Storage of datapoints to update.
               * STREAM_UPDATE: user can call indexes.upsertDatapoints/DeleteDatapoints to update the Index and the updates will be applied in corresponding DeployedIndexes in nearly real-time.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels with user-defined metadata to organize your Indexes.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['AiIndexMetadataArgs'] metadata: Additional information about the Index.
               Although this field is not marked as required in the API specification, it is currently required when creating an Index and must be provided.
               Attempts to create an Index without this field will result in an API error.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] metadata_schema_uri: Points to a YAML file stored on Google Cloud Storage describing additional information about the Index, that is specific to it. Unset if the Index does not have any additional information.
        :param pulumi.Input[_builtins.str] name: The resource name of the Index.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] region: The region of the index. eg us-central1
        :param pulumi.Input[_builtins.str] update_time: The timestamp of when the Index was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deployed_indexes is not None:
            pulumi.set(__self__, "deployed_indexes", deployed_indexes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if index_stats is not None:
            pulumi.set(__self__, "index_stats", index_stats)
        if index_update_method is not None:
            pulumi.set(__self__, "index_update_method", index_update_method)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_schema_uri is not None:
            pulumi.set(__self__, "metadata_schema_uri", metadata_schema_uri)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of when the Index was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deployedIndexes")
    def deployed_indexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AiIndexDeployedIndexArgs']]]]:
        """
        The pointers to DeployedIndexes created from this Index. An Index can be only deleted if all its DeployedIndexes had been undeployed first.
        Structure is documented below.
        """
        return pulumi.get(self, "deployed_indexes")

    @deployed_indexes.setter
    def deployed_indexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AiIndexDeployedIndexArgs']]]]):
        pulumi.set(self, "deployed_indexes", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Index.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Used to perform consistent read-modify-write updates.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="indexStats")
    def index_stats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AiIndexIndexStatArgs']]]]:
        """
        Stats of the index resource.
        Structure is documented below.
        """
        return pulumi.get(self, "index_stats")

    @index_stats.setter
    def index_stats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AiIndexIndexStatArgs']]]]):
        pulumi.set(self, "index_stats", value)

    @_builtins.property
    @pulumi.getter(name="indexUpdateMethod")
    def index_update_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The update method to use with this Index. The value must be the followings. If not set, BATCH_UPDATE will be used by default.
        * BATCH_UPDATE: user can call indexes.patch with files on Cloud Storage of datapoints to update.
        * STREAM_UPDATE: user can call indexes.upsertDatapoints/DeleteDatapoints to update the Index and the updates will be applied in corresponding DeployedIndexes in nearly real-time.
        """
        return pulumi.get(self, "index_update_method")

    @index_update_method.setter
    def index_update_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "index_update_method", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The labels with user-defined metadata to organize your Indexes.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['AiIndexMetadataArgs']]:
        """
        Additional information about the Index.
        Although this field is not marked as required in the API specification, it is currently required when creating an Index and must be provided.
        Attempts to create an Index without this field will result in an API error.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['AiIndexMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="metadataSchemaUri")
    def metadata_schema_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Points to a YAML file stored on Google Cloud Storage describing additional information about the Index, that is specific to it. Unset if the Index does not have any additional information.
        """
        return pulumi.get(self, "metadata_schema_uri")

    @metadata_schema_uri.setter
    def metadata_schema_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata_schema_uri", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name of the Index.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the index. eg us-central1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp of when the Index was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:vertex/aiIndex:AiIndex")
class AiIndex(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 index_update_method: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Union['AiIndexMetadataArgs', 'AiIndexMetadataArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A representation of a collection of database items organized in a way that allows for approximate nearest neighbor (a.k.a ANN) algorithms search.

        To get more information about Index, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexes/)

        ## Example Usage

        ### Vertex Ai Index

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="vertex-ai-index-test",
            location="us-central1",
            uniform_bucket_level_access=True)
        # The sample data comes from the following link:
        # https://cloud.google.com/vertex-ai/docs/matching-engine/filtering#specify-namespaces-tokens
        data = gcp.storage.BucketObject("data",
            name="contents/data.json",
            bucket=bucket.name,
            content=\"\"\"{"id": "42", "embedding": [0.5, 1.0], "restricts": [{"namespace": "class", "allow": ["cat", "pet"]},{"namespace": "category", "allow": ["feline"]}]}
        {"id": "43", "embedding": [0.6, 1.0], "restricts": [{"namespace": "class", "allow": ["dog", "pet"]},{"namespace": "category", "allow": ["canine"]}]}
        \"\"\")
        index = gcp.vertex.AiIndex("index",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            display_name="test-index",
            description="index for test",
            metadata={
                "contents_delta_uri": bucket.name.apply(lambda name: f"gs://{name}/contents"),
                "config": {
                    "dimensions": 2,
                    "approximate_neighbors_count": 150,
                    "shard_size": "SHARD_SIZE_SMALL",
                    "distance_measure_type": "DOT_PRODUCT_DISTANCE",
                    "algorithm_config": {
                        "tree_ah_config": {
                            "leaf_node_embedding_count": 500,
                            "leaf_nodes_to_search_percent": 7,
                        },
                    },
                },
            },
            index_update_method="BATCH_UPDATE")
        ```
        ### Vertex Ai Index Streaming

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="vertex-ai-index-test",
            location="us-central1",
            uniform_bucket_level_access=True)
        # The sample data comes from the following link:
        # https://cloud.google.com/vertex-ai/docs/matching-engine/filtering#specify-namespaces-tokens
        data = gcp.storage.BucketObject("data",
            name="contents/data.json",
            bucket=bucket.name,
            content=\"\"\"{"id": "42", "embedding": [0.5, 1.0], "restricts": [{"namespace": "class", "allow": ["cat", "pet"]},{"namespace": "category", "allow": ["feline"]}]}
        {"id": "43", "embedding": [0.6, 1.0], "restricts": [{"namespace": "class", "allow": ["dog", "pet"]},{"namespace": "category", "allow": ["canine"]}]}
        \"\"\")
        index = gcp.vertex.AiIndex("index",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            display_name="test-index",
            description="index for test",
            metadata={
                "contents_delta_uri": bucket.name.apply(lambda name: f"gs://{name}/contents"),
                "config": {
                    "dimensions": 2,
                    "shard_size": "SHARD_SIZE_LARGE",
                    "distance_measure_type": "COSINE_DISTANCE",
                    "feature_norm_type": "UNIT_L2_NORM",
                    "algorithm_config": {
                        "brute_force_config": {},
                    },
                },
            },
            index_update_method="STREAM_UPDATE")
        ```

        ## Import

        Index can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/indexes/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Index can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiIndex:AiIndex default projects/{{project}}/locations/{{region}}/indexes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiIndex:AiIndex default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiIndex:AiIndex default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiIndex:AiIndex default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the Index.
        :param pulumi.Input[_builtins.str] display_name: The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        :param pulumi.Input[_builtins.str] index_update_method: The update method to use with this Index. The value must be the followings. If not set, BATCH_UPDATE will be used by default.
               * BATCH_UPDATE: user can call indexes.patch with files on Cloud Storage of datapoints to update.
               * STREAM_UPDATE: user can call indexes.upsertDatapoints/DeleteDatapoints to update the Index and the updates will be applied in corresponding DeployedIndexes in nearly real-time.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels with user-defined metadata to organize your Indexes.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Union['AiIndexMetadataArgs', 'AiIndexMetadataArgsDict']] metadata: Additional information about the Index.
               Although this field is not marked as required in the API specification, it is currently required when creating an Index and must be provided.
               Attempts to create an Index without this field will result in an API error.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The region of the index. eg us-central1
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AiIndexArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A representation of a collection of database items organized in a way that allows for approximate nearest neighbor (a.k.a ANN) algorithms search.

        To get more information about Index, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.indexes/)

        ## Example Usage

        ### Vertex Ai Index

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="vertex-ai-index-test",
            location="us-central1",
            uniform_bucket_level_access=True)
        # The sample data comes from the following link:
        # https://cloud.google.com/vertex-ai/docs/matching-engine/filtering#specify-namespaces-tokens
        data = gcp.storage.BucketObject("data",
            name="contents/data.json",
            bucket=bucket.name,
            content=\"\"\"{"id": "42", "embedding": [0.5, 1.0], "restricts": [{"namespace": "class", "allow": ["cat", "pet"]},{"namespace": "category", "allow": ["feline"]}]}
        {"id": "43", "embedding": [0.6, 1.0], "restricts": [{"namespace": "class", "allow": ["dog", "pet"]},{"namespace": "category", "allow": ["canine"]}]}
        \"\"\")
        index = gcp.vertex.AiIndex("index",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            display_name="test-index",
            description="index for test",
            metadata={
                "contents_delta_uri": bucket.name.apply(lambda name: f"gs://{name}/contents"),
                "config": {
                    "dimensions": 2,
                    "approximate_neighbors_count": 150,
                    "shard_size": "SHARD_SIZE_SMALL",
                    "distance_measure_type": "DOT_PRODUCT_DISTANCE",
                    "algorithm_config": {
                        "tree_ah_config": {
                            "leaf_node_embedding_count": 500,
                            "leaf_nodes_to_search_percent": 7,
                        },
                    },
                },
            },
            index_update_method="BATCH_UPDATE")
        ```
        ### Vertex Ai Index Streaming

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="vertex-ai-index-test",
            location="us-central1",
            uniform_bucket_level_access=True)
        # The sample data comes from the following link:
        # https://cloud.google.com/vertex-ai/docs/matching-engine/filtering#specify-namespaces-tokens
        data = gcp.storage.BucketObject("data",
            name="contents/data.json",
            bucket=bucket.name,
            content=\"\"\"{"id": "42", "embedding": [0.5, 1.0], "restricts": [{"namespace": "class", "allow": ["cat", "pet"]},{"namespace": "category", "allow": ["feline"]}]}
        {"id": "43", "embedding": [0.6, 1.0], "restricts": [{"namespace": "class", "allow": ["dog", "pet"]},{"namespace": "category", "allow": ["canine"]}]}
        \"\"\")
        index = gcp.vertex.AiIndex("index",
            labels={
                "foo": "bar",
            },
            region="us-central1",
            display_name="test-index",
            description="index for test",
            metadata={
                "contents_delta_uri": bucket.name.apply(lambda name: f"gs://{name}/contents"),
                "config": {
                    "dimensions": 2,
                    "shard_size": "SHARD_SIZE_LARGE",
                    "distance_measure_type": "COSINE_DISTANCE",
                    "feature_norm_type": "UNIT_L2_NORM",
                    "algorithm_config": {
                        "brute_force_config": {},
                    },
                },
            },
            index_update_method="STREAM_UPDATE")
        ```

        ## Import

        Index can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/indexes/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Index can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vertex/aiIndex:AiIndex default projects/{{project}}/locations/{{region}}/indexes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiIndex:AiIndex default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiIndex:AiIndex default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vertex/aiIndex:AiIndex default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AiIndexArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AiIndexArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 index_update_method: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Union['AiIndexMetadataArgs', 'AiIndexMetadataArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AiIndexArgs.__new__(AiIndexArgs)

            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["index_update_method"] = index_update_method
            __props__.__dict__["labels"] = labels
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["create_time"] = None
            __props__.__dict__["deployed_indexes"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["index_stats"] = None
            __props__.__dict__["metadata_schema_uri"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AiIndex, __self__).__init__(
            'gcp:vertex/aiIndex:AiIndex',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            deployed_indexes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AiIndexDeployedIndexArgs', 'AiIndexDeployedIndexArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            index_stats: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AiIndexIndexStatArgs', 'AiIndexIndexStatArgsDict']]]]] = None,
            index_update_method: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            metadata: Optional[pulumi.Input[Union['AiIndexMetadataArgs', 'AiIndexMetadataArgsDict']]] = None,
            metadata_schema_uri: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'AiIndex':
        """
        Get an existing AiIndex resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The timestamp of when the Index was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AiIndexDeployedIndexArgs', 'AiIndexDeployedIndexArgsDict']]]] deployed_indexes: The pointers to DeployedIndexes created from this Index. An Index can be only deleted if all its DeployedIndexes had been undeployed first.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: The description of the Index.
        :param pulumi.Input[_builtins.str] display_name: The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: Used to perform consistent read-modify-write updates.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AiIndexIndexStatArgs', 'AiIndexIndexStatArgsDict']]]] index_stats: Stats of the index resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] index_update_method: The update method to use with this Index. The value must be the followings. If not set, BATCH_UPDATE will be used by default.
               * BATCH_UPDATE: user can call indexes.patch with files on Cloud Storage of datapoints to update.
               * STREAM_UPDATE: user can call indexes.upsertDatapoints/DeleteDatapoints to update the Index and the updates will be applied in corresponding DeployedIndexes in nearly real-time.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: The labels with user-defined metadata to organize your Indexes.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Union['AiIndexMetadataArgs', 'AiIndexMetadataArgsDict']] metadata: Additional information about the Index.
               Although this field is not marked as required in the API specification, it is currently required when creating an Index and must be provided.
               Attempts to create an Index without this field will result in an API error.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] metadata_schema_uri: Points to a YAML file stored on Google Cloud Storage describing additional information about the Index, that is specific to it. Unset if the Index does not have any additional information.
        :param pulumi.Input[_builtins.str] name: The resource name of the Index.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] region: The region of the index. eg us-central1
        :param pulumi.Input[_builtins.str] update_time: The timestamp of when the Index was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AiIndexState.__new__(_AiIndexState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deployed_indexes"] = deployed_indexes
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["index_stats"] = index_stats
        __props__.__dict__["index_update_method"] = index_update_method
        __props__.__dict__["labels"] = labels
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["metadata_schema_uri"] = metadata_schema_uri
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["region"] = region
        __props__.__dict__["update_time"] = update_time
        return AiIndex(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of when the Index was created in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deployedIndexes")
    def deployed_indexes(self) -> pulumi.Output[Sequence['outputs.AiIndexDeployedIndex']]:
        """
        The pointers to DeployedIndexes created from this Index. An Index can be only deleted if all its DeployedIndexes had been undeployed first.
        Structure is documented below.
        """
        return pulumi.get(self, "deployed_indexes")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Index.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        Used to perform consistent read-modify-write updates.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="indexStats")
    def index_stats(self) -> pulumi.Output[Sequence['outputs.AiIndexIndexStat']]:
        """
        Stats of the index resource.
        Structure is documented below.
        """
        return pulumi.get(self, "index_stats")

    @_builtins.property
    @pulumi.getter(name="indexUpdateMethod")
    def index_update_method(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The update method to use with this Index. The value must be the followings. If not set, BATCH_UPDATE will be used by default.
        * BATCH_UPDATE: user can call indexes.patch with files on Cloud Storage of datapoints to update.
        * STREAM_UPDATE: user can call indexes.upsertDatapoints/DeleteDatapoints to update the Index and the updates will be applied in corresponding DeployedIndexes in nearly real-time.
        """
        return pulumi.get(self, "index_update_method")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The labels with user-defined metadata to organize your Indexes.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional['outputs.AiIndexMetadata']]:
        """
        Additional information about the Index.
        Although this field is not marked as required in the API specification, it is currently required when creating an Index and must be provided.
        Attempts to create an Index without this field will result in an API error.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="metadataSchemaUri")
    def metadata_schema_uri(self) -> pulumi.Output[_builtins.str]:
        """
        Points to a YAML file stored on Google Cloud Storage describing additional information about the Index, that is specific to it. Unset if the Index does not have any additional information.
        """
        return pulumi.get(self, "metadata_schema_uri")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name of the Index.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region of the index. eg us-central1
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp of when the Index was last updated in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "update_time")

