# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterResult',
    'AwaitableGetClusterResult',
    'get_cluster',
    'get_cluster_output',
]

@pulumi.output_type
class GetClusterResult:
    """
    A collection of values returned by getCluster.
    """
    def __init__(__self__, autoscaling_settings=None, id=None, management=None, name=None, node_type_configs=None, parent=None, state=None, uid=None):
        if autoscaling_settings and not isinstance(autoscaling_settings, list):
            raise TypeError("Expected argument 'autoscaling_settings' to be a list")
        pulumi.set(__self__, "autoscaling_settings", autoscaling_settings)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if management and not isinstance(management, bool):
            raise TypeError("Expected argument 'management' to be a bool")
        pulumi.set(__self__, "management", management)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_type_configs and not isinstance(node_type_configs, list):
            raise TypeError("Expected argument 'node_type_configs' to be a list")
        pulumi.set(__self__, "node_type_configs", node_type_configs)
        if parent and not isinstance(parent, str):
            raise TypeError("Expected argument 'parent' to be a str")
        pulumi.set(__self__, "parent", parent)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter(name="autoscalingSettings")
    def autoscaling_settings(self) -> Sequence['outputs.GetClusterAutoscalingSettingResult']:
        return pulumi.get(self, "autoscaling_settings")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def management(self) -> _builtins.bool:
        return pulumi.get(self, "management")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeTypeConfigs")
    def node_type_configs(self) -> Sequence['outputs.GetClusterNodeTypeConfigResult']:
        return pulumi.get(self, "node_type_configs")

    @_builtins.property
    @pulumi.getter
    def parent(self) -> _builtins.str:
        return pulumi.get(self, "parent")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.str:
        return pulumi.get(self, "uid")


class AwaitableGetClusterResult(GetClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterResult(
            autoscaling_settings=self.autoscaling_settings,
            id=self.id,
            management=self.management,
            name=self.name,
            node_type_configs=self.node_type_configs,
            parent=self.parent,
            state=self.state,
            uid=self.uid)


def get_cluster(name: Optional[_builtins.str] = None,
                parent: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterResult:
    """
    Use this data source to get details about a cluster resource.

    To get more information about private cloud cluster, see:
    * [API documentation](https://cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.privateClouds.clusters)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_cluster = gcp.vmwareengine.get_cluster(name="my-cluster",
        parent="project/locations/us-west1-a/privateClouds/my-cloud")
    ```


    :param _builtins.str name: Name of the resource.
    :param _builtins.str parent: The resource name of the private cloud that this cluster belongs.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['parent'] = parent
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:vmwareengine/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult).value

    return AwaitableGetClusterResult(
        autoscaling_settings=pulumi.get(__ret__, 'autoscaling_settings'),
        id=pulumi.get(__ret__, 'id'),
        management=pulumi.get(__ret__, 'management'),
        name=pulumi.get(__ret__, 'name'),
        node_type_configs=pulumi.get(__ret__, 'node_type_configs'),
        parent=pulumi.get(__ret__, 'parent'),
        state=pulumi.get(__ret__, 'state'),
        uid=pulumi.get(__ret__, 'uid'))
def get_cluster_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                       parent: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterResult]:
    """
    Use this data source to get details about a cluster resource.

    To get more information about private cloud cluster, see:
    * [API documentation](https://cloud.google.com/vmware-engine/docs/reference/rest/v1/projects.locations.privateClouds.clusters)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_cluster = gcp.vmwareengine.get_cluster(name="my-cluster",
        parent="project/locations/us-west1-a/privateClouds/my-cloud")
    ```


    :param _builtins.str name: Name of the resource.
    :param _builtins.str parent: The resource name of the private cloud that this cluster belongs.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['parent'] = parent
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:vmwareengine/getCluster:getCluster', __args__, opts=opts, typ=GetClusterResult)
    return __ret__.apply(lambda __response__: GetClusterResult(
        autoscaling_settings=pulumi.get(__response__, 'autoscaling_settings'),
        id=pulumi.get(__response__, 'id'),
        management=pulumi.get(__response__, 'management'),
        name=pulumi.get(__response__, 'name'),
        node_type_configs=pulumi.get(__response__, 'node_type_configs'),
        parent=pulumi.get(__response__, 'parent'),
        state=pulumi.get(__response__, 'state'),
        uid=pulumi.get(__response__, 'uid')))
