# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StageArgs', 'Stage']

@pulumi.input_type
class StageArgs:
    def __init__(__self__, *,
                 api_id: pulumi.Input[str],
                 access_log_settings: Optional[pulumi.Input['StageAccessLogSettingsArgs']] = None,
                 auto_deploy: Optional[pulumi.Input[bool]] = None,
                 client_certificate_id: Optional[pulumi.Input[str]] = None,
                 default_route_settings: Optional[pulumi.Input['StageDefaultRouteSettingsArgs']] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 route_settings: Optional[pulumi.Input[Sequence[pulumi.Input['StageRouteSettingArgs']]]] = None,
                 stage_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Stage resource.
        :param pulumi.Input[str] api_id: API identifier.
        :param pulumi.Input['StageAccessLogSettingsArgs'] access_log_settings: Settings for logging access in this stage.
               Use the `apigateway.Account` resource to configure [permissions for CloudWatch Logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#set-up-access-logging-permissions).
        :param pulumi.Input[bool] auto_deploy: Whether updates to an API automatically trigger a new deployment. Defaults to `false`. Applicable for HTTP APIs.
        :param pulumi.Input[str] client_certificate_id: Identifier of a client certificate for the stage. Use the `apigateway.ClientCertificate` resource to configure a client certificate.
               Supported only for WebSocket APIs.
        :param pulumi.Input['StageDefaultRouteSettingsArgs'] default_route_settings: Default route settings for the stage.
        :param pulumi.Input[str] deployment_id: Deployment identifier of the stage. Use the `apigatewayv2.Deployment` resource to configure a deployment.
        :param pulumi.Input[str] description: Description for the stage. Must be less than or equal to 1024 characters in length.
        :param pulumi.Input[str] name: Name of the stage. Must be between 1 and 128 characters in length.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['StageRouteSettingArgs']]] route_settings: Route settings for the stage.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] stage_variables: Map that defines the stage variables for the stage.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the stage. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "api_id", api_id)
        if access_log_settings is not None:
            pulumi.set(__self__, "access_log_settings", access_log_settings)
        if auto_deploy is not None:
            pulumi.set(__self__, "auto_deploy", auto_deploy)
        if client_certificate_id is not None:
            pulumi.set(__self__, "client_certificate_id", client_certificate_id)
        if default_route_settings is not None:
            pulumi.set(__self__, "default_route_settings", default_route_settings)
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if route_settings is not None:
            pulumi.set(__self__, "route_settings", route_settings)
        if stage_variables is not None:
            pulumi.set(__self__, "stage_variables", stage_variables)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Input[str]:
        """
        API identifier.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter(name="accessLogSettings")
    def access_log_settings(self) -> Optional[pulumi.Input['StageAccessLogSettingsArgs']]:
        """
        Settings for logging access in this stage.
        Use the `apigateway.Account` resource to configure [permissions for CloudWatch Logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#set-up-access-logging-permissions).
        """
        return pulumi.get(self, "access_log_settings")

    @access_log_settings.setter
    def access_log_settings(self, value: Optional[pulumi.Input['StageAccessLogSettingsArgs']]):
        pulumi.set(self, "access_log_settings", value)

    @property
    @pulumi.getter(name="autoDeploy")
    def auto_deploy(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether updates to an API automatically trigger a new deployment. Defaults to `false`. Applicable for HTTP APIs.
        """
        return pulumi.get(self, "auto_deploy")

    @auto_deploy.setter
    def auto_deploy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_deploy", value)

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of a client certificate for the stage. Use the `apigateway.ClientCertificate` resource to configure a client certificate.
        Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "client_certificate_id")

    @client_certificate_id.setter
    def client_certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate_id", value)

    @property
    @pulumi.getter(name="defaultRouteSettings")
    def default_route_settings(self) -> Optional[pulumi.Input['StageDefaultRouteSettingsArgs']]:
        """
        Default route settings for the stage.
        """
        return pulumi.get(self, "default_route_settings")

    @default_route_settings.setter
    def default_route_settings(self, value: Optional[pulumi.Input['StageDefaultRouteSettingsArgs']]):
        pulumi.set(self, "default_route_settings", value)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Deployment identifier of the stage. Use the `apigatewayv2.Deployment` resource to configure a deployment.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the stage. Must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the stage. Must be between 1 and 128 characters in length.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="routeSettings")
    def route_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StageRouteSettingArgs']]]]:
        """
        Route settings for the stage.
        """
        return pulumi.get(self, "route_settings")

    @route_settings.setter
    def route_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StageRouteSettingArgs']]]]):
        pulumi.set(self, "route_settings", value)

    @property
    @pulumi.getter(name="stageVariables")
    def stage_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map that defines the stage variables for the stage.
        """
        return pulumi.get(self, "stage_variables")

    @stage_variables.setter
    def stage_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "stage_variables", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the stage. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _StageState:
    def __init__(__self__, *,
                 access_log_settings: Optional[pulumi.Input['StageAccessLogSettingsArgs']] = None,
                 api_id: Optional[pulumi.Input[str]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 auto_deploy: Optional[pulumi.Input[bool]] = None,
                 client_certificate_id: Optional[pulumi.Input[str]] = None,
                 default_route_settings: Optional[pulumi.Input['StageDefaultRouteSettingsArgs']] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execution_arn: Optional[pulumi.Input[str]] = None,
                 invoke_url: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 route_settings: Optional[pulumi.Input[Sequence[pulumi.Input['StageRouteSettingArgs']]]] = None,
                 stage_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Stage resources.
        :param pulumi.Input['StageAccessLogSettingsArgs'] access_log_settings: Settings for logging access in this stage.
               Use the `apigateway.Account` resource to configure [permissions for CloudWatch Logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#set-up-access-logging-permissions).
        :param pulumi.Input[str] api_id: API identifier.
        :param pulumi.Input[str] arn: ARN of the stage.
        :param pulumi.Input[bool] auto_deploy: Whether updates to an API automatically trigger a new deployment. Defaults to `false`. Applicable for HTTP APIs.
        :param pulumi.Input[str] client_certificate_id: Identifier of a client certificate for the stage. Use the `apigateway.ClientCertificate` resource to configure a client certificate.
               Supported only for WebSocket APIs.
        :param pulumi.Input['StageDefaultRouteSettingsArgs'] default_route_settings: Default route settings for the stage.
        :param pulumi.Input[str] deployment_id: Deployment identifier of the stage. Use the `apigatewayv2.Deployment` resource to configure a deployment.
        :param pulumi.Input[str] description: Description for the stage. Must be less than or equal to 1024 characters in length.
        :param pulumi.Input[str] execution_arn: ARN prefix to be used in an `lambda.Permission`'s `source_arn` attribute.
               For WebSocket APIs this attribute can additionally be used in an `iam.Policy` to authorize access to the [`@connections` API](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-how-to-call-websocket-api-connections.html).
               See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-control-access-iam.html) for details.
        :param pulumi.Input[str] invoke_url: URL to invoke the API pointing to the stage,
               e.g., `wss://z4675bid1j.execute-api.eu-west-2.amazonaws.com/example-stage`, or `https://z4675bid1j.execute-api.eu-west-2.amazonaws.com/`
        :param pulumi.Input[str] name: Name of the stage. Must be between 1 and 128 characters in length.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['StageRouteSettingArgs']]] route_settings: Route settings for the stage.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] stage_variables: Map that defines the stage variables for the stage.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the stage. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if access_log_settings is not None:
            pulumi.set(__self__, "access_log_settings", access_log_settings)
        if api_id is not None:
            pulumi.set(__self__, "api_id", api_id)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_deploy is not None:
            pulumi.set(__self__, "auto_deploy", auto_deploy)
        if client_certificate_id is not None:
            pulumi.set(__self__, "client_certificate_id", client_certificate_id)
        if default_route_settings is not None:
            pulumi.set(__self__, "default_route_settings", default_route_settings)
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_arn is not None:
            pulumi.set(__self__, "execution_arn", execution_arn)
        if invoke_url is not None:
            pulumi.set(__self__, "invoke_url", invoke_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if route_settings is not None:
            pulumi.set(__self__, "route_settings", route_settings)
        if stage_variables is not None:
            pulumi.set(__self__, "stage_variables", stage_variables)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter(name="accessLogSettings")
    def access_log_settings(self) -> Optional[pulumi.Input['StageAccessLogSettingsArgs']]:
        """
        Settings for logging access in this stage.
        Use the `apigateway.Account` resource to configure [permissions for CloudWatch Logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#set-up-access-logging-permissions).
        """
        return pulumi.get(self, "access_log_settings")

    @access_log_settings.setter
    def access_log_settings(self, value: Optional[pulumi.Input['StageAccessLogSettingsArgs']]):
        pulumi.set(self, "access_log_settings", value)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> Optional[pulumi.Input[str]]:
        """
        API identifier.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the stage.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="autoDeploy")
    def auto_deploy(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether updates to an API automatically trigger a new deployment. Defaults to `false`. Applicable for HTTP APIs.
        """
        return pulumi.get(self, "auto_deploy")

    @auto_deploy.setter
    def auto_deploy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_deploy", value)

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of a client certificate for the stage. Use the `apigateway.ClientCertificate` resource to configure a client certificate.
        Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "client_certificate_id")

    @client_certificate_id.setter
    def client_certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate_id", value)

    @property
    @pulumi.getter(name="defaultRouteSettings")
    def default_route_settings(self) -> Optional[pulumi.Input['StageDefaultRouteSettingsArgs']]:
        """
        Default route settings for the stage.
        """
        return pulumi.get(self, "default_route_settings")

    @default_route_settings.setter
    def default_route_settings(self, value: Optional[pulumi.Input['StageDefaultRouteSettingsArgs']]):
        pulumi.set(self, "default_route_settings", value)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Deployment identifier of the stage. Use the `apigatewayv2.Deployment` resource to configure a deployment.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the stage. Must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executionArn")
    def execution_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN prefix to be used in an `lambda.Permission`'s `source_arn` attribute.
        For WebSocket APIs this attribute can additionally be used in an `iam.Policy` to authorize access to the [`@connections` API](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-how-to-call-websocket-api-connections.html).
        See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-control-access-iam.html) for details.
        """
        return pulumi.get(self, "execution_arn")

    @execution_arn.setter
    def execution_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_arn", value)

    @property
    @pulumi.getter(name="invokeUrl")
    def invoke_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL to invoke the API pointing to the stage,
        e.g., `wss://z4675bid1j.execute-api.eu-west-2.amazonaws.com/example-stage`, or `https://z4675bid1j.execute-api.eu-west-2.amazonaws.com/`
        """
        return pulumi.get(self, "invoke_url")

    @invoke_url.setter
    def invoke_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invoke_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the stage. Must be between 1 and 128 characters in length.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="routeSettings")
    def route_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StageRouteSettingArgs']]]]:
        """
        Route settings for the stage.
        """
        return pulumi.get(self, "route_settings")

    @route_settings.setter
    def route_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StageRouteSettingArgs']]]]):
        pulumi.set(self, "route_settings", value)

    @property
    @pulumi.getter(name="stageVariables")
    def stage_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map that defines the stage variables for the stage.
        """
        return pulumi.get(self, "stage_variables")

    @stage_variables.setter
    def stage_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "stage_variables", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags to assign to the stage. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)


class Stage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_log_settings: Optional[pulumi.Input[Union['StageAccessLogSettingsArgs', 'StageAccessLogSettingsArgsDict']]] = None,
                 api_id: Optional[pulumi.Input[str]] = None,
                 auto_deploy: Optional[pulumi.Input[bool]] = None,
                 client_certificate_id: Optional[pulumi.Input[str]] = None,
                 default_route_settings: Optional[pulumi.Input[Union['StageDefaultRouteSettingsArgs', 'StageDefaultRouteSettingsArgsDict']]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 route_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StageRouteSettingArgs', 'StageRouteSettingArgsDict']]]]] = None,
                 stage_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages an Amazon API Gateway Version 2 stage.
        More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigatewayv2.Stage("example",
            api_id=example_aws_apigatewayv2_api["id"],
            name="example-stage")
        ```

        ## Import

        Using `pulumi import`, import `aws_apigatewayv2_stage` using the API identifier and stage name. For example:

        ```sh
        $ pulumi import aws:apigatewayv2/stage:Stage example aabbccddee/example-stage
        ```
        -> __Note:__ The API Gateway managed stage created as part of [_quick_create_](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-basic-concept.html#apigateway-definition-quick-create) cannot be imported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['StageAccessLogSettingsArgs', 'StageAccessLogSettingsArgsDict']] access_log_settings: Settings for logging access in this stage.
               Use the `apigateway.Account` resource to configure [permissions for CloudWatch Logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#set-up-access-logging-permissions).
        :param pulumi.Input[str] api_id: API identifier.
        :param pulumi.Input[bool] auto_deploy: Whether updates to an API automatically trigger a new deployment. Defaults to `false`. Applicable for HTTP APIs.
        :param pulumi.Input[str] client_certificate_id: Identifier of a client certificate for the stage. Use the `apigateway.ClientCertificate` resource to configure a client certificate.
               Supported only for WebSocket APIs.
        :param pulumi.Input[Union['StageDefaultRouteSettingsArgs', 'StageDefaultRouteSettingsArgsDict']] default_route_settings: Default route settings for the stage.
        :param pulumi.Input[str] deployment_id: Deployment identifier of the stage. Use the `apigatewayv2.Deployment` resource to configure a deployment.
        :param pulumi.Input[str] description: Description for the stage. Must be less than or equal to 1024 characters in length.
        :param pulumi.Input[str] name: Name of the stage. Must be between 1 and 128 characters in length.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[Union['StageRouteSettingArgs', 'StageRouteSettingArgsDict']]]] route_settings: Route settings for the stage.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] stage_variables: Map that defines the stage variables for the stage.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the stage. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Amazon API Gateway Version 2 stage.
        More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigatewayv2.Stage("example",
            api_id=example_aws_apigatewayv2_api["id"],
            name="example-stage")
        ```

        ## Import

        Using `pulumi import`, import `aws_apigatewayv2_stage` using the API identifier and stage name. For example:

        ```sh
        $ pulumi import aws:apigatewayv2/stage:Stage example aabbccddee/example-stage
        ```
        -> __Note:__ The API Gateway managed stage created as part of [_quick_create_](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-basic-concept.html#apigateway-definition-quick-create) cannot be imported.

        :param str resource_name: The name of the resource.
        :param StageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_log_settings: Optional[pulumi.Input[Union['StageAccessLogSettingsArgs', 'StageAccessLogSettingsArgsDict']]] = None,
                 api_id: Optional[pulumi.Input[str]] = None,
                 auto_deploy: Optional[pulumi.Input[bool]] = None,
                 client_certificate_id: Optional[pulumi.Input[str]] = None,
                 default_route_settings: Optional[pulumi.Input[Union['StageDefaultRouteSettingsArgs', 'StageDefaultRouteSettingsArgsDict']]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 route_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StageRouteSettingArgs', 'StageRouteSettingArgsDict']]]]] = None,
                 stage_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StageArgs.__new__(StageArgs)

            __props__.__dict__["access_log_settings"] = access_log_settings
            if api_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_id'")
            __props__.__dict__["api_id"] = api_id
            __props__.__dict__["auto_deploy"] = auto_deploy
            __props__.__dict__["client_certificate_id"] = client_certificate_id
            __props__.__dict__["default_route_settings"] = default_route_settings
            __props__.__dict__["deployment_id"] = deployment_id
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["route_settings"] = route_settings
            __props__.__dict__["stage_variables"] = stage_variables
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["execution_arn"] = None
            __props__.__dict__["invoke_url"] = None
            __props__.__dict__["tags_all"] = None
        super(Stage, __self__).__init__(
            'aws:apigatewayv2/stage:Stage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_log_settings: Optional[pulumi.Input[Union['StageAccessLogSettingsArgs', 'StageAccessLogSettingsArgsDict']]] = None,
            api_id: Optional[pulumi.Input[str]] = None,
            arn: Optional[pulumi.Input[str]] = None,
            auto_deploy: Optional[pulumi.Input[bool]] = None,
            client_certificate_id: Optional[pulumi.Input[str]] = None,
            default_route_settings: Optional[pulumi.Input[Union['StageDefaultRouteSettingsArgs', 'StageDefaultRouteSettingsArgsDict']]] = None,
            deployment_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            execution_arn: Optional[pulumi.Input[str]] = None,
            invoke_url: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            route_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StageRouteSettingArgs', 'StageRouteSettingArgsDict']]]]] = None,
            stage_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'Stage':
        """
        Get an existing Stage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['StageAccessLogSettingsArgs', 'StageAccessLogSettingsArgsDict']] access_log_settings: Settings for logging access in this stage.
               Use the `apigateway.Account` resource to configure [permissions for CloudWatch Logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#set-up-access-logging-permissions).
        :param pulumi.Input[str] api_id: API identifier.
        :param pulumi.Input[str] arn: ARN of the stage.
        :param pulumi.Input[bool] auto_deploy: Whether updates to an API automatically trigger a new deployment. Defaults to `false`. Applicable for HTTP APIs.
        :param pulumi.Input[str] client_certificate_id: Identifier of a client certificate for the stage. Use the `apigateway.ClientCertificate` resource to configure a client certificate.
               Supported only for WebSocket APIs.
        :param pulumi.Input[Union['StageDefaultRouteSettingsArgs', 'StageDefaultRouteSettingsArgsDict']] default_route_settings: Default route settings for the stage.
        :param pulumi.Input[str] deployment_id: Deployment identifier of the stage. Use the `apigatewayv2.Deployment` resource to configure a deployment.
        :param pulumi.Input[str] description: Description for the stage. Must be less than or equal to 1024 characters in length.
        :param pulumi.Input[str] execution_arn: ARN prefix to be used in an `lambda.Permission`'s `source_arn` attribute.
               For WebSocket APIs this attribute can additionally be used in an `iam.Policy` to authorize access to the [`@connections` API](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-how-to-call-websocket-api-connections.html).
               See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-control-access-iam.html) for details.
        :param pulumi.Input[str] invoke_url: URL to invoke the API pointing to the stage,
               e.g., `wss://z4675bid1j.execute-api.eu-west-2.amazonaws.com/example-stage`, or `https://z4675bid1j.execute-api.eu-west-2.amazonaws.com/`
        :param pulumi.Input[str] name: Name of the stage. Must be between 1 and 128 characters in length.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[Union['StageRouteSettingArgs', 'StageRouteSettingArgsDict']]]] route_settings: Route settings for the stage.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] stage_variables: Map that defines the stage variables for the stage.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of tags to assign to the stage. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StageState.__new__(_StageState)

        __props__.__dict__["access_log_settings"] = access_log_settings
        __props__.__dict__["api_id"] = api_id
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_deploy"] = auto_deploy
        __props__.__dict__["client_certificate_id"] = client_certificate_id
        __props__.__dict__["default_route_settings"] = default_route_settings
        __props__.__dict__["deployment_id"] = deployment_id
        __props__.__dict__["description"] = description
        __props__.__dict__["execution_arn"] = execution_arn
        __props__.__dict__["invoke_url"] = invoke_url
        __props__.__dict__["name"] = name
        __props__.__dict__["route_settings"] = route_settings
        __props__.__dict__["stage_variables"] = stage_variables
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Stage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessLogSettings")
    def access_log_settings(self) -> pulumi.Output[Optional['outputs.StageAccessLogSettings']]:
        """
        Settings for logging access in this stage.
        Use the `apigateway.Account` resource to configure [permissions for CloudWatch Logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#set-up-access-logging-permissions).
        """
        return pulumi.get(self, "access_log_settings")

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Output[str]:
        """
        API identifier.
        """
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the stage.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoDeploy")
    def auto_deploy(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether updates to an API automatically trigger a new deployment. Defaults to `false`. Applicable for HTTP APIs.
        """
        return pulumi.get(self, "auto_deploy")

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> pulumi.Output[Optional[str]]:
        """
        Identifier of a client certificate for the stage. Use the `apigateway.ClientCertificate` resource to configure a client certificate.
        Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "client_certificate_id")

    @property
    @pulumi.getter(name="defaultRouteSettings")
    def default_route_settings(self) -> pulumi.Output[Optional['outputs.StageDefaultRouteSettings']]:
        """
        Default route settings for the stage.
        """
        return pulumi.get(self, "default_route_settings")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Output[str]:
        """
        Deployment identifier of the stage. Use the `apigatewayv2.Deployment` resource to configure a deployment.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description for the stage. Must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executionArn")
    def execution_arn(self) -> pulumi.Output[str]:
        """
        ARN prefix to be used in an `lambda.Permission`'s `source_arn` attribute.
        For WebSocket APIs this attribute can additionally be used in an `iam.Policy` to authorize access to the [`@connections` API](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-how-to-call-websocket-api-connections.html).
        See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-control-access-iam.html) for details.
        """
        return pulumi.get(self, "execution_arn")

    @property
    @pulumi.getter(name="invokeUrl")
    def invoke_url(self) -> pulumi.Output[str]:
        """
        URL to invoke the API pointing to the stage,
        e.g., `wss://z4675bid1j.execute-api.eu-west-2.amazonaws.com/example-stage`, or `https://z4675bid1j.execute-api.eu-west-2.amazonaws.com/`
        """
        return pulumi.get(self, "invoke_url")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the stage. Must be between 1 and 128 characters in length.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="routeSettings")
    def route_settings(self) -> pulumi.Output[Optional[Sequence['outputs.StageRouteSetting']]]:
        """
        Route settings for the stage.
        """
        return pulumi.get(self, "route_settings")

    @property
    @pulumi.getter(name="stageVariables")
    def stage_variables(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map that defines the stage variables for the stage.
        """
        return pulumi.get(self, "stage_variables")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of tags to assign to the stage. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

