# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetHostedZoneIdResult',
    'AwaitableGetHostedZoneIdResult',
    'get_hosted_zone_id',
    'get_hosted_zone_id_output',
]

@pulumi.output_type
class GetHostedZoneIdResult:
    """
    A collection of values returned by getHostedZoneId.
    """
    def __init__(__self__, id=None, region=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the AWS App Runner service HostedZoneId in the selected region.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")


class AwaitableGetHostedZoneIdResult(GetHostedZoneIdResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostedZoneIdResult(
            id=self.id,
            region=self.region)


def get_hosted_zone_id(region: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostedZoneIdResult:
    """
    Use this data source to get the HostedZoneId of an AWS App Runner service deployed
    in a given region for the purpose of using it in an AWS Route53 Alias record.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    main = aws.apprunner.get_hosted_zone_id()
    www = aws.route53.Record("www",
        zone_id=primary["zoneId"],
        name="example.com",
        type=aws.route53.RecordType.A,
        aliases=[{
            "name": main_aws_apprunner_custom_domain_association["dnsTarget"],
            "zone_id": main.id,
            "evaluate_target_health": True,
        }])
    ```


    :param str region: Name of the region whose AWS App Runner service HostedZoneId is desired.
           Defaults to the region from the AWS provider configuration.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:apprunner/getHostedZoneId:getHostedZoneId', __args__, opts=opts, typ=GetHostedZoneIdResult).value

    return AwaitableGetHostedZoneIdResult(
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_hosted_zone_id_output(region: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHostedZoneIdResult]:
    """
    Use this data source to get the HostedZoneId of an AWS App Runner service deployed
    in a given region for the purpose of using it in an AWS Route53 Alias record.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    main = aws.apprunner.get_hosted_zone_id()
    www = aws.route53.Record("www",
        zone_id=primary["zoneId"],
        name="example.com",
        type=aws.route53.RecordType.A,
        aliases=[{
            "name": main_aws_apprunner_custom_domain_association["dnsTarget"],
            "zone_id": main.id,
            "evaluate_target_health": True,
        }])
    ```


    :param str region: Name of the region whose AWS App Runner service HostedZoneId is desired.
           Defaults to the region from the AWS provider configuration.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:apprunner/getHostedZoneId:getHostedZoneId', __args__, opts=opts, typ=GetHostedZoneIdResult)
    return __ret__.apply(lambda __response__: GetHostedZoneIdResult(
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
