# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 max_size: pulumi.Input[int],
                 min_size: pulumi.Input[int],
                 availability_zone_distribution: Optional[pulumi.Input['GroupAvailabilityZoneDistributionArgs']] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 capacity_rebalance: Optional[pulumi.Input[bool]] = None,
                 context: Optional[pulumi.Input[str]] = None,
                 default_cooldown: Optional[pulumi.Input[int]] = None,
                 default_instance_warmup: Optional[pulumi.Input[int]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 desired_capacity_type: Optional[pulumi.Input[str]] = None,
                 enabled_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 force_delete_warm_pool: Optional[pulumi.Input[bool]] = None,
                 health_check_grace_period: Optional[pulumi.Input[int]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 ignore_failed_scaling_activities: Optional[pulumi.Input[bool]] = None,
                 initial_lifecycle_hooks: Optional[pulumi.Input[Sequence[pulumi.Input['GroupInitialLifecycleHookArgs']]]] = None,
                 instance_maintenance_policy: Optional[pulumi.Input['GroupInstanceMaintenancePolicyArgs']] = None,
                 instance_refresh: Optional[pulumi.Input['GroupInstanceRefreshArgs']] = None,
                 launch_configuration: Optional[pulumi.Input[str]] = None,
                 launch_template: Optional[pulumi.Input['GroupLaunchTemplateArgs']] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_instance_lifetime: Optional[pulumi.Input[int]] = None,
                 metrics_granularity: Optional[pulumi.Input[Union[str, 'MetricsGranularity']]] = None,
                 min_elb_capacity: Optional[pulumi.Input[int]] = None,
                 mixed_instances_policy: Optional[pulumi.Input['GroupMixedInstancesPolicyArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 placement_group: Optional[pulumi.Input[str]] = None,
                 protect_from_scale_in: Optional[pulumi.Input[bool]] = None,
                 service_linked_role_arn: Optional[pulumi.Input[str]] = None,
                 suspended_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['GroupTagArgs']]]] = None,
                 target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 termination_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 traffic_sources: Optional[pulumi.Input[Sequence[pulumi.Input['GroupTrafficSourceArgs']]]] = None,
                 vpc_zone_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wait_for_capacity_timeout: Optional[pulumi.Input[str]] = None,
                 wait_for_elb_capacity: Optional[pulumi.Input[int]] = None,
                 warm_pool: Optional[pulumi.Input['GroupWarmPoolArgs']] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[int] max_size: Maximum size of the Auto Scaling Group.
        :param pulumi.Input[int] min_size: Minimum size of the Auto Scaling Group.
               (See also Waiting for Capacity below.)
        :param pulumi.Input['GroupAvailabilityZoneDistributionArgs'] availability_zone_distribution: The instance capacity distribution across Availability Zones. See Availability Zone Distribution below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
        :param pulumi.Input[bool] capacity_rebalance: Whether capacity rebalance is enabled. Otherwise, capacity rebalance is disabled.
        :param pulumi.Input[str] context: Reserved.
        :param pulumi.Input[int] default_cooldown: Amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
        :param pulumi.Input[int] default_instance_warmup: Amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the InService state. (See [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html))
        :param pulumi.Input[int] desired_capacity: Number of Amazon EC2 instances that
               should be running in the group. (See also Waiting for
               Capacity below.)
        :param pulumi.Input[str] desired_capacity_type: The unit of measurement for the value specified for `desired_capacity`. Supported for attribute-based instance type selection only. Valid values: `"units"`, `"vcpu"`, `"memory-mib"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_metrics: List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
        :param pulumi.Input[bool] force_delete: Allows deleting the Auto Scaling Group without waiting
               for all instances in the pool to terminate. You can force an Auto Scaling Group to delete
               even if it's in the process of scaling a resource. Normally, this provider
               drains all the instances before deleting the group. This bypasses that
               behavior and potentially leaves resources dangling.
        :param pulumi.Input[bool] force_delete_warm_pool: Allows deleting the Auto Scaling Group without waiting for all instances in the warm pool to terminate.
        :param pulumi.Input[int] health_check_grace_period: Time (in seconds) after instance comes into service before checking health.
        :param pulumi.Input[str] health_check_type: "EC2" or "ELB". Controls how health checking is done.
        :param pulumi.Input[bool] ignore_failed_scaling_activities: Whether to ignore failed [Auto Scaling scaling activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html) while waiting for capacity. The default is `false` -- failed scaling activities cause errors to be returned.
        :param pulumi.Input[Sequence[pulumi.Input['GroupInitialLifecycleHookArgs']]] initial_lifecycle_hooks: One or more
               [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
               to attach to the Auto Scaling Group **before** instances are launched. The
               syntax is exactly the same as the separate
               `autoscaling.LifecycleHook`
               resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
               a new Auto Scaling Group. For all other use-cases, please use `autoscaling.LifecycleHook` resource.
        :param pulumi.Input['GroupInstanceMaintenancePolicyArgs'] instance_maintenance_policy: If this block is configured, add a instance maintenance policy to the specified Auto Scaling group. Defined below.
        :param pulumi.Input['GroupInstanceRefreshArgs'] instance_refresh: If this block is configured, start an
               [Instance Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
               when this Auto Scaling Group is updated. Defined below.
        :param pulumi.Input[str] launch_configuration: Name of the launch configuration to use.
        :param pulumi.Input['GroupLaunchTemplateArgs'] launch_template: Nested argument with Launch template specification to use to launch instances. See Launch Template below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] load_balancers: List of elastic load balancer names to add to the autoscaling
               group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
        :param pulumi.Input[int] max_instance_lifetime: Maximum amount of time, in seconds, that an instance can be in service, values must be either equal to 0 or between 86400 and 31536000 seconds.
        :param pulumi.Input[Union[str, 'MetricsGranularity']] metrics_granularity: Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
        :param pulumi.Input[int] min_elb_capacity: Setting this causes Pulumi to wait for
               this number of instances from this Auto Scaling Group to show up healthy in the
               ELB only on creation. Updates will not wait on ELB instance number changes.
               (See also Waiting for Capacity below.)
        :param pulumi.Input['GroupMixedInstancesPolicyArgs'] mixed_instances_policy: Configuration block containing settings to define launch targets for Auto Scaling groups. See Mixed Instances Policy below for more details.
        :param pulumi.Input[str] name: Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`.
        :param pulumi.Input[str] placement_group: Name of the placement group into which you'll launch your instances, if any.
        :param pulumi.Input[bool] protect_from_scale_in: Whether newly launched instances
               are automatically protected from termination by Amazon EC2 Auto Scaling when
               scaling in. For more information about preventing instances from terminating
               on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
               in the Amazon EC2 Auto Scaling User Guide.
        :param pulumi.Input[str] service_linked_role_arn: ARN of the service-linked role that the ASG will use to call other AWS services
        :param pulumi.Input[Sequence[pulumi.Input[str]]] suspended_processes: List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
               Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
        :param pulumi.Input[Sequence[pulumi.Input['GroupTagArgs']]] tags: Configuration block(s) containing resource tags. See Tag below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_group_arns: Set of `alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] termination_policies: List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
        :param pulumi.Input[Sequence[pulumi.Input['GroupTrafficSourceArgs']]] traffic_sources: Attaches one or more traffic sources to the specified Auto Scaling group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_zone_identifiers: List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
        :param pulumi.Input[str] wait_for_capacity_timeout: Maximum
               [duration](https://golang.org/pkg/time/#ParseDuration) that the provider should
               wait for ASG instances to be healthy before timing out. (See also Waiting
               for Capacity below.) Setting this to "0" causes
               the provider to skip all Capacity Waiting behavior.
        :param pulumi.Input[int] wait_for_elb_capacity: Setting this will cause Pulumi to wait
               for exactly this number of healthy instances from this Auto Scaling Group in
               all attached load balancers on both create and update operations. (Takes
               precedence over `min_elb_capacity` behavior.)
               (See also Waiting for Capacity below.)
        :param pulumi.Input['GroupWarmPoolArgs'] warm_pool: If this block is configured, add a [Warm Pool](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
               to the specified Auto Scaling group. Defined below
        """
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)
        if availability_zone_distribution is not None:
            pulumi.set(__self__, "availability_zone_distribution", availability_zone_distribution)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if capacity_rebalance is not None:
            pulumi.set(__self__, "capacity_rebalance", capacity_rebalance)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if default_cooldown is not None:
            pulumi.set(__self__, "default_cooldown", default_cooldown)
        if default_instance_warmup is not None:
            pulumi.set(__self__, "default_instance_warmup", default_instance_warmup)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if desired_capacity_type is not None:
            pulumi.set(__self__, "desired_capacity_type", desired_capacity_type)
        if enabled_metrics is not None:
            pulumi.set(__self__, "enabled_metrics", enabled_metrics)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if force_delete_warm_pool is not None:
            pulumi.set(__self__, "force_delete_warm_pool", force_delete_warm_pool)
        if health_check_grace_period is not None:
            pulumi.set(__self__, "health_check_grace_period", health_check_grace_period)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if ignore_failed_scaling_activities is not None:
            pulumi.set(__self__, "ignore_failed_scaling_activities", ignore_failed_scaling_activities)
        if initial_lifecycle_hooks is not None:
            pulumi.set(__self__, "initial_lifecycle_hooks", initial_lifecycle_hooks)
        if instance_maintenance_policy is not None:
            pulumi.set(__self__, "instance_maintenance_policy", instance_maintenance_policy)
        if instance_refresh is not None:
            pulumi.set(__self__, "instance_refresh", instance_refresh)
        if launch_configuration is not None:
            pulumi.set(__self__, "launch_configuration", launch_configuration)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if max_instance_lifetime is not None:
            pulumi.set(__self__, "max_instance_lifetime", max_instance_lifetime)
        if metrics_granularity is not None:
            pulumi.set(__self__, "metrics_granularity", metrics_granularity)
        if min_elb_capacity is not None:
            pulumi.set(__self__, "min_elb_capacity", min_elb_capacity)
        if mixed_instances_policy is not None:
            pulumi.set(__self__, "mixed_instances_policy", mixed_instances_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if placement_group is not None:
            pulumi.set(__self__, "placement_group", placement_group)
        if protect_from_scale_in is not None:
            pulumi.set(__self__, "protect_from_scale_in", protect_from_scale_in)
        if service_linked_role_arn is not None:
            pulumi.set(__self__, "service_linked_role_arn", service_linked_role_arn)
        if suspended_processes is not None:
            pulumi.set(__self__, "suspended_processes", suspended_processes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_group_arns is not None:
            pulumi.set(__self__, "target_group_arns", target_group_arns)
        if termination_policies is not None:
            pulumi.set(__self__, "termination_policies", termination_policies)
        if traffic_sources is not None:
            pulumi.set(__self__, "traffic_sources", traffic_sources)
        if vpc_zone_identifiers is not None:
            pulumi.set(__self__, "vpc_zone_identifiers", vpc_zone_identifiers)
        if wait_for_capacity_timeout is not None:
            pulumi.set(__self__, "wait_for_capacity_timeout", wait_for_capacity_timeout)
        if wait_for_elb_capacity is not None:
            pulumi.set(__self__, "wait_for_elb_capacity", wait_for_elb_capacity)
        if warm_pool is not None:
            pulumi.set(__self__, "warm_pool", warm_pool)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Input[int]:
        """
        Maximum size of the Auto Scaling Group.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Input[int]:
        """
        Minimum size of the Auto Scaling Group.
        (See also Waiting for Capacity below.)
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="availabilityZoneDistribution")
    def availability_zone_distribution(self) -> Optional[pulumi.Input['GroupAvailabilityZoneDistributionArgs']]:
        """
        The instance capacity distribution across Availability Zones. See Availability Zone Distribution below for more details.
        """
        return pulumi.get(self, "availability_zone_distribution")

    @availability_zone_distribution.setter
    def availability_zone_distribution(self, value: Optional[pulumi.Input['GroupAvailabilityZoneDistributionArgs']]):
        pulumi.set(self, "availability_zone_distribution", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="capacityRebalance")
    def capacity_rebalance(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether capacity rebalance is enabled. Otherwise, capacity rebalance is disabled.
        """
        return pulumi.get(self, "capacity_rebalance")

    @capacity_rebalance.setter
    def capacity_rebalance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "capacity_rebalance", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[str]]:
        """
        Reserved.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="defaultCooldown")
    def default_cooldown(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
        """
        return pulumi.get(self, "default_cooldown")

    @default_cooldown.setter
    def default_cooldown(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_cooldown", value)

    @property
    @pulumi.getter(name="defaultInstanceWarmup")
    def default_instance_warmup(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the InService state. (See [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html))
        """
        return pulumi.get(self, "default_instance_warmup")

    @default_instance_warmup.setter
    def default_instance_warmup(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_instance_warmup", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Number of Amazon EC2 instances that
        should be running in the group. (See also Waiting for
        Capacity below.)
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="desiredCapacityType")
    def desired_capacity_type(self) -> Optional[pulumi.Input[str]]:
        """
        The unit of measurement for the value specified for `desired_capacity`. Supported for attribute-based instance type selection only. Valid values: `"units"`, `"vcpu"`, `"memory-mib"`.
        """
        return pulumi.get(self, "desired_capacity_type")

    @desired_capacity_type.setter
    def desired_capacity_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desired_capacity_type", value)

    @property
    @pulumi.getter(name="enabledMetrics")
    def enabled_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
        """
        return pulumi.get(self, "enabled_metrics")

    @enabled_metrics.setter
    def enabled_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_metrics", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows deleting the Auto Scaling Group without waiting
        for all instances in the pool to terminate. You can force an Auto Scaling Group to delete
        even if it's in the process of scaling a resource. Normally, this provider
        drains all the instances before deleting the group. This bypasses that
        behavior and potentially leaves resources dangling.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="forceDeleteWarmPool")
    def force_delete_warm_pool(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows deleting the Auto Scaling Group without waiting for all instances in the warm pool to terminate.
        """
        return pulumi.get(self, "force_delete_warm_pool")

    @force_delete_warm_pool.setter
    def force_delete_warm_pool(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete_warm_pool", value)

    @property
    @pulumi.getter(name="healthCheckGracePeriod")
    def health_check_grace_period(self) -> Optional[pulumi.Input[int]]:
        """
        Time (in seconds) after instance comes into service before checking health.
        """
        return pulumi.get(self, "health_check_grace_period")

    @health_check_grace_period.setter
    def health_check_grace_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_grace_period", value)

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[pulumi.Input[str]]:
        """
        "EC2" or "ELB". Controls how health checking is done.
        """
        return pulumi.get(self, "health_check_type")

    @health_check_type.setter
    def health_check_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_type", value)

    @property
    @pulumi.getter(name="ignoreFailedScalingActivities")
    def ignore_failed_scaling_activities(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to ignore failed [Auto Scaling scaling activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html) while waiting for capacity. The default is `false` -- failed scaling activities cause errors to be returned.
        """
        return pulumi.get(self, "ignore_failed_scaling_activities")

    @ignore_failed_scaling_activities.setter
    def ignore_failed_scaling_activities(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_failed_scaling_activities", value)

    @property
    @pulumi.getter(name="initialLifecycleHooks")
    def initial_lifecycle_hooks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupInitialLifecycleHookArgs']]]]:
        """
        One or more
        [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
        to attach to the Auto Scaling Group **before** instances are launched. The
        syntax is exactly the same as the separate
        `autoscaling.LifecycleHook`
        resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
        a new Auto Scaling Group. For all other use-cases, please use `autoscaling.LifecycleHook` resource.
        """
        return pulumi.get(self, "initial_lifecycle_hooks")

    @initial_lifecycle_hooks.setter
    def initial_lifecycle_hooks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupInitialLifecycleHookArgs']]]]):
        pulumi.set(self, "initial_lifecycle_hooks", value)

    @property
    @pulumi.getter(name="instanceMaintenancePolicy")
    def instance_maintenance_policy(self) -> Optional[pulumi.Input['GroupInstanceMaintenancePolicyArgs']]:
        """
        If this block is configured, add a instance maintenance policy to the specified Auto Scaling group. Defined below.
        """
        return pulumi.get(self, "instance_maintenance_policy")

    @instance_maintenance_policy.setter
    def instance_maintenance_policy(self, value: Optional[pulumi.Input['GroupInstanceMaintenancePolicyArgs']]):
        pulumi.set(self, "instance_maintenance_policy", value)

    @property
    @pulumi.getter(name="instanceRefresh")
    def instance_refresh(self) -> Optional[pulumi.Input['GroupInstanceRefreshArgs']]:
        """
        If this block is configured, start an
        [Instance Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
        when this Auto Scaling Group is updated. Defined below.
        """
        return pulumi.get(self, "instance_refresh")

    @instance_refresh.setter
    def instance_refresh(self, value: Optional[pulumi.Input['GroupInstanceRefreshArgs']]):
        pulumi.set(self, "instance_refresh", value)

    @property
    @pulumi.getter(name="launchConfiguration")
    def launch_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the launch configuration to use.
        """
        return pulumi.get(self, "launch_configuration")

    @launch_configuration.setter
    def launch_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_configuration", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['GroupLaunchTemplateArgs']]:
        """
        Nested argument with Launch template specification to use to launch instances. See Launch Template below for more details.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['GroupLaunchTemplateArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of elastic load balancer names to add to the autoscaling
        group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter(name="maxInstanceLifetime")
    def max_instance_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum amount of time, in seconds, that an instance can be in service, values must be either equal to 0 or between 86400 and 31536000 seconds.
        """
        return pulumi.get(self, "max_instance_lifetime")

    @max_instance_lifetime.setter
    def max_instance_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instance_lifetime", value)

    @property
    @pulumi.getter(name="metricsGranularity")
    def metrics_granularity(self) -> Optional[pulumi.Input[Union[str, 'MetricsGranularity']]]:
        """
        Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
        """
        return pulumi.get(self, "metrics_granularity")

    @metrics_granularity.setter
    def metrics_granularity(self, value: Optional[pulumi.Input[Union[str, 'MetricsGranularity']]]):
        pulumi.set(self, "metrics_granularity", value)

    @property
    @pulumi.getter(name="minElbCapacity")
    def min_elb_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Setting this causes Pulumi to wait for
        this number of instances from this Auto Scaling Group to show up healthy in the
        ELB only on creation. Updates will not wait on ELB instance number changes.
        (See also Waiting for Capacity below.)
        """
        return pulumi.get(self, "min_elb_capacity")

    @min_elb_capacity.setter
    def min_elb_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_elb_capacity", value)

    @property
    @pulumi.getter(name="mixedInstancesPolicy")
    def mixed_instances_policy(self) -> Optional[pulumi.Input['GroupMixedInstancesPolicyArgs']]:
        """
        Configuration block containing settings to define launch targets for Auto Scaling groups. See Mixed Instances Policy below for more details.
        """
        return pulumi.get(self, "mixed_instances_policy")

    @mixed_instances_policy.setter
    def mixed_instances_policy(self, value: Optional[pulumi.Input['GroupMixedInstancesPolicyArgs']]):
        pulumi.set(self, "mixed_instances_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique name beginning with the specified
        prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the placement group into which you'll launch your instances, if any.
        """
        return pulumi.get(self, "placement_group")

    @placement_group.setter
    def placement_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_group", value)

    @property
    @pulumi.getter(name="protectFromScaleIn")
    def protect_from_scale_in(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether newly launched instances
        are automatically protected from termination by Amazon EC2 Auto Scaling when
        scaling in. For more information about preventing instances from terminating
        on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
        in the Amazon EC2 Auto Scaling User Guide.
        """
        return pulumi.get(self, "protect_from_scale_in")

    @protect_from_scale_in.setter
    def protect_from_scale_in(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "protect_from_scale_in", value)

    @property
    @pulumi.getter(name="serviceLinkedRoleArn")
    def service_linked_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the service-linked role that the ASG will use to call other AWS services
        """
        return pulumi.get(self, "service_linked_role_arn")

    @service_linked_role_arn.setter
    def service_linked_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_linked_role_arn", value)

    @property
    @pulumi.getter(name="suspendedProcesses")
    def suspended_processes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
        Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
        """
        return pulumi.get(self, "suspended_processes")

    @suspended_processes.setter
    def suspended_processes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "suspended_processes", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupTagArgs']]]]:
        """
        Configuration block(s) containing resource tags. See Tag below for more details.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetGroupArns")
    def target_group_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of `alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
        """
        return pulumi.get(self, "target_group_arns")

    @target_group_arns.setter
    def target_group_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_group_arns", value)

    @property
    @pulumi.getter(name="terminationPolicies")
    def termination_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
        """
        return pulumi.get(self, "termination_policies")

    @termination_policies.setter
    def termination_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "termination_policies", value)

    @property
    @pulumi.getter(name="trafficSources")
    def traffic_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupTrafficSourceArgs']]]]:
        """
        Attaches one or more traffic sources to the specified Auto Scaling group.
        """
        return pulumi.get(self, "traffic_sources")

    @traffic_sources.setter
    def traffic_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupTrafficSourceArgs']]]]):
        pulumi.set(self, "traffic_sources", value)

    @property
    @pulumi.getter(name="vpcZoneIdentifiers")
    def vpc_zone_identifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
        """
        return pulumi.get(self, "vpc_zone_identifiers")

    @vpc_zone_identifiers.setter
    def vpc_zone_identifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_zone_identifiers", value)

    @property
    @pulumi.getter(name="waitForCapacityTimeout")
    def wait_for_capacity_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum
        [duration](https://golang.org/pkg/time/#ParseDuration) that the provider should
        wait for ASG instances to be healthy before timing out. (See also Waiting
        for Capacity below.) Setting this to "0" causes
        the provider to skip all Capacity Waiting behavior.
        """
        return pulumi.get(self, "wait_for_capacity_timeout")

    @wait_for_capacity_timeout.setter
    def wait_for_capacity_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wait_for_capacity_timeout", value)

    @property
    @pulumi.getter(name="waitForElbCapacity")
    def wait_for_elb_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Setting this will cause Pulumi to wait
        for exactly this number of healthy instances from this Auto Scaling Group in
        all attached load balancers on both create and update operations. (Takes
        precedence over `min_elb_capacity` behavior.)
        (See also Waiting for Capacity below.)
        """
        return pulumi.get(self, "wait_for_elb_capacity")

    @wait_for_elb_capacity.setter
    def wait_for_elb_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "wait_for_elb_capacity", value)

    @property
    @pulumi.getter(name="warmPool")
    def warm_pool(self) -> Optional[pulumi.Input['GroupWarmPoolArgs']]:
        """
        If this block is configured, add a [Warm Pool](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
        to the specified Auto Scaling group. Defined below
        """
        return pulumi.get(self, "warm_pool")

    @warm_pool.setter
    def warm_pool(self, value: Optional[pulumi.Input['GroupWarmPoolArgs']]):
        pulumi.set(self, "warm_pool", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 availability_zone_distribution: Optional[pulumi.Input['GroupAvailabilityZoneDistributionArgs']] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 capacity_rebalance: Optional[pulumi.Input[bool]] = None,
                 context: Optional[pulumi.Input[str]] = None,
                 default_cooldown: Optional[pulumi.Input[int]] = None,
                 default_instance_warmup: Optional[pulumi.Input[int]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 desired_capacity_type: Optional[pulumi.Input[str]] = None,
                 enabled_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 force_delete_warm_pool: Optional[pulumi.Input[bool]] = None,
                 health_check_grace_period: Optional[pulumi.Input[int]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 ignore_failed_scaling_activities: Optional[pulumi.Input[bool]] = None,
                 initial_lifecycle_hooks: Optional[pulumi.Input[Sequence[pulumi.Input['GroupInitialLifecycleHookArgs']]]] = None,
                 instance_maintenance_policy: Optional[pulumi.Input['GroupInstanceMaintenancePolicyArgs']] = None,
                 instance_refresh: Optional[pulumi.Input['GroupInstanceRefreshArgs']] = None,
                 launch_configuration: Optional[pulumi.Input[str]] = None,
                 launch_template: Optional[pulumi.Input['GroupLaunchTemplateArgs']] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_instance_lifetime: Optional[pulumi.Input[int]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 metrics_granularity: Optional[pulumi.Input[Union[str, 'MetricsGranularity']]] = None,
                 min_elb_capacity: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 mixed_instances_policy: Optional[pulumi.Input['GroupMixedInstancesPolicyArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 placement_group: Optional[pulumi.Input[str]] = None,
                 predicted_capacity: Optional[pulumi.Input[int]] = None,
                 protect_from_scale_in: Optional[pulumi.Input[bool]] = None,
                 service_linked_role_arn: Optional[pulumi.Input[str]] = None,
                 suspended_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['GroupTagArgs']]]] = None,
                 target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 termination_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 traffic_sources: Optional[pulumi.Input[Sequence[pulumi.Input['GroupTrafficSourceArgs']]]] = None,
                 vpc_zone_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wait_for_capacity_timeout: Optional[pulumi.Input[str]] = None,
                 wait_for_elb_capacity: Optional[pulumi.Input[int]] = None,
                 warm_pool: Optional[pulumi.Input['GroupWarmPoolArgs']] = None,
                 warm_pool_size: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[str] arn: ARN for this Auto Scaling Group
        :param pulumi.Input['GroupAvailabilityZoneDistributionArgs'] availability_zone_distribution: The instance capacity distribution across Availability Zones. See Availability Zone Distribution below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
        :param pulumi.Input[bool] capacity_rebalance: Whether capacity rebalance is enabled. Otherwise, capacity rebalance is disabled.
        :param pulumi.Input[str] context: Reserved.
        :param pulumi.Input[int] default_cooldown: Amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
        :param pulumi.Input[int] default_instance_warmup: Amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the InService state. (See [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html))
        :param pulumi.Input[int] desired_capacity: Number of Amazon EC2 instances that
               should be running in the group. (See also Waiting for
               Capacity below.)
        :param pulumi.Input[str] desired_capacity_type: The unit of measurement for the value specified for `desired_capacity`. Supported for attribute-based instance type selection only. Valid values: `"units"`, `"vcpu"`, `"memory-mib"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_metrics: List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
        :param pulumi.Input[bool] force_delete: Allows deleting the Auto Scaling Group without waiting
               for all instances in the pool to terminate. You can force an Auto Scaling Group to delete
               even if it's in the process of scaling a resource. Normally, this provider
               drains all the instances before deleting the group. This bypasses that
               behavior and potentially leaves resources dangling.
        :param pulumi.Input[bool] force_delete_warm_pool: Allows deleting the Auto Scaling Group without waiting for all instances in the warm pool to terminate.
        :param pulumi.Input[int] health_check_grace_period: Time (in seconds) after instance comes into service before checking health.
        :param pulumi.Input[str] health_check_type: "EC2" or "ELB". Controls how health checking is done.
        :param pulumi.Input[bool] ignore_failed_scaling_activities: Whether to ignore failed [Auto Scaling scaling activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html) while waiting for capacity. The default is `false` -- failed scaling activities cause errors to be returned.
        :param pulumi.Input[Sequence[pulumi.Input['GroupInitialLifecycleHookArgs']]] initial_lifecycle_hooks: One or more
               [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
               to attach to the Auto Scaling Group **before** instances are launched. The
               syntax is exactly the same as the separate
               `autoscaling.LifecycleHook`
               resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
               a new Auto Scaling Group. For all other use-cases, please use `autoscaling.LifecycleHook` resource.
        :param pulumi.Input['GroupInstanceMaintenancePolicyArgs'] instance_maintenance_policy: If this block is configured, add a instance maintenance policy to the specified Auto Scaling group. Defined below.
        :param pulumi.Input['GroupInstanceRefreshArgs'] instance_refresh: If this block is configured, start an
               [Instance Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
               when this Auto Scaling Group is updated. Defined below.
        :param pulumi.Input[str] launch_configuration: Name of the launch configuration to use.
        :param pulumi.Input['GroupLaunchTemplateArgs'] launch_template: Nested argument with Launch template specification to use to launch instances. See Launch Template below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] load_balancers: List of elastic load balancer names to add to the autoscaling
               group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
        :param pulumi.Input[int] max_instance_lifetime: Maximum amount of time, in seconds, that an instance can be in service, values must be either equal to 0 or between 86400 and 31536000 seconds.
        :param pulumi.Input[int] max_size: Maximum size of the Auto Scaling Group.
        :param pulumi.Input[Union[str, 'MetricsGranularity']] metrics_granularity: Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
        :param pulumi.Input[int] min_elb_capacity: Setting this causes Pulumi to wait for
               this number of instances from this Auto Scaling Group to show up healthy in the
               ELB only on creation. Updates will not wait on ELB instance number changes.
               (See also Waiting for Capacity below.)
        :param pulumi.Input[int] min_size: Minimum size of the Auto Scaling Group.
               (See also Waiting for Capacity below.)
        :param pulumi.Input['GroupMixedInstancesPolicyArgs'] mixed_instances_policy: Configuration block containing settings to define launch targets for Auto Scaling groups. See Mixed Instances Policy below for more details.
        :param pulumi.Input[str] name: Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`.
        :param pulumi.Input[str] placement_group: Name of the placement group into which you'll launch your instances, if any.
        :param pulumi.Input[int] predicted_capacity: Predicted capacity of the group.
        :param pulumi.Input[bool] protect_from_scale_in: Whether newly launched instances
               are automatically protected from termination by Amazon EC2 Auto Scaling when
               scaling in. For more information about preventing instances from terminating
               on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
               in the Amazon EC2 Auto Scaling User Guide.
        :param pulumi.Input[str] service_linked_role_arn: ARN of the service-linked role that the ASG will use to call other AWS services
        :param pulumi.Input[Sequence[pulumi.Input[str]]] suspended_processes: List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
               Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
        :param pulumi.Input[Sequence[pulumi.Input['GroupTagArgs']]] tags: Configuration block(s) containing resource tags. See Tag below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_group_arns: Set of `alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] termination_policies: List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
        :param pulumi.Input[Sequence[pulumi.Input['GroupTrafficSourceArgs']]] traffic_sources: Attaches one or more traffic sources to the specified Auto Scaling group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_zone_identifiers: List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
        :param pulumi.Input[str] wait_for_capacity_timeout: Maximum
               [duration](https://golang.org/pkg/time/#ParseDuration) that the provider should
               wait for ASG instances to be healthy before timing out. (See also Waiting
               for Capacity below.) Setting this to "0" causes
               the provider to skip all Capacity Waiting behavior.
        :param pulumi.Input[int] wait_for_elb_capacity: Setting this will cause Pulumi to wait
               for exactly this number of healthy instances from this Auto Scaling Group in
               all attached load balancers on both create and update operations. (Takes
               precedence over `min_elb_capacity` behavior.)
               (See also Waiting for Capacity below.)
        :param pulumi.Input['GroupWarmPoolArgs'] warm_pool: If this block is configured, add a [Warm Pool](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
               to the specified Auto Scaling group. Defined below
        :param pulumi.Input[int] warm_pool_size: Current size of the warm pool.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if availability_zone_distribution is not None:
            pulumi.set(__self__, "availability_zone_distribution", availability_zone_distribution)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if capacity_rebalance is not None:
            pulumi.set(__self__, "capacity_rebalance", capacity_rebalance)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if default_cooldown is not None:
            pulumi.set(__self__, "default_cooldown", default_cooldown)
        if default_instance_warmup is not None:
            pulumi.set(__self__, "default_instance_warmup", default_instance_warmup)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if desired_capacity_type is not None:
            pulumi.set(__self__, "desired_capacity_type", desired_capacity_type)
        if enabled_metrics is not None:
            pulumi.set(__self__, "enabled_metrics", enabled_metrics)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if force_delete_warm_pool is not None:
            pulumi.set(__self__, "force_delete_warm_pool", force_delete_warm_pool)
        if health_check_grace_period is not None:
            pulumi.set(__self__, "health_check_grace_period", health_check_grace_period)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if ignore_failed_scaling_activities is not None:
            pulumi.set(__self__, "ignore_failed_scaling_activities", ignore_failed_scaling_activities)
        if initial_lifecycle_hooks is not None:
            pulumi.set(__self__, "initial_lifecycle_hooks", initial_lifecycle_hooks)
        if instance_maintenance_policy is not None:
            pulumi.set(__self__, "instance_maintenance_policy", instance_maintenance_policy)
        if instance_refresh is not None:
            pulumi.set(__self__, "instance_refresh", instance_refresh)
        if launch_configuration is not None:
            pulumi.set(__self__, "launch_configuration", launch_configuration)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if max_instance_lifetime is not None:
            pulumi.set(__self__, "max_instance_lifetime", max_instance_lifetime)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if metrics_granularity is not None:
            pulumi.set(__self__, "metrics_granularity", metrics_granularity)
        if min_elb_capacity is not None:
            pulumi.set(__self__, "min_elb_capacity", min_elb_capacity)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if mixed_instances_policy is not None:
            pulumi.set(__self__, "mixed_instances_policy", mixed_instances_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if placement_group is not None:
            pulumi.set(__self__, "placement_group", placement_group)
        if predicted_capacity is not None:
            pulumi.set(__self__, "predicted_capacity", predicted_capacity)
        if protect_from_scale_in is not None:
            pulumi.set(__self__, "protect_from_scale_in", protect_from_scale_in)
        if service_linked_role_arn is not None:
            pulumi.set(__self__, "service_linked_role_arn", service_linked_role_arn)
        if suspended_processes is not None:
            pulumi.set(__self__, "suspended_processes", suspended_processes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_group_arns is not None:
            pulumi.set(__self__, "target_group_arns", target_group_arns)
        if termination_policies is not None:
            pulumi.set(__self__, "termination_policies", termination_policies)
        if traffic_sources is not None:
            pulumi.set(__self__, "traffic_sources", traffic_sources)
        if vpc_zone_identifiers is not None:
            pulumi.set(__self__, "vpc_zone_identifiers", vpc_zone_identifiers)
        if wait_for_capacity_timeout is not None:
            pulumi.set(__self__, "wait_for_capacity_timeout", wait_for_capacity_timeout)
        if wait_for_elb_capacity is not None:
            pulumi.set(__self__, "wait_for_elb_capacity", wait_for_elb_capacity)
        if warm_pool is not None:
            pulumi.set(__self__, "warm_pool", warm_pool)
        if warm_pool_size is not None:
            pulumi.set(__self__, "warm_pool_size", warm_pool_size)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN for this Auto Scaling Group
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="availabilityZoneDistribution")
    def availability_zone_distribution(self) -> Optional[pulumi.Input['GroupAvailabilityZoneDistributionArgs']]:
        """
        The instance capacity distribution across Availability Zones. See Availability Zone Distribution below for more details.
        """
        return pulumi.get(self, "availability_zone_distribution")

    @availability_zone_distribution.setter
    def availability_zone_distribution(self, value: Optional[pulumi.Input['GroupAvailabilityZoneDistributionArgs']]):
        pulumi.set(self, "availability_zone_distribution", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="capacityRebalance")
    def capacity_rebalance(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether capacity rebalance is enabled. Otherwise, capacity rebalance is disabled.
        """
        return pulumi.get(self, "capacity_rebalance")

    @capacity_rebalance.setter
    def capacity_rebalance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "capacity_rebalance", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[str]]:
        """
        Reserved.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="defaultCooldown")
    def default_cooldown(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
        """
        return pulumi.get(self, "default_cooldown")

    @default_cooldown.setter
    def default_cooldown(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_cooldown", value)

    @property
    @pulumi.getter(name="defaultInstanceWarmup")
    def default_instance_warmup(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the InService state. (See [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html))
        """
        return pulumi.get(self, "default_instance_warmup")

    @default_instance_warmup.setter
    def default_instance_warmup(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_instance_warmup", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Number of Amazon EC2 instances that
        should be running in the group. (See also Waiting for
        Capacity below.)
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="desiredCapacityType")
    def desired_capacity_type(self) -> Optional[pulumi.Input[str]]:
        """
        The unit of measurement for the value specified for `desired_capacity`. Supported for attribute-based instance type selection only. Valid values: `"units"`, `"vcpu"`, `"memory-mib"`.
        """
        return pulumi.get(self, "desired_capacity_type")

    @desired_capacity_type.setter
    def desired_capacity_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desired_capacity_type", value)

    @property
    @pulumi.getter(name="enabledMetrics")
    def enabled_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
        """
        return pulumi.get(self, "enabled_metrics")

    @enabled_metrics.setter
    def enabled_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_metrics", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows deleting the Auto Scaling Group without waiting
        for all instances in the pool to terminate. You can force an Auto Scaling Group to delete
        even if it's in the process of scaling a resource. Normally, this provider
        drains all the instances before deleting the group. This bypasses that
        behavior and potentially leaves resources dangling.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="forceDeleteWarmPool")
    def force_delete_warm_pool(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows deleting the Auto Scaling Group without waiting for all instances in the warm pool to terminate.
        """
        return pulumi.get(self, "force_delete_warm_pool")

    @force_delete_warm_pool.setter
    def force_delete_warm_pool(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete_warm_pool", value)

    @property
    @pulumi.getter(name="healthCheckGracePeriod")
    def health_check_grace_period(self) -> Optional[pulumi.Input[int]]:
        """
        Time (in seconds) after instance comes into service before checking health.
        """
        return pulumi.get(self, "health_check_grace_period")

    @health_check_grace_period.setter
    def health_check_grace_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_grace_period", value)

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[pulumi.Input[str]]:
        """
        "EC2" or "ELB". Controls how health checking is done.
        """
        return pulumi.get(self, "health_check_type")

    @health_check_type.setter
    def health_check_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_type", value)

    @property
    @pulumi.getter(name="ignoreFailedScalingActivities")
    def ignore_failed_scaling_activities(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to ignore failed [Auto Scaling scaling activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html) while waiting for capacity. The default is `false` -- failed scaling activities cause errors to be returned.
        """
        return pulumi.get(self, "ignore_failed_scaling_activities")

    @ignore_failed_scaling_activities.setter
    def ignore_failed_scaling_activities(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_failed_scaling_activities", value)

    @property
    @pulumi.getter(name="initialLifecycleHooks")
    def initial_lifecycle_hooks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupInitialLifecycleHookArgs']]]]:
        """
        One or more
        [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
        to attach to the Auto Scaling Group **before** instances are launched. The
        syntax is exactly the same as the separate
        `autoscaling.LifecycleHook`
        resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
        a new Auto Scaling Group. For all other use-cases, please use `autoscaling.LifecycleHook` resource.
        """
        return pulumi.get(self, "initial_lifecycle_hooks")

    @initial_lifecycle_hooks.setter
    def initial_lifecycle_hooks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupInitialLifecycleHookArgs']]]]):
        pulumi.set(self, "initial_lifecycle_hooks", value)

    @property
    @pulumi.getter(name="instanceMaintenancePolicy")
    def instance_maintenance_policy(self) -> Optional[pulumi.Input['GroupInstanceMaintenancePolicyArgs']]:
        """
        If this block is configured, add a instance maintenance policy to the specified Auto Scaling group. Defined below.
        """
        return pulumi.get(self, "instance_maintenance_policy")

    @instance_maintenance_policy.setter
    def instance_maintenance_policy(self, value: Optional[pulumi.Input['GroupInstanceMaintenancePolicyArgs']]):
        pulumi.set(self, "instance_maintenance_policy", value)

    @property
    @pulumi.getter(name="instanceRefresh")
    def instance_refresh(self) -> Optional[pulumi.Input['GroupInstanceRefreshArgs']]:
        """
        If this block is configured, start an
        [Instance Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
        when this Auto Scaling Group is updated. Defined below.
        """
        return pulumi.get(self, "instance_refresh")

    @instance_refresh.setter
    def instance_refresh(self, value: Optional[pulumi.Input['GroupInstanceRefreshArgs']]):
        pulumi.set(self, "instance_refresh", value)

    @property
    @pulumi.getter(name="launchConfiguration")
    def launch_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the launch configuration to use.
        """
        return pulumi.get(self, "launch_configuration")

    @launch_configuration.setter
    def launch_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_configuration", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['GroupLaunchTemplateArgs']]:
        """
        Nested argument with Launch template specification to use to launch instances. See Launch Template below for more details.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['GroupLaunchTemplateArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of elastic load balancer names to add to the autoscaling
        group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter(name="maxInstanceLifetime")
    def max_instance_lifetime(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum amount of time, in seconds, that an instance can be in service, values must be either equal to 0 or between 86400 and 31536000 seconds.
        """
        return pulumi.get(self, "max_instance_lifetime")

    @max_instance_lifetime.setter
    def max_instance_lifetime(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instance_lifetime", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum size of the Auto Scaling Group.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="metricsGranularity")
    def metrics_granularity(self) -> Optional[pulumi.Input[Union[str, 'MetricsGranularity']]]:
        """
        Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
        """
        return pulumi.get(self, "metrics_granularity")

    @metrics_granularity.setter
    def metrics_granularity(self, value: Optional[pulumi.Input[Union[str, 'MetricsGranularity']]]):
        pulumi.set(self, "metrics_granularity", value)

    @property
    @pulumi.getter(name="minElbCapacity")
    def min_elb_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Setting this causes Pulumi to wait for
        this number of instances from this Auto Scaling Group to show up healthy in the
        ELB only on creation. Updates will not wait on ELB instance number changes.
        (See also Waiting for Capacity below.)
        """
        return pulumi.get(self, "min_elb_capacity")

    @min_elb_capacity.setter
    def min_elb_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_elb_capacity", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum size of the Auto Scaling Group.
        (See also Waiting for Capacity below.)
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="mixedInstancesPolicy")
    def mixed_instances_policy(self) -> Optional[pulumi.Input['GroupMixedInstancesPolicyArgs']]:
        """
        Configuration block containing settings to define launch targets for Auto Scaling groups. See Mixed Instances Policy below for more details.
        """
        return pulumi.get(self, "mixed_instances_policy")

    @mixed_instances_policy.setter
    def mixed_instances_policy(self, value: Optional[pulumi.Input['GroupMixedInstancesPolicyArgs']]):
        pulumi.set(self, "mixed_instances_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique name beginning with the specified
        prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the placement group into which you'll launch your instances, if any.
        """
        return pulumi.get(self, "placement_group")

    @placement_group.setter
    def placement_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_group", value)

    @property
    @pulumi.getter(name="predictedCapacity")
    def predicted_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Predicted capacity of the group.
        """
        return pulumi.get(self, "predicted_capacity")

    @predicted_capacity.setter
    def predicted_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "predicted_capacity", value)

    @property
    @pulumi.getter(name="protectFromScaleIn")
    def protect_from_scale_in(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether newly launched instances
        are automatically protected from termination by Amazon EC2 Auto Scaling when
        scaling in. For more information about preventing instances from terminating
        on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
        in the Amazon EC2 Auto Scaling User Guide.
        """
        return pulumi.get(self, "protect_from_scale_in")

    @protect_from_scale_in.setter
    def protect_from_scale_in(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "protect_from_scale_in", value)

    @property
    @pulumi.getter(name="serviceLinkedRoleArn")
    def service_linked_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        ARN of the service-linked role that the ASG will use to call other AWS services
        """
        return pulumi.get(self, "service_linked_role_arn")

    @service_linked_role_arn.setter
    def service_linked_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_linked_role_arn", value)

    @property
    @pulumi.getter(name="suspendedProcesses")
    def suspended_processes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
        Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
        """
        return pulumi.get(self, "suspended_processes")

    @suspended_processes.setter
    def suspended_processes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "suspended_processes", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupTagArgs']]]]:
        """
        Configuration block(s) containing resource tags. See Tag below for more details.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetGroupArns")
    def target_group_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of `alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
        """
        return pulumi.get(self, "target_group_arns")

    @target_group_arns.setter
    def target_group_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "target_group_arns", value)

    @property
    @pulumi.getter(name="terminationPolicies")
    def termination_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
        """
        return pulumi.get(self, "termination_policies")

    @termination_policies.setter
    def termination_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "termination_policies", value)

    @property
    @pulumi.getter(name="trafficSources")
    def traffic_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupTrafficSourceArgs']]]]:
        """
        Attaches one or more traffic sources to the specified Auto Scaling group.
        """
        return pulumi.get(self, "traffic_sources")

    @traffic_sources.setter
    def traffic_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupTrafficSourceArgs']]]]):
        pulumi.set(self, "traffic_sources", value)

    @property
    @pulumi.getter(name="vpcZoneIdentifiers")
    def vpc_zone_identifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
        """
        return pulumi.get(self, "vpc_zone_identifiers")

    @vpc_zone_identifiers.setter
    def vpc_zone_identifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_zone_identifiers", value)

    @property
    @pulumi.getter(name="waitForCapacityTimeout")
    def wait_for_capacity_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum
        [duration](https://golang.org/pkg/time/#ParseDuration) that the provider should
        wait for ASG instances to be healthy before timing out. (See also Waiting
        for Capacity below.) Setting this to "0" causes
        the provider to skip all Capacity Waiting behavior.
        """
        return pulumi.get(self, "wait_for_capacity_timeout")

    @wait_for_capacity_timeout.setter
    def wait_for_capacity_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wait_for_capacity_timeout", value)

    @property
    @pulumi.getter(name="waitForElbCapacity")
    def wait_for_elb_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Setting this will cause Pulumi to wait
        for exactly this number of healthy instances from this Auto Scaling Group in
        all attached load balancers on both create and update operations. (Takes
        precedence over `min_elb_capacity` behavior.)
        (See also Waiting for Capacity below.)
        """
        return pulumi.get(self, "wait_for_elb_capacity")

    @wait_for_elb_capacity.setter
    def wait_for_elb_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "wait_for_elb_capacity", value)

    @property
    @pulumi.getter(name="warmPool")
    def warm_pool(self) -> Optional[pulumi.Input['GroupWarmPoolArgs']]:
        """
        If this block is configured, add a [Warm Pool](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
        to the specified Auto Scaling group. Defined below
        """
        return pulumi.get(self, "warm_pool")

    @warm_pool.setter
    def warm_pool(self, value: Optional[pulumi.Input['GroupWarmPoolArgs']]):
        pulumi.set(self, "warm_pool", value)

    @property
    @pulumi.getter(name="warmPoolSize")
    def warm_pool_size(self) -> Optional[pulumi.Input[int]]:
        """
        Current size of the warm pool.
        """
        return pulumi.get(self, "warm_pool_size")

    @warm_pool_size.setter
    def warm_pool_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "warm_pool_size", value)


class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone_distribution: Optional[pulumi.Input[Union['GroupAvailabilityZoneDistributionArgs', 'GroupAvailabilityZoneDistributionArgsDict']]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 capacity_rebalance: Optional[pulumi.Input[bool]] = None,
                 context: Optional[pulumi.Input[str]] = None,
                 default_cooldown: Optional[pulumi.Input[int]] = None,
                 default_instance_warmup: Optional[pulumi.Input[int]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 desired_capacity_type: Optional[pulumi.Input[str]] = None,
                 enabled_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 force_delete_warm_pool: Optional[pulumi.Input[bool]] = None,
                 health_check_grace_period: Optional[pulumi.Input[int]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 ignore_failed_scaling_activities: Optional[pulumi.Input[bool]] = None,
                 initial_lifecycle_hooks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupInitialLifecycleHookArgs', 'GroupInitialLifecycleHookArgsDict']]]]] = None,
                 instance_maintenance_policy: Optional[pulumi.Input[Union['GroupInstanceMaintenancePolicyArgs', 'GroupInstanceMaintenancePolicyArgsDict']]] = None,
                 instance_refresh: Optional[pulumi.Input[Union['GroupInstanceRefreshArgs', 'GroupInstanceRefreshArgsDict']]] = None,
                 launch_configuration: Optional[pulumi.Input[str]] = None,
                 launch_template: Optional[pulumi.Input[Union['GroupLaunchTemplateArgs', 'GroupLaunchTemplateArgsDict']]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_instance_lifetime: Optional[pulumi.Input[int]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 metrics_granularity: Optional[pulumi.Input[Union[str, 'MetricsGranularity']]] = None,
                 min_elb_capacity: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 mixed_instances_policy: Optional[pulumi.Input[Union['GroupMixedInstancesPolicyArgs', 'GroupMixedInstancesPolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 placement_group: Optional[pulumi.Input[str]] = None,
                 protect_from_scale_in: Optional[pulumi.Input[bool]] = None,
                 service_linked_role_arn: Optional[pulumi.Input[str]] = None,
                 suspended_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupTagArgs', 'GroupTagArgsDict']]]]] = None,
                 target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 termination_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 traffic_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupTrafficSourceArgs', 'GroupTrafficSourceArgsDict']]]]] = None,
                 vpc_zone_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wait_for_capacity_timeout: Optional[pulumi.Input[str]] = None,
                 wait_for_elb_capacity: Optional[pulumi.Input[int]] = None,
                 warm_pool: Optional[pulumi.Input[Union['GroupWarmPoolArgs', 'GroupWarmPoolArgsDict']]] = None,
                 __props__=None):
        """
        Provides an Auto Scaling Group resource.

        > **Note:** You must specify either `launch_configuration`, `launch_template`, or `mixed_instances_policy`.

        > **NOTE on Auto Scaling Groups, Attachments and Traffic Source Attachments:** Pulumi provides standalone Attachment (for attaching Classic Load Balancers and Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target groups) and Traffic Source Attachment (for attaching Load Balancers and VPC Lattice target groups) resources and an Auto Scaling Group resource with `load_balancers`, `target_group_arns` and `traffic_source` attributes. Do not use the same traffic source in more than one of these resources. Doing so will cause a conflict of attachments. A `lifecycle` configuration block can be used to suppress differences if necessary.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        test = aws.ec2.PlacementGroup("test",
            name="test",
            strategy=aws.ec2.PlacementStrategy.CLUSTER)
        bar = aws.autoscaling.Group("bar",
            name="foobar3-test",
            max_size=5,
            min_size=2,
            health_check_grace_period=300,
            health_check_type="ELB",
            desired_capacity=4,
            force_delete=True,
            placement_group=test.id,
            launch_configuration=foobar["name"],
            vpc_zone_identifiers=[
                example1["id"],
                example2["id"],
            ],
            instance_maintenance_policy={
                "min_healthy_percentage": 90,
                "max_healthy_percentage": 120,
            },
            initial_lifecycle_hooks=[{
                "name": "foobar",
                "default_result": "CONTINUE",
                "heartbeat_timeout": 2000,
                "lifecycle_transition": "autoscaling:EC2_INSTANCE_LAUNCHING",
                "notification_metadata": json.dumps({
                    "foo": "bar",
                }),
                "notification_target_arn": "arn:aws:sqs:us-east-1:444455556666:queue1*",
                "role_arn": "arn:aws:iam::123456789012:role/S3Access",
            }],
            tags=[
                {
                    "key": "foo",
                    "value": "bar",
                    "propagate_at_launch": True,
                },
                {
                    "key": "lorem",
                    "value": "ipsum",
                    "propagate_at_launch": False,
                },
            ])
        ```

        ### With Latest Version Of Launch Template

        ```python
        import pulumi
        import pulumi_aws as aws

        foobar = aws.ec2.LaunchTemplate("foobar",
            name_prefix="foobar",
            image_id="ami-1a2b3c",
            instance_type="t2.micro")
        bar = aws.autoscaling.Group("bar",
            availability_zones=["us-east-1a"],
            desired_capacity=1,
            max_size=1,
            min_size=1,
            launch_template={
                "id": foobar.id,
                "version": "$Latest",
            })
        ```

        ### Mixed Instances Policy

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.LaunchTemplate("example",
            name_prefix="example",
            image_id=example_aws_ami["id"],
            instance_type="c5.large")
        example_group = aws.autoscaling.Group("example",
            availability_zones=["us-east-1a"],
            desired_capacity=1,
            max_size=1,
            min_size=1,
            mixed_instances_policy={
                "launch_template": {
                    "launch_template_specification": {
                        "launch_template_id": example.id,
                    },
                    "overrides": [
                        {
                            "instance_type": "c4.large",
                            "weighted_capacity": "3",
                        },
                        {
                            "instance_type": "c3.large",
                            "weighted_capacity": "2",
                        },
                    ],
                },
            })
        ```

        ### Mixed Instances Policy with Spot Instances and Capacity Rebalance

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.LaunchTemplate("example",
            name_prefix="example",
            image_id=example_aws_ami["id"],
            instance_type="c5.large")
        example_group = aws.autoscaling.Group("example",
            capacity_rebalance=True,
            desired_capacity=12,
            max_size=15,
            min_size=12,
            vpc_zone_identifiers=[
                example1["id"],
                example2["id"],
            ],
            mixed_instances_policy={
                "instances_distribution": {
                    "on_demand_base_capacity": 0,
                    "on_demand_percentage_above_base_capacity": 25,
                    "spot_allocation_strategy": "capacity-optimized",
                },
                "launch_template": {
                    "launch_template_specification": {
                        "launch_template_id": example.id,
                    },
                    "overrides": [
                        {
                            "instance_type": "c4.large",
                            "weighted_capacity": "3",
                        },
                        {
                            "instance_type": "c3.large",
                            "weighted_capacity": "2",
                        },
                    ],
                },
            })
        ```

        ### Mixed Instances Policy with Instance level LaunchTemplateSpecification Overrides

        When using a diverse instance set, some instance types might require a launch template with configuration values unique to that instance type such as a different AMI (Graviton2), architecture specific user data script, different EBS configuration, or different networking configuration.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.LaunchTemplate("example",
            name_prefix="example",
            image_id=example_aws_ami["id"],
            instance_type="c5.large")
        example2 = aws.ec2.LaunchTemplate("example2",
            name_prefix="example2",
            image_id=example2_aws_ami["id"])
        example_group = aws.autoscaling.Group("example",
            availability_zones=["us-east-1a"],
            desired_capacity=1,
            max_size=1,
            min_size=1,
            mixed_instances_policy={
                "launch_template": {
                    "launch_template_specification": {
                        "launch_template_id": example.id,
                    },
                    "overrides": [
                        {
                            "instance_type": "c4.large",
                            "weighted_capacity": "3",
                        },
                        {
                            "instance_type": "c6g.large",
                            "launch_template_specification": {
                                "launch_template_id": example2.id,
                            },
                            "weighted_capacity": "2",
                        },
                    ],
                },
            })
        ```

        ### Mixed Instances Policy with Attribute-based Instance Type Selection

        As an alternative to manually choosing instance types when creating a mixed instances group, you can specify a set of instance attributes that describe your compute requirements.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.LaunchTemplate("example",
            name_prefix="example",
            image_id=example_aws_ami["id"],
            instance_type="c5.large")
        example_group = aws.autoscaling.Group("example",
            availability_zones=["us-east-1a"],
            desired_capacity=1,
            max_size=1,
            min_size=1,
            mixed_instances_policy={
                "launch_template": {
                    "launch_template_specification": {
                        "launch_template_id": example.id,
                    },
                    "overrides": [{
                        "instance_requirements": {
                            "memory_mib": {
                                "min": 1000,
                            },
                            "vcpu_count": {
                                "min": 4,
                            },
                        },
                    }],
                },
            })
        ```

        ### Dynamic tagging

        ```python
        import pulumi
        import pulumi_aws as aws

        config = pulumi.Config()
        extra_tags = config.get_object("extraTags")
        if extra_tags is None:
            extra_tags = [
                {
                    "key": "Foo",
                    "propagateAtLaunch": True,
                    "value": "Bar",
                },
                {
                    "key": "Baz",
                    "propagateAtLaunch": True,
                    "value": "Bam",
                },
            ]
        test = aws.autoscaling.Group("test",
            tags=[
                {
                    "key": "explicit1",
                    "value": "value1",
                    "propagate_at_launch": True,
                },
                {
                    "key": "explicit2",
                    "value": "value2",
                    "propagate_at_launch": True,
                },
            ],
            name="foobar3-test",
            max_size=5,
            min_size=2,
            launch_configuration=foobar["name"],
            vpc_zone_identifiers=[
                example1["id"],
                example2["id"],
            ])
        ```

        ### Automatically refresh all instances after the group is updated

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.get_ami(most_recent=True,
            owners=["amazon"],
            filters=[{
                "name": "name",
                "values": ["amzn-ami-hvm-*-x86_64-gp2"],
            }])
        example_launch_template = aws.ec2.LaunchTemplate("example",
            image_id=example.id,
            instance_type="t3.nano")
        example_group = aws.autoscaling.Group("example",
            availability_zones=["us-east-1a"],
            desired_capacity=1,
            max_size=2,
            min_size=1,
            launch_template={
                "id": example_launch_template.id,
                "version": example_launch_template.latest_version,
            },
            tags=[{
                "key": "Key",
                "value": "Value",
                "propagate_at_launch": True,
            }],
            instance_refresh={
                "strategy": "Rolling",
                "preferences": {
                    "min_healthy_percentage": 50,
                },
                "triggers": ["tag"],
            })
        ```

        ### Auto Scaling group with Warm Pool

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.LaunchTemplate("example",
            name_prefix="example",
            image_id=example_aws_ami["id"],
            instance_type="c5.large")
        example_group = aws.autoscaling.Group("example",
            availability_zones=["us-east-1a"],
            desired_capacity=1,
            max_size=5,
            min_size=1,
            warm_pool={
                "pool_state": "Hibernated",
                "min_size": 1,
                "max_group_prepared_capacity": 10,
                "instance_reuse_policy": {
                    "reuse_on_scale_in": True,
                },
            })
        ```

        ### Auto Scaling group with Traffic Sources

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.autoscaling.Group("test",
            traffic_sources=[{
                "identifier": entry["value"]["arn"],
                "type": "vpc-lattice",
            } for entry in [{"key": k, "value": v} for k, v in [__item for __item in test_aws_vpclattice_target_group]]],
            vpc_zone_identifiers=test_aws_subnet["id"],
            max_size=1,
            min_size=1,
            force_delete=True)
        ```

        ## Waiting for Capacity

        A newly-created ASG is initially empty and begins to scale to `min_size` (or
        `desired_capacity`, if specified) by launching instances using the provided
        Launch Configuration. These instances take time to launch and boot.

        On ASG Update, changes to these values also take time to result in the target
        number of instances providing service.

        This provider provides two mechanisms to help consistently manage ASG scale up
        time across dependent resources.

        #### Waiting for ASG Capacity

        The first is default behavior. This provider waits after ASG creation for
        `min_size` (or `desired_capacity`, if specified) healthy instances to show up
        in the ASG before continuing.

        If `min_size` or `desired_capacity` are changed in a subsequent update,
        this provider will also wait for the correct number of healthy instances before
        continuing.

        This provider considers an instance "healthy" when the ASG reports `HealthStatus:
        "Healthy"` and `LifecycleState: "InService"`. See the [AWS AutoScaling
        Docs](https://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingGroupLifecycle.html)
        for more information on an ASG's lifecycle.

        This provider will wait for healthy instances for up to
        `wait_for_capacity_timeout`. If ASG creation is taking more than a few minutes,
        it's worth investigating for scaling activity errors, which can be caused by
        problems with the selected Launch Configuration.

        Setting `wait_for_capacity_timeout` to `"0"` disables ASG Capacity waiting.

        #### Waiting for ELB Capacity

        The second mechanism is optional, and affects ASGs with attached ELBs specified
        via the `load_balancers` attribute or with ALBs specified with `target_group_arns`.

        The `min_elb_capacity` parameter causes the provider to wait for at least the
        requested number of instances to show up `"InService"` in all attached ELBs
        during ASG creation. It has no effect on ASG updates.

        If `wait_for_elb_capacity` is set, the provider will wait for exactly that number
        of Instances to be `"InService"` in all attached ELBs on both creation and
        updates.

        These parameters can be used to ensure that service is being provided before
        the provider moves on. If new instances don't pass the ELB's health checks for any
        reason, the apply will time out, and the ASG will be marked as
        tainted (i.e., marked to be destroyed in a follow up run).

        As with ASG Capacity, the provider will wait for up to `wait_for_capacity_timeout`
        for the proper number of instances to be healthy.

        #### Troubleshooting Capacity Waiting Timeouts

        If ASG creation takes more than a few minutes, this could indicate one of a
        number of configuration problems. See the [AWS Docs on Load Balancer
        Troubleshooting](https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-troubleshooting.html)
        for more information.

        ## Import

        Using `pulumi import`, import Auto Scaling Groups using the `name`. For example:

        ```sh
        $ pulumi import aws:autoscaling/group:Group web web-asg
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GroupAvailabilityZoneDistributionArgs', 'GroupAvailabilityZoneDistributionArgsDict']] availability_zone_distribution: The instance capacity distribution across Availability Zones. See Availability Zone Distribution below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
        :param pulumi.Input[bool] capacity_rebalance: Whether capacity rebalance is enabled. Otherwise, capacity rebalance is disabled.
        :param pulumi.Input[str] context: Reserved.
        :param pulumi.Input[int] default_cooldown: Amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
        :param pulumi.Input[int] default_instance_warmup: Amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the InService state. (See [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html))
        :param pulumi.Input[int] desired_capacity: Number of Amazon EC2 instances that
               should be running in the group. (See also Waiting for
               Capacity below.)
        :param pulumi.Input[str] desired_capacity_type: The unit of measurement for the value specified for `desired_capacity`. Supported for attribute-based instance type selection only. Valid values: `"units"`, `"vcpu"`, `"memory-mib"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_metrics: List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
        :param pulumi.Input[bool] force_delete: Allows deleting the Auto Scaling Group without waiting
               for all instances in the pool to terminate. You can force an Auto Scaling Group to delete
               even if it's in the process of scaling a resource. Normally, this provider
               drains all the instances before deleting the group. This bypasses that
               behavior and potentially leaves resources dangling.
        :param pulumi.Input[bool] force_delete_warm_pool: Allows deleting the Auto Scaling Group without waiting for all instances in the warm pool to terminate.
        :param pulumi.Input[int] health_check_grace_period: Time (in seconds) after instance comes into service before checking health.
        :param pulumi.Input[str] health_check_type: "EC2" or "ELB". Controls how health checking is done.
        :param pulumi.Input[bool] ignore_failed_scaling_activities: Whether to ignore failed [Auto Scaling scaling activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html) while waiting for capacity. The default is `false` -- failed scaling activities cause errors to be returned.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupInitialLifecycleHookArgs', 'GroupInitialLifecycleHookArgsDict']]]] initial_lifecycle_hooks: One or more
               [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
               to attach to the Auto Scaling Group **before** instances are launched. The
               syntax is exactly the same as the separate
               `autoscaling.LifecycleHook`
               resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
               a new Auto Scaling Group. For all other use-cases, please use `autoscaling.LifecycleHook` resource.
        :param pulumi.Input[Union['GroupInstanceMaintenancePolicyArgs', 'GroupInstanceMaintenancePolicyArgsDict']] instance_maintenance_policy: If this block is configured, add a instance maintenance policy to the specified Auto Scaling group. Defined below.
        :param pulumi.Input[Union['GroupInstanceRefreshArgs', 'GroupInstanceRefreshArgsDict']] instance_refresh: If this block is configured, start an
               [Instance Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
               when this Auto Scaling Group is updated. Defined below.
        :param pulumi.Input[str] launch_configuration: Name of the launch configuration to use.
        :param pulumi.Input[Union['GroupLaunchTemplateArgs', 'GroupLaunchTemplateArgsDict']] launch_template: Nested argument with Launch template specification to use to launch instances. See Launch Template below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] load_balancers: List of elastic load balancer names to add to the autoscaling
               group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
        :param pulumi.Input[int] max_instance_lifetime: Maximum amount of time, in seconds, that an instance can be in service, values must be either equal to 0 or between 86400 and 31536000 seconds.
        :param pulumi.Input[int] max_size: Maximum size of the Auto Scaling Group.
        :param pulumi.Input[Union[str, 'MetricsGranularity']] metrics_granularity: Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
        :param pulumi.Input[int] min_elb_capacity: Setting this causes Pulumi to wait for
               this number of instances from this Auto Scaling Group to show up healthy in the
               ELB only on creation. Updates will not wait on ELB instance number changes.
               (See also Waiting for Capacity below.)
        :param pulumi.Input[int] min_size: Minimum size of the Auto Scaling Group.
               (See also Waiting for Capacity below.)
        :param pulumi.Input[Union['GroupMixedInstancesPolicyArgs', 'GroupMixedInstancesPolicyArgsDict']] mixed_instances_policy: Configuration block containing settings to define launch targets for Auto Scaling groups. See Mixed Instances Policy below for more details.
        :param pulumi.Input[str] name: Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`.
        :param pulumi.Input[str] placement_group: Name of the placement group into which you'll launch your instances, if any.
        :param pulumi.Input[bool] protect_from_scale_in: Whether newly launched instances
               are automatically protected from termination by Amazon EC2 Auto Scaling when
               scaling in. For more information about preventing instances from terminating
               on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
               in the Amazon EC2 Auto Scaling User Guide.
        :param pulumi.Input[str] service_linked_role_arn: ARN of the service-linked role that the ASG will use to call other AWS services
        :param pulumi.Input[Sequence[pulumi.Input[str]]] suspended_processes: List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
               Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupTagArgs', 'GroupTagArgsDict']]]] tags: Configuration block(s) containing resource tags. See Tag below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_group_arns: Set of `alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] termination_policies: List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupTrafficSourceArgs', 'GroupTrafficSourceArgsDict']]]] traffic_sources: Attaches one or more traffic sources to the specified Auto Scaling group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_zone_identifiers: List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
        :param pulumi.Input[str] wait_for_capacity_timeout: Maximum
               [duration](https://golang.org/pkg/time/#ParseDuration) that the provider should
               wait for ASG instances to be healthy before timing out. (See also Waiting
               for Capacity below.) Setting this to "0" causes
               the provider to skip all Capacity Waiting behavior.
        :param pulumi.Input[int] wait_for_elb_capacity: Setting this will cause Pulumi to wait
               for exactly this number of healthy instances from this Auto Scaling Group in
               all attached load balancers on both create and update operations. (Takes
               precedence over `min_elb_capacity` behavior.)
               (See also Waiting for Capacity below.)
        :param pulumi.Input[Union['GroupWarmPoolArgs', 'GroupWarmPoolArgsDict']] warm_pool: If this block is configured, add a [Warm Pool](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
               to the specified Auto Scaling group. Defined below
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Auto Scaling Group resource.

        > **Note:** You must specify either `launch_configuration`, `launch_template`, or `mixed_instances_policy`.

        > **NOTE on Auto Scaling Groups, Attachments and Traffic Source Attachments:** Pulumi provides standalone Attachment (for attaching Classic Load Balancers and Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target groups) and Traffic Source Attachment (for attaching Load Balancers and VPC Lattice target groups) resources and an Auto Scaling Group resource with `load_balancers`, `target_group_arns` and `traffic_source` attributes. Do not use the same traffic source in more than one of these resources. Doing so will cause a conflict of attachments. A `lifecycle` configuration block can be used to suppress differences if necessary.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        test = aws.ec2.PlacementGroup("test",
            name="test",
            strategy=aws.ec2.PlacementStrategy.CLUSTER)
        bar = aws.autoscaling.Group("bar",
            name="foobar3-test",
            max_size=5,
            min_size=2,
            health_check_grace_period=300,
            health_check_type="ELB",
            desired_capacity=4,
            force_delete=True,
            placement_group=test.id,
            launch_configuration=foobar["name"],
            vpc_zone_identifiers=[
                example1["id"],
                example2["id"],
            ],
            instance_maintenance_policy={
                "min_healthy_percentage": 90,
                "max_healthy_percentage": 120,
            },
            initial_lifecycle_hooks=[{
                "name": "foobar",
                "default_result": "CONTINUE",
                "heartbeat_timeout": 2000,
                "lifecycle_transition": "autoscaling:EC2_INSTANCE_LAUNCHING",
                "notification_metadata": json.dumps({
                    "foo": "bar",
                }),
                "notification_target_arn": "arn:aws:sqs:us-east-1:444455556666:queue1*",
                "role_arn": "arn:aws:iam::123456789012:role/S3Access",
            }],
            tags=[
                {
                    "key": "foo",
                    "value": "bar",
                    "propagate_at_launch": True,
                },
                {
                    "key": "lorem",
                    "value": "ipsum",
                    "propagate_at_launch": False,
                },
            ])
        ```

        ### With Latest Version Of Launch Template

        ```python
        import pulumi
        import pulumi_aws as aws

        foobar = aws.ec2.LaunchTemplate("foobar",
            name_prefix="foobar",
            image_id="ami-1a2b3c",
            instance_type="t2.micro")
        bar = aws.autoscaling.Group("bar",
            availability_zones=["us-east-1a"],
            desired_capacity=1,
            max_size=1,
            min_size=1,
            launch_template={
                "id": foobar.id,
                "version": "$Latest",
            })
        ```

        ### Mixed Instances Policy

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.LaunchTemplate("example",
            name_prefix="example",
            image_id=example_aws_ami["id"],
            instance_type="c5.large")
        example_group = aws.autoscaling.Group("example",
            availability_zones=["us-east-1a"],
            desired_capacity=1,
            max_size=1,
            min_size=1,
            mixed_instances_policy={
                "launch_template": {
                    "launch_template_specification": {
                        "launch_template_id": example.id,
                    },
                    "overrides": [
                        {
                            "instance_type": "c4.large",
                            "weighted_capacity": "3",
                        },
                        {
                            "instance_type": "c3.large",
                            "weighted_capacity": "2",
                        },
                    ],
                },
            })
        ```

        ### Mixed Instances Policy with Spot Instances and Capacity Rebalance

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.LaunchTemplate("example",
            name_prefix="example",
            image_id=example_aws_ami["id"],
            instance_type="c5.large")
        example_group = aws.autoscaling.Group("example",
            capacity_rebalance=True,
            desired_capacity=12,
            max_size=15,
            min_size=12,
            vpc_zone_identifiers=[
                example1["id"],
                example2["id"],
            ],
            mixed_instances_policy={
                "instances_distribution": {
                    "on_demand_base_capacity": 0,
                    "on_demand_percentage_above_base_capacity": 25,
                    "spot_allocation_strategy": "capacity-optimized",
                },
                "launch_template": {
                    "launch_template_specification": {
                        "launch_template_id": example.id,
                    },
                    "overrides": [
                        {
                            "instance_type": "c4.large",
                            "weighted_capacity": "3",
                        },
                        {
                            "instance_type": "c3.large",
                            "weighted_capacity": "2",
                        },
                    ],
                },
            })
        ```

        ### Mixed Instances Policy with Instance level LaunchTemplateSpecification Overrides

        When using a diverse instance set, some instance types might require a launch template with configuration values unique to that instance type such as a different AMI (Graviton2), architecture specific user data script, different EBS configuration, or different networking configuration.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.LaunchTemplate("example",
            name_prefix="example",
            image_id=example_aws_ami["id"],
            instance_type="c5.large")
        example2 = aws.ec2.LaunchTemplate("example2",
            name_prefix="example2",
            image_id=example2_aws_ami["id"])
        example_group = aws.autoscaling.Group("example",
            availability_zones=["us-east-1a"],
            desired_capacity=1,
            max_size=1,
            min_size=1,
            mixed_instances_policy={
                "launch_template": {
                    "launch_template_specification": {
                        "launch_template_id": example.id,
                    },
                    "overrides": [
                        {
                            "instance_type": "c4.large",
                            "weighted_capacity": "3",
                        },
                        {
                            "instance_type": "c6g.large",
                            "launch_template_specification": {
                                "launch_template_id": example2.id,
                            },
                            "weighted_capacity": "2",
                        },
                    ],
                },
            })
        ```

        ### Mixed Instances Policy with Attribute-based Instance Type Selection

        As an alternative to manually choosing instance types when creating a mixed instances group, you can specify a set of instance attributes that describe your compute requirements.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.LaunchTemplate("example",
            name_prefix="example",
            image_id=example_aws_ami["id"],
            instance_type="c5.large")
        example_group = aws.autoscaling.Group("example",
            availability_zones=["us-east-1a"],
            desired_capacity=1,
            max_size=1,
            min_size=1,
            mixed_instances_policy={
                "launch_template": {
                    "launch_template_specification": {
                        "launch_template_id": example.id,
                    },
                    "overrides": [{
                        "instance_requirements": {
                            "memory_mib": {
                                "min": 1000,
                            },
                            "vcpu_count": {
                                "min": 4,
                            },
                        },
                    }],
                },
            })
        ```

        ### Dynamic tagging

        ```python
        import pulumi
        import pulumi_aws as aws

        config = pulumi.Config()
        extra_tags = config.get_object("extraTags")
        if extra_tags is None:
            extra_tags = [
                {
                    "key": "Foo",
                    "propagateAtLaunch": True,
                    "value": "Bar",
                },
                {
                    "key": "Baz",
                    "propagateAtLaunch": True,
                    "value": "Bam",
                },
            ]
        test = aws.autoscaling.Group("test",
            tags=[
                {
                    "key": "explicit1",
                    "value": "value1",
                    "propagate_at_launch": True,
                },
                {
                    "key": "explicit2",
                    "value": "value2",
                    "propagate_at_launch": True,
                },
            ],
            name="foobar3-test",
            max_size=5,
            min_size=2,
            launch_configuration=foobar["name"],
            vpc_zone_identifiers=[
                example1["id"],
                example2["id"],
            ])
        ```

        ### Automatically refresh all instances after the group is updated

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.get_ami(most_recent=True,
            owners=["amazon"],
            filters=[{
                "name": "name",
                "values": ["amzn-ami-hvm-*-x86_64-gp2"],
            }])
        example_launch_template = aws.ec2.LaunchTemplate("example",
            image_id=example.id,
            instance_type="t3.nano")
        example_group = aws.autoscaling.Group("example",
            availability_zones=["us-east-1a"],
            desired_capacity=1,
            max_size=2,
            min_size=1,
            launch_template={
                "id": example_launch_template.id,
                "version": example_launch_template.latest_version,
            },
            tags=[{
                "key": "Key",
                "value": "Value",
                "propagate_at_launch": True,
            }],
            instance_refresh={
                "strategy": "Rolling",
                "preferences": {
                    "min_healthy_percentage": 50,
                },
                "triggers": ["tag"],
            })
        ```

        ### Auto Scaling group with Warm Pool

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.LaunchTemplate("example",
            name_prefix="example",
            image_id=example_aws_ami["id"],
            instance_type="c5.large")
        example_group = aws.autoscaling.Group("example",
            availability_zones=["us-east-1a"],
            desired_capacity=1,
            max_size=5,
            min_size=1,
            warm_pool={
                "pool_state": "Hibernated",
                "min_size": 1,
                "max_group_prepared_capacity": 10,
                "instance_reuse_policy": {
                    "reuse_on_scale_in": True,
                },
            })
        ```

        ### Auto Scaling group with Traffic Sources

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.autoscaling.Group("test",
            traffic_sources=[{
                "identifier": entry["value"]["arn"],
                "type": "vpc-lattice",
            } for entry in [{"key": k, "value": v} for k, v in [__item for __item in test_aws_vpclattice_target_group]]],
            vpc_zone_identifiers=test_aws_subnet["id"],
            max_size=1,
            min_size=1,
            force_delete=True)
        ```

        ## Waiting for Capacity

        A newly-created ASG is initially empty and begins to scale to `min_size` (or
        `desired_capacity`, if specified) by launching instances using the provided
        Launch Configuration. These instances take time to launch and boot.

        On ASG Update, changes to these values also take time to result in the target
        number of instances providing service.

        This provider provides two mechanisms to help consistently manage ASG scale up
        time across dependent resources.

        #### Waiting for ASG Capacity

        The first is default behavior. This provider waits after ASG creation for
        `min_size` (or `desired_capacity`, if specified) healthy instances to show up
        in the ASG before continuing.

        If `min_size` or `desired_capacity` are changed in a subsequent update,
        this provider will also wait for the correct number of healthy instances before
        continuing.

        This provider considers an instance "healthy" when the ASG reports `HealthStatus:
        "Healthy"` and `LifecycleState: "InService"`. See the [AWS AutoScaling
        Docs](https://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingGroupLifecycle.html)
        for more information on an ASG's lifecycle.

        This provider will wait for healthy instances for up to
        `wait_for_capacity_timeout`. If ASG creation is taking more than a few minutes,
        it's worth investigating for scaling activity errors, which can be caused by
        problems with the selected Launch Configuration.

        Setting `wait_for_capacity_timeout` to `"0"` disables ASG Capacity waiting.

        #### Waiting for ELB Capacity

        The second mechanism is optional, and affects ASGs with attached ELBs specified
        via the `load_balancers` attribute or with ALBs specified with `target_group_arns`.

        The `min_elb_capacity` parameter causes the provider to wait for at least the
        requested number of instances to show up `"InService"` in all attached ELBs
        during ASG creation. It has no effect on ASG updates.

        If `wait_for_elb_capacity` is set, the provider will wait for exactly that number
        of Instances to be `"InService"` in all attached ELBs on both creation and
        updates.

        These parameters can be used to ensure that service is being provided before
        the provider moves on. If new instances don't pass the ELB's health checks for any
        reason, the apply will time out, and the ASG will be marked as
        tainted (i.e., marked to be destroyed in a follow up run).

        As with ASG Capacity, the provider will wait for up to `wait_for_capacity_timeout`
        for the proper number of instances to be healthy.

        #### Troubleshooting Capacity Waiting Timeouts

        If ASG creation takes more than a few minutes, this could indicate one of a
        number of configuration problems. See the [AWS Docs on Load Balancer
        Troubleshooting](https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/elb-troubleshooting.html)
        for more information.

        ## Import

        Using `pulumi import`, import Auto Scaling Groups using the `name`. For example:

        ```sh
        $ pulumi import aws:autoscaling/group:Group web web-asg
        ```

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone_distribution: Optional[pulumi.Input[Union['GroupAvailabilityZoneDistributionArgs', 'GroupAvailabilityZoneDistributionArgsDict']]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 capacity_rebalance: Optional[pulumi.Input[bool]] = None,
                 context: Optional[pulumi.Input[str]] = None,
                 default_cooldown: Optional[pulumi.Input[int]] = None,
                 default_instance_warmup: Optional[pulumi.Input[int]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 desired_capacity_type: Optional[pulumi.Input[str]] = None,
                 enabled_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 force_delete_warm_pool: Optional[pulumi.Input[bool]] = None,
                 health_check_grace_period: Optional[pulumi.Input[int]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 ignore_failed_scaling_activities: Optional[pulumi.Input[bool]] = None,
                 initial_lifecycle_hooks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupInitialLifecycleHookArgs', 'GroupInitialLifecycleHookArgsDict']]]]] = None,
                 instance_maintenance_policy: Optional[pulumi.Input[Union['GroupInstanceMaintenancePolicyArgs', 'GroupInstanceMaintenancePolicyArgsDict']]] = None,
                 instance_refresh: Optional[pulumi.Input[Union['GroupInstanceRefreshArgs', 'GroupInstanceRefreshArgsDict']]] = None,
                 launch_configuration: Optional[pulumi.Input[str]] = None,
                 launch_template: Optional[pulumi.Input[Union['GroupLaunchTemplateArgs', 'GroupLaunchTemplateArgsDict']]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_instance_lifetime: Optional[pulumi.Input[int]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 metrics_granularity: Optional[pulumi.Input[Union[str, 'MetricsGranularity']]] = None,
                 min_elb_capacity: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 mixed_instances_policy: Optional[pulumi.Input[Union['GroupMixedInstancesPolicyArgs', 'GroupMixedInstancesPolicyArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 placement_group: Optional[pulumi.Input[str]] = None,
                 protect_from_scale_in: Optional[pulumi.Input[bool]] = None,
                 service_linked_role_arn: Optional[pulumi.Input[str]] = None,
                 suspended_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupTagArgs', 'GroupTagArgsDict']]]]] = None,
                 target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 termination_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 traffic_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupTrafficSourceArgs', 'GroupTrafficSourceArgsDict']]]]] = None,
                 vpc_zone_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 wait_for_capacity_timeout: Optional[pulumi.Input[str]] = None,
                 wait_for_elb_capacity: Optional[pulumi.Input[int]] = None,
                 warm_pool: Optional[pulumi.Input[Union['GroupWarmPoolArgs', 'GroupWarmPoolArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            __props__.__dict__["availability_zone_distribution"] = availability_zone_distribution
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["capacity_rebalance"] = capacity_rebalance
            __props__.__dict__["context"] = context
            __props__.__dict__["default_cooldown"] = default_cooldown
            __props__.__dict__["default_instance_warmup"] = default_instance_warmup
            __props__.__dict__["desired_capacity"] = desired_capacity
            __props__.__dict__["desired_capacity_type"] = desired_capacity_type
            __props__.__dict__["enabled_metrics"] = enabled_metrics
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["force_delete_warm_pool"] = force_delete_warm_pool
            __props__.__dict__["health_check_grace_period"] = health_check_grace_period
            __props__.__dict__["health_check_type"] = health_check_type
            __props__.__dict__["ignore_failed_scaling_activities"] = ignore_failed_scaling_activities
            __props__.__dict__["initial_lifecycle_hooks"] = initial_lifecycle_hooks
            __props__.__dict__["instance_maintenance_policy"] = instance_maintenance_policy
            __props__.__dict__["instance_refresh"] = instance_refresh
            __props__.__dict__["launch_configuration"] = launch_configuration
            __props__.__dict__["launch_template"] = launch_template
            __props__.__dict__["load_balancers"] = load_balancers
            __props__.__dict__["max_instance_lifetime"] = max_instance_lifetime
            if max_size is None and not opts.urn:
                raise TypeError("Missing required property 'max_size'")
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["metrics_granularity"] = metrics_granularity
            __props__.__dict__["min_elb_capacity"] = min_elb_capacity
            if min_size is None and not opts.urn:
                raise TypeError("Missing required property 'min_size'")
            __props__.__dict__["min_size"] = min_size
            __props__.__dict__["mixed_instances_policy"] = mixed_instances_policy
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["placement_group"] = placement_group
            __props__.__dict__["protect_from_scale_in"] = protect_from_scale_in
            __props__.__dict__["service_linked_role_arn"] = service_linked_role_arn
            __props__.__dict__["suspended_processes"] = suspended_processes
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_group_arns"] = target_group_arns
            __props__.__dict__["termination_policies"] = termination_policies
            __props__.__dict__["traffic_sources"] = traffic_sources
            __props__.__dict__["vpc_zone_identifiers"] = vpc_zone_identifiers
            __props__.__dict__["wait_for_capacity_timeout"] = wait_for_capacity_timeout
            __props__.__dict__["wait_for_elb_capacity"] = wait_for_elb_capacity
            __props__.__dict__["warm_pool"] = warm_pool
            __props__.__dict__["arn"] = None
            __props__.__dict__["predicted_capacity"] = None
            __props__.__dict__["warm_pool_size"] = None
        super(Group, __self__).__init__(
            'aws:autoscaling/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[str]] = None,
            availability_zone_distribution: Optional[pulumi.Input[Union['GroupAvailabilityZoneDistributionArgs', 'GroupAvailabilityZoneDistributionArgsDict']]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            capacity_rebalance: Optional[pulumi.Input[bool]] = None,
            context: Optional[pulumi.Input[str]] = None,
            default_cooldown: Optional[pulumi.Input[int]] = None,
            default_instance_warmup: Optional[pulumi.Input[int]] = None,
            desired_capacity: Optional[pulumi.Input[int]] = None,
            desired_capacity_type: Optional[pulumi.Input[str]] = None,
            enabled_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            force_delete: Optional[pulumi.Input[bool]] = None,
            force_delete_warm_pool: Optional[pulumi.Input[bool]] = None,
            health_check_grace_period: Optional[pulumi.Input[int]] = None,
            health_check_type: Optional[pulumi.Input[str]] = None,
            ignore_failed_scaling_activities: Optional[pulumi.Input[bool]] = None,
            initial_lifecycle_hooks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupInitialLifecycleHookArgs', 'GroupInitialLifecycleHookArgsDict']]]]] = None,
            instance_maintenance_policy: Optional[pulumi.Input[Union['GroupInstanceMaintenancePolicyArgs', 'GroupInstanceMaintenancePolicyArgsDict']]] = None,
            instance_refresh: Optional[pulumi.Input[Union['GroupInstanceRefreshArgs', 'GroupInstanceRefreshArgsDict']]] = None,
            launch_configuration: Optional[pulumi.Input[str]] = None,
            launch_template: Optional[pulumi.Input[Union['GroupLaunchTemplateArgs', 'GroupLaunchTemplateArgsDict']]] = None,
            load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            max_instance_lifetime: Optional[pulumi.Input[int]] = None,
            max_size: Optional[pulumi.Input[int]] = None,
            metrics_granularity: Optional[pulumi.Input[Union[str, 'MetricsGranularity']]] = None,
            min_elb_capacity: Optional[pulumi.Input[int]] = None,
            min_size: Optional[pulumi.Input[int]] = None,
            mixed_instances_policy: Optional[pulumi.Input[Union['GroupMixedInstancesPolicyArgs', 'GroupMixedInstancesPolicyArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_prefix: Optional[pulumi.Input[str]] = None,
            placement_group: Optional[pulumi.Input[str]] = None,
            predicted_capacity: Optional[pulumi.Input[int]] = None,
            protect_from_scale_in: Optional[pulumi.Input[bool]] = None,
            service_linked_role_arn: Optional[pulumi.Input[str]] = None,
            suspended_processes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupTagArgs', 'GroupTagArgsDict']]]]] = None,
            target_group_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            termination_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            traffic_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupTrafficSourceArgs', 'GroupTrafficSourceArgsDict']]]]] = None,
            vpc_zone_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            wait_for_capacity_timeout: Optional[pulumi.Input[str]] = None,
            wait_for_elb_capacity: Optional[pulumi.Input[int]] = None,
            warm_pool: Optional[pulumi.Input[Union['GroupWarmPoolArgs', 'GroupWarmPoolArgsDict']]] = None,
            warm_pool_size: Optional[pulumi.Input[int]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arn: ARN for this Auto Scaling Group
        :param pulumi.Input[Union['GroupAvailabilityZoneDistributionArgs', 'GroupAvailabilityZoneDistributionArgsDict']] availability_zone_distribution: The instance capacity distribution across Availability Zones. See Availability Zone Distribution below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
        :param pulumi.Input[bool] capacity_rebalance: Whether capacity rebalance is enabled. Otherwise, capacity rebalance is disabled.
        :param pulumi.Input[str] context: Reserved.
        :param pulumi.Input[int] default_cooldown: Amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
        :param pulumi.Input[int] default_instance_warmup: Amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the InService state. (See [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html))
        :param pulumi.Input[int] desired_capacity: Number of Amazon EC2 instances that
               should be running in the group. (See also Waiting for
               Capacity below.)
        :param pulumi.Input[str] desired_capacity_type: The unit of measurement for the value specified for `desired_capacity`. Supported for attribute-based instance type selection only. Valid values: `"units"`, `"vcpu"`, `"memory-mib"`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_metrics: List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
        :param pulumi.Input[bool] force_delete: Allows deleting the Auto Scaling Group without waiting
               for all instances in the pool to terminate. You can force an Auto Scaling Group to delete
               even if it's in the process of scaling a resource. Normally, this provider
               drains all the instances before deleting the group. This bypasses that
               behavior and potentially leaves resources dangling.
        :param pulumi.Input[bool] force_delete_warm_pool: Allows deleting the Auto Scaling Group without waiting for all instances in the warm pool to terminate.
        :param pulumi.Input[int] health_check_grace_period: Time (in seconds) after instance comes into service before checking health.
        :param pulumi.Input[str] health_check_type: "EC2" or "ELB". Controls how health checking is done.
        :param pulumi.Input[bool] ignore_failed_scaling_activities: Whether to ignore failed [Auto Scaling scaling activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html) while waiting for capacity. The default is `false` -- failed scaling activities cause errors to be returned.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupInitialLifecycleHookArgs', 'GroupInitialLifecycleHookArgsDict']]]] initial_lifecycle_hooks: One or more
               [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
               to attach to the Auto Scaling Group **before** instances are launched. The
               syntax is exactly the same as the separate
               `autoscaling.LifecycleHook`
               resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
               a new Auto Scaling Group. For all other use-cases, please use `autoscaling.LifecycleHook` resource.
        :param pulumi.Input[Union['GroupInstanceMaintenancePolicyArgs', 'GroupInstanceMaintenancePolicyArgsDict']] instance_maintenance_policy: If this block is configured, add a instance maintenance policy to the specified Auto Scaling group. Defined below.
        :param pulumi.Input[Union['GroupInstanceRefreshArgs', 'GroupInstanceRefreshArgsDict']] instance_refresh: If this block is configured, start an
               [Instance Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
               when this Auto Scaling Group is updated. Defined below.
        :param pulumi.Input[str] launch_configuration: Name of the launch configuration to use.
        :param pulumi.Input[Union['GroupLaunchTemplateArgs', 'GroupLaunchTemplateArgsDict']] launch_template: Nested argument with Launch template specification to use to launch instances. See Launch Template below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] load_balancers: List of elastic load balancer names to add to the autoscaling
               group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
        :param pulumi.Input[int] max_instance_lifetime: Maximum amount of time, in seconds, that an instance can be in service, values must be either equal to 0 or between 86400 and 31536000 seconds.
        :param pulumi.Input[int] max_size: Maximum size of the Auto Scaling Group.
        :param pulumi.Input[Union[str, 'MetricsGranularity']] metrics_granularity: Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
        :param pulumi.Input[int] min_elb_capacity: Setting this causes Pulumi to wait for
               this number of instances from this Auto Scaling Group to show up healthy in the
               ELB only on creation. Updates will not wait on ELB instance number changes.
               (See also Waiting for Capacity below.)
        :param pulumi.Input[int] min_size: Minimum size of the Auto Scaling Group.
               (See also Waiting for Capacity below.)
        :param pulumi.Input[Union['GroupMixedInstancesPolicyArgs', 'GroupMixedInstancesPolicyArgsDict']] mixed_instances_policy: Configuration block containing settings to define launch targets for Auto Scaling groups. See Mixed Instances Policy below for more details.
        :param pulumi.Input[str] name: Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
        :param pulumi.Input[str] name_prefix: Creates a unique name beginning with the specified
               prefix. Conflicts with `name`.
        :param pulumi.Input[str] placement_group: Name of the placement group into which you'll launch your instances, if any.
        :param pulumi.Input[int] predicted_capacity: Predicted capacity of the group.
        :param pulumi.Input[bool] protect_from_scale_in: Whether newly launched instances
               are automatically protected from termination by Amazon EC2 Auto Scaling when
               scaling in. For more information about preventing instances from terminating
               on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
               in the Amazon EC2 Auto Scaling User Guide.
        :param pulumi.Input[str] service_linked_role_arn: ARN of the service-linked role that the ASG will use to call other AWS services
        :param pulumi.Input[Sequence[pulumi.Input[str]]] suspended_processes: List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
               Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupTagArgs', 'GroupTagArgsDict']]]] tags: Configuration block(s) containing resource tags. See Tag below for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] target_group_arns: Set of `alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] termination_policies: List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupTrafficSourceArgs', 'GroupTrafficSourceArgsDict']]]] traffic_sources: Attaches one or more traffic sources to the specified Auto Scaling group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_zone_identifiers: List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
        :param pulumi.Input[str] wait_for_capacity_timeout: Maximum
               [duration](https://golang.org/pkg/time/#ParseDuration) that the provider should
               wait for ASG instances to be healthy before timing out. (See also Waiting
               for Capacity below.) Setting this to "0" causes
               the provider to skip all Capacity Waiting behavior.
        :param pulumi.Input[int] wait_for_elb_capacity: Setting this will cause Pulumi to wait
               for exactly this number of healthy instances from this Auto Scaling Group in
               all attached load balancers on both create and update operations. (Takes
               precedence over `min_elb_capacity` behavior.)
               (See also Waiting for Capacity below.)
        :param pulumi.Input[Union['GroupWarmPoolArgs', 'GroupWarmPoolArgsDict']] warm_pool: If this block is configured, add a [Warm Pool](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
               to the specified Auto Scaling group. Defined below
        :param pulumi.Input[int] warm_pool_size: Current size of the warm pool.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["availability_zone_distribution"] = availability_zone_distribution
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["capacity_rebalance"] = capacity_rebalance
        __props__.__dict__["context"] = context
        __props__.__dict__["default_cooldown"] = default_cooldown
        __props__.__dict__["default_instance_warmup"] = default_instance_warmup
        __props__.__dict__["desired_capacity"] = desired_capacity
        __props__.__dict__["desired_capacity_type"] = desired_capacity_type
        __props__.__dict__["enabled_metrics"] = enabled_metrics
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["force_delete_warm_pool"] = force_delete_warm_pool
        __props__.__dict__["health_check_grace_period"] = health_check_grace_period
        __props__.__dict__["health_check_type"] = health_check_type
        __props__.__dict__["ignore_failed_scaling_activities"] = ignore_failed_scaling_activities
        __props__.__dict__["initial_lifecycle_hooks"] = initial_lifecycle_hooks
        __props__.__dict__["instance_maintenance_policy"] = instance_maintenance_policy
        __props__.__dict__["instance_refresh"] = instance_refresh
        __props__.__dict__["launch_configuration"] = launch_configuration
        __props__.__dict__["launch_template"] = launch_template
        __props__.__dict__["load_balancers"] = load_balancers
        __props__.__dict__["max_instance_lifetime"] = max_instance_lifetime
        __props__.__dict__["max_size"] = max_size
        __props__.__dict__["metrics_granularity"] = metrics_granularity
        __props__.__dict__["min_elb_capacity"] = min_elb_capacity
        __props__.__dict__["min_size"] = min_size
        __props__.__dict__["mixed_instances_policy"] = mixed_instances_policy
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["placement_group"] = placement_group
        __props__.__dict__["predicted_capacity"] = predicted_capacity
        __props__.__dict__["protect_from_scale_in"] = protect_from_scale_in
        __props__.__dict__["service_linked_role_arn"] = service_linked_role_arn
        __props__.__dict__["suspended_processes"] = suspended_processes
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_group_arns"] = target_group_arns
        __props__.__dict__["termination_policies"] = termination_policies
        __props__.__dict__["traffic_sources"] = traffic_sources
        __props__.__dict__["vpc_zone_identifiers"] = vpc_zone_identifiers
        __props__.__dict__["wait_for_capacity_timeout"] = wait_for_capacity_timeout
        __props__.__dict__["wait_for_elb_capacity"] = wait_for_elb_capacity
        __props__.__dict__["warm_pool"] = warm_pool
        __props__.__dict__["warm_pool_size"] = warm_pool_size
        return Group(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN for this Auto Scaling Group
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="availabilityZoneDistribution")
    def availability_zone_distribution(self) -> pulumi.Output['outputs.GroupAvailabilityZoneDistribution']:
        """
        The instance capacity distribution across Availability Zones. See Availability Zone Distribution below for more details.
        """
        return pulumi.get(self, "availability_zone_distribution")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of Availability Zones where instances in the Auto Scaling group can be created. Used for launching into the default VPC subnet in each Availability Zone when not using the `vpc_zone_identifier` attribute, or for attaching a network interface when an existing network interface ID is specified in a launch template. Conflicts with `vpc_zone_identifier`.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="capacityRebalance")
    def capacity_rebalance(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether capacity rebalance is enabled. Otherwise, capacity rebalance is disabled.
        """
        return pulumi.get(self, "capacity_rebalance")

    @property
    @pulumi.getter
    def context(self) -> pulumi.Output[Optional[str]]:
        """
        Reserved.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="defaultCooldown")
    def default_cooldown(self) -> pulumi.Output[int]:
        """
        Amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
        """
        return pulumi.get(self, "default_cooldown")

    @property
    @pulumi.getter(name="defaultInstanceWarmup")
    def default_instance_warmup(self) -> pulumi.Output[Optional[int]]:
        """
        Amount of time, in seconds, until a newly launched instance can contribute to the Amazon CloudWatch metrics. This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates instance metrics, resulting in more reliable usage data. Set this value equal to the amount of time that it takes for resource consumption to become stable after an instance reaches the InService state. (See [Set the default instance warmup for an Auto Scaling group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html))
        """
        return pulumi.get(self, "default_instance_warmup")

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> pulumi.Output[int]:
        """
        Number of Amazon EC2 instances that
        should be running in the group. (See also Waiting for
        Capacity below.)
        """
        return pulumi.get(self, "desired_capacity")

    @property
    @pulumi.getter(name="desiredCapacityType")
    def desired_capacity_type(self) -> pulumi.Output[Optional[str]]:
        """
        The unit of measurement for the value specified for `desired_capacity`. Supported for attribute-based instance type selection only. Valid values: `"units"`, `"vcpu"`, `"memory-mib"`.
        """
        return pulumi.get(self, "desired_capacity_type")

    @property
    @pulumi.getter(name="enabledMetrics")
    def enabled_metrics(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of metrics to collect. The allowed values are defined by the [underlying AWS API](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html).
        """
        return pulumi.get(self, "enabled_metrics")

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[bool]]:
        """
        Allows deleting the Auto Scaling Group without waiting
        for all instances in the pool to terminate. You can force an Auto Scaling Group to delete
        even if it's in the process of scaling a resource. Normally, this provider
        drains all the instances before deleting the group. This bypasses that
        behavior and potentially leaves resources dangling.
        """
        return pulumi.get(self, "force_delete")

    @property
    @pulumi.getter(name="forceDeleteWarmPool")
    def force_delete_warm_pool(self) -> pulumi.Output[Optional[bool]]:
        """
        Allows deleting the Auto Scaling Group without waiting for all instances in the warm pool to terminate.
        """
        return pulumi.get(self, "force_delete_warm_pool")

    @property
    @pulumi.getter(name="healthCheckGracePeriod")
    def health_check_grace_period(self) -> pulumi.Output[Optional[int]]:
        """
        Time (in seconds) after instance comes into service before checking health.
        """
        return pulumi.get(self, "health_check_grace_period")

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> pulumi.Output[str]:
        """
        "EC2" or "ELB". Controls how health checking is done.
        """
        return pulumi.get(self, "health_check_type")

    @property
    @pulumi.getter(name="ignoreFailedScalingActivities")
    def ignore_failed_scaling_activities(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to ignore failed [Auto Scaling scaling activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html) while waiting for capacity. The default is `false` -- failed scaling activities cause errors to be returned.
        """
        return pulumi.get(self, "ignore_failed_scaling_activities")

    @property
    @pulumi.getter(name="initialLifecycleHooks")
    def initial_lifecycle_hooks(self) -> pulumi.Output[Optional[Sequence['outputs.GroupInitialLifecycleHook']]]:
        """
        One or more
        [Lifecycle Hooks](http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html)
        to attach to the Auto Scaling Group **before** instances are launched. The
        syntax is exactly the same as the separate
        `autoscaling.LifecycleHook`
        resource, without the `autoscaling_group_name` attribute. Please note that this will only work when creating
        a new Auto Scaling Group. For all other use-cases, please use `autoscaling.LifecycleHook` resource.
        """
        return pulumi.get(self, "initial_lifecycle_hooks")

    @property
    @pulumi.getter(name="instanceMaintenancePolicy")
    def instance_maintenance_policy(self) -> pulumi.Output[Optional['outputs.GroupInstanceMaintenancePolicy']]:
        """
        If this block is configured, add a instance maintenance policy to the specified Auto Scaling group. Defined below.
        """
        return pulumi.get(self, "instance_maintenance_policy")

    @property
    @pulumi.getter(name="instanceRefresh")
    def instance_refresh(self) -> pulumi.Output[Optional['outputs.GroupInstanceRefresh']]:
        """
        If this block is configured, start an
        [Instance Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
        when this Auto Scaling Group is updated. Defined below.
        """
        return pulumi.get(self, "instance_refresh")

    @property
    @pulumi.getter(name="launchConfiguration")
    def launch_configuration(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the launch configuration to use.
        """
        return pulumi.get(self, "launch_configuration")

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> pulumi.Output['outputs.GroupLaunchTemplate']:
        """
        Nested argument with Launch template specification to use to launch instances. See Launch Template below for more details.
        """
        return pulumi.get(self, "launch_template")

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> pulumi.Output[Sequence[str]]:
        """
        List of elastic load balancer names to add to the autoscaling
        group names. Only valid for classic load balancers. For ALBs, use `target_group_arns` instead. To remove all load balancer attachments an empty list should be specified.
        """
        return pulumi.get(self, "load_balancers")

    @property
    @pulumi.getter(name="maxInstanceLifetime")
    def max_instance_lifetime(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum amount of time, in seconds, that an instance can be in service, values must be either equal to 0 or between 86400 and 31536000 seconds.
        """
        return pulumi.get(self, "max_instance_lifetime")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[int]:
        """
        Maximum size of the Auto Scaling Group.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="metricsGranularity")
    def metrics_granularity(self) -> pulumi.Output[Optional[str]]:
        """
        Granularity to associate with the metrics to collect. The only valid value is `1Minute`. Default is `1Minute`.
        """
        return pulumi.get(self, "metrics_granularity")

    @property
    @pulumi.getter(name="minElbCapacity")
    def min_elb_capacity(self) -> pulumi.Output[Optional[int]]:
        """
        Setting this causes Pulumi to wait for
        this number of instances from this Auto Scaling Group to show up healthy in the
        ELB only on creation. Updates will not wait on ELB instance number changes.
        (See also Waiting for Capacity below.)
        """
        return pulumi.get(self, "min_elb_capacity")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Output[int]:
        """
        Minimum size of the Auto Scaling Group.
        (See also Waiting for Capacity below.)
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="mixedInstancesPolicy")
    def mixed_instances_policy(self) -> pulumi.Output['outputs.GroupMixedInstancesPolicy']:
        """
        Configuration block containing settings to define launch targets for Auto Scaling groups. See Mixed Instances Policy below for more details.
        """
        return pulumi.get(self, "mixed_instances_policy")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the Auto Scaling Group. By default generated by Pulumi. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[str]:
        """
        Creates a unique name beginning with the specified
        prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the placement group into which you'll launch your instances, if any.
        """
        return pulumi.get(self, "placement_group")

    @property
    @pulumi.getter(name="predictedCapacity")
    def predicted_capacity(self) -> pulumi.Output[int]:
        """
        Predicted capacity of the group.
        """
        return pulumi.get(self, "predicted_capacity")

    @property
    @pulumi.getter(name="protectFromScaleIn")
    def protect_from_scale_in(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether newly launched instances
        are automatically protected from termination by Amazon EC2 Auto Scaling when
        scaling in. For more information about preventing instances from terminating
        on scale in, see [Using instance scale-in protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
        in the Amazon EC2 Auto Scaling User Guide.
        """
        return pulumi.get(self, "protect_from_scale_in")

    @property
    @pulumi.getter(name="serviceLinkedRoleArn")
    def service_linked_role_arn(self) -> pulumi.Output[str]:
        """
        ARN of the service-linked role that the ASG will use to call other AWS services
        """
        return pulumi.get(self, "service_linked_role_arn")

    @property
    @pulumi.getter(name="suspendedProcesses")
    def suspended_processes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of processes to suspend for the Auto Scaling Group. The allowed values are `Launch`, `Terminate`, `HealthCheck`, `ReplaceUnhealthy`, `AZRebalance`, `AlarmNotification`, `ScheduledActions`, `AddToLoadBalancer`, `InstanceRefresh`.
        Note that if you suspend either the `Launch` or `Terminate` process types, it can prevent your Auto Scaling Group from functioning properly.
        """
        return pulumi.get(self, "suspended_processes")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.GroupTag']]]:
        """
        Configuration block(s) containing resource tags. See Tag below for more details.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetGroupArns")
    def target_group_arns(self) -> pulumi.Output[Sequence[str]]:
        """
        Set of `alb.TargetGroup` ARNs, for use with Application or Network Load Balancing. To remove all target group attachments an empty list should be specified.
        """
        return pulumi.get(self, "target_group_arns")

    @property
    @pulumi.getter(name="terminationPolicies")
    def termination_policies(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of policies to decide how the instances in the Auto Scaling Group should be terminated. The allowed values are `OldestInstance`, `NewestInstance`, `OldestLaunchConfiguration`, `ClosestToNextInstanceHour`, `OldestLaunchTemplate`, `AllocationStrategy`, `Default`. Additionally, the ARN of a Lambda function can be specified for custom termination policies.
        """
        return pulumi.get(self, "termination_policies")

    @property
    @pulumi.getter(name="trafficSources")
    def traffic_sources(self) -> pulumi.Output[Sequence['outputs.GroupTrafficSource']]:
        """
        Attaches one or more traffic sources to the specified Auto Scaling group.
        """
        return pulumi.get(self, "traffic_sources")

    @property
    @pulumi.getter(name="vpcZoneIdentifiers")
    def vpc_zone_identifiers(self) -> pulumi.Output[Sequence[str]]:
        """
        List of subnet IDs to launch resources in. Subnets automatically determine which availability zones the group will reside. Conflicts with `availability_zones`.
        """
        return pulumi.get(self, "vpc_zone_identifiers")

    @property
    @pulumi.getter(name="waitForCapacityTimeout")
    def wait_for_capacity_timeout(self) -> pulumi.Output[Optional[str]]:
        """
        Maximum
        [duration](https://golang.org/pkg/time/#ParseDuration) that the provider should
        wait for ASG instances to be healthy before timing out. (See also Waiting
        for Capacity below.) Setting this to "0" causes
        the provider to skip all Capacity Waiting behavior.
        """
        return pulumi.get(self, "wait_for_capacity_timeout")

    @property
    @pulumi.getter(name="waitForElbCapacity")
    def wait_for_elb_capacity(self) -> pulumi.Output[Optional[int]]:
        """
        Setting this will cause Pulumi to wait
        for exactly this number of healthy instances from this Auto Scaling Group in
        all attached load balancers on both create and update operations. (Takes
        precedence over `min_elb_capacity` behavior.)
        (See also Waiting for Capacity below.)
        """
        return pulumi.get(self, "wait_for_elb_capacity")

    @property
    @pulumi.getter(name="warmPool")
    def warm_pool(self) -> pulumi.Output[Optional['outputs.GroupWarmPool']]:
        """
        If this block is configured, add a [Warm Pool](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
        to the specified Auto Scaling group. Defined below
        """
        return pulumi.get(self, "warm_pool")

    @property
    @pulumi.getter(name="warmPoolSize")
    def warm_pool_size(self) -> pulumi.Output[int]:
        """
        Current size of the warm pool.
        """
        return pulumi.get(self, "warm_pool_size")

