# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetJobQueueResult',
    'AwaitableGetJobQueueResult',
    'get_job_queue',
    'get_job_queue_output',
]

@pulumi.output_type
class GetJobQueueResult:
    """
    A collection of values returned by getJobQueue.
    """
    def __init__(__self__, arn=None, compute_environment_orders=None, id=None, job_state_time_limit_actions=None, name=None, priority=None, scheduling_policy_arn=None, state=None, status=None, status_reason=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if compute_environment_orders and not isinstance(compute_environment_orders, list):
            raise TypeError("Expected argument 'compute_environment_orders' to be a list")
        pulumi.set(__self__, "compute_environment_orders", compute_environment_orders)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if job_state_time_limit_actions and not isinstance(job_state_time_limit_actions, list):
            raise TypeError("Expected argument 'job_state_time_limit_actions' to be a list")
        pulumi.set(__self__, "job_state_time_limit_actions", job_state_time_limit_actions)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if priority and not isinstance(priority, int):
            raise TypeError("Expected argument 'priority' to be a int")
        pulumi.set(__self__, "priority", priority)
        if scheduling_policy_arn and not isinstance(scheduling_policy_arn, str):
            raise TypeError("Expected argument 'scheduling_policy_arn' to be a str")
        pulumi.set(__self__, "scheduling_policy_arn", scheduling_policy_arn)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_reason and not isinstance(status_reason, str):
            raise TypeError("Expected argument 'status_reason' to be a str")
        pulumi.set(__self__, "status_reason", status_reason)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> str:
        """
        ARN of the job queue.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="computeEnvironmentOrders")
    def compute_environment_orders(self) -> Sequence['outputs.GetJobQueueComputeEnvironmentOrderResult']:
        """
        The compute environments that are attached to the job queue and the order in
        which job placement is preferred. Compute environments are selected for job placement in ascending order.
        * `compute_environment_order.#.order` - The order of the compute environment.
        * `compute_environment_order.#.compute_environment` - The ARN of the compute environment.
        """
        return pulumi.get(self, "compute_environment_orders")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="jobStateTimeLimitActions")
    def job_state_time_limit_actions(self) -> Sequence['outputs.GetJobQueueJobStateTimeLimitActionResult']:
        """
        Specifies an action that AWS Batch will take after the job has remained at the head of the queue in the specified state for longer than the specified time.
        * `job_state_time_limit_action.#.action` - The action to take when a job is at the head of the job queue in the specified state for the specified period of time.
        * `job_state_time_limit_action.#.max_time_seconds` - The approximate amount of time, in seconds, that must pass with the job in the specified state before the action is taken.
        * `job_state_time_limit_action.#.reason` - The reason to log for the action being taken.
        * `job_state_time_limit_action.#.state` - The state of the job needed to trigger the action.
        """
        return pulumi.get(self, "job_state_time_limit_actions")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        Priority of the job queue. Job queues with a higher priority are evaluated first when
        associated with the same compute environment.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="schedulingPolicyArn")
    def scheduling_policy_arn(self) -> str:
        """
        The ARN of the fair share scheduling policy. If this attribute has a value, the job queue uses a fair share scheduling policy. If this attribute does not have a value, the job queue uses a first in, first out (FIFO) scheduling policy.
        """
        return pulumi.get(self, "scheduling_policy_arn")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describes the ability of the queue to accept new jobs (for example, `ENABLED` or `DISABLED`).
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current status of the job queue (for example, `CREATING` or `VALID`).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> str:
        """
        Short, human-readable string to provide additional details about the current status
        of the job queue.
        """
        return pulumi.get(self, "status_reason")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Key-value map of resource tags
        """
        return pulumi.get(self, "tags")


class AwaitableGetJobQueueResult(GetJobQueueResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobQueueResult(
            arn=self.arn,
            compute_environment_orders=self.compute_environment_orders,
            id=self.id,
            job_state_time_limit_actions=self.job_state_time_limit_actions,
            name=self.name,
            priority=self.priority,
            scheduling_policy_arn=self.scheduling_policy_arn,
            state=self.state,
            status=self.status,
            status_reason=self.status_reason,
            tags=self.tags)


def get_job_queue(name: Optional[str] = None,
                  tags: Optional[Mapping[str, str]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobQueueResult:
    """
    The Batch Job Queue data source allows access to details of a specific
    job queue within AWS Batch.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test_queue = aws.batch.get_job_queue(name="tf-test-batch-job-queue")
    ```


    :param str name: Name of the job queue.
    :param Mapping[str, str] tags: Key-value map of resource tags
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:batch/getJobQueue:getJobQueue', __args__, opts=opts, typ=GetJobQueueResult).value

    return AwaitableGetJobQueueResult(
        arn=pulumi.get(__ret__, 'arn'),
        compute_environment_orders=pulumi.get(__ret__, 'compute_environment_orders'),
        id=pulumi.get(__ret__, 'id'),
        job_state_time_limit_actions=pulumi.get(__ret__, 'job_state_time_limit_actions'),
        name=pulumi.get(__ret__, 'name'),
        priority=pulumi.get(__ret__, 'priority'),
        scheduling_policy_arn=pulumi.get(__ret__, 'scheduling_policy_arn'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        status_reason=pulumi.get(__ret__, 'status_reason'),
        tags=pulumi.get(__ret__, 'tags'))
def get_job_queue_output(name: Optional[pulumi.Input[str]] = None,
                         tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJobQueueResult]:
    """
    The Batch Job Queue data source allows access to details of a specific
    job queue within AWS Batch.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test_queue = aws.batch.get_job_queue(name="tf-test-batch-job-queue")
    ```


    :param str name: Name of the job queue.
    :param Mapping[str, str] tags: Key-value map of resource tags
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:batch/getJobQueue:getJobQueue', __args__, opts=opts, typ=GetJobQueueResult)
    return __ret__.apply(lambda __response__: GetJobQueueResult(
        arn=pulumi.get(__response__, 'arn'),
        compute_environment_orders=pulumi.get(__response__, 'compute_environment_orders'),
        id=pulumi.get(__response__, 'id'),
        job_state_time_limit_actions=pulumi.get(__response__, 'job_state_time_limit_actions'),
        name=pulumi.get(__response__, 'name'),
        priority=pulumi.get(__response__, 'priority'),
        scheduling_policy_arn=pulumi.get(__response__, 'scheduling_policy_arn'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        status_reason=pulumi.get(__response__, 'status_reason'),
        tags=pulumi.get(__response__, 'tags')))
