# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ComputeEnvironmentComputeResources',
    'ComputeEnvironmentComputeResourcesEc2Configuration',
    'ComputeEnvironmentComputeResourcesLaunchTemplate',
    'ComputeEnvironmentEksConfiguration',
    'ComputeEnvironmentUpdatePolicy',
    'JobDefinitionEksProperties',
    'JobDefinitionEksPropertiesPodProperties',
    'JobDefinitionEksPropertiesPodPropertiesContainers',
    'JobDefinitionEksPropertiesPodPropertiesContainersEnv',
    'JobDefinitionEksPropertiesPodPropertiesContainersResources',
    'JobDefinitionEksPropertiesPodPropertiesContainersSecurityContext',
    'JobDefinitionEksPropertiesPodPropertiesContainersVolumeMount',
    'JobDefinitionEksPropertiesPodPropertiesImagePullSecret',
    'JobDefinitionEksPropertiesPodPropertiesInitContainer',
    'JobDefinitionEksPropertiesPodPropertiesInitContainerEnv',
    'JobDefinitionEksPropertiesPodPropertiesInitContainerResources',
    'JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContext',
    'JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMount',
    'JobDefinitionEksPropertiesPodPropertiesMetadata',
    'JobDefinitionEksPropertiesPodPropertiesVolume',
    'JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDir',
    'JobDefinitionEksPropertiesPodPropertiesVolumeHostPath',
    'JobDefinitionEksPropertiesPodPropertiesVolumeSecret',
    'JobDefinitionRetryStrategy',
    'JobDefinitionRetryStrategyEvaluateOnExit',
    'JobDefinitionTimeout',
    'JobQueueComputeEnvironmentOrder',
    'JobQueueJobStateTimeLimitAction',
    'JobQueueTimeouts',
    'SchedulingPolicyFairSharePolicy',
    'SchedulingPolicyFairSharePolicyShareDistribution',
    'GetComputeEnvironmentUpdatePolicyResult',
    'GetJobDefinitionEksPropertyResult',
    'GetJobDefinitionEksPropertyPodPropertyResult',
    'GetJobDefinitionEksPropertyPodPropertyContainerResult',
    'GetJobDefinitionEksPropertyPodPropertyContainerEnvResult',
    'GetJobDefinitionEksPropertyPodPropertyContainerResourceResult',
    'GetJobDefinitionEksPropertyPodPropertyContainerSecurityContextResult',
    'GetJobDefinitionEksPropertyPodPropertyContainerVolumeMountResult',
    'GetJobDefinitionEksPropertyPodPropertyImagePullSecretResult',
    'GetJobDefinitionEksPropertyPodPropertyInitContainerResult',
    'GetJobDefinitionEksPropertyPodPropertyInitContainerEnvResult',
    'GetJobDefinitionEksPropertyPodPropertyInitContainerResourceResult',
    'GetJobDefinitionEksPropertyPodPropertyInitContainerSecurityContextResult',
    'GetJobDefinitionEksPropertyPodPropertyInitContainerVolumeMountResult',
    'GetJobDefinitionEksPropertyPodPropertyMetadataResult',
    'GetJobDefinitionEksPropertyPodPropertyVolumeResult',
    'GetJobDefinitionEksPropertyPodPropertyVolumeEmptyDirResult',
    'GetJobDefinitionEksPropertyPodPropertyVolumeHostPathResult',
    'GetJobDefinitionEksPropertyPodPropertyVolumeSecretResult',
    'GetJobDefinitionNodePropertyResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerEnvironmentResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerEphemeralStorageResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerFargatePlatformConfigurationResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterDeviceResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterTmpfResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfigurationResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfigurationSecretOptionResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerMountPointResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerNetworkConfigurationResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerResourceRequirementResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerRuntimePlatformResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerSecretResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerUlimitResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfigurationResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfigurationAuthorizationConfigResult',
    'GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeHostResult',
    'GetJobDefinitionRetryStrategyResult',
    'GetJobDefinitionRetryStrategyEvaluateOnExitResult',
    'GetJobDefinitionTimeoutResult',
    'GetJobQueueComputeEnvironmentOrderResult',
    'GetJobQueueJobStateTimeLimitActionResult',
    'GetSchedulingPolicyFairSharePolicyResult',
    'GetSchedulingPolicyFairSharePolicyShareDistributionResult',
]

@pulumi.output_type
class ComputeEnvironmentComputeResources(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxVcpus":
            suggest = "max_vcpus"
        elif key == "allocationStrategy":
            suggest = "allocation_strategy"
        elif key == "bidPercentage":
            suggest = "bid_percentage"
        elif key == "desiredVcpus":
            suggest = "desired_vcpus"
        elif key == "ec2Configurations":
            suggest = "ec2_configurations"
        elif key == "ec2KeyPair":
            suggest = "ec2_key_pair"
        elif key == "imageId":
            suggest = "image_id"
        elif key == "instanceRole":
            suggest = "instance_role"
        elif key == "instanceTypes":
            suggest = "instance_types"
        elif key == "launchTemplate":
            suggest = "launch_template"
        elif key == "minVcpus":
            suggest = "min_vcpus"
        elif key == "placementGroup":
            suggest = "placement_group"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "spotIamFleetRole":
            suggest = "spot_iam_fleet_role"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeEnvironmentComputeResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeEnvironmentComputeResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeEnvironmentComputeResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_vcpus: int,
                 subnets: Sequence[str],
                 type: str,
                 allocation_strategy: Optional[str] = None,
                 bid_percentage: Optional[int] = None,
                 desired_vcpus: Optional[int] = None,
                 ec2_configurations: Optional[Sequence['outputs.ComputeEnvironmentComputeResourcesEc2Configuration']] = None,
                 ec2_key_pair: Optional[str] = None,
                 image_id: Optional[str] = None,
                 instance_role: Optional[str] = None,
                 instance_types: Optional[Sequence[str]] = None,
                 launch_template: Optional['outputs.ComputeEnvironmentComputeResourcesLaunchTemplate'] = None,
                 min_vcpus: Optional[int] = None,
                 placement_group: Optional[str] = None,
                 security_group_ids: Optional[Sequence[str]] = None,
                 spot_iam_fleet_role: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None):
        """
        :param int max_vcpus: The maximum number of EC2 vCPUs that an environment can reach.
        :param Sequence[str] subnets: A list of VPC subnets into which the compute resources are launched.
        :param str type: The type of compute environment. Valid items are `EC2`, `SPOT`, `FARGATE` or `FARGATE_SPOT`.
        :param str allocation_strategy: The allocation strategy to use for the compute resource in case not enough instances of the best fitting instance type can be allocated. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/batch/latest/APIReference/API_ComputeResource.html#Batch-Type-ComputeResource-allocationStrategy). Defaults to `BEST_FIT`. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param int bid_percentage: Integer of maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your bid percentage is 20% (`20`), then the Spot price must be below 20% of the current On-Demand price for that EC2 instance. If you leave this field empty, the default value is 100% of the On-Demand price. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param int desired_vcpus: The desired number of EC2 vCPUS in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param Sequence['ComputeEnvironmentComputeResourcesEc2ConfigurationArgs'] ec2_configurations: Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn't specified, the default is ECS_AL2. This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
        :param str ec2_key_pair: The EC2 key pair that is used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param str image_id: The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified. (Deprecated, use `ec2_configuration` `image_id_override` instead)
        :param str instance_role: The Amazon ECS instance role applied to Amazon EC2 instances in a compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param Sequence[str] instance_types: A list of instance types that may be launched. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param 'ComputeEnvironmentComputeResourcesLaunchTemplateArgs' launch_template: The launch template to use for your compute resources. See details below. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param int min_vcpus: The minimum number of EC2 vCPUs that an environment should maintain. For `EC2` or `SPOT` compute environments, if the parameter is not explicitly defined, a `0` default value will be set. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param str placement_group: The Amazon EC2 placement group to associate with your compute resources.
        :param Sequence[str] security_group_ids: A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
        :param str spot_iam_fleet_role: The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a SPOT compute environment. This parameter is required for SPOT compute environments. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param Mapping[str, str] tags: Key-value pair tags to be applied to resources that are launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        pulumi.set(__self__, "max_vcpus", max_vcpus)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "type", type)
        if allocation_strategy is not None:
            pulumi.set(__self__, "allocation_strategy", allocation_strategy)
        if bid_percentage is not None:
            pulumi.set(__self__, "bid_percentage", bid_percentage)
        if desired_vcpus is not None:
            pulumi.set(__self__, "desired_vcpus", desired_vcpus)
        if ec2_configurations is not None:
            pulumi.set(__self__, "ec2_configurations", ec2_configurations)
        if ec2_key_pair is not None:
            pulumi.set(__self__, "ec2_key_pair", ec2_key_pair)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_role is not None:
            pulumi.set(__self__, "instance_role", instance_role)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if min_vcpus is not None:
            pulumi.set(__self__, "min_vcpus", min_vcpus)
        if placement_group is not None:
            pulumi.set(__self__, "placement_group", placement_group)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_iam_fleet_role is not None:
            pulumi.set(__self__, "spot_iam_fleet_role", spot_iam_fleet_role)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="maxVcpus")
    def max_vcpus(self) -> int:
        """
        The maximum number of EC2 vCPUs that an environment can reach.
        """
        return pulumi.get(self, "max_vcpus")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        A list of VPC subnets into which the compute resources are launched.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of compute environment. Valid items are `EC2`, `SPOT`, `FARGATE` or `FARGATE_SPOT`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> Optional[str]:
        """
        The allocation strategy to use for the compute resource in case not enough instances of the best fitting instance type can be allocated. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/batch/latest/APIReference/API_ComputeResource.html#Batch-Type-ComputeResource-allocationStrategy). Defaults to `BEST_FIT`. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "allocation_strategy")

    @property
    @pulumi.getter(name="bidPercentage")
    def bid_percentage(self) -> Optional[int]:
        """
        Integer of maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your bid percentage is 20% (`20`), then the Spot price must be below 20% of the current On-Demand price for that EC2 instance. If you leave this field empty, the default value is 100% of the On-Demand price. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "bid_percentage")

    @property
    @pulumi.getter(name="desiredVcpus")
    def desired_vcpus(self) -> Optional[int]:
        """
        The desired number of EC2 vCPUS in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "desired_vcpus")

    @property
    @pulumi.getter(name="ec2Configurations")
    def ec2_configurations(self) -> Optional[Sequence['outputs.ComputeEnvironmentComputeResourcesEc2Configuration']]:
        """
        Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn't specified, the default is ECS_AL2. This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "ec2_configurations")

    @property
    @pulumi.getter(name="ec2KeyPair")
    def ec2_key_pair(self) -> Optional[str]:
        """
        The EC2 key pair that is used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "ec2_key_pair")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[str]:
        """
        The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified. (Deprecated, use `ec2_configuration` `image_id_override` instead)
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceRole")
    def instance_role(self) -> Optional[str]:
        """
        The Amazon ECS instance role applied to Amazon EC2 instances in a compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "instance_role")

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[Sequence[str]]:
        """
        A list of instance types that may be launched. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "instance_types")

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional['outputs.ComputeEnvironmentComputeResourcesLaunchTemplate']:
        """
        The launch template to use for your compute resources. See details below. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "launch_template")

    @property
    @pulumi.getter(name="minVcpus")
    def min_vcpus(self) -> Optional[int]:
        """
        The minimum number of EC2 vCPUs that an environment should maintain. For `EC2` or `SPOT` compute environments, if the parameter is not explicitly defined, a `0` default value will be set. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "min_vcpus")

    @property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> Optional[str]:
        """
        The Amazon EC2 placement group to associate with your compute resources.
        """
        return pulumi.get(self, "placement_group")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[str]]:
        """
        A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="spotIamFleetRole")
    def spot_iam_fleet_role(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a SPOT compute environment. This parameter is required for SPOT compute environments. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "spot_iam_fleet_role")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Key-value pair tags to be applied to resources that are launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ComputeEnvironmentComputeResourcesEc2Configuration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageIdOverride":
            suggest = "image_id_override"
        elif key == "imageType":
            suggest = "image_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeEnvironmentComputeResourcesEc2Configuration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeEnvironmentComputeResourcesEc2Configuration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeEnvironmentComputeResourcesEc2Configuration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_id_override: Optional[str] = None,
                 image_type: Optional[str] = None):
        """
        :param str image_id_override: The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `image_id` argument in the `compute_resources` block.
        :param str image_type: The image type to match with the instance type to select an AMI. If the `image_id_override` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) (`ECS_AL2`) is used.
        """
        if image_id_override is not None:
            pulumi.set(__self__, "image_id_override", image_id_override)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)

    @property
    @pulumi.getter(name="imageIdOverride")
    def image_id_override(self) -> Optional[str]:
        """
        The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `image_id` argument in the `compute_resources` block.
        """
        return pulumi.get(self, "image_id_override")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[str]:
        """
        The image type to match with the instance type to select an AMI. If the `image_id_override` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) (`ECS_AL2`) is used.
        """
        return pulumi.get(self, "image_type")


@pulumi.output_type
class ComputeEnvironmentComputeResourcesLaunchTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTemplateId":
            suggest = "launch_template_id"
        elif key == "launchTemplateName":
            suggest = "launch_template_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeEnvironmentComputeResourcesLaunchTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeEnvironmentComputeResourcesLaunchTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeEnvironmentComputeResourcesLaunchTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_template_id: Optional[str] = None,
                 launch_template_name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str launch_template_id: ID of the launch template. You must specify either the launch template ID or launch template name in the request, but not both.
        :param str launch_template_name: Name of the launch template.
        :param str version: The version number of the launch template. Default: The default version of the launch template.
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[str]:
        """
        ID of the launch template. You must specify either the launch template ID or launch template name in the request, but not both.
        """
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[str]:
        """
        Name of the launch template.
        """
        return pulumi.get(self, "launch_template_name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version number of the launch template. Default: The default version of the launch template.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ComputeEnvironmentEksConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eksClusterArn":
            suggest = "eks_cluster_arn"
        elif key == "kubernetesNamespace":
            suggest = "kubernetes_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeEnvironmentEksConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeEnvironmentEksConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeEnvironmentEksConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eks_cluster_arn: str,
                 kubernetes_namespace: str):
        """
        :param str eks_cluster_arn: The Amazon Resource Name (ARN) of the Amazon EKS cluster.
        :param str kubernetes_namespace: The namespace of the Amazon EKS cluster. AWS Batch manages pods in this namespace.
        """
        pulumi.set(__self__, "eks_cluster_arn", eks_cluster_arn)
        pulumi.set(__self__, "kubernetes_namespace", kubernetes_namespace)

    @property
    @pulumi.getter(name="eksClusterArn")
    def eks_cluster_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the Amazon EKS cluster.
        """
        return pulumi.get(self, "eks_cluster_arn")

    @property
    @pulumi.getter(name="kubernetesNamespace")
    def kubernetes_namespace(self) -> str:
        """
        The namespace of the Amazon EKS cluster. AWS Batch manages pods in this namespace.
        """
        return pulumi.get(self, "kubernetes_namespace")


@pulumi.output_type
class ComputeEnvironmentUpdatePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobExecutionTimeoutMinutes":
            suggest = "job_execution_timeout_minutes"
        elif key == "terminateJobsOnUpdate":
            suggest = "terminate_jobs_on_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeEnvironmentUpdatePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeEnvironmentUpdatePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeEnvironmentUpdatePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_execution_timeout_minutes: int,
                 terminate_jobs_on_update: bool):
        """
        :param int job_execution_timeout_minutes: Specifies the job timeout (in minutes) when the compute environment infrastructure is updated.
        :param bool terminate_jobs_on_update: Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated.
        """
        pulumi.set(__self__, "job_execution_timeout_minutes", job_execution_timeout_minutes)
        pulumi.set(__self__, "terminate_jobs_on_update", terminate_jobs_on_update)

    @property
    @pulumi.getter(name="jobExecutionTimeoutMinutes")
    def job_execution_timeout_minutes(self) -> int:
        """
        Specifies the job timeout (in minutes) when the compute environment infrastructure is updated.
        """
        return pulumi.get(self, "job_execution_timeout_minutes")

    @property
    @pulumi.getter(name="terminateJobsOnUpdate")
    def terminate_jobs_on_update(self) -> bool:
        """
        Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated.
        """
        return pulumi.get(self, "terminate_jobs_on_update")


@pulumi.output_type
class JobDefinitionEksProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "podProperties":
            suggest = "pod_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pod_properties: 'outputs.JobDefinitionEksPropertiesPodProperties'):
        """
        :param 'JobDefinitionEksPropertiesPodPropertiesArgs' pod_properties: Properties for the Kubernetes pod resources of a job. See `pod_properties` below.
        """
        pulumi.set(__self__, "pod_properties", pod_properties)

    @property
    @pulumi.getter(name="podProperties")
    def pod_properties(self) -> 'outputs.JobDefinitionEksPropertiesPodProperties':
        """
        Properties for the Kubernetes pod resources of a job. See `pod_properties` below.
        """
        return pulumi.get(self, "pod_properties")


@pulumi.output_type
class JobDefinitionEksPropertiesPodProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsPolicy":
            suggest = "dns_policy"
        elif key == "hostNetwork":
            suggest = "host_network"
        elif key == "imagePullSecrets":
            suggest = "image_pull_secrets"
        elif key == "initContainers":
            suggest = "init_containers"
        elif key == "serviceAccountName":
            suggest = "service_account_name"
        elif key == "shareProcessNamespace":
            suggest = "share_process_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksPropertiesPodProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksPropertiesPodProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksPropertiesPodProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: 'outputs.JobDefinitionEksPropertiesPodPropertiesContainers',
                 dns_policy: Optional[str] = None,
                 host_network: Optional[bool] = None,
                 image_pull_secrets: Optional[Sequence['outputs.JobDefinitionEksPropertiesPodPropertiesImagePullSecret']] = None,
                 init_containers: Optional[Sequence['outputs.JobDefinitionEksPropertiesPodPropertiesInitContainer']] = None,
                 metadata: Optional['outputs.JobDefinitionEksPropertiesPodPropertiesMetadata'] = None,
                 service_account_name: Optional[str] = None,
                 share_process_namespace: Optional[bool] = None,
                 volumes: Optional[Sequence['outputs.JobDefinitionEksPropertiesPodPropertiesVolume']] = None):
        """
        :param 'JobDefinitionEksPropertiesPodPropertiesContainersArgs' containers: Properties of the container that's used on the Amazon EKS pod. See containers below.
        :param str dns_policy: DNS policy for the pod. The default value is `ClusterFirst`. If the `host_network` argument is not specified, the default is `ClusterFirstWithHostNet`. `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see Pod's DNS policy in the Kubernetes documentation.
        :param bool host_network: Whether the pod uses the hosts' network IP address. The default value is `true`. Setting this to `false` enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
        :param Sequence['JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgs'] image_pull_secrets: List of Kubernetes secret resources. See `image_pull_secret` below.
        :param Sequence['JobDefinitionEksPropertiesPodPropertiesInitContainerArgs'] init_containers: Containers which run before application containers, always runs to completion, and must complete successfully before the next container starts. These containers are registered with the Amazon EKS Connector agent and persists the registration information in the Kubernetes backend data store. See containers below.
        :param 'JobDefinitionEksPropertiesPodPropertiesMetadataArgs' metadata: Metadata about the Kubernetes pod.
        :param str service_account_name: Name of the service account that's used to run the pod.
        :param bool share_process_namespace: Indicates if the processes in a container are shared, or visible, to other containers in the same pod.
        :param Sequence['JobDefinitionEksPropertiesPodPropertiesVolumeArgs'] volumes: Volumes for a job definition that uses Amazon EKS resources. AWS Batch supports emptyDir, hostPath, and secret volume types.
        """
        pulumi.set(__self__, "containers", containers)
        if dns_policy is not None:
            pulumi.set(__self__, "dns_policy", dns_policy)
        if host_network is not None:
            pulumi.set(__self__, "host_network", host_network)
        if image_pull_secrets is not None:
            pulumi.set(__self__, "image_pull_secrets", image_pull_secrets)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if service_account_name is not None:
            pulumi.set(__self__, "service_account_name", service_account_name)
        if share_process_namespace is not None:
            pulumi.set(__self__, "share_process_namespace", share_process_namespace)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def containers(self) -> 'outputs.JobDefinitionEksPropertiesPodPropertiesContainers':
        """
        Properties of the container that's used on the Amazon EKS pod. See containers below.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="dnsPolicy")
    def dns_policy(self) -> Optional[str]:
        """
        DNS policy for the pod. The default value is `ClusterFirst`. If the `host_network` argument is not specified, the default is `ClusterFirstWithHostNet`. `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see Pod's DNS policy in the Kubernetes documentation.
        """
        return pulumi.get(self, "dns_policy")

    @property
    @pulumi.getter(name="hostNetwork")
    def host_network(self) -> Optional[bool]:
        """
        Whether the pod uses the hosts' network IP address. The default value is `true`. Setting this to `false` enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
        """
        return pulumi.get(self, "host_network")

    @property
    @pulumi.getter(name="imagePullSecrets")
    def image_pull_secrets(self) -> Optional[Sequence['outputs.JobDefinitionEksPropertiesPodPropertiesImagePullSecret']]:
        """
        List of Kubernetes secret resources. See `image_pull_secret` below.
        """
        return pulumi.get(self, "image_pull_secrets")

    @property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[Sequence['outputs.JobDefinitionEksPropertiesPodPropertiesInitContainer']]:
        """
        Containers which run before application containers, always runs to completion, and must complete successfully before the next container starts. These containers are registered with the Amazon EKS Connector agent and persists the registration information in the Kubernetes backend data store. See containers below.
        """
        return pulumi.get(self, "init_containers")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['outputs.JobDefinitionEksPropertiesPodPropertiesMetadata']:
        """
        Metadata about the Kubernetes pod.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> Optional[str]:
        """
        Name of the service account that's used to run the pod.
        """
        return pulumi.get(self, "service_account_name")

    @property
    @pulumi.getter(name="shareProcessNamespace")
    def share_process_namespace(self) -> Optional[bool]:
        """
        Indicates if the processes in a container are shared, or visible, to other containers in the same pod.
        """
        return pulumi.get(self, "share_process_namespace")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.JobDefinitionEksPropertiesPodPropertiesVolume']]:
        """
        Volumes for a job definition that uses Amazon EKS resources. AWS Batch supports emptyDir, hostPath, and secret volume types.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class JobDefinitionEksPropertiesPodPropertiesContainers(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imagePullPolicy":
            suggest = "image_pull_policy"
        elif key == "securityContext":
            suggest = "security_context"
        elif key == "volumeMounts":
            suggest = "volume_mounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksPropertiesPodPropertiesContainers. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksPropertiesPodPropertiesContainers.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksPropertiesPodPropertiesContainers.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: str,
                 args: Optional[Sequence[str]] = None,
                 commands: Optional[Sequence[str]] = None,
                 envs: Optional[Sequence['outputs.JobDefinitionEksPropertiesPodPropertiesContainersEnv']] = None,
                 image_pull_policy: Optional[str] = None,
                 name: Optional[str] = None,
                 resources: Optional['outputs.JobDefinitionEksPropertiesPodPropertiesContainersResources'] = None,
                 security_context: Optional['outputs.JobDefinitionEksPropertiesPodPropertiesContainersSecurityContext'] = None,
                 volume_mounts: Optional[Sequence['outputs.JobDefinitionEksPropertiesPodPropertiesContainersVolumeMount']] = None):
        """
        :param str image: Docker image used to start the container.
        :param Sequence[str] args: Array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
        :param Sequence[str] commands: Entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
        :param Sequence['JobDefinitionEksPropertiesPodPropertiesContainersEnvArgs'] envs: Environment variables to pass to a container. See EKS Environment below.
        :param str image_pull_policy: Image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`.
        :param str name: Name of the container. If the name isn't specified, the default name "Default" is used. Each container in a pod must have a unique name.
        :param 'JobDefinitionEksPropertiesPodPropertiesContainersResourcesArgs' resources: Type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`.
        :param 'JobDefinitionEksPropertiesPodPropertiesContainersSecurityContextArgs' security_context: Security context for a job.
        :param Sequence['JobDefinitionEksPropertiesPodPropertiesContainersVolumeMountArgs'] volume_mounts: Volume mounts for the container.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        Docker image used to start the container.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        Array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[str]]:
        """
        Entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.JobDefinitionEksPropertiesPodPropertiesContainersEnv']]:
        """
        Environment variables to pass to a container. See EKS Environment below.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[str]:
        """
        Image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`.
        """
        return pulumi.get(self, "image_pull_policy")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the container. If the name isn't specified, the default name "Default" is used. Each container in a pod must have a unique name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.JobDefinitionEksPropertiesPodPropertiesContainersResources']:
        """
        Type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional['outputs.JobDefinitionEksPropertiesPodPropertiesContainersSecurityContext']:
        """
        Security context for a job.
        """
        return pulumi.get(self, "security_context")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.JobDefinitionEksPropertiesPodPropertiesContainersVolumeMount']]:
        """
        Volume mounts for the container.
        """
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class JobDefinitionEksPropertiesPodPropertiesContainersEnv(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Name of the job definition.
        :param str value: Value of the environment variable.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the job definition.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class JobDefinitionEksPropertiesPodPropertiesContainersResources(dict):
    def __init__(__self__, *,
                 limits: Optional[Mapping[str, str]] = None,
                 requests: Optional[Mapping[str, str]] = None):
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "requests")


@pulumi.output_type
class JobDefinitionEksPropertiesPodPropertiesContainersSecurityContext(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnlyRootFileSystem":
            suggest = "read_only_root_file_system"
        elif key == "runAsGroup":
            suggest = "run_as_group"
        elif key == "runAsNonRoot":
            suggest = "run_as_non_root"
        elif key == "runAsUser":
            suggest = "run_as_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksPropertiesPodPropertiesContainersSecurityContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksPropertiesPodPropertiesContainersSecurityContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksPropertiesPodPropertiesContainersSecurityContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 privileged: Optional[bool] = None,
                 read_only_root_file_system: Optional[bool] = None,
                 run_as_group: Optional[int] = None,
                 run_as_non_root: Optional[bool] = None,
                 run_as_user: Optional[int] = None):
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if read_only_root_file_system is not None:
            pulumi.set(__self__, "read_only_root_file_system", read_only_root_file_system)
        if run_as_group is not None:
            pulumi.set(__self__, "run_as_group", run_as_group)
        if run_as_non_root is not None:
            pulumi.set(__self__, "run_as_non_root", run_as_non_root)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)

    @property
    @pulumi.getter
    def privileged(self) -> Optional[bool]:
        return pulumi.get(self, "privileged")

    @property
    @pulumi.getter(name="readOnlyRootFileSystem")
    def read_only_root_file_system(self) -> Optional[bool]:
        return pulumi.get(self, "read_only_root_file_system")

    @property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional[int]:
        return pulumi.get(self, "run_as_group")

    @property
    @pulumi.getter(name="runAsNonRoot")
    def run_as_non_root(self) -> Optional[bool]:
        return pulumi.get(self, "run_as_non_root")

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[int]:
        return pulumi.get(self, "run_as_user")


@pulumi.output_type
class JobDefinitionEksPropertiesPodPropertiesContainersVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksPropertiesPodPropertiesContainersVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksPropertiesPodPropertiesContainersVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksPropertiesPodPropertiesContainersVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: str,
                 name: str,
                 read_only: Optional[bool] = None):
        """
        :param str name: Name of the job definition.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the job definition.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        return pulumi.get(self, "read_only")


@pulumi.output_type
class JobDefinitionEksPropertiesPodPropertiesImagePullSecret(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: Unique identifier.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique identifier.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class JobDefinitionEksPropertiesPodPropertiesInitContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imagePullPolicy":
            suggest = "image_pull_policy"
        elif key == "securityContext":
            suggest = "security_context"
        elif key == "volumeMounts":
            suggest = "volume_mounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksPropertiesPodPropertiesInitContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksPropertiesPodPropertiesInitContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksPropertiesPodPropertiesInitContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: str,
                 args: Optional[Sequence[str]] = None,
                 commands: Optional[Sequence[str]] = None,
                 envs: Optional[Sequence['outputs.JobDefinitionEksPropertiesPodPropertiesInitContainerEnv']] = None,
                 image_pull_policy: Optional[str] = None,
                 name: Optional[str] = None,
                 resources: Optional['outputs.JobDefinitionEksPropertiesPodPropertiesInitContainerResources'] = None,
                 security_context: Optional['outputs.JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContext'] = None,
                 volume_mounts: Optional[Sequence['outputs.JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMount']] = None):
        """
        :param str image: Docker image used to start the container.
        :param Sequence[str] args: Array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
        :param Sequence[str] commands: Entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
        :param Sequence['JobDefinitionEksPropertiesPodPropertiesInitContainerEnvArgs'] envs: Environment variables to pass to a container. See EKS Environment below.
        :param str image_pull_policy: Image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`.
        :param str name: Name of the job definition.
        :param 'JobDefinitionEksPropertiesPodPropertiesInitContainerResourcesArgs' resources: Type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`.
        :param 'JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContextArgs' security_context: Security context for a job.
        :param Sequence['JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMountArgs'] volume_mounts: Volume mounts for the container.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        Docker image used to start the container.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        Array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[str]]:
        """
        Entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.JobDefinitionEksPropertiesPodPropertiesInitContainerEnv']]:
        """
        Environment variables to pass to a container. See EKS Environment below.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[str]:
        """
        Image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`.
        """
        return pulumi.get(self, "image_pull_policy")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the job definition.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.JobDefinitionEksPropertiesPodPropertiesInitContainerResources']:
        """
        Type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional['outputs.JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContext']:
        """
        Security context for a job.
        """
        return pulumi.get(self, "security_context")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMount']]:
        """
        Volume mounts for the container.
        """
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class JobDefinitionEksPropertiesPodPropertiesInitContainerEnv(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Name of the job definition.
        :param str value: Value of the environment variable.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the job definition.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class JobDefinitionEksPropertiesPodPropertiesInitContainerResources(dict):
    def __init__(__self__, *,
                 limits: Optional[Mapping[str, str]] = None,
                 requests: Optional[Mapping[str, str]] = None):
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def requests(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "requests")


@pulumi.output_type
class JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContext(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnlyRootFileSystem":
            suggest = "read_only_root_file_system"
        elif key == "runAsGroup":
            suggest = "run_as_group"
        elif key == "runAsNonRoot":
            suggest = "run_as_non_root"
        elif key == "runAsUser":
            suggest = "run_as_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 privileged: Optional[bool] = None,
                 read_only_root_file_system: Optional[bool] = None,
                 run_as_group: Optional[int] = None,
                 run_as_non_root: Optional[bool] = None,
                 run_as_user: Optional[int] = None):
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if read_only_root_file_system is not None:
            pulumi.set(__self__, "read_only_root_file_system", read_only_root_file_system)
        if run_as_group is not None:
            pulumi.set(__self__, "run_as_group", run_as_group)
        if run_as_non_root is not None:
            pulumi.set(__self__, "run_as_non_root", run_as_non_root)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)

    @property
    @pulumi.getter
    def privileged(self) -> Optional[bool]:
        return pulumi.get(self, "privileged")

    @property
    @pulumi.getter(name="readOnlyRootFileSystem")
    def read_only_root_file_system(self) -> Optional[bool]:
        return pulumi.get(self, "read_only_root_file_system")

    @property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional[int]:
        return pulumi.get(self, "run_as_group")

    @property
    @pulumi.getter(name="runAsNonRoot")
    def run_as_non_root(self) -> Optional[bool]:
        return pulumi.get(self, "run_as_non_root")

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[int]:
        return pulumi.get(self, "run_as_user")


@pulumi.output_type
class JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: str,
                 name: str,
                 read_only: Optional[bool] = None):
        """
        :param str name: Name of the job definition.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the job definition.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        return pulumi.get(self, "read_only")


@pulumi.output_type
class JobDefinitionEksPropertiesPodPropertiesMetadata(dict):
    def __init__(__self__, *,
                 labels: Optional[Mapping[str, str]] = None):
        """
        :param Mapping[str, str] labels: Key-value pairs used to identify, sort, and organize cube resources.
        """
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        Key-value pairs used to identify, sort, and organize cube resources.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class JobDefinitionEksPropertiesPodPropertiesVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emptyDir":
            suggest = "empty_dir"
        elif key == "hostPath":
            suggest = "host_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksPropertiesPodPropertiesVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksPropertiesPodPropertiesVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksPropertiesPodPropertiesVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 empty_dir: Optional['outputs.JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDir'] = None,
                 host_path: Optional['outputs.JobDefinitionEksPropertiesPodPropertiesVolumeHostPath'] = None,
                 name: Optional[str] = None,
                 secret: Optional['outputs.JobDefinitionEksPropertiesPodPropertiesVolumeSecret'] = None):
        """
        :param str name: Name of the job definition.
        """
        if empty_dir is not None:
            pulumi.set(__self__, "empty_dir", empty_dir)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="emptyDir")
    def empty_dir(self) -> Optional['outputs.JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDir']:
        return pulumi.get(self, "empty_dir")

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional['outputs.JobDefinitionEksPropertiesPodPropertiesVolumeHostPath']:
        return pulumi.get(self, "host_path")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the job definition.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secret(self) -> Optional['outputs.JobDefinitionEksPropertiesPodPropertiesVolumeSecret']:
        return pulumi.get(self, "secret")


@pulumi.output_type
class JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDir(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeLimit":
            suggest = "size_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDir. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDir.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDir.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size_limit: str,
                 medium: Optional[str] = None):
        """
        :param str size_limit: Maximum size of the volume. By default, there's no maximum size defined.
        :param str medium: Medium to store the volume. The default value is an empty string, which uses the storage of the node.
        """
        pulumi.set(__self__, "size_limit", size_limit)
        if medium is not None:
            pulumi.set(__self__, "medium", medium)

    @property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> str:
        """
        Maximum size of the volume. By default, there's no maximum size defined.
        """
        return pulumi.get(self, "size_limit")

    @property
    @pulumi.getter
    def medium(self) -> Optional[str]:
        """
        Medium to store the volume. The default value is an empty string, which uses the storage of the node.
        """
        return pulumi.get(self, "medium")


@pulumi.output_type
class JobDefinitionEksPropertiesPodPropertiesVolumeHostPath(dict):
    def __init__(__self__, *,
                 path: str):
        """
        :param str path: Path of the file or directory on the host to mount into containers on the pod.
        """
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path of the file or directory on the host to mount into containers on the pod.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class JobDefinitionEksPropertiesPodPropertiesVolumeSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionEksPropertiesPodPropertiesVolumeSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionEksPropertiesPodPropertiesVolumeSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionEksPropertiesPodPropertiesVolumeSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_name: str,
                 optional: Optional[bool] = None):
        """
        :param str secret_name: Name of the secret. The name must be allowed as a DNS subdomain name.
        :param bool optional: Whether the secret or the secret's keys must be defined.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> str:
        """
        Name of the secret. The name must be allowed as a DNS subdomain name.
        """
        return pulumi.get(self, "secret_name")

    @property
    @pulumi.getter
    def optional(self) -> Optional[bool]:
        """
        Whether the secret or the secret's keys must be defined.
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class JobDefinitionRetryStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluateOnExits":
            suggest = "evaluate_on_exits"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionRetryStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionRetryStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionRetryStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attempts: Optional[int] = None,
                 evaluate_on_exits: Optional[Sequence['outputs.JobDefinitionRetryStrategyEvaluateOnExit']] = None):
        """
        :param int attempts: Number of times to move a job to the `RUNNABLE` status. You may specify between `1` and `10` attempts.
        :param Sequence['JobDefinitionRetryStrategyEvaluateOnExitArgs'] evaluate_on_exits: Evaluate on exit conditions under which the job should be retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. You may specify up to 5 configuration blocks.
        """
        if attempts is not None:
            pulumi.set(__self__, "attempts", attempts)
        if evaluate_on_exits is not None:
            pulumi.set(__self__, "evaluate_on_exits", evaluate_on_exits)

    @property
    @pulumi.getter
    def attempts(self) -> Optional[int]:
        """
        Number of times to move a job to the `RUNNABLE` status. You may specify between `1` and `10` attempts.
        """
        return pulumi.get(self, "attempts")

    @property
    @pulumi.getter(name="evaluateOnExits")
    def evaluate_on_exits(self) -> Optional[Sequence['outputs.JobDefinitionRetryStrategyEvaluateOnExit']]:
        """
        Evaluate on exit conditions under which the job should be retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. You may specify up to 5 configuration blocks.
        """
        return pulumi.get(self, "evaluate_on_exits")


@pulumi.output_type
class JobDefinitionRetryStrategyEvaluateOnExit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onExitCode":
            suggest = "on_exit_code"
        elif key == "onReason":
            suggest = "on_reason"
        elif key == "onStatusReason":
            suggest = "on_status_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionRetryStrategyEvaluateOnExit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionRetryStrategyEvaluateOnExit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionRetryStrategyEvaluateOnExit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 on_exit_code: Optional[str] = None,
                 on_reason: Optional[str] = None,
                 on_status_reason: Optional[str] = None):
        """
        :param str action: Action to take if all of the specified conditions are met. The values are not case sensitive. Valid values: `retry`, `exit`.
        :param str on_exit_code: Glob pattern to match against the decimal representation of the exit code returned for a job.
        :param str on_reason: Glob pattern to match against the reason returned for a job.
        :param str on_status_reason: Glob pattern to match against the status reason returned for a job.
        """
        pulumi.set(__self__, "action", action)
        if on_exit_code is not None:
            pulumi.set(__self__, "on_exit_code", on_exit_code)
        if on_reason is not None:
            pulumi.set(__self__, "on_reason", on_reason)
        if on_status_reason is not None:
            pulumi.set(__self__, "on_status_reason", on_status_reason)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Action to take if all of the specified conditions are met. The values are not case sensitive. Valid values: `retry`, `exit`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="onExitCode")
    def on_exit_code(self) -> Optional[str]:
        """
        Glob pattern to match against the decimal representation of the exit code returned for a job.
        """
        return pulumi.get(self, "on_exit_code")

    @property
    @pulumi.getter(name="onReason")
    def on_reason(self) -> Optional[str]:
        """
        Glob pattern to match against the reason returned for a job.
        """
        return pulumi.get(self, "on_reason")

    @property
    @pulumi.getter(name="onStatusReason")
    def on_status_reason(self) -> Optional[str]:
        """
        Glob pattern to match against the status reason returned for a job.
        """
        return pulumi.get(self, "on_status_reason")


@pulumi.output_type
class JobDefinitionTimeout(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attemptDurationSeconds":
            suggest = "attempt_duration_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobDefinitionTimeout. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobDefinitionTimeout.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobDefinitionTimeout.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attempt_duration_seconds: Optional[int] = None):
        """
        :param int attempt_duration_seconds: Time duration in seconds after which AWS Batch terminates your jobs if they have not finished. The minimum value for the timeout is `60` seconds.
        """
        if attempt_duration_seconds is not None:
            pulumi.set(__self__, "attempt_duration_seconds", attempt_duration_seconds)

    @property
    @pulumi.getter(name="attemptDurationSeconds")
    def attempt_duration_seconds(self) -> Optional[int]:
        """
        Time duration in seconds after which AWS Batch terminates your jobs if they have not finished. The minimum value for the timeout is `60` seconds.
        """
        return pulumi.get(self, "attempt_duration_seconds")


@pulumi.output_type
class JobQueueComputeEnvironmentOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeEnvironment":
            suggest = "compute_environment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobQueueComputeEnvironmentOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobQueueComputeEnvironmentOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobQueueComputeEnvironmentOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_environment: str,
                 order: int):
        """
        :param str compute_environment: The Amazon Resource Name (ARN) of the compute environment.
        :param int order: The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower order integer value is tried for job placement first.
        """
        pulumi.set(__self__, "compute_environment", compute_environment)
        pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter(name="computeEnvironment")
    def compute_environment(self) -> str:
        """
        The Amazon Resource Name (ARN) of the compute environment.
        """
        return pulumi.get(self, "compute_environment")

    @property
    @pulumi.getter
    def order(self) -> int:
        """
        The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower order integer value is tried for job placement first.
        """
        return pulumi.get(self, "order")


@pulumi.output_type
class JobQueueJobStateTimeLimitAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxTimeSeconds":
            suggest = "max_time_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobQueueJobStateTimeLimitAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobQueueJobStateTimeLimitAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobQueueJobStateTimeLimitAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 max_time_seconds: int,
                 reason: str,
                 state: str):
        """
        :param str action: The action to take when a job is at the head of the job queue in the specified state for the specified period of time. Valid values include `"CANCEL"`
               * `job_state_time_limit_action.#.max_time_seconds` - The approximate amount of time, in seconds, that must pass with the job in the specified state before the action is taken. Valid values include integers between `600` & `86400`
        :param str reason: The reason to log for the action being taken.
        :param str state: The state of the job needed to trigger the action. Valid values include `"RUNNABLE"`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "max_time_seconds", max_time_seconds)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The action to take when a job is at the head of the job queue in the specified state for the specified period of time. Valid values include `"CANCEL"`
        * `job_state_time_limit_action.#.max_time_seconds` - The approximate amount of time, in seconds, that must pass with the job in the specified state before the action is taken. Valid values include integers between `600` & `86400`
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="maxTimeSeconds")
    def max_time_seconds(self) -> int:
        return pulumi.get(self, "max_time_seconds")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        The reason to log for the action being taken.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the job needed to trigger the action. Valid values include `"RUNNABLE"`.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class JobQueueTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[str] = None,
                 delete: Optional[str] = None,
                 update: Optional[str] = None):
        """
        :param str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class SchedulingPolicyFairSharePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeReservation":
            suggest = "compute_reservation"
        elif key == "shareDecaySeconds":
            suggest = "share_decay_seconds"
        elif key == "shareDistributions":
            suggest = "share_distributions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchedulingPolicyFairSharePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchedulingPolicyFairSharePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchedulingPolicyFairSharePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_reservation: Optional[int] = None,
                 share_decay_seconds: Optional[int] = None,
                 share_distributions: Optional[Sequence['outputs.SchedulingPolicyFairSharePolicyShareDistribution']] = None):
        """
        :param int compute_reservation: A value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet been used. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html).
        :param Sequence['SchedulingPolicyFairSharePolicyShareDistributionArgs'] share_distributions: One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
        """
        if compute_reservation is not None:
            pulumi.set(__self__, "compute_reservation", compute_reservation)
        if share_decay_seconds is not None:
            pulumi.set(__self__, "share_decay_seconds", share_decay_seconds)
        if share_distributions is not None:
            pulumi.set(__self__, "share_distributions", share_distributions)

    @property
    @pulumi.getter(name="computeReservation")
    def compute_reservation(self) -> Optional[int]:
        """
        A value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet been used. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html).
        """
        return pulumi.get(self, "compute_reservation")

    @property
    @pulumi.getter(name="shareDecaySeconds")
    def share_decay_seconds(self) -> Optional[int]:
        return pulumi.get(self, "share_decay_seconds")

    @property
    @pulumi.getter(name="shareDistributions")
    def share_distributions(self) -> Optional[Sequence['outputs.SchedulingPolicyFairSharePolicyShareDistribution']]:
        """
        One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
        """
        return pulumi.get(self, "share_distributions")


@pulumi.output_type
class SchedulingPolicyFairSharePolicyShareDistribution(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shareIdentifier":
            suggest = "share_identifier"
        elif key == "weightFactor":
            suggest = "weight_factor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchedulingPolicyFairSharePolicyShareDistribution. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchedulingPolicyFairSharePolicyShareDistribution.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchedulingPolicyFairSharePolicyShareDistribution.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 share_identifier: str,
                 weight_factor: Optional[float] = None):
        """
        :param str share_identifier: A fair share identifier or fair share identifier prefix. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        :param float weight_factor: The weight factor for the fair share identifier. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        """
        pulumi.set(__self__, "share_identifier", share_identifier)
        if weight_factor is not None:
            pulumi.set(__self__, "weight_factor", weight_factor)

    @property
    @pulumi.getter(name="shareIdentifier")
    def share_identifier(self) -> str:
        """
        A fair share identifier or fair share identifier prefix. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        """
        return pulumi.get(self, "share_identifier")

    @property
    @pulumi.getter(name="weightFactor")
    def weight_factor(self) -> Optional[float]:
        """
        The weight factor for the fair share identifier. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        """
        return pulumi.get(self, "weight_factor")


@pulumi.output_type
class GetComputeEnvironmentUpdatePolicyResult(dict):
    def __init__(__self__, *,
                 job_execution_timeout_minutes: int,
                 terminate_jobs_on_update: bool):
        pulumi.set(__self__, "job_execution_timeout_minutes", job_execution_timeout_minutes)
        pulumi.set(__self__, "terminate_jobs_on_update", terminate_jobs_on_update)

    @property
    @pulumi.getter(name="jobExecutionTimeoutMinutes")
    def job_execution_timeout_minutes(self) -> int:
        return pulumi.get(self, "job_execution_timeout_minutes")

    @property
    @pulumi.getter(name="terminateJobsOnUpdate")
    def terminate_jobs_on_update(self) -> bool:
        return pulumi.get(self, "terminate_jobs_on_update")


@pulumi.output_type
class GetJobDefinitionEksPropertyResult(dict):
    def __init__(__self__, *,
                 pod_properties: Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyResult']):
        """
        :param Sequence['GetJobDefinitionEksPropertyPodPropertyArgs'] pod_properties: The properties for the Kubernetes pod resources of a job.
        """
        pulumi.set(__self__, "pod_properties", pod_properties)

    @property
    @pulumi.getter(name="podProperties")
    def pod_properties(self) -> Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyResult']:
        """
        The properties for the Kubernetes pod resources of a job.
        """
        return pulumi.get(self, "pod_properties")


@pulumi.output_type
class GetJobDefinitionEksPropertyPodPropertyResult(dict):
    def __init__(__self__, *,
                 containers: Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyContainerResult'],
                 dns_policy: str,
                 host_network: bool,
                 image_pull_secrets: Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyImagePullSecretResult'],
                 init_containers: Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyInitContainerResult'],
                 metadatas: Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyMetadataResult'],
                 service_account_name: str,
                 share_process_namespace: bool,
                 volumes: Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyVolumeResult']):
        """
        :param Sequence['GetJobDefinitionEksPropertyPodPropertyContainerArgs'] containers: The properties of the container that's used on the Amazon EKS pod. See containers below.
        :param str dns_policy: The DNS policy for the pod. The default value is ClusterFirst. If the hostNetwork parameter is not specified, the default is ClusterFirstWithHostNet. ClusterFirst indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node.
        :param bool host_network: Indicates if the pod uses the hosts' network IP address. The default value is true. Setting this to false enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
        :param Sequence['GetJobDefinitionEksPropertyPodPropertyInitContainerArgs'] init_containers: Containers which run before application containers, always runs to completion, and must complete successfully before the next container starts. These containers are registered with the Amazon EKS Connector agent and persists the registration information in the Kubernetes backend data store. See containers below.
        :param Sequence['GetJobDefinitionEksPropertyPodPropertyMetadataArgs'] metadatas: Metadata about the Kubernetes pod.
        :param str service_account_name: The name of the service account that's used to run the pod.
        :param bool share_process_namespace: (Optional) Indicates if the processes in a container are shared, or visible, to other containers in the same pod.
        :param Sequence['GetJobDefinitionEksPropertyPodPropertyVolumeArgs'] volumes: A list of data volumes used in a job.
        """
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "dns_policy", dns_policy)
        pulumi.set(__self__, "host_network", host_network)
        pulumi.set(__self__, "image_pull_secrets", image_pull_secrets)
        pulumi.set(__self__, "init_containers", init_containers)
        pulumi.set(__self__, "metadatas", metadatas)
        pulumi.set(__self__, "service_account_name", service_account_name)
        pulumi.set(__self__, "share_process_namespace", share_process_namespace)
        pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyContainerResult']:
        """
        The properties of the container that's used on the Amazon EKS pod. See containers below.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="dnsPolicy")
    def dns_policy(self) -> str:
        """
        The DNS policy for the pod. The default value is ClusterFirst. If the hostNetwork parameter is not specified, the default is ClusterFirstWithHostNet. ClusterFirst indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node.
        """
        return pulumi.get(self, "dns_policy")

    @property
    @pulumi.getter(name="hostNetwork")
    def host_network(self) -> bool:
        """
        Indicates if the pod uses the hosts' network IP address. The default value is true. Setting this to false enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
        """
        return pulumi.get(self, "host_network")

    @property
    @pulumi.getter(name="imagePullSecrets")
    def image_pull_secrets(self) -> Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyImagePullSecretResult']:
        return pulumi.get(self, "image_pull_secrets")

    @property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyInitContainerResult']:
        """
        Containers which run before application containers, always runs to completion, and must complete successfully before the next container starts. These containers are registered with the Amazon EKS Connector agent and persists the registration information in the Kubernetes backend data store. See containers below.
        """
        return pulumi.get(self, "init_containers")

    @property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyMetadataResult']:
        """
        Metadata about the Kubernetes pod.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> str:
        """
        The name of the service account that's used to run the pod.
        """
        return pulumi.get(self, "service_account_name")

    @property
    @pulumi.getter(name="shareProcessNamespace")
    def share_process_namespace(self) -> bool:
        """
        (Optional) Indicates if the processes in a container are shared, or visible, to other containers in the same pod.
        """
        return pulumi.get(self, "share_process_namespace")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyVolumeResult']:
        """
        A list of data volumes used in a job.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class GetJobDefinitionEksPropertyPodPropertyContainerResult(dict):
    def __init__(__self__, *,
                 args: Sequence[str],
                 commands: Sequence[str],
                 envs: Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyContainerEnvResult'],
                 image: str,
                 image_pull_policy: str,
                 name: str,
                 resources: Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyContainerResourceResult'],
                 security_contexts: Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyContainerSecurityContextResult'],
                 volume_mounts: Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyContainerVolumeMountResult']):
        """
        :param Sequence[str] args: An array of arguments to the entrypoint
        :param Sequence[str] commands: The command that's passed to the container.
        :param Sequence['GetJobDefinitionEksPropertyPodPropertyContainerEnvArgs'] envs: The environment variables to pass to a container.  Array of EksContainerEnvironmentVariable objects.
        :param str image: The image used to start a container.
        :param str image_pull_policy: The image pull policy for the container.
        :param str name: The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        :param Sequence['GetJobDefinitionEksPropertyPodPropertyContainerResourceArgs'] resources: The type and amount of resources to assign to a container.
        :param Sequence['GetJobDefinitionEksPropertyPodPropertyContainerSecurityContextArgs'] security_contexts: The security context for a job.
        :param Sequence['GetJobDefinitionEksPropertyPodPropertyContainerVolumeMountArgs'] volume_mounts: The volume mounts for the container.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "envs", envs)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "security_contexts", security_contexts)
        pulumi.set(__self__, "volume_mounts", volume_mounts)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        An array of arguments to the entrypoint
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> Sequence[str]:
        """
        The command that's passed to the container.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def envs(self) -> Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyContainerEnvResult']:
        """
        The environment variables to pass to a container.  Array of EksContainerEnvironmentVariable objects.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        The image used to start a container.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> str:
        """
        The image pull policy for the container.
        """
        return pulumi.get(self, "image_pull_policy")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyContainerResourceResult']:
        """
        The type and amount of resources to assign to a container.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="securityContexts")
    def security_contexts(self) -> Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyContainerSecurityContextResult']:
        """
        The security context for a job.
        """
        return pulumi.get(self, "security_contexts")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyContainerVolumeMountResult']:
        """
        The volume mounts for the container.
        """
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class GetJobDefinitionEksPropertyPodPropertyContainerEnvResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        :param str value: The quantity of the specified resource to reserve for the container.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The quantity of the specified resource to reserve for the container.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetJobDefinitionEksPropertyPodPropertyContainerResourceResult(dict):
    def __init__(__self__, *,
                 limits: Mapping[str, str],
                 requests: Mapping[str, str]):
        """
        :param Mapping[str, str] limits: The type and quantity of the resources to reserve for the container.
        :param Mapping[str, str] requests: The type and quantity of the resources to request for the container.
        """
        pulumi.set(__self__, "limits", limits)
        pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Mapping[str, str]:
        """
        The type and quantity of the resources to reserve for the container.
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def requests(self) -> Mapping[str, str]:
        """
        The type and quantity of the resources to request for the container.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class GetJobDefinitionEksPropertyPodPropertyContainerSecurityContextResult(dict):
    def __init__(__self__, *,
                 privileged: bool,
                 read_only_root_file_system: bool,
                 run_as_group: int,
                 run_as_non_root: bool,
                 run_as_user: int):
        """
        :param bool privileged: When this parameter is true, the container is given elevated permissions on the host container instance (similar to the root user).
        :param int run_as_group: When this parameter is specified, the container is run as the specified group ID (gid). If this parameter isn't specified, the default is the group that's specified in the image metadata.
        :param bool run_as_non_root: When this parameter is specified, the container is run as a user with a uid other than 0. If this parameter isn't specified, so such rule is enforced.
        :param int run_as_user: When this parameter is specified, the container is run as the specified user ID (uid). If this parameter isn't specified, the default is the user that's specified in the image metadata.
        """
        pulumi.set(__self__, "privileged", privileged)
        pulumi.set(__self__, "read_only_root_file_system", read_only_root_file_system)
        pulumi.set(__self__, "run_as_group", run_as_group)
        pulumi.set(__self__, "run_as_non_root", run_as_non_root)
        pulumi.set(__self__, "run_as_user", run_as_user)

    @property
    @pulumi.getter
    def privileged(self) -> bool:
        """
        When this parameter is true, the container is given elevated permissions on the host container instance (similar to the root user).
        """
        return pulumi.get(self, "privileged")

    @property
    @pulumi.getter(name="readOnlyRootFileSystem")
    def read_only_root_file_system(self) -> bool:
        return pulumi.get(self, "read_only_root_file_system")

    @property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> int:
        """
        When this parameter is specified, the container is run as the specified group ID (gid). If this parameter isn't specified, the default is the group that's specified in the image metadata.
        """
        return pulumi.get(self, "run_as_group")

    @property
    @pulumi.getter(name="runAsNonRoot")
    def run_as_non_root(self) -> bool:
        """
        When this parameter is specified, the container is run as a user with a uid other than 0. If this parameter isn't specified, so such rule is enforced.
        """
        return pulumi.get(self, "run_as_non_root")

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> int:
        """
        When this parameter is specified, the container is run as the specified user ID (uid). If this parameter isn't specified, the default is the user that's specified in the image metadata.
        """
        return pulumi.get(self, "run_as_user")


@pulumi.output_type
class GetJobDefinitionEksPropertyPodPropertyContainerVolumeMountResult(dict):
    def __init__(__self__, *,
                 mount_path: str,
                 name: str,
                 read_only: bool):
        """
        :param str mount_path: The path on the container where the volume is mounted.
        :param str name: The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        :param bool read_only: If this value is true, the container has read-only access to the volume.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        """
        The path on the container where the volume is mounted.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> bool:
        """
        If this value is true, the container has read-only access to the volume.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class GetJobDefinitionEksPropertyPodPropertyImagePullSecretResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetJobDefinitionEksPropertyPodPropertyInitContainerResult(dict):
    def __init__(__self__, *,
                 args: Sequence[str],
                 commands: Sequence[str],
                 envs: Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyInitContainerEnvResult'],
                 image: str,
                 image_pull_policy: str,
                 name: str,
                 resources: Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyInitContainerResourceResult'],
                 security_contexts: Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyInitContainerSecurityContextResult'],
                 volume_mounts: Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyInitContainerVolumeMountResult']):
        """
        :param Sequence[str] args: An array of arguments to the entrypoint
        :param Sequence[str] commands: The command that's passed to the container.
        :param Sequence['GetJobDefinitionEksPropertyPodPropertyInitContainerEnvArgs'] envs: The environment variables to pass to a container.  Array of EksContainerEnvironmentVariable objects.
        :param str image: The image used to start a container.
        :param str image_pull_policy: The image pull policy for the container.
        :param str name: The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        :param Sequence['GetJobDefinitionEksPropertyPodPropertyInitContainerResourceArgs'] resources: The type and amount of resources to assign to a container.
        :param Sequence['GetJobDefinitionEksPropertyPodPropertyInitContainerSecurityContextArgs'] security_contexts: The security context for a job.
        :param Sequence['GetJobDefinitionEksPropertyPodPropertyInitContainerVolumeMountArgs'] volume_mounts: The volume mounts for the container.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "envs", envs)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "security_contexts", security_contexts)
        pulumi.set(__self__, "volume_mounts", volume_mounts)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        An array of arguments to the entrypoint
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> Sequence[str]:
        """
        The command that's passed to the container.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def envs(self) -> Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyInitContainerEnvResult']:
        """
        The environment variables to pass to a container.  Array of EksContainerEnvironmentVariable objects.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        The image used to start a container.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> str:
        """
        The image pull policy for the container.
        """
        return pulumi.get(self, "image_pull_policy")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyInitContainerResourceResult']:
        """
        The type and amount of resources to assign to a container.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="securityContexts")
    def security_contexts(self) -> Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyInitContainerSecurityContextResult']:
        """
        The security context for a job.
        """
        return pulumi.get(self, "security_contexts")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyInitContainerVolumeMountResult']:
        """
        The volume mounts for the container.
        """
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class GetJobDefinitionEksPropertyPodPropertyInitContainerEnvResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        :param str value: The quantity of the specified resource to reserve for the container.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The quantity of the specified resource to reserve for the container.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetJobDefinitionEksPropertyPodPropertyInitContainerResourceResult(dict):
    def __init__(__self__, *,
                 limits: Mapping[str, str],
                 requests: Mapping[str, str]):
        """
        :param Mapping[str, str] limits: The type and quantity of the resources to reserve for the container.
        :param Mapping[str, str] requests: The type and quantity of the resources to request for the container.
        """
        pulumi.set(__self__, "limits", limits)
        pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Mapping[str, str]:
        """
        The type and quantity of the resources to reserve for the container.
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def requests(self) -> Mapping[str, str]:
        """
        The type and quantity of the resources to request for the container.
        """
        return pulumi.get(self, "requests")


@pulumi.output_type
class GetJobDefinitionEksPropertyPodPropertyInitContainerSecurityContextResult(dict):
    def __init__(__self__, *,
                 privileged: bool,
                 read_only_root_file_system: bool,
                 run_as_group: int,
                 run_as_non_root: bool,
                 run_as_user: int):
        """
        :param bool privileged: When this parameter is true, the container is given elevated permissions on the host container instance (similar to the root user).
        :param int run_as_group: When this parameter is specified, the container is run as the specified group ID (gid). If this parameter isn't specified, the default is the group that's specified in the image metadata.
        :param bool run_as_non_root: When this parameter is specified, the container is run as a user with a uid other than 0. If this parameter isn't specified, so such rule is enforced.
        :param int run_as_user: When this parameter is specified, the container is run as the specified user ID (uid). If this parameter isn't specified, the default is the user that's specified in the image metadata.
        """
        pulumi.set(__self__, "privileged", privileged)
        pulumi.set(__self__, "read_only_root_file_system", read_only_root_file_system)
        pulumi.set(__self__, "run_as_group", run_as_group)
        pulumi.set(__self__, "run_as_non_root", run_as_non_root)
        pulumi.set(__self__, "run_as_user", run_as_user)

    @property
    @pulumi.getter
    def privileged(self) -> bool:
        """
        When this parameter is true, the container is given elevated permissions on the host container instance (similar to the root user).
        """
        return pulumi.get(self, "privileged")

    @property
    @pulumi.getter(name="readOnlyRootFileSystem")
    def read_only_root_file_system(self) -> bool:
        return pulumi.get(self, "read_only_root_file_system")

    @property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> int:
        """
        When this parameter is specified, the container is run as the specified group ID (gid). If this parameter isn't specified, the default is the group that's specified in the image metadata.
        """
        return pulumi.get(self, "run_as_group")

    @property
    @pulumi.getter(name="runAsNonRoot")
    def run_as_non_root(self) -> bool:
        """
        When this parameter is specified, the container is run as a user with a uid other than 0. If this parameter isn't specified, so such rule is enforced.
        """
        return pulumi.get(self, "run_as_non_root")

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> int:
        """
        When this parameter is specified, the container is run as the specified user ID (uid). If this parameter isn't specified, the default is the user that's specified in the image metadata.
        """
        return pulumi.get(self, "run_as_user")


@pulumi.output_type
class GetJobDefinitionEksPropertyPodPropertyInitContainerVolumeMountResult(dict):
    def __init__(__self__, *,
                 mount_path: str,
                 name: str,
                 read_only: bool):
        """
        :param str mount_path: The path on the container where the volume is mounted.
        :param str name: The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        :param bool read_only: If this value is true, the container has read-only access to the volume.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        """
        The path on the container where the volume is mounted.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> bool:
        """
        If this value is true, the container has read-only access to the volume.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class GetJobDefinitionEksPropertyPodPropertyMetadataResult(dict):
    def __init__(__self__, *,
                 labels: Mapping[str, str]):
        """
        :param Mapping[str, str] labels: Key-value pairs used to identify, sort, and organize cube resources.
        """
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Key-value pairs used to identify, sort, and organize cube resources.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class GetJobDefinitionEksPropertyPodPropertyVolumeResult(dict):
    def __init__(__self__, *,
                 empty_dirs: Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyVolumeEmptyDirResult'],
                 host_paths: Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyVolumeHostPathResult'],
                 name: str,
                 secrets: Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyVolumeSecretResult']):
        """
        :param Sequence['GetJobDefinitionEksPropertyPodPropertyVolumeEmptyDirArgs'] empty_dirs: Specifies the configuration of a Kubernetes emptyDir volume.
        :param Sequence['GetJobDefinitionEksPropertyPodPropertyVolumeHostPathArgs'] host_paths: The path for the device on the host container instance.
        :param str name: The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        :param Sequence['GetJobDefinitionEksPropertyPodPropertyVolumeSecretArgs'] secrets: Specifies the configuration of a Kubernetes secret volume.
        """
        pulumi.set(__self__, "empty_dirs", empty_dirs)
        pulumi.set(__self__, "host_paths", host_paths)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="emptyDirs")
    def empty_dirs(self) -> Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyVolumeEmptyDirResult']:
        """
        Specifies the configuration of a Kubernetes emptyDir volume.
        """
        return pulumi.get(self, "empty_dirs")

    @property
    @pulumi.getter(name="hostPaths")
    def host_paths(self) -> Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyVolumeHostPathResult']:
        """
        The path for the device on the host container instance.
        """
        return pulumi.get(self, "host_paths")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secrets(self) -> Sequence['outputs.GetJobDefinitionEksPropertyPodPropertyVolumeSecretResult']:
        """
        Specifies the configuration of a Kubernetes secret volume.
        """
        return pulumi.get(self, "secrets")


@pulumi.output_type
class GetJobDefinitionEksPropertyPodPropertyVolumeEmptyDirResult(dict):
    def __init__(__self__, *,
                 medium: str,
                 size_limit: str):
        """
        :param str medium: The medium to store the volume.
        :param str size_limit: The maximum size of the volume. By default, there's no maximum size defined.
        """
        pulumi.set(__self__, "medium", medium)
        pulumi.set(__self__, "size_limit", size_limit)

    @property
    @pulumi.getter
    def medium(self) -> str:
        """
        The medium to store the volume.
        """
        return pulumi.get(self, "medium")

    @property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> str:
        """
        The maximum size of the volume. By default, there's no maximum size defined.
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class GetJobDefinitionEksPropertyPodPropertyVolumeHostPathResult(dict):
    def __init__(__self__, *,
                 path: str):
        """
        :param str path: The path of the file or directory on the host to mount into containers on the pod.
        """
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path of the file or directory on the host to mount into containers on the pod.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetJobDefinitionEksPropertyPodPropertyVolumeSecretResult(dict):
    def __init__(__self__, *,
                 optional: bool,
                 secret_name: str):
        """
        :param bool optional: Specifies whether the secret or the secret's keys must be defined.
        :param str secret_name: The name of the secret. The name must be allowed as a DNS subdomain name
        """
        pulumi.set(__self__, "optional", optional)
        pulumi.set(__self__, "secret_name", secret_name)

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Specifies whether the secret or the secret's keys must be defined.
        """
        return pulumi.get(self, "optional")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> str:
        """
        The name of the secret. The name must be allowed as a DNS subdomain name
        """
        return pulumi.get(self, "secret_name")


@pulumi.output_type
class GetJobDefinitionNodePropertyResult(dict):
    def __init__(__self__, *,
                 main_node: int,
                 node_range_properties: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyResult'],
                 num_nodes: int):
        """
        :param int main_node: Specifies the node index for the main node of a multi-node parallel job. This node index value must be fewer than the number of nodes.
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyArgs'] node_range_properties: A list of node ranges and their properties that are associated with a multi-node parallel job.
        :param int num_nodes: The number of nodes that are associated with a multi-node parallel job.
        """
        pulumi.set(__self__, "main_node", main_node)
        pulumi.set(__self__, "node_range_properties", node_range_properties)
        pulumi.set(__self__, "num_nodes", num_nodes)

    @property
    @pulumi.getter(name="mainNode")
    def main_node(self) -> int:
        """
        Specifies the node index for the main node of a multi-node parallel job. This node index value must be fewer than the number of nodes.
        """
        return pulumi.get(self, "main_node")

    @property
    @pulumi.getter(name="nodeRangeProperties")
    def node_range_properties(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyResult']:
        """
        A list of node ranges and their properties that are associated with a multi-node parallel job.
        """
        return pulumi.get(self, "node_range_properties")

    @property
    @pulumi.getter(name="numNodes")
    def num_nodes(self) -> int:
        """
        The number of nodes that are associated with a multi-node parallel job.
        """
        return pulumi.get(self, "num_nodes")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyResult(dict):
    def __init__(__self__, *,
                 containers: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerResult'],
                 target_nodes: str):
        """
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerArgs'] containers: The container details for the node range.
        :param str target_nodes: The range of nodes, using node index values. A range of 0:3 indicates nodes with index values of 0 through 3. I
        """
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "target_nodes", target_nodes)

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerResult']:
        """
        The container details for the node range.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="targetNodes")
    def target_nodes(self) -> str:
        """
        The range of nodes, using node index values. A range of 0:3 indicates nodes with index values of 0 through 3. I
        """
        return pulumi.get(self, "target_nodes")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerResult(dict):
    def __init__(__self__, *,
                 commands: Sequence[str],
                 environments: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerEnvironmentResult'],
                 ephemeral_storages: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerEphemeralStorageResult'],
                 execution_role_arn: str,
                 fargate_platform_configurations: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerFargatePlatformConfigurationResult'],
                 image: str,
                 instance_type: str,
                 job_role_arn: str,
                 linux_parameters: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterResult'],
                 log_configurations: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfigurationResult'],
                 mount_points: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerMountPointResult'],
                 network_configurations: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerNetworkConfigurationResult'],
                 privileged: bool,
                 readonly_root_filesystem: bool,
                 resource_requirements: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerResourceRequirementResult'],
                 runtime_platforms: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerRuntimePlatformResult'],
                 secrets: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerSecretResult'],
                 ulimits: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerUlimitResult'],
                 user: str,
                 volumes: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeResult']):
        """
        :param Sequence[str] commands: The command that's passed to the container.
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerEnvironmentArgs'] environments: The environment variables to pass to a container.
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerEphemeralStorageArgs'] ephemeral_storages: The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate.
        :param str execution_role_arn: The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role.
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerFargatePlatformConfigurationArgs'] fargate_platform_configurations: The platform configuration for jobs that are running on Fargate resources. Jobs that are running on EC2 resources must not specify this parameter.
        :param str image: The image used to start a container.
        :param str instance_type: The instance type to use for a multi-node parallel job.
        :param str job_role_arn: The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions.
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterArgs'] linux_parameters: Linux-specific modifications that are applied to the container.
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfigurationArgs'] log_configurations: The log configuration specification for the container.
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerMountPointArgs'] mount_points: The mount points for data volumes in your container.
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerNetworkConfigurationArgs'] network_configurations: The network configuration for jobs that are running on Fargate resources.
        :param bool privileged: When this parameter is true, the container is given elevated permissions on the host container instance (similar to the root user).
        :param bool readonly_root_filesystem: When this parameter is true, the container is given read-only access to its root file system.
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerResourceRequirementArgs'] resource_requirements: The type and amount of resources to assign to a container.
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerRuntimePlatformArgs'] runtime_platforms: An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerSecretArgs'] secrets: The secrets for the container.
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerUlimitArgs'] ulimits: A list of ulimits to set in the container.
        :param str user: The user name to use inside the container.
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeArgs'] volumes: A list of data volumes used in a job.
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "environments", environments)
        pulumi.set(__self__, "ephemeral_storages", ephemeral_storages)
        pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        pulumi.set(__self__, "fargate_platform_configurations", fargate_platform_configurations)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "job_role_arn", job_role_arn)
        pulumi.set(__self__, "linux_parameters", linux_parameters)
        pulumi.set(__self__, "log_configurations", log_configurations)
        pulumi.set(__self__, "mount_points", mount_points)
        pulumi.set(__self__, "network_configurations", network_configurations)
        pulumi.set(__self__, "privileged", privileged)
        pulumi.set(__self__, "readonly_root_filesystem", readonly_root_filesystem)
        pulumi.set(__self__, "resource_requirements", resource_requirements)
        pulumi.set(__self__, "runtime_platforms", runtime_platforms)
        pulumi.set(__self__, "secrets", secrets)
        pulumi.set(__self__, "ulimits", ulimits)
        pulumi.set(__self__, "user", user)
        pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[str]:
        """
        The command that's passed to the container.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def environments(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerEnvironmentResult']:
        """
        The environment variables to pass to a container.
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter(name="ephemeralStorages")
    def ephemeral_storages(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerEphemeralStorageResult']:
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on AWS Fargate.
        """
        return pulumi.get(self, "ephemeral_storages")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume. For jobs that run on Fargate resources, you must provide an execution role.
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="fargatePlatformConfigurations")
    def fargate_platform_configurations(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerFargatePlatformConfigurationResult']:
        """
        The platform configuration for jobs that are running on Fargate resources. Jobs that are running on EC2 resources must not specify this parameter.
        """
        return pulumi.get(self, "fargate_platform_configurations")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        The image used to start a container.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The instance type to use for a multi-node parallel job.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="jobRoleArn")
    def job_role_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions.
        """
        return pulumi.get(self, "job_role_arn")

    @property
    @pulumi.getter(name="linuxParameters")
    def linux_parameters(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterResult']:
        """
        Linux-specific modifications that are applied to the container.
        """
        return pulumi.get(self, "linux_parameters")

    @property
    @pulumi.getter(name="logConfigurations")
    def log_configurations(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfigurationResult']:
        """
        The log configuration specification for the container.
        """
        return pulumi.get(self, "log_configurations")

    @property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerMountPointResult']:
        """
        The mount points for data volumes in your container.
        """
        return pulumi.get(self, "mount_points")

    @property
    @pulumi.getter(name="networkConfigurations")
    def network_configurations(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerNetworkConfigurationResult']:
        """
        The network configuration for jobs that are running on Fargate resources.
        """
        return pulumi.get(self, "network_configurations")

    @property
    @pulumi.getter
    def privileged(self) -> bool:
        """
        When this parameter is true, the container is given elevated permissions on the host container instance (similar to the root user).
        """
        return pulumi.get(self, "privileged")

    @property
    @pulumi.getter(name="readonlyRootFilesystem")
    def readonly_root_filesystem(self) -> bool:
        """
        When this parameter is true, the container is given read-only access to its root file system.
        """
        return pulumi.get(self, "readonly_root_filesystem")

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerResourceRequirementResult']:
        """
        The type and amount of resources to assign to a container.
        """
        return pulumi.get(self, "resource_requirements")

    @property
    @pulumi.getter(name="runtimePlatforms")
    def runtime_platforms(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerRuntimePlatformResult']:
        """
        An object that represents the compute environment architecture for AWS Batch jobs on Fargate.
        """
        return pulumi.get(self, "runtime_platforms")

    @property
    @pulumi.getter
    def secrets(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerSecretResult']:
        """
        The secrets for the container.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter
    def ulimits(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerUlimitResult']:
        """
        A list of ulimits to set in the container.
        """
        return pulumi.get(self, "ulimits")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The user name to use inside the container.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeResult']:
        """
        A list of data volumes used in a job.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerEnvironmentResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        :param str value: The quantity of the specified resource to reserve for the container.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The quantity of the specified resource to reserve for the container.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerEphemeralStorageResult(dict):
    def __init__(__self__, *,
                 size_in_gib: int):
        pulumi.set(__self__, "size_in_gib", size_in_gib)

    @property
    @pulumi.getter(name="sizeInGib")
    def size_in_gib(self) -> int:
        return pulumi.get(self, "size_in_gib")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerFargatePlatformConfigurationResult(dict):
    def __init__(__self__, *,
                 platform_version: str):
        """
        :param str platform_version: The AWS Fargate platform version where the jobs are running. A platform version is specified only for jobs that are running on Fargate resources.
        """
        pulumi.set(__self__, "platform_version", platform_version)

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> str:
        """
        The AWS Fargate platform version where the jobs are running. A platform version is specified only for jobs that are running on Fargate resources.
        """
        return pulumi.get(self, "platform_version")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterResult(dict):
    def __init__(__self__, *,
                 devices: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterDeviceResult'],
                 init_process_enabled: bool,
                 max_swap: int,
                 shared_memory_size: int,
                 swappiness: int,
                 tmpfs: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterTmpfResult']):
        """
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterDeviceArgs'] devices: Any of the host devices to expose to the container.
        :param bool init_process_enabled: If true, run an init process inside the container that forwards signals and reaps processes.
        :param int max_swap: The total amount of swap memory (in MiB) a container can use.
        :param int shared_memory_size: The value for the size (in MiB) of the `/dev/shm` volume.
        :param int swappiness: You can use this parameter to tune a container's memory swappiness behavior.
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterTmpfArgs'] tmpfs: The container path, mount options, and size (in MiB) of the tmpfs mount.
        """
        pulumi.set(__self__, "devices", devices)
        pulumi.set(__self__, "init_process_enabled", init_process_enabled)
        pulumi.set(__self__, "max_swap", max_swap)
        pulumi.set(__self__, "shared_memory_size", shared_memory_size)
        pulumi.set(__self__, "swappiness", swappiness)
        pulumi.set(__self__, "tmpfs", tmpfs)

    @property
    @pulumi.getter
    def devices(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterDeviceResult']:
        """
        Any of the host devices to expose to the container.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter(name="initProcessEnabled")
    def init_process_enabled(self) -> bool:
        """
        If true, run an init process inside the container that forwards signals and reaps processes.
        """
        return pulumi.get(self, "init_process_enabled")

    @property
    @pulumi.getter(name="maxSwap")
    def max_swap(self) -> int:
        """
        The total amount of swap memory (in MiB) a container can use.
        """
        return pulumi.get(self, "max_swap")

    @property
    @pulumi.getter(name="sharedMemorySize")
    def shared_memory_size(self) -> int:
        """
        The value for the size (in MiB) of the `/dev/shm` volume.
        """
        return pulumi.get(self, "shared_memory_size")

    @property
    @pulumi.getter
    def swappiness(self) -> int:
        """
        You can use this parameter to tune a container's memory swappiness behavior.
        """
        return pulumi.get(self, "swappiness")

    @property
    @pulumi.getter
    def tmpfs(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterTmpfResult']:
        """
        The container path, mount options, and size (in MiB) of the tmpfs mount.
        """
        return pulumi.get(self, "tmpfs")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterDeviceResult(dict):
    def __init__(__self__, *,
                 container_path: str,
                 host_path: str,
                 permissions: Sequence[str]):
        """
        :param str container_path: The absolute file path in the container where the tmpfs volume is mounted.
        :param str host_path: The path for the device on the host container instance.
        :param Sequence[str] permissions: The explicit permissions to provide to the container for the device.
        """
        pulumi.set(__self__, "container_path", container_path)
        pulumi.set(__self__, "host_path", host_path)
        pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> str:
        """
        The absolute file path in the container where the tmpfs volume is mounted.
        """
        return pulumi.get(self, "container_path")

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> str:
        """
        The path for the device on the host container instance.
        """
        return pulumi.get(self, "host_path")

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[str]:
        """
        The explicit permissions to provide to the container for the device.
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerLinuxParameterTmpfResult(dict):
    def __init__(__self__, *,
                 container_path: str,
                 mount_options: Sequence[str],
                 size: int):
        """
        :param str container_path: The absolute file path in the container where the tmpfs volume is mounted.
        :param Sequence[str] mount_options: The list of tmpfs volume mount options.
        :param int size: The size (in MiB) of the tmpfs volume.
        """
        pulumi.set(__self__, "container_path", container_path)
        pulumi.set(__self__, "mount_options", mount_options)
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> str:
        """
        The absolute file path in the container where the tmpfs volume is mounted.
        """
        return pulumi.get(self, "container_path")

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Sequence[str]:
        """
        The list of tmpfs volume mount options.
        """
        return pulumi.get(self, "mount_options")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size (in MiB) of the tmpfs volume.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfigurationResult(dict):
    def __init__(__self__, *,
                 log_driver: str,
                 options: Mapping[str, str],
                 secret_options: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfigurationSecretOptionResult']):
        """
        :param str log_driver: The log driver to use for the container.
        :param Mapping[str, str] options: The configuration options to send to the log driver.
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfigurationSecretOptionArgs'] secret_options: The secrets to pass to the log configuration.
        """
        pulumi.set(__self__, "log_driver", log_driver)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "secret_options", secret_options)

    @property
    @pulumi.getter(name="logDriver")
    def log_driver(self) -> str:
        """
        The log driver to use for the container.
        """
        return pulumi.get(self, "log_driver")

    @property
    @pulumi.getter
    def options(self) -> Mapping[str, str]:
        """
        The configuration options to send to the log driver.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="secretOptions")
    def secret_options(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfigurationSecretOptionResult']:
        """
        The secrets to pass to the log configuration.
        """
        return pulumi.get(self, "secret_options")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerLogConfigurationSecretOptionResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value_from: str):
        """
        :param str name: The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        :param str value_from: The secret to expose to the container. The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> str:
        """
        The secret to expose to the container. The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.
        """
        return pulumi.get(self, "value_from")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerMountPointResult(dict):
    def __init__(__self__, *,
                 container_path: str,
                 read_only: bool,
                 source_volume: str):
        """
        :param str container_path: The absolute file path in the container where the tmpfs volume is mounted.
        :param bool read_only: If this value is true, the container has read-only access to the volume.
        :param str source_volume: The name of the volume to mount.
        """
        pulumi.set(__self__, "container_path", container_path)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "source_volume", source_volume)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> str:
        """
        The absolute file path in the container where the tmpfs volume is mounted.
        """
        return pulumi.get(self, "container_path")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> bool:
        """
        If this value is true, the container has read-only access to the volume.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="sourceVolume")
    def source_volume(self) -> str:
        """
        The name of the volume to mount.
        """
        return pulumi.get(self, "source_volume")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 assign_public_ip: bool):
        """
        :param bool assign_public_ip: Indicates whether the job has a public IP address.
        """
        pulumi.set(__self__, "assign_public_ip", assign_public_ip)

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> bool:
        """
        Indicates whether the job has a public IP address.
        """
        return pulumi.get(self, "assign_public_ip")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerResourceRequirementResult(dict):
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        :param str type: The type of resource to assign to a container. The supported resources include `GPU`, `MEMORY`, and `VCPU`.
        :param str value: The quantity of the specified resource to reserve for the container.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of resource to assign to a container. The supported resources include `GPU`, `MEMORY`, and `VCPU`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The quantity of the specified resource to reserve for the container.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerRuntimePlatformResult(dict):
    def __init__(__self__, *,
                 cpu_architecture: str,
                 operating_system_family: str):
        """
        :param str cpu_architecture: The vCPU architecture. The default value is X86_64. Valid values are X86_64 and ARM64.
        :param str operating_system_family: The operating system for the compute environment. V
        """
        pulumi.set(__self__, "cpu_architecture", cpu_architecture)
        pulumi.set(__self__, "operating_system_family", operating_system_family)

    @property
    @pulumi.getter(name="cpuArchitecture")
    def cpu_architecture(self) -> str:
        """
        The vCPU architecture. The default value is X86_64. Valid values are X86_64 and ARM64.
        """
        return pulumi.get(self, "cpu_architecture")

    @property
    @pulumi.getter(name="operatingSystemFamily")
    def operating_system_family(self) -> str:
        """
        The operating system for the compute environment. V
        """
        return pulumi.get(self, "operating_system_family")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerSecretResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value_from: str):
        """
        :param str name: The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        :param str value_from: The secret to expose to the container. The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> str:
        """
        The secret to expose to the container. The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.
        """
        return pulumi.get(self, "value_from")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerUlimitResult(dict):
    def __init__(__self__, *,
                 hard_limit: int,
                 name: str,
                 soft_limit: int):
        """
        :param int hard_limit: The hard limit for the ulimit type.
        :param str name: The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        :param int soft_limit: The soft limit for the ulimit type.
        """
        pulumi.set(__self__, "hard_limit", hard_limit)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "soft_limit", soft_limit)

    @property
    @pulumi.getter(name="hardLimit")
    def hard_limit(self) -> int:
        """
        The hard limit for the ulimit type.
        """
        return pulumi.get(self, "hard_limit")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="softLimit")
    def soft_limit(self) -> int:
        """
        The soft limit for the ulimit type.
        """
        return pulumi.get(self, "soft_limit")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeResult(dict):
    def __init__(__self__, *,
                 efs_volume_configurations: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfigurationResult'],
                 hosts: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeHostResult'],
                 name: str):
        """
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfigurationArgs'] efs_volume_configurations: This parameter is specified when you're using an Amazon Elastic File System file system for job storage.
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeHostArgs'] hosts: The contents of the host parameter determine whether your data volume persists on the host container instance and where it's stored.
        :param str name: The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        """
        pulumi.set(__self__, "efs_volume_configurations", efs_volume_configurations)
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="efsVolumeConfigurations")
    def efs_volume_configurations(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfigurationResult']:
        """
        This parameter is specified when you're using an Amazon Elastic File System file system for job storage.
        """
        return pulumi.get(self, "efs_volume_configurations")

    @property
    @pulumi.getter
    def hosts(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeHostResult']:
        """
        The contents of the host parameter determine whether your data volume persists on the host container instance and where it's stored.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfigurationResult(dict):
    def __init__(__self__, *,
                 authorization_configs: Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfigurationAuthorizationConfigResult'],
                 file_system_id: str,
                 root_directory: str,
                 transit_encryption: str,
                 transit_encryption_port: int):
        """
        :param Sequence['GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfigurationAuthorizationConfigArgs'] authorization_configs: The authorization configuration details for the Amazon EFS file system.
        :param str file_system_id: The Amazon EFS file system ID to use.
        :param str root_directory: The directory within the Amazon EFS file system to mount as the root directory inside the host.
        :param str transit_encryption: Determines whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server
        :param int transit_encryption_port: The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
        """
        pulumi.set(__self__, "authorization_configs", authorization_configs)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "root_directory", root_directory)
        pulumi.set(__self__, "transit_encryption", transit_encryption)
        pulumi.set(__self__, "transit_encryption_port", transit_encryption_port)

    @property
    @pulumi.getter(name="authorizationConfigs")
    def authorization_configs(self) -> Sequence['outputs.GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfigurationAuthorizationConfigResult']:
        """
        The authorization configuration details for the Amazon EFS file system.
        """
        return pulumi.get(self, "authorization_configs")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> str:
        """
        The Amazon EFS file system ID to use.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> str:
        """
        The directory within the Amazon EFS file system to mount as the root directory inside the host.
        """
        return pulumi.get(self, "root_directory")

    @property
    @pulumi.getter(name="transitEncryption")
    def transit_encryption(self) -> str:
        """
        Determines whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server
        """
        return pulumi.get(self, "transit_encryption")

    @property
    @pulumi.getter(name="transitEncryptionPort")
    def transit_encryption_port(self) -> int:
        """
        The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
        """
        return pulumi.get(self, "transit_encryption_port")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeEfsVolumeConfigurationAuthorizationConfigResult(dict):
    def __init__(__self__, *,
                 access_point_id: str,
                 iam: str):
        """
        :param str access_point_id: The Amazon EFS access point ID to use.
        :param str iam: Whether or not to use the AWS Batch job IAM role defined in a job definition when mounting the Amazon EFS file system.
        """
        pulumi.set(__self__, "access_point_id", access_point_id)
        pulumi.set(__self__, "iam", iam)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> str:
        """
        The Amazon EFS access point ID to use.
        """
        return pulumi.get(self, "access_point_id")

    @property
    @pulumi.getter
    def iam(self) -> str:
        """
        Whether or not to use the AWS Batch job IAM role defined in a job definition when mounting the Amazon EFS file system.
        """
        return pulumi.get(self, "iam")


@pulumi.output_type
class GetJobDefinitionNodePropertyNodeRangePropertyContainerVolumeHostResult(dict):
    def __init__(__self__, *,
                 source_path: str):
        """
        :param str source_path: The path on the host container instance that's presented to the container.
        """
        pulumi.set(__self__, "source_path", source_path)

    @property
    @pulumi.getter(name="sourcePath")
    def source_path(self) -> str:
        """
        The path on the host container instance that's presented to the container.
        """
        return pulumi.get(self, "source_path")


@pulumi.output_type
class GetJobDefinitionRetryStrategyResult(dict):
    def __init__(__self__, *,
                 attempts: int,
                 evaluate_on_exits: Sequence['outputs.GetJobDefinitionRetryStrategyEvaluateOnExitResult']):
        """
        :param int attempts: The number of times to move a job to the RUNNABLE status.
        :param Sequence['GetJobDefinitionRetryStrategyEvaluateOnExitArgs'] evaluate_on_exits: Array of up to 5 objects that specify the conditions where jobs are retried or failed.
        """
        pulumi.set(__self__, "attempts", attempts)
        pulumi.set(__self__, "evaluate_on_exits", evaluate_on_exits)

    @property
    @pulumi.getter
    def attempts(self) -> int:
        """
        The number of times to move a job to the RUNNABLE status.
        """
        return pulumi.get(self, "attempts")

    @property
    @pulumi.getter(name="evaluateOnExits")
    def evaluate_on_exits(self) -> Sequence['outputs.GetJobDefinitionRetryStrategyEvaluateOnExitResult']:
        """
        Array of up to 5 objects that specify the conditions where jobs are retried or failed.
        """
        return pulumi.get(self, "evaluate_on_exits")


@pulumi.output_type
class GetJobDefinitionRetryStrategyEvaluateOnExitResult(dict):
    def __init__(__self__, *,
                 action: str,
                 on_exit_code: str,
                 on_reason: str,
                 on_status_reason: str):
        """
        :param str action: Specifies the action to take if all of the specified conditions (onStatusReason, onReason, and onExitCode) are met. The values aren't case sensitive.
        :param str on_exit_code: Contains a glob pattern to match against the decimal representation of the ExitCode returned for a job.
        :param str on_reason: Contains a glob pattern to match against the Reason returned for a job.
        :param str on_status_reason: Contains a glob pattern to match against the StatusReason returned for a job.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "on_exit_code", on_exit_code)
        pulumi.set(__self__, "on_reason", on_reason)
        pulumi.set(__self__, "on_status_reason", on_status_reason)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Specifies the action to take if all of the specified conditions (onStatusReason, onReason, and onExitCode) are met. The values aren't case sensitive.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="onExitCode")
    def on_exit_code(self) -> str:
        """
        Contains a glob pattern to match against the decimal representation of the ExitCode returned for a job.
        """
        return pulumi.get(self, "on_exit_code")

    @property
    @pulumi.getter(name="onReason")
    def on_reason(self) -> str:
        """
        Contains a glob pattern to match against the Reason returned for a job.
        """
        return pulumi.get(self, "on_reason")

    @property
    @pulumi.getter(name="onStatusReason")
    def on_status_reason(self) -> str:
        """
        Contains a glob pattern to match against the StatusReason returned for a job.
        """
        return pulumi.get(self, "on_status_reason")


@pulumi.output_type
class GetJobDefinitionTimeoutResult(dict):
    def __init__(__self__, *,
                 attempt_duration_seconds: int):
        """
        :param int attempt_duration_seconds: The job timeout time (in seconds) that's measured from the job attempt's startedAt timestamp.
        """
        pulumi.set(__self__, "attempt_duration_seconds", attempt_duration_seconds)

    @property
    @pulumi.getter(name="attemptDurationSeconds")
    def attempt_duration_seconds(self) -> int:
        """
        The job timeout time (in seconds) that's measured from the job attempt's startedAt timestamp.
        """
        return pulumi.get(self, "attempt_duration_seconds")


@pulumi.output_type
class GetJobQueueComputeEnvironmentOrderResult(dict):
    def __init__(__self__, *,
                 compute_environment: str,
                 order: int):
        pulumi.set(__self__, "compute_environment", compute_environment)
        pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter(name="computeEnvironment")
    def compute_environment(self) -> str:
        return pulumi.get(self, "compute_environment")

    @property
    @pulumi.getter
    def order(self) -> int:
        return pulumi.get(self, "order")


@pulumi.output_type
class GetJobQueueJobStateTimeLimitActionResult(dict):
    def __init__(__self__, *,
                 action: str,
                 max_time_seconds: int,
                 reason: str,
                 state: str):
        """
        :param str state: Describes the ability of the queue to accept new jobs (for example, `ENABLED` or `DISABLED`).
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "max_time_seconds", max_time_seconds)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def action(self) -> str:
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="maxTimeSeconds")
    def max_time_seconds(self) -> int:
        return pulumi.get(self, "max_time_seconds")

    @property
    @pulumi.getter
    def reason(self) -> str:
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Describes the ability of the queue to accept new jobs (for example, `ENABLED` or `DISABLED`).
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetSchedulingPolicyFairSharePolicyResult(dict):
    def __init__(__self__, *,
                 compute_reservation: int,
                 share_decay_seconds: int,
                 share_distributions: Sequence['outputs.GetSchedulingPolicyFairSharePolicyShareDistributionResult']):
        """
        :param int compute_reservation: Value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet been used. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html).
        :param Sequence['GetSchedulingPolicyFairSharePolicyShareDistributionArgs'] share_distributions: One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
        """
        pulumi.set(__self__, "compute_reservation", compute_reservation)
        pulumi.set(__self__, "share_decay_seconds", share_decay_seconds)
        pulumi.set(__self__, "share_distributions", share_distributions)

    @property
    @pulumi.getter(name="computeReservation")
    def compute_reservation(self) -> int:
        """
        Value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet been used. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html).
        """
        return pulumi.get(self, "compute_reservation")

    @property
    @pulumi.getter(name="shareDecaySeconds")
    def share_decay_seconds(self) -> int:
        return pulumi.get(self, "share_decay_seconds")

    @property
    @pulumi.getter(name="shareDistributions")
    def share_distributions(self) -> Sequence['outputs.GetSchedulingPolicyFairSharePolicyShareDistributionResult']:
        """
        One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
        """
        return pulumi.get(self, "share_distributions")


@pulumi.output_type
class GetSchedulingPolicyFairSharePolicyShareDistributionResult(dict):
    def __init__(__self__, *,
                 share_identifier: str,
                 weight_factor: float):
        """
        :param str share_identifier: Fair share identifier or fair share identifier prefix. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        :param float weight_factor: Weight factor for the fair share identifier. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        """
        pulumi.set(__self__, "share_identifier", share_identifier)
        pulumi.set(__self__, "weight_factor", weight_factor)

    @property
    @pulumi.getter(name="shareIdentifier")
    def share_identifier(self) -> str:
        """
        Fair share identifier or fair share identifier prefix. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        """
        return pulumi.get(self, "share_identifier")

    @property
    @pulumi.getter(name="weightFactor")
    def weight_factor(self) -> float:
        """
        Weight factor for the fair share identifier. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        """
        return pulumi.get(self, "weight_factor")


