# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomModelArgs', 'CustomModel']

@pulumi.input_type
class CustomModelArgs:
    def __init__(__self__, *,
                 base_model_identifier: pulumi.Input[str],
                 custom_model_name: pulumi.Input[str],
                 hyperparameters: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 job_name: pulumi.Input[str],
                 role_arn: pulumi.Input[str],
                 custom_model_kms_key_id: Optional[pulumi.Input[str]] = None,
                 customization_type: Optional[pulumi.Input[str]] = None,
                 output_data_config: Optional[pulumi.Input['CustomModelOutputDataConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input['CustomModelTimeoutsArgs']] = None,
                 training_data_config: Optional[pulumi.Input['CustomModelTrainingDataConfigArgs']] = None,
                 validation_data_config: Optional[pulumi.Input['CustomModelValidationDataConfigArgs']] = None,
                 vpc_config: Optional[pulumi.Input['CustomModelVpcConfigArgs']] = None):
        """
        The set of arguments for constructing a CustomModel resource.
        :param pulumi.Input[str] base_model_identifier: The Amazon Resource Name (ARN) of the base model.
        :param pulumi.Input[str] custom_model_name: Name for the custom model.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] hyperparameters: [Parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html) related to tuning the model.
        :param pulumi.Input[str] job_name: A name for the customization job.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of an IAM role that Bedrock can assume to perform tasks on your behalf.
        :param pulumi.Input[str] custom_model_kms_key_id: The custom model is encrypted at rest using this key. Specify the key ARN.
        :param pulumi.Input[str] customization_type: The customization type. Valid values: `FINE_TUNING`, `CONTINUED_PRE_TRAINING`.
        :param pulumi.Input['CustomModelOutputDataConfigArgs'] output_data_config: S3 location for the output data.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the customization job and custom model. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['CustomModelTrainingDataConfigArgs'] training_data_config: Information about the training dataset.
        :param pulumi.Input['CustomModelValidationDataConfigArgs'] validation_data_config: Information about the validation dataset.
        :param pulumi.Input['CustomModelVpcConfigArgs'] vpc_config: Configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are using for this job.
        """
        pulumi.set(__self__, "base_model_identifier", base_model_identifier)
        pulumi.set(__self__, "custom_model_name", custom_model_name)
        pulumi.set(__self__, "hyperparameters", hyperparameters)
        pulumi.set(__self__, "job_name", job_name)
        pulumi.set(__self__, "role_arn", role_arn)
        if custom_model_kms_key_id is not None:
            pulumi.set(__self__, "custom_model_kms_key_id", custom_model_kms_key_id)
        if customization_type is not None:
            pulumi.set(__self__, "customization_type", customization_type)
        if output_data_config is not None:
            pulumi.set(__self__, "output_data_config", output_data_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if training_data_config is not None:
            pulumi.set(__self__, "training_data_config", training_data_config)
        if validation_data_config is not None:
            pulumi.set(__self__, "validation_data_config", validation_data_config)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="baseModelIdentifier")
    def base_model_identifier(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the base model.
        """
        return pulumi.get(self, "base_model_identifier")

    @base_model_identifier.setter
    def base_model_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "base_model_identifier", value)

    @property
    @pulumi.getter(name="customModelName")
    def custom_model_name(self) -> pulumi.Input[str]:
        """
        Name for the custom model.
        """
        return pulumi.get(self, "custom_model_name")

    @custom_model_name.setter
    def custom_model_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "custom_model_name", value)

    @property
    @pulumi.getter
    def hyperparameters(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        [Parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html) related to tuning the model.
        """
        return pulumi.get(self, "hyperparameters")

    @hyperparameters.setter
    def hyperparameters(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "hyperparameters", value)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> pulumi.Input[str]:
        """
        A name for the customization job.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_name", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of an IAM role that Bedrock can assume to perform tasks on your behalf.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="customModelKmsKeyId")
    def custom_model_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The custom model is encrypted at rest using this key. Specify the key ARN.
        """
        return pulumi.get(self, "custom_model_kms_key_id")

    @custom_model_kms_key_id.setter
    def custom_model_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_model_kms_key_id", value)

    @property
    @pulumi.getter(name="customizationType")
    def customization_type(self) -> Optional[pulumi.Input[str]]:
        """
        The customization type. Valid values: `FINE_TUNING`, `CONTINUED_PRE_TRAINING`.
        """
        return pulumi.get(self, "customization_type")

    @customization_type.setter
    def customization_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customization_type", value)

    @property
    @pulumi.getter(name="outputDataConfig")
    def output_data_config(self) -> Optional[pulumi.Input['CustomModelOutputDataConfigArgs']]:
        """
        S3 location for the output data.
        """
        return pulumi.get(self, "output_data_config")

    @output_data_config.setter
    def output_data_config(self, value: Optional[pulumi.Input['CustomModelOutputDataConfigArgs']]):
        pulumi.set(self, "output_data_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the customization job and custom model. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CustomModelTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CustomModelTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="trainingDataConfig")
    def training_data_config(self) -> Optional[pulumi.Input['CustomModelTrainingDataConfigArgs']]:
        """
        Information about the training dataset.
        """
        return pulumi.get(self, "training_data_config")

    @training_data_config.setter
    def training_data_config(self, value: Optional[pulumi.Input['CustomModelTrainingDataConfigArgs']]):
        pulumi.set(self, "training_data_config", value)

    @property
    @pulumi.getter(name="validationDataConfig")
    def validation_data_config(self) -> Optional[pulumi.Input['CustomModelValidationDataConfigArgs']]:
        """
        Information about the validation dataset.
        """
        return pulumi.get(self, "validation_data_config")

    @validation_data_config.setter
    def validation_data_config(self, value: Optional[pulumi.Input['CustomModelValidationDataConfigArgs']]):
        pulumi.set(self, "validation_data_config", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['CustomModelVpcConfigArgs']]:
        """
        Configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are using for this job.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['CustomModelVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


@pulumi.input_type
class _CustomModelState:
    def __init__(__self__, *,
                 base_model_identifier: Optional[pulumi.Input[str]] = None,
                 custom_model_arn: Optional[pulumi.Input[str]] = None,
                 custom_model_kms_key_id: Optional[pulumi.Input[str]] = None,
                 custom_model_name: Optional[pulumi.Input[str]] = None,
                 customization_type: Optional[pulumi.Input[str]] = None,
                 hyperparameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 job_arn: Optional[pulumi.Input[str]] = None,
                 job_name: Optional[pulumi.Input[str]] = None,
                 job_status: Optional[pulumi.Input[str]] = None,
                 output_data_config: Optional[pulumi.Input['CustomModelOutputDataConfigArgs']] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input['CustomModelTimeoutsArgs']] = None,
                 training_data_config: Optional[pulumi.Input['CustomModelTrainingDataConfigArgs']] = None,
                 training_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelTrainingMetricArgs']]]] = None,
                 validation_data_config: Optional[pulumi.Input['CustomModelValidationDataConfigArgs']] = None,
                 validation_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelValidationMetricArgs']]]] = None,
                 vpc_config: Optional[pulumi.Input['CustomModelVpcConfigArgs']] = None):
        """
        Input properties used for looking up and filtering CustomModel resources.
        :param pulumi.Input[str] base_model_identifier: The Amazon Resource Name (ARN) of the base model.
        :param pulumi.Input[str] custom_model_arn: The ARN of the output model.
        :param pulumi.Input[str] custom_model_kms_key_id: The custom model is encrypted at rest using this key. Specify the key ARN.
        :param pulumi.Input[str] custom_model_name: Name for the custom model.
        :param pulumi.Input[str] customization_type: The customization type. Valid values: `FINE_TUNING`, `CONTINUED_PRE_TRAINING`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] hyperparameters: [Parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html) related to tuning the model.
        :param pulumi.Input[str] job_arn: The ARN of the customization job.
        :param pulumi.Input[str] job_name: A name for the customization job.
        :param pulumi.Input[str] job_status: The status of the customization job. A successful job transitions from `InProgress` to `Completed` when the output model is ready to use.
        :param pulumi.Input['CustomModelOutputDataConfigArgs'] output_data_config: S3 location for the output data.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of an IAM role that Bedrock can assume to perform tasks on your behalf.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the customization job and custom model. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['CustomModelTrainingDataConfigArgs'] training_data_config: Information about the training dataset.
        :param pulumi.Input[Sequence[pulumi.Input['CustomModelTrainingMetricArgs']]] training_metrics: Metrics associated with the customization job.
        :param pulumi.Input['CustomModelValidationDataConfigArgs'] validation_data_config: Information about the validation dataset.
        :param pulumi.Input[Sequence[pulumi.Input['CustomModelValidationMetricArgs']]] validation_metrics: The loss metric for each validator that you provided.
        :param pulumi.Input['CustomModelVpcConfigArgs'] vpc_config: Configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are using for this job.
        """
        if base_model_identifier is not None:
            pulumi.set(__self__, "base_model_identifier", base_model_identifier)
        if custom_model_arn is not None:
            pulumi.set(__self__, "custom_model_arn", custom_model_arn)
        if custom_model_kms_key_id is not None:
            pulumi.set(__self__, "custom_model_kms_key_id", custom_model_kms_key_id)
        if custom_model_name is not None:
            pulumi.set(__self__, "custom_model_name", custom_model_name)
        if customization_type is not None:
            pulumi.set(__self__, "customization_type", customization_type)
        if hyperparameters is not None:
            pulumi.set(__self__, "hyperparameters", hyperparameters)
        if job_arn is not None:
            pulumi.set(__self__, "job_arn", job_arn)
        if job_name is not None:
            pulumi.set(__self__, "job_name", job_name)
        if job_status is not None:
            pulumi.set(__self__, "job_status", job_status)
        if output_data_config is not None:
            pulumi.set(__self__, "output_data_config", output_data_config)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            warnings.warn("""Please use `tags` instead.""", DeprecationWarning)
            pulumi.log.warn("""tags_all is deprecated: Please use `tags` instead.""")
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if training_data_config is not None:
            pulumi.set(__self__, "training_data_config", training_data_config)
        if training_metrics is not None:
            pulumi.set(__self__, "training_metrics", training_metrics)
        if validation_data_config is not None:
            pulumi.set(__self__, "validation_data_config", validation_data_config)
        if validation_metrics is not None:
            pulumi.set(__self__, "validation_metrics", validation_metrics)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="baseModelIdentifier")
    def base_model_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the base model.
        """
        return pulumi.get(self, "base_model_identifier")

    @base_model_identifier.setter
    def base_model_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_model_identifier", value)

    @property
    @pulumi.getter(name="customModelArn")
    def custom_model_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the output model.
        """
        return pulumi.get(self, "custom_model_arn")

    @custom_model_arn.setter
    def custom_model_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_model_arn", value)

    @property
    @pulumi.getter(name="customModelKmsKeyId")
    def custom_model_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The custom model is encrypted at rest using this key. Specify the key ARN.
        """
        return pulumi.get(self, "custom_model_kms_key_id")

    @custom_model_kms_key_id.setter
    def custom_model_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_model_kms_key_id", value)

    @property
    @pulumi.getter(name="customModelName")
    def custom_model_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the custom model.
        """
        return pulumi.get(self, "custom_model_name")

    @custom_model_name.setter
    def custom_model_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_model_name", value)

    @property
    @pulumi.getter(name="customizationType")
    def customization_type(self) -> Optional[pulumi.Input[str]]:
        """
        The customization type. Valid values: `FINE_TUNING`, `CONTINUED_PRE_TRAINING`.
        """
        return pulumi.get(self, "customization_type")

    @customization_type.setter
    def customization_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customization_type", value)

    @property
    @pulumi.getter
    def hyperparameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        [Parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html) related to tuning the model.
        """
        return pulumi.get(self, "hyperparameters")

    @hyperparameters.setter
    def hyperparameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "hyperparameters", value)

    @property
    @pulumi.getter(name="jobArn")
    def job_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the customization job.
        """
        return pulumi.get(self, "job_arn")

    @job_arn.setter
    def job_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_arn", value)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the customization job.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_name", value)

    @property
    @pulumi.getter(name="jobStatus")
    def job_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the customization job. A successful job transitions from `InProgress` to `Completed` when the output model is ready to use.
        """
        return pulumi.get(self, "job_status")

    @job_status.setter
    def job_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_status", value)

    @property
    @pulumi.getter(name="outputDataConfig")
    def output_data_config(self) -> Optional[pulumi.Input['CustomModelOutputDataConfigArgs']]:
        """
        S3 location for the output data.
        """
        return pulumi.get(self, "output_data_config")

    @output_data_config.setter
    def output_data_config(self, value: Optional[pulumi.Input['CustomModelOutputDataConfigArgs']]):
        pulumi.set(self, "output_data_config", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of an IAM role that Bedrock can assume to perform tasks on your behalf.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags to assign to the customization job and custom model. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CustomModelTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CustomModelTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="trainingDataConfig")
    def training_data_config(self) -> Optional[pulumi.Input['CustomModelTrainingDataConfigArgs']]:
        """
        Information about the training dataset.
        """
        return pulumi.get(self, "training_data_config")

    @training_data_config.setter
    def training_data_config(self, value: Optional[pulumi.Input['CustomModelTrainingDataConfigArgs']]):
        pulumi.set(self, "training_data_config", value)

    @property
    @pulumi.getter(name="trainingMetrics")
    def training_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelTrainingMetricArgs']]]]:
        """
        Metrics associated with the customization job.
        """
        return pulumi.get(self, "training_metrics")

    @training_metrics.setter
    def training_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelTrainingMetricArgs']]]]):
        pulumi.set(self, "training_metrics", value)

    @property
    @pulumi.getter(name="validationDataConfig")
    def validation_data_config(self) -> Optional[pulumi.Input['CustomModelValidationDataConfigArgs']]:
        """
        Information about the validation dataset.
        """
        return pulumi.get(self, "validation_data_config")

    @validation_data_config.setter
    def validation_data_config(self, value: Optional[pulumi.Input['CustomModelValidationDataConfigArgs']]):
        pulumi.set(self, "validation_data_config", value)

    @property
    @pulumi.getter(name="validationMetrics")
    def validation_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelValidationMetricArgs']]]]:
        """
        The loss metric for each validator that you provided.
        """
        return pulumi.get(self, "validation_metrics")

    @validation_metrics.setter
    def validation_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomModelValidationMetricArgs']]]]):
        pulumi.set(self, "validation_metrics", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['CustomModelVpcConfigArgs']]:
        """
        Configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are using for this job.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['CustomModelVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


class CustomModel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_model_identifier: Optional[pulumi.Input[str]] = None,
                 custom_model_kms_key_id: Optional[pulumi.Input[str]] = None,
                 custom_model_name: Optional[pulumi.Input[str]] = None,
                 customization_type: Optional[pulumi.Input[str]] = None,
                 hyperparameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 job_name: Optional[pulumi.Input[str]] = None,
                 output_data_config: Optional[pulumi.Input[Union['CustomModelOutputDataConfigArgs', 'CustomModelOutputDataConfigArgsDict']]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['CustomModelTimeoutsArgs', 'CustomModelTimeoutsArgsDict']]] = None,
                 training_data_config: Optional[pulumi.Input[Union['CustomModelTrainingDataConfigArgs', 'CustomModelTrainingDataConfigArgsDict']]] = None,
                 validation_data_config: Optional[pulumi.Input[Union['CustomModelValidationDataConfigArgs', 'CustomModelValidationDataConfigArgsDict']]] = None,
                 vpc_config: Optional[pulumi.Input[Union['CustomModelVpcConfigArgs', 'CustomModelVpcConfigArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrockfoundation.get_model(model_id="amazon.titan-text-express-v1")
        example_custom_model = aws.bedrock.CustomModel("example",
            custom_model_name="example-model",
            job_name="example-job-1",
            base_model_identifier=example.model_arn,
            role_arn=example_aws_iam_role["arn"],
            hyperparameters={
                "epochCount": "1",
                "batchSize": "1",
                "learningRate": "0.005",
                "learningRateWarmupSteps": "0",
            },
            output_data_config={
                "s3_uri": f"s3://{output['id']}/data/",
            },
            training_data_config={
                "s3_uri": f"s3://{training['id']}/data/train.jsonl",
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock custom model using the `job_arn`. For example:

        ```sh
        $ pulumi import aws:bedrock/customModel:CustomModel example arn:aws:bedrock:us-west-2:123456789012:model-customization-job/amazon.titan-text-express-v1:0:8k/1y5n57gh5y2e
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] base_model_identifier: The Amazon Resource Name (ARN) of the base model.
        :param pulumi.Input[str] custom_model_kms_key_id: The custom model is encrypted at rest using this key. Specify the key ARN.
        :param pulumi.Input[str] custom_model_name: Name for the custom model.
        :param pulumi.Input[str] customization_type: The customization type. Valid values: `FINE_TUNING`, `CONTINUED_PRE_TRAINING`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] hyperparameters: [Parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html) related to tuning the model.
        :param pulumi.Input[str] job_name: A name for the customization job.
        :param pulumi.Input[Union['CustomModelOutputDataConfigArgs', 'CustomModelOutputDataConfigArgsDict']] output_data_config: S3 location for the output data.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of an IAM role that Bedrock can assume to perform tasks on your behalf.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the customization job and custom model. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['CustomModelTrainingDataConfigArgs', 'CustomModelTrainingDataConfigArgsDict']] training_data_config: Information about the training dataset.
        :param pulumi.Input[Union['CustomModelValidationDataConfigArgs', 'CustomModelValidationDataConfigArgsDict']] validation_data_config: Information about the validation dataset.
        :param pulumi.Input[Union['CustomModelVpcConfigArgs', 'CustomModelVpcConfigArgsDict']] vpc_config: Configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are using for this job.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomModelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrockfoundation.get_model(model_id="amazon.titan-text-express-v1")
        example_custom_model = aws.bedrock.CustomModel("example",
            custom_model_name="example-model",
            job_name="example-job-1",
            base_model_identifier=example.model_arn,
            role_arn=example_aws_iam_role["arn"],
            hyperparameters={
                "epochCount": "1",
                "batchSize": "1",
                "learningRate": "0.005",
                "learningRateWarmupSteps": "0",
            },
            output_data_config={
                "s3_uri": f"s3://{output['id']}/data/",
            },
            training_data_config={
                "s3_uri": f"s3://{training['id']}/data/train.jsonl",
            })
        ```

        ## Import

        Using `pulumi import`, import Bedrock custom model using the `job_arn`. For example:

        ```sh
        $ pulumi import aws:bedrock/customModel:CustomModel example arn:aws:bedrock:us-west-2:123456789012:model-customization-job/amazon.titan-text-express-v1:0:8k/1y5n57gh5y2e
        ```

        :param str resource_name: The name of the resource.
        :param CustomModelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomModelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_model_identifier: Optional[pulumi.Input[str]] = None,
                 custom_model_kms_key_id: Optional[pulumi.Input[str]] = None,
                 custom_model_name: Optional[pulumi.Input[str]] = None,
                 customization_type: Optional[pulumi.Input[str]] = None,
                 hyperparameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 job_name: Optional[pulumi.Input[str]] = None,
                 output_data_config: Optional[pulumi.Input[Union['CustomModelOutputDataConfigArgs', 'CustomModelOutputDataConfigArgsDict']]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['CustomModelTimeoutsArgs', 'CustomModelTimeoutsArgsDict']]] = None,
                 training_data_config: Optional[pulumi.Input[Union['CustomModelTrainingDataConfigArgs', 'CustomModelTrainingDataConfigArgsDict']]] = None,
                 validation_data_config: Optional[pulumi.Input[Union['CustomModelValidationDataConfigArgs', 'CustomModelValidationDataConfigArgsDict']]] = None,
                 vpc_config: Optional[pulumi.Input[Union['CustomModelVpcConfigArgs', 'CustomModelVpcConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomModelArgs.__new__(CustomModelArgs)

            if base_model_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'base_model_identifier'")
            __props__.__dict__["base_model_identifier"] = base_model_identifier
            __props__.__dict__["custom_model_kms_key_id"] = custom_model_kms_key_id
            if custom_model_name is None and not opts.urn:
                raise TypeError("Missing required property 'custom_model_name'")
            __props__.__dict__["custom_model_name"] = custom_model_name
            __props__.__dict__["customization_type"] = customization_type
            if hyperparameters is None and not opts.urn:
                raise TypeError("Missing required property 'hyperparameters'")
            __props__.__dict__["hyperparameters"] = hyperparameters
            if job_name is None and not opts.urn:
                raise TypeError("Missing required property 'job_name'")
            __props__.__dict__["job_name"] = job_name
            __props__.__dict__["output_data_config"] = output_data_config
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["training_data_config"] = training_data_config
            __props__.__dict__["validation_data_config"] = validation_data_config
            __props__.__dict__["vpc_config"] = vpc_config
            __props__.__dict__["custom_model_arn"] = None
            __props__.__dict__["job_arn"] = None
            __props__.__dict__["job_status"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["training_metrics"] = None
            __props__.__dict__["validation_metrics"] = None
        super(CustomModel, __self__).__init__(
            'aws:bedrock/customModel:CustomModel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            base_model_identifier: Optional[pulumi.Input[str]] = None,
            custom_model_arn: Optional[pulumi.Input[str]] = None,
            custom_model_kms_key_id: Optional[pulumi.Input[str]] = None,
            custom_model_name: Optional[pulumi.Input[str]] = None,
            customization_type: Optional[pulumi.Input[str]] = None,
            hyperparameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            job_arn: Optional[pulumi.Input[str]] = None,
            job_name: Optional[pulumi.Input[str]] = None,
            job_status: Optional[pulumi.Input[str]] = None,
            output_data_config: Optional[pulumi.Input[Union['CustomModelOutputDataConfigArgs', 'CustomModelOutputDataConfigArgsDict']]] = None,
            role_arn: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['CustomModelTimeoutsArgs', 'CustomModelTimeoutsArgsDict']]] = None,
            training_data_config: Optional[pulumi.Input[Union['CustomModelTrainingDataConfigArgs', 'CustomModelTrainingDataConfigArgsDict']]] = None,
            training_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomModelTrainingMetricArgs', 'CustomModelTrainingMetricArgsDict']]]]] = None,
            validation_data_config: Optional[pulumi.Input[Union['CustomModelValidationDataConfigArgs', 'CustomModelValidationDataConfigArgsDict']]] = None,
            validation_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomModelValidationMetricArgs', 'CustomModelValidationMetricArgsDict']]]]] = None,
            vpc_config: Optional[pulumi.Input[Union['CustomModelVpcConfigArgs', 'CustomModelVpcConfigArgsDict']]] = None) -> 'CustomModel':
        """
        Get an existing CustomModel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] base_model_identifier: The Amazon Resource Name (ARN) of the base model.
        :param pulumi.Input[str] custom_model_arn: The ARN of the output model.
        :param pulumi.Input[str] custom_model_kms_key_id: The custom model is encrypted at rest using this key. Specify the key ARN.
        :param pulumi.Input[str] custom_model_name: Name for the custom model.
        :param pulumi.Input[str] customization_type: The customization type. Valid values: `FINE_TUNING`, `CONTINUED_PRE_TRAINING`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] hyperparameters: [Parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html) related to tuning the model.
        :param pulumi.Input[str] job_arn: The ARN of the customization job.
        :param pulumi.Input[str] job_name: A name for the customization job.
        :param pulumi.Input[str] job_status: The status of the customization job. A successful job transitions from `InProgress` to `Completed` when the output model is ready to use.
        :param pulumi.Input[Union['CustomModelOutputDataConfigArgs', 'CustomModelOutputDataConfigArgsDict']] output_data_config: S3 location for the output data.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of an IAM role that Bedrock can assume to perform tasks on your behalf.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags to assign to the customization job and custom model. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union['CustomModelTrainingDataConfigArgs', 'CustomModelTrainingDataConfigArgsDict']] training_data_config: Information about the training dataset.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomModelTrainingMetricArgs', 'CustomModelTrainingMetricArgsDict']]]] training_metrics: Metrics associated with the customization job.
        :param pulumi.Input[Union['CustomModelValidationDataConfigArgs', 'CustomModelValidationDataConfigArgsDict']] validation_data_config: Information about the validation dataset.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomModelValidationMetricArgs', 'CustomModelValidationMetricArgsDict']]]] validation_metrics: The loss metric for each validator that you provided.
        :param pulumi.Input[Union['CustomModelVpcConfigArgs', 'CustomModelVpcConfigArgsDict']] vpc_config: Configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are using for this job.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomModelState.__new__(_CustomModelState)

        __props__.__dict__["base_model_identifier"] = base_model_identifier
        __props__.__dict__["custom_model_arn"] = custom_model_arn
        __props__.__dict__["custom_model_kms_key_id"] = custom_model_kms_key_id
        __props__.__dict__["custom_model_name"] = custom_model_name
        __props__.__dict__["customization_type"] = customization_type
        __props__.__dict__["hyperparameters"] = hyperparameters
        __props__.__dict__["job_arn"] = job_arn
        __props__.__dict__["job_name"] = job_name
        __props__.__dict__["job_status"] = job_status
        __props__.__dict__["output_data_config"] = output_data_config
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["training_data_config"] = training_data_config
        __props__.__dict__["training_metrics"] = training_metrics
        __props__.__dict__["validation_data_config"] = validation_data_config
        __props__.__dict__["validation_metrics"] = validation_metrics
        __props__.__dict__["vpc_config"] = vpc_config
        return CustomModel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="baseModelIdentifier")
    def base_model_identifier(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the base model.
        """
        return pulumi.get(self, "base_model_identifier")

    @property
    @pulumi.getter(name="customModelArn")
    def custom_model_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the output model.
        """
        return pulumi.get(self, "custom_model_arn")

    @property
    @pulumi.getter(name="customModelKmsKeyId")
    def custom_model_kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The custom model is encrypted at rest using this key. Specify the key ARN.
        """
        return pulumi.get(self, "custom_model_kms_key_id")

    @property
    @pulumi.getter(name="customModelName")
    def custom_model_name(self) -> pulumi.Output[str]:
        """
        Name for the custom model.
        """
        return pulumi.get(self, "custom_model_name")

    @property
    @pulumi.getter(name="customizationType")
    def customization_type(self) -> pulumi.Output[str]:
        """
        The customization type. Valid values: `FINE_TUNING`, `CONTINUED_PRE_TRAINING`.
        """
        return pulumi.get(self, "customization_type")

    @property
    @pulumi.getter
    def hyperparameters(self) -> pulumi.Output[Mapping[str, str]]:
        """
        [Parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html) related to tuning the model.
        """
        return pulumi.get(self, "hyperparameters")

    @property
    @pulumi.getter(name="jobArn")
    def job_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the customization job.
        """
        return pulumi.get(self, "job_arn")

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> pulumi.Output[str]:
        """
        A name for the customization job.
        """
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter(name="jobStatus")
    def job_status(self) -> pulumi.Output[str]:
        """
        The status of the customization job. A successful job transitions from `InProgress` to `Completed` when the output model is ready to use.
        """
        return pulumi.get(self, "job_status")

    @property
    @pulumi.getter(name="outputDataConfig")
    def output_data_config(self) -> pulumi.Output[Optional['outputs.CustomModelOutputDataConfig']]:
        """
        S3 location for the output data.
        """
        return pulumi.get(self, "output_data_config")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of an IAM role that Bedrock can assume to perform tasks on your behalf.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A map of tags to assign to the customization job and custom model. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    @_utilities.deprecated("""Please use `tags` instead.""")
    def tags_all(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.CustomModelTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="trainingDataConfig")
    def training_data_config(self) -> pulumi.Output[Optional['outputs.CustomModelTrainingDataConfig']]:
        """
        Information about the training dataset.
        """
        return pulumi.get(self, "training_data_config")

    @property
    @pulumi.getter(name="trainingMetrics")
    def training_metrics(self) -> pulumi.Output[Sequence['outputs.CustomModelTrainingMetric']]:
        """
        Metrics associated with the customization job.
        """
        return pulumi.get(self, "training_metrics")

    @property
    @pulumi.getter(name="validationDataConfig")
    def validation_data_config(self) -> pulumi.Output[Optional['outputs.CustomModelValidationDataConfig']]:
        """
        Information about the validation dataset.
        """
        return pulumi.get(self, "validation_data_config")

    @property
    @pulumi.getter(name="validationMetrics")
    def validation_metrics(self) -> pulumi.Output[Sequence['outputs.CustomModelValidationMetric']]:
        """
        The loss metric for each validator that you provided.
        """
        return pulumi.get(self, "validation_metrics")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Output[Optional['outputs.CustomModelVpcConfig']]:
        """
        Configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are using for this job.
        """
        return pulumi.get(self, "vpc_config")

